/* Definitions of IRC message functions and list of messages.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

unsigned long serv_com = 0;
unsigned long day_serv_com = 0;
unsigned long hour_serv_com = 0;
unsigned long min_serv_com = 0;

unsigned long nsreg=0, csreg=0;
unsigned long nsid=0, csid=0;
unsigned long nsidf=0, csidf=0;
unsigned long ghost=0, news=0;
unsigned long nsset=0, csset=0;
unsigned long nsdrop=0, csdrop=0;
unsigned long nsgp=0, csgp=0, csremove;
unsigned long csop=0, csbot=0;

/* List of messages is at the bottom of the file. */

/*************************************************************************/
static void m_nickcoll(char *source, int ac, char **av)
{
    do_quit(source, ac, av);
}
/*************************************************************************/
static void m_user(char *source, int ac, char **av)
{
    send_cmd (server_name, "446 %s :USERS has been disabled", source);
}
/*************************************************************************/
#ifdef UNREAL
static void m_umode2(char *source, int ac, char **av)
{
        av[1] = sstrdup (av[0]);
        strcpy (av[0], source);
        do_umode (source, ac, av);
	if (av[1]) free(av[1]);
}
#endif
/*************************************************************************/
#ifdef UNREAL
/* av[1] ST
   av[2] PROTO
   av[3] CLOAK KEY?
   av[8] Network name
*/
static void m_netinfo(char *source, int ac, char **av)
{
    if (ac < 1)
        return;
    if (atoi (av[0]) > maxusercnt)
        maxusercnt = atoi (av[0]);
#ifdef UNREAL32
    if (av[3]) {
	if (CLOAK_KEY) free(CLOAK_KEY);
	CLOAK_KEY = sstrdup(av[3]);
    }
    send_cmd (server_name, "%s %d %lu 2303 %s * * * :%s", 
		istoken?TOK_NETINFO:MSG_NETINFO,
                maxusercnt, time(NULL), CLOAK_KEY, av[7]);
#else
    send_cmd (server_name, "%s %d %lu 2302 * * * * :%s",
		istoken?TOK_NETINFO:MSG_NETINFO,
                maxusercnt, time(NULL), av[7]);
#endif
}
#endif
/*************************************************************************/
static void m_time(char *source, int ac, char **av)
{
        time_t t;
        struct tm *tm1;
        char buf[80];

        time(&t);
        tm1 = localtime(&t);
        strftime(buf, sizeof(buf), "%A %B %d %Y -- %H:%M %Z", tm1);

        send_cmd (server_name, "391 %s %s :%s", source, server_name, buf);

}
/*************************************************************************/
static void m_stats(char *source, int ac, char **av)
{
    time_t uptime = CTime - start_time;
    long count, count2, mem, mem2;

    if (ac != 2)
        return;

     switch(*av[0]) {

      case 'u':
      case 'U':
      if (uptime > 86400)
        send_cmd (server_name, "242 %s :Services up %d day%s, %d:%02d:%02d",
                   source, uptime/86400, (uptime/86400 == 1) ? "" : "s",
                   (uptime/3600)%24, (uptime/60)%60, uptime%60);
      else if (uptime > 3600)
          send_cmd(server_name, "372 %s :"
                        "Services up %d hour%s, %d minute%s", source,
                        uptime/3600, uptime/3600==1 ? "" : "s",
                        (uptime/60) % 60, (uptime/60)%60==1 ? "" : "s");
      else
          send_cmd(server_name, "372 %s :"
                        "Services up %d minute%s, %d second%s", source,
                        uptime/60, uptime/60==1 ? "" : "s",
                        uptime%60, uptime%60==1 ? "" : "s");


        send_cmd(NULL, "250 %s :Current users: %d (%d ops); maximum %d",
                source, usercnt, opcnt, maxusercnt);

	send_cmd(NULL, "NOTICE %s :Connects in total: %li", source, connectscnt);
	send_cmd (server_name, "219 %s %s :End of /STATS report", source, av[0]);
        break;

    case 'S':
    case 's':
          send_cmd(server_name, "372 %s :%s", source, server_name);
          break;
    case 'M':
    case 'm':
	  if (!is_services_helpop(source))
             return;
          send_cmd(server_name, "372 %s :%d minute", source, min_serv_com);
          send_cmd(server_name, "372 %s :%d hour", source, hour_serv_com);
          send_cmd(server_name, "372 %s :%d day", source, day_serv_com);
          send_cmd(server_name, "372 %s :%d commands", source, serv_com);
          send_cmd(server_name, "372 %s :%d/%d nsreg/csreg",
                   source, nsreg, csreg);
          send_cmd(server_name, "372 %s :%d/%d nsid/fails",
                   source, nsid, nsidf);
          send_cmd(server_name, "372 %s :%d/%d csid/fails",
                   source, csid, csidf);
          send_cmd(server_name, "372 %s :%d/%d ns/cs set",
                   source, nsset, csset);
          send_cmd(server_name, "372 %s :%d/%d ns/cs drops",
                   source, nsdrop, csdrop);
          send_cmd(server_name, "372 %s :%d/%d ns/cs getpass",
                   source, nsgp, csgp);
          send_cmd(server_name, "372 %s :%d/%d op/remove",
                   source, csop, csremove);
          send_cmd(server_name, "372 %s :%d ghosts",
                   source, ghost);
          send_cmd(server_name, "372 %s :%d news",
                   source, news);
          send_cmd(server_name, "372 %s :%d Set Bot",
                   source, csbot);
          break;
     case 'R':
     case 'r':
	  if (!is_services_helpop(source))
             return;
         get_nickserv_stats(&count, &mem);
         get_chanserv_stats(&count2, &mem2);
         send_cmd(server_name, "372 %s :%d/%d nicks/chans",
              source, count, count2);
         send_cmd(server_name, "372 %s :%d/%d kb",
              source, mem, mem2);
         break;
     } 
}
/*************************************************************************/
void do_infoservices(const char *source, const char *nick)
{
     notice(s_NickServ, source,
               "(\2Currently on IRC\2) - \"/whois %s\" for more information", nick);
     notice(s_NickServ, source,
                "\2%s\2 is \"Services Bot\"\n", nick);
}
/*************************************************************************/
static void m_setname(char *source, int ac, char **av)
{
        User *u;
        NickInfo *ni, *hni;

        /* First, update the user structure. */
        u = finduser (source);
	if (!u)
		return;

	if (u)  {
	   if (u->username)
		free (u->username);
	   u->realname = sstrdup(av[0]);
	}

        /* Now, update the nickinfo. */
        ni = findnick (u->nick);
        hni = nickhost(ni);
        if (hni && (hni->flags & NI_IDENTIFIED)) {
		free(hni->last_realname);
		hni->last_realname = sstrdup(av[0]);
	}
}
/*************************************************************************/
static void m_userhost(char *source, int ac, char **av)
{
        User *u;
	char *nick = strtok(av[1],"=");
	char *virthost;
	if (!nick)
		return;
	if (strchr(nick, '*')) {
		virthost = strtok(NULL,"@");
		virthost = strtok(NULL," ");
		nick = strtok(nick, "*");
	} else {
		virthost = strtok(NULL,"@");
		virthost = strtok(NULL," ");
	}

	if (!virthost)
		return;

        u = finduser (nick);

	if (!u)
		return;

	if (u && virthost)  {
		if (u->host)
			free(u->host);
	        u->host = sstrdup(virthost);
	}
}
/*************************************************************************/
static void m_sethost(char *source, int ac, char **av)
{
        User *u;
        NickInfo *ni, *hni;

        /* First, update the user structure. */
        u = finduser (source);
	if (!u)
		return;
	if (u) {
		if (u->host)
			free(u->host);
	        u->host = sstrdup(av[0]);
	}
        /* Now, update the nickinfo. */
        ni = findnick (u->nick);
	hni = nickhost(ni);
        if (hni && (hni->flags & NI_IDENTIFIED)) {
	    if (hni->last_usermask)
		    free(hni->last_usermask);
            hni->last_usermask = smalloc(strlen(u->username)+strlen(u->host)+2);
 	    snprintf (hni->last_usermask,strlen(u->username)+strlen(u->host)+2,"%s@%s", u->username, u->host);
	}
}
/*************************************************************************/
static void m_setident(char *source, int ac, char **av)
{
        User *u;
        NickInfo *ni, *hni;

        /* First, update the user structure. */
        u = finduser (source);
	if (!u)
		return;
	if (u) {
		if (u->username)
			free (u->username);
	        u->username = sstrdup(av[0]);
	}

        /* Now, update the nickinfo. */
        ni = findnick (u->nick);
	hni = nickhost(ni);
        if (hni && (hni->flags & NI_IDENTIFIED)) {
	    if (hni->last_usermask)
	    	free(hni->last_usermask);
            hni->last_usermask = smalloc(strlen(u->username)+strlen(u->host)+2);
 	    snprintf (hni->last_usermask,strlen(u->username)+strlen(u->host)+2,"%s@%s", u->username, u->host);
	}
}
/*************************************************************************/
static void m_server(char *source, int ac, char **av)
{
    if (ac < 1)
        return;
    numserver++;
    check_jupes();
    check_zlines();
}

/*************************************************************************/
static void m_squit(char *source, int ac, char **av)
{

    if (ac < 1)
	return;
    check_jupe_squit(source, av[0]);
    if (numserver == 0) /* Posible Crashed in here or not? */
	numserver = 1;
    numserver--;
}
/*************************************************************************/
static void m_ping(char *source, int ac, char **av)
{
    if (ac < 1)
	return;
    send_cmd(server_name, "PONG %s %s", ac>1 ? av[1] : server_name, av[0]);
}

/*************************************************************************/
static void m_away(char *source, int ac, char **av)
{
    if (ac == 0 || *av[0] == 0)		/* un-away */
	check_memos(source);
}

/*************************************************************************/
static void m_join(char *source, int ac, char **av)
{
#ifndef CR
    if (ac != 1)
	return;
#endif
    do_join(source, ac, av);
}

/*************************************************************************/
#ifdef SJOIN
static void m_sjoin(char *source, int ac, char **av)
{
   do_sjoin(source, ac, av);
}
#endif
/*************************************************************************/
static void m_kick(char *source, int ac, char **av)
{
    if (ac != 3)
	return;
    if (is_servbot(av[1])) {
	send_cmd(av[1], "JOIN %s", av[0]);
	send_cmd(s_ChanServ, "MODE %s +o %s", av[0], av[1]);
#if defined(UNREAL)
	send_cmd(s_ChanServ, "MODE %s +a %s", av[0], av[1]);
#elif defined(RAGEIRCD) || defined(LIQUID)
	send_cmd(s_ChanServ, "MODE %s +u %s", av[0], av[1]);
#endif
    }
    do_kick(source, ac, av);
}

/*************************************************************************/
static void m_kill(char *source, int ac, char **av)
{
    if (ac != 2)
	return;
    do_kill(source, ac, av);
}

/*************************************************************************/
static void m_mode(char *source, int ac, char **av)
{
    char *modestr = av[1];
    char *s, *nick;
    int add = 0, i, x=0, x2=0, isoper;
#ifdef DEFHALFOP
    int yx=0;
#endif
    User *u;

    if (*av[0] == '#' || *av[0] == '&') {
        char newmodes[128];
        char *rlist[13], *rrlist[13];
        char c, *mchange = newmodes;
        char **bv = av, *nv[8], *ov[8], *reop[8];
#ifdef DEFHALFOP
	char *ovh[8], *rhlist[13];
        int ohstart = 2;
#endif
        int bc = ac, start = 2, ostart = 2, rstart = 2;
	int vmode = 0;

        for (i=2; i < 8; i++) {
           ov[i] = NULL;
#ifdef DEFHALFOP
           ovh[i] = NULL;
#endif
           reop[i] = NULL;
        }

	if (ac < 2)
	    return;

        s = modestr;
        bc -= 2;
        bv += 2;

        while (*s) {
            int repeat = 0;
            char *mv[3];
            switch(c = *s++) {
               case '+':
                  if (*mchange-1 != '+')
                     *mchange++ = '+';
                  add = 1;
                  break;
               case '-':
                  if (*mchange-1 != '-')
                     *mchange++ = '-';
                  add = 0;
                  break;

               case 'b':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+b";
                 else
                    mv[1] = "-b";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %cb",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;

                 do_cmode(source, 3, mv);
                 break;

               case 'e':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+e";
                 else
                    mv[1] = "-e";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %ce",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;

                 do_cmode(source, 3, mv);
                 break;

               case 'L':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+L";
                 else
                    mv[1] = "-L";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %cL",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;

                 do_cmode(source, 3, mv);
                 break;

               case 'f':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+f";
                 else
                    mv[1] = "-f";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %cf",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;

                 do_cmode(source, 3, mv);
                 break;

               case 'v':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+v";
                 else
                    mv[1] = "-v";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %cv",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;
                 do_cmode(source, 3, mv);
                 break;
#ifdef DEFHALFOP
               case 'h':
                 mv[0] = av[0];
                 mv[1] = "+h";
                 repeat = 0;
                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %ch",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 nick = *bv++;
                 for (i=0; i < yx; i++) {
                    if (rhlist[i] && stricmp(rhlist[i], nick) == 0)
       	                repeat++;
                 }
                 rhlist[yx++] = nick;
                 mv[2] = nick;
                 if (add) {
                     u = finduser(nick);
                     if (!u)
                        break;
	             if (!check_valid_hop(u, av[0], 0) &&
			stricmp(source, u->nick) && !repeat) {
                        ovh[ohstart++] = nick;
                        do_cmode(source, 3, mv);
                        break;
                     } else {
                       if (!repeat)
                          do_cmode(source, 3, mv);
		     }
                 } else {
                     mv[1] = "-h";
                     u = finduser(nick);
                     if (!u)
                        break;
                     do_cmode(source, 3, mv);
                 }
                 break;
#endif
               case 'q':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+q";
                 else
                    mv[1] = "-q";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %cq",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;
                 do_cmode(source, 3, mv);
                 break;

               case 'a':
                 mv[0] = av[0];
                 if (add)
                    mv[1] = "+a";
                 else
                    mv[1] = "-a";

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %ca",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }
                 mv[2] = *bv++;
                 do_cmode(source, 3, mv);
                 break;

               case 'o':
                 mv[0] = av[0];
                 mv[1] = "+o";
                 repeat = 0;

                 if (--bc < 0) {
                   log("channel: MODE %s %s: missing parameter for %co",
                                     av[0], modestr, add ? '+' : '-');
                   break;
                 }

                 nick = *bv++;

                 for (i=0; i < x; i++) {
                    if (rlist[i] && !stricmp(rlist[i], nick))
       	                repeat++;
                 }

                 rlist[x++] = nick;

                 mv[2] = nick;

                 if (add) {
		    int isvalids = 1;
                    u = finduser(nick);

                    if (!u)
                        break;

		    isoper = 0;

		    if (is_oper(u->nick))
			isoper = 1;

		    if (!check_valid_op(u, av[0], 0))
			isvalids = 0;

	            if (!isvalids && stricmp(source, u->nick) && !repeat) {

				if (isoper == 1) {
					User *u2;

					u2 = finduser(source);
					if (u2)
						notice (s_ChanServ, source,"%s is an ircop and can hold ops in %s even when OpGuard is enabled.", nick, av[0]);

		                        do_cmode(source, 3, mv);
					break;

				} else {
	  			        ov[ostart++] = nick;
	                        	break;
				}
                   } else {
                       if (!repeat)
                          do_cmode(source, 3, mv);
		   }
                 } else {
                     ChannelInfo *ci;
                     int ulev = 0;
                     mv[1] = "-o";

                     ci = cs_findchan(av[0]);
                     u = finduser(nick);

                     if (!u)
                        break;

                 if (ci && (ci->botflag & CBI_PROTECT)) {
		     User *u2;
                     for (i=0; i < x2; i++) {
                        if (rrlist[i] && stricmp(rrlist[i], nick) == 0)
                           repeat++;
                     }
                     rrlist[x2++] = nick;

                     ulev = get_access(u, ci);
		     u2 = finduser(source);
                     if (u2 && ci && ulev >= get_access(u2, ci)) {
                        if (ci && (ulev > 3) && !repeat
                               && (stricmp(source, nick) != 0) && is_chanop(nick, av[0]))
                           reop[rstart++] = nick;
                        else
	                        do_cmode(source, 3, mv);
		     }
                     } else
                         do_cmode(source, 3, mv);
                 }
                 break;

              default:

                   *mchange++ = c;
                   if (c == 'l' && add)
                      nv[start++] = *bv++;
                   else if (c == 'k')
                      nv[start++] = *bv++;
                   else vmode = 1;
                   break;

            } /* Switch */
       } /* While */

       if (start > 2 || vmode) {
           nv[0] = av[0];
	   nv[1] = newmodes;
           do_cmode(source, start-1, nv);
       }

       if (ov[2])
          send_cmd(s_ChanServ, "MODE %s -%s%s%s%s%s%s %s %s %s %s %s %s",
                 av[0], "o", ov[3] ? "o" : "",
                 ov[4] ? "o" : "", ov[5] ? "o" : "",
                 ov[6] ? "o" : "", ov[7] ? "o" : "",
                 ov[2], ov[3] ? ov[3] : "",
                 ov[4] ? ov[4] : "", ov[5] ? ov[5] : "",
                 ov[6] ? ov[6] : "", ov[7] ? ov[7] : "");

       if (reop[2])
          send_cmd(s_ChanServ, "MODE %s +%s%s%s%s%s%s %s %s %s %s %s %s",
                 av[0], "o", reop[3] ? "o" : "",
                 reop[4] ? "o" : "", reop[5] ? "o" : "",
                 reop[6] ? "o" : "", reop[7] ? "o" : "",
                 reop[2], reop[3] ? reop[3] : "",
                 reop[4] ? reop[4] : "", reop[5] ? reop[5] : "",
                 reop[6] ? reop[6] : "", reop[7] ? reop[7] : "");

#ifdef DEFHALFOP
       if (ovh[2])
          send_cmd(s_ChanServ, "MODE %s -%s%s%s%s%s%s %s %s %s %s %s %s",
                 av[0], "h", ovh[3] ? "h" : "",
                 ovh[4] ? "h" : "", ovh[5] ? "h" : "",
                 ovh[6] ? "h" : "", ovh[7] ? "h" : "",
                 ovh[2], ovh[3] ? ovh[3] : "",
                 ovh[4] ? ovh[4] : "", ovh[5] ? ovh[5] : "",
                 ovh[6] ? ovh[6] : "", ovh[7] ? ovh[7] : "");
#endif

    } else {
	if (ac != 2)
	    return;
	do_umode(source, ac, av);
    }
}

/*************************************************************************/
static void m_motd(char *source, int ac, char **av)
{
    FILE *f;
    char buf[BUFSIZE];
    int i;
    time_t uptime = CTime - start_time;
    User *u = finduser(source);

    if (u && is_tokn(19))
        do_update_flood(u, 2);

    f = fopen(MOTD_FILENAME, "r");
    send_cmd(server_name, "375 %s :***** \2\37Services Message of the Day\37\2 *****",
		source);
   if (f) {
	while (fgets(buf, sizeof(buf), f)) {
	    buf[strlen(buf)-1] = 0;
	    send_cmd(server_name, "372 %s :- %s", source, buf);
	}
	fclose(f);
    }
    *buf = 0;
    sendmotd(source);
    send_cmd(server_name, "372 %s :-", source);

    if (MOTD_UPDATE && !readonly) {
       i = (UPDATE_TIMEOUT - (CTime - last_update));
       send_cmd(server_name, "372 %s :- Next DataBase Update: %d Minute%s, %d second%s",
           source, i/60, i==1 ? "" : "s",
           i%60, i==1 ? "" : "s");
       i=0;
    }

    if (MOTD_UPTIME) {
      if (uptime > 86400)
          send_cmd(server_name, "372 %s :- "
                        "Services up \2%d\2 day%s, \2%02d:%02d\2", source,
                        uptime/86400, (uptime/86400 == 1) ? "" : "s",
                        (uptime/3600) % 24, (uptime/60) % 60);
      else if (uptime > 3600)
          send_cmd(server_name, "372 %s :- "
                        "Services up \2%d hour%s, %d minute%s\2", source,
                        uptime/3600, uptime/3600==1 ? "" : "s",
                        (uptime/60) % 60, (uptime/60)%60==1 ? "" : "s");
      else
          send_cmd(server_name, "372 %s :- "
                        "Services up \2%d minute%s, %d second%s\2", source,
                        uptime/60, uptime/60==1 ? "" : "s",
                        uptime%60, uptime%60==1 ? "" : "s");
    }

    send_cmd(server_name, "372 %s :-", source);
    send_cmd(server_name, "372 %s :- /Msg %s Credits", source, s_HelpServ);
    send_cmd(server_name, "372 %s :-", source);
    send_cmd(server_name, "372 %s :- Auspice Services are copyright (c) "
                "2000-2001 In Mean.", source);
    send_cmd(server_name, "376 %s :***** End of /MOTD command *****", source);
}
/*************************************************************************/
static void m_nick(char *source, int ac, char **av)
{
#if !defined(BAHAMUT) && !defined(NICKV2)
    if (ac == 8) {
	/* Get rid of the useless extra parameter. */
	av[6] = av[7];
	ac--;
    }

    if ((!*source && ac != 7) || (*source && ac != 2))
	return;
#endif
    do_nick(source, ac, av);
}
/*************************************************************************/
/*************************************************************************/
static void m_part(char *source, int ac, char **av)
{
    if (ac < 1 || ac > 2)
	return;
    do_part(source, ac, av);
}
/*************************************************************************/
#ifdef UNREAL
static void m_swhois(char *source, int ac, char **av)
{
	send_cmd(NULL, "SWHOIS %s :", av[0]);
}
#endif
/*************************************************************************/
static void m_privmsg(char *source, int ac, char **av)
{
    time_t starttime;	/* When processing started and finished */
    time_t now = CTime;
    char *nick;
    User *u;

    if (ac != 2 || !source || !av[0])
	return;

    else if (!(u = finduser(source)))
        return;

    if(strchr(av[0], '@')) {
	nick = strtok(av[0], "@");
	av[0] = nick;
    }

    if (is_tokn(19) && !(*av[0] == '#')) {
        if (do_update_flood(u, 0) == 1)
            return;
    }


    /* Check if we should ignore.  Operators always get through. */
    if (is_tokn(19) && !is_oper(source) && !(*av[0] == '#')) {
         if (check_ignore(u->nick, u->username, u->realhost) != 0)
              return;
    }

    if (u && (u->flags & U_NOSERV)) {
	log("Access denied to services from %s", source);
	return;
    }

    if ((debug == 1) && ((stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_RootServ) == 0)
       || (stricmp(av[0], s_NickServ) == 0)
       || (stricmp(av[0], s_MemoServ) == 0)
       || (stricmp(av[0], s_ChanServ) == 0)
       || (stricmp(av[0], s_HelpServ) == 0)
       || (stricmp(av[0], s_Agent) == 0)
#ifndef NONSUPER
       || (stricmp(av[0], s_ServicesX) == 0)
       || (stricmp(av[0], s_ServicesW) == 0)
       || (stricmp(av[0], s_MassServ) == 0)
#endif
       || (stricmp(av[0], s_SpamChecker) == 0)
       || (stricmp(av[0], s_AdminServ) == 0)
#ifdef WEBSERVICE
       || (stricmp(av[0], s_WebServ) == 0)
#endif
#ifdef DEFHOSTSERV
       || (stricmp(av[0], s_HostServ) == 0)
#endif
       || (stricmp(av[0], s_BotServ) == 0))
       && (!stricmp(av[1], "*identify*") ==0))
            log("%s: %s", source, inbuf);

    if ((sndebug == 1) && ((stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_OperServ) == 0)
       || (stricmp(av[0], s_RootServ) == 0)
       || (stricmp(av[0], s_NickServ) == 0)
       || (stricmp(av[0], s_MemoServ) == 0)
       || (stricmp(av[0], s_ChanServ) == 0)
       || (stricmp(av[0], s_HelpServ) == 0)
       || (stricmp(av[0], s_Agent) == 0)
#ifndef NONSUPER
       || (stricmp(av[0], s_ServicesX) == 0)
       || (stricmp(av[0], s_ServicesW) == 0)
       || (stricmp(av[0], s_MassServ) == 0)
#endif
#ifdef DEFHOSTSERV
       || (stricmp(av[0], s_HostServ) == 0)
#endif
       || (stricmp(av[0], s_BotServ) == 0)
#ifdef WEBSERVICE
       || (stricmp(av[0], s_WebServ) == 0)
#endif
       || (stricmp(av[0], s_AdminServ) == 0)
       || (stricmp(av[0], s_SpamChecker) == 0))
       && (!stricmp(av[1], "*identify*") ==0))
           send_cmd(s_OperServ, "PRIVMSG %s :%s: %s", snoopchan, source, inbuf);

    if (!(*av[0] == '#')) {
	    serv_com += 1;

	    if (now > d_check_time) {
	       d_check_time = CTime + 86400;
	       day_serv_com = 1;
	    } else {
	        day_serv_com += 1;
	    }

	    if (now > h_check_time) {
	       h_check_time = CTime + 3600;
	       hour_serv_com = 1;
	    } else {
	        hour_serv_com += 1;
	    }

	   if (now > m_check_time) {
	      m_check_time = CTime + 60;
	      min_serv_com = 1;
	   } else {
	       min_serv_com += 1;
	   }

	    starttime = CTime;
   }

    if (!stricmp(av[0], s_OperServ)) {

	if(!(u->flags & U_ABUSIVE))
	    operserv(source, av[1]);
	else
            notice(s_OperServ, source, "Sorry, only IRC Operators may access OperServ.");

    } else if (stricmp(av[0], s_RootServ) == 0) {
        if (is_services_root(source) && is_oper(source))
            rootserv(u, source, av[1]);
	else {
            notice(s_RootServ, source, "Sorry, only Services Root may access RootServ.");
	}

    } else if (stricmp(av[0], s_NickServ) == 0) {
	nickserv(u, source, av[1]);

    } else if (stricmp(av[0], s_ChanServ) == 0) {
	chanserv(u, source, av[1]);

    } else if (stricmp(av[0], s_MemoServ) == 0) {
	memoserv(u, source, av[1]);

    } else if (stricmp(av[0], s_Agent) == 0) {
	agent(source, av[1], u);

    } else if (stricmp(av[0], s_HelpServ) == 0) {
	helpserv(s_HelpServ, source, av[1]);

#ifndef NONSUPER
    } else if (stricmp(av[0], s_ServicesX) == 0) {
	servicesX(source, av[1]);

    } else if (stricmp(av[0], s_ServicesW) == 0) {
	servicesW(source, av[1]);

    } else if (stricmp(av[0], s_MassServ) == 0) {
	massserv(source, av[1]);
#endif

    } else if (stricmp(av[0], s_SpamChecker) == 0) {
	SpamCheck(source, av[1]);

#ifdef DEFHOSTSERV
    } else if (stricmp(av[0], s_HostServ) == 0) {
	HostServ(u, source, av[1]);
#endif

    } else if (stricmp(av[0], s_AdminServ) == 0) {
	adminserv(source, av[1]);
#ifdef WEBSERVICE
    } else if (stricmp(av[0], s_WebServ) == 0) {
	webserv(u, source, av[1]);
#endif
    } else if (stricmp(av[0], s_BotServ) == 0) {
	sbotserv(source, av[1]);

    } else if (check_ifbot(av[0])) {
        botserv(source, av[0], av[1]);

    } else if (*av[0] == '#') {
	bmsgchan(source, av[0], av[1], u);

    } else if (snchan && !stricmp(av[0], snchan)) {
	send_cmd(s_OperServ, "PRIVMSG %s :<%s/%s> %s", snoopchan, source, av[0], av[1]);
    }

    /* Add to ignore list if the command took a significant amount of time. */

}

/*************************************************************************/

static void m_quit(char *source, int ac, char **av)
{
    if (ac != 1)
	return;
    do_quit(source, ac, av);
}

/*************************************************************************/

static void m_topic(char *source, int ac, char **av)
{
    if (ac != 4)
	return;

    do_topic(source, ac, av);
}

/*************************************************************************/

Message messages[] = {

    { "436",       m_nickcoll },
    { "421",       NULL },
#ifdef LIQUID
    { "449",       NULL },
    { "CHOST",     NULL },
    { "CIDENT",     NULL },
    { "SERVERINFO", NULL },
    { "IJOIN", m_join },
#endif
#ifdef RAGEIRCD
    { "SNICK",      m_nick },
#endif
    { "380",	   NULL },
    { "401",	   NULL },
    { "402",	   NULL },
    { "302",	   m_userhost },
    { "HELP",	   NULL },
    { "4",	   NULL },
    { MSG_AWAY,      m_away },
    { TOK_AWAY,      m_away },
    { MSG_JOIN,      m_join },
    { TOK_JOIN,      m_join },
#ifdef SJOIN
    { MSG_SJOIN,     m_sjoin },
    { TOK_SJOIN,     m_sjoin },
#endif
    { MSG_KICK,      m_kick },
    { TOK_KICK,      m_kick },
    { MSG_KILL,      m_kill },
    { TOK_KILL,      m_kill },
    { MSG_SVSKILL,   NULL },
    { TOK_SVSKILL,   NULL },
    { MSG_MODE,      m_mode },
    { TOK_MODE,      m_mode },
    { "SVSMODE",   NULL },
    { "n",   NULL },
    { MSG_MOTD,      m_motd },
    { TOK_MOTD,      m_motd },
    { MSG_NICK,      m_nick },
    { TOK_NICK,      m_nick },
    { MSG_NOTICE,    NULL },
    { TOK_NOTICE,    NULL },
    { MSG_PART,      m_part },
    { TOK_PART,      m_part },
    { MSG_PASS,      NULL },
    { TOK_PASS,      NULL },
    { MSG_PING,      m_ping },
    { TOK_PING,      m_ping },
    { MSG_PRIVATE,   m_privmsg },
    { TOK_PRIVATE,   m_privmsg },
    { MSG_QUIT,      m_quit },
    { TOK_QUIT,      m_quit },
    { MSG_SERVER,    m_server },
    { TOK_SERVER,    m_server },
    { MSG_SQUIT,     m_squit },
    { TOK_SQUIT,     m_squit },
    { MSG_TOPIC,     m_topic },
    { TOK_TOPIC,     m_topic },
    { "WALLOPS",   NULL },
    { "=",   NULL },
    { MSG_VERSION,   m_version },
    { TOK_VERSION,   m_version },
    { "AKILL",     NULL },
    { "V",     NULL },
    { "GLOBOPS",   NULL },
    { "]",   NULL },
    { "CHATOPS",   NULL },
    { "p",   NULL },
    { "GNOTICE",   NULL },
    { "Z",   NULL },
    { "GOPER",     NULL },
    { "[",     NULL },
    { "RAKILL",    NULL },
    { "Y",    NULL },
    { MSG_ADMIN,     m_admin },
    { TOK_ADMIN,     m_admin },
    { MSG_USERS,     m_user },
    { TOK_USERS,     m_user },
    { MSG_INFO,      m_info },
    { TOK_INFO,      m_info },
    { MSG_CREDITS,   m_credits },
    { TOK_CREDITS,   m_credits },
    { MSG_STATS,     m_stats },
    { TOK_STATS,     m_stats },
    { MSG_TIME,      m_time },
    { TOK_TIME,      m_time },
    { MSG_WHOIS,    NULL },
    { TOK_WHOIS,     NULL },
    { "SMO",       NULL },
    { "AU",       NULL },
    { "PROTOCTL",  NULL },
    { "_",  NULL },
    { MSG_SQLINE, m_addsqline },
    { TOK_SQLINE, m_addsqline },
    { "UNSQLINE",  NULL },
    { "d",  NULL },
    { "SVSNOOP",  NULL },
    { "f",  NULL },
    { "TRACE",  NULL },
    { "b",  NULL },
    { "ERROR",  NULL },
    { "SWHOIS",  NULL },
    { "VCTRL",  NULL },
    { "SYNC",  NULL },
    { MSG_SETIDENT,  m_setident },
    { TOK_SETIDENT,  m_setident },
    { MSG_SETHOST,   m_sethost },
    { TOK_SETHOST,   m_sethost },
    { MSG_SETNAME,   m_setname },
    { TOK_SETNAME,   m_setname },
    { "SETIDENT",  NULL },
    { "AD",  NULL },
    { "CHGHOST",   NULL },
    { "AL",   NULL },
#ifdef UNREAL
    { MSG_UMODE2,  m_umode2 },
    { TOK_UMODE2,  m_umode2 },
    { MSG_NETINFO,   m_netinfo },
    { TOK_NETINFO,   m_netinfo },
    { MSG_SWHOIS,   m_swhois },
    { TOK_SWHOIS,   m_swhois },
#endif
#ifdef ULTIMATE
    { "NETG",  NULL },
    { "GCLIENT",  NULL },
    { "SNETINFO",   NULL },
#endif
    { NULL }
};

/*************************************************************************/

Message *find_message(const char *name)
{
    Message *m;

    for (m = messages; m->name; m++) {
	if (stricmp(name, m->name) == 0)
	    return m;
    }
    return NULL;
}

/*************************************************************************/
