/* Various routines to perform simple actions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *  http://www.auspice.org
 * Originally based on SirvNET Services(c) by Trevor Klingbeil.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

/*************************************************************************/

/* Remove a user from the IRC network.  `source' is the nick which should
 * generate the kill, or NULL for a server-generated kill.
 */

void kill_user(const char *source, const char *user, const char *reason)
{
    char *av[2];

    if (!user || !*user)
	return;
    if (!source || !*source)
	source = server_name;
    if (!reason)
	reason = "";
    av[0] = sstrdup(user);
    av[1] = smalloc(strlen(source) + strlen(reason) + 5);
    sprintf(av[1], "%s (%s)", source, reason);
    send_cmd(SERVER_NAME, "%s %s :%s", istoken?TOK_KILL:MSG_KILL, user, av[1]);
    do_kill(source, 2, av);
    free(av[0]);
    free(av[1]);
}

/*************************************************************************/

/* Note a bad password attempt for the given user.  If they've used up
 * their limit, toss them off.
 */

void bad_password(User *u, const char *target)
{
  if (BAD_PW_LIMIT == 0)
     return;
  else {
    time_t now = CTime;

    if (BAD_PW_TIMEOUT > 0) {
        if (u->invalid_pw_time > 0 && u->invalid_pw_time < now-BAD_PW_TIMEOUT)
            u->invalid_pw_count = 0;
    }
    u->invalid_pw_count++;
    u->invalid_pw_time = now;
    if (u->invalid_pw_count >= BAD_PW_LIMIT) {
         if (*target == '#') {
               slog("CS *I %s (%s!%s@%s) [Abusive - Killed]",
                    target, u->nick, u->username, u->host);
              do_break_log("CS_I", "CS *I %s (%s!%s@%s) [Abusive - Killed]",
                    target, u->nick, u->username, u->host);
              kill_user(s_ChanServ, u->nick, "Too many invalid chan passwords");
         } else {
               slog("NS *I %s (%s!%s@%s) [Abusive - Killed]",
                     target, u->nick, u->username, u->host);
               do_break_log("NS_I", "NS *I %s (%s!%s@%s) [Abusive - Killed]",
                    target, u->nick, u->username, u->host);
               kill_user(s_NickServ, u->nick, "Too many invalid nick passwords");
         }
     } 

   }
}

/*************************************************************************/
