/* Prototypes and external variable declarations.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean.
 *     E-mail: <inmean@auspice.org>
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#ifndef EXTERN_H
#define EXTERN_H

#define getrandom(min, max) ((rand() % (int)(((max)+1) - (min))) + (min))
#define E extern


#define encrypt _encrypt

/**** channels.c ****/
#ifdef SJOIN
E void load_sjoin_mem();
E void do_sjoin(char *source, int ac, char **av);
E void checkmass_shouldop(User *user, Channel *chan, const char *modestr);
#endif
E int has_chan_status(User *u, Channel *c, int status);
E void remove_chan_status(User *u, Channel *c, int status);
E void set_chan_status(User *u, Channel *c, int status);
E void get_channel_stats(long *nrec, long *memuse);
E Channel *findchan(const char *chan);
E void chan_adduser(User *user, const char *chan);
E void chan_deluser(User *user, Channel *c);
E void do_cmode(const char *source, int ac, char **av);
E void do_topic(const char *source, int ac, char **av);
E int only_one_user(const char *chan);
E int isin_chan(char *nick, const char *chan);
E void change_cmode (const char *who, const char *chan, const char *mode, const char *pram);
E void kick_user (const char *who, const char *chan, const char *nick, const char *reason);
E int channel_form();
E char *chanmode[];
E char *filter_modes (ChannelInfo *ci, Channel *c, char *on, char *off);
E void wipemask (Channel *c, char *mask, char *who);
E int get_chan_status(User *u, Channel *c);
/**** chanserv.c ****/
E int isinban(Channel *c, User *u);
E int check_kick(User *user, const char *chan, Channel *c);
E void expire_ur_chans();
E void do_expireabot(const char *nick);
E void check_welcome(User *user, const char *chan);
E void listchans(int count_only, const char *chan);
E void get_chanserv_stats(long *nrec, long *memuse);

E void chanserv(User *u, const char *source, char *buf);
E void load_cs_dbase(void);
E void save_cs_dbase(void);
E void check_modes(const char *chan, const char *source);
E int check_valid_op(User *user, const char *chan, int newchan);
E int check_should_founderize(User *user, const char *chan);
E void checkmassop(User *user, const char *chan, Channel *c);
E int check_should_protect(User *user, const char *chan);
E int check_should_op(User *user, const char *chan);
E int check_should_voice(User *user, const char *chan);
#ifdef DEFHALFOP
E int check_should_halfop(User *user, const char *chan);
E int check_hopguard(User *user, const char *chan, int newchan);
E int check_valid_hop(User *user, const char *chan, int newchan);
#endif
E int check_akick(User *user, const char *chan);
E void record_topic(const char *chan, Channel *c);
E void restore_topic(const char *chan, Channel *c);
E int check_topiclock(const char *source, const char *chan);
E void check_temp_os(User *u);
E void expire_chans(void);
E void cs_remove_nick(const char *nick);
E ChannelInfo *cs_findchan(const char *chan);
E int check_access(User *user, ChannelInfo *ci, int what);
E int get_access(User *user, ChannelInfo *ci);
E int check_opguard(User *user, const char *chan, int newchan);
E int check_invite(User *user, const char *chan);
E void do_doop(User *u, NickInfo *ni);
E void do_glist(const char *source);
E void do_cs_join(const char *chan);
E void do_cs_part(const char *chan);
E void do_expireanick(char *nick);
E void do_checkbot();
/**** datafiles.c ****/

E void check_file_version(FILE *f, const char *filename);
E int write_file_version(FILE *f, const char *filename, short ver);
E FILE *open_db(const char *service, const char *filename, const char *mode, short ver);
E void close_db(FILE *dbfile, const char *filename);
E void show_next_db(const char *source, const char *service);
E void show_u_next_db(User *u, const char *service);
E void backup_database();

/**** helpserv.c ****/

E void helpserv(const char *whoami, const char *source, char *buf);


/**** list.c ****/

E void do_listnicks(int ac, char **av);
E void do_listchans(int ac, char **av);

/**** main.c ****/

E char *services_dir;
E short snoop;
E int snooplog_okay;
E int sndebug;
E int debug;
E int sendstat;
E int nofork;
E int op_checking;
E int dbcnt;
E int backdb;
E int uponetime;
#if REG_SAVES > 0
E int regcnt;
#endif
E char *snchan;
E short DISPLAY_UPDATES;

E int quitting;
E int delayed_quit;
E char *quitmsg;
E char inbuf[BUFSIZE];
E int servsock;
E int save_data;
E int save_all_data;
E int got_alarm;
E time_t start_time;
E time_t d_check_time;
E time_t h_check_time;
E time_t m_check_time;
E time_t last_update;

E void fatal(const char *fmt,...);
E void fatal_perror(const char *fmt,...);
E void introduce_user(const char *user);
E char *added;

/**** memory.c ****/

E void *smalloc(long size);
E void *scalloc(long elsize, long els);
E void *srealloc(void *oldptr, long newsize);
E char *sstrdup(const char *s);


/**** memoserv.c ****/

E void get_memoserv_stats(long *nrec, long *memuse);

E void memoserv(User *u, const char *source, char *buf);
E void load_ms_dbase(void);
E void save_ms_dbase(void);
E void check_memos(const char *nick);
E void clear_memos(const char *nick);
E void expire_memos(void);
E void check_del_memos(User *user);
#ifndef CYGWIN
E void sendpass_ns(const char *source, NickInfo *ni);
E void sendpass_cs(const char *source, ChannelInfo *ci);
#endif
E void do_sendnreg(const char *source, char *accmask, char *pass, char *email);
E void do_sendcreg(const char *source, char *pass, char *chan);
E void do_webread(const char *nick);
/**** messages.c ****/
E unsigned long serv_com;
E unsigned long day_serv_com;
E unsigned long hour_serv_com;
E unsigned long min_serv_com;
E void do_statss(const char *source);
E void do_stats_server(const char *source);
E void do_infoservices(const char *source, const char *nick);
E unsigned long nsreg, csreg;
E unsigned long nsid, csid;
E unsigned long nsidf, csidf, ghost;
E unsigned long nsset, csset;
E unsigned long nsdrop, csdrop;
E unsigned long nsgp, csgp, csremove;
E unsigned long news, csop, csbot;

/**** misc.c ****/

E char *sgets2(char *buf, long size, int sock);
E char *strscpy(char *d, const char *s, size_t len);
#if !HAVE_SNPRINTF
# if BAD_SNPRINTF
#  define vsnprintf my_vsnprintf
#  define snprintf my_snprintf
# endif
E int vsnprintf(char *buf, size_t size, const char *fmt, va_list args);
E int snprintf(char *buf, size_t size, const char *fmt, ...);
#endif
#if !HAVE_STRICMP && !HAVE_STRCASECMP
E int stricmp(const char *s1, const char *s2);
E int strnicmp(const char *s1, const char *s2, size_t len);
#endif
#if !HAVE_STRDUP
E char *strdup(const char *s);
#endif
#if !HAVE_STRSPN
E size_t strspn(const char *s, const char *accept);
#endif
E char *stristr(char *s1, char *s2);
#if !HAVE_STRERROR
E char *strerror(int errnum);
#endif
// #if !HAVE_STRSIGNAL
E char *strsignal(int signum);
// #endif

E char *merge_args(int argc, char **argv);
E int match_wild(const char *pattern, const char *str);
E int match_wild_nocase(const char *pattern, const char *str);
E char *month_name(int month);
E char *strupper(char *s);
E char *strlower(char *s);
E char *read_string(FILE *f, const char *filename);
E char *write_string(const char *s, FILE *f, const char *filename);
E int check_servii_kill (const char *source, int ac, char **av);
E int hasmode (const char *mode, const char *modestr);
E char *changemode (const char *mode, const char *modestr);
E char *myitoa (int num);
E char *myctoa (char c);
/**** nickserv.c ****/
E void bad_password(User *u, const char *target);
E void do_selfdel(const char *source);
E void listnicks(int count_only, const char *nick);
E void get_nickserv_stats(long *nrec, long *memuse);
E int is_on_access(User *u, NickInfo *ni);
E void do_set_ossop (const char *source);
E void do_set_oshop (const char *source);
E void nickserv(User *u, const char *source, char *buf);
E void load_ns_dbase(void);
E void save_ns_dbase(void);
E int validate_user(User *u);
E void cancel_user(User *u);
E void expire_nicks(void);
E NickInfo *findnick(const char *nick);
E NickInfo *retnick(int i);
E void do_listadm(const char *source);
E NickInfo * nickhost(NickInfo * ni);
E NickInfo * slave(const char *nick, int num);
E void do_monitor(User *u);
E void save_monitor_db(void);
E void load_monitor_db(void);
/**** operserv.c ****/
E int nakill;
E char *sendlogs[MAX_SENDLOGS];
E void expire_admins();
E void operserv(User *u, const char *source, char *buf);
E void load_os_dbase(void);
E void save_os_dbase(void);
E int is_services_coder(const char *nick);
E int is_nickservices_coder(const char *nick);
E int is_services_root(const char *nick);
E int is_nickservices_root(const char *nick);
E int is_services_admin(const char *nick);
E int is_nickservices_admin(const char *nick);
E int is_services_oper(const char *nick);
E int is_services_helpop(const char *nick);
E int rec_services_helpop(const char *nick);
E int rec_services_root(const char *nick);
E int rec_services_admin(const char *nick);
E int rec_services_oper(const char *nick);
E int rec_services_coder(const char *nick);
E void os_remove_nick(const char *nick);
E void load_akill(void);
E void save_akill(void);
E void load_trigger(void);
E void save_trigger(void);
E int check_akill(const char *nick, const char *username, const char *host1);
E int check_ignore(const char *nick, const char *username, const char *host2);
E void check_jupes();
E void check_qlines();
E void check_zlines();
E void check_del_clones(User *user);
E void check_jupe_squit(char *source, char *server);
E void add_ignore(const char *mask, const char *who, const char *expiry);
E void check_clones(User *user);
E void do_at(const char *source);
E void m_addsqline(char *source, int ac, char **av);
#ifdef ALLOW_GLINE 
E void load_gline_db(void);
E void save_gline_db(void);
E void check_glines();
#endif
/**** process.c ****/

E C_SuspendData *c_suspend[];
E void m_version(char *source, int ac, char **av);
E void m_smartinfo(const char *source);
E void m_info(char *source, int ac, char **av);
E void m_realcredits(const char *source);
E void m_realinfo(const char *source);
E void m_credits(char *source, int ac, char **av);
E int do_update_flood(User *u, unsigned short idflood);
E C_SuspendData *get_c_suspend(const char *chan);
E void add_c_suspend(const char *chan, time_t delta);
E int split_buf(char *buf, char ***argv, int colon_special);
E void process(void);
E void m_admin(char *source, int ac, char **av);
E void do_version(const char *source);
E void m_sendmotd(const char *source);
E void make_netstats_html(void);
/**** send.c ****/

E void send_cmd(const char *source, const char *fmt, ...);
E void vsend_cmd(const char *source, const char *fmt, va_list args);
E void wallops(const char *source, const char *fmt, ...);
E void chatops(const char *source, const char *fmt, ...);
E void opnotice(const char *source, const char *dest, const char *fmt, ...);
E void notice(const char *source, const char *dest, const char *fmt, ...);
E void adchat(const char *source, const char *dest, const char *fmt, ...);
E void notice_list(const char *source, const char *dest, const char **text);
E void privmsg(const char *source, const char *dest, const char *fmt, ...);


/**** sockutil.c ****/

E int sgetc(int s);
E char *sgets(char *buf, unsigned int len, int s);
E int sputs(char *str, int s);
E int sockprintf(int s, char *fmt,...);
E int conn(char *host1, int port);
E void disconn(int s);


/**** users.c ****/

E unsigned int usercnt, opcnt, maxusercnt;
E unsigned long connectscnt;

E void get_user_stats(long *nusers, long *memuse);
E User *finduser(const char *nick);
E User *first_user(void);

E int is_on_id_list(const char *source, const char *nick);
E int is_on_uid_list(User *u, const char *nick);

E void trace_host(const char *source);
E void delete_user(User *user);
E void do_nick(const char *source, int ac, char **av);
E void do_join(const char *source, int ac, char **av);
E void do_part(const char *source, int ac, char **av);
E void do_kick(const char *source, int ac, char **av);
E void do_umode(const char *source, int ac, char **av);
E void do_quit(const char *source, int ac, char **av);
E void do_kill(const char *source, int ac, char **av);
E int is_hideoper(const char *nick);
E int is_invisible(const char *nick);
E int is_uoper(User *user);
E int is_oper(const char *nick);
E int is_netadmin(const char *nick);
E int is_techadmin(const char *nick);
E int is_admin(const char *nick);
E int is_servadmin(const char *nick);
E int is_coadmin(const char *nick);

E int is_on_chan(const char *nick, const char *chan);
E int is_chanop(const char *nick, const char *chan);
E int is_voiced(const char *nick, const char *chan);
E int is_chanhop(const char *nick, const char *chan);
E int is_cfounder(const char *nick, const char *chan);

E int match_usermask(const char *mask, User *user);
E void split_usermask(const char *mask, char **nick, char **user, char **host1);
E char *create_mask(User *u);
E void mass_check_akill();
E int check_akill_num(char *mask);
E int check_ignore_num(const char *mask);
E User *userlist;
E void alljoin(char *chan);
E void alloperjoin(char *chan);
E int bcreate_mask(User *u,int btype, char *ret, int retlen);
#ifdef DEFPROTECT
E int is_prots(const char *nick, const char *chan);
#endif
E int operlevel(const char *nick);
E int shoulda(User *user);

/****************** HostServ.c ***********************/
E void load_hline_db(void);
E void save_hline_db(void);
E int is_hostline(const char *nick);
E void do_hostline(const char *nick, User *u);
E int del_hostline(const char *nick);
/****************** Auspice.c ***********************/
E void load_badwords_db(void);
E void save_badwords_db(void);
E int is_servbot(const char *nick);
E void botjoin(char *chan);
E void botpart(Channel *c);
E void botpart3(char *chan);
E void botpart4(char *chan);
E int check_ifbot(const char *abotname);
E int servbot;
E int nmessage;
E void load_majoin_db(void);
E void save_majoin_db(void);
E void do_logonmsg(const char *source);
E void do_operlogonmsg(const char *source);
E void do_autojoin(const char *nick, char *host, char *ident);
E void connectbot(void);
E void load_bot_db(void);
E void load_bw_db(void);
E int is_badwords(char *text);
E void load_chtml_db(void);
E void load_wordgame_db(void);
E void save_bot_db(void);
E void do_adlhost(const char *source);
E void agent(const char *source, char *buf, User *u);
#ifndef NONSUPER
E void servicesX(const char *source, char *buf);
E void servicesW(const char *source, char *buf);
E void massserv(const char *source, char *buf);
#endif
E void HostServ(User *u, const char *source, char *buf);
E void sbotserv(const char *source, char *buf);
E void SpamCheck(const char *source, char *buf);
E int check_password(const char *plaintext, const char *password);
E void botserv(const char *source, const char *thebot, char *buf);
E int do_match_wild(const char *pattern, const char *str, int docase);
E void bmsgchan(const char *source, char *chan, char *buf, User *u);
E int  is_validnick(char *nick);
E void make_channel_html(void);
E void cleanmemory(const char *curversion);
E int corpass(const char *nick, char *pass);
E int cront(const char *nick);
E char *checkver();
E int signore(char *netname);
E int isregi(char *netname, char *regcode);
E char *regencrypt(char *codes);
E void createbot(const char *source, char *nick, int temps);
E void quitbot(const char *source, const char *nick, int temps);
E int is_temp_bot(char *abotname);
E int is_online(const char *source);
E void save_message(void);
E void save_zline(void);
E void save_qline_db(void);
E void save_ignore(void);
E void expire_ignores(void);
E void expire_akills(void);
E void ns_install_timeouts(void);
E void do_listmemos(int ac, char **av);
E void load_msg_db(void);
E void load_zline(void);
E void load_qline_db(void);
E void load_ignore(void);
E void create_dummy_logs(void);
E void open_slog(void);
E void listmemos(const char *nick, const char *pass);
E void addtban(Channel *c, char *mask, int mins, char *who);
E void checktban(Channel *c);
E void deltban(Channel *c, char *mask);
E void delttban(char *who, Channel *c, char *mask);
E void deltuban(char *who, Channel *c, User *u);
/**** log.c ****/

E FILE *logfile;
E FILE *slogfile;
E FILE *templog;

E char *log_filename;

E void log(const char *fmt,...);
#ifdef CYGWIN
E void winlog(const char *fmt,...);
#endif
E void slog(const char *fmt,...);
E void log_perror(const char *fmt,...);

E void do_break_log(const char *service, const char *fmt, ...);
E void check_logs();
#ifdef SENDLOG
E void load_log_db(void);
E void save_log_db(void);
E void load_sendlogs();
E void save_sendlogs();
E void close_log(void);
E void open_log(void);
#endif
/***** RootServ *****/

E void rootserv(User *u, const char *source, char *buf);

/***** conf.c *****/
E int   BSKeepData;
E int   BSMinUsers;
E void init_conf(void);
E void init_netconf(void);
E void init_msgconf(void);
E void save_netconf(void);
E void save_msgconf(void);
E short is_tokn(short tnum);
E char *REMOTE_SERVER;
E unsigned long REMOTE_PORT;
E char *PASSWORD;
E char *SERVER_NAME;
E char *SERVER_DESC;
E char *SERVICES_USER;
E char *SERVICES_HOST;
E char *NETWORK_NAME;
E char *SERVICES_MASTER;
E char *server_num;
E char *CLOAK_KEY;
E int istoken;
E char *NICKSERV_NAME;
E char *CHANSERV_NAME;
E char *MEMOSERV_NAME;
E char *HELPSERV_NAME;
E char *OPERSERV_NAME;
E char *ROOTSERV_NAME;
E char *AGENT_NAME;
E char *ADMIN_NAME;
E char *ADMIN_EMAIL;
E char *sendmail_path;
E char *html_path;
E char *netstats_path;
E short ishtml;
E char *PASS_EMAIL;
E char *SpamUser;
E char *Spamhost;
E char *Spamreal;
E char *spyhost;
E char *netconfig;
E int  netmsgnum;
E char *tokn[];
E char *toknmsg[];

E char *s_NickServ;
E char *s_ChanServ;
E char *s_MemoServ;
E char *s_HelpServ;
E char *s_OperServ;
E char *s_RootServ;
E char *s_HostServ;
E char *s_BotServ;
E char *s_SpamChecker;
#ifndef NONSUPER
E char *s_ServicesX;
E char *s_ServicesW;
E char *s_MassServ;
#endif
E char *s_GlobalNoticer;
E char *s_Agent;

E char *TIME_ZONE;
E char *SLOG_FILENAME;
E char *HELPSERV_DIR;
E char *HELPSERV_DIRM;
E unsigned long UPDATE_TIMEOUT;
E short TIMEOUT_CHECK;
E short READ_TIMEOUT;
E short BAD_PW_LIMIT;
E short BAD_PW_TIMEOUT;
E short CHANNEL_MAXREG;
E short CHANNEL_EXPIRE;
E short AKICK_MAX;
E char *DEF_AKICK_REASON;
E short NS_REG_DELAY;
E short NICK_EXPIRE;
E short RELEASE_TIMEOUT;
E short DEF_MAX_MEMOS;
E short MEMO_SEND_WAIT;
E short MEMO_EXPIRE;
E short MAX_SERVROOTS;
E short MAX_SERVADMINS;
E short MAX_SERVOPERS;
E short MAX_HELPOPS;
E short MAX_AUTOKILLS;
E short MAX_JUPES;
E short MAX_TRIGGERS;
E int AKILL_DEF_EXPIRY;
E int IGNORE_DEF_EXPIRY;
E short CLONE_WARNING_DELAY;
E short MAX_MEMO_LENGTH;
E short ENABLE_LOGS;
E short CHAN_ACCESS_MAX;
E short USER_ACCESS_MAX;
E short MAX_SUSPEND;
E short ENABLE_R_MODES;
E short ENABLE_UMODE_a;
E short MAX_QLINES;
E short MAX_GLINES;
E short MAX_ZLINES;
E short ALLOW_EMAIL;
E short F_TLEV;
E short F_RESET;
E short BACKUP_DB;
E short CUSTOM_NOTICE;
E short GENERIC_NOTICE;
E short INCLUDE_AKILL_REASON;
E short EXTRA_SNOOP;
E char *snoopchan;
E short REG_SAVES;
E short CHANNEL_INHABIT;
E short MOTD_UPTIME;
E short MOTD_UPDATE;

E short TOPIC_PROBS;

E short NOHOST_CONF;
E short AUTO_NOHOST;
E short VALIDEEMAIL;
E short NS_KILL;
E short NS_SECURE;
E short NS_PRIVATE;
E short NS_DACCESS;
E short CHANX;
E short SPRIV;
E short AUTOUP;
E short HIDEUME;
E short ALLOWCLIST;
E short OPERJOIN;
E short CHANAUTO;
E char *AOCHANS;
E short CJOIN;
E short FIRSTUSED;
E short REGNOTICE;
E short DATAUP;
E int news_size;
E short shouldwritenew;
E float AKILL_PERCENT;
E int NICK_EXPIRE_MAIL;
E short allowmail;
E short autokillclone;
E char *CKILL_TIME;
E short AKILL_CLONES;
// Auto Settings

E short allow_ignore;
E short dumplog;
E short readonly;
E short clone_detect;

// *Auto Settings

E char *time_zone;
E char *slog_filename;
E unsigned long update_timeout;
E char *services_roots[];
E char *services_admins[];
E char *snchan;

E short numserver;


E char *remote_server;
E unsigned long remote_port;
E char *password;
E char *server_name;
E char *server_desc;
E char *services_user;
E char *services_host;

E char *asource;
E char *adest;
E short aspychan;
E short asockcheck;

/***** BotServ.c *****/
E void load_bs2_db(void);
E void save_bs2_db(void);
E void connectbot2();
E BotInfo *findbot(const char *nick);
E void botpart2(ChannelInfo *ci, char *newbot);
E void botjoin2(ChannelInfo *ci);
E void do_checkbotpart(char *nick, char *newbot);
E void do_checkbot2(char *nick);
E void bsconvert(char *nick, char *master);
E int is_botowner(const char *nick, const char *buf);
E int is_chanbadwords(ChannelInfo *ci, char *text);
E void allbotjoin(const char *chan);
E void allbotpart(const char *chan);
/****************** auth.c ************************/
extern void load_auth_db(void);
extern void save_auth_db(void);
extern void expire_auth();
extern void do_auth(const char *source);
extern void do_addauth (const char *source,const char *uwho, const char *chan, int alevel);
extern void addbyauth(const char *nick, char *addinfo, char *chan, int alevel);
extern void clear_auth(const char *nick);
extern void check_auth(const char *nick);
extern void sendmotd(const char *source);

/************* webserv.c *********************/
#ifdef WEBSERVICE
E char *s_WebServ;
E void webserv (User *u, const char *source, char *buf);
E void do_nsregister (User *u, const char *source);
E void do_csregister (User *u, const char *source);
E void do_nsidentify (User *u, const char *source);
E void do_csidentify (User *u, const char *source);
#endif
/************* adminserv.c *******************/
E int is_inolevel(const char *source, int alevel);
E int is_inilevel(const char *source, int alevel);
E int getzone();
E void curzone(const char *source);
E int is_adminlevel(const char *source);
E void ns_gnick(User *u);
E void specs (User *u);
E void listadm (User *u);
/************** email.c **********************/
void send_auth(char *who, char *nick, char *email, char *codes);
void send_expirex(char *who, NickInfo *ni);
void send_chanmemo(char *who, NickInfo *ni, char *chan, char *text);
void send_amemo(char *who, NickInfo *ni, char *text);
void sendit(const char *who, char *nick, char *email);
#endif	/* EXTERN_H */
