#include "../inc/services.h"
#include "../inc/timeout.h"

#define MO_DB "monitor.db"
struct mymonitor_ {
    char *who;
    time_t stime;
    char *bywho;
    char *note;
} *MyMonitor = NULL;
static int nhj = 0;
static int hj_size = 0;

void load_monitor_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_Agent, "monitor.db", "r", 1)))
        return;
    switch (i = get_file_version(f, "monitor.db")) {
      case 1:
        nhj = fgetc(f) * 256 + fgetc(f);
        if (nhj < 8)
            hj_size = 16;
        else
            hj_size = 2*nhj;
        MyMonitor = smalloc(sizeof(*MyMonitor) * hj_size);
        if (!nhj) {
            fclose(f);
            return;
        }
        if (nhj != fread(MyMonitor, sizeof(*MyMonitor), nhj, f))
            fatal_perror("Read error on %s", MO_DB);
        for (i = 0; i < nhj; i++) {
            MyMonitor[i].who = read_string(f, MO_DB);
            MyMonitor[i].bywho = read_string(f, MO_DB);
            MyMonitor[i].note = read_string(f, MO_DB);
        }
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, MO_DB);
    } /* switch (version) */

    close_db(f, MO_DB);
}

void save_monitor_db(void)
{
    FILE *f;
    int i;
    f = open_db(s_Agent, MO_DB, "w", 1);
    fputc(nhj/256, f);
    fputc(nhj & 255, f);
    if (fwrite(MyMonitor, sizeof(*MyMonitor), nhj, f) != nhj)
        fatal_perror("Write error on %s", MO_DB);
    for (i = 0; i < nhj; i++) {
        write_string(MyMonitor[i].who, f, MO_DB);
        write_string(MyMonitor[i].bywho, f, MO_DB);
        write_string(MyMonitor[i].note, f, MO_DB);
    }
    close_db(f, MO_DB);
}
void do_monitor(User *u)
{
        NickInfo *ni = findnick(u->nick);
        char *cmd = strtok(NULL, " ");

        if (!ni) {
                notice(s_NickServ, u->nick, "Your nick is not registered.");
                return;
        }

        if (!cmd) {
                notice(s_NickServ, u->nick, "Syntax: MONITOR <command>.");
                return;
        }

	if (!stricmp(cmd, "ADD")) {
		int i;
		char *who = strtok(NULL, " ");
		char *note = strtok(NULL, "");
		if (!is_services_admin(u->nick)) {
	                notice(s_NickServ, u->nick, "Permision Denied.");
			return;
		}
		if (!who || !note) {
	                notice(s_NickServ, u->nick, "Syntax: MONITOR ADD <nick> <reason>.");
			return;
		}
		for (i = 0; i < nhj; i++) {
			if (!stricmp(who, MyMonitor[i].who)) {
				notice(s_NickServ, u->nick, "This nick currently exist in Monitor list.");
				return;
			}
		}
                if (nhj >= hj_size) {
	                if (hj_size < 8)
				hj_size = 8;
                        else
                        	hj_size *= 2;
		        MyMonitor = srealloc(MyMonitor, sizeof(*MyMonitor) *hj_size);
                }
               	MyMonitor[nhj].who = sstrdup(who);
                MyMonitor[nhj].bywho = sstrdup(u->nick);
       	        MyMonitor[nhj].note = sstrdup(note);
       	        MyMonitor[nhj].stime = CTime;
               	++nhj;
                notice(s_NickServ, u->nick, "Record added.");
	} else if (!stricmp(cmd, "LIST")) {
		NickInfo *ni2;
		int i;
		if (!is_uoper(u)) {
	                notice(s_NickServ, u->nick, "Permision Denied.");
			return;
		}
		for (i = 0; i < nhj; i++) {
			time_t uptime = CTime - MyMonitor[i].stime;
			ni2 = findnick(MyMonitor[i].who);
			if (ni2) {
			time_t myseen = CTime - ni2->last_seen;
			notice(s_NickServ, u->nick, " %d) %s Start: %d day%s %d:%d ago Seen: %d day ago (added by %s) %s",
			i+1, MyMonitor[i].who, uptime/86400, (uptime/86400 == 1) ? "" : "s",
                        (uptime/3600) % 24, (uptime/60) % 60 , myseen/86400, MyMonitor[i].bywho, MyMonitor[i].note);
			} else {
			notice(s_NickServ, u->nick, " %d) %s Start: %d day%s %d:%d ago (added by %s) %s",
			i+1, MyMonitor[i].who, uptime/86400, (uptime/86400 == 1) ? "" : "s",
                        (uptime/3600) % 24, (uptime/60) % 60 , MyMonitor[i].bywho, MyMonitor[i].note);
			}
		}
                notice(s_NickServ, u->nick, "End of List");
	} else if (!stricmp(cmd, "DEL")) {
		char *who = strtok(NULL, " ");
		int i, j;
		if (!is_services_root(u->nick)) {
	                notice(s_NickServ, u->nick, "Permision Denied.");
			return;
		}
		if (!who) {
	                notice(s_NickServ, u->nick, "Syntax: MONITOR DEL <number>.");
			return;
		}
		if (who && (strspn(who, "1234567890") == strlen(who) && (i = atoi(who)) > 0 && i <=nhj)) {
			for (j=0; j<nhj; ++j) {
				if (j > (i-1)) {
					if (MyMonitor[j-1].who) free(MyMonitor[j-1].who);
					MyMonitor[j-1].who = sstrdup(MyMonitor[j].who);
					if (MyMonitor[j-1].bywho)  free(MyMonitor[j-1].bywho);
					MyMonitor[j-1].bywho = sstrdup(MyMonitor[j].bywho);
					if (MyMonitor[j-1].note) free(MyMonitor[j-1].note);
					MyMonitor[j-1].note = sstrdup(MyMonitor[j].note);
					MyMonitor[j-1].stime = MyMonitor[j].stime;
                                }
			}
			free(MyMonitor[nhj].who);
			free(MyMonitor[nhj].bywho);
                        free(MyMonitor[nhj].note);
                        nhj--;
	                notice(s_Agent, u->nick, "Monitor #%d is deleted.", i);
                } else {
	                notice(s_Agent, u->nick, "Record not found.");
	        } /* else */
	} else if (!stricmp(cmd, "VIEW")) {
		int i;
		for (i = 0; i < nhj; i++) {
			if (!stricmp(u->nick, MyMonitor[i].who)) {
				time_t uptime = CTime - MyMonitor[i].stime;
				notice(s_NickServ, u->nick, " %d) %s Start: %d day%s %d:%d ago : %s",
				i+1, MyMonitor[i].who, uptime/86400, (uptime/86400 == 1) ? "" : "s",
	                	(uptime/3600) % 24, (uptime/60) % 60 , MyMonitor[i].note);
			}
		}
	} else if (!stricmp(cmd, "RESET")) {
		char *who = strtok(NULL, " ");
		int i;
		if (!is_services_root(u->nick)) {
	                notice(s_NickServ, u->nick, "Permision Denied.");
			return;
		}
		if (!who) {
	                notice(s_NickServ, u->nick, "Syntax: MONITOR RESET <nick>.");
			return;
		}
		for (i = 0; i < nhj; i++) {
			if (!stricmp(who, MyMonitor[i].who)) {
				MyMonitor[i].stime = CTime;
				notice(s_NickServ, u->nick, "Reset monitor time for nick %s.", who);
			}
		}
	} else {
		notice(s_NickServ, u->nick, "Unknown command.");
	}
}
