/* Auspice functions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean.
 *     E-mail: <auspice@auspice.org>
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"
#include "../inc/timeout.h"

int servbot = 0;
int chtml = 0;
long wgameline = 0;
static int nhj = 0;
static int hj_size = 0;
static int nmessage = 0;
static int nbadwords = 0;
static int message_size = 0;
static int badwords_size = 0;

struct message_ {
    char *text;
    short type;
    char *who;
    long reserved[4];
} *lmessages = NULL;

struct badwords_ {
    char *text;
    char *who;
} *BadWords = NULL;

struct newsflash_ {
    char *text;
    time_t time;
    char *who;
} *NewsFlash = NULL;
static int nnewsflash = 0;
static int curflash = 0;
struct hostjoin_ {
    char *host;
    char *chan;
    char *who;
    long reserved[4];
} *hostjoin = NULL;

char *channelname[64];
char *channeltopic[64];
#ifdef WGAME
char *wordgame[3100];
char *wordhelp[3100];
#endif

static void do_agenthelp(const char *source);
static void do_agentset(const char *source);

#ifndef NONSUPER
void servicesX(const char *source, char *buf);
void servicesW(const char *source, char *buf);
#endif
int del_badword(const char *nick);
static void do_agentbadwords(const char *source);
static void do_newsflash(const char *source);

int is_servbot(const char *nick);
int is_badwords(char *text);
static void agenthtml();

int socket_connected = 0;

/* 1 = connected
   0 = not connected, no failed attempts
   -(x), x = number of failed attempts */

int socket_fd = 0;
long int last_ping;

/************************************************************************/
int  is_validnick(char *nick)
{
        char *ch;

        if (*nick == '-' || isdigit(*nick))    /* first character in  [0..9-] */
                return 0;

	if (strlen(nick) > 20)
                return 0;

        for (ch = nick; *ch && (ch - nick) < 30; ch++)
                if (isspace(*ch) || (*ch == '%'))
	                return 0;

        return 1;
}
/*************************** TOOLS *************************************/
void load_msg_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_Agent, MSG_DB, "r", 1)))
        return;

    switch (i = get_file_version(f, MSG_DB)) {
      case 6:
      case 5:
        nmessage = fgetc(f) * 256 + fgetc(f);
        if (nmessage < 8)
            message_size = 16;
        else
            message_size = 2*nmessage;
        lmessages = smalloc(sizeof(*lmessages) * message_size);
        if (!nmessage) {
            fclose(f);
            return;
        }
        if (nmessage != fread(lmessages, sizeof(*lmessages), nmessage, f))
            fatal_perror("Read error on %s", MSG_DB);
        for (i = 0; i < nmessage; i++) {
            lmessages[i].text = read_string(f, MSG_DB);
            lmessages[i].who = read_string(f, MSG_DB);
        }
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, MSG_DB);
    } /* switch (version) */

    close_db(f, MSG_DB);
}
/*************************************************************************/
void save_message(void)
{
    FILE *f;
    int i;
    f = open_db(s_Agent, MSG_DB, "w", AS_MSG_VERSION);
    fputc(nmessage/256, f);
    fputc(nmessage & 255, f);
    if (fwrite(lmessages, sizeof(*lmessages), nmessage, f) != nmessage)
        fatal_perror("Write error on %s", MSG_DB);
    for (i = 0; i < nmessage; i++) {
        write_string(lmessages[i].text, f, MSG_DB);
        write_string(lmessages[i].who, f, MSG_DB);
    }
    close_db(f, MSG_DB);
}
/*************************************************************************/
void do_logonmsg(const char *source)
{
	int i;
        for (i = 0; i < nmessage; ++i)
            if (lmessages[i].type == M_LOGON) {
                if (is_tokn(47)) {
			notice(s_GlobalNoticer, source, "%s", lmessages[i].text);
		} else {
			send_cmd(server_name, "304 %s :\00312Logon\0034News\003:%s", source, lmessages[i].text);
		}
	    }
}
/*************************************************************************/
void do_operlogonmsg(const char *source)
{
	int i;
        for (i = 0; i < nmessage; ++i)
            if (lmessages[i].type == M_OPER) {
                if (is_tokn(47)) {
			notice(s_GlobalNoticer, source, "%s", lmessages[i].text);
		} else {
			send_cmd(server_name, "304 %s :\00312Oper\0034News\003: %s", source, lmessages[i].text);
		}
	    }
}
/*************************************************************************/
void load_badwords_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_Agent, BADWORD_DB, "r", 1)))
        return;

    switch (i = get_file_version(f, BADWORD_DB)) {
      case 1:
        nbadwords = fgetc(f) * 256 + fgetc(f);
        if (nbadwords < 8)
            badwords_size = 16;
        else
            badwords_size = 2*nbadwords;
        BadWords = smalloc(sizeof(*BadWords) * badwords_size);
        if (!nbadwords) {
            fclose(f);
            return;
        }
        if (nbadwords != fread(BadWords, sizeof(*BadWords), nbadwords, f))
            fatal_perror("Read error on %s", BADWORD_DB);
        for (i = 0; i < nbadwords; i++) {
            BadWords[i].text = read_string(f, BADWORD_DB);
            BadWords[i].who = read_string(f, BADWORD_DB);
        }
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, BADWORD_DB);
    } /* switch (version) */

    close_db(f, BADWORD_DB);
}
/***********************************************************/
void save_badwords_db(void)
{
    FILE *f;
    int i;

    f = open_db(s_Agent, BADWORD_DB, "w", BADWORD_VERSION);
    fputc(nbadwords/256, f);
    fputc(nbadwords & 255, f);
    if (fwrite(BadWords, sizeof(*BadWords), nbadwords, f) != nbadwords)
        fatal_perror("Write error on %s", BADWORD_DB);
    for (i = 0; i < nbadwords; i++) {
        write_string(BadWords[i].text, f, BADWORD_DB);
        write_string(BadWords[i].who, f, BADWORD_DB);
    }
    close_db(f, BADWORD_DB);

}
/***********************************************************/
void load_majoin_db(void)
{
    FILE *f;
    int i;

    if (!(f = open_db(s_Agent, HJ_DB, "r", 1)))
        return;

    switch (i = get_file_version(f, HJ_DB)) {
      case 6:
      case 5:
        nhj = fgetc(f) * 256 + fgetc(f);
        if (nhj < 8)
            hj_size = 16;
        else
            hj_size = 2*nhj;
        hostjoin = smalloc(sizeof(*hostjoin) * hj_size);
        if (!nhj) {
            fclose(f);
            return;
        }
        if (nhj != fread(hostjoin, sizeof(*hostjoin), nhj, f))
            fatal_perror("Read error on %s", HJ_DB);
        for (i = 0; i < nhj; i++) {
            hostjoin[i].host = read_string(f, HJ_DB);
            hostjoin[i].chan = read_string(f, HJ_DB);
            hostjoin[i].who = read_string(f, HJ_DB);
        }
        break;
      default:
        fatal("Unsupported version (%d) on %s", i, HJ_DB);
    } /* switch (version) */

    close_db(f, HJ_DB);
}
/**********************************************************/
void save_majoin_db(void)
{
    FILE *f;
    int i;
    f = open_db(s_Agent, HJ_DB, "w", AS_MJ_VERSION);
    fputc(nhj/256, f);
    fputc(nhj & 255, f);
    if (fwrite(hostjoin, sizeof(*hostjoin), nhj, f) != nhj)
        fatal_perror("Write error on %s", HJ_DB);
    for (i = 0; i < nhj; i++) {
        write_string(hostjoin[i].host, f, HJ_DB);
        write_string(hostjoin[i].chan, f, HJ_DB);
        write_string(hostjoin[i].who, f, HJ_DB);
    }
    close_db(f, HJ_DB);
}
void load_agent_db(void) {

    FILE *f = fopen ("agent.db", "r");
    char *item, *s, dBuf[2048];

    if (!f) {
        return;
    }
    while (fgets (dBuf, 2047, f))
    {
    item = strtok (dBuf, " ");

    if (*item == '#' || *item == '\n' || *item == '\t' || *item == ' ' ||
        *item == '\0' || *item == '\r' || !*item)
                continue;
    if (!strcmp (item, "NF")) {
        nnewsflash++;
        NewsFlash = srealloc(NewsFlash, sizeof(*NewsFlash) *nnewsflash);
        if ((s = strtok (NULL, " "))) { NewsFlash[nnewsflash - 1].who = sstrdup(s); }
        if ((s = strtok (NULL, " "))) { NewsFlash[nnewsflash - 1].time = atol(s); }
        if ((s = strtok (NULL, "\n"))) { NewsFlash[nnewsflash - 1].text = sstrdup(s); }
        continue;
    }
    }
    fclose(f);
}


void save_agent_db(void)
{
    FILE *f;
    int i;
    if (rename("agent.db", "agent.db.save") < 0 && errno != ENOENT) {
        wallops(NULL, "Can't back up %s database agent.db", s_RootServ);
        return;
    }
    f = fopen ("agent.db", "w");
    if (!f) {
        return;
    }
    for (i = 0; i < nnewsflash; ++i) {
        fprintf (f, "NF %s %lu %s\n", NewsFlash[i].who, NewsFlash[i].time, NewsFlash[i].text); 
    }
    fclose(f);
    remove("agent.db.save");
}
void checkflash ()
{
	User *user;
        if (nnewsflash == 0) return;
        if (curflash >= nnewsflash) {
		for (user = userlist; user; user = user->next)
		send_cmd(server_name, "304 %s :\00312News\0034Flash\3: Free Friend Finder Services, fast and secure at http://www.web141.com", user->nick);
		curflash = 0;
	} else {
	for (user = userlist; user; user = user->next)
	send_cmd(server_name, "304 %s :\00312News\0034Flash\3: %s", user->nick, NewsFlash[curflash].text);
        curflash++;
	}
}
/***********************************************************/
void load_chtml_db(void)
{
    FILE *f;
    char chtmldata[128];
    int i = 1;
    *chtmldata = 0;
    chtml = 1;
    strcat(chtmldata, "chtml.conf");
    f = fopen(chtmldata, "r");
    if (f) {
    while(fgets(chtmldata, sizeof(chtmldata), f)) {
	 if (*chtmldata == '@') {
			if (channelname[chtml]) {
				free(channelname[chtml]);
				channelname[chtml] = NULL;
			}
			channelname[chtml] = sstrdup(strtok(chtmldata, "\n"));
			if (channeltopic[chtml])
				free(channeltopic[chtml]);
			channeltopic[chtml] = NULL;
			chtml++;
			i = 1;
	 } else {
		 if (chtmldata && (strlen(chtmldata) > 1)) {
		 if (i==1) {
			if (channelname[chtml]) {
				free(channelname[chtml]);
				channelname[chtml] = NULL;
			}
			channelname[chtml] = sstrdup(strtok(chtmldata, "\n"));
			i = 2;
		 } else {
			if (channeltopic[chtml]) {
				free(channeltopic[chtml]);
				channeltopic[chtml] = NULL;
			}
			channeltopic[chtml] = sstrdup(strtok(chtmldata, "\n"));
			i = 1;
			chtml++;
		 } }
	 }
    }
    fclose(f);
    }
    chtml--;
} 
/***********************************************************/
#ifdef WGAME
void load_wordgame_db(void)
{
    FILE *f;
    char gworddata[512];
    *gworddata = 0;
    wgameline = 1;
    if (f = fopen("wgame.conf", "r")) {
    while(fgets(gworddata, sizeof(gworddata), f)) {
	wordgame[wgameline] = sstrdup(strtok(gworddata, ":"));
	wordhelp[wgameline] = sstrdup(strtok(NULL, "\n"));
	wgameline++;
	*gworddata = 0;
    }
    fclose(f);
    }
    wgameline--;
}
#endif
/***********************************************************/
int is_badwords(char *text)
{
	int i;

	if (!text)
		return 0;

	for (i=0; i<nbadwords; i++)
		if (match_wild_nocase(BadWords[i].text, text))
			return 1;
	return 0;
}
/*******************************************************/
void make_channel_html(void)
{
    Channel *c;
    int i;
    FILE *fp;
    FILE *fp1;

    if (ishtml == 0)
	return;

    fp = fopen(html_path, "w");
    fp1 = fopen("channel.dump", "w");
    if (fp) {
	fprintf(fp, "<style type=\"text/css\">");
	fprintf(fp, "<!--A:link, A:visited { text-decoration: none }");
	fprintf(fp, "A:hover { text-decoration: underline; color:  #FF0000 }");
	fprintf(fp, "A:hover { text-decoration: overline; color:  #0000000}--->");
	fprintf(fp, "</style>");
	fprintf(fp, "<body bgcolor=\"#FFFFFF\" text=\"#000000\" font=\"Arial, Helvetica, sans-serif\">");
	fprintf (fp, "<h2>Channel Listing</h2>\n");
	fprintf (fp, "<p><font size=\"2\">There are <b>%d</b> channels available in this network.</font></p>", channel_form());
	fprintf (fp, "<table border=\"1\" bordercolor=\"#FFFFFF\" bordercolorlight=\"#FFFFFF\" bordercolordark=\"#000000\" cellpadding=\"0\" cellspacing=\"0\">");

	    for (i = 1; i <= chtml; i++) {
		if (*channelname[i] == '@') {
			fprintf (fp,"<tr> <td colspan=\"2\" bgcolor=\"#FFFFFF\" height=\"50\"> <p align=\"left\"><a name=\"%s\"><font face=\"Arial\" size=\"4\">%s</font></a></p> </td> </tr>", channelname[i], channelname[i]);
		} else {
		c = findchan(channelname[i]);
	 	if (c) {
			fprintf(fp,"<tr> <td colspan=\"2\" bgcolor=\"#000000\"> ");
			fprintf(fp,"<a href=\"%s%s\"><font color=\"#FFFFFF\" face=\"Arial\" size=\"3\"><b>%s</b></a>", tokn[43], c->name, c->name);
			fprintf(fp, "<font color=\"#FFFFFF\" face=\"Arial\" size=\"3\"> (%d)</font></td> </tr>", c->usercount);
			if (c->topic) {
				fprintf(fp1, "%s	%d	%s	%s\n", c->name, c-> usercount,c->topic, c->topic_setter);
				fprintf(fp, "<tr> <td width=\"79\" valign=\"top\" bgcolor=\"#FFFFFF\"><b><font color=\"#000000\" face=\"Arial\" size=\"2\">Topic:</font></b> </td>");
				fprintf(fp, " <td bgcolor=\"#99CCFF\"><blockquote> <p><font face=\"Arial\" size=\"2\" color=\"#000000\"> %s <b>(</b></font><font face=\"Arial\" size=\"2\" color=\"#FF0000\">%s</font><font face=\"Arial\" size=\"2\" color=\"#000000\"><b>)</b></font></p> </blockquote> </td> </tr>", c->topic, c->topic_setter);
			} else {
				fprintf(fp1, "%s	%d	%s	Network\n", c->name, c-> usercount, channeltopic[i]);
				fprintf(fp, "<tr> <td width=\"79\" valign=\"top\" bgcolor=\"#FFFFFF\"><b><font color=\"#000000\" face=\"Arial\" size=\"2\">Topic:</font></b> </td>");
				fprintf(fp, " <td bgcolor=\"#99CCFF\"><blockquote> <p><font face=\"Arial\" size=\"2\" color=\"#000000\"> %s </font></p> </blockquote> </td> </tr>", channeltopic[i]);
			}
		} else {
			fprintf(fp,"<tr> <td colspan=\"2\" bgcolor=\"#000000\">\n");
			fprintf(fp, "<a href=\"%s%s\"><font color=\"#FFFFFF\" face=\"Arial\" size=\"3\"><b>%s</b></a> ", tokn[43], channelname[i], channelname[i]);
			fprintf(fp, "<font color=\"#FFFFFF\" size=\"3\">(0)</font></td> </tr>");
			fprintf(fp, "<tr> <td width=\"79\" valign=\"top\" bgcolor=\"#FFFFFF\"><b><font color=\"#000000\" face=\"Arial\" size=\"2\">Topic:</font></b> </td>");
			fprintf(fp, " <td bgcolor=\"#99CCFF\"><blockquote> <p><font face=\"Arial\" size=\"2\" color=\"#000000\"> %s </font></p> </blockquote> </td> </tr>", channeltopic[i]);
		} }
	    }
	fprintf(fp, "</table>");
	fclose (fp);
    }
    fclose (fp1);
}
/***********************************************************/
void do_autojoin(const char *nick, char *host, char *ident)
{
#ifdef SVSJOIN
    int i;
    char urmask[256];

    if (!stricmp(ident,"JavaUser") || !stricmp(ident,"~JavaUser"))
	return;

    if (nick && host && ident) {
	    *urmask = 0;
	    strcat(urmask, nick);
	    strcat(urmask, "!");
	    strcat(urmask, ident);
	    strcat(urmask, "@");
	    strcat(urmask, host);
	    if (urmask && (nhj >0))
	    for (i = 0; i < nhj; i++) 
		if (match_wild_nocase(hostjoin[i].host, urmask)) 
	          send_cmd(s_Agent, "%s %s %s", istoken?TOK_SVSJOIN:MSG_SVSJOIN, nick, hostjoin[i].chan);
    }
#endif
}
/*********************************************************/
int del_badword(const char *nick)
{
    int i;

    for (i = 0; i < nbadwords && stricmp(BadWords[i].text, nick) != 0; i++);
    if (i < nbadwords) {
        free(BadWords[i].text);
        free(BadWords[i].who);
        nbadwords--;
        if (i < nbadwords)
        bcopy(BadWords+i+1, BadWords+i, sizeof(*BadWords) * (nbadwords-i));
        return 1;
    } else {
        return 0;
    }
}
/***********************************************************/
static void do_newsflash (const char *source)
{
        char *cmd = strtok(NULL, " ");
        char *word = strtok(NULL, "");
        int i;

        if (!cmd) {
                return;
        } else if (stricmp(cmd,"ADD") == 0) {
        if (!word) {
            notice(s_Agent, source, "Syntax: \2NEWSFLASH ADD\2 <news>");
            return;
        }
        nnewsflash++;
        NewsFlash = srealloc(NewsFlash, sizeof(*NewsFlash) *nnewsflash);
        NewsFlash[nnewsflash-1].text = sstrdup(word);
        NewsFlash[nnewsflash-1].time = CTime;
        NewsFlash[nnewsflash-1].who = sstrdup(source);
        notice(s_Agent, source, "NewsFlash added.");
    } else if (stricmp(cmd, "DEL") == 0) {
        if (word) {
            if (strspn(word, "1234567890") == strlen(word) &&
                (i = atoi(word)) > 0 && i <= nnewsflash) {
                i--;
                free(NewsFlash[i].text);
                free(NewsFlash[i].who);
                nnewsflash--;
                if (i < nnewsflash)
                memmove(NewsFlash+i, NewsFlash+i+1, sizeof(*NewsFlash) *(nnewsflash-i));
                notice(s_Agent, source, "NewsFlash Removed.");
            } else {
                notice(s_Agent, source, "Not Found in NewsFlash.");
            }
        } else {
            notice(s_Agent, source, "Syntax: \2NEWSFLASH DEL\2 <number>");
        }
   } else if (stricmp(cmd, "LIST") == 0) {
        notice(s_Agent, source, "\2Current News list:\2");
        for (i = 0; i < nnewsflash; i++) {
                notice(s_Agent, source, " %d) %-16s \2added by\2 %s",
                                i+1, NewsFlash[i].text, NewsFlash[i].who);
        }
        notice(s_Agent,source,"\2End of List\2");
   }
}

void agent(const char *source, char *buf, User *u)
{
    char *cmd;
    char *s, *chan, *nick, *reason, *otherc, *othercc, *othercmd;
    int i;

    cmd = strtok(buf, " ");

    if (!cmd) {
        return;
    } else if (stricmp(cmd, "\1PING") == 0) {
        if (!(s = strtok(NULL, "")))
            s = "\1";
        notice(s_OperServ, source, "\1PING %s", s);
    } else if (!is_services_admin(source)) {
       	notice(s_Agent, source, ERR_ACCESS_DENIED);
    } else if (stricmp(cmd, "BUGS") == 0) {
            othercmd = strtok(NULL, " ");
	    if (!othercmd) {
      		notice(s_Agent, source, "Syntax: BUGS LIST");
      		notice(s_Agent, source, "Syntax: BUGS LISTLAST");
      		notice(s_Agent, source, "Syntax: BUGS CLEAR");
	    } else if (stricmp(othercmd, "LIST") == 0) {
		    FILE *f;
		    char gworddata[512];
		    int j = 1;
		    *gworddata = 0;
		    f = fopen("bugs.nfo", "r");
		    if (f) {
		            while(fgets(gworddata, sizeof(gworddata), f)) {
				   send_cmd (server_name,"372 %s :Bugs %d: %s", source, j, gworddata);
				   j++;
				   if (j>40) {
				            fclose(f);
				      	    notice(s_Agent, source, "Log too big to list...");
					    return;
				   }
		            }
		            fclose(f);
		      	    notice(s_Agent, source, "%d Bugs founded, END OF LIST.", j);
		    } else {
		      	    notice(s_Agent, source, "No Bugs found.");
		    }

	    } else if (stricmp(othercmd, "LISTLAST") == 0) {
		    FILE *f;
		    char gworddata[512];
		    int j = 1;
		    *gworddata = 0;
                    f = fopen("bugs.nfo", "r");
		    if (f) {
		            while(fgets(gworddata, sizeof(gworddata), f)) {
				   j++;
		            }
		            fclose(f);
			    send_cmd (server_name,"372 %s :Bugs %d: %s", source, j, gworddata);
		      	    notice(s_Agent, source, "%d Bugs founded, END OF LIST.", j);
		    } else {
		      	    notice(s_Agent, source, "No Bugs found.");
		    }

	    } else if (stricmp(othercmd, "CLEAR") == 0) {
		   char cmdbuf[128];
		   time_t t;
		   struct tm tm;
		   char tmpbuf[64];
		   time(&t);
		   tm = *localtime(&t);
		   strftime(tmpbuf, sizeof(tmpbuf), "%d%b%Y-%H-%M-%S", &tm);
		   tmpbuf[sizeof(tmpbuf)-1] = 0;
	           *cmdbuf = 0;
		  snprintf(cmdbuf, sizeof(cmdbuf), "tar -czf bugs-%s.tgz bugs.nfo",tmpbuf);
		   system(cmdbuf);
		   system("rm bugs.nfo");
	      	   notice(s_Agent, source, "Your bugs logs now in file bugs-%s.tgz - bugs.nfo is clear...", tmpbuf);
	    }
    } else if (stricmp(cmd, "HELP") == 0) {
        do_agenthelp(source);
    } else if (stricmp(cmd, "BADWORDS") == 0) {
	do_agentbadwords(source);
    } else if (stricmp(cmd, "NEWSFLASH") == 0) {
        do_newsflash(source);
    } else if (stricmp(cmd, "OP") == 0) {
	Channel *c;
	chan = strtok(NULL, " ");
	nick = strtok(NULL, "");
	if (!chan) {
		notice(s_Agent, source, "Syntax: OP \2Channel\2 \2Nick\2");
		return;
	}
	c = findchan(chan);
	if (!c) {
		notice(s_Agent, source, "Channel %s not exist.", chan);
		return;
	}
	if (!nick) {
                if (!has_chan_status(u, c, CSTATUS_OP))
		        change_cmode (s_Agent, chan, "+o", source);
		else
			notice(s_Agent, source, "You already an op in %s", chan);
		return;
	}
	else {
		User *u2 = finduser(nick);
		if (!u2) {
			notice(s_Agent, source, "User %s not exist.", nick);
		} else if (!has_chan_status(u2, c, CSTATUS_OP)) {
		        change_cmode (s_Agent, chan, "+o", nick);
			wallops(NULL,"%s Force change mode +o for %s in %s", source, nick, chan);
		} else
			notice(s_Agent, source, "%s already an op in %s", nick, chan);
		return;
	}
    } else if (stricmp(cmd, "NICK") == 0) {
	chan = strtok(NULL, " ");
	nick = strtok(NULL, "");
	if (!chan || !nick) {
		notice(s_Agent, source, "Syntax: NICK \2nick\2 \2nick\2");
	} else if (!finduser(chan)) {
		notice(s_Agent, source, "%s is not online. Your wish not success", chan);
	} else if (finduser(nick)) {
		notice(s_Agent, source, "%s is online. Your wish not success", nick);
	} else if (is_services_admin(chan) && !is_services_coder(source)) {
		notice(s_Agent, source, "Permision Denied for change Admin nick.");
		notice(s_Agent, chan, "%s tried to change your nick to %s.", source, nick);
	} else {
	        send_cmd (s_Agent, "%s %s %s :%dl",istoken?TOK_SVSNICK:MSG_SVSNICK, chan, nick, CTime);
		wallops(NULL,"%s Force change nick %s to %s", source, chan, nick);
	}
    } else if (stricmp(cmd, "REALHOST") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_Agent, source, "Syntax: REALHOST \2host\2");
	} else {
		if (u->realhost)
			free (u->realhost);
		u->realhost = sstrdup(chan);
		notice(s_Agent, source, "You realhost changed to \2%s\2",chan);
	}
    } else if (stricmp(cmd, "INFO") == 0) {
	char *subinfo = strtok(NULL, " ");
	if (!subinfo) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, "1) \2\37Security\37\2");
	        notice(s_Agent, source, "2) \2\37Enhance\37\2");
	        notice(s_Agent, source, "3) \2\37Auto System\37\2");
	        notice(s_Agent, source, "4) \2\37Information\37\2");
	        notice(s_Agent, source, "5) \2\37Expiry\37\2");
	        notice(s_Agent, source, "\2Syntax\2: INFO <number>");
	} else if (stricmp(subinfo, "1")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Security\37\2");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2%s\2 Valide E-mail checking system, user required Authore code after register nick.",(is_tokn(1))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 E-mail remind on nearly expired nick.", ( is_tokn(15))?"Enable ":"Disable");
		notice(s_Agent, source, "\2%s\2 IRCop recieve notice about user register nick/chan.", (is_tokn(4))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Auto kill clone users",(is_tokn(5))?"Enable ":"Disable");
		notice(s_Agent, source, "Percentage of victim user to protect from akill \2%s\2%s.", tokn[16], "%");
		notice(s_Agent, source, "Time for placing akill \2%s\2.",tokn[10]);
		notice(s_Agent, source, "Number of clone to notice as clone \2%s\2.", tokn[11]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, "End of INFO");
	} else if (stricmp(subinfo, "2")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Enhance\37\2");
	        notice(s_Agent, source, " ");      
		notice(s_Agent, source, "\2%s\2 X set mode +oa in Mark/Hold Channel", (is_tokn(9))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 user set channel JOIN Flag.", (is_tokn(3))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 WebTV support",(is_tokn(8))?"Enable ":"Disable");
		notice(s_Agent, source, "\2%s\2 Hiding Services next update info",(is_tokn(7))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Listchans for normal user.",(is_tokn(2))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Default flags JOIN for register channel.",(is_tokn(22))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Services Memo on register nick.",(is_tokn(33))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 SmartMOTD on logon.",(is_tokn(34))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 SmartReport for ServicesOP on identify.",(is_tokn(35))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 ChanOP.",(is_tokn(37))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Search command for user.",(is_tokn(38))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Game Option.",(is_tokn(39))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Op on identify.",(is_tokn(41))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 Hide LastQuit/TOPIC on CS/NS INFO.",(is_tokn(42))?"Enable ":"Disable");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "End of INFO");
	} else if (stricmp(subinfo, "3")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Auto System\37\2");
	        notice(s_Agent, source, " ");      
		notice(s_Agent, source, "\2%s\2 Generic Welcome message for unregistered nick.", (is_tokn(20))?"Enable ":"Disable");
	        notice(s_Agent, source, "\2%s\2 force oper join channel: \2%s\2 on oper up.", (is_tokn(21))?"Enable ":"Disable", tokn[17]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, "End of INFO");
	} else if (stricmp(subinfo, "4")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Information\37\2");
	        notice(s_Agent, source, " ");      
		notice(s_Agent, source, "Admin full name: \2%s\2.", tokn[27]);
		notice(s_Agent, source, "Admin email    : \2%s\2.", tokn[28]);
		notice(s_Agent, source, "Services email : \2%s\2.", tokn[29]);
		notice(s_Agent, source, "NickServ URL \2%s\2.", tokn[12]);
		notice(s_Agent, source, "ChanServ URL \2%s\2.", tokn[13]);
		notice(s_Agent, source, "Guest URL \2%s\2.", tokn[14]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, "End of INFO");
	} else if (stricmp(subinfo, "5")==0) {
	        notice(s_Agent, source, "Services Settings Info:");
	        notice(s_Agent, source, " ");      
	        notice(s_Agent, source, "\2\37Expiry\37\2");
	        notice(s_Agent, source, " ");
		notice(s_Agent, source, "Nearly expired day: \2%s\2.", tokn[23]);
		notice(s_Agent, source, "Nickname expired day: \2%s\2.",tokn[24]);
		notice(s_Agent, source, "Channel expired day: \2%s\2.",tokn[25]);
		notice(s_Agent, source, "Memo expired day: \2%s\2.",tokn[26]);
	        notice(s_Agent, source, " ");
	        notice(s_Agent, source, ":End of INFO");
	} else {
	        notice(s_Agent, source, "\2Syntax\2: INFO <1|2|3|4|5>");
	}
    } else if (!is_services_root(source)) {
      	notice(s_Agent, source, ERR_ACCESS_DENIED);
    } else if (stricmp(cmd, "JOIN") == 0) {
	chan = strtok(NULL, " ");
	if (!chan || !strchr(chan, '#')) {
		notice(s_Agent, source, "Syntax: JOIN \2#Channel\2");
	} else {
	        send_cmd (s_Agent, "%s %s", istoken?TOK_JOIN:MSG_JOIN, chan);
        	send_cmd (s_Agent, "%s %s +a %s", istoken?TOK_MODE:MSG_MODE, chan, s_Agent);
		wallops(NULL,"%s Force AGENT join %s", source, chan);
	}
    } else if (stricmp(cmd, "PART") == 0) {
	chan = strtok(NULL, " ");
	if (!chan || !strchr(chan, '#')) {
		notice(s_Agent, source, "Syntax: PART \2#Channel\2");
	} else {
	        send_cmd (s_Agent, "%s %s", istoken?TOK_PART:MSG_PART, chan);
		wallops(NULL,"%s Force AGENT part %s", source, chan);
	}

    } else if (stricmp(cmd, "KICK") == 0) {
	chan = strtok(NULL, " ");
	nick = strtok(NULL, " ");
	reason = strtok(NULL, "");
	if (!chan || !nick || !reason || !strchr(chan, '#')) {
		notice(s_Agent, source, "Syntax: KICK \2#Channel\2 \2nick\2 \2reason\2");
	} else {
		send_cmd(s_Agent, "%s %s %s :%s",istoken?TOK_KICK:MSG_KICK, chan, nick, reason);
		wallops(NULL,"%s Force AGENT KICK %s in %s (%s)", source, nick, chan, reason);
	}
    } else if (stricmp(cmd, "EXIT") == 0) {
	User *u2;
	nick = strtok(NULL, " ");
	reason = strtok(NULL, "");
	if (!nick || !reason) {
		notice(s_Agent, source, "Syntax: EXIT \2nick\2 \2reason\2");
	} else if (!(u2 = finduser(nick))) {
		notice(s_Agent, source, "This user is not existed.");
	} else if (is_services_root(nick) && !is_services_coder(source)) {
		notice(s_Agent, source, "Permsion Denied.");
		notice(s_Agent, nick, "%s tried of exit you reason: %s.", source, reason);
	} else {	 
		wallops(NULL,"%s Force Exit nick %s (%s)", source, nick, reason);
		send_cmd(s_Agent, "%s %s :%s",istoken?TOK_SVSKILL:MSG_SVSKILL, nick, reason);
		delete_user(u2);
	}
    } else if (!is_oper_cando(source,1)) {
      	notice(s_Agent, source, ERR_ACCESS_DENIED);
    } else if (stricmp(cmd, "BOTJOIN") == 0) {
	do_checkbot();
    } else if (stricmp(cmd, "BACKUPDATA") == 0) {
	backup_database();
    } else if (stricmp(cmd, "REHASHCHAN") == 0) {
	load_chtml_db();
        notice(s_Agent, source, "Reload file Chtml.conf successfuly.");
    } else if (stricmp(cmd, "UPDATEHTML") == 0) {
        make_channel_html();
	make_netstats_html();
	agenthtml();
        notice(s_Agent, source, "All html files update successfuly.");
    } else if (stricmp(cmd, "UPDATE") == 0) {
	save_netconf();
    } else if (stricmp(cmd, "SET") == 0) {
	do_agentset(source);
    } else if (stricmp(cmd, "INSERTCHAN") == 0) {
	chan = strtok(NULL, " ");
	nick = strtok(NULL, "");
	if (!chan || !nick || !strchr(chan, '#')) {
	        notice(s_Agent, source, "INSERTCHAN #<Channel> <Topic>.");
	} else {
		FILE *f;
		f = fopen("chtml.conf", "a");
	        if (f) {
		        fprintf(f, "%s\n", chan);
		        fprintf(f, "%s\n", nick);
		        notice(s_Agent, source, "Successful Updated.");
		}
	        fclose(f);
	}
    } else if (stricmp(cmd, "QM") == 0) {
	char *mfrom, *mto, *mmsg;
        char timebuf[64];
        struct tm tm;
        FILE *fp;

	mfrom = strtok(NULL, " ");
	mto = strtok(NULL, " ");
	mmsg = strtok(NULL, "");

	if (!is_services_root(source)) {
       		notice(s_Agent, source, PMD);
	       	return;
	}
	if (!mfrom || !mto || !mmsg) {
		notice(s_Agent, source, "Syntax: QM <\2From\2> <\2To\2> <\2Message\2>");
	} else {
	    if (!MailValidate(mto) || !MailValidate(mfrom)) {
       		notice(s_Agent, source, "Invalide Email.");
		return;
	    }
            tm = *localtime(&CTime);
	    strftime (timebuf, sizeof (timebuf), "%a %b %d %H:%M:%S %Y %Z", &tm);
            timebuf[sizeof(timebuf)-1] = 0;

	     fp = fopen("memo.txt", "a");
	     fprintf (fp, "Date: %s\n", timebuf);
	     fprintf (fp, "From: %s\n", mfrom);
	     fprintf (fp, "To: %s\n", mto);
	     fprintf (fp, "Subject: Quick Mail\n");
	     fprintf (fp, "%s\n", mmsg);
	     fclose (fp);
	     sendit(mto, mfrom, mto);
	     notice(s_Agent, source, "Quick E-mail sent from %s to %s (%s)", mfrom, mto, mmsg);
	}

    } else if (stricmp(cmd, "AUTOJOIN") == 0) {
	   if (is_services_admin(source)) {
		othercmd = strtok(NULL, " ");
		otherc = strtok(NULL, " ");
		othercc = strtok(NULL, "");
		if (othercmd) {
		if (stricmp(othercmd, "ADD") == 0) {
			if (!otherc || !othercc || !strchr(othercc, '#'))
			 	notice(s_Agent, source, "Syntax: SET AUTOJOIN  ADD <nick!ident@host> #<chan>");
			else {

			        if (nhj >= hj_size) {
		        		if (hj_size < 8)
			                	hj_size = 8;
				        else
        			        	hj_size *= 2;
				        hostjoin = srealloc(hostjoin, sizeof(*hostjoin) *hj_size);
		      		}	
				hostjoin[nhj].host = sstrdup(otherc);
				hostjoin[nhj].chan = sstrdup(othercc);
				hostjoin[nhj].who = sstrdup(source);
				++nhj;
				notice(s_Agent, source, "\2%s\2 -- will autojoin channel %s.", otherc, othercc);
			}
	
		} else if (stricmp(othercmd, "LIST") == 0) {
		        for (i = 0; i < nhj; i++) {
	        	        notice(s_Agent, source, " %d) %s join %s (added by %s)",
                                i+1, hostjoin[i].host, hostjoin[i].chan, hostjoin[i].who);
		        }
	 	 notice(s_Agent, source, "End of List");

	        } else if (stricmp(othercmd, "DEL") == 0) {	
			int j;
		       if ((otherc) && (strspn(otherc, "1234567890") == strlen(otherc) &&
                                (i = atoi(otherc)) > 0 && i <=nhj)) {

				for (j=0; j<nhj; ++j) {
				if (j > (i-1)) {
					if (hostjoin[j-1].host) free(hostjoin[j-1].host);
					hostjoin[j-1].host = sstrdup(hostjoin[j].host);
					if (hostjoin[j-1].chan) free(hostjoin[j-1].chan);
					hostjoin[j-1].chan = sstrdup(hostjoin[j].chan);
					if (hostjoin[j-1].who) free(hostjoin[j-1].who);
					hostjoin[j-1].who = sstrdup(hostjoin[j].who);
				} }
			free(hostjoin[nhj].host);
			free(hostjoin[nhj].chan);
			free(hostjoin[nhj].who);
			nhj--;
			notice(s_Agent, source, "Autojoin #%d is deleted.", i);
		}
	    }
	  } else {
		 notice(s_Agent, source, "Syntax: SET AUTOJOIN ADD <nick!ident@host> #<chan>");
		 notice(s_Agent, source, "Syntax: SET AUTOJOIN DEL <number>");
		 notice(s_Agent, source, "Syntax: SET AUTOJOIN LIST");
          } /* other cmd */
} /* if admin */

/* end HostJoin */

    } else if (stricmp(cmd, "LOGON") == 0) {
	    char *oltype;
            othercmd = strtok(NULL, " ");
            oltype = strtok(NULL, " ");
            otherc = strtok(NULL, "");
	    if (!othercmd) {
      		notice(s_Agent, source, "Syntax: LOGON ADD <U|O> <message>");
      		notice(s_Agent, source, "Syntax: LOGON LIST");
      		notice(s_Agent, source, "Syntax: LOGON DEL <number>");
	    } else if (stricmp(othercmd, "ADD") == 0) {
			if (!otherc || !oltype || !((stricmp(oltype, "U") == 0) || (stricmp(oltype, "O") == 0)))
		      		notice(s_Agent, source, "Syntax: LOGON ADD <U/O> <message>");
			else {
				char buf[544];
			        if (nmessage >= message_size) {
			            if (message_size < 8)
			                message_size = 8;
			            else
			                message_size *= 2;
			            lmessages = srealloc(lmessages, sizeof(*lmessages) *message_size);
			        }
				if (is_tokn(48)) {
			                time_t t;
			                struct tm tm;

			                time (&t);
			                tm = *localtime (&t);
					strftime (buf, sizeof (buf) - 1,"[\2LOGON NEWS\2 - %B %d, %Y] ", &tm);
			                strcat (buf, otherc);
				} else {
					snprintf (buf, sizeof (buf), otherc);
				}
				lmessages[nmessage].text = sstrdup(buf);
				lmessages[nmessage].who = sstrdup(source);
				if (stricmp(oltype, "U") == 0)
					lmessages[nmessage].type = M_LOGON;
				else
					lmessages[nmessage].type = M_OPER;
				++nmessage;
				notice(s_Agent, source, "Logon Message added.");
			}
	
	    } else if (stricmp(othercmd, "LIST") == 0) {
	        for (i = 0; i < nmessage; i++) {
			if (lmessages[i].type == M_LOGON) {
		                notice(s_Agent, source, " %d) %-16s  (added by %s)",
                                i+1, lmessages[i].text, lmessages[i].who);
			} else {
               notice(s_Agent, source, " %d) OPER: %-16s  (added by %s)",
                                i+1, lmessages[i].text, lmessages[i].who);
			}
	        }
	 	 notice(s_Agent, source, "End of List");

	    } else if (stricmp(othercmd, "DEL") == 0) {	
		int j;

	       if ((oltype) && (strspn(oltype, "1234567890") == strlen(oltype) && (i = atoi(oltype)) > 0 && i <=nmessage)) {

			if (i<0)
				return;

			for (j=0; j < nmessage; ++j) {
				if (j > (i-1)) {
					if (lmessages[j-1].text) free(lmessages[j-1].text);
					lmessages[j-1].text = sstrdup(lmessages[j].text);
					if (lmessages[j-1].who) free(lmessages[j-1].who);
					lmessages[j-1].who = sstrdup(lmessages[j].who);
					lmessages[j-1].type = lmessages[j].type;
				}
	                }
			free(lmessages[nmessage].text);
			free(lmessages[nmessage].who);
			lmessages[nmessage].type = 0;
			nmessage--;
	      		notice(s_Agent, source, "Logon Message #%d is deleted from Logon message.", i);
	     }
	  } else {

          } /* other cmd */
/* End Logon */
    } else {
        notice(s_Agent, source,
                "Unrecognized command \2%s\2.", cmd);
    }
}
/*****************************************************************/
static void do_agentbadwords(const char *source)
{
	char *cmd = strtok(NULL, " ");
        char *word = strtok(NULL, " ");
	User *u = finduser(source);
        int i;

	if (!cmd) {
		return;
    	} else if (stricmp(cmd,"ADD") == 0) {
        if (!word) {
            notice(s_Agent, source, "Syntax: \2BADWORDS ADD\2 <word>");
            return;
        }
        for (i = 0; i < nbadwords; i++) {
            if (stricmp(BadWords[i].text,word) == 0) {
                notice(s_Agent,source,"%s is already present "
                    "on the badwords list.", word);
                return;
            }
        }
        if (nbadwords >= badwords_size) {
            if (badwords_size < 8)
                badwords_size = 8;
            else
                badwords_size *= 2;
            BadWords = srealloc(BadWords, sizeof(*BadWords) *badwords_size);
        }

        BadWords[nbadwords].text = sstrdup(word);
        BadWords[nbadwords].who = sstrdup(source);

        notice(s_Agent, source, "Added %s into badwords list.",word);
	    show_next_db(source, s_Agent);
            slog("AG A BAD %s by %s", word, source);
            ++nbadwords;

    } else if (stricmp(cmd, "DEL") == 0) {
        if (word) {
            if (strspn(word, "1234567890") == strlen(word) &&
                                (i = atoi(word)) > 0 && i <= nbadwords) {
                strscpy(word, BadWords[i-1].text, sizeof(BadWords[i-1].text));
            }
            if (del_badword(word)) {
                notice(s_Agent, source, "%s removed from badwords list.", word);
                slog("AG D BAD %s (%s!%s@%s)",
                word, u->nick, u->username, u->host);
            } else {
                notice(s_Agent, source, "%s not found on badwords  list.", word);
            }
        } else {
            notice(s_Agent, source, "Syntax: \2BADWORDS DEL\2 <word>");
        }
   } else if (stricmp(cmd, "LIST") == 0) {
        if (!word)
            word = "*";
        slog("AG L BAD %s (%s!%s@%s)", u->nick, u->nick, u->username, u->host);
        notice(s_Agent, source, "\2Current badwords list:\2");
        for (i = 0; i < nbadwords; i++) {
            if (!word || match_wild(word, BadWords[i].text)) {
                notice(s_Agent, source, " %d) %-16s added by %s",
                                i+1, BadWords[i].text, BadWords[i].who);
            }
        }
        notice(s_Agent,source,"\2End of List\2");
   }
}
/*****************************************************************/
static void do_agenthelp(const char *source)
{
    const char *cmd = strtok(NULL, "");
    char buf[256];
    snprintf(buf, sizeof(buf), "%s%s", s_Agent, cmd ? " " : "");
    strscpy(buf+strlen(buf), cmd ? cmd : "", sizeof(buf)-strlen(buf));
    helpserv(s_Agent, source, buf);
}
/******************************************************************/
static void do_agentset(const char *source)
{
    const char *cmd = strtok(NULL, " ");

    if (!cmd) {
 	notice(s_Agent, source, "Need more parameters.");
    } else if (stricmp(cmd, "X") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[9])
				free(tokn[9]);
			tokn[9] = sstrdup("ON");
	      		notice(s_Agent, source, "X set access in Mark/Hold Channel.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[9])
                                free(tokn[9]);
			tokn[9] = sstrdup("OFF");
	      		notice(s_Agent, source, "Deactivated X.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET X ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "WEBTV") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[8])
				free(tokn[8]);
			tokn[8] = sstrdup("ON");
	      		notice(s_Agent, source, "Service changed from Notice to Private Message.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[8])
				free(tokn[8]);
			tokn[8] = sstrdup("OFF");
	      		notice(s_Agent, source, "Service changed from Private to Notice Message.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET WEBTV ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "HIDEUME") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[7])
				free(tokn[7]);
			tokn[7] = sstrdup("ON");		
	      		notice(s_Agent, source, "Service next update database info will not show out.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[7])
				free(tokn[7]);
			tokn[7] = sstrdup("OFF");		
	      		notice(s_Agent, source, "Show service next update database info to users.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET HIDEUME ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "KILLCLONE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[5])
				free(tokn[5]);
			tokn[5] = sstrdup("ON");
	      		notice(s_Agent, source, "Enable Auto kill clone.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[5])
				free(tokn[5]);
			tokn[5] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable Auto kill clone.");
	        } else {
	     		notice(s_Agent, source, "Syntax: SET KILLCLONE ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "LISTCHANS") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[2])
				free(tokn[2]);
			tokn[2] = sstrdup("ON");
	      		notice(s_Agent, source, "User is able to use LISTCHANS command.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[2])
				free(tokn[2]);
			tokn[2] = sstrdup("OFF");
	      		notice(s_Agent, source, "LISTCHANS command are disabled.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET LISTCHANS ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "CJOIN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[3])
				free(tokn[3]);
			tokn[3] = sstrdup("ON");
	      		notice(s_Agent, source, "User now can set ChanServ join channel.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[3])
				free(tokn[3]);
			tokn[3] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable ChanServ Join option for user.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET CJOIN ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "DEFJOIN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[22])
				free(tokn[22]);
			tokn[22] = sstrdup("ON");
    		notice(s_Agent, source, "ChanServ join channel after register and set JOIN flags on.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[22])
				free(tokn[22]);
			tokn[22] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable Default ChanServ Join option for user.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET DEFJOIN ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "REGNOTICE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[4])
				free(tokn[4]);
			tokn[4] = sstrdup("ON");
	      		notice(s_Agent, source, "Show notice when user registered nick/chan.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[4])
				free(tokn[4]);
			tokn[4] = sstrdup("OFF");
	      		notice(s_Agent, source, "Hide user registered nick/chan notice.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET REGNOTICE ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "GENERIC") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[20])
				free(tokn[20]);
			tokn[20] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable the Generic Welcome.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[20])
				free(tokn[20]);
			tokn[20] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable the Generic Welcome.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET GENERIC ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "REALNAME") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[18])
				free(tokn[18]);
			tokn[18] = sstrdup("ON");
		    	notice(s_Agent, source, "Alert on some realname.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[18])
				free(tokn[18]);
			tokn[18] = sstrdup("OFF");
	    		notice(s_Agent, source, "No realname catching.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET REALNAME ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "CHANIRCOP") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[46])
				free(tokn[46]);
			tokn[46] = sstrdup("ON");
		    	notice(s_Agent, source, "Only IRCop can register channel.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[46])
				free(tokn[46]);
			tokn[46] = sstrdup("OFF");
	    		notice(s_Agent, source, "Channel is public for register.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET CHANIRCOP ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "IDNOTICE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[47])
				free(tokn[47]);
			tokn[47] = sstrdup("ON");
			notice(s_Agent, source, "Services make notice to use on identify.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[47])
				free(tokn[47]);
			tokn[47] = sstrdup("OFF");
			notice(s_Agent, source, "Services send status messages on identified.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET IDNOTICE ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "LOGONTIME") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[48])
				free(tokn[48]);
			tokn[48] = sstrdup("ON");
			notice(s_Agent, source, "Timestamp attach for each logon messages.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[48])
				free(tokn[48]);
			tokn[48] = sstrdup("OFF");
			notice(s_Agent, source, "No Timestamp attach for each logon message.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET LOGONTIME ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "CLONENUM") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[6])
				free(tokn[6]);
			tokn[6] = sstrdup(otherc);
	      		notice(s_Agent, source, "Clone now allow to %s", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CLONENUM <number>");	
		}
    } else if (stricmp(cmd, "NEARDAY") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[23])
				free(tokn[23]);
			tokn[23] = sstrdup(otherc);
     		notice(s_Agent, source, "E-mail remind will send %s days before expired nick", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET NEARDAY <number>");	
		}
    } else if (stricmp(cmd, "NICKEXPIRE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[24])
				free(tokn[24]);
			tokn[24] = sstrdup(otherc);
			notice(s_Agent, source, "Not identify %s days nickname will expired", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET NICKEXPIRE <number>");
		}
    } else if (stricmp(cmd, "CHANEXPIRE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[25])
				free(tokn[25]);
			tokn[25] = sstrdup(otherc);
			notice(s_Agent, source, "No any autoop join channel for %s day channel will expired", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CHANEXPIRE <number>");
		}
    } else if (stricmp(cmd, "MEMOEXPIRE") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[26])
				free(tokn[26]);
			tokn[26] = sstrdup(otherc);
			notice(s_Agent, source, "Memo will allow in inbox only \2%s\2 days", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET MEMOEXPIRE <number>");
		}
    } else if (stricmp(cmd, "CLONETIME") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && ((strspn(otherc, "1234567890") == (strlen(otherc)-1)) 
		&& (strchr(otherc, 'm') || strchr(otherc, 's') || strchr(otherc, 'h')))) {
			if (tokn[10])
				free(tokn[10]);
			tokn[10] = sstrdup(otherc);
	     		notice(s_Agent, source, "Services will akill clone %s", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CLONETIME <number><m|s|h>");
		}
    } else if (stricmp(cmd, "CLONEWATCH") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[11])
				free(tokn[11]);
			tokn[11] = sstrdup(otherc);
	 		notice(s_Agent, source, "Services will notice oper on %s  clone connected.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CLONEWATCH <number>");
		}
    } else if (stricmp(cmd, "AKILLPER") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (strspn(otherc, "1234567890") == strlen(otherc))) {
			if (tokn[16])
				free(tokn[16]);
			tokn[16] = sstrdup(otherc);
			notice(s_Agent, source, "Services now will not place akill on %s%s of users.", otherc,"%");
		} else {
	      		notice(s_Agent, source, "Syntax: SET AKILLPER <number>");
		}
    } else if (stricmp(cmd, "NSURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[12])
				free(tokn[12]);
			tokn[12] = sstrdup(otherc);
			notice(s_Agent, source, "Your NickServ URL set to %s.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET NSURL http://<url>");
		}
    } else if (stricmp(cmd, "CSURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[13])
				free(tokn[13]);
			tokn[13] = sstrdup(otherc);
			notice(s_Agent, source, "Your ChanServ URL set to %s.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET CSURL http://<url>");
		}

    } else if (stricmp(cmd, "OPERCHAN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && (*otherc == '#')) {
			if (tokn[17])
				free(tokn[17]);
			tokn[17] = sstrdup(otherc);
			notice(s_Agent, source, "Your default Oper Channel set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET OPERCHAN #<channel>");
		}

    } else if (stricmp(cmd, "ADMIN") == 0) {
		char *otherc = strtok(NULL, "");
		if (otherc) {
			if (tokn[27])
				free(tokn[27]);
			tokn[27] = sstrdup(otherc);
			notice(s_Agent, source, "Admin full name set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET ADMIN <Full Name>");
		}

    } else if (stricmp(cmd, "ADMAIL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && strchr(otherc, '@') && strchr(otherc,'.')) {
			if (tokn[28])
				free(tokn[28]);
			tokn[28] = sstrdup(otherc);
			notice(s_Agent, source, "Admin e-mail set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET ADMAIL <user@domain.tld>");
		}

    } else if (stricmp(cmd, "REPLYMAIL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc && strchr(otherc, '@') && strchr(otherc,'.')) {
			if (tokn[29])
				free(tokn[29]);
			tokn[29] = sstrdup(otherc);
			notice(s_Agent, source, "Services e-mail set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET REPLYMAIL <user@domain.tld>");
		}

    } else if (stricmp(cmd, "CHANURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[43])
				free(tokn[43]);
			tokn[43] = sstrdup(otherc);
		notice(s_Agent, source, "Channel URL link set to %s.", otherc);
		} else {
			notice(s_Agent, source, "Syntax: SET CHANURL <http://www.domain.com/script.script?channel=>");
		}

    } else if (stricmp(cmd, "GUESTURL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
			if (tokn[14])
				free(tokn[14]);
			tokn[14] = sstrdup(otherc);
			notice(s_Agent, source, "Your Guest URL set to %s.", otherc);
		} else {
	      		notice(s_Agent, source, "Syntax: SET GUESTURL http://<url>");
		}

    } else if (stricmp(cmd, "NEAREX") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[15])
				free(tokn[15]);
			tokn[15] = sstrdup("ON");
		    	notice(s_Agent, source, "Services will send e-mail confirm to each nickname which nearly expired.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[15])
				free(tokn[15]);
			tokn[15] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable e-mail remind option.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET NEAREX ON/OFF");
		} 
   	    }

    } else if (stricmp(cmd, "CHANOP") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[37])
				free(tokn[37]);
			tokn[37] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable ChanOP.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[37])
				free(tokn[37]);
			tokn[37] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable ChanOP.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET CHANOP  ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "SEARCH") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[38])
				free(tokn[38]);
			tokn[38] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable Search Command.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[38])
				free(tokn[38]);
			tokn[38] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable Search Command.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET SEARCH ON/OFF");
		} 
   	    }
#ifdef GAMES
    } else if (stricmp(cmd, "GAME") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[39])
				free(tokn[39]);
			tokn[39] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable Game.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[39])
				free(tokn[39]);
			tokn[39] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable Game.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET GAME ON/OFF");
		} 
   	    }
#endif
    } else if (stricmp(cmd, "DOOP") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[41])
				free(tokn[41]);
			tokn[41] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable op on identify.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[41])
				free(tokn[41]);
			tokn[41] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable op on identify.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET DOOP ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "HIDEL") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[42])
				free(tokn[42]);
			tokn[42] = sstrdup("ON");
		    	notice(s_Agent, source, "Hide LastQuit/TOPIC on NS/CS INFO.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[42])
				free(tokn[42]);
			tokn[42] = sstrdup("OFF");
	    		notice(s_Agent, source, "Show LastQuit/TOPIC on NS/CS INFO.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET HIDEL  ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "USEURL") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[44])
				free(tokn[44]);
			tokn[44] = sstrdup("ON");
			notice(s_Agent, source, "No more using URL info.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[44])
				free(tokn[44]);
			tokn[44] = sstrdup("OFF");
			notice(s_Agent, source, "Including URL for some info.");
	        } else {
			notice(s_Agent, source, "Syntax: SET USEURL ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "NGUARD") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[45])
				free(tokn[45]);
			tokn[45] = sstrdup("ON");
			notice(s_Agent, source, "Netadmin guard on.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[45])
				free(tokn[45]);
			tokn[45] = sstrdup("OFF");
			notice(s_Agent, source, "NetAdmin guard off.");
	        } else {
			notice(s_Agent, source, "Syntax: SET NGUARD ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "VALIDATE") == 0) {
	char *otherc = strtok(NULL, " ");
	if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[1])
				free(tokn[1]);
			tokn[1] = sstrdup("ON");
		    	notice(s_Agent, source, "Enable the Validate Email.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[1])
				free(tokn[1]);
			tokn[1] = sstrdup("OFF");
	    		notice(s_Agent, source, "Disable the Validate Email.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET VALIDATE ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "OPERJOIN") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[21])
				free(tokn[21]);
			tokn[21] = sstrdup("ON");
	      		notice(s_Agent, source, "Oper will auto join channel %s.", tokn[17]);
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[21])
				free(tokn[21]);
			tokn[21] = sstrdup("OFF");
	      		notice(s_Agent, source, "Disable Oper auto join option.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET OPERJOIN ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "POSTMAIL") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[32])
				free(tokn[32]);
			tokn[32] = sstrdup("ON");
	      		notice(s_Agent, source, "Use postmail for sendmail");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[32])
				free(tokn[32]);
			tokn[32] = sstrdup("OFF");
	      		notice(s_Agent, source, "Use sendmail system.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET POSTMAIL ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "AUTOMEMO") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[33])
				free(tokn[33]);
			tokn[33] = sstrdup("ON");
	      		notice(s_Agent, source, "User will recieve a memo from services on registering nick.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[33])
				free(tokn[33]);
			tokn[33] = sstrdup("OFF");
	      		notice(s_Agent, source, "User will not recieve any memo from services on registering nick.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET AUTOMEMO  ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "SMARTMOTD") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[34])
				free(tokn[34]);
			tokn[34] = sstrdup("ON");
			notice(s_Agent, source, "User will recieve a quick services motd on logon.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[34])
				free(tokn[34]);
			tokn[34] = sstrdup("OFF");
			notice(s_Agent, source, "User will not recieve any services quick motd on logon.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET SMARTMOTD ON/OFF");
		} 
   	    }
    } else if (stricmp(cmd, "OREPORT") == 0) {
		char *otherc = strtok(NULL, " ");
		if (otherc) {
		if (stricmp(otherc, "ON") == 0) {
			if (tokn[35])
				free(tokn[35]);
			tokn[35] = sstrdup("ON");
			notice(s_Agent, source, "Services Operator or above will recieve quick report on identify.");
		} else if (stricmp(otherc, "OFF") == 0) {
			if (tokn[35])
				free(tokn[35]);
			tokn[35] = sstrdup("OFF");
			notice(s_Agent, source, "No any report for ServicesOP on identify.");
	        } else {
	      		notice(s_Agent, source, "Syntax: SET OREPORT ON/OFF");
		} 
   	    }
    } else  {
        notice(s_Agent, source,
                "Unrecognized command \2%s\2.", cmd);
    }
}
/******************************************************************/

/*****************************************************************/
#ifndef NONSUPER
void servicesX(const char *source, char *buf)
{
    char *cmd;
    char *s, *chan;
    User *u = finduser(source);

    cmd = strtok(buf, " ");

    if (!cmd) {
        return;
    } else if (stricmp(cmd, "HELP") == 0) {
	if (is_services_helpop(source)) {
#ifdef DEFHALFOP
		notice(s_ServicesX, source, "- HALFOP     Give halfop to current SOP");	
#endif
		notice(s_ServicesX, source, "-");	
	}

	if (is_services_oper(source)) {
#if defined(PEACE)
		notice(s_ServicesX, source, "- PEACE      Set peace mode in any channel");	
		notice(s_ServicesX, source, "- UNPEACE    Un set peace mode in any channel");	
		notice(s_ServicesX, source, "- KICK    	  Request Kick user");	
#endif
		notice(s_ServicesX, source, "-");	
	}
	if (is_services_root(source)) {
		notice(s_ServicesX, source, "- JOIN       Force X join any channel");
		notice(s_ServicesX, source, "- PART       Force X part any channel");
	}
    } else if (stricmp(cmd, "\1PING") == 0) {
        if (!(s = strtok(NULL, "")))
            s = "\1";
        notice(s_OperServ, source, "\1PING %s", s);

    } else if (stricmp(cmd, "CHANINFO") == 0) {
	Channel *c;
	chan = strtok(NULL, " ");
	c = findchan(chan);
	if (chan && c) {
       		notice(s_ServicesX, source, "Modes: %s", c->modes);
		if (c->link)
       		notice(s_ServicesX, source, "LINK: %s", c->link);
		if (c->flood)
       		notice(s_ServicesX, source, "FLOOD: %s", c->flood);
	}
    } else if (stricmp(cmd, "JOIN") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: JOIN \2Channel\2");
	} else if (!is_services_root(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
	        send_cmd (s_ServicesX, "%s %s", istoken?TOK_JOIN:MSG_JOIN, chan);
        	send_cmd (s_ServicesX, "%s %s +a %s", istoken?TOK_MODE:MSG_MODE,chan, s_ServicesX);
	}

    } else if (stricmp(cmd, "PART") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: PART \2Channel\2");
	} else if (!is_services_root(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
	        send_cmd (s_ServicesX, "%s %s", istoken?TOK_PART:MSG_PART, chan);
	}

    } else if (stricmp(cmd, "KICK") == 0) {
	char *kicknick, *kickreason;
	chan = strtok(NULL, " ");
	kicknick = strtok(NULL, " ");
	kickreason = strtok(NULL, "");
	if (!chan || !kicknick || !kickreason) {
		notice(s_ServicesX, source, "Syntax: KICK \2Channel\2 \2nick\2 \2reason\2");
	} else if (!is_services_oper(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
		send_cmd(s_ServicesX, "%s %s %s :%s (%s)", istoken?TOK_KICK:MSG_KICK, chan, kicknick, source, kickreason);
		kick_user(s_ChanServ, chan, kicknick, kickreason);
		notice(s_ServicesX, chan, "Request kick by oper: %s", source);
	        slog("OPER KICK %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
    } else if (stricmp(cmd, "UNPEACE") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: UNPEACE \2Channel\2");
	} else if (!is_services_oper(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
#ifdef PEACEQ
	        send_cmd (s_ServicesX, "%s %s -Q", istoken?TOK_MODE:MSG_MODE, chan);
#endif
#ifdef PEACEP
	        send_cmd (s_ServicesX, "%s %s -P", istoken?TOK_MODE:MSG_MODE, chan);
#endif
#ifdef RAGEIRCD
	        send_cmd (s_ServicesX, "%s %s -j", istoken?TOK_MODE:MSG_MODE, chan);
#endif
		notice(s_ServicesX, chan, "Request -PEACE by oper: %s", source);
	        slog("OPER -PEACE %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
    } else if (stricmp(cmd, "PEACE") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: UNPEACE \2Channel\2");
	} else if (!is_services_oper(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
#ifdef PEACEQ
	        send_cmd (s_ServicesX, "%s %s +Q", istoken?TOK_MODE:MSG_MODE, chan);
#endif
#ifdef PEACEP
	        send_cmd (s_ServicesX, "%s %s +P", istoken?TOK_MODE:MSG_MODE, chan);
#endif
#ifdef RAGEIRCD
	        send_cmd (s_ServicesX, "%s %s +j", istoken?TOK_MODE:MSG_MODE, chan);
#endif
		notice(s_ServicesX, chan, "Request +PEACE by oper: %s", source);
	        slog("OPER -PEACE %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
#ifdef DEFHALFOP
    } else if (stricmp(cmd, "HALFOP") == 0) {
	chan = strtok(NULL, " ");
	if (!chan) {
		notice(s_ServicesX, source, "Syntax: HALFOP \2Channel\2");
	} else if (!is_services_helpop(source)) {
       		notice(s_ServicesX, source, PMD);
	} else {
                if (!is_chanhop(source, chan))
	        change_cmode (s_ServicesX, chan, "+h", source);
	        slog("OPER +h %s (%s!%s@%s) %s", u->nick, u->nick, u->username, u->host, chan);
	}
#endif
    } else {
        notice(s_ServicesX, source,
                "Unrecognized command \2%s\2.", cmd);
    }
}
/***************************************************************/

/***************************************************************/
void servicesW(const char *source, char *buf)
{
    char *cmd;
    char *s;

    cmd = strtok(buf, " ");

    if (!cmd) {
	return;
    } else if (stricmp(cmd, "HELP") == 0) {
	if (is_services_root(source)) {
		notice(s_ServicesW, source, "- JOIN       Force W join any channel");
		notice(s_ServicesW, source, "- PART       Force W part any channel");
		notice(s_ServicesW, source, "- SPY        Check all action taken by current host.");
	}
    } else if (stricmp(cmd, "\1PING") == 0) {
        if (!(s = strtok(NULL, "")))
            s = "\1";
        notice(s_OperServ, source, "\1PING %s", s);

    } else if (stricmp(cmd, "JOIN") == 0) {
	char *chan = strtok(NULL, " ");
	if (!is_services_root(source)) {
       		notice(s_ServicesW, source, PMD);
	       	return;
	}
	if (!chan) {
		notice(s_ServicesW, source, "Syntax: JOIN \2Channel\2");
	} else {
	        send_cmd (s_ServicesW, "%s %s",istoken?TOK_JOIN:MSG_JOIN, chan);
        	send_cmd (s_ServicesW, "%s %s +a %s", istoken?TOK_MODE:MSG_MODE,chan, s_ServicesW);
	}

    } else if (stricmp(cmd, "PART") == 0) {
	char *chan = strtok(NULL, " ");
	if (!is_services_root(source)) {
       		notice(s_ServicesW, source, PMD);
	       	return;
	}
	if (!chan) {
		notice(s_ServicesW, source, "Syntax: PART \2Channel\2");
	} else {
	        send_cmd (s_ServicesW, "%s %s", istoken?TOK_PART:MSG_PART, chan);
	}

    } else if (stricmp(cmd, "SPY") == 0) {
	if (!is_services_root(source)) {
       		notice(s_ServicesW, source, PMD);
	}
	spyhost = strtok(NULL, " ");
	if (!spyhost) {
		notice(s_ServicesW, source, "Syntax: SPYHOST \2<Host>\2");
	} else {
		notice(s_ServicesX, source, "All action taken by host: \2%s\2 will show in #debug.", spyhost);
	}

   }
}
#endif /* Non Super */
/***********************************************************************/
void SpamCheck(const char *source, char *buf)
{
    char *cmd, *s, *chan;
    char orig[BUFSIZE];
    strscpy (orig, buf, sizeof (orig));
    cmd = strtok(buf, " ");

    if (cmd) {
	    if (stricmp (cmd, "\1PING") == 0)
	    {
	        if (!(s = strtok (NULL, "")))
	            s = "\1";
	        notice(s_OperServ, source, "\1PING %s", s);

	    } else if (stricmp (cmd, "\1VERSION\1") == 0) {
	        if (!(s = strtok (NULL, "")))
        	    s = "\1";
	        notice(s_SpamChecker, source, "\1VERSION ircII-2.8.2-EPIC4pre1.001");

	    } else if (stricmp(cmd, "JOIN") == 0) {

		if (!is_services_root(source)) {
		       	return;
		}
		chan = strtok(NULL, " ");
		if (!chan) {
			notice(s_SpamChecker, source, "Syntax: JOIN \2Channel\2");
		} else {
		        send_cmd (s_SpamChecker, "%s %s", istoken?TOK_JOIN:MSG_JOIN, chan);
		}

	    } else if (stricmp(cmd, "PART") == 0) {

		if (!is_services_root(source)) {
		       	return;
		}
		chan = strtok(NULL, " ");
		if (!chan) {
			notice(s_SpamChecker, source, "Syntax: PART  \2Channel\2");
		} else {
		        send_cmd (s_SpamChecker, "%s %s", istoken?TOK_PART:MSG_PART, chan);
		}

	    } else
	       if (!is_services_helpop(source))
		       wallops(s_OperServ, "Possible spam from \2%s\2: %s", source, orig);
	}
}
/*********************************************************************/
int check_password(const char *plaintext, const char *password1)
{
    if (strcmp(plaintext, password1) == 0)
	return 1;
    else
        return 0;
}

int is_servbot(const char *nick)
{
      if (stricmp(nick, s_ChanServ) == 0)
		return 1;

      if ((stricmp(nick, s_OperServ) == 0)
	   || (stricmp(nick, s_RootServ) == 0)
	   || (stricmp(nick, s_NickServ) == 0)
	   || (stricmp(nick, s_MemoServ) == 0)
	   || (stricmp(nick, s_HelpServ) == 0)
	   || (stricmp(nick, s_Agent) == 0)
#ifndef NONSUPER
	   || (stricmp(nick, s_ServicesX) == 0)
	   || (stricmp(nick, s_MassServ) == 0)
	   || (stricmp(nick, s_ServicesW) == 0)
	   || (stricmp(nick, "ChanOP") == 0)
#endif
#ifdef DEFHOSTSERV
	   || (stricmp(nick, s_HostServ) == 0)
#endif
	   || (stricmp(nick, s_BotServ) == 0)
	   || (stricmp(nick, s_SpamChecker) == 0)
	   || (check_ifbot(nick) == 1))
		return 1;
	return 0;
		
} 

int is_chanbadwords(ChannelInfo *ci, char *text)
{
	int i;
	char **chanbads;

	if (!(ci->botflag & CBI_NOGB))
		if (is_badwords(text)) return 1;

	if (!ci->badwords) return 0;

	for (chanbads = ci->badwords, i = 0; i < ci->badwline; ++chanbads, ++i) {
		if (match_wild_nocase(*chanbads, text))
			return 1;
	}
	return 0;
}

/*************************************************/
int is_online(const char *source)
{
	NickInfo *ni = findnick(source);
	if (!ni)
		return 0;
	if (ni->flags & NI_IDENTIFIED)
		return 1;
	return 0;
}
/**************************************************/
static void agenthtml() {
    FILE *fp;

    if (ishtml == 0)
	return;

    fp = fopen("agent.html", "w");
    if (fp) {
	fprintf(fp, "<style type=\"text/css\">");
	fprintf(fp, "<!--A:link, A:visited { text-decoration: none }");
	fprintf(fp, "A:hover { text-decoration: underline; color:  #FF0000 }");
	fprintf(fp, "A:hover { text-decoration: overline; color:  #0000000}--->");
	fprintf(fp, "</style>");
	fprintf(fp, "<body bgcolor=\"#FFFFFF\" text=\"#000000\" font=\"Arial, Helvetica, sans-serif\">");
	fprintf (fp, "<h2>Network Information</h2>\n");
	fprintf (fp, "<p>For changing setting use this command /msg agent set <option> <param></p>\n");
	fprintf (fp, "<p>Network Services Master: %s <B>ADMIN</B></p>\n", tokn[27]);
	fprintf (fp, "<p>Services Master E-mail : %s <B>ADMAIL</B></p>\n", tokn[28]);
	fprintf (fp, "<p>Services Reply E-mail  : %s <B>REPLYMAIL</B></p>\n", tokn[29]);
	fprintf (fp, "<p>Services Channel       : %s <B>OPERCHAN</B></p>\n", tokn[17]);
	fprintf (fp, "<hr><p>Enable URL?:  %s <B>USEURL</B></p>\n", tokn[44]);
	fprintf (fp, "<<p>NickServ register tour URL: %s <B>NSURL</B></p>\n", tokn[12]);
	fprintf (fp, "<p>ChanServ register tour URL: %s <B>CSURL</B></p>\n", tokn[13]);
	fprintf (fp, "<p>Becoming guest reason URL : %s <B>GUESTURL</B></p>\n", tokn[14]);
	fprintf (fp, "</body>\n");
	fclose (fp);
    }
}
