/* Main header for Services.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 *
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#ifndef SERVICES_H
#define SERVICES_H

/*************************************************************************/

#include "config.h"

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <time.h>
#include <errno.h>
#include <grp.h>
#include <limits.h>
#include <netdb.h>
#include <netinet/in.h>
#include <setjmp.h>
#include <sys/socket.h> 
#include <sys/stat.h>   /* for umask() on some systems */
#include <sys/types.h>
#include <sys/time.h>

#include <ctype.h>

/* We have our own versions of toupper()/tolower(). */
#undef tolower
#undef toupper
#define tolower tolower_
#define toupper toupper_
extern int toupper(char), tolower(char);

#include "auspice.h"
#include "defs.h"
#include "messages.h"
#include "msg.h"
/*************************** Help File ***********************************/
#define TTB_SIZE                8
/*************************************************************************/
#define MODEMAX         64

/* Configuration sanity-checking: */
#if CHANNEL_MAXREG > 65535
# define CHANNEL_MAXREG	0
#endif
#if DEF_MAX_MEMOS > 65535
# define DEF_MAX_MEMOS	0
#endif

/*************************************************************************/


/*************************************************************************/

/* Nickname info structure.  Each nick structure is stored in one of 256
 * lists; the list is determined by the first character of the nick.  Nicks
 * are stored in alphabetical order within lists. */

typedef struct nickinfov5_ NickInfoV5;
struct nickinfov5_ {
    NickInfoV5 *next, *prev;
    char nick[NICKMAX];
    char pass[PASSMAX];
    char *last_usermask;
    char *last_realname;
    time_t time_registered;
    time_t last_seen;
    long accesscount;	/* # of entries */
    char **access;	/* Array of strings */
    long flags;		/* See below */
    time_t id_timestamp;/* TS8 timestamp of user who last ID'd for nick */
    unsigned short memomax;
    unsigned short channelcount;/* Number of channels currently registered */
    char *url;
    char *email;
    char *forward;
    char *hold;       /*  }                                       */
    char *mark;       /*  }   --   Identities (what svsadmin did it?)  */
    char *forbid;
    int news;
    char *uin;
    char *age;
    /* FIELDS information about the owner */
    char *info;
    char *sex;
    char *mlock;
};

typedef struct nickinfo_ NickInfo;
struct nickinfo_ {
    NickInfo *next, *prev;
    char nick[NICKMAX];
    char pass[PASSMAX];
    char *last_usermask;
    char *last_realname;
    time_t time_registered;
    time_t last_seen;
    long accesscount;	/* # of entries */
    char **access;	/* Array of strings */
    long flags;		/* See below */
    time_t id_timestamp;/* TS8 timestamp of user who last ID'd for nick */
    unsigned short memomax;
    unsigned short channelcount;/* Number of channels currently registered */
    char *url;
    char *email;
    char *forward;
    char *hold;       /*  }                                       */
    char *mark;       /*  }   --   Identities (what svsadmin did it?)  */
    char *forbid;
    int news;
    char *uin;
    char *age;
    /* FIELDS information about the owner */
    char *info;
    char *sex;
    char *mlock;
    char *last_quit;  /* Last Quit Message */

    /* Extra Flags */
    long eflags;

    /* Auto Join Field */
    long ajoincount;
    char **autojoin;
    /* User Comment */
    long comline;
    char **comment;
    /* User Note */
    long noteline;
    char **note;
};


#define NI_KILLPROTECT	0x00000001  /* Kill others who take this nick */
#define NI_SECURE	0x00000002  /* Don't recognize unless IDENTIFY'd */
#define NI_VERBOTEN	0x00000004  /* Nick may not be registered or used */
#define NI_ENCRYPTEDPW	0x00000008  /* Nickname password is encrypted */
#define NI_MEMO_SIGNON	0x00000010  /* Notify of memos at signon and un-away */
#define NI_MEMO_RECEIVE	0x00000020  /* Notify of new memos when sent */
#define NI_PRIVATE	0x00000040  /* Don't show in LIST to non-servadmins */
#define NI_HIDE_EMAIL   0x00000080
#define NI_MARK		0x00000100
#define NI_HOLD		0x00000200
#define NI_EMAILMEMOS   0x00000400
#define NI_NOOP         0x00000800
#define NI_NOMEMO       0x00001000
#define NI_NOHOST	0x00002000
#define NI_SENDLOGS     0x00004000
#define NI_NEVEROP      0x00008000
#define NI_AUTH         0x00010000  /* Reserve for AUTH services */
#define NI_PRIVMSG      0x00020000  /* Recieve notice in private message */
#define NI_MALAY        0x00040000  /* Malaysia Language for my friend ghost */
#define NI_HOP		0x00080000  /* Reconize as Services Help op */
#define NI_SOP		0x00100000  /* Reconize as Services Operator */
#define NI_EXMAIL	0x00200000  /* have been sent e-mail confirm expired */
#define NI_BOTMSG	0x00400000  /* Recieved the message from your bot */
#define NI_SLAVE	0x00800000  /* A slave nick */
#define NI_FREEZE	0x01000000  /* Stop this nick being use as a register */
#define NI_WAUTH	0x02000000  /* This nick can be use until AUTH */

#define NI_IDENTIFIED	0x80000000  /* User has IDENTIFY'd */
#define NI_RECOGNIZED	0x40000000  /* User comes from a known addy */
#define NI_KILL_HELD	0x20000000  /* Nick is being held after a kill */

/*************************************************************************/
/* Extra Flags */

#define NIX_AUTOJOIN	0x00000001  /* This nick can be use until AUTH */
#define NIX_LOCK	0x00000002  /* This nick can getpass by Master only */
#define NIX_AGG		0x00000004  /* aggressive protection */

/*************************************************************************/

/* Channel info structures.  Stored similarly to the nicks, except that
 * the second character of the channel name, not the first, is used to
 * determine the list.  (Hashing based on the first character of the name
 * wouldn't get very far. ;) ) */

typedef struct {
    short level;
    short is_nick;	/* 1 if this is a nick, 0 if a user@host mask.  If
			 * -1, then this entry is currently unused (a hack
			 * to get numbered lists to have consistent
			 * numbering). */
# define in_use is_nick
    char *name;
    char *adder;
} ChanAccess7;

#define ACCESS_FOUNDER	10000	/* Numeric level indicating founder access */
#define ACCESS_INVALID	-10000	/* Used in levels[] for disabled settings */

/* AutoKick data. */
typedef struct {
    short is_nick;
    short pad;
    char *name;
    char *reason;
} AutoKick;

typedef struct chaninfo7_ ChannelInfo7;
typedef struct chaninfo_ ChannelInfo;
struct chaninfo7_ {
    ChannelInfo7 *next, *prev;
    char name[CHANMAX];
    char founder[NICKMAX];		/* Always a reg'd nick */
    char founderpass[PASSMAX];          
    char *desc;
    time_t time_registered;
    time_t last_used;
    long accesscount;
    ChanAccess7 *access;			/* List of authorized users */
    long akickcount;
    AutoKick *akick;
    char mlock_on[MODEMAX], mlock_off[MODEMAX]; 
    long mlock_limit;			/* 0 if no limit */
    char *mlock_key;			/* NULL if no key */
    char *last_topic;			/* Last topic on the channel */
    char last_topic_setter[NICKMAX];	/* Who set the last topic */
    time_t last_topic_time;		/* When the last topic was set */
    long flags;				/* See below */
    short *levels;			/* Access levels for commands */
    char *url;
    char *email;
    char *welcome;
    char *hold;       /*  }                                         */
    char *mark;       /*  }   --   Identities (what admin did it?)  */
    char *freeze;     /*  }   --                                    */
    char *forbid;     /*  }                                         */
    int topic_allow;                  /* Who's allowed to change topic */
    char *successor;            /* Person who get channel when founder
				         * nick droped */
    char *mlock_link;         /* +L #mlock_link */
    char *mlock_flood;        /* +f mlock_flood */
    char *bot;                /* Bot name */
    long botflag;              /* flag CBI_ */
    long newsline;
    char **news;
    long badwline;
    char **badwords;

    long reserved[3]; /*For future expansion -- set to 0 */
};
/*****************************************************/

typedef struct {
    short level;
    short is_nick;	/* 1 if this is a nick, 0 if a user@host mask.  If
			 * -1, then this entry is currently unused (a hack
			 * to get numbered lists to have consistent
			 * numbering). */
# define in_use is_nick
    char *name;
    char *adder;
    int accflag;	 /* For Time Op ... */
} ChanAccess;

#define ACI_ZONE1  0x0002		/* 0->5 */
#define ACI_ZONE2  0x0004		/* 6->11 */
#define ACI_ZONE3  0x0008		/* 12->17 */
#define ACI_ZONE4  0x0010		/* 18->23 */

struct chaninfo_ {
    ChannelInfo *next, *prev;
    char name[CHANMAX];
    char founder[NICKMAX];		/* Always a reg'd nick */
    char founderpass[PASSMAX];          
    char *desc;
    time_t time_registered;
    time_t last_used;
    long accesscount;
    ChanAccess *access;			/* List of authorized users */
    long akickcount;
    AutoKick *akick;
    char mlock_on[MODEMAX], mlock_off[MODEMAX]; 
    long mlock_limit;			/* 0 if no limit */
    char *mlock_key;			/* NULL if no key */
    char *last_topic;			/* Last topic on the channel */
    char last_topic_setter[NICKMAX];	/* Who set the last topic */
    time_t last_topic_time;		/* When the last topic was set */
    long flags;				/* See below */
    short *levels;			/* Access levels for commands */
    char *url;
    char *email;
    char *welcome;
    char *hold;       /*  }                                         */
    char *mark;       /*  }   --   Identities (what admin did it?)  */
    char *freeze;     /*  }   --                                    */
    char *forbid;     /*  }                                         */
    int topic_allow;                  /* Who's allowed to change topic */
    char *successor;            /* Person who get channel when founder
				         * nick droped */
    char *mlock_link;         /* +L #mlock_link */
    char *mlock_flood;        /* +f mlock_flood */

    long newsline;
    char **news;

    long badwline;
    char **badwords;

    char *markreason;
    char *freezereason;
    char *holdreason;
    char *lastgetpass;

    char *bot;			      /* Bot name */
    long botflag;		      /* flag CBI_ */
    int ttb;			      /* Time for to ban */
    int capsmin, capspercent;         /* For CAPS kicker */
    int floodlines, floodsecs;        /* For FLOOD kicker */
    int repeattimes;                  /* For REPEAT kicker */
};


/*****************************************************/
/* BotServ Database */
typedef struct botinfo_ BotInfo;

struct botinfo_ {
        BotInfo *next, *prev;
        char *nick;             /* Bot Nickname*/
        char *user;             /* bot user name */
        char *host;             /* bot hostname */
        char *real;             /* bot real name */
        char *master;          /* Whois this bot master */
        long flags;
	int chancount;
        time_t created;
};
/* Bot Flags */
#define BI_MASTER  0x00000001 /* Only master can assign it */
#define BI_USER    0x00000002 /* Open for every one */
#define BI_TEMP    0x00000004 /* A ChanOP bot */
/*****************************************************/

/* Retain topic even after last person leaves channel */
#define CI_KEEPTOPIC	0x00000001
/* Don't allow non-authorized users to be opped */
#define CI_OPGUARD	0x00000002
/* Hide channel from ChanServ LIST command */
#define CI_PRIVATE	0x00000004
/* Topic can only be changed by SET TOPIC */
#define CI_TOPICLOCK	0x00000008
/* Those not allowed ops are kickbanned */
#define CI_RESTRICTED	0x00000010
/* Don't auto-deop anyone */
#define CI_LEAVEOPS	0x00000020
/* Don't allow any privileges unless a user is IDENTIFY'd with NickServ */
#define CI_IDENT	0x00000040
/* Don't allow the channel to be registered or used */
#define CI_VERBOTEN	0x00000080
/* Channel password is encrypted */
#define CI_ENCRYPTEDPW	0x00000100
// Held channel
#define CI_HELDCHAN     0x00000200
// marked channel
#define CI_MARKCHAN     0x00000400
// Only Opers can join
#define CI_OPERONLY     0x00000800
// Only SOP+ can join
#define CI_SOPONLY      0x00001000
// Only SA+ can join
#define CI_SAONLY       0x00002000
// Only SRA+ can join
#define CI_SRAONLY      0x00004000
// Only Coders can join
#define CI_CODERONLY    0x00008000
// Only Abuse Team can join
#define CI_ABUSEONLY	0x00010000
// Frozen Channel
#define CI_FREEZECHAN   0x00020000
// Memo Levels
#define CI_MEMO_AV      0x00040000
#define CI_MEMO_AOP     0x00080000
#define CI_MEMO_SOP     0x00100000
#define CI_MEMO_CF      0x00200000
#define CI_MEMO_FR      0x00400000
#define CI_MEMO_NONE    0x00800000
#define CI_UNSECURE     0x01000000
#define CI_MEMO_HOP     0x02000000
#define CI_CHANJOIN     0x04000000  /* ChanServ stay in Channel */
#define CI_CLOSED       0x08000000  /* Reserved for Require AUTH */
#define CI_AUTOVOP      0x10000000  /* Auto +v to all guest */
#define CI_AUTOOP       0x20000000  /* Auto +o to all guest */
#define CI_AUTOHOP      0x40000000  /* Auto +h to all guest */

/* Channel's access list has masks in it, not just registered nicks */
#define CI_HAS_MASKS	0x80000000

/* Indices for cmd_access[]: */
#define CA_INVITE	0
#define CA_AKICK	1
#define CA_SET		2	/* but not FOUNDER or PASSWORD */
#define CA_UNBAN	3
#define CA_AUTOOP	4
#define CA_AUTODEOP	5	/* Maximum, not minimum */
#define CA_AUTOVOICE	6
#define CA_OPDEOP	7	/* ChanServ commands OP and DEOP */
#define CA_ACCESS_LIST	8
#define CA_CLEAR	9
#define CA_NOJOIN	10	/* Maximum */
#define CA_ACCESS_CHANGE 11
#define CA_AUTOHOP      12
#define CA_USEROP       13

#define CA_SIZE		14
/*************************************************************************/
#define CBI_BOTCOM		0x00000001 /* Make bot act like eggdrop bot */
#define CBI_BOTSTAY		0x00000002 /* Make bot stay in channel forever */
#define CBI_KICKCAP		0x00000004 /* Make bot kick the excess CAP */
#define CBI_KICKBOLDS		0x00000008
#define CBI_KICKCOLORS		0x00000010
#define CBI_KICKREVERSES	0x00000020
#define CBI_KICKUNDERLINES	0x00000040
#define CBI_KICKBADWORDS	0x00000080
#define CBI_KICKFLOOD		0x00000100
#define CBI_KICKREPEAT		0x00000200
#define CBI_PROTOP		0x00000400
#define CBI_GUESSNUM		0x00000800
#define CBI_GUESSWRD		0x00001000
#define CBI_NORMALMSG		0x00002000
#define CBI_GREET		0x00004000
#define CBI_VERBOSE		0x00008000
#define CBI_BADCHAN		0x00010000
#define CBI_BADNICK		0x00020000
#define CBI_PROTECT		0x00040000 /* Protect op from being deop */
#define CBI_NOGB		0x00080000 /* No Global Badword */
#define CBI_HOPGUARD		0x00100000 /* Halfop Guard */
/*************************************************************************/

/* MemoServ data.  Only nicks that actually have memos get records in
 * MemoServ's lists, which are stored the same way NickServ's are. */

typedef struct memo_ Memo;

struct memo_ {
    char sender[NICKMAX];
    long number;	/* Index number -- not necessarily array position! */
    time_t time;	/* When it was sent */
    char *text;
    char *chan;
    short flags;
    short reserved_s;
    long reserved[3];   /* For future expansion -- set to 0 */
};

#define MF_UNREAD	0x0001	/* Memo has not yet been read */
#define MF_DEL          0x0002  /* Memo marked as deleted */
#define MF_ACK          0x0004  /* Maked as sending back the ACK on read */
#define MF_MARK         0x0008  /* Mark as not expire */

typedef struct memolist_ MemoList;

struct memolist_ {
    MemoList *next, *prev;
    char nick[NICKMAX];	/* Owner of the memos */
    long n_memos;	/* Number of memos */
    Memo *memos;	/* The memos themselves */
    long reserved[4];   /* For future expansion -- set to 0 */
};

/*************************************************************************/

/*************************************************************************/
/* Online user and channel data. */

typedef struct user_ User;
typedef struct channel_ Channel;

struct user_ {
    User *next, *prev;
    char nick[NICKMAX];
    char *username;
    char *host;				/* user's hostname */
    char *realhost;			/* user's realhost */
    char *realname;
    char *server;			/* name of server user is on */
    time_t signon;
    time_t my_signon;			/* when did _we_ see the user? */
    long mode;				/* see below */
    long flags;
    struct u_chanlist {
	struct u_chanlist *next, *prev;
	Channel *chan;
	int status;
    } *chans;				/* channels user has joined */
    struct u_chaninfolist {
	struct u_chaninfolist *next, *prev;
	ChannelInfo *chan;
    } *founder_chans;			/* channels user has identified for */
    char *id_nicks[MAX_IDS];
    short invalid_pw_count;		/* # of invalid password attempts */
    time_t invalid_pw_time;		/* time of last invalid password */
    time_t lastmemosend;		/* last time MS SEND command used */
    time_t lastnickreg;			/* last time NS REGISTER cmd used */
    time_t flood_time;                  /* time until reset flood level */
    int floodlev, floodlev2;            /* current flood level */
    short motd, version;               /* additional flood monitors */
    int games;
    short iswebtv;
};

#define UMODE_O  0x00000001	/* Global IRCop */
#define UMODE_I  0x00000002      /* Invisible +i */
#define UMODE_S  0x00000004      /* Server message +s */
#define UMODE_W  0x00000008      /* Wallop +w */
#define UMODE_G  0x00000010      /* Globops +g */
#define UMODE_H  0x00000020      /* Helper +h */
#define UMODE_A  0x00000040      /* Admin +A */
#ifdef NETADMIN
#define UMODE_N  0x00000080      /* Net Admin +N */
#define UMODE_T  0x00000100      /* Tech Admin +T */
#endif
#define UMODE_IN 0x00000400      /* Invisible mode +I */
#define UMODE_HO 0x00000800      /* Hide Oper mode +H */
#define UMODE_C  0x00001000      /* Co Admin in Unreal +C */
#define UMODE_B  0x00000200      /* Bot +B */


#define U_ABUSIVE 0x00000001
#define U_NOOPER  0x00000002
#define U_NOSERV  0x00000004
#define U_GUEST   0x00000008

#define CSTATUS_OP      0x0001
#define CSTATUS_VOICE   0x0002
#define CSTATUS_HALFOP  0x0004          /* Halfop (+h) */
#define CSTATUS_OWNER   0x0008          /* Owner/Founder (+q) */
#define CSTATUS_PROTECT 0x0010          /* Protected users (+a) */

typedef struct bandata_ BanData;
typedef struct userdata_ UserData;
struct userdata_ {
    /* Data validity */
    time_t last_use;

    /* for flood kicker */
    int lines;
    time_t last_start;

    /* for repeat kicker */
    char *lastline;
    int times;
};
struct channel_ {
    Channel *next, *prev;
    char name[CHANMAX];
    time_t creation_time;		/* when channel was created */
    char *topic;
    char topic_setter[NICKMAX];		/* who set the topic */
    time_t topic_time;			/* when topic was set */
    char modes[MODEMAX];		/* Channel mode handle */
    long limit;				/* 0 if none */
    char *key;				/* NULL if none */
    char *link;				/* NULL if none */
    char *flood;			/* NULL if none */
    int bancount, bansize;
    int ngames;
    int wgames;
    char *wgame;
    char **bans;
    int usercount;
    int havebot;
    struct c_userlist {
	struct c_userlist *next, *prev;
	User *user;
	UserData *ud;
    } *users;
    BanData *bd;
    time_t server_modetime;           /* Time of last server MODE */
    time_t chanserv_modetime;         /* Time of last check_modes() */
    int server_modecount;             /* Number of server MODEs this second */
    int chanserv_modecount;           /* Number of check_mode()'s this sec */
    int bouncy_modes;                 /* Did we fail to set modes here? */
 };
/*************************************************************************/

struct bandata_ {
    BanData *next, *prev;
    char *mask;
    time_t last_use;           
    int16 banmin; /* minute to ban */
};

/*************************************************************************/

/* Channel Suspend data. */

typedef struct c_suspend_data {
    struct c_suspend_data *next;
    char chan[CHANMAX];
    time_t time;        /* When do we stop suspending? */
} C_SuspendData;

/*************************************************************************/
#define M_LOGON 0
#define M_OPER  1
/*************************************************************************/

#include "extern.h"

/*************************************************************************/
/* Each Database have their own version */
/*************************************************************************/
#define BADWORD_VERSION	1
#define BS_VERSION	1
#define ADS_VERSION	1
#define NS_VERSION	6
#define CS_VERSION	8
#define MS_VERSION	6
#define OS_SA_VERSION	6
#define OS_SRA_VERSION	6
#define OS_QL_VERSION	6
#define OS_ZL_VERSION	6
#define OS_TR_VERSION	6
#define OS_QL_VERSION	6
#define OS_AK_VERSION	6 /* Auto Akill */
#define OS_AKI_VERSION	6 /* Akill */
#define OS_IG_VERSION	6
#define OS_AT_VERSION	6
#define OS_GL_VERSION	6
#define AS_MSG_VERSION	6
#define AS_HL_VERSION	6
#define AS_MJ_VERSION	6
#define AUTHS_VERSION	1

/* Highest Version */

#define FILE_VERSION    8

/*************************************************************************/
#endif	/* SERVICES_H */
