/* Auspice functions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean.
 *     E-mail: <auspice@auspice.org>
 *
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"
#include "../inc/timeout.h"

static BotInfo *makebot(const char *nick);
static BotInfo *botlists[256];
static void do_bot(const char *source);
static void alpha_insert_bot(BotInfo *bi);
static void change_bot_nick(BotInfo *bi, char *newnick);
static void insert_bot(BotInfo *bi);
static void do_help(const char *source);
static void do_ohelp(const char *source);
static void do_bot_settings(User *u, ChannelInfo *ci, const char *opts, const char *acmd);
static void do_info(const char *source);
static void do_chanset(const char *source);

/**********************************************************************/
void load_bs2_db(void)
{
    FILE *f = fopen(AUTH_DB, "r");
    int i, ver;
    BotInfo *bi;

    if (!(f = open_db(s_BotServ, BOTSERV2_DB, "r", 1)))
        return;

    switch (ver = get_file_version(f, BOTSERV2_DB)) {
	case 1:
        for (i = 33; i < 256; ++i) {
            while (fgetc(f) == 1) {
                   bi = smalloc(sizeof(BotInfo));
                   if (1 != fread(bi, sizeof(BotInfo), 1, f))
                       fatal_perror("Read error on %s", BOTSERV2_DB);

                if (bi->nick)
                    bi->nick = read_string(f, BOTSERV2_DB);
                alpha_insert_bot(bi);

                if (bi->user)
                    bi->user = read_string(f, BOTSERV2_DB);
                if (bi->host)
                    bi->host = read_string(f, BOTSERV2_DB);
                if (bi->real)
                    bi->real = read_string(f, BOTSERV2_DB);
                if (bi->master)
                    bi->master = read_string(f, BOTSERV2_DB);
		if (bi->flags == 0)
		    bi->flags |= BI_USER;
            } /* while (fgetc(f) == 1) */
        } /* for (i) */
	break;
      default:
        fatal("Unsupported version number (%d) on %s", i, BOTSERV2_DB);
    } /* switch (version) */

    close_db(f, BOTSERV2_DB);
}
/**********************************************************************/
static void alpha_insert_bot(BotInfo *bi)
{
    BotInfo *bi2, *bi3;
    char *nick = bi->nick;

    for (bi3 = NULL, bi2 = botlists[tolower(*nick)];
                        bi2 && stricmp(bi2->nick, nick) < 0;
                        bi3 = bi2, bi2 = bi2->next)
        ;
    bi->prev = bi3;
    bi->next = bi2;
    if (!bi3)
        botlists[tolower(*nick)] = bi;
    else
        bi3->next = bi;
    if (bi2)
        bi2->prev = bi;
}
/**********************************************************************/
void save_bs2_db(void)
{
    FILE *f;
    int i;
    BotInfo *bi;

    if (!(f = open_db(s_BotServ, BOTSERV2_DB, "w", BS_VERSION)))
        return;
    for (i = 33; i < 256; ++i) {
        for (bi = botlists[i]; bi; bi = bi->next) {
            fputc(1, f);

            if (1 != fwrite(bi, sizeof(BotInfo), 1, f))
            fatal_perror("Write error on %s", BOTSERV2_DB);
            if (bi->nick) {
                write_string(bi->nick, f, BOTSERV2_DB);
            }
            if (bi->user) {
                write_string(bi->user, f, BOTSERV2_DB);
            }
            if (bi->host) {
                write_string(bi->host, f, BOTSERV2_DB);
            }
            if (bi->real) {
                write_string(bi->real, f, BOTSERV2_DB);
            }
            if (bi->master) {
                write_string(bi->master, f, BOTSERV2_DB);
            }
        }
        fputc(0, f);
    }
    close_db(f, BOTSERV2_DB);
}
/**********************************************************************/
static BotInfo *makebot(const char *nick)
{
    BotInfo *bi;

    bi = scalloc(sizeof(BotInfo), 1);
    bi->nick = sstrdup(nick);
    alpha_insert_bot(bi);
    return bi;
}
/**********************************************************************/
static int delbot(BotInfo *bi)
{
    do_expireabot(bi->nick);
    if (bi->next)
        bi->next->prev = bi->prev;
    if (bi->prev)
        bi->prev->next = bi->next;
    else
        botlists[tolower(*bi->nick)] = bi->next;
    if (bi->nick)
      free(bi->nick);
    if (bi->user)
      free(bi->user);
    if (bi->host)
      free(bi->host);
    if (bi->real)
      free(bi->real);
    if (bi->master)
      free(bi->master);

    free(bi);
    return 1;
}
/**********************************************************************/
BotInfo *findbot(const char *nick)
{
    BotInfo *bi;
    if (!nick || !*nick) return NULL;
    for (bi = botlists[tolower(*nick)]; bi; bi = bi->next) {
        if (stricmp(bi->nick, nick) == 0)
            return bi;
    }
    return NULL;
}
/**********************************************************************/
void sbotserv(const char *source, char *buf)
{
    BotInfo *bi;
    char *cmd, *s, *chan, *bchan;
    cmd = strtok(buf, " ");

    if (cmd) {
            if (stricmp (cmd, "\1PING") == 0)
            {
                if (!(s = strtok (NULL, "")))
                    s = "\1";
                notice(s_BotServ, source, "\1PING %s", s);

            } else if (stricmp (cmd, "\1VERSION\1") == 0) {
                if (!(s = strtok (NULL, "")))
                    s = "\1";
                notice(s_BotServ, source, "%sVERSION Auspice IRC Services %s", s, s);
            } else if (stricmp(cmd, "HELP") == 0) {
			do_help(source);
            } else if (stricmp(cmd, "MUTE") == 0) {
                int i;
		if (!is_services_coder(source))
			return;
		for (i = 33; i < 256; ++i)
		for (bi = botlists[i]; bi; bi = bi->next)
		send_cmd(s_NickServ, "SVSMODE %s +d 0", bi->nick);
            } else if (stricmp(cmd, "UNMUTE") == 0) {
                int i;
		if (!is_services_coder(source))
			return;
		for (i = 33; i < 256; ++i)
		for (bi = botlists[i]; bi; bi = bi->next)
		send_cmd(s_NickServ, "SVSMODE %s -d 0", bi->nick);
            } else if (stricmp(cmd, "LIST") == 0) {
                int i;
                notice(s_BotServ, source, "\2Bot Listing\2.");
		for (i = 33; i < 256; ++i)
			for (bi = botlists[i]; bi; bi = bi->next)
			if (bi->flags & BI_USER) {
				notice(s_BotServ, source, "%-10s \2%-15s\2 (%s@%s)", "Public",bi->nick, bi->user, bi->host);
			} else if (is_oper(source)) {
				notice(s_BotServ, source, "%-10s \2%-15s\2 (%s@%s)", bi->flags & BI_MASTER?"Private":"NotSet",bi->nick, bi->user, bi->host);
			}
                notice(s_BotServ, source, "\2End OF List\2.");

            } else if (stricmp(cmd, "SET") == 0) {
		ChannelInfo *ci;
		char *opts, *acmd;
		User *u = finduser(source);

		if (readonly) {
		    notice(s_BotServ, source, 
                	"Sorry, channel option setting is temporarily disabled.");
	            return;
	        }
        
               chan = strtok(NULL, " ");
               opts = strtok(NULL, " ");
               acmd = strtok(NULL, " ");

	       if (!chan) {
		    notice(s_BotServ, source, 
                	"Syntax: /Msg %s SET #channel options ON|OFF", s_BotServ);
		    return;
	       }

	       ci = cs_findchan(chan);

	       if (!ci) {
		    notice(s_BotServ, source, 
                	"Channel %s is not registered.", chan);
		    return;
	       }

	       if (!u) {
			return;
	       }

	       if ((get_access(u,ci) < 12) && !is_services_admin(source)) {
		    notice(s_BotServ, source, 
                	"Only Founder or Co Founder can change bot setting.");
		    return;
	       }

	       if (!opts || !acmd) {
			notice(s_BotServ, u->nick, "Syntax: /Msg %s SET #channel <Option> <ON|OFF>", s_BotServ);
	       } else if (stricmp(acmd,"ON") && stricmp(acmd,"OFF")) {
			notice(s_BotServ, u->nick, "Syntax: /Msg %s SET #channel <Option> <ON|OFF>", s_BotServ);
	       } else {	
		       do_bot_settings(u,ci,opts,acmd);
	       }

            } else if (stricmp(cmd, "ASSIGN") == 0) {
		ChannelInfo *ci;
		User *u = finduser(source);

		if (readonly) {
		    notice(s_BotServ, source, 
                	"Sorry, channel option setting is temporarily disabled.");
	            return;
	        }
        
                chan = strtok(NULL, " ");
                bchan = strtok(NULL, " ");

	       if (!chan || !bchan) {
		    notice(s_BotServ, source, 
                	"Syntax: /Msg %s ASSIGN #channel botnick", s_BotServ);
		    return;
	       }

	       ci = cs_findchan(chan);

	       if (!ci) {
		    notice(s_BotServ, source, 
                	"Channel %s is not registered.", chan);
		    return;
	       }

	       if (!u) return;
	      
	       if ((get_access(u,ci) < 12) && !is_services_admin(source)) {
		    notice(s_BotServ, source, 
                	"Only Founder or Co Founder can assign bot.");
		    return;
	       }

	       bi = findbot(bchan);

	       if (!bi) {
		    notice(s_BotServ, source, 
                	"This bot is not exist, please use command /Msg %s LIST   to list available bot.", s_BotServ);
		    return;
	       }

	      if (stricmp(source, bi->master) && (bi->flags & BI_MASTER) && !is_oper_cando(source, 1)) {
		    notice(s_BotServ, source, 
                	"Only Bot Master can assign this bot");
		    return;
	       }

	       if ((ci->bot) && (!stricmp(ci->bot, bchan))) {
		    notice(s_BotServ, source, "This bot already assigned");
		    return;
	       }
               csbot++;
               if(ci->bot) {
                        botpart3(chan);
                        free(ci->bot);
               }
               ci->bot = sstrdup (bchan);
               botjoin(chan);
               notice(s_BotServ, source, "Your channel bot is \2%s\2.", bchan);
               slog("CS BOT %s bot: %s", chan, ci->bot);
               show_u_next_db(u, s_BotServ);
            } else if (stricmp(cmd, "UNASSIGN") == 0) {
		ChannelInfo *ci;
		User *u = finduser(source);

		if (readonly) {
		    notice(s_BotServ, source, 
                	"Sorry, channel option setting is temporarily disabled.");
	            return;
	        }
        
                chan = strtok(NULL, " ");

	       if (!chan) {
		    notice(s_BotServ, source, 
                	"Syntax: /Msg %s UNASSIGN #channel", s_BotServ);
		    return;
	       }

	       ci = cs_findchan(chan);

	       if (!ci) {
		    notice(s_BotServ, source, 
                	"Channel %s is not registered.", chan);
		    return;
	       }

	       if (!u) {
			return;
	       }

	       if ((get_access(u,ci) < 12) && !is_services_admin(source)) {
		    notice(s_BotServ, source, 
                	"Only Founder or Co Founder can unassign bot.");
		    return;
	       }

	       if (!ci->bot) {
		    notice(s_BotServ, source, 
                	"There is not bot in this channel");
		    return;
	       }
               csbot++;
               if(ci->bot) {
                        botpart3(chan);
                        free(ci->bot);
                        ci->bot = NULL;
               }
	       notice(s_BotServ, source, "There are no bot set in your channel now.");
               slog("CS BOT %s unset bot)", chan);
               show_u_next_db(u, s_BotServ);
            } else if (stricmp(cmd, "BOT") == 0) {
		do_bot(source);
            } else if (stricmp(cmd, "INFO") == 0) {
		do_info(source);
            } else if (stricmp(cmd, "CHANSET") == 0) {
		do_chanset(source);
            } else if (stricmp(cmd, "WHOIS") == 0) {
		struct tm tm;
		char timebuf[64];
                chan = strtok(NULL, " ");
                if (!chan) {
                        notice(s_BotServ, source, "Syntax: WHOIS \2Botnick\2");
                } else {
			bi = findbot(chan);
                        if (bi) {
			        char bufss[512];
				*timebuf =0;
				notice(s_BotServ, source,"Bot Nick   : %s (%s@%s) %s", bi->nick, bi->user, bi->host, bi->real);
				notice(s_BotServ, source,"Master     : %s", bi->master);
			        tm = *localtime(&bi->created);
			        strftime(timebuf, sizeof(timebuf), "%b %d %H:%M:%S %Y %Z", &tm);
			        timebuf[sizeof(timebuf)-1] = 0;
			        notice(s_BotServ, source,"Registered : %s", timebuf);
				*bufss = 0;
				if (bi->flags & BI_MASTER)
				strcat(bufss, "Private");
				if (bi->flags & BI_USER) {
			        if (*bufss)
					strcat(bufss, ", ");
				strcat(bufss, "Public");
				}
			        notice(s_BotServ, source,"Options: %s", bufss);
                        }
                }

            } else if (stricmp(cmd, "OHELP") == 0) {
			do_ohelp(source);

            } else if (stricmp(cmd, "SNOOP") == 0) {
                if (!is_services_root(source)) {
                        notice(s_BotServ, source, PMD);
                        return;
                }

                chan = strtok(NULL, " ");
                bchan = strtok(NULL, " ");

		if (!chan || !bchan) {
			notice(s_BotServ, source, "Syntax: SNOOP [\2source\2] [\2dest\2]");
                        notice(s_BotServ, source, "Disable Channel Spy feature");
                        aspychan = 0;
                } else {
                        if (asource) free(asource);
                        asource = sstrdup(chan);
                        if (adest) free(adest);
                        adest = sstrdup(bchan);
                        aspychan = 1;
                        notice(s_BotServ, source, "All message in channel %s forward to %s.", chan, bchan);
                }

	    }
	}
}
 
/**************************************************************/
static void do_info(const char *source)
{
	ChannelInfo *ci;
	char *chan = strtok(NULL, " ");

	if (!chan) {
	        notice(s_BotServ, source, "Syntax: /MSG %s \2INFO\2 #<channel>", s_BotServ);
	} else {
		ci = cs_findchan(chan);
		if (!ci) {
		        notice(s_BotServ, source, "This channel is not a registered channel");
		} else if (!ci->bot) {
			notice(s_BotServ, source, "There is not bot assigned in this channel");
		} else {
        	    notice(s_BotServ, source, "Channel Bot : \2%s\2",ci->bot);
        	    notice(s_BotServ, source, "Caps Limit  : Allow: \2%d\2 Percent: \2%d\2", ci->capsmin, ci->capspercent);
        	    notice(s_BotServ, source, "Flood Limit : Lines: \2%d\2 Seconds: \2%d\2", ci->floodlines, ci->floodsecs);
        	    notice(s_BotServ, source, "Repeat Limit: Lines: \2%d\2", ci->repeattimes);
	            if (ci->botflag) {
        	        char buf[512];
                	*buf = 0;
		        if (ci->botflag & CBI_BOTCOM)
                	    strcat(buf, "Bot Command");
	                if (ci->botflag & CBI_BOTSTAY) {
        	            if (*buf)
	                        strcat(buf, ", ");
        	            strcat(buf, "Stay");
	                }
        	        if (ci->botflag & CBI_KICKCAP) {
                	    if (*buf)
                	        strcat(buf, ", ");
	                    strcat(buf, "Caps");
        	        }
	                if (ci->botflag & CBI_KICKBOLDS) {
        	            if (*buf)
                	        strcat(buf, ", ");
	                    strcat(buf, "Bolds");
        	        }
                	if (ci->botflag & CBI_KICKCOLORS) {
	                    if (*buf)
        	                strcat(buf, ", ");
                	    strcat(buf, "Colors");
	                }
        	        if (ci->botflag & CBI_KICKREVERSES) {
	                    if (*buf)
        	                strcat(buf, ", ");
                	    strcat(buf, "Reverses");
	                }
        	        if (ci->botflag & CBI_KICKUNDERLINES) {
                	    if (*buf)
                        	strcat(buf, ", ");
	                    strcat(buf, "Underlines");
        	        }
	                if (ci->botflag & CBI_KICKBADWORDS) {
        	            if (*buf)
                	        strcat(buf, ", ");
	                    strcat(buf, "Badwords");
        	        }
	                if (ci->botflag & CBI_KICKFLOOD) {
        	            if (*buf)
                	        strcat(buf, ", ");
	                    strcat(buf, "Flood");
        	        }
	                if (ci->botflag & CBI_KICKREPEAT) {
        	            if (*buf)
                	        strcat(buf, ", ");
	                    strcat(buf, "Repeat");
        	        }
                	if (ci->botflag & CBI_PROTOP) {
	                    if (*buf)
        	                strcat(buf, ", ");
	                    strcat(buf, "Protect Op");
        	        }
	               notice(s_BotServ, source, "Bot Options : \2%s\2", buf);
	            } /* if have flag */
		} /* !ci? */
	} /* !chan? */
}
/*************************************************************/
static void do_chanset(const char *source)
{
	ChannelInfo *ci;
	char *chan = strtok(NULL, " ");
	char *cmd = strtok(NULL, " ");
	char *param1 = strtok(NULL, " ");
	char *param2 = strtok(NULL, " ");

	if (!chan || !cmd || !param1) {
	        notice(s_BotServ, source, "Syntax: /MSG %s \2CHANSET\2 #<channel> <option> <param1> <param2>", s_BotServ);
	} else {
		ci = cs_findchan(chan);
		if (!ci) {
		        notice(s_BotServ, source, "This channel is not a registered channel");
		} else if (!ci->bot) {
			notice(s_BotServ, source, "There is not bot assigned in this channel");
		} else {
	            User *u = finduser(source);
               if (!u) {
                        return;
               }

               if ((get_access(u,ci) < 12) && !is_services_admin(source)) 
		{
                    notice(s_BotServ, source,
                        "Only Founder or Co Founder can change bot setting.");
                    return;
               }

		    if (!stricmp(cmd, "CAPS")) {
			if (!param2) {
			       notice(s_BotServ, source, "Syntax: /MSG %s \2CHANSET\2 %s CAPS <allow> <percents>", s_BotServ, chan);
			} else if ((strlen(param1) > 3) || (strlen(param2) > 2)) {
				notice(s_BotServ, source, "Input too big");
			} else {
				ci->capsmin = atoi(param1);
				ci->capspercent = atoi(param2);
		       	    notice(s_BotServ, source, "Caps Limit  : Allow: \2%d\2 Percent: \2%d\2", ci->capsmin, ci->capspercent);
			}
		    } else if (!stricmp(cmd, "FLOOD")) {
			if (!param2) {
			       notice(s_BotServ, source, "Syntax: /MSG %s \2CHANSET\2 %s FLOOD <lines> <secs>", s_BotServ, chan);
			} else if ((strlen(param1) > 3) && (strlen(param2) > 2)) {
				notice(s_BotServ, source, "Input too big");
			} else {
				ci->floodlines = atoi(param1);
				ci->floodsecs = atoi(param2);
	        	    	notice(s_BotServ, source, "Flood Limit : Lines: \2%d\2 Seconds: \2%d\2", ci->floodlines, ci->floodsecs);
			}
		    } else if (!stricmp(cmd, "REPEAT")) {
			if ((strlen(param1) > 3)) {
				notice(s_BotServ, source, "Input too big");
			} else {
				ci->repeattimes = atoi(param1);
		       	    notice(s_BotServ, source, "Repeat Limit: Lines: \2%d\2", ci->repeattimes);
			}
		    } else {
		       	    notice(s_BotServ, source, "Unknown Option.");
		    }
		} /* !ci? */
	} /* !chan? */
}
/*************************************************************/
static void do_bot(const char *source)
{
    BotInfo *bi;
    NickInfo *ni = findnick(source);
    char *cmd = strtok(NULL, " ");
    if (!cmd) {
        notice(s_BotServ, source, "Syntax: /MSG %s \2BOT\2 <command> [<parameters>].", s_BotServ);
    } else if (!is_services_admin(source) || !ni) {
        notice(s_BotServ, source, PMD);
    } else if (!stricmp(cmd, "ADD")) {
        char *nick = strtok(NULL, " ");
        char *user = strtok(NULL, " ");
        char *host = strtok(NULL, " ");
        char *real = strtok(NULL, "");

        if (!nick || !user || !host || !real)  {
		notice(s_BotServ, source,"Syntax: BOT ADD \2botnick\2 \2username\2 \2bothost\2 \2realname\2");
		notice(s_BotServ, source, "Example: BOT ADD testbot MyNewBot botserv.auspice.org In Mean Bot");
        } else if (findbot(nick)) {
                notice(s_BotServ, source, "This bot already exist.");
	} else {
		if (finduser(nick)) {
			notice(s_BotServ, source, "This nick currently online.");
			return;
		}
                bi = makebot(nick);
                if (!bi) {
	                notice(s_BotServ, source, "Failed created bot.");
			return;
                }
                bi->user = sstrdup(user);
                bi->host = sstrdup(host);
                bi->real = sstrdup(real);
                bi->master = sstrdup(source);
                bi->created = CTime;
		bi->flags = 0;
		bi->flags |= BI_USER;
                bi->chancount = 0;
                NEWNICK(bi->nick, bi->user, bi->host, bi->real, BOTMODE, 1);
                notice(s_BotServ, source, "Bot \2%s\2 connected.", bi->nick);
	}
     } else if (!stricmp(cmd, "CHANGE")) {
        char *oldnick = strtok(NULL, " ");
        char *nick = strtok(NULL, " ");
        char *user = strtok(NULL, " ");
        char *host = strtok(NULL, " ");
        char *real = strtok(NULL, "");
	int is_sr = is_services_root(source);

        if (!oldnick || !nick)
                notice(s_BotServ, source, "Syntax: BOT CHANGE \2old-bot-nick\2 \2new-bot-nick\2 [\2user\2] [\2host\2] [\2real\2]");
        else if (!(bi = findbot(oldnick)))
                notice(s_BotServ, source, "Bot %s doesn't exist", oldnick);
	else if (!is_sr && (stricmp(source, bi->master) != 0)) {
	        notice(s_BotServ, source, PMD);
		return;
        } else {
                if (!strcmp(bi->nick, nick)
                                && ((user) ? !strcmp(bi->user, user) : 1)
                                && ((host) ? !strcmp(bi->host, host) : 1)
                                && ((real) ? !strcmp(bi->real, real) : 1))
                {
                        notice(s_BotServ, source, "Setting didn't changed.");
                        return;
                }
                if (stricmp(bi->nick, nick) && findbot(nick))
                {
                        notice(s_BotServ, source, "Bot %s already existed", nick);
                        return;
                }
                if (stricmp(bi->nick, nick) && finduser(nick))
                {
                        notice(s_BotServ, source, "nick %s currently online", nick);
                        return;
                }
                if (stricmp(bi->nick, nick))
                {
			User *u2;
                        send_cmd(NULL, "UNSQLINE %s", bi->nick);
                        if ((u2 = finduser(nick)))
                                kill_user(s_BotServ, u2->nick, "This nick is now used by Services");
                }
                if (strcmp(nick, bi->nick))
                        change_bot_nick(bi, nick);
                if (user && strcmp(user, bi->user))
                {
                        free(bi->user);
                        bi->user = sstrdup(user);
                }
                if (host && strcmp(host, bi->host))
                {
                        free(bi->host);
                        bi->host = sstrdup(host);
                }
                if (real && strcmp(real, bi->real))
                {
                        free(bi->real);
                        bi->real = sstrdup(real);
                }
                if (!user)
                        send_cmd(oldnick, "NICK %s", bi->nick);
                else
                {
			do_checkbotpart(oldnick, bi->nick);
                        send_cmd(oldnick, "QUIT :Quit: Be right back");
	                NEWNICK(bi->nick, bi->user, bi->host, bi->real, BOTMODE, 1);
                        do_checkbot2(bi->nick);
                }
                notice(s_BotServ, source, "Bot \2%s\2 has been changed to %s!%s@%s (%s)", oldnick, bi->nick, bi->user, bi->host, bi->real);
	}
     } else if (!stricmp(cmd, "TRANSFER")) {
        char *nick = strtok(NULL, " ");
        char *master = strtok(NULL, " ");
	int is_sr = is_services_root(source);

        if (!nick || !master)
                notice(s_BotServ, source, "Syntax: BOT TRANSFER \2bot-nick\2 \2new-master-nick\2");
        else if (!(bi = findbot(nick)))
                notice(s_BotServ, source, "Bot %s doesn't exist", nick);
        else if (!findnick(master))
                notice(s_BotServ, source, "New master nick is not registered");
	else if (!is_sr && (stricmp(source, bi->master))) {
	        notice(s_BotServ, source, PMD);
		return;
        } else {
                if (stricmp(master, bi->master))
                {
                        free(bi->master);
                        bi->master = sstrdup(master);
                }
                notice(s_BotServ, source, "Bot \2%s\2 has been changed master to (%s)", nick, bi->master);
	}
     } else if (!stricmp(cmd, "SET")) {
        char *nick = strtok(NULL, " ");
        char *opts = strtok(NULL, " ");
        char *choo = strtok(NULL, " ");
	int is_sr = is_services_root(source);

	if (!nick || !opts || !choo) {
		notice(s_BotServ, source,"Syntax: BOT SET \2botnick\2 \2option\2 \2ON|OFF\2");
		return;
	}
	bi = findbot(nick);
	if (!bi) {
		notice(s_BotServ, source,"This services bot does not exist.");
		return;
	}
	if (stricmp(opts, "MASTER")==0) {
		if (!is_sr && stricmp(source, bi->master)) {
		        notice(s_BotServ, source, PMD);
			return;
		}
		if (stricmp(choo, "ON")==0) {
			bi->flags |= BI_MASTER;
			bi->flags &= ~BI_USER;
			notice(s_BotServ, source,"This services bot can assigned or use by the master only.");
		} else if (stricmp(choo, "OFF")==0) {
			bi->flags |= BI_USER;
			bi->flags &= ~BI_MASTER;
			notice(s_BotServ, source,"This services bot is public for everyone.");
		} else {
			notice(s_BotServ, source,"Syntax: BOT SET \2botnick\2 \2MASTER\2 \2ON|OFF\2.");
		}	
	} else {
		notice(s_BotServ, source,"Syntax: BOT SET \2botnick\2 \2option\2 \2ON|OFF\2");
	}
     } else if (!stricmp(cmd, "DEL")) {
        char *nick = strtok(NULL, " ");

        if (!nick)
		notice(s_BotServ, source,"Syntax: BOT DEL \2botnick\2");
        else if (!(bi = findbot(nick)))
                notice(s_BotServ, source, "This bot does not existed.");
        else
        {
                send_cmd(bi->nick, "QUIT :Quit: Deleted by %s!", source);
                send_cmd(NULL, "UNSQLINE %s", bi->nick);
                delbot(bi);
		notice(s_BotServ, source,"Deleted bot \2%s\2.", nick);
	}
    }
}
/**************************************************************/
void connectbot2()
{
	int i;
	BotInfo *bi;
	for (i = 33; i < 256; ++i)
		for (bi = botlists[i]; bi; bi = bi->next)
		if (bi) {
	                NEWNICK(bi->nick, bi->user, bi->host, bi->real, BOTMODE, 1);
		}
}
/**************************************************************/
void allbotjoin(const char *chan)
{
	int i;
	BotInfo *bi;
	for (i = 33; i < 256; ++i)
		for (bi = botlists[i]; bi; bi = bi->next)
		if (bi) {
                      send_cmd(bi->nick, "JOIN %s", chan);
		}
}
void allbotpart(const char *chan)
{
	int i;
	BotInfo *bi;
	for (i = 33; i < 256; ++i)
		for (bi = botlists[i]; bi; bi = bi->next)
		if (bi) {
                      send_cmd(bi->nick, "PART %s :I'm quit.", chan);
		}
}
/*************************************************************/
int check_ifbot(const char *abotname)
{
	if (findbot(abotname))
           return 1;
        return 0;
}
/************************************************************/
static void change_bot_nick(BotInfo *bi, char *newnick)
{
        if (bi->next)
        bi->next->prev = bi->prev;
    if (bi->prev)
        bi->prev->next = bi->next;
    else
    botlists[tolower(*bi->nick)] = bi->next;

        if (bi->nick) free(bi->nick);
        bi->nick = sstrdup(newnick);

        insert_bot(bi);
}
/***************************************/
static void insert_bot(BotInfo *bi)
{
    /* bi->prev = NULL;
    bi->next = botlist;
    if (bi->next) bi->next->prev = bi;
    botlist = bi; */

    BotInfo *ptr, *prev;

    for (prev = NULL, ptr = botlists[tolower(*bi->nick)];
                        ptr != NULL && stricmp(ptr->nick, bi->nick) < 0;
                        prev = ptr, ptr = ptr->next)
        ;
        bi->prev = prev;
    bi->next = ptr;
    if (!prev)
        botlists[tolower(*bi->nick)] = bi;
    else
        prev->next = bi;
    if (ptr)
        ptr->prev = bi;
}
/************************************************/
void botjoin2(ChannelInfo *ci)
{
        BotInfo *bi;
        Channel *c;
	if (!ci)
		return;
	c = findchan(ci->name);
	if (c && (c->havebot == 1))
		return;

        if (ci && ci->bot) {
		bi = findbot(ci->bot);
                if (bi) {
                      send_cmd(ci->bot, "JOIN %s", ci->name);

#if defined(PROTECTA)
                      send_cmd(ci->bot, "MODE %s +oa %s %s", ci->name, ci->bot, ci->bot);
#elif defined(LIQUID)
                      send_cmd(ci->bot, "MODE %s +ou %s %s", ci->name, ci->bot, ci->bot);
#else
                      send_cmd(ci->bot, "MODE %s +o %s", ci->name, ci->bot);
#endif

                      if (c)
                                c->havebot = 1;
                } else {
                        free(ci->bot);
			ci->bot = NULL;
                }
        }

}
/************************************************/
void botpart2(ChannelInfo *ci, char *newbot)
{
        Channel *c = findchan(ci->name);
        send_cmd(ci->bot, "PART %s :Be right back", ci->name);
	if (c) 
		c->havebot = 0;
	if (ci->bot) {
		free(ci->bot);
		ci->bot = sstrdup(newbot);
	}

}
/************************************************/
void bsconvert(char *nick, char *master)
{
	BotInfo *bi;
        bi = makebot(nick);
        if (!bi)
		return;
        bi->user = "BotServ";
        bi->host = sstrdup(services_host);
        bi->real = "Services Bot";
        bi->master = sstrdup(master);
        bi->created = CTime;
	bi->flags = 0;
	bi->chancount = 0;
}
/************************************************/
int is_botowner(const char *nick, const char *buf)
{
	BotInfo *bi = findbot(buf);
	if (nick && buf && bi)
		if (stricmp(bi->master, nick) == 0)
			return 1;
	return 0;
}
/*************************************************/
static void do_help(const char *source)
{
    const char *cmd = strtok(NULL, "");
    char buf[256];
    snprintf(buf, sizeof(buf), "%s%s", s_BotServ, cmd ? " " : "");
    strscpy(buf+strlen(buf), cmd ? cmd : "", sizeof(buf)-strlen(buf));
    helpserv(s_BotServ, source, buf);
    if (is_services_admin(source)) {
        notice(s_BotServ, source, "For more Help using command /Msg %s HELP OHELP.", s_BotServ);
    }
}
static void do_ohelp(const char *source)
{
    const char *cmd = strtok(NULL, "");
    char buf[BUFSIZE];
    snprintf(buf, sizeof(buf), "%s%s", s_BotServ, cmd ? " oper " : " oper");
    strscpy(buf+strlen(buf), cmd ? cmd : "", sizeof(buf)-strlen(buf));
    helpserv(s_BotServ, source, buf);
    if (!cmd)
        slog("BS - %s requested ohelp: (index)", source);

    if (cmd)
        slog("BS - %s requested ohelp: %s", source, cmd);
}

/************************************************/
static void do_bot_settings(User *u, ChannelInfo *ci, const char *opts, const char *acmd) {

    if (!stricmp(opts, "BOTCOM")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_BOTCOM;
	        notice(s_BotServ, u->nick, "Active bot command in channel.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_BOTCOM;
	        notice(s_BotServ, u->nick, "Disable bot command in channel.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "KICKCAP")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKCAP;
	        notice(s_BotServ, u->nick, "Bot will watch all setence for excess CAPs and ban kick.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKCAP;
	        notice(s_BotServ, u->nick, "Disable Caplock control.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "BOTSTAY")) {
	if (!is_services_admin(u->nick)) {
	        notice(s_BotServ, u->nick, "Only Services Admin can set this option.");
		return;
	}
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_BOTSTAY;
	        notice(s_BotServ, u->nick, "Bot will now stay in the channel.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_BOTSTAY;
	        notice(s_BotServ, u->nick, "Bot will stay in the channel with atleast one user.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "BOLDS")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKBOLDS;
	        notice(s_BotServ, u->nick, "Bot will now kick \2Bolds\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKBOLDS;
	        notice(s_BotServ, u->nick, "Bot won't kick \2Bolds\2 anymore");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "COLORS")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKCOLORS;
	        notice(s_BotServ, u->nick, "Bot will now kick \2Colors\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKCOLORS;
	        notice(s_BotServ, u->nick, "Bot won't kick \2Colors\2 anymore.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "GREET")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_GREET;
	        notice(s_BotServ, u->nick, "Bot will now greet the user info.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_GREET;
	        notice(s_BotServ, u->nick, "Bot will not greet user on join.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "REVERSES")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKREVERSES;
	        notice(s_BotServ, u->nick, "Bot will now kick \2Reverses\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKREVERSES;
	        notice(s_BotServ, u->nick, "Bot won't kick \2Reverses\2 user.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "UNDERLINES")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKUNDERLINES;
	        notice(s_BotServ, u->nick, "Bot will now kick \2Underlines\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKUNDERLINES;
	        notice(s_BotServ, u->nick, "Bot won't kick \2Underlines\2 anymore.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "BADWORDS")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKBADWORDS;
	        notice(s_BotServ, u->nick, "Bot will now kick \2Badwords\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKBADWORDS;
	        notice(s_BotServ, u->nick, "Bot won't kick \2Badwords\2 anymore.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "REPEAT")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKREPEAT;
	        notice(s_BotServ, u->nick, "Bot will now kick \2repeat\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKREPEAT;
	        notice(s_BotServ, u->nick, "Bot won't kick \2repeat\2 anymore.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "FLOOD")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_KICKFLOOD;
	        notice(s_BotServ, u->nick, "Bot will now kick \2flood\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_KICKFLOOD;
	        notice(s_BotServ, u->nick, "Bot won't kick \2flood\2 anymore.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "PROTECTOP")) {
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_PROTOP;
	        notice(s_BotServ, u->nick, "Bot will now \2Protect Op\2.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_PROTOP;
	        notice(s_BotServ, u->nick, "Bot won't \2Protect Op\2  anymore.");
	        show_u_next_db(u, s_BotServ);
	}
#ifdef GAMES
    } else if (!stricmp(opts, "GUESSNUM") && is_tokn(39)) {
        if (!is_services_admin(u->nick)) {
                notice(s_BotServ, u->nick, "Only Services admin can set that.");
                return;
        }
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_GUESSNUM;
	        notice(s_BotServ, u->nick, "Activate Guessing Number Game in your channel.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_GUESSNUM;
	        notice(s_BotServ, u->nick, "DeActivate Guessing Number Game.");
	        show_u_next_db(u, s_BotServ);
	}
    } else if (!stricmp(opts, "GUESSWRM") && is_tokn(39)) {
        if (!is_services_admin(u->nick)) {
                notice(s_BotServ, u->nick, "Only Services admin can set that.");
                return;
        }
        if (!stricmp(acmd, "ON")) {
	        ci->botflag |= CBI_GUESSWRD;
	        notice(s_BotServ, u->nick, "Activate Guessing Word Game in your channel.");
	        show_u_next_db(u, s_BotServ);
	} else {
	        ci->botflag &= ~CBI_GUESSWRD;
	        notice(s_BotServ, u->nick, "DeActivate Guessing Word Game.");
	        show_u_next_db(u, s_BotServ);
	}
#endif
    } else {
	notice(s_BotServ, u->nick, "This option is not exist, please using command /Msg %s HELP SET for more info", s_BotServ);
    }
}
