/* Miscellaneous routines.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services(c) by Andy Church.
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */

#include "../inc/services.h"

/*************************************************************************/

/* toupper/tolower:  Like the ANSI functions, but make sure we return an
 *                   int instead of a (signed) char.
 */ 
int toupper(char c)
{

    if (!isallowed(c))
		return (unsigned char)c;

    if (islower(c))
		return (unsigned char)c - ('a'-'A');
    else
		return (unsigned char)c;
}

int tolower(char c)
{

    if (!isallowed(c))
		return (unsigned char)c;

    if (isupper(c))
		return (unsigned char)c + ('a'-'A');
    else
		return (unsigned char)c;
}
/*************************************************************************/

/* sgets2:  Read a line of text from a socket, and strip newline and
 *          carriage return characters from the end of the line.
 */

char *sgets2(char *buf, long size, int sock)
{
    char *s = sgets(buf, size, sock);
    if (!s || s == (char *)-1)
	return s;
    if (buf[strlen(buf)-1] == '\n')
	buf[strlen(buf)-1] = 0;
    if (buf[strlen(buf)-1] == '\r')
	buf[strlen(buf)-1] = 0;
    return buf;
}

/*************************************************************************/

/* strscpy:  Copy at most len-1 characters from a string to a buffer, and
 *           add a null terminator after the last character copied.
 */

char *strscpy(char *d, const char *s, size_t len)
{
    char *d_orig = d;

    if (!len)
	return d;
    while (--len && (*d++ = *s++))
	;
    *d = 0;
    return d_orig;
}

/*************************************************************************/

/* stristr:  Search case-insensitively for string s2 within string s1,
 *           returning the first occurrence of s2 or NULL if s2 was not
 *           found.
 */

char *stristr(char *s1, char *s2)
{
    register char *s = s1, *d = s2;

    while (*s1) {
	if (tolower(*s1) == tolower(*d)) {
	    s1++; d++;
	    if (*d == 0)
		return s;
	} else {
	    s = ++s1;
	    d = s2;
	}
    }
    return NULL;
}

/*************************************************************************/

/* merge_args:  Take an argument count and argument vector and merge them
 *              into a single string in which each argument is separated by
 *              a space.
 */

char *merge_args(int argc, char **argv)
{
    int i;
    static char s[4096];
    char *t;

    t = s;
    for (i = 0; i < argc; ++i)
	t += snprintf(t, sizeof(s)-(t-s), "%s%s", *argv++, (i<argc-1) ? " " : "");
    return s;
}

/*************************************************************************/

/* match_wild:  Attempt to match a string to a pattern which might contain
 *              '*' or '?' wildcards.  Return 1 if the string matches the
 *              pattern, 0 if not.
 */

int do_match_wild(const char *pattern, const char *str, int docase)
{
    char c;
    const char *s;

    /* This WILL eventually terminate: either by *pattern == 0, or by a
     * trailing '*'. */

    for (;;) {
	switch (c = *pattern++) {
	  case 0:
	    if (!*str)
		return 1;
	    return 0;
	  case '?':
	    if (!*str)
		return 0;
	    ++str;
	    break;
	  case '*':
	    if (!*pattern)
		return 1;	/* trailing '*' matches everything else */
	    s = str;
	    while (*s) {
		if ((docase ? (*s==*pattern) : (tolower(*s)==tolower(*pattern)))
					&& do_match_wild(pattern, s, docase))
		    return 1;
		++s;
	    }
	    break;
	  default:
	    if (docase ? (*str++ != c) : (tolower(*str++) != tolower(c)))
		return 0;
	    break;
	} /* switch */
    }
}

int match_wild(const char *pattern, const char *str)
{
    return do_match_wild(pattern, str, 1);
}

int match_wild_nocase(const char *pattern, const char *str)
{
    return do_match_wild(pattern, str, 0);
}

/*************************************************************************/

/* month_name:  Return the three-character month name corresponding to the
 *              given month number, 1-12.
 */

static char months[12][4] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

char *month_name(int month)
{
    return months[month-1];
}

/*************************************************************************/

/* strupper, strlower:  Convert a string to upper or lower case.
 */

char *strupper(char *s)
{
    char *t = s;
    while (*t)
	*t++ = toupper(*t);
    return s;
}

char *strlower(char *s)
{
    char *t = s;
    while (*t)
	*t++ = tolower(*t);
    return s;
}

/*************************************************************************/

/* read_string, write_string:
 *	Read a string from a file, or write a string to a file, with the
 *	string length prefixed as a two-byte big-endian integer.  The
 *	filename is passed in so that it can be reported in the log file
 *	(and possibly with wallops) if an error occurs.
 */

char *read_string(FILE *f, const char *filename)
{
    char *s;
    int len;

    len = fgetc(f) * 256 + fgetc(f);
    s = smalloc(len);
    if (len != fread(s, 1, len, f))
        fatal_perror("Read error on file: %s", filename);
    return s;
}

char *write_string(const char *s, FILE *f, const char *filename)
{
    int i;

    i = strlen(s) + 1;        /* Include trailing null */
    fputc(i / 256, f);
    fputc(i & 255, f);
    if (i != fwrite(s, 1, i, f))
        fatal_perror("Write error on file: %s", filename);
    return NULL;

}


/*************************************************************************/

int check_servii_kill (const char *source, int ac, char **av)
{
    User *user;
    int server = 0;

    if (!stricmp(av[0],s_ChanServ) || !stricmp(av[0],s_NickServ)
        || !stricmp(av[0],s_OperServ) || !stricmp(av[0],s_MemoServ)
        || !stricmp(av[0],s_GlobalNoticer) || !stricmp(av[0],s_HelpServ) 
	|| !stricmp(av[0],s_Agent)
	|| !stricmp(av[0],s_AdminServ)
#ifndef NONSUPER
        || !stricmp(av[0],s_ServicesX)
	|| !stricmp(av[0],s_ServicesW) 
        || !stricmp(av[0],s_MassServ)
#endif
#ifdef DEFHOSTSERV
|| !stricmp(av[0],s_HostServ)
#endif
	|| !stricmp(av[0],s_BotServ)) {

        if (!stricmp(av[0],s_OperServ))
            introduce_user(s_OperServ);
        if (!stricmp(av[0],s_NickServ))
            introduce_user(s_NickServ);
        if (!stricmp(av[0],s_ChanServ))
            introduce_user(s_ChanServ);
        if (!stricmp(av[0],s_GlobalNoticer))
            introduce_user(s_GlobalNoticer);
        if (!stricmp(av[0],s_MemoServ))
            introduce_user(s_MemoServ);
        if (!stricmp(av[0],s_HelpServ))
            introduce_user(s_HelpServ);
        if (!stricmp(av[0],s_Agent))
            introduce_user(s_Agent);
#ifndef NONSUPER
        if (!stricmp(av[0],s_ServicesX))
            introduce_user(s_ServicesX);
        if (!stricmp(av[0],s_ServicesW))
            introduce_user(s_ServicesW);
        if (!stricmp(av[0],s_MassServ))
            introduce_user(s_MassServ);
#endif
#ifdef DEFHOSTSERV
        if (!stricmp(av[0],s_HostServ))
            introduce_user(s_HostServ);
#endif
        if (!stricmp(av[0],s_BotServ))
            introduce_user(s_BotServ);
#ifdef WEBSERVICE
        if (!stricmp(av[0],s_WebServ))
            introduce_user(s_WebServ);
#endif
        if (!stricmp(av[0],s_AdminServ))
            introduce_user(s_AdminServ);

	user = finduser(source);
	if (!user)
        	server = 1;

        if (!server) {
            notice(s_GlobalNoticer,source,"Do \2*NOT*\2 kill services!");
            wallops(NULL,"%s Tried to kill a services client!", source);
            send_cmd(NULL, "%s %s -oaSA", istoken?TOK_SVSMODE:MSG_SVSMODE, source);
            return 1;
        } else
            wallops(SERVER_NAME,"%s revived after server kill", av[0]);

    }
    return 0;
}


/*************************************************************************/
/* Convert a number to a string (reverse of atoi). */
/* Copy from wrecked */
char *myctoa (char c)
{
    static char ret[2];
    ret[0] = c;
    ret[1] = 0;
    return ret;
}

char *myitoa (int num)
{
    static char ret[32];
    sprintf (ret, "%d", num);
    return ret;
}

int hasmode (const char *mode, const char *modestr)
{
    int i, j, k, add = 1;
    char mode_on[64], mode_off[64];

    /* Modes we want, or dont want */
    for (i=0, j=0, k=0; mode[i]; i++)
    {
        if (mode[i]=='+') add = 1;
        else if (mode[i]=='-') add = 0;
        else if ((mode[i] >= 65 && mode[i] <= 90) ||   /* A-Z */
                 (mode[i] >= 97 && mode[i] <= 122))    /* a-z */
        {
            add ? (mode_on[j] = mode[i]) : (mode_off[k] = mode[i]);
            add ? j++ : k++;
        }
        mode_on[j] = mode_off[k] = 0;
    }

    /* What we DO need is there ... */
    for (i=0; mode_on[i]; i++)
    {
        for (j=0; modestr[j]; j++)
            if (mode_on[i]==modestr[j])
                break;
        if (!(modestr[j]))
            return 0;
    }
    /* What we DONT want isnt there ... */
    for (i=0; mode_off[i]; i++)
    {
        for (j=0; modestr[j]; j++)
            if (mode_off[i]==modestr[j])
                break;
        if (modestr[j])
            return 0;
    }
    return 1;
}


char *changemode (const char *mode, const char *modestr)
{
    int i, j, k, add = 1;
    char mode_on[64], mode_off[64];
    static char newmodestr[64];
    strscpy (newmodestr, "", sizeof(newmodestr));

    /* Modes we want, or dont want */
    for (i=0, j=0, k=0; mode[i]; i++)
    {
	if (mode[i]=='+') add = 1;
	else if (mode[i]=='-') add = 0;
	else if ((mode[i] >= 65 && mode[i] <= 90) ||   /* A-Z */
		 (mode[i] >= 97 && mode[i] <= 122))    /* a-z */
	{
	    add ? (mode_on[j] = mode[i]) : (mode_off[k] = mode[i]);
	    add ? j++ : k++;
	}
	mode_on[j] = mode_off[k] = 0;
    }

    k=0;
    for (i=0; modestr[i]; i++)
    {
	for (j=0; mode_off[j]; j++)
	    if (mode_off[j]==modestr[i])
		break;
	if (!(mode_off[j]))
	{
	    newmodestr[k] = modestr[i];
	    k++; newmodestr[k] = 0;
	}
    }

    for (i=0; mode_on[i]; i++)
    {
	for (j=0; newmodestr[j]; j++)
	    if (mode_on[i]==newmodestr[j])
		break;
	if (!(newmodestr[j]))
	{
	    newmodestr[k] = mode_on[i];
	    k++; newmodestr[k] = 0;
	}
    }
 	return newmodestr;
}

