/* Services -- main source file.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean
 *     E-mail: auspice@auspice.org
 * SirvNET Services is copyright (c) 1998-2000 Trevor Klingbeil.
 *     E-mail: <priority1@dal.net>
 * Originally based on EsperNet Services (c) 1996-1998 Andy Church.
 *     E-mail: <achurch@dragonfire.net>
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file LICENSE); if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../inc/services.h"
#include "../inc/timeout.h"

/******** Global variables! ********/

/* These can all be set by options. */
char *services_dir = SERVICES_DIR;	/* -dir directory */
time_t	CTime;
int snooplog_okay = 0;
int sndebug = 0;                        /* -snoop debug */
int debug = 0;				/* -debug */
int nofork = 0;				/* -nofork */
int sendstat = 0;
int op_checking = 0;                    /* Don't touch, internal switch */
int dbcnt = 1;
int backdb = 0;
#if REG_SAVES > 0
   int regcnt = 0;
#endif
/* Set to 1 if we are to quit */
int quitting = 0;

/* Set to 1 if we are to quit after saving databases */
int delayed_quit = 0;

/* Contains a message as to why services is terminating */
char *quitmsg = NULL;

/* Input buffer - global, so we can dump it if something goes wrong */
char inbuf[BUFSIZE];

char *snchan = NULL;

/* Socket for talking to server */
int servsock = -1;

/* Should we update the databases now? */
int save_data = 0;

/* At what time were we started? */
time_t start_time;
time_t d_check_time;
time_t h_check_time;
time_t m_check_time;
time_t last_update;

char *added;

/* TS3 */
#define TS_VERSION    "TS"
#define TS_MIN         1
#define TS_CURRENT     3

/******** Local variables! ********/

/* Set to 1 if we are waiting for input */
static int waiting = 0;

/* Set to 1 after we've set everything up */
static int started = 0;

/* If we get a signal, use this to jump out of the main loop. */
static jmp_buf panic_jmp;

/*************************************************************************/
int istoken = 0;

void savebugs(char *logss)
{
    time_t t;
    struct tm tm;
    char buf[256];
    FILE *savedabugs;
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y]", &tm);

    savedabugs = fopen("bugs.nfo", "a");
    if (savedabugs) {
        fprintf(savedabugs, "**************** %s ****************\n", buf);
        fprintf(savedabugs, "%s\n",logss);
        fprintf(savedabugs, "Connected in: %li\n", connectscnt);
        fprintf(savedabugs, "com: %li  nsreg: %li  csreg: %li\n",serv_com, nsreg, csreg);
        fprintf(savedabugs, "nsid: %li  fails: %li  csid: %li fails: %li\n",nsid, nsidf, csid, csidf);
        fprintf(savedabugs, "nsset: %li  csset: %li  nsdrop: %li csdrop: %li\n",nsset, csset, nsdrop, csdrop);
        fprintf(savedabugs, "ghost: %li  news: %li  csbot: %li\n",ghost, news, csbot);
	fclose(savedabugs);
    }
}
/*************************************************************************/

/* If we get a weird signal, come here. */

static void sighandler(int signum)
{
    if (started) {
	if (signum == SIGHUP) {  /* SIGHUP = save databases and restart */
	    save_data = -2;
	    signal(SIGHUP, SIG_IGN);
	    return;
	} else if (signum == SIGTERM || signum == SIGINT || signum == SIGQUIT) {
	    /* nothing */
	} else if (!waiting) {
	    savebugs(inbuf);
	    log("PANIC! buffer = %s", inbuf);
	    /* Cut off if this would make IRC command >510 characters. */
	    if (strlen(inbuf) > 448) {
		inbuf[446] = '>';
		inbuf[447] = '>';
		inbuf[448] = 0;
	    }
	    wallops(NULL, "PANIC! buffer = %s\r\n", inbuf);
        } else if (waiting == -11) {
	        savebugs("PANIC! Error in saving databases back-up files");
                log("PANIC! Error in saving databases back-up files");
                wallops(SERVER_NAME, "PANIC! waiting=%d Error in saving database back-up files! (%s)",
                   waiting, strsignal(signum));

	} else if (waiting < 0) {
	    if (waiting == -1) {
		log("PANIC! in timed_update (%s)", strsignal(signum));
		wallops(NULL, "PANIC! in timed_update (%s)", strsignal(signum));
	    } else {
		log("PANIC! waiting=%d (%s)", waiting, strsignal(signum));
		wallops(NULL, "PANIC! waiting=%d (%s)", waiting, strsignal(signum));
	    }
	}
    }
    if (signum == SIGUSR1 || !(quitmsg = malloc(BUFSIZE))) {
	quitmsg = "Out of memory!";
	quitting = 1;
    } else {
#if HAVE_STRSIGNAL
	snprintf(quitmsg, BUFSIZE, "Services terminating: %s", strsignal(signum));
#else
	snprintf(quitmsg, BUFSIZE, "Services terminating on signal %d", signum);
#endif
	quitting = 1;
    }
    if (started)
	longjmp(panic_jmp, 1);
    else {
	log("%s", quitmsg);
	exit(1);
    }
}

/*************************************************************************/


/* We've hit something we can't recover from.  Let people know what
 * happened, then go down.
 */

void fatal(const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256], buf2[4096];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y]", &tm);
    vsnprintf(buf2, sizeof(buf2), fmt, args);
    if (logfile)
        fprintf(logfile, "%s FATAL: %s\n", buf, buf2);
    if (nofork)
        fprintf(stderr, "%s FATAL: %s\n", buf, buf2);
    if (servsock >= 0)
        wallops(NULL, "FATAL ERROR!  %s", buf2);
    exit(1);
}

/* Same thing, but do it like perror().
 */

void fatal_perror(const char *fmt,...)
{
    va_list args;
    time_t t;
    struct tm tm;
    char buf[256], buf2[4096];

    va_start(args, fmt);
    time(&t);
    tm = *localtime(&t);
    strftime(buf, sizeof(buf)-1, "[%b %d %H:%M:%S %Y]", &tm);
    vsnprintf(buf2, sizeof(buf2), fmt, args);
    if (logfile)
        fprintf(logfile, "%s FATAL: %s: %s\n", buf, buf2, strerror(errno));
    if (stderr)
        fprintf(stderr, "%s FATAL: %s: %s\n", buf, buf2, strerror(errno));
    if (servsock >= 0)
        wallops(NULL, "FATAL ERROR!  %s: %s", buf2, strerror(errno));
    exit(1);

}

/*************************************************************************/

/* Send a NICK command for the given pseudo-client.  If `user' is NULL,
 * send NICK commands for all the pseudo-clients. */
#ifdef NICKV2
	#define NICK(nick,user,host,name) do { send_cmd(NULL, "NICK %s 1 %lu %s %s %s 1 + * :%s", (nick), time(NULL), (user), (host),server_name, (name)); } while (0)
#elif defined(BAHAMUT)
	#define NICK(nick,user,host,name) do { send_cmd(NULL, "NICK %s 1 %lu %s %s %s %s %lu :%s", (nick), time(NULL), "+" ,(user), (host),server_name, time(NULL), (name)); } while (0)
#elif defined(IRCUP9)
	#define NICK(nick,user,host,name) do { send_cmd(NULL, "NICK %s 1 %lu %s %s %s :%s", (nick), time(NULL), (user), (host), server_name, (name)); } while (0)
#else
	#define NICK(nick,user,host,name) do { send_cmd(NULL, "NICK %s 1 %lu %s %s %s %lu :%s", (nick), time(NULL), (user), (host), server_name, time(NULL), (name)); } while (0)
#endif
void introduce_user(const char *user)
{
    if (!user || stricmp(user, s_NickServ) == 0) {
	NICK(s_NickServ, services_user, services_host, "Nick Registration Service");
        send_cmd(s_NickServ, "MODE %s +dqS", s_NickServ);
    }
    if (!user || stricmp(user, s_ChanServ) == 0) {
	NICK(s_ChanServ, services_user, services_host, "Channel Registration Service");
        send_cmd(s_ChanServ, "MODE %s +qdS", s_ChanServ);
    }
    if (!user || stricmp(user, s_HelpServ) == 0) {
	NICK(s_HelpServ, services_user, services_host, "Help Services");
        send_cmd(s_HelpServ, "MODE %s +dqS", s_HelpServ);
    }
    if (!user || stricmp(user, s_MemoServ) == 0) {
	NICK(s_MemoServ, services_user, services_host, "Memo Services");
        send_cmd(s_MemoServ, "MODE %s +dqS", s_MemoServ);
    }

    if (!user || stricmp(user, s_Agent) == 0) {
            NICK(s_Agent, services_user, services_host, "General Services Agent");
            send_cmd(s_Agent, "MODE %s +dqS", s_Agent);
    }
#ifndef NONSUPER
    if (!user || stricmp(user, s_ServicesX) == 0) {
            NICK(s_ServicesX, services_user, services_host, "Channel Services Agent");
            send_cmd(s_ServicesX, "MODE %s +dqS", s_ServicesX);
    }

    if (!user || stricmp(user, s_ServicesW) == 0) {
            NICK(s_ServicesW, services_user, services_host, "Nickname Services Agent");
            send_cmd(s_ServicesW, "MODE %s +dqS", s_ServicesW);
    }
    if (!user || stricmp(user, s_MassServ) == 0) {
        NICK(s_MassServ, services_user, services_host, "Mass Service");
        send_cmd(s_MassServ, "MODE %s +dqS", s_MassServ);
    }
#endif
    if (!user || stricmp(user, s_OperServ) == 0) {
	NICK(s_OperServ, services_user, services_host, "Operator Services");
	send_cmd(s_OperServ, "MODE %s +odqS", s_OperServ);
    }
    if (!user || stricmp(user, s_RootServ) == 0) {
        NICK(s_RootServ, services_user, services_host, "Root Administration Service");
        send_cmd(s_RootServ, "MODE %s +dqS", s_RootServ);
    }
    if (!user || stricmp(user, s_AdminServ) == 0) {
        NICK(s_AdminServ, services_user, services_host, "Administration Services");
        send_cmd(s_AdminServ, "MODE %s +dqS", s_AdminServ);
    }
#ifdef WEBSERVICE
    if (!user || stricmp(user, s_WebServ) == 0) {
        NICK(s_WebServ, services_user, services_host, "WebTV Services");
        send_cmd(s_WebServ, "MODE %s +dqS", s_WebServ);
    }
#endif
    if (!user || stricmp(user, s_GlobalNoticer) == 0) {
	NICK(s_GlobalNoticer, services_user, services_host, "Global Noticer");
	send_cmd(s_GlobalNoticer, "MODE %s +dqS", s_GlobalNoticer);
    }
#ifdef DEFHOSTSERV
    if (!user || stricmp(user, s_HostServ) == 0) {
        NICK(s_HostServ, services_user, services_host, "Host Name Service");
        send_cmd(s_HostServ, "MODE %s +dqS", s_HostServ);
    }
#endif
    if (!user || stricmp(user, s_BotServ) == 0) {
        NICK(s_BotServ, services_user, services_host, "Bot Services");
        send_cmd(s_BotServ, "MODE %s +dqBS", s_BotServ);
    }
    if (!user || stricmp(user, s_SpamChecker) == 0) {
	NICK(s_SpamChecker, SpamUser, Spamhost, Spamreal);
    }
    if (!user) {
	    connectbot2();
	    do_checkbot();
    }

}

#undef NICK
/*************************************************************************/
/*************************************************************************/

/* Initialization/cleanup routines: */

/*************************************************************************/

/* Set group name if necessary.  Return 0 if successful (or if RUNGROUP not
 * defined), else print an error message to logfile and return -1.
 */

static int set_group(void)
{
#ifdef RUNGROUP
    struct group *gr;

    setgrent();
    while (gr = getgrent()) {
	if (strcmp(gr->gr_name, RUNGROUP) == 0)
	    break;
    }
    endgrent();
    if (gr) {
	setgid(gr->gr_gid);
	return 0;
    } else {
	fprintf(logfile, "Unknown group `%s'\n", RUNGROUP);
	return -1;
    }
#else
    return 0;
#endif
}

/*************************************************************************/

/* Parse command-line options.  Return 0 if all went well, -1 for an error
 * with an option, or 1 for -help.
 */

static int parse_options(int ac, char **av)
{
    int i;
    char *s;

    for (i = 1; i < ac; ++i) {
	s = av[i];
	if (*s == '-') {
	    ++s;

            if (strcmp(s, "readonly") == 0) {
		readonly = 1;
	    } else if (strcmp(s, "up11") == 0) {
		DATAUP = 3;
	    } else if (strcmp(s, "upmlock") == 0) {
		DATAUP = 4;
	    } else if (strcmp(s, "upone") == 0) {
		DATAUP = 5;
	    } else if (strcmp(s, "nofork") == 0) {
		nofork = 1;
	    } else {
		fprintf(stderr, "Unknown option -%s\n", s);
		return -1;
	    }
	} else {
	    fprintf(stderr, "Non-option arguments not allowed\n");
	    return -1;
	}
    }
    return 0;
}

/*************************************************************************/

/* Remove our PID file.  Done at exit. */

static void remove_pidfile(void)
{
    remove(PID_FILE);
}

/*************************************************************************/

/* Create our PID file and write the PID to it. */

static void write_pidfile(void)
{
    FILE *pidfile;

    pidfile = fopen(PID_FILE, "w");
    if (pidfile) {
	fprintf(pidfile, "%d\n", getpid());
	fclose(pidfile);
	atexit(remove_pidfile);
    } else {
	log_perror("Warning: cannot write to PID file %s", PID_FILE);
    }
}

/*************************************************************************/

/* Overall initialization routine. */

static int init(int ac, char **av)
{
    FILE *anews;
    char newspath[128];
    int i;

    /* Set file creation mask and group ID. */
#ifdef DEFUMASK
    umask(DEFUMASK);
#endif
    if (set_group() < 0)
	return 1;
    
    /* Parse options. */
    parse_options(ac, av);

    /* Chdir to Services data directory. */
    if (chdir(services_dir) < 0) {
	fprintf(stderr, "chdir(%s): %s\n", services_dir, strerror(errno));
	return 1;
    }
    if (chdir("./logs") < 0) {
        fprintf(stderr, "chdir(data/logs): %s\n", strerror(errno));
        return 1;
    } else {
       if (chdir("..") < 0) {
          fprintf(stderr, "Directory Structure Error..Aborting\n");
          return 1;
       }
    }

    srand(time(NULL));

    /* Detach ourselves if requested. */
    if (!nofork) {
	if ((i = fork()) < 0) {
	    perror("fork()");
	    return 1;
	} else if (i != 0) {
	    exit(0);
	}
	if (setpgid(0, 0) < 0) {
	    perror("setpgid()");
	    return 1;
	}
    }

    /* Open logfile. */
#ifdef SENDLOG
    open_log();
#endif
    open_slog();
    create_dummy_logs();

    /* Write our PID to the PID file. */
    write_pidfile();

    /* Announce ourselves to the logfile. */

    if (debug || readonly) {
	log("Services starting up (options:%s%s)",
		debug ? " debug" : "", readonly ? " readonly" : "");
    } else {
	log("Services starting up (normal mode)");
    }


    start_time = time(NULL);
    d_check_time = time(NULL) + 86400;
    h_check_time = time(NULL) + 3600;
    m_check_time = time(NULL) + 60;

    /* If in read-only mode, close the logfile again. */
#ifdef SENDLOG
    if (readonly) {
	close_log();
        close_slog();
    }
#endif
#ifdef SJOIN
    load_sjoin_mem();
    log("Allocated SJOIN memory");
#endif

    /* Set signal handlers. */
    signal(SIGINT, sighandler);
    signal(SIGTERM, sighandler);
    signal(SIGPIPE, SIG_IGN);		/* We don't care about broken pipes */
    signal(SIGQUIT, sighandler);
    signal(SIGSEGV, sighandler);
    signal(SIGBUS, sighandler);
    signal(SIGQUIT, sighandler);
    signal(SIGHUP, sighandler);
    signal(SIGILL, sighandler);
    signal(SIGTRAP, sighandler);
#if defined(SIGIOT) && (!defined(SIGABRT) || SIGIOT != SIGABRT)
    signal(SIGIOT, sighandler);
#endif
    signal(SIGFPE, sighandler);
    signal(SIGALRM, SIG_IGN);		/* Used by sgets() for read timeout */
    signal(SIGUSR2, SIG_IGN);
    signal(SIGCHLD, SIG_IGN);
    signal(SIGWINCH, SIG_IGN);
    signal(SIGTTIN, SIG_IGN);
    signal(SIGTTOU, SIG_IGN);
    signal(SIGTSTP, SIG_IGN);

    signal(SIGUSR1, sighandler);  /* This is our "out-of-memory" panic switch */

    /* Read Configuration File */
    slog("Searching .conf file");
    init_conf();
    init_netconf();

    slog("Successfully loaded .conf file");

    /* Load up databases */
    load_ns_dbase();
    load_cs_dbase();
    load_ms_dbase();
    load_os_dbase();
    load_akill();
    load_ignore();
    load_qline_db();
#ifdef ALLOW_GLINE
    load_gline_db();
#endif
    load_zline();
    load_trigger();
    load_badwords_db();
#ifdef SENDLOG
    load_log_db();
#endif
#ifdef DEFHOSTSERV
    load_hline_db();
#endif
#ifdef WGAME
    load_wordgame_db();
#endif
    load_chtml_db();
    load_msg_db();
    load_majoin_db();
    load_bs2_db();
    load_admin_db();
    load_auth_db();
    log("Databases loaded");
    fflush(stdout);
    check_logs();
/* check to see to email services logs */

    *newspath = 0;
    strcat(newspath, HELPSERV_DIR); strcat(newspath, "/news");

    anews = fopen(newspath, "r");
    if (anews) {
        fseek(anews, 0L, SEEK_END);
        news_size = ftell(anews);
        fclose(anews);
    }

    /* Connect to the remote server */
    servsock = conn(remote_server, remote_port);
    if (servsock < 0) {
	log_perror("Can't connect to server");
	return 1;
    }

#ifdef BAHAMUT
    send_cmd(NULL, "PASS %s :TS", PASSWORD);
    send_cmd(NULL, "CAPAB SSJOIN TS5 UNCONNECT");
    send_cmd(NULL, "SERVER %s 1 :%s", server_name, server_desc);
    send_cmd(NULL, "SVINFO 3 1 0 :%lu", time(NULL));
#elif defined (IRCUP9)
    send_cmd(NULL, "PASS :%s", PASSWORD);
    send_cmd(NULL, "SERVER %s 1 %lu %lu P09 :%s", server_name, CTime, CTime, server_desc);
#elif defined(UNREAL)
    send_cmd(NULL, "PASS :%s", PASSWORD);
    send_cmd (NULL, "PROTOCTL TOKEN VL VHP NICKv2 SJOIN SJOIN2 SJ3");
    send_cmd (NULL, "SERVER %s 1 :U%s-*-%s %s", server_name, "0", server_num , server_desc);
#elif defined(RAGEIRCD)
    send_cmd(NULL, "PASS :%s", PASSWORD);
    send_cmd (NULL, "SERVER %s 1 :%s", server_name, server_desc);
#else
    send_cmd(NULL, "PASS :%s", PASSWORD);
    send_cmd (NULL, "SERVER %s 1 :%s", server_name, server_desc);
#endif

    sgets2(inbuf, sizeof(inbuf), servsock);
    if (strnicmp(inbuf, "ERROR", 5) == 0) {
	log("Remote server returned: %s", inbuf);
	return 1;
    }

    /* Bring in our pseudo-clients */
    introduce_user(NULL);

    /* add QLINED nicks from s_qline list */

    check_qlines();
    check_zlines();
#ifdef ALLOW_GLINE
    check_glines();
#endif

    /* Success! */

    snooplog_okay = 1;
    slog("Services successfully loaded");
    printf("\nLoading Auspice Services 2.5.x - (c) 2000-2001 In Mean\n");
    return 0;
}

/*************************************************************************/
/*************************************************************************/

/* Main routine.  (What does it look like? :-) ) */

int main(int ac, char **av, char **envp)
{
/*  time_t last_update; */  /* When did we last update the databases? */
    time_t last_check;	/* When did we last check NickServ timeouts? */
    int i;
    char *progname;

    /* Find program name. */
    progname = strrchr(av[0], '/');
    if (progname)
	++progname;
    else
	progname = av[0];

    /* Were we run under "listnicks" or "listchans"?  Do appropriate stuff
     * if so. */

#ifndef CYGWIN
    if (strcmp(progname, "listnicks") == 0) {
	do_listnicks(ac, av);
	return 0;
    } else if (strcmp(progname, "listchans") == 0) {
	do_listchans(ac, av);
	return 0;
    } else if (strcmp(progname, "listmemos") == 0) {
	do_listmemos(ac, av);
	return 0;
    }
#endif

    /* Initialization stuff. */

#ifdef UNREAL
    istoken = 1;
#endif
    if ((i = init(ac, av)) != 0)
	return i;

    ns_install_timeouts();

#ifndef CYGWIN
   memset(av[0], 0 , strlen(av[0]));
   strcpy(av[0], "Auspice 2.5.x");
#endif

    /* We have a line left over from earlier, so process it first. */
    process();

    last_update = time(NULL);

    /* The signal handler routine will drop back here with quitting != 0
     * if it gets called. */
    setjmp(panic_jmp);
    started = 1;

    /*** Main loop. ***/

    while (!quitting) {
	CTime = time(NULL);
	waiting = -3;
	if (!readonly && (save_data || CTime - last_update >= update_timeout)) {
	    /* First, check for expired nicks/channels */

#if REG_SAVES > 0
            regcnt = 0;
#endif
	    if (debug)
		log("debug: Running expire routines");

            if (DISPLAY_UPDATES > 0)
               wallops(SERVER_NAME, "Running Database Store & Expire #%d",
                   dbcnt);
            dbcnt++;
            slog("!! Running expire routines");
	    waiting = -22;
	    expire_nicks();
	    waiting = -23;
	    expire_chans();
            waiting = -24;
	    expire_akills();
	    waiting = -25;
            expire_ignores();
            waiting = -25.1;
            expire_memos();
            waiting = -26;
            expire_auth();
            slog("!! Database Expire Completed");

	    /* Now actually save stuff */
	    waiting = -2;
	    if (debug) {
	            slog("!! Saving Databases");
	            log("debug: Saving databases");
	    }
	    waiting = -11;
	    save_ns_dbase();
	    waiting = -12;
	    save_cs_dbase();
	    waiting = -13;
	    save_ms_dbase();
	    waiting = -14;
	    save_os_dbase();
	    waiting = -15;
	    save_akill();
            waiting = -15.1;
            save_ignore();
            waiting = -15.2;
	    save_trigger();
            waiting = -16;
            save_qline_db();
            waiting = -19;
            save_zline();
#ifdef DEFHOSTSERV
            waiting = -20;
            save_hline_db();
#endif
            waiting = -21.1;
	    save_bs2_db();
            waiting = -21.2;
	    save_message();
            waiting = -21.4;
	    save_majoin_db();
            waiting = -21.5;
	    save_badwords_db();
            waiting = -21.6;
	    save_admin_db();
            waiting = -21.7;
	    save_auth_db();
	    make_channel_html();
	    make_netstats_html();
            backdb++;
            if ((BACKUP_DB > 0) && (backdb > BACKUP_DB))
                backup_database();

            log("!! Databases Stored");
            if (save_data < 0)
		break;	/* out of main loop */

	    save_data = 0;
	    last_update = CTime;
	}
	if (delayed_quit)
	    break;

	waiting = -1;

	if (CTime - last_check >= TIMEOUT_CHECK) {
            check_timeouts();
            expire_akills();
            expire_ignores();
            check_logs();
	    last_check = CTime;
        }


	waiting = 1;
	i = (int)sgets2(inbuf, sizeof(inbuf), servsock);
	waiting = 0;

	if (i > 0) {
	    process();
	} else if (i == 0) {
	    quitmsg = malloc(BUFSIZE);
	    if (quitmsg)
		snprintf(quitmsg, BUFSIZE, "Read error from server: %s", strerror(errno));
	    else
		quitmsg = "Read error from server";
	    quitting = 1;
	}
	waiting = -4;
    }

    /* Check for restart instead of exit */
    if (save_data == -2) {
#ifdef SERVICES_BIN
	log("Restarting");
	if (!quitmsg)
	    quitmsg = "Restarting";
#ifdef IRCUP9
	send_cmd(server_name, "%s %s 0 :%s", istoken?TOK_SQUIT:MSG_SQUIT, server_name, quitmsg);
#else
	send_cmd(server_name, "%s %s :%s", istoken?TOK_SQUIT:MSG_SQUIT, server_name, quitmsg);
#endif
	disconn(servsock);
        if (chdir("..") < 0) {
             fprintf(stderr, "Unknown error in directory structure (attemped re-loading binary)");
             fatal_perror("Restart failed");
        }
	execve(SERVICES_BIN, av, envp);
	log_perror("Restart failed");
	return 1;
#else
	quitmsg = "Restart attempt failed--SERVICES_BIN not defined (rerun configure)";
#endif
    }

    /* Disconnect and exit */
    if (!quitmsg) 
	quitmsg = "Terminating, reason unknown";
    log("%s", quitmsg);
    if (started)
	send_cmd(server_name, "%s %s :%s",istoken?TOK_SQUIT:MSG_SQUIT, server_name, quitmsg);
    disconn(servsock);
    return 0;
}
