/* Auspice functions.
 *
 * Auspice Services is copyright (c) 2000-2001 In Mean.
 *     E-mail: <auspice@auspice.org>
 *
 * This program is free but copyrighted software; see the file LICENSE for
 * details.
 */
#include "../inc/services.h"
#ifndef NONSUPER
void massserv(const char *source, char *buf)
{
    char *cmd, *s, *chan;
    char orig[BUFSIZE];
    strscpy (orig, buf, sizeof (orig));
    cmd = strtok(buf, " ");

    if (cmd) {
	    if (stricmp (cmd, "\1PING") == 0)
	    {
	        if (!(s = strtok (NULL, "")))
	            s = "\1";
	        notice(s_MassServ, source, "\1PING %s", s);

	    } else if (stricmp (cmd, "\1VERSION\1") == 0) {
	        if (!(s = strtok (NULL, "")))
        	    s = "\1";
	        notice(s_MassServ, source, "%sVERSION Auspice IRC Services %s", s, s);

	    } else if (!is_services_root(source)) {
		notice(s_MassServ, source, "Permission denied.");
	       	return;
	    } else if (stricmp(cmd, "JOIN") == 0) {

		if (!is_services_root(source)) {
			notice(s_MassServ, source, "Permission denied.");
		       	return;
		}
		chan = strtok(NULL, " ");
		if (!chan) {
			notice(s_MassServ, source, "Syntax: JOIN \2Channel\2");
		} else {
		        send_cmd (s_MassServ, "JOIN %s", chan);
		}

	    } else if (stricmp(cmd, "PART") == 0) {

		if (!is_services_root(source)) {
			notice(s_MassServ, source, "Permission denied.");
		       	return;
		}
		chan = strtok(NULL, " ");
		if (!chan) {
			notice(s_MassServ, source, "Syntax: PART \2Channel\2");
		} else {
		        send_cmd (s_MassServ, "PART %s", chan);
		}

            } else if (stricmp(cmd, "SERVJOIN") == 0) {
	        chan = strtok(NULL, " ");
		if (!is_services_root(source)) {
			notice(s_MassServ, source, "Permission denied.");
		       	return;
		}
	        if (!chan) {
		    notice(s_MassServ, source, "Syntax: SERVJOIN <channel>");
	            return;
		}
		send_cmd(s_OperServ, "JOIN %s", chan);
		send_cmd(s_OperServ, "MODE %s +o %s", chan, s_OperServ);
		send_cmd(s_RootServ, "JOIN %s", chan);
	        send_cmd(s_RootServ, "MODE %s +o %s", chan, s_RootServ);
	        send_cmd(s_NickServ, "JOIN %s", chan);
	        send_cmd(s_NickServ, "MODE %s +o %s", chan, s_NickServ);
	        send_cmd(s_ChanServ, "JOIN %s", chan);
	        send_cmd(s_ChanServ, "MODE %s +o %s", chan, s_ChanServ);
	        send_cmd(s_MemoServ, "JOIN %s", chan);
	        send_cmd(s_MemoServ, "MODE %s +o %s", chan, s_MemoServ);
	        send_cmd(s_HelpServ, "JOIN %s", chan);
	        send_cmd(s_HelpServ, "MODE %s +o %s", chan, s_HelpServ);
	        send_cmd(s_Agent, "JOIN %s", chan);
	        send_cmd(s_Agent, "MODE %s +o %s", chan, s_Agent);
#ifndef NONSUPER
	        send_cmd(s_ServicesX, "JOIN %s", chan);
	        send_cmd(s_ServicesX, "MODE %s +o %s", chan, s_ServicesX);
	        send_cmd(s_ServicesW, "JOIN %s", chan);
	        send_cmd(s_ServicesW, "MODE %s +o %s", chan, s_ServicesW);
	        send_cmd(s_MassServ, "JOIN %s", chan);
	        send_cmd(s_MassServ, "MODE %s +o %s", chan, s_MassServ);
#endif
	        send_cmd(s_GlobalNoticer, "JOIN %s", chan);
	        send_cmd(s_GlobalNoticer, "MODE %s +o %s", chan, s_GlobalNoticer);
	        send_cmd(s_SpamChecker, "JOIN %s", chan);
	        send_cmd(s_SpamChecker, "MODE %s +o %s", chan, s_SpamChecker);
	        send_cmd(s_BotServ, "JOIN %s", chan);
	        send_cmd(s_BotServ, "MODE %s +o %s", chan, s_BotServ);
#ifdef DEFHOSTSERV
	        send_cmd(s_HostServ, "JOIN %s", chan);
	        send_cmd(s_HostServ, "MODE %s +o %s", chan, s_HostServ);
#endif
#ifdef WEBSERVICE
	        send_cmd(s_WebServ, "JOIN %s", chan);
	        send_cmd(s_WebServ, "MODE %s +o %s", chan, s_WebServ);
#endif
	        send_cmd(s_AdminServ, "JOIN %s", chan);
	        send_cmd(s_AdminServ, "MODE %s +o %s", chan, s_AdminServ);
            } else if (stricmp(cmd, "SERVPART") == 0) {
	        chan = strtok(NULL, " ");
		if (!is_services_root(source)) {
			notice(s_MassServ, source, "Permission denied.");
		       	return;
		}
	        if (!chan) {
		    notice(s_MassServ, source, "Syntax: SERVPART <channel>");
	            return;
		}
	        send_cmd(s_OperServ, "PART %s", chan);
	        send_cmd(s_RootServ, "PART %s", chan);
	        send_cmd(s_NickServ, "PART %s", chan);
	        send_cmd(s_ChanServ, "PART %s", chan);
	        send_cmd(s_MemoServ, "PART %s", chan);
	        send_cmd(s_HelpServ, "PART %s", chan);
	        send_cmd(s_Agent, "PART %s", chan);
#ifndef NONSUPER
	        send_cmd(s_ServicesX, "PART %s", chan);
	        send_cmd(s_ServicesW, "PART %s", chan);
	        send_cmd(s_MassServ, "PART %s", chan);
#endif
	        send_cmd(s_GlobalNoticer, "PART %s", chan);
	        send_cmd(s_SpamChecker, "PART %s", chan);
	        send_cmd(s_BotServ, "PART %s", chan);
#ifdef DEFHOSTSERV
	        send_cmd(s_HostServ, "PART %s", chan);
#endif
#ifdef WEBSERVICE
	        send_cmd(s_WebServ, "PART %s", chan);
#endif
	        send_cmd(s_AdminServ, "PART %s", chan);


	    } else if (stricmp(cmd, "ALLBOTJOIN") == 0 ) {
		        chan = strtok(NULL, " ");
				if (!is_services_root(source)) {
					notice(s_MassServ, source, "Permission denied.");
				} else if (!chan) {
					notice(s_MassServ, source, "Syntax: ALLBOTJOIN <channel>");
				} else {
					allbotjoin(chan);
				}

	    } else if (stricmp(cmd, "ALLBOTPART") == 0 ) {
	        chan = strtok(NULL, " ");
			if (!is_services_root(source)) {
				notice(s_MassServ, source, "Permission denied.");
			} else if (!chan) {
					notice(s_MassServ, source, "Syntax: ALLBOTPART <channel>");
			} else {
					allbotpart(chan);
			}
	} else if (stricmp(cmd, "ALLJOIN") == 0) {
	        chan = strtok(NULL, " ");
			if (!is_services_coder(source)) {
				notice(s_MassServ, source, "Permission denied.");
			}
	        if (!chan) {
				notice(s_MassServ, source, "Syntax: ALLJOIN <channel>");   
			} else {
				alljoin(chan);
			}
	} else if (stricmp(cmd, "ALLOPERJOIN") == 0) {
	        chan = strtok(NULL, " ");
			if (!is_services_coder(source)) {
				notice(s_MassServ, source, "Permission denied.");
			}
	        if (!chan) {
				notice(s_MassServ, source, "Syntax: ALLOPERJOIN <channel>");   
		} else {
				alloperjoin(chan);
		}
	} else if (stricmp(cmd, "HELP") == 0) {
			notice(s_MassServ, source,"Mass Services still under construction.");
			notice(s_MassServ, source,"- SERVJOIN      Make all Services bots Join a channel");
			notice(s_MassServ, source,"- SERVPART      Make all Services bots Part a channel");
			notice(s_MassServ, source,"- ALLBOTJOIN    Make all bots Join a channel");
			notice(s_MassServ, source,"- ALLBOTPART    Make all bots Part a channel");
			notice(s_MassServ, source,"- ALLJOIN       Make all users join a channel");
			notice(s_MassServ, source,"- ALLOPERJOIN   Make all users join a channel");
	} else
			notice(s_MassServ, source,"Unknown command.");
	}
}

#endif /* Non Super */
