/*
 * Decompiled with CFR 0.152.
 */
package com.crackj2ee.mail;

import com.crackj2ee.mail.Mail;
import com.crackj2ee.mail.MailException;
import com.crackj2ee.mail.MailListener;
import com.crackj2ee.mail.MxConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;

public class MailEngine {
    private static final String END_FLAG = "\r\n";
    private MxConfig config = null;

    public void setMxConfig(MxConfig config) {
        this.config = config;
    }

    public void send(final Mail mail, final MailListener listener) {
        if (this.config == null) {
            throw new MailException("MxConfig is not set. Invoke setMxConfig() first.");
        }
        if (listener == null) {
            this._send(mail, null);
        } else {
            Thread t = new Thread(){

                public void run() {
                    MailEngine.this._send(mail, listener);
                }
            };
            t.start();
        }
    }

    private void _onStateChanged(Mail mail, MailListener listener, int state) {
        if (listener != null) {
            listener.onStateChanged(mail, state);
        }
    }

    private void _onException(Mail mail, MailListener listener, Exception e) {
        MailException me;
        MailException mailException = me = e instanceof MailException ? (MailException)e : new MailException(e);
        if (listener == null) {
            throw me;
        }
        listener.onError(mail, me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void _send(Mail mail, MailListener listener) {
        block32: {
            Exception e322;
            OutputStream out;
            InputStream in;
            Socket socket;
            block28: {
                int len;
                this._onStateChanged(mail, listener, 1);
                String mx = null;
                InetAddress inetAddr = null;
                try {
                    mx = this.config.lookUpMxServer(mail.getToDomain());
                    inetAddr = InetAddress.getByName(mx);
                }
                catch (Exception e2) {
                    this._onException(mail, listener, e2);
                    return;
                }
                this._onStateChanged(mail, listener, 2);
                socket = null;
                in = null;
                out = null;
                socket = new Socket(inetAddr, 25);
                in = socket.getInputStream();
                out = socket.getOutputStream();
                this.response(in, 220, 0, 0);
                this.send("HELO " + mail.getFromDomain() + END_FLAG, out);
                this.response(in, 250, 0, 0);
                this.send("MAIL FROM:<" + mail.getFrom() + ">" + END_FLAG, out);
                this.response(in, 250, 0, 0);
                this.send("RCPT TO:<" + mail.getTo() + ">" + END_FLAG, out);
                this.response(in, 250, 251, 0);
                this.send("DATA\r\n", out);
                this.response(in, 354, 0, 0);
                this.send("Date: " + new Date().toString() + END_FLAG, out);
                this.send("From: " + mail.getFrom() + END_FLAG, out);
                this.send("To: " + mail.getTo() + END_FLAG, out);
                this.send("Subject: " + mail.getSubject() + END_FLAG, out);
                this.send("Content-Type: " + mail.getContentType() + END_FLAG, out);
                this.send("Content-Transfer-Encoding: base64\r\n", out);
                this.send("\r\n\r\n", out);
                String base64 = mail.getBase64Body();
                for (int start = 0; start < base64.length(); start += len) {
                    len = base64.length() - start;
                    if (len > 1000) {
                        len = 1000;
                    }
                    String line = base64.substring(start, start + len);
                    this.send(line + END_FLAG, out);
                }
                this.send("\r\n.\r\n", out);
                this.response(in, 250, 0, 0);
                this.send("QUIT\r\n", out);
                this.response(in, 221, 0, 0);
                this._onStateChanged(mail, listener, 3);
                Object var13_14 = null;
                if (in == null) break block28;
                try {
                    in.close();
                }
                catch (Exception e322) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e322) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e322) {}
            }
            break block32;
            {
                catch (Exception e4) {
                    Exception e322;
                    this._onException(mail, listener, e4);
                    Object var13_15 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e322) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e322) {
                            // empty catch block
                        }
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception e322) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e322;
                Object var13_16 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private int response(InputStream in, int expect1, int expect2, int expect3) throws IOException {
        int code = 0;
        byte[] buffer = new byte[1024];
        int n = in.read(buffer);
        if (n == -1) {
            throw new MailException("Empty response.");
        }
        String s = new String(buffer, 0, n);
        System.out.println("[RECEIVE]" + s);
        if (s.length() >= 3) {
            try {
                code = Integer.parseInt(s.substring(0, 3));
            }
            catch (Exception e) {
                throw new MailException("Unrecognized response: " + s);
            }
            if (code > 0 && (code == expect1 || code == expect2 || code == expect3)) {
                return code;
            }
            throw new MailException(s);
        }
        throw new MailException("Unrecognized response: " + s);
    }

    private void send(String s, OutputStream out) throws IOException {
        System.out.println("[SEND] " + s);
        byte[] buffer = s.getBytes();
        out.write(buffer);
        out.flush();
    }
}

