/*
 * Decompiled with CFR 0.152.
 */
package com.crackj2ee.mail;

import com.crackj2ee.mail.MailException;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class MxConfig {
    private static final String[] ATTR_MX = new String[]{"MX"};
    private DirContext ctx = null;
    private LRUCache cache = new LRUCache();

    public MxConfig() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (NamingException ne) {
            throw new MailException(ne);
        }
    }

    public void setCacheSize(int max) {
        this.cache.setMax(max < 1 ? 1 : max);
    }

    public void setCacheTime(int sec) {
        this.cache.setCacheTime(sec < 1 ? 1 : sec);
    }

    String lookUpMxServer(String domain) {
        block6: {
            String ret = null;
            String expired = null;
            try {
                ret = this.getFromCache(domain);
            }
            catch (NeedRefreshException nre) {
                expired = (String)nre.getExpiredValue();
            }
            if (ret != null) {
                return ret;
            }
            Attributes attrs = null;
            try {
                attrs = this.ctx.getAttributes(domain, ATTR_MX);
                NamingEnumeration<? extends Attribute> en = attrs.getAll();
                if (en.hasMore()) {
                    String addr = en.next().toString();
                    int n = addr.lastIndexOf(32);
                    ret = addr.substring(n + 1, addr.length() - 1);
                    this.putIntoCache(domain, ret);
                    return ret;
                }
            }
            catch (Exception e) {
                if (expired == null) break block6;
                return expired;
            }
        }
        throw new MailException("Could not found MX server of domain: " + domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFromCache(String domain) {
        Object obj = null;
        MxConfig mxConfig = this;
        synchronized (mxConfig) {
            obj = this.cache.get(domain);
        }
        return obj == null ? null : obj.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIntoCache(String domain, String mx) {
        MxConfig mxConfig = this;
        synchronized (mxConfig) {
            this.cache.put(domain, mx);
        }
    }

    class LRUCache
    extends LinkedHashMap {
        private int max = 20;
        private long life = 600000L;

        LRUCache() {
        }

        public void setMax(int max) {
            this.max = max;
        }

        public void setCacheTime(int sec) {
            this.life = sec * 1000;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.max;
        }

        public Object get(Object key) {
            Object obj = super.get(key);
            if (obj == null) {
                return null;
            }
            WrapValue wv = (WrapValue)obj;
            if (wv.isExpired()) {
                this.remove(key);
                throw new NeedRefreshException(wv.getValue());
            }
            return wv.getValue();
        }

        public Object put(Object key, Object value) {
            return super.put(key, new WrapValue(value));
        }

        class WrapValue {
            Object value;
            long start;

            WrapValue(Object value) {
                this.value = value;
                this.start = System.currentTimeMillis();
            }

            Object getValue() {
                return this.value;
            }

            boolean isExpired() {
                return System.currentTimeMillis() - this.start > LRUCache.this.life;
            }
        }
    }

    class NeedRefreshException
    extends RuntimeException {
        private Object expiredValue;

        NeedRefreshException(Object expiredValue) {
            this.expiredValue = expiredValue;
        }

        public Object getExpiredValue() {
            return this.expiredValue;
        }
    }
}

