/*
 * Decompiled with CFR 0.152.
 */
package ecks.Threads;

import ecks.Logging;
import ecks.main;
import ecks.protocols.Generic;
import ecks.protocols.Protocol;
import ecks.util;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.ClosedByInterruptException;

public class ConnThread
implements Runnable {
    BufferedReader stream;
    Protocol handoff;

    public ConnThread(BufferedReader in, Protocol p) {
        this.stream = in;
        this.handoff = p;
    }

    public void run() {
        do {
            try {
                this.handoff.Incoming(this.stream.readLine().trim());
            }
            catch (ClosedByInterruptException e) {
                e.printStackTrace();
                Logging.warn("CONNTHREAD", "Thread is being interrupted.");
                break;
            }
            catch (SocketException e) {
                Generic.curProtocol.setState(Protocol.States.S_DISCONNECTED);
                Logging.error("CONNTHREAD", "Connection terminated unexpectedly, quitting");
                break;
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
                Logging.error("CONNTHREAD", "Null pointer exception!");
                Generic.curProtocol.setState(Protocol.States.S_DISCONNECTING);
                Logging.error("CONNTHREAD", "Upstream is null; Server closed connection.");
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                Logging.error("CONNTHREAD", "Thread got exception!");
                try {
                    if (!this.stream.ready()) {
                        Generic.curProtocol.setState(Protocol.States.S_DISCONNECTING);
                        Logging.error("CONNTHREAD", "Upstream is null; Server closed connection.");
                    }
                }
                catch (IOException e1) {}
                break;
                Logging.info("CONNTHREAD", e.getMessage());
            }
        } while (!Thread.interrupted());
        Logging.warn("CONNTHREAD", "Thread has broken free of loop.");
        main.goGracefullyIntoTheNight();
        util.getThreads().remove(Thread.currentThread());
    }
}

