/*
 * Decompiled with CFR 0.152.
 */
package ecks.services;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.Utility.Client;
import ecks.protocols.Generic;
import ecks.services.SrvHelp_channel;
import ecks.services.bService;
import ecks.util;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrvHelp
extends bService {
    public String name = "SrvHelp";
    public Map<String, SrvHelp_channel> Channels = new HashMap<String, SrvHelp_channel>();
    public Map<Client, SrvHelp_channel> qMap = new HashMap<Client, SrvHelp_channel>();

    @Override
    public void introduce() {
        Generic.srvIntroduce(this);
        Hooks.regHook(this, Hooks.Events.E_PRIVMSG);
        Hooks.regHook(this, Hooks.Events.E_JOINCHAN);
        Hooks.regHook(this, Hooks.Events.E_PARTCHAN);
        if (!Configuration.Config.get("debugchan").equals("OFF")) {
            Generic.curProtocol.srvJoin(this, Configuration.Config.get("debugchan"), "+stn");
            Generic.curProtocol.outSETMODE(this, Configuration.Config.get("debugchan"), "+o", this.name);
        }
        if (Configuration.Config.get("joinchannels").equals("YES")) {
            for (String chan : this.Channels.keySet()) {
                Generic.curProtocol.srvJoin(this, chan, "+stn");
                Generic.curProtocol.outSETMODE(this, chan, "+o", this.name);
            }
        }
    }

    @Override
    public String getname() {
        return this.name;
    }

    @Override
    public void setname(String nname) {
        this.name = nname;
    }

    public Map<String, SrvHelp_channel> getChannels() {
        return this.Channels;
    }

    @Override
    public String getSRVDB() {
        String tOut = "";
        tOut = tOut + "<service class=\"" + this.getClass().getName() + "\" name=\"" + this.name + "\">\r\n";
        for (Map.Entry<String, SrvHelp_channel> usar : this.Channels.entrySet()) {
            tOut = tOut + "\t" + "<channel>\r\n";
            tOut = tOut + "\t\t" + "<name value=\"" + util.encodeUTF(usar.getValue().channel) + "\"/>\r\n";
            tOut = tOut + "\t\t" + "<metadata>\r\n";
            for (Map.Entry<String, String> md : usar.getValue().getAllMeta().entrySet()) {
                tOut = tOut + "\t\t\t" + "<" + util.encodeUTF(md.getKey()) + " value=\"" + util.encodeUTF(md.getValue()) + "\"/>\r\n";
            }
            tOut = tOut + "\t\t" + "</metadata>\r\n";
            tOut = tOut + "\t" + "</channel>\r\n";
        }
        tOut = tOut + "</service>\r\n";
        return tOut;
    }

    @Override
    public void loadSRVDB(NodeList XMLin) {
        for (int i = 0; i < XMLin.getLength(); ++i) {
            HashMap<String, String> mTemp = new HashMap<String, String>();
            if (XMLin.item(i).getNodeType() != 1) continue;
            NodeList t = ((Element)XMLin.item(i)).getElementsByTagName("name");
            String nTemp = util.decodeUTF(t.item(0).getAttributes().getNamedItem("value").getNodeValue());
            t = ((Element)XMLin.item(i)).getElementsByTagName("metadata").item(0).getChildNodes();
            for (int j = 0; j < t.getLength(); ++j) {
                if (t.item(j).getNodeType() != 1) continue;
                mTemp.put(util.decodeUTF(t.item(j).getNodeName()), util.decodeUTF(t.item(j).getAttributes().getNamedItem("value").getNodeValue()));
            }
            this.Channels.put(nTemp.toLowerCase().trim(), new SrvHelp_channel(nTemp, mTemp));
        }
        Logging.info("SRVHELP", "Loaded " + this.Channels.size() + " help channels from database.");
    }

    @Override
    public int getcount() {
        return this.Channels.size();
    }

    @Override
    public void hookDispatch(Hooks.Events what, String source, String target, String args) {
        switch (what) {
            case E_PRIVMSG: {
                if (this.qMap.containsKey(Generic.Users.get(source.toLowerCase()))) break;
            }
            default: {
                super.hookDispatch(this, what, source, target, args);
            }
        }
    }
}

