/*
 * Decompiled with CFR 0.152.
 */
package ecks.services;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.protocols.Generic;
import ecks.services.Service;
import ecks.services.SrvAuth;
import ecks.services.modules.CommandDesc;
import ecks.services.modules.CommandModule;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class bService
implements Service {
    public Map<String, CommandModule> Commands = new HashMap<String, CommandModule>();

    @Override
    public void introduce() {
        Generic.srvIntroduce(this);
    }

    @Override
    public abstract void setname(String var1);

    @Override
    public void handle(String user, String replyto, String command) {
        boolean inchan = !user.equals(replyto);
        String cmd = (command = command.trim()).split(" ")[0];
        if (cmd.startsWith("FQDN")) {
            cmd = cmd.substring(4);
            command = command.substring(4);
            Logging.verbose("SERVICE", "Command \"" + cmd + "\" is fully qualified.");
        }
        try {
            if (!this.Commands.containsKey(cmd.toLowerCase())) {
                Generic.curProtocol.outPRVMSG(this, replyto, "\u0002Error:\u0002 Unknown Command!");
                return;
            }
            CommandDesc c = this.Commands.get(cmd.toLowerCase()).getDesc();
            if (!(inchan && c.InChannel || !inchan)) {
                Generic.curProtocol.outPRVMSG(this, replyto, "\u0002Error:\u0002 That command is unavailable in-channel!");
                return;
            }
            if (command.split(" ").length > c.ArgCount + 1) {
                Generic.curProtocol.outPRVMSG(this, replyto, "\u0002Error:\u0002 Too many arguments!");
                return;
            }
            if (Configuration.getSvc().containsKey(Configuration.authservice)) {
                CommandDesc.access_levels req = this.Commands.get((Object)cmd.toLowerCase()).getDesc().Required_Access;
                String handle = Generic.Users.get((Object)user.toLowerCase()).authhandle;
                CommandDesc.access_levels cur = ((SrvAuth)Configuration.getSvc().get(Configuration.authservice)).checkAccess(handle);
                if (handle == null && req.ordinal() != 0) {
                    Generic.curProtocol.outPRVMSG(this, replyto, "\u0002Error:\u0002 You're not authed!");
                    return;
                }
                if (cur.ordinal() < req.ordinal()) {
                    Generic.curProtocol.outPRVMSG(this, replyto, "\u0002Error:\u0002 Not enough access!");
                    return;
                }
                Logging.verbose("SERVICE", "Handling command: " + cmd + ", for user: " + user + ".");
                this.Commands.get(cmd.toLowerCase()).handle_command(this, user.toLowerCase(), replyto, command.substring(cmd.length()).trim());
            } else {
                this.Commands.get(cmd.toLowerCase()).handle_command(this, user, replyto, command.substring(cmd.length()).trim());
            }
        }
        catch (NullPointerException NPE) {
            Logging.error("SERVICE", "Caught NPE in command.");
            Logging.info("SERVICE", "NPE handling command:" + user + " \\ " + replyto + " \\ " + command);
            NPE.printStackTrace();
        }
    }

    @Override
    public void die(String message) {
        Generic.srvDie(message);
    }

    @Override
    public void addCommand(String cmdName, CommandModule newCmd) {
        this.Commands.put(cmdName, newCmd);
    }

    @Override
    public Map<String, CommandModule> getCommands() {
        return this.Commands;
    }

    @Override
    public abstract String getSRVDB();

    @Override
    public abstract void loadSRVDB(NodeList var1);

    public void hookDispatch(Service which, Hooks.Events what, String source, String target, String args) {
        switch (what) {
            case E_PRIVMSG: {
                String target2 = "";
                String arguments = "";
                if (target.startsWith("#")) {
                    if (args.split(" ")[0].endsWith(":")) {
                        target2 = args.split(" ")[0];
                        target2 = target2.substring(0, target2.length() - 1);
                        arguments = args.substring(target2.length() + 1).trim();
                    }
                } else {
                    target2 = target;
                    arguments = args;
                }
                String[] temp = target2.split("@");
                target2 = temp[0];
                if (temp.length > 1) {
                    arguments = "FQDN" + arguments;
                }
                if (!target2.toLowerCase().equals(which.getname().toLowerCase())) break;
                which.handle(source, target.startsWith("#") ? target : source, arguments);
                break;
            }
        }
    }
}

