/*
 * Decompiled with CFR 0.152.
 */
package ecks.services.modules.SrvOper;

import ecks.Logging;
import ecks.Utility.Channel;
import ecks.Utility.Client;
import ecks.Utility.UserModes;
import ecks.protocols.Generic;
import ecks.services.Service;
import ecks.services.SrvChannel;
import ecks.services.modules.CommandDesc;
import ecks.services.modules.bCommand;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.PatternSyntaxException;

public class Grep
extends bCommand {
    public final CommandDesc Desc = new CommandDesc("grep", 50, true, CommandDesc.access_levels.A_OPER, "Sort (java regex) and act upon data.", "[users|channels] [(uid|ident|mask)(name|topic)] [print|(kill|gline)(close)] regexp");

    public CommandDesc getDesc() {
        return this.Desc;
    }

    public void handle_command(Service who, String user, String replyto, String arguments) {
        block49: {
            String[] args = arguments.split(" ");
            if (args.length > 3) {
                String what = args[0];
                String what2 = args[1];
                String cmd = args[2];
                String towhat = args[3];
                Boolean confirm = false;
                String reason = "";
                if (args.length == 5) {
                    confirm = args[4].equals("CONFIRM");
                }
                if (args.length > 5) {
                    for (int i = 5; i < args.length; ++i) {
                        reason = reason + args[i] + " ";
                    }
                } else {
                    reason = "Matched Grep.";
                }
                try {
                    if (what.equals("users")) {
                        ArrayList<Client> matches = new ArrayList<Client>();
                        for (Map.Entry<String, Client> Client2 : Generic.Users.entrySet()) {
                            if (what2.equals("uid")) {
                                if (!Client2.getValue().uid.matches(towhat.replace("*", "\\S+"))) continue;
                                matches.add(Client2.getValue());
                                continue;
                            }
                            if (what2.equals("mask")) {
                                if (!Client2.getValue().host.matches(towhat.replace("*", "\\S+"))) continue;
                                matches.add(Client2.getValue());
                                continue;
                            }
                            if (what2.equals("ident")) {
                                if (!Client2.getValue().ident.matches(towhat.replace("*", "\\S+"))) continue;
                                matches.add(Client2.getValue());
                                continue;
                            }
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Invalid field for user. Usage: grep users [uid|mask|ident] [print|kill|gline] regexp");
                            return;
                        }
                        if (cmd.equals("count")) {
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Grep Results:\u0002 " + matches.size() + " matches.");
                        } else if (cmd.equals("print")) {
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Grep Results:\u0002 " + matches.size() + " matches.");
                            for (int i = 0; i < matches.size(); ++i) {
                                Generic.curProtocol.outPRVMSG(who, replyto, "   " + matches.get(i).toString());
                            }
                        } else if (cmd.equals("kill")) {
                            if (matches.size() > Generic.Users.size() / 10) {
                                if (confirm.booleanValue()) {
                                    for (int i = 0; i < matches.size(); ++i) {
                                        Generic.curProtocol.outKILL(who, ((Client)matches.get((int)i)).uid, reason);
                                    }
                                    Logging.warn("SRVOPER", user + " killed more than 10% of the network.!");
                                } else {
                                    Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Affects more than 10% of network (" + matches.size() + "/" + Generic.Users.size() + ", " + (float)matches.size() / (float)Generic.Users.size() * 100.0f + "%). Confirm by adding CONFIRM to end of command.");
                                }
                            } else {
                                for (int i = 0; i < matches.size(); ++i) {
                                    Generic.curProtocol.outKILL(who, ((Client)matches.get((int)i)).uid, reason);
                                }
                            }
                        } else if (cmd.equals("gline")) {
                            if (matches.size() > Generic.Users.size() / 10) {
                                if (confirm.booleanValue()) {
                                    for (int i = 0; i < matches.size(); ++i) {
                                        Generic.curProtocol.outGLINE(who, (Client)matches.get(i), reason);
                                    }
                                    Logging.warn("SRVOPER", user + " managed to gline more than 10% of the network!");
                                } else {
                                    Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Affects more than 10% of network (" + matches.size() + "/" + Generic.Users.size() + ", " + matches.size() / Generic.Users.size() * 100 + "%). Confirm by adding CONFIRM to end of command.");
                                }
                            } else {
                                for (int i = 0; i < matches.size(); ++i) {
                                    Generic.curProtocol.outGLINE(who, (Client)matches.get(i), reason);
                                }
                            }
                        } else {
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Invalid action for user. Usage: grep users [uid|mask|ident] [print|count|kill|gline] regexp");
                        }
                        break block49;
                    }
                    if (what.equals("channels")) {
                        ArrayList<Channel> matches = new ArrayList<Channel>();
                        for (Map.Entry<String, Channel> Client3 : Generic.Channels.entrySet()) {
                            if (what2.equals("name")) {
                                if (!Client3.getValue().name.matches(towhat.replace("*", "\\S+"))) continue;
                                matches.add(Client3.getValue());
                                continue;
                            }
                            if (what2.equals("topic")) {
                                Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Unimplimented");
                                return;
                            }
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Invalid field for channel. Usage: grep channels [name|topic] [print|count|close] regexp");
                            return;
                        }
                        if (cmd.equals("count")) {
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Grep Results:\u0002 " + matches.size() + " matches.");
                        } else if (cmd.equals("print")) {
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Grep Results:\u0002 " + matches.size() + " matches.");
                            for (int i = 0; i < matches.size(); ++i) {
                                Generic.curProtocol.outPRVMSG(who, replyto, "   " + matches.get(i).toString());
                            }
                        } else if (cmd.equals("close")) {
                            for (int i = 0; i < matches.size(); ++i) {
                                ArrayList<Client> alc = new ArrayList<Client>();
                                for (Map.Entry<Client, UserModes> Cl : ((Channel)matches.get((int)i)).clientmodes.entrySet()) {
                                    alc.add(Cl.getKey());
                                }
                                for (Client c : alc) {
                                    if (c.modes.contains("o")) continue;
                                    if (c.authhandle != null) {
                                        Generic.curProtocol.outKICK(who, c.uid, ((Channel)matches.get((int)i)).name, "Channel has been closed by network administration.");
                                        continue;
                                    }
                                    Generic.curProtocol.outKILL(who, c.uid, "Channel " + ((Channel)matches.get((int)i)).name + " has been closed by network staff.");
                                }
                                ((SrvChannel)who).getChannels().get(((Channel)matches.get((int)i)).name).setMeta("_isbad", "Channel was closed via batch grep.");
                                Logging.warn("SRVOPER", user + " closed channel " + ((Channel)matches.get((int)i)).name + " !");
                            }
                        } else {
                            Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Invalid action for channels. Usage: grep channels [name|topic] [print|count|close] regexp");
                        }
                        break block49;
                    }
                    Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Invalid command. Usage: grep [users|channels] [(uid|ident|mask)(name|topic)] [print|count|(kill|gline)(close)] regexp");
                }
                catch (PatternSyntaxException pse) {
                    Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Bad Regex.");
                }
            } else {
                Generic.curProtocol.outPRVMSG(who, replyto, "\u0002Error:\u0002 Invalid arguments. Usage: grep [users|channels] [(uid|ident|mask)(name|topic)] [print|count|(kill|gline)(close)] regexp");
            }
        }
    }
}

