/*
 * Decompiled with CFR 0.152.
 */
package ecks.Hooks;

import ecks.Logging;
import ecks.services.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Hooks {
    public static Map<Service, List<Events>> regHooks;

    public static void initialize() {
        regHooks = new HashMap<Service, List<Events>>();
    }

    public static void regHook(Service who, Events what) {
        if (regHooks.containsKey(who)) {
            List<Events> e = regHooks.get(who);
            e.add(what);
            regHooks.put(who, e);
        } else {
            ArrayList<Events> e = new ArrayList<Events>();
            e.add(what);
            regHooks.put(who, e);
        }
    }

    public static void unregHook(Service who, Events what) {
        if (regHooks.containsKey(who)) {
            List<Events> e = regHooks.get(who);
            if (e.contains((Object)what)) {
                e.remove((Object)what);
                regHooks.remove(who);
                regHooks.put(who, e);
            } else {
                Logging.warn("HOOKS", "Tried to remove a hook for that doesn't exist!");
            }
        } else {
            Logging.warn("HOOKS", "Tried to remove a hook for a service that doesn't exist!");
        }
    }

    public static void hook(Events what, String source, String target, String args) {
        for (Map.Entry<Service, List<Events>> e : regHooks.entrySet()) {
            if (!e.getValue().contains((Object)what)) continue;
            e.getKey().hookDispatch(what, source, target, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Events {
        E_JOINCHAN,
        E_PARTCHAN,
        E_PRIVMSG,
        E_KICK,
        E_MODE,
        E_UMODE,
        E_TOPIC,
        E_SIGNON;

    }
}

