/*
 * Decompiled with CFR 0.152.
 */
package ecks;

import ecks.Configuration;
import ecks.protocols.Generic;
import ecks.protocols.Protocol;
import ecks.util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class Logging {
    public static loglevels myLogLevel;
    static boolean inchan;
    static Writer out;

    public Logging() {
        myLogLevel = loglevels.D_NONE;
    }

    public static void setup() {
        myLogLevel = loglevels.valueOf(Configuration.Config.get("debuglevel"));
        boolean stdio = Configuration.Config.get("debugdevice").equals("stdio");
        try {
            out = stdio ? new OutputStreamWriter(System.out) : new BufferedWriter(new FileWriter(Configuration.Config.get("debugdevice")));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Failed to create logging device. Giving up.");
            System.exit(-1);
        }
        inchan = !Configuration.Config.get("debugchan").equals("OFF");
    }

    public void finalize() throws Throwable {
        out.close();
        super.finalize();
    }

    static void log(String what, loglevels ll, String ai) throws IOException {
        if (myLogLevel.equals((Object)loglevels.D_NONE)) {
            return;
        }
        if (myLogLevel.equals((Object)loglevels.D_VERBOSE) && what.equals("RAW")) {
            out.write("         \t          \t" + util.pad(what, 10) + '\t' + ai + "\r\n");
            out.flush();
            return;
        }
        if (inchan && Generic.curProtocol != null && Generic.curProtocol.getState().equals((Object)Protocol.States.S_ONLINE)) {
            Generic.curProtocol.outPRVMSG(Configuration.getSvc().get(Configuration.logservice), Configuration.Config.get("debugchan"), String.valueOf(System.currentTimeMillis() / 1000L) + '\t' + util.pad(ll.toString(), 10) + '\t' + util.pad(what, 10) + '\t' + ai);
        }
        out.write(String.valueOf(System.currentTimeMillis() / 1000L) + '\t' + util.pad(ll.toString(), 10) + '\t' + util.pad(what, 10) + '\t' + ai + "\r\n");
        out.flush();
    }

    public static void info(String what, String more) {
        if (myLogLevel.ordinal() < loglevels.D_INFO.ordinal()) {
            return;
        }
        try {
            Logging.log(what, loglevels.D_INFO, more);
        }
        catch (IOException e) {
            System.err.println("Failed to log. Giving up.");
            System.exit(-1);
        }
    }

    public static void warn(String what, String more) {
        if (myLogLevel.ordinal() < loglevels.D_WARN.ordinal()) {
            return;
        }
        try {
            Logging.log(what, loglevels.D_WARN, more);
        }
        catch (IOException e) {
            System.err.println("Failed to log. Giving up.");
            System.exit(-1);
        }
    }

    public static void error(String what, String more) {
        if (myLogLevel.ordinal() < loglevels.D_ERRORS.ordinal()) {
            return;
        }
        try {
            Logging.log(what, loglevels.D_ERRORS, more);
        }
        catch (IOException e) {
            System.err.println("Failed to log. Giving up.");
            System.exit(-1);
        }
    }

    public static void raw(String what, Boolean in) {
        if (myLogLevel.ordinal() < loglevels.D_VERBOSE.ordinal()) {
            return;
        }
        String direction = "-> ";
        if (in.booleanValue()) {
            direction = "<- ";
        }
        try {
            Logging.log("RAW", loglevels.D_VERBOSE, direction + what);
        }
        catch (IOException e) {
            System.err.println("Failed to log. Giving up.");
            System.exit(-1);
        }
    }

    public static void verbose(String what, String more) {
        if (myLogLevel.ordinal() < loglevels.D_VERBOSE.ordinal()) {
            return;
        }
        try {
            Logging.log(what, loglevels.D_VERBOSE, more);
        }
        catch (IOException e) {
            System.err.println("Failed to log. Giving up.");
            System.exit(-1);
        }
    }

    public static void summary(String what, String more) {
        if (myLogLevel.ordinal() < loglevels.D_SUMMARY.ordinal()) {
            return;
        }
        try {
            Logging.log(what, loglevels.D_SUMMARY, more);
        }
        catch (IOException e) {
            System.err.println("Failed to log. Giving up.");
            System.exit(-1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum loglevels {
        D_NONE,
        D_ERRORS,
        D_WARN,
        D_SUMMARY,
        D_INFO,
        D_VERBOSE;

    }
}

