/*
 * Decompiled with CFR 0.152.
 */
package ecks;

import ecks.Configuration;
import ecks.Logging;
import ecks.main;
import ecks.services.Service;
import ecks.util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Storage {
    public void loadDB() {
        Document dom = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse("srvdb.xml");
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        assert (dom != null);
        Element docEle = dom.getDocumentElement();
        NodeList zl = docEle.getElementsByTagName("service");
        if (zl != null && zl.getLength() > 0) {
            for (int i = 0; i < zl.getLength(); ++i) {
                Element el = (Element)zl.item(i);
                if (!Configuration.Services.containsKey(el.getAttribute("name").toLowerCase())) continue;
                Logging.verbose("DATABASE", el.getAttribute("name") + " Loading database...");
                Configuration.getSvc().get(el.getAttribute("name").toLowerCase()).loadSRVDB(el.getChildNodes());
                Logging.verbose("DATABASE", el.getAttribute("name") + " Loading complete...");
            }
        } else {
            Logging.error("DATABASE", "No services defined in configuration file! Exiting");
            main.goGracefullyIntoTheNight();
        }
    }

    public static synchronized void flushDB() {
        String out = "";
        for (Map.Entry<String, Service> Serve : Configuration.Services.entrySet()) {
            out = out + Serve.getValue().getSRVDB();
        }
        out = out.trim();
        Logging.info("DATABASE", "Writing " + out.getBytes().length + "bytes of services data to disk...");
        try {
            BufferedWriter o = new BufferedWriter(new FileWriter("srvdb.xml"));
            o.write("<db version=\"" + util.getVersion() + "\" stamp=\"" + util.getTS() + "\">\r\n" + out + "\r\n</db>");
            o.close();
            Logging.verbose("DATABASE", "Write completed.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

