/*
 * Decompiled with CFR 0.152.
 */
package ecks.protocols;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.Utility.ChanModes;
import ecks.Utility.Channel;
import ecks.Utility.Client;
import ecks.Utility.UserModes;
import ecks.main;
import ecks.protocols.Protocol;
import ecks.services.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Generic {
    public static Map<String, Client> Users = new HashMap<String, Client>();
    public static Map<String, Channel> Channels = new HashMap<String, Channel>();
    public static Protocol curProtocol;

    public static void SetProtocol(Protocol p) {
        curProtocol = p;
    }

    public static void BringServicesOnline() {
        try {
            for (Map.Entry<String, Service> Serve : Configuration.getSvc().entrySet()) {
                Serve.getValue().introduce();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Logging.warn("PROTOCOL", "Got NPE whilst bringing services agents online!");
        }
    }

    public static void nickRename(String oldnick, String newnick, long ts) {
        String oldid = oldnick.toLowerCase();
        String newid = newnick.toLowerCase();
        Client client = Users.get(oldid);
        client.uid = newnick;
        client.signon = ts;
        if (oldid.equals(newid)) {
            return;
        }
        Users.put(newid, client);
        Users.remove(oldid);
    }

    public static void modeUser(String target, String modes) {
        Generic.Users.get((Object)target.toLowerCase()).modes.applyChanges(modes);
        Hooks.hook(Hooks.Events.E_UMODE, null, target, modes);
    }

    public static void vHost(String target, String newhost) {
        Generic.Users.get((Object)target.toLowerCase()).althost = newhost;
    }

    public static void modeChan(String target, String modes) {
        Generic.Channels.get((Object)target.toLowerCase()).modes.applyChanges(modes);
        Hooks.hook(Hooks.Events.E_MODE, null, target, modes);
    }

    public static void nickSignOn(String[] tokens) {
        Users.put(tokens[1].toLowerCase(), new Client(tokens[1], Integer.parseInt(tokens[2]), Long.parseLong(tokens[3]), tokens[4], tokens[5], tokens[6], tokens[7], tokens[8], Long.parseLong(tokens[9]), Long.parseLong(tokens[10]), tokens[11], tokens[12]));
        Hooks.hook(Hooks.Events.E_SIGNON, tokens[1], null, tokens[5] + " " + tokens[6] + " " + tokens[11]);
        Logging.verbose("PROTOCOL", "User " + tokens[1] + " is now being tracked.");
        if (Long.parseLong(tokens[9]) > 0L) {
            Logging.info("PROTOCOL", "User " + tokens[1] + " was previously authed.");
            if (Configuration.getSvc().containsKey(Configuration.authservice)) {
                Logging.info("PROTOCOL", "Attempting re-entry...");
                Configuration.getSvc().get(Configuration.authservice).handle(tokens[1].toLowerCase(), "service", "reauth " + tokens[9] + " " + tokens[3]);
            }
        }
    }

    public static synchronized void nickSignOff(String who) {
        if (Users.containsKey(who.toLowerCase())) {
            ArrayList<String> blah = Users.get(who.toLowerCase()).getChans();
            for (String chan : blah) {
                Generic.chanPart(chan, who);
            }
            Users.remove(who.toLowerCase());
            Logging.verbose("PROTOCOL", "User " + who + " is no longer being tracked.");
        } else {
            Logging.warn("PROTOCOL", "Tried to sign off a user that didn't exist!");
        }
    }

    public static void nickGotKicked(String user, String channel) {
        Generic.chanPart(channel, user);
        Hooks.hook(Hooks.Events.E_KICK, channel, user, null);
        if (Configuration.getSvc().containsKey(user.toLowerCase())) {
            Logging.info("PROTOCOL", "Service was kicked! Attempting rejoin.");
            curProtocol.srvJoin(Configuration.getSvc().get(user.toLowerCase()), channel, "+nt");
        }
    }

    public static void nickGotKilled(String user) {
        if (!Users.containsKey(user.toLowerCase())) {
            return;
        }
        if (Configuration.getSvc().containsKey(user.toLowerCase())) {
            Logging.error("PROTOCOL", "Service was killed! Attempting 'reconnect'.");
            Configuration.getSvc().get(user.toLowerCase()).introduce();
            return;
        }
        Generic.nickSignOff(user);
    }

    public static void chanBurst(int ts, String channel, String modes, String[] users) {
        ChanModes m = new ChanModes();
        HashMap<Client, UserModes> cm = new HashMap<Client, UserModes>();
        m.applyChanges(modes);
        Map<Character, Character> xlate = curProtocol.getPrefixMap();
        if (users.length != 0) {
            for (String user : users) {
                UserModes t = new UserModes();
                String tUser = user.toLowerCase();
                String tMode = null;
                for (Map.Entry<Character, Character> e : xlate.entrySet()) {
                    if (!user.startsWith(e.getKey().toString())) continue;
                    tUser = user.substring(1).toLowerCase();
                    tMode = "+" + xlate.get(user.substring(0, 1).toCharArray());
                }
                Client z = Users.get(tUser);
                if (tMode != null) {
                    t.applyChanges(tMode);
                }
                cm.put(z, t);
            }
        }
        if (Channels.containsKey(channel.toLowerCase())) {
            if (!curProtocol.getState().equals((Object)Protocol.States.S_BURSTING)) {
                Logging.error("PROTOCOL", "Attempted to add a channel " + channel + " that already exists. " + cm.size() + " user(s) joined.");
                Logging.info("PROTOCOL", "Chan is: " + Channels.get(channel.toLowerCase()).toString());
                Generic.Channels.get((Object)channel.toLowerCase()).clientmodes.putAll(cm);
            } else {
                Channels.put(channel.toLowerCase(), new Channel(ts, channel, m, cm));
                Logging.verbose("PROTOCOL", "Channel " + channel + " is now being tracked. (OVERRIDDEN)");
            }
        } else {
            Channels.put(channel.toLowerCase(), new Channel(ts, channel, m, cm));
            Logging.verbose("PROTOCOL", "Channel " + channel + " is now being tracked.");
        }
        try {
            for (Client c : cm.keySet()) {
                c.chans.add(channel.toLowerCase());
                Hooks.hook(Hooks.Events.E_JOINCHAN, channel, c.uid, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void chanJoin(int ts, String channel, String user) {
        if (Channels.containsKey(channel.toLowerCase())) {
            Generic.Channels.get((Object)channel.toLowerCase()).clientmodes.put(Users.get(user.toLowerCase()), new UserModes());
            Generic.Users.get((Object)user.toLowerCase()).chans.add(channel.toLowerCase());
            Hooks.hook(Hooks.Events.E_JOINCHAN, channel, user, "");
        } else {
            Generic.chanBurst(ts, channel, "+nt", new String[]{user});
        }
    }

    public static void chanTopic(int ts, String channel, String what) {
        if (Channels.containsKey(channel.toLowerCase())) {
            Generic.Channels.get((Object)channel.toLowerCase()).topic = what;
            Generic.Channels.get((Object)channel.toLowerCase()).tts = ts;
            Hooks.hook(Hooks.Events.E_TOPIC, channel, what, null);
        } else {
            Logging.error("PROTOCOL", "Attempted to set a topic on a channel that does not exist");
        }
    }

    public static void chanPart(String channel, String user) {
        if (!Channels.containsKey(channel.toLowerCase())) {
            Logging.warn("PROTOCOL", "Tried to part user " + user + "  from a channel " + channel + " that didn't exist");
            return;
        }
        if (!Users.containsKey(user.toLowerCase())) {
            Logging.warn("PROTOCOL", "Tried to part a user that didn't exist");
            return;
        }
        Client who = Users.get(user.toLowerCase());
        if (Generic.Channels.get((Object)channel.toLowerCase()).clientmodes.containsKey(who)) {
            who.chans.remove(channel.toLowerCase());
            Generic.Channels.get((Object)channel.toLowerCase()).clientmodes.remove(who);
            Hooks.hook(Hooks.Events.E_PARTCHAN, channel, user, null);
        } else {
            Logging.warn("PROTOCOL", "Tried to part user " + user + " from channel " + channel + " that they weren't on");
            Logging.info("PROTOCOL", "User is: " + who.toString());
            Logging.info("PROTOCOL", "Chan is: " + Channels.get(channel.toLowerCase()).toString());
        }
        if (Generic.Channels.get((Object)channel.toLowerCase()).clientmodes.size() == 0) {
            Channels.remove(channel.toLowerCase());
            Logging.verbose("PROTOCOL", "Channel " + channel + " is no longer being tracked.");
        }
    }

    public static void srvIntroduce(Service whatservice) {
        curProtocol.srvIntroduce(whatservice);
    }

    public static void srvJoin(Service whatservice, String where, String modes) {
        curProtocol.srvJoin(whatservice, where, modes);
    }

    public static void srvPart(Service whatservice, String where, String why) {
        curProtocol.srvPart(whatservice, where, why);
    }

    public static void srvDie() {
        Generic.srvDie("Quitting Gracefully.");
    }

    public static void srvDie(String message) {
        if (message.trim().equals("")) {
            Generic.srvDie();
        }
        for (Service Serve : Configuration.getSvc().values()) {
            curProtocol.outQUIT(Serve, message);
        }
        main.goGracefullyIntoTheNight();
    }
}

