/*
 * Decompiled with CFR 0.152.
 */
package ecks.protocols;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.Utility.Client;
import ecks.main;
import ecks.protocols.Generic;
import ecks.protocols.Protocol;
import ecks.services.Service;
import ecks.util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ngfqircd
implements Protocol {
    BufferedWriter out;
    Protocol.States myState = Protocol.States.S_DISCONNECTED;
    boolean wasOnline = false;
    String myUplink;
    long connected;
    int nCount = 0;
    final String modeargs = "ovblkIE";

    @Override
    public long getWhenStarted() {
        return this.connected;
    }

    @Override
    public Map<Character, Character> getPrefixMap() {
        HashMap<Character, Character> z = new HashMap<Character, Character>();
        z.put(Character.valueOf('@'), Character.valueOf('o'));
        z.put(Character.valueOf('+'), Character.valueOf('v'));
        return z;
    }

    @Override
    public String getModeArgs() {
        return "ovblkIE";
    }

    @Override
    public Protocol.States getState() {
        return this.myState;
    }

    @Override
    public void setState(Protocol.States newstate) {
        this.myState = newstate;
    }

    @Override
    public void setBuffers(BufferedWriter o) {
        this.out = o;
        this.myState = Protocol.States.S_HASBUFFERS;
        Logging.info("PROTOCOL", "Waiting for server...");
    }

    @Override
    public void Incoming(String line) {
        Logging.raw(line, true);
        if (line == null) {
            Logging.error("PROTOCOL", "Got NULL incoming line!");
            main.goGracefullyIntoTheNight();
            return;
        }
        boolean hasSource = line.startsWith(":");
        String[] halves = line.split(" :", 2);
        boolean hasExtArg = halves.length > 1;
        String[] tokens = halves[0].split(" ");
        String command = tokens[hasSource ? 1 : 0];
        String source = hasSource ? tokens[0].substring(1) : null;
        this.Delegate(command, hasSource, source, tokens, hasExtArg, hasExtArg ? halves[1] : null);
    }

    @Override
    public void Outgoing(String what) throws IOException {
        this.out.write(what + "\r\n");
        Logging.raw(what, false);
        this.out.flush();
    }

    void Delegate(String cmd, Boolean hasSource, String source, String[] tokens, Boolean hasargs, String args) {
        try {
            if (cmd.equals("PING")) {
                this.outPong();
                if (this.myState == Protocol.States.S_SERVICES) {
                    this.myState = Protocol.States.S_ONLINE;
                    Logging.info("PROTOCOL", "Ecks Services " + util.getVersion() + " operational. " + util.getTS());
                    this.connected = Long.parseLong(util.getTS());
                }
                if (this.myState == Protocol.States.S_BURSTING) {
                    if (!this.wasOnline) {
                        Logging.info("PROTOCOL", "Burst completed. Bringing services online...");
                        this.myState = Protocol.States.S_SERVICES;
                        Generic.BringServicesOnline();
                        this.wasOnline = true;
                    } else {
                        Logging.warn("PROTOCOL", "Network recovered from netsplit...");
                        Logging.info("PROTOCOL", "Burst completed.");
                        this.myState = Protocol.States.S_SERVICES;
                    }
                }
            } else if (cmd.equals("NOTICE")) {
                if (this.myState == Protocol.States.S_HASBUFFERS) {
                    ++this.nCount;
                    if (this.nCount > 3) {
                        this.outHandshake();
                        Logging.info("PROTOCOL", "Sending Handshake...");
                    }
                }
            } else if (cmd.equals("GNOTICE")) {
                if (this.myState != Protocol.States.S_ONLINE) {
                    Logging.info("PROTOCOL", "Connection established. Beginning burst...");
                    this.myState = Protocol.States.S_BURSTING;
                }
            } else if (cmd.equals("NICK")) {
                if (hasSource.booleanValue()) {
                    Generic.nickRename(source, tokens[2], Long.parseLong(args));
                } else {
                    this.nickSignOn(tokens, args);
                }
            } else if (cmd.equals("KICK")) {
                Generic.nickGotKicked(tokens[3], tokens[2]);
            } else if (cmd.equals("SERVER")) {
                this.myUplink = tokens[1];
            } else if (cmd.equals("KILL")) {
                Generic.nickGotKilled(tokens[2]);
            } else if (!cmd.equals("AWAY")) {
                if (cmd.equals("PART")) {
                    Generic.chanPart(tokens[2], source);
                } else if (cmd.equals("QUIT")) {
                    Generic.nickSignOff(source);
                } else if (cmd.equals("MODE")) {
                    if (tokens[2].startsWith("#")) {
                        String modestring = tokens[4];
                        if (tokens.length > 4) {
                            for (int i = 5; i < tokens.length; ++i) {
                                modestring = modestring + " " + tokens[i];
                            }
                        }
                        Generic.modeChan(tokens[2], modestring);
                    } else {
                        String modestring = args;
                        Generic.modeUser(tokens[2], modestring);
                    }
                } else if (cmd.equals("PRIVMSG")) {
                    Hooks.hook(Hooks.Events.E_PRIVMSG, source, tokens[2], args);
                } else if (cmd.equals("SJOIN")) {
                    if (!Generic.Users.containsKey(source.toLowerCase())) {
                        if (tokens.length > 4) {
                            String ExtModes = "";
                            for (int i = 5; i < tokens.length; ++i) {
                                ExtModes = " " + tokens[i];
                            }
                            Generic.chanBurst(Integer.parseInt(tokens[2]), tokens[3], tokens[4] + ExtModes, args.split(" "));
                        } else {
                            Generic.chanBurst(Integer.parseInt(tokens[2]), tokens[3], tokens[4], args.split(" "));
                        }
                    } else {
                        Generic.chanJoin(Integer.parseInt(tokens[2]), tokens[3], source);
                    }
                } else if (cmd.equals("TOPIC")) {
                    Generic.chanTopic(Integer.parseInt(tokens[4]), tokens[2], args);
                } else if (cmd.equals("ERROR")) {
                    Logging.error("PROTOCOL", "Recieved Error. Disconnecting.");
                    Logging.warn("PROTOCOL", "Error was: " + (hasargs != false ? args : ""));
                    main.goGracefullyIntoTheNight();
                } else {
                    Logging.warn("PROTOCOL", "Unsupported command: " + cmd);
                }
            }
        }
        catch (IOException ioe) {
            Logging.error("PROTOCOL", "Got IOException while delegating command: " + cmd);
            Logging.error("PROTOCOL", "IOE Claims: " + ioe.getMessage());
        }
    }

    void nickSignOn(String[] tokens, String args) {
        String[] newargs = new String[]{null, tokens[1], tokens[2], tokens[3], tokens[4], tokens[5], tokens[6], tokens[6], tokens[7], tokens[8], tokens[9], args, null};
        Generic.nickSignOn(newargs);
    }

    void outPong() throws IOException {
        this.Outgoing("PONG :" + util.getTS());
        Logging.info("PROTOCOL", "Server pinged...");
    }

    void outHandshake() throws IOException {
        this.Outgoing("CAPAB :QS TSORA SERVICES CHW KLN GLN KNOCK SSJOIN TSMODE");
        this.Outgoing("PASS " + Configuration.Config.get("password") + " :TS");
        this.Outgoing("SERVER " + Configuration.Config.get("hostname") + " 1 :Ecks Services " + util.getVersion());
        this.Outgoing("SVINFO 6 3 1 :" + util.getTS());
    }

    @Override
    public void srvIntroduce(Service whom) {
        try {
            String o = "NICK " + whom.getname() + " 1 " + util.getTS() + " +ior " + whom.getname() + " services " + Configuration.Config.get("hostname") + " 0 1066435662 :Network Services";
            this.Outgoing(o);
            String[] tokens = o.split(" ");
            String[] newargs = new String[]{null, tokens[1], tokens[2], tokens[3], tokens[4], tokens[5], tokens[6], tokens[6], tokens[7], tokens[8], tokens[9], "Network Services", null};
            Generic.nickSignOn(newargs);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while introducing service: " + whom.getname());
            Logging.error("PROTOCOL", "IOE Claims: " + e.getMessage());
        }
    }

    @Override
    public void srvJoin(Service who, String where, String modes) {
        try {
            this.Outgoing("SJOIN " + util.getTS() + " " + where + " " + modes + " :@" + who.getname());
            Generic.chanJoin(Integer.parseInt(util.getTS()), where, who.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void srvPart(Service who, String where, String why) {
        try {
            this.Outgoing(":" + who.getname() + " PART " + where + " :" + why);
            Generic.chanPart(where, who.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outPRVMSG(Service me, String coru, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " PRIVMSG " + coru + " :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outNOTICE(Service me, String coru, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " NOTICE " + coru + " :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outQUIT(Service me, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " QUIT :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outSETMODE(Service me, String channel, String mode, String who) {
        try {
            this.Outgoing(":" + me.getname() + " MODE " + channel + " " + mode + " " + who);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outKILL(Service me, String who, String why) {
        try {
            this.Outgoing(":" + me.getname() + " KILL " + who + " :" + Configuration.Config.get("hostname") + "!services!" + me.getname() + "! (" + why + ")");
            Generic.nickSignOff(who.toLowerCase());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outPART(Service me, String chan, String reason) {
        try {
            this.Outgoing(":" + me.getname() + " PART " + chan + " :" + reason);
            Generic.chanPart(chan, me.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outGLINE(Service me, Client who, String why) {
        try {
            this.Outgoing(":" + Configuration.Config.get("hostname") + " AKILL " + who.host + " " + who.ident + " 3600 " + me.getname() + " " + util.getTS() + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outGLINE(Service me, String mask, long duration, String why) {
        try {
            String[] t = mask.split("@");
            String id = t[0];
            String host = t[1];
            this.Outgoing(":" + Configuration.Config.get("hostname") + " AKILL " + host + " " + id + " " + duration + " " + me.getname() + " " + util.getTS() + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outUNGLINE(Service me, String mask) {
        try {
            String[] t = mask.split("@");
            String id = t[0];
            String host = t[1];
            this.Outgoing("RAKILL " + host + " " + id + " " + me.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void srvSetAuthed(Service me, String who, Long svsid) {
        this.outMODE(me, Generic.Users.get(who.toLowerCase()), "+rd", svsid.toString());
    }

    @Override
    public void srvUnSetAuthed(Service me, String who) {
        this.outMODE(me, Generic.Users.get(who.toLowerCase()), "-rd", "");
    }

    @Override
    public void outKICK(Service me, String who, String where, String why) {
        try {
            this.Outgoing(":" + me.getname() + " KICK " + where + " " + who + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outINVITE(Service me, String who, String where) {
        try {
            this.Outgoing(":" + me.getname() + " INVITE " + who + " " + where);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outMODE(Service me, Client who, String what, String more) {
        try {
            this.Outgoing("SVSMODE " + who.uid + " " + who.signon + " " + what + " " + more);
            who.modes.applyChanges(what + " " + more);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outTOPIC(Service me, String where, String what) {
        try {
            this.Outgoing(":" + me.getname() + " TOPIC " + where + " NETWORK " + util.getTS() + " :" + what);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }
}

