/*
 * Decompiled with CFR 0.152.
 */
package com.crackj2ee.mail;

import com.crackj2ee.mail.Base64;
import com.crackj2ee.mail.HtmlMail;
import com.crackj2ee.mail.MailException;
import com.crackj2ee.mail.TextMail;

public abstract class Mail {
    private static final String REGEX_EMAIL = "[a-zA-Z0-9_\\.-]+@[a-zA-Z0-9_-]+(.[a-zA-Z0-9_-]+){1,2}";
    private String from;
    private String to;
    private String subject;

    Mail(String from, String to, String subject) {
        this.from = this.checkEmailAddress(from);
        this.to = this.checkEmailAddress(to);
        this.subject = subject == null ? "Untitled" : subject;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getSubject() {
        return this.subject;
    }

    protected abstract String getContentType();

    protected abstract byte[] getBody();

    protected String getToDomain() {
        int n = this.to.indexOf(64);
        return this.to.substring(n + 1);
    }

    protected String getFromDomain() {
        int n = this.from.indexOf(64);
        return this.from.substring(n + 1);
    }

    protected String getBase64Body() {
        return Base64.byteArrayToBase64(this.getBody());
    }

    private String checkEmailAddress(String emailAddr) {
        if (emailAddr == null) {
            throw new MailException("Email address is empty.");
        }
        if ((emailAddr = emailAddr.trim()).equals("")) {
            throw new MailException("Email address is empty.");
        }
        if (!emailAddr.matches(REGEX_EMAIL)) {
            throw new MailException("Invalid email address.");
        }
        return emailAddr.trim();
    }

    public static Mail buildTextMail(String from, String to, String subject, String body) {
        return new TextMail(from, to, subject, body);
    }

    public static Mail buildHtmlMail(String from, String to, String subject, String body) {
        return new HtmlMail(from, to, subject, body);
    }
}

