/*
 * Decompiled with CFR 0.152.
 */
package ecks;

import ecks.Configuration;
import ecks.Logging;
import ecks.main;
import ecks.services.Service;
import ecks.services.modules.CommandModule;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ConfParse {
    Document dom;

    public ConfParse() {
        this.parseXmlFile();
        this.parseDocument();
    }

    private void parseXmlFile() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse("ecks.xml");
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseDocument() {
        Element docEle = this.dom.getDocumentElement();
        NodeList zl = docEle.getElementsByTagName("debuglevel");
        Element el = (Element)zl.item(0);
        Configuration.Config.put("debuglevel", el.getAttribute("value"));
        zl = docEle.getElementsByTagName("debugdevice");
        el = (Element)zl.item(0);
        Configuration.Config.put("debugdevice", el.getAttribute("value"));
        zl = docEle.getElementsByTagName("debugchan");
        el = (Element)zl.item(0);
        Configuration.Config.put("debugchan", el.getAttribute("value"));
        zl = docEle.getElementsByTagName("joinchannels");
        el = (Element)zl.item(0);
        Configuration.Config.put("joinchannels", el.getAttribute("value"));
        zl = docEle.getElementsByTagName("secure");
        el = (Element)zl.item(0);
        Configuration.Config.put("secure", el.getAttribute("value"));
        NodeList nl = docEle.getElementsByTagName("uplink");
        Configuration.Config.put("protocol", ((Element)nl.item(0)).getAttribute("protocol"));
        NodeList cnod = nl.item(0).getChildNodes();
        for (int i = 0; i < cnod.getLength(); ++i) {
            String mname = "";
            String mval = "";
            try {
                mname = cnod.item(i).getNodeName();
                mval = cnod.item(i).getAttributes().getNamedItem("value").getNodeValue();
            }
            catch (NullPointerException N) {
                // empty catch block
            }
            if (mname.equals("#text") || mname.equals("#comment")) continue;
            Configuration.Config.put(mname, mval);
        }
    }

    public void parseDocument2() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("service");
        for (int i = 0; i < nl.getLength(); ++i) {
            String newSvc = ((Element)nl.item(i)).getAttribute("name");
            try {
                Configuration.Services.put(newSvc.toLowerCase(), (Service)Class.forName(((Element)nl.item(i)).getAttribute("class")).newInstance());
                Configuration.Services.get(newSvc.toLowerCase()).setname(newSvc);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                Logging.error("CONFIGURATION", "Exception: Class not found! (check your config)");
                main.goGracefullyIntoTheNight();
            }
            NodeList z = ((Element)nl.item(i)).getElementsByTagName("modules");
            if (z.item(0) == null) continue;
            NodeList nle = ((Element)z.item(0)).getElementsByTagName("command");
            Logging.info("CONFIGURATION", "Loading " + nle.getLength() + " command modules for service " + newSvc + ".");
            for (int iz = 0; iz < nle.getLength(); ++iz) {
                try {
                    Configuration.Services.get(newSvc.toLowerCase()).addCommand(((CommandModule)Class.forName(((Element)nle.item(iz)).getAttribute("value")).newInstance()).getName().toLowerCase(), (CommandModule)Class.forName(((Element)nle.item(iz)).getAttribute("value")).newInstance());
                    Logging.verbose("CONFIGURATION", "Loading command module " + ((Element)nle.item(iz)).getAttribute("value") + " for service " + newSvc + ".");
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

