/*
 * Decompiled with CFR 0.152.
 */
package ecks.Utility;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class RBLChecker {
    public static final String RBL_ORDB = "relays.ordb.org";
    public static final String RBL_SPAMCOP = "bl.spamcop.net";
    public static final String RBL_DSBL = "list.dsbl.org";
    public static final String RBL_OSIRUSOFT = "relays.osirusoft.com";
    private static String RBL = "relays.ordb.org";

    private RBLChecker() {
    }

    public static void main(String[] args) {
        System.out.println(RBLChecker.checkRelay("127.0.0.2"));
        System.out.println(RBLChecker.checkRelay("mail.gmx.net"));
    }

    public static void setRBL(String rbl) {
        RBL = rbl != null && !rbl.equals("") ? rbl : RBL_ORDB;
    }

    public static boolean checkRelay(String hostName) {
        try {
            InetAddress.getByName(RBLChecker.invertIPAddress(hostName) + "." + RBL);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    protected static String invertIPAddress(String originalIPAddress) {
        StringTokenizer t = new StringTokenizer(originalIPAddress, ".");
        String inverted = t.nextToken();
        while (t.hasMoreTokens()) {
            inverted = t.nextToken() + "." + inverted;
        }
        return inverted;
    }
}

