/*
 * Decompiled with CFR 0.152.
 */
package ecks;

import ecks.Configuration;
import ecks.Connection;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.RPC.RPCHandler;
import ecks.Storage;
import ecks.Threads.DbThread;
import ecks.protocols.Generic;
import ecks.protocols.Protocol;
import ecks.util;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.xmlrpc.WebServer;

public class main {
    static Configuration myConf = new Configuration();

    public static void main(String[] args) throws Exception {
        Protocol myProto = null;
        try {
            myProto = (Protocol)Class.forName(Configuration.Config.get("protocol")).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        assert (myProto != null);
        Generic.SetProtocol(myProto);
        Logging.setup();
        Logging.summary("STARTUP", "Welcome to Ecks Services. Internal Version: " + util.getVersion());
        Logging.verbose("STARTUP", "Logging loaded...");
        Hooks.initialize();
        Logging.verbose("STARTUP", "Hooks initialized...");
        Configuration.LoadServices();
        Logging.info("STARTUP", "Services loaded...");
        Configuration.Database = new Storage();
        Configuration.Database.loadDB();
        Logging.info("STARTUP", "Database loaded...");
        util.startThread(new Thread(new DbThread())).start();
        Logging.info("STARTUP", "Database thread started...");
        InetAddress inetT = Configuration.Config.get("localhost").toLowerCase().equals("any") ? InetAddress.getLocalHost() : InetAddress.getByName(Configuration.Config.get("localhost"));
        Connection myConnection = new Connection(Configuration.Config.get("remote"), Integer.parseInt(Configuration.Config.get("port")), Configuration.Config.get("localport"), inetT, myProto);
        myConnection.Connect();
        Logging.info("STARTUP", "Connection attempted...");
        main.myConf.RPCServer = Configuration.Config.get("rpcport").equals("any") ? new WebServer(8081) : new WebServer(Integer.parseInt(Configuration.Config.get("rpcport")), inetT);
        main.myConf.RPCServer.addHandler("ecks", new RPCHandler());
        main.myConf.RPCServer.start();
        Logging.info("STARTUP", "XMLRPC Started...");
        Logging.verbose("STARTUP", "Good luck!");
    }

    public static synchronized void goGracefullyIntoTheNight() {
        if (Generic.curProtocol.getState().equals((Object)Protocol.States.S_DISCONNECTING)) {
            System.exit(0);
        }
        Generic.curProtocol.setState(Protocol.States.S_DISCONNECTING);
        Logging.warn("SHUTDOWN", "Interrupting Threads...");
        for (Thread t : util.getThreads()) {
            t.interrupt();
        }
        Logging.warn("SHUTDOWN", "Stopping RPC");
        main.myConf.RPCServer.shutdown();
        if (Generic.curProtocol.getWhenStarted() != 0L) {
            Logging.summary("SHUTDOWN", "Uptime was: " + (Long.parseLong(util.getTS()) - Generic.curProtocol.getWhenStarted()));
        } else {
            Logging.summary("SHUTDOWN", "Never established a connection!");
        }
        Logging.warn("SHUTDOWN", "Goodbye.");
        for (Thread t : util.getThreads()) {
            t.interrupt();
        }
        try {
            Connection.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

