/*
 * Decompiled with CFR 0.152.
 */
package ecks.protocols;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.Utility.Client;
import ecks.main;
import ecks.protocols.Generic;
import ecks.protocols.Protocol;
import ecks.services.Service;
import ecks.util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class cots
implements Protocol {
    BufferedWriter out;
    Protocol.States myState = Protocol.States.S_DISCONNECTED;
    boolean wasOnline = false;
    String myUplink;
    long connected;
    int nCount = 0;
    String modeargs = "";
    Map<String, String> xlate = new HashMap<String, String>();
    Map<Character, Character> mPrefix = new HashMap<Character, Character>();

    @Override
    public long getWhenStarted() {
        return this.connected;
    }

    @Override
    public String getModeArgs() {
        return this.modeargs;
    }

    @Override
    public Map<Character, Character> getPrefixMap() {
        return this.mPrefix;
    }

    @Override
    public Protocol.States getState() {
        return this.myState;
    }

    @Override
    public void setState(Protocol.States newstate) {
        this.myState = newstate;
    }

    @Override
    public void setBuffers(BufferedWriter o) {
        this.out = o;
        this.myState = Protocol.States.S_HASBUFFERS;
        Logging.info("PROTOCOL", "Waiting for server...");
    }

    @Override
    public void Incoming(String line) {
        String source;
        Logging.raw(line, true);
        if (line == null) {
            Logging.error("PROTOCOL", "Got NULL incoming line!");
            main.goGracefullyIntoTheNight();
            return;
        }
        boolean hasSource = line.startsWith(":");
        String[] halves = line.split(" :", 2);
        boolean hasExtArg = halves.length > 1;
        String[] tokens = halves[0].split(" ");
        String command = tokens[hasSource ? 1 : 0];
        String string = source = hasSource ? tokens[0].substring(1) : null;
        if (hasSource) {
            source = this.o2n(source);
        }
        this.Delegate(command, hasSource, source, tokens, hasExtArg, hasExtArg ? halves[1] : null);
    }

    @Override
    public void Outgoing(String what) throws IOException {
        this.out.write(what);
        this.out.newLine();
        Logging.raw(what, false);
        this.out.flush();
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void Delegate(String cmd, Boolean hasSource, String source, String[] tokens, Boolean hasargs, String args) {
        try {
            if (cmd.equals("PING")) {
                this.outPong();
            } else if (cmd.equals("NOTICE")) {
                if (this.myState == Protocol.States.S_HASBUFFERS) {
                    this.outHandshake();
                    Logging.info("PROTOCOL", "Sending Handshake...");
                }
            } else if (cmd.equals("CHANMODE")) {
                if (!tokens[2].equals("D") && !this.modeargs.contains(tokens[1])) {
                    this.modeargs = this.modeargs + tokens[1];
                }
            } else if (cmd.equals("BURST")) {
                if (tokens[1].equals("R")) {
                    this.myState = Protocol.States.S_SERVICES;
                    Generic.BringServicesOnline();
                    this.wasOnline = true;
                    this.Outgoing("BURST E");
                    this.myState = Protocol.States.S_BURSTING;
                    this.Outgoing("BURST R");
                }
                if (tokens[1].equals("E")) {
                    this.myState = Protocol.States.S_ONLINE;
                    Logging.info("PROTOCOL", "Ecks Services " + util.getVersion() + " operational. " + util.getTS());
                    this.connected = Long.parseLong(util.getTS());
                }
            } else if (cmd.equals("NOTE")) {
                Logging.info("PROTOCOL", "NOTE: " + args);
            } else if (cmd.equals("PREFIX")) {
                String[] blah = args.substring(1).split("\\)");
                for (int i = 0; i < blah[0].length(); ++i) {
                    this.mPrefix.put(Character.valueOf(blah[1].charAt(i)), Character.valueOf(blah[0].charAt(i)));
                }
            } else if (cmd.equals("USER")) {
                if (hasargs.booleanValue()) {
                    this.nickSignOn(tokens, args);
                } else {
                    this.nickSignOn(tokens, tokens[16]);
                }
            } else if (cmd.equals("NICK")) {
                Generic.nickRename(source, tokens[2], Long.parseLong(util.getTS()));
            } else if (cmd.equals("KICK")) {
                Generic.nickGotKicked(this.o2n(tokens[3]), this.o2n(tokens[2]));
            } else if (cmd.equals("SERVER")) {
                this.myUplink = tokens[1];
                this.xlate.put(tokens[2], tokens[1]);
            } else if (cmd.equals("KILL")) {
                if (tokens[2].equals(Configuration.Config.get("hostname"))) {
                    Logging.error("PROTOCOL", "We've done something wrong. Bailing.");
                    main.goGracefullyIntoTheNight();
                }
                Generic.nickGotKilled(this.o2n(tokens[2]));
            } else if (!cmd.equals("AWAY")) {
                if (cmd.equals("PART")) {
                    Generic.chanPart(tokens[2], source);
                } else if (cmd.equals("QUIT")) {
                    if (this.myUplink.equals(this.o2n(source))) {
                        main.goGracefullyIntoTheNight();
                        return;
                    }
                    Generic.nickSignOff(source);
                } else if (cmd.equals("MODE")) {
                    if (!hasargs.booleanValue()) {
                        args = tokens[3];
                    }
                    if (this.o2n(tokens[2]).startsWith("#")) {
                        Generic.modeChan(this.o2n(tokens[2]), args);
                    } else {
                        Generic.modeUser(this.o2n(tokens[2]), args);
                    }
                } else if (cmd.equals("SMODE")) {
                    Generic.modeChan(tokens[3], args);
                } else if (cmd.equals("PRIVMSG")) {
                    Hooks.hook(Hooks.Events.E_PRIVMSG, source, this.o2n(tokens[2]), args);
                } else if (cmd.equals("JOIN")) {
                    if (tokens[2].equals("0")) {
                        Generic.Users.get((Object)source).chans.clear();
                    } else {
                        Generic.chanJoin(0, tokens[2], source);
                    }
                } else if (cmd.equals("SJOIN")) {
                    String[] temp = args.split(" ");
                    for (int i = 0; i < temp.length; ++i) {
                        String z = "";
                        for (Map.Entry<Character, Character> e : this.mPrefix.entrySet()) {
                            if (!temp[i].startsWith(e.getKey().toString())) continue;
                            z = temp[i].substring(0, 1);
                            temp[i] = temp[i].substring(1);
                        }
                        temp[i] = this.o2n(temp[i]);
                        temp[i] = z + temp[i];
                    }
                    Generic.chanBurst(Integer.parseInt(tokens[2]), tokens[3], "", temp);
                } else if (cmd.equals("TOPIC")) {
                    Generic.chanTopic(0, tokens[2], args);
                } else if (cmd.equals("ERROR")) {
                    Logging.error("PROTOCOL", "Recieved Error. Disconnecting.");
                    Logging.warn("PROTOCOL", "Error was: " + (hasargs != false ? args : ""));
                    main.goGracefullyIntoTheNight();
                } else {
                    Logging.warn("PROTOCOL", "Unsupported command: " + cmd);
                }
            }
        }
        catch (IOException ioe) {
            Logging.error("PROTOCOL", "Got IOException while delegating command: " + cmd);
            Logging.error("PROTOCOL", "IOE Claims: " + ioe.getMessage());
        }
    }

    void nickSignOn(String[] tokens, String args) {
        this.xlate.put(tokens[2], tokens[4]);
        try {
            String[] newargs = new String[]{null, tokens[4], "0", tokens[3], tokens[11], tokens[5], tokens[7], tokens[6], tokens[0], "0", String.valueOf(util.ip2long(InetAddress.getByName(tokens[8]))), args, null};
            Generic.nickSignOn(newargs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void outPong() throws IOException {
        this.Outgoing("PONG :" + util.getTS());
        Logging.info("PROTOCOL", "Server pinged...");
    }

    void outHandshake() throws IOException {
        this.Outgoing("NOTICE & :\u0001VERSION  " + util.getVersion() + " \u0001");
        this.Outgoing("AUTH S-A-D * I " + Configuration.Config.get("password"));
        this.Outgoing("SERVER " + Configuration.Config.get("hostname") + " " + Configuration.Config.get("numeric") + " " + util.getTS() + " :Ecks Services " + util.getVersion());
    }

    @Override
    public void srvIntroduce(Service whom) {
        try {
            this.xlate.put("0" + util.paddingString(whom.getname(), 7, '0', true), whom.getname());
            String o = ":" + Configuration.Config.get("hostname") + " USER 0" + util.paddingString(whom.getname(), 7, '0', true) + " " + util.getTS() + " " + whom.getname() + " services " + Configuration.Config.get("hostname") + " " + Configuration.Config.get("hostname") + " 0 " + " * * " + " +ior " + " * * " + util.getTS() + " " + util.getTS() + " " + ":Network Services";
            this.Outgoing(o);
            String[] tokens = o.split(" ");
            String[] newargs = new String[]{null, tokens[4], "0", tokens[3], tokens[11], tokens[5], tokens[7], tokens[6], tokens[0], "0", tokens[8], "Network Services", null};
            Generic.nickSignOn(newargs);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while introducing service: " + whom.getname());
            Logging.error("PROTOCOL", "IOE Claims: " + e.getMessage());
        }
    }

    @Override
    public void srvJoin(Service who, String where, String modes) {
        try {
            this.Outgoing(":" + who.getname() + " JOIN " + where);
            this.Outgoing(":" + who.getname() + " MODE :" + modes);
            Generic.chanJoin(Integer.parseInt(util.getTS()), where, who.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void srvPart(Service who, String where, String why) {
        try {
            this.Outgoing(":" + who.getname() + " PART " + where + " :" + why);
            Generic.chanPart(where, who.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outPRVMSG(Service me, String coru, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " PRIVMSG " + coru + " :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outNOTICE(Service me, String coru, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " NOTICE " + coru + " :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outQUIT(Service me, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " QUIT :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outSETMODE(Service me, String channel, String mode, String who) {
        try {
            this.Outgoing(":" + me.getname() + " MODE " + channel + " " + mode + " " + who);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outKILL(Service me, String who, String why) {
        try {
            this.Outgoing(":" + me.getname() + " KILL " + who + " :" + Configuration.Config.get("hostname") + "!services!" + me.getname() + "! (" + why + ")");
            Generic.nickSignOff(who.toLowerCase());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outPART(Service me, String chan, String reason) {
        try {
            this.Outgoing(":" + me.getname() + " PART " + chan + " :" + reason);
            Generic.chanPart(chan, me.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outGLINE(Service me, Client who, String why) {
        try {
            this.Outgoing(":" + Configuration.Config.get("hostname") + " AKILL " + who.host + " " + who.ident + " 0 " + me.getname() + " " + util.getTS() + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outGLINE(Service me, String mask, long duration, String why) {
        try {
            String[] t = mask.split("@");
            String id = t[0];
            String host = t[1];
            this.Outgoing(":" + Configuration.Config.get("hostname") + " AKILL " + host + " " + id + " " + duration + " " + me.getname() + " " + util.getTS() + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outUNGLINE(Service me, String mask) {
        try {
            String[] t = mask.split("@");
            String id = t[0];
            String host = t[1];
            this.Outgoing("RAKILL " + host + " " + id + " " + me.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void srvSetAuthed(Service me, String who, Long svsid) {
        this.outMODE(me, Generic.Users.get(who.toLowerCase()), "+rd", svsid.toString());
    }

    @Override
    public void srvUnSetAuthed(Service me, String who) {
        this.outMODE(me, Generic.Users.get(who.toLowerCase()), "-rd", "");
    }

    @Override
    public void outKICK(Service me, String who, String where, String why) {
        try {
            this.Outgoing(":" + me.getname() + " KICK " + where + " " + who + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outINVITE(Service me, String who, String where) {
        try {
            this.Outgoing(":" + me.getname() + " INVITE " + who + " " + where);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outMODE(Service me, Client who, String what, String more) {
        try {
            this.Outgoing("SVSMODE " + who.uid + " " + who.signon + " " + what + " " + more);
            who.modes.applyChanges(what + " " + more);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outTOPIC(Service me, String where, String what) {
    }

    String o2n(String what) {
        if (what.startsWith("0")) {
            return this.xlate.get(what);
        }
        return what;
    }
}

