/*
 * Decompiled with CFR 0.152.
 */
package ecks.protocols;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.Utility.Client;
import ecks.main;
import ecks.protocols.Generic;
import ecks.protocols.Protocol;
import ecks.services.Service;
import ecks.util;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class inspircd
implements Protocol {
    BufferedWriter out;
    Protocol.States myState = Protocol.States.S_DISCONNECTED;
    boolean wasOnline = false;
    String myUplink;
    long connected;
    final String modeargs = "ovqahblkIE";

    @Override
    public long getWhenStarted() {
        return this.connected;
    }

    @Override
    public Map<Character, Character> getPrefixMap() {
        HashMap<Character, Character> z = new HashMap<Character, Character>();
        z.put(Character.valueOf('@'), Character.valueOf('o'));
        z.put(Character.valueOf('+'), Character.valueOf('v'));
        z.put(Character.valueOf('~'), Character.valueOf('q'));
        z.put(Character.valueOf('&'), Character.valueOf('a'));
        z.put(Character.valueOf('%'), Character.valueOf('h'));
        return z;
    }

    @Override
    public String getModeArgs() {
        return "ovqahblkIE";
    }

    @Override
    public Protocol.States getState() {
        return this.myState;
    }

    @Override
    public void setState(Protocol.States newstate) {
        this.myState = newstate;
    }

    @Override
    public void setBuffers(BufferedWriter o) {
        this.out = o;
        this.myState = Protocol.States.S_HASBUFFERS;
        Logging.info("PROTOCOL", "Waiting for server...");
    }

    @Override
    public void Incoming(String line) {
        Logging.raw(line, true);
        if (line == null) {
            Logging.error("PROTOCOL", "Got NULL incoming line!");
            main.goGracefullyIntoTheNight();
            return;
        }
        boolean hasSource = line.startsWith(":");
        String[] halves = line.split(" :", 2);
        boolean hasExtArg = halves.length > 1;
        String[] tokens = halves[0].split(" ");
        String command = tokens[hasSource ? 1 : 0];
        String source = hasSource ? tokens[0].substring(1) : null;
        this.Delegate(command, hasSource, source, tokens, hasExtArg, hasExtArg ? halves[1] : null);
    }

    @Override
    public void Outgoing(String what) throws IOException {
        this.out.write(what + "\r\n");
        Logging.raw(what, false);
        this.out.flush();
    }

    void Delegate(String cmd, Boolean hasSource, String source, String[] tokens, Boolean hasargs, String args) {
        try {
            if (cmd.equals("PING")) {
                this.outPong();
            } else if (cmd.equals("ENDBURST")) {
                Logging.info("PROTOCOL", "Burst completed.");
                this.myState = Protocol.States.S_ONLINE;
                Logging.info("PROTOCOL", "Ecks Services " + util.getVersion() + " operational. " + util.getTS());
                this.connected = Long.parseLong(util.getTS());
            } else if (cmd.equals("CAPAB")) {
                if (tokens[1].equals("END")) {
                    Logging.info("PROTOCOL", "Sending Handshake...");
                    this.outHandshake();
                    this.myState = Protocol.States.S_SERVICES;
                    Generic.BringServicesOnline();
                    this.myState = Protocol.States.S_BURSTING;
                }
            } else if (!cmd.equals("NOTICE") && !cmd.equals("GNOTICE")) {
                if (cmd.equals("METADATA")) {
                    if (tokens[3].equals("accountname")) {
                        Logging.info("PROTOCOL", "User " + tokens[2] + " was previously authed.");
                        if (Configuration.getSvc().containsKey(Configuration.authservice)) {
                            Logging.info("PROTOCOL", "Attempting re-entry...");
                            Configuration.getSvc().get(Configuration.authservice).handle(tokens[2].toLowerCase(), "service", "reauth " + args + " " + util.getTS());
                        }
                    }
                } else if (cmd.equals("NICK")) {
                    if (tokens.length > 7) {
                        this.nickSignOn(tokens, args);
                    } else {
                        Generic.nickRename(source, tokens[2], 0L);
                    }
                } else if (cmd.equals("KICK")) {
                    Generic.nickGotKicked(tokens[3], tokens[2]);
                } else if (cmd.equals("SERVER")) {
                    this.myUplink = tokens[1];
                } else if (cmd.equals("KILL")) {
                    Generic.nickGotKilled(tokens[2]);
                } else if (!cmd.equals("AWAY")) {
                    if (cmd.equals("PART")) {
                        Generic.chanPart(tokens[2], source);
                    } else if (cmd.equals("QUIT")) {
                        Generic.nickSignOff(source);
                    } else if (cmd.equals("OPERTYPE")) {
                        Generic.modeUser(source, "+o");
                    } else if (cmd.equals("FMODE")) {
                        if (tokens[2].startsWith("#")) {
                            String modestring = tokens[4];
                            if (tokens.length > 4) {
                                for (int i = 5; i < tokens.length; ++i) {
                                    modestring = modestring + " " + tokens[i];
                                }
                            }
                            Generic.modeChan(tokens[2], modestring);
                        } else {
                            Generic.modeUser(tokens[2], tokens[5]);
                        }
                    } else if (cmd.equals("PRIVMSG")) {
                        Hooks.hook(Hooks.Events.E_PRIVMSG, source, tokens[2], args);
                    } else if (cmd.equals("JOIN")) {
                        Generic.chanJoin(Integer.parseInt(tokens[3]), tokens[2], source);
                    } else if (cmd.equals("FJOIN")) {
                        if (!Generic.Users.containsKey(source.toLowerCase())) {
                            String[] z;
                            String[] n;
                            String m = "";
                            if (hasargs.booleanValue()) {
                                z = n = args.split(" ");
                                int i = -1;
                                for (String y : z) {
                                    String[] c = y.split(",");
                                    m = m + c[0];
                                    n[++i] = c[1];
                                }
                            } else {
                                z = n = tokens;
                                String[] c = z[4].split(",");
                                m = m + c[0];
                                n = new String[]{c[1]};
                            }
                            try {
                                Generic.chanBurst(Integer.parseInt(tokens[3]), tokens[2], m, n);
                            }
                            catch (NullPointerException NPE) {
                                System.out.println(tokens[3] + " " + tokens[2]);
                                NPE.printStackTrace();
                            }
                        } else {
                            Generic.chanJoin(Integer.parseInt(tokens[2]), tokens[3], source);
                        }
                    } else if (cmd.equals("TOPIC")) {
                        Generic.chanTopic(0, tokens[2], args);
                    } else {
                        Logging.warn("PROTOCOL", "Unsupported command: " + cmd);
                    }
                }
            }
        }
        catch (IOException ioe) {
            Logging.error("PROTOCOL", "Got IOException while delegating command: " + cmd);
            Logging.error("PROTOCOL", "IOE Claims: " + ioe.getMessage());
        }
    }

    void nickSignOn(String[] tokens, String args) {
        String[] newargs = new String[]{null, tokens[3], "1", tokens[2], tokens[7], tokens[6], tokens[4], tokens[5], tokens[0], "0", String.valueOf(util.ip2long(tokens[8])), args, null};
        Generic.nickSignOn(newargs);
    }

    void outPong() throws IOException {
        this.Outgoing("PONG :" + util.getTS());
        Logging.info("PROTOCOL", "Server pinged...");
    }

    void outHandshake() throws IOException {
        this.Outgoing("SERVER " + Configuration.Config.get("hostname") + " " + Configuration.Config.get("password") + " 0 :Ecks Services " + util.getVersion());
        this.Outgoing("BURST " + util.getTS());
        this.Outgoing(":" + Configuration.Config.get("hostname") + " VERSION :Ecks Services " + util.getVersion());
    }

    @Override
    public void srvIntroduce(Service whom) {
        try {
            String o = "NICK " + util.getTS() + " " + whom.getname() + " " + Configuration.Config.get("hostname") + " " + Configuration.Config.get("hostname") + " " + whom.getname() + " +ir " + "0.0.0.0 :Network Services";
            this.Outgoing(":" + Configuration.Config.get("hostname") + " " + o);
            String[] tokens = o.split(" ");
            String[] newargs = new String[]{null, tokens[2], "1", tokens[1], tokens[6], tokens[5], tokens[3], tokens[4], "", "0", "0", "0", null};
            Generic.nickSignOn(newargs);
            this.Outgoing(":" + whom.getname() + " OPERTYPE :network service");
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while introducing service: " + whom.getname());
            Logging.error("PROTOCOL", "IOE Claims: " + e.getMessage());
        }
    }

    @Override
    public void srvJoin(Service who, String where, String modes) {
        try {
            this.Outgoing(":" + Configuration.Config.get("hostname") + " FJOIN " + where + " " + util.getTS() + " :@," + who.getname());
            Generic.chanJoin(Integer.parseInt(util.getTS()), where, who.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void srvPart(Service who, String where, String why) {
        try {
            this.Outgoing(":" + who.getname() + " PART " + where + " :" + why);
            Generic.chanPart(where, who.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outPRVMSG(Service me, String coru, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " PRIVMSG " + coru + " :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outNOTICE(Service me, String coru, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " NOTICE " + coru + " :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outQUIT(Service me, String msg) {
        try {
            this.Outgoing(":" + me.getname() + " QUIT :" + msg);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outSETMODE(Service me, String channel, String mode, String who) {
        try {
            this.Outgoing(":" + me.getname() + " MODE " + channel + " " + mode + " " + who);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outKILL(Service me, String who, String why) {
        try {
            this.Outgoing(":" + me.getname() + " KILL " + who + " :" + Configuration.Config.get("hostname") + "!services!" + me.getname() + "! (" + why + ")");
            Generic.nickSignOff(who.toLowerCase());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outPART(Service me, String chan, String reason) {
        try {
            this.Outgoing(":" + me.getname() + " PART " + chan + " :" + reason);
            Generic.chanPart(chan, me.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outGLINE(Service me, Client who, String why) {
        try {
            this.Outgoing(":" + Configuration.Config.get("hostname") + " AKILL " + who.host + " " + who.ident + " 3600 " + me.getname() + " " + util.getTS() + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outGLINE(Service me, String mask, long duration, String why) {
        try {
            String[] t = mask.split("@");
            String id = t[0];
            String host = t[1];
            this.Outgoing(":" + Configuration.Config.get("hostname") + " AKILL " + host + " " + id + " " + duration + " " + me.getname() + " " + util.getTS() + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outUNGLINE(Service me, String mask) {
        try {
            String[] t = mask.split("@");
            String id = t[0];
            String host = t[1];
            this.Outgoing("RAKILL " + host + " " + id + " " + me.getname());
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void srvSetAuthed(Service me, String who, Long svsid) {
        this.outMODE(me, Generic.Users.get(who.toLowerCase()), "+r", "");
        try {
            this.Outgoing(":" + Configuration.Config.get("hostname") + " METADATA " + who.toLowerCase() + " accountname :" + Generic.Users.get((Object)who.toLowerCase()).svsid);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void srvUnSetAuthed(Service me, String who) {
        this.outMODE(me, Generic.Users.get(who.toLowerCase()), "-r", "");
        try {
            this.Outgoing(":" + Configuration.Config.get("hostname") + " METADATA " + who.toLowerCase() + " accountname :\u0000");
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outKICK(Service me, String who, String where, String why) {
        try {
            this.Outgoing(":" + me.getname() + " KICK " + where + " " + who + " :" + why);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outINVITE(Service me, String who, String where) {
        try {
            this.Outgoing(":" + me.getname() + " INVITE " + who + " " + where);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outMODE(Service me, Client who, String what, String more) {
        try {
            this.Outgoing(":" + me.getname() + " MODE " + who.uid + " " + what + " " + more);
            who.modes.applyChanges(what + " " + more);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }

    @Override
    public void outTOPIC(Service me, String where, String what) {
        try {
            this.Outgoing(":" + me.getname() + " TOPIC " + where + " :" + what);
        }
        catch (IOException e) {
            Logging.error("PROTOCOL", "Got IOException while sending a command.");
            Logging.error("PROTOCOL", "IOE: " + e.getMessage() + "... " + e.toString());
        }
    }
}

