/*
 * Decompiled with CFR 0.152.
 */
package ecks.services;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.Threads.SrvAuth_ExpiryThread;
import ecks.protocols.Generic;
import ecks.services.SrvAuth_user;
import ecks.services.bService;
import ecks.services.modules.CommandDesc;
import ecks.util;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrvAuth
extends bService {
    public String name = "SrvAuth";
    public Map<String, SrvAuth_user> Users = new HashMap<String, SrvAuth_user>();
    public Map<Long, String> dbMap = new HashMap<Long, String>();

    @Override
    public void introduce() {
        Hooks.regHook(this, Hooks.Events.E_PRIVMSG);
        Generic.srvIntroduce(this);
        util.startThread(new Thread(new SrvAuth_ExpiryThread())).start();
        Logging.info("SRVAUTH", "Expiry thread started...");
        if (!Configuration.Config.get("debugchan").equals("OFF")) {
            Generic.srvJoin(this, Configuration.Config.get("debugchan"), "+stn");
        }
    }

    public boolean chkpass(String pwd, String user) {
        return this.Users.get((Object)user).password.equals(util.hash(pwd));
    }

    @Override
    public String getname() {
        return this.name;
    }

    @Override
    public void setname(String nname) {
        this.name = nname;
    }

    public CommandDesc.access_levels checkAccess(String user) {
        if (this.Users.containsKey(user)) {
            return this.Users.get((Object)user).services_access;
        }
        return CommandDesc.access_levels.A_NONE;
    }

    @Override
    public void handle(String user, String replyto, String command) {
        String cmd = command.split(" ")[0];
        if (Configuration.Config.get("secure").equals("NO")) {
            super.handle(user.toLowerCase(), replyto.toLowerCase(), command);
            return;
        }
        if (cmd.startsWith("FQDN")) {
            super.handle(user.toLowerCase(), replyto.toLowerCase(), command);
        } else if (cmd.toLowerCase().equals("auth") || cmd.toLowerCase().equals("register") || cmd.toLowerCase().equals("changepass")) {
            Generic.curProtocol.outPRVMSG(this, replyto, "\u0002Error:\u0002 You \u0002*MUST*\u0002 /msg " + this.getname() + "@" + Configuration.Config.get("hostname") + " " + cmd + "!");
        } else {
            super.handle(user.toLowerCase(), replyto.toLowerCase(), command);
        }
    }

    public SrvAuth() {
        Configuration.authservice = this.name.toLowerCase();
    }

    public Map<String, SrvAuth_user> getUsers() {
        return this.Users;
    }

    @Override
    public String getSRVDB() {
        String tOut = "";
        tOut = tOut + "<service class=\"" + this.getClass().getName() + "\" name=\"" + this.name + "\">\r\n";
        for (Map.Entry<String, SrvAuth_user> usar : this.Users.entrySet()) {
            tOut = tOut + "\t" + "<user>\r\n";
            tOut = tOut + "\t\t" + "<username value=\"" + util.encodeUTF(usar.getValue().username) + "\"/>\r\n";
            tOut = tOut + "\t\t" + "<password value=\"" + util.encodeUTF(usar.getValue().password) + "\"/>\r\n";
            tOut = tOut + "\t\t" + "<email value=\"" + util.encodeUTF(usar.getValue().email) + "\"/>\r\n";
            tOut = tOut + "\t\t" + "<access value=\"" + (Object)((Object)usar.getValue().services_access) + "\"/>\r\n";
            tOut = tOut + "\t\t" + "<metadata>\r\n";
            for (Map.Entry<String, String> md : usar.getValue().getAllMeta().entrySet()) {
                tOut = tOut + "\t\t\t" + "<" + util.encodeUTF(md.getKey()) + " value=\"" + util.encodeUTF(md.getValue()) + "\"/>\r\n";
            }
            tOut = tOut + "\t\t" + "</metadata>\r\n";
            tOut = tOut + "\t" + "</user>\r\n";
        }
        tOut = tOut + "</service>\r\n";
        return tOut;
    }

    @Override
    public void loadSRVDB(NodeList XMLin) {
        for (int i = 0; i < XMLin.getLength(); ++i) {
            HashMap<String, String> mTemp = new HashMap<String, String>();
            if (XMLin.item(i).getNodeType() != 1) continue;
            NodeList t = ((Element)XMLin.item(i)).getElementsByTagName("username");
            String uTemp = util.decodeUTF(t.item(0).getAttributes().getNamedItem("value").getNodeValue());
            t = ((Element)XMLin.item(i)).getElementsByTagName("password");
            String pTemp = util.decodeUTF(t.item(0).getAttributes().getNamedItem("value").getNodeValue());
            t = ((Element)XMLin.item(i)).getElementsByTagName("email");
            String eTemp = util.decodeUTF(t.item(0).getAttributes().getNamedItem("value").getNodeValue());
            t = ((Element)XMLin.item(i)).getElementsByTagName("access");
            CommandDesc.access_levels aTemp = CommandDesc.access_levels.valueOf(t.item(0).getAttributes().getNamedItem("value").getNodeValue());
            t = ((Element)XMLin.item(i)).getElementsByTagName("metadata").item(0).getChildNodes();
            for (int j = 0; j < t.getLength(); ++j) {
                if (t.item(j).getNodeType() != 1) continue;
                mTemp.put(util.decodeUTF(t.item(j).getNodeName()), util.decodeUTF(t.item(j).getAttributes().getNamedItem("value").getNodeValue()));
            }
            this.Users.put(uTemp.toLowerCase().trim(), new SrvAuth_user(uTemp, pTemp, eTemp, aTemp, mTemp));
            if (!this.Users.get(uTemp.toLowerCase().trim()).getAllMeta().containsKey("svsid")) {
                if (!this.dbMap.containsKey(i)) {
                    this.Users.get(uTemp.toLowerCase().trim()).setMeta("svsid", String.valueOf(i));
                } else {
                    this.Users.get(uTemp.toLowerCase().trim()).setMeta("svsid", String.valueOf(this.dbMap.size() - 1));
                }
            }
            this.dbMap.put(Long.parseLong(this.Users.get(uTemp.toLowerCase().trim()).getMeta("svsid")), uTemp.toLowerCase().trim());
        }
        Logging.info("SRVAUTH", "Loaded " + this.Users.size() + " registered users from database.");
    }

    @Override
    public int getcount() {
        return this.Users.size();
    }

    @Override
    public void hookDispatch(Hooks.Events what, String source, String target, String args) {
        super.hookDispatch(this, what, source, target, args);
        switch (what) {
            default: 
        }
    }
}

