/*
 * Decompiled with CFR 0.152.
 */
package ecks.services;

import ecks.Configuration;
import ecks.Hooks.Hooks;
import ecks.Logging;
import ecks.Threads.SrvChannel_ExpiryThread;
import ecks.protocols.Generic;
import ecks.services.SrvAuth;
import ecks.services.SrvChannel_channel;
import ecks.services.bService;
import ecks.util;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrvChannel
extends bService {
    public String name = "SrvChan";
    public Map<String, SrvChannel_channel> Channels = new HashMap<String, SrvChannel_channel>();

    @Override
    public void introduce() {
        Configuration.chanservice = this.name.toLowerCase();
        Generic.srvIntroduce(this);
        Hooks.regHook(this, Hooks.Events.E_PRIVMSG);
        Hooks.regHook(this, Hooks.Events.E_JOINCHAN);
        Hooks.regHook(this, Hooks.Events.E_KICK);
        Hooks.regHook(this, Hooks.Events.E_MODE);
        Hooks.regHook(this, Hooks.Events.E_TOPIC);
        util.startThread(new Thread(new SrvChannel_ExpiryThread())).start();
        Logging.info("SRVCHAN", "Expiry thread started...");
        if (!Configuration.Config.get("debugchan").equals("OFF")) {
            Generic.curProtocol.srvJoin(this, Configuration.Config.get("debugchan"), "+stn");
            Generic.curProtocol.outSETMODE(this, Configuration.Config.get("debugchan"), "+o", this.name);
        }
        if (Configuration.Config.get("joinchannels").equals("YES")) {
            for (String chan : this.Channels.keySet()) {
                Generic.curProtocol.srvJoin(this, chan, "+srtn");
                Generic.curProtocol.outSETMODE(this, chan, "+ntro", this.name);
                if (!this.Channels.get(chan).getAllMeta().containsKey("enftopic")) continue;
                Generic.curProtocol.outTOPIC(this, chan, this.Channels.get(chan).getMeta("enftopic"));
            }
        }
    }

    @Override
    public String getname() {
        return this.name;
    }

    @Override
    public void setname(String nname) {
        this.name = nname;
    }

    public Map<String, SrvChannel_channel> getChannels() {
        return this.Channels;
    }

    @Override
    public String getSRVDB() {
        String tOut = "";
        tOut = tOut + "<service class=\"" + this.getClass().getName() + "\" name=\"" + this.name + "\">\r\n";
        for (Map.Entry<String, SrvChannel_channel> usar : this.Channels.entrySet()) {
            tOut = tOut + "\t" + "<channel>\r\n";
            tOut = tOut + "\t\t" + "<name value=\"" + util.encodeUTF(usar.getValue().channel) + "\"/>\r\n";
            tOut = tOut + "\t\t" + "<users>\r\n";
            for (Map.Entry<String, SrvChannel_channel.ChanAccess> entry : usar.getValue().getUsers().entrySet()) {
                tOut = tOut + "\t\t\t" + "<" + util.encodeUTF(entry.getKey()) + " value=\"" + (Object)((Object)entry.getValue()) + "\"/>\r\n";
            }
            tOut = tOut + "\t\t" + "</users>\r\n";
            tOut = tOut + "\t\t" + "<metadata>\r\n";
            for (Map.Entry<String, Object> entry : usar.getValue().getAllMeta().entrySet()) {
                tOut = tOut + "\t\t\t" + "<" + util.encodeUTF(entry.getKey()) + " value=\"" + util.encodeUTF((String)entry.getValue()) + "\"/>\r\n";
            }
            tOut = tOut + "\t\t" + "</metadata>\r\n";
            tOut = tOut + "\t" + "</channel>\r\n";
        }
        tOut = tOut + "</service>\r\n";
        return tOut;
    }

    @Override
    public void loadSRVDB(NodeList XMLin) {
        for (int i = 0; i < XMLin.getLength(); ++i) {
            int j;
            HashMap<String, String> sTemp = new HashMap<String, String>();
            HashMap<String, String> mTemp = new HashMap<String, String>();
            HashMap<String, SrvChannel_channel.ChanAccess> uTemp = new HashMap<String, SrvChannel_channel.ChanAccess>();
            if (XMLin.item(i).getNodeType() != 1) continue;
            NodeList t = ((Element)XMLin.item(i)).getElementsByTagName("name");
            String nTemp = util.decodeUTF(t.item(0).getAttributes().getNamedItem("value").getNodeValue());
            t = ((Element)XMLin.item(i)).getElementsByTagName("users").item(0).getChildNodes();
            for (j = 0; j < t.getLength(); ++j) {
                if (t.item(j).getNodeType() != 1) continue;
                String handle = util.decodeUTF(t.item(j).getNodeName());
                String access = t.item(j).getAttributes().getNamedItem("value").getNodeValue();
                if (((SrvAuth)Configuration.getSvc().get(Configuration.authservice)).getUsers().containsKey(handle.toLowerCase())) {
                    ((SrvAuth)Configuration.getSvc().get((Object)Configuration.authservice)).getUsers().get((Object)handle.toLowerCase()).WhereAccess.put(nTemp, access);
                }
                uTemp.put(handle, SrvChannel_channel.ChanAccess.valueOf(access));
            }
            t = ((Element)XMLin.item(i)).getElementsByTagName("metadata").item(0).getChildNodes();
            for (j = 0; j < t.getLength(); ++j) {
                if (t.item(j).getNodeType() != 1) continue;
                mTemp.put(util.decodeUTF(t.item(j).getNodeName()), util.decodeUTF(t.item(j).getAttributes().getNamedItem("value").getNodeValue()));
            }
            this.Channels.put(nTemp.toLowerCase().trim(), new SrvChannel_channel(nTemp, uTemp, sTemp, mTemp));
        }
        Logging.info("SRVCHAN", "Loaded " + this.Channels.size() + " registered channels from database.");
    }

    @Override
    public int getcount() {
        return this.Channels.size();
    }

    @Override
    public void hookDispatch(Hooks.Events what, String source, String target, String args) {
        if (what.equals((Object)Hooks.Events.E_PRIVMSG)) {
            if (args.length() > 0) {
                if (args.substring(0, 1).equals("!")) {
                    super.hookDispatch(this, what, source, target, this.getname() + ": " + args.substring(1));
                } else {
                    super.hookDispatch(this, what, source, target, args);
                }
            }
        } else {
            super.hookDispatch(this, what, source, target, args);
        }
        switch (what) {
            case E_JOINCHAN: {
                this.handle(target, source, "sync silent");
                break;
            }
            case E_MODE: {
                if (!this.Channels.containsKey(target) || !this.Channels.get(target).getAllMeta().containsKey("enfmodes")) break;
                Generic.curProtocol.outSETMODE(this, target, this.Channels.get(target).getMeta("enfmodes"), this.getname());
                break;
            }
            case E_TOPIC: {
                if (!this.Channels.containsKey(source) || !this.Channels.get(source).getAllMeta().containsKey("enftopic") || Generic.Channels.get((Object)source).topic.equals(this.Channels.get(source).getMeta("enftopic"))) break;
                Generic.curProtocol.outTOPIC(this, source, this.Channels.get(source).getMeta("enftopic"));
                break;
            }
        }
    }
}

