#include "aClient.h"
#include "options.h"
#include "extern.h"
#include <stdlib.h>
#include <stdio.h>

aClient::aClient(char *n)
{
    #ifdef DEBUGMODE
	log("aClient created: %s", (n[0] == '\0' ? "NULL" : n));
    #endif
    strcpy(nick, n);

    #ifdef P10
	strcpy(realnick, n);
    #endif

    stats = NULL;
    flags = 0;
}
#ifdef P10
aClient::aClient(char *n, char *rn)
{
    #ifdef DEBUGMODE
	log("aClient created: %s", (n[0] == '\0' ? "NULL" : n));
    #endif
    strcpy(nick, n);
    strcpy(realnick, rn);
    stats = NULL;
    flags = 0;
}
#endif

aClient::aClient(const aClient &right)
{
    #ifdef DEBUGMODE
	log("aClient created from another aClient: %s\n", right.nick);
    #endif

    stats = NULL;
    flags = 0;
    setData(&right);
}

aClient::aClient()
{
    aClient("");
}

aClient::~aClient()
{
    if (stats)
    {
	#ifdef DEBUGMODE
	    log("aClient deleted: %s %s %s", nick, stats->name, stats->password); 
	#endif

	delete stats;
    }
  #ifdef DEBUGMODE
    else
    {
	log("aClient deleted: %s", nick);
    }
  #endif

    flags = 0;
}

ostream &operator<<( ostream &out, const aClient &c )
{
    out << (c.nick[0] == '\0' ? "NULL" : c.nick);
    return out;
}

void aClient::setData(const aClient *right)
{
    if (right != this)
    {
	strcpy(nick, right->nick);
	#ifdef P10
	    strcpy(realnick, right->realnick);
	#endif
	if (right->stats)
	{
	    if (!stats)
		stats = new Player;
	    #ifdef DEBUGMODE
		log("Should be setting data for %s", right->stats->name);
	    #endif

	    stats->setData(right->stats);
	}
    }
}

long int aClient::setFlags(long int newflags)
{
    flags = newflags;
    return getFlags();
}

long int aClient::addFlag(long int flag)
{
    flags |= flag;
    return getFlags();
}

long int aClient::remFlag(long int flag)
{
    flags &= ~flag;
    return getFlags();
}
