#ifndef ACLIENT_H
#define ACLIENT_H

#include <string.h>
#include "options.h"
#include "player.h"
#include <iostream>
using std::ostream;

class Player; // forward declaration

class aClient {

	friend ostream &operator<<( ostream &output, const aClient &c);

    public:
        aClient(char *);		// Constructor takes a char for the nick

	#ifdef P10
	    aClient(char *, char *);	// Constructor takes a char for the nick and realnick
	#endif

	aClient(const aClient &);	// Copy constructor
        aClient();			// Default constructor
        ~aClient();			// Destructor

	// Sets the client's player struct data to the same thing as another aClient's 
	// player struct data
	void setData(const aClient *);

        void setNick(char *n) { strcpy(nick, n);};	// Sets the client's nick
        char *getNick() { return nick; };		// Returns the client's nick

	#ifdef P10
	    void setRealNick(char *rn) { strcpy(realnick, rn);}; // Sets the client's realnick
	    char *getRealNick() { return realnick; };	// Returns the client's real nick
	#endif

	Player *stats;					// Pointer to the client's player struct

	long int getFlags() { return flags; };		// Returns the Client's current flags

	// Functions also return the flags after modifying them
	long int setFlags(long int);    // Sets the clients flags to a new value
	long int addFlag(long int);	// Adds a flag to the client's flags
	long int remFlag(long int);	// Removes a flag from the client's current flags

    private:
	#ifdef P10
	    char realnick[32];	// Client's text nickname. Not the numeric
	#endif
        char nick[32];		// Client's current nickname. Numeric if P10 is used
	long int flags;		// Client's current flags.
};

#endif
