#include "sockhelp.h"
#include "aClient.h"
#include "list.h"
#include "extern.h"
#include "flags.h"
#include <cctype>

void do_forest(char *u);
Monster *getNewMonster(Monster *m);
void deleteMonster(Monster *m);

void forest(char *source, char *buf)
{
	char *cmd = strtok(buf, " ");

	if (cmd[0] == ':')
	    cmd++;
	if (source[0] == ':')
	    source++;

	if (stricmp(cmd, "SEARCH") == 0)
	{
	    do_forest(source);
	} else if (stricmp(cmd, "ATTACK") == 0) {
	    do_attack(source);
        } else if (stricmp(cmd, "RUN") == 0) {
	    do_run(source);
	} else if (stricmp(cmd, "HEAL") == 0) {
	    do_heal(source);
	}

source--;
}

void do_forest(char *u)
{
    aClient *source;

    int num = rand() % 12;


    if (!(source = find(u)))
    {
	notice(s_GameServ, u, "Fatal Error in do_forest. Contact a %S admin for help.");
	return;
    }
    else if (!is_playing(source))
    {
        notice(s_GameServ, u, "You must be playing the game to search the forest!");
	return;
    }
    Player *p = source->stats;

    if (!isAlive(p))
    {
	notice(s_GameServ, u, "You are dead. Wait until tomorrow to search the forest some more.");
	return;
    }
    else 
    {
        if (p->forest_fights <= 0)
        {
            notice(s_GameServ, u, "You are out of forest fights for the day. Wait "\
                "till tomorrow!");
            return;
        }
        else if (!is_fighting(u))
        {
	    int eventnum = rand() % 100;
	    p->forest_fights--;

	    notice(s_GameServ, u, "You search the forest for something to kill...");

	    // 88% of forest searching turns up a monster
	    if (eventnum >= 12)
	    {
            	p->fight = new Monster(monsters[p->level - 1][num]);
            	notice(s_GameServ, u, "You have found %s!", p->fight->name);
	        if (p->fight->hp < p->fight->maxhp)
		    p->fight->hp = p->fight->maxhp;

            	p->battle = NULL; // Just to make sure
	    	p->master = NULL; // Just to make sure
            	display_monster(u);
	    }
	    else if (eventnum < 12 && eventnum >= 5) // 7% for the fountain
	    {
		notice(s_GameServ, u, "In your path lies a beautiful fountain from which flows the crystal waters of life.");
		notice(s_GameServ, u, "You wet your lips on the cool blue waters and feel rejuvenated");
		p->hp = p->maxhp;
	    }
	    else if (eventnum < 5) // 5 % for the wishing well
	    {
		notice(s_GameServ, u, "You come upon a pure green emerald studded magic wishing well.");
		if (p->gold == 0)
		{
		    notice(s_GameServ, u, "Too bad you're broke. Guess you won't be having any wishes answered today.");
		    return;
		}
		notice(s_GameServ, u, "You throw one of your gold pieces into the well and it vanishes into a puff of white smoke.");
		notice(s_GameServ, u, "In an instant, the puff of smoke materializes into a gnome.");
		notice(s_GameServ, u, "The gnome is holding something in his hand motioning for you to come closer.");
		notice(s_GameServ, u, "It is a wand! The gnome is waving it through the air towards you!");
		// 2% for each wishing well chance except for forest fights
		if (eventnum < 1) // forest fights
		{
		    notice(s_GameServ, u, "EXTRA FOREST FIGHTS!!");
		    p->forest_fights += (rand() % 11) + 5;
		}
		else if (eventnum < 3)
		{
		    notice(s_GameServ, u, "A SACK OF GOLD!");
		    p->gold += (rand() % 1000) * (p->level + (rand() % 10));
		}
		else
		{
		    notice(s_GameServ, u, "Time seems to stand still for a moment.");
		    notice(s_GameServ, u, "EXTRA EXPERIENCE POINTS");
		    p->exp += (rand() % 100) * (p->level + rand() % 10);
		}
	    }
        }
        else if (is_fighting(u))
        {
            notice(s_GameServ, u, "You want to fight two monsters at once?");
        }
    }

}

Monster *getNewMonster(Monster *m)
{
    if (!m)
	return NULL;

    Monster *newguy;
    newguy = new Monster;

    if (m->name)
    {
	newguy->name = new char[strlen(m->name)];
	strcpy(newguy->name, m->name);
    }
    if (m->weapon)
    {
	newguy->weapon = new char[strlen(m->weapon)];
	strcpy(newguy->weapon, m->weapon);
    }
    if (m->death)
    {
	newguy->death = new char[strlen(m->death)];
	strcpy(newguy->death, m->death);
    }

    newguy->strength = m->strength;
    newguy->gold = m->gold;
    newguy->exp = m->exp;
    newguy->hp = m->hp;
    newguy->maxhp = m->maxhp;
    return newguy;
}
