#include "sockhelp.h"
#include "aClient.h"
#include "list.h"
#include "extern.h"
#include <cctype>

void do_store(char *u);

void store(char *source, char *buf)
{
	char *cmd = strtok(buf, " ");

	if (cmd[0] == ':')
	    cmd++;
	if (source[0] == ':')
	    source++;

	if (stricmp(cmd, "LIST") == 0)
	{
	    do_store(source);
	}

source--;
}

void do_store(char *u)
{
    aClient *source;
    char *cmd;

    int num = rand() % 12;

    source = find(u);

    if (!is_playing(u))
    {
        notice(s_GameServ, u, "You must be playing the game to search the forest!");
    }
    else 
    {
        if (source->stats->forest_fights <= 0)
        {
            notice(s_GameServ, u, "You are out of forest fights for the day. Wait "\
                "till tomorrow!");
            return;
        }
        else if (isnt_fighting(u))
        {
            Player *ni = source->stats;
            ni->forest_fights--;
            ni->fight = &monsters[ni->level - 1][num];
            notice(s_GameServ, u, "You search the forest for something to kill...");
            notice(s_GameServ, u, "You have found %s!", ni->fight->name);
            ni->fight->hp = ni->fight->maxhp;
            ni->battle = NULL;
            display_monster(u);
        }
        else if (is_fighting(u))
        {
            notice(s_GameServ, u, "You want to fight two monsters at once?");
        }
    }

}

