#include <fstream>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "extern.h"

using std::ifstream;
using std::cerr;
using std::endl;

int load_config_file(char *config);
void unload_config_file();

/* Random Configuration Stuff Goes Here until I code it to load from a .conf file :)*/

char *s_GameServ;		// GameServ's nickname
char *gshost;			// GameServ's Hostname
char *gsident;			// GameServ's ident/username
char *servername;		// GameServ's Server
char *c_Forest;			// Forest channel
char *c_ForestTopic; 		// Forest Channel Topic
char *adminpass;		// Administrator password
char *welcomemsg;		// Welcome Message
int welcomedelay;		// Welcome Message Delay
int updateperiod;		// Seconds until another player database update
int forestfights;		// Forest fights per day

// Remote server stuff. This is used for the outgoing connection gameserv needs to make
// to a real ircd.
char *remoteserver;		// Server to connect to
char *remoteport;		// Port to connect to on remoteserver
char *remotepass;		// Password for the server link

char *playerdata; 		// File to store player data in
char *monsterdata;		// File to load monster data from

#if defined(P10)
	char *gsnum = "[]AAA";		// GameServ Numeric
#endif

void unload_config_file()
{
    if (s_GameServ)
    	delete [] s_GameServ;
    if (gshost)
	delete [] gshost;
    if (gsident)
	delete [] gsident;
    if (servername)
	delete [] servername;
    if (c_Forest)
	delete [] c_Forest;
    if (c_ForestTopic)
	delete [] c_ForestTopic;
    if (remoteserver)
	delete [] remoteserver;
    if (remoteport)
	delete [] remoteport;
    if (remotepass)
	delete [] remotepass;
    if (playerdata)
	delete [] playerdata;
    if (monsterdata)
	delete [] monsterdata;
    if (adminpass)
	delete [] adminpass;
    if (welcomemsg)
	delete [] welcomemsg;
}

int load_config_file(char *config)
{
    char *buf, *directive, *value;
    #define numdirectives 15

    unload_config_file();

    struct DIRECTIVE {
	bool done;
	char *desc;
    };

    DIRECTIVE directives[numdirectives];

     directives[0].desc = "s_GameServ - GameServ Nickname";
     directives[1].desc = "GSHOST - GameServ Hostname";
     directives[2].desc = "GSIDENT - GameServ Ident";
     directives[3].desc = "SERVERNAME - Pseudo Server's Name";
     directives[4].desc = "C_FOREST - Forest Channel";
     directives[5].desc = "C_FORESTTOPIC - Topic for the Forest Channel";
     directives[6].desc = "REMOTESERVER - Server for gameserv to connect to (ip or hostname)";
     directives[7].desc = "REMOTEPORT - Port on the remote server to connect to";
     directives[8].desc = "REMOTEPASS - Password on the remote server";
     directives[9].desc = "PLAYERDATA - File to store the player saves in";
    directives[10].desc = "MONSTERDATA - File to load the monsters from";
    directives[11].desc = "ADMINPASS - Password to identify as an admin with";
    directives[12].desc = "WELCOMEDELAY - Delay (in seconds) to wait before welcoming new users to the network";
    directives[13].desc = "FORESTFIGHTS - Number of forest fights players get every day";
    directives[14].desc = "UPDATEPERIOD - Number of seconds between every player data save";
    directives[15].desc = "WELCOMEMSG - Message to send to new users on the network";

    for (int count = 0; count < numdirectives; count++)
    {
	directives[count].done = false;
    }

    ifstream infile;
    infile.open(config);
    if (infile.fail())
    {
	log("Error opening %s", config);
	cerr << "Error opening " << config << endl;
	return 0;
    }

    buf = new char[1024];

    while (infile.getline(buf, 1024, '\n'))
    {
	#ifdef DEBUGMODE
	    log("Config file entry buf: %s", buf);
	#endif

	if (buf[0] == '#' || buf[0] == ' ' || buf[0] == '\0' || buf[0] == '\n' || buf[0] == '\r')
	    continue;
	
	directive = strtok(buf, " ");

        if (stricmp(directive, "DIE") == 0)
	{
	    value = strtok(NULL, "");
	    log("You should read the entire %s file!", config);
	    cerr << "You should read the entire " << config << " file!" 
		 << endl;
	    delete []buf;
	    exit(0);
	}
	if (stricmp(directive, "S_GAMESERV") == 0)
	{
	    value = strtok(NULL, " ");
	    s_GameServ = new char[strlen(value) + 1];
	    strcpy(s_GameServ, value);
	    directives[0].done = true;
	}
	else if (stricmp(directive, "GSHOST") == 0)
	{
	    value = strtok(NULL, " ");
	    gshost = new char[strlen(value) + 1];
	    strcpy(gshost, value);
	    directives[1].done = true;
	}
	else if (stricmp(directive, "GSIDENT") == 0)
	{
	    value = strtok(NULL, " ");
	    gsident = new char[strlen(value) + 1];
	    strcpy(gsident, value);
	    directives[2].done = true;
	}
	else if (stricmp(directive, "SERVERNAME") == 0)
	{
	    value = strtok(NULL, " ");
	    servername = new char[strlen(value) + 1];
	    strcpy(servername, value);
	    directives[3].done = true;
	}
	else if (stricmp(directive, "C_FOREST") == 0)
	{
	    value = strtok(NULL, " ");
	    c_Forest = new char[strlen(value) + 1];
	    strcpy(c_Forest, value);
	    directives[4].done = true;
	}
	else if (stricmp(directive, "C_FORESTTOPIC") == 0)
	{
	    value = strtok(NULL, "");
	    c_ForestTopic = new char[strlen(value) + 1];
	    strcpy(c_ForestTopic, value);
	    directives[5].done = true;
	}
	else if (stricmp(directive, "REMOTESERVER") == 0)
	{
	    value = strtok(NULL, " ");
	    remoteserver = new char[strlen(value) + 1];
	    strcpy(remoteserver, value);
	    directives[6].done = true;
	}
	else if (stricmp(directive, "REMOTEPORT") == 0)
	{
	    value = strtok(NULL, " ");
	    remoteport = new char[strlen(value) + 1];
	    strcpy(remoteport, value);
	    directives[7].done = true;
	}
	else if (stricmp(directive, "REMOTEPASS") == 0)
	{
	    value = strtok(NULL, "");
	    remotepass = new char[strlen(value) + 1];
	    strcpy(remotepass, value);
	    directives[8].done = true;
	}
	else if (stricmp(directive, "PLAYERDATA") == 0)
	{
	    value = strtok(NULL, "");
	    playerdata = new char[strlen(value) + 1];
	    strcpy(playerdata, value);
	    directives[9].done = true;
	}
	else if (stricmp(directive, "MONSTERDATA") == 0)
	{
	    value = strtok(NULL, "");
	    monsterdata = new char[strlen(value) + 1];
	    strcpy(monsterdata, value);
	    directives[10].done = true;
	}
	else if (stricmp(directive, "ADMINPASS") == 0)
	{
	    value = strtok(NULL, "");
	    adminpass = new char[strlen(value) + 1];
	    strcpy(adminpass, value);
	    directives[11].done = true;
	}
	else if (stricmp(directive, "WELCOMEDELAY") == 0)
	{
	    value = strtok(NULL, " ");
	    welcomedelay = stringtoint(value);
	    directives[12].done = true;
	}
	else if (stricmp(directive, "FORESTFIGHTS") == 0)
	{
	    value = strtok(NULL, " ");
	    forestfights = stringtoint(value);
	    directives[13].done = true;
	}
	else if (stricmp(directive, "UPDATEPERIOD") == 0)
	{
	    value = strtok(NULL, " ");
	    updateperiod = stringtoint(value);
	    directives[14].done = true;
	}
	else if (stricmp(directive, "WELCOMEMSG") == 0)
	{
	    value = strtok(NULL, "");
	    welcomemsg = new char[strlen(value) + 1];
	    strcpy(welcomemsg, value);
	    directives[15].done = true;
	}
	else
	{
	    #ifdef DEBUGMODE
		log("Unknown Directive. Buffer: %s", buf);
		cerr << "Unknown " << config << " directive. Buffer: " 
		     << buf << endl;
	    #endif
	    continue;
	}
    }
delete [] buf;
infile.close();

    int nonemissing = 1;
    for (int count2 = 0; count2 < numdirectives; count2++)
    {
	if (!directives[count2].done)
	{
	    cerr << "Missing config directive: " << directives[count2].desc << endl;
	    nonemissing = 0;
	}
    }

    return nonemissing;
}
