#ifndef EXTERN_H
#define EXTERN_H

#define E extern

#define LEVELS 12	// Levels in the game
#define REALLEVELS 8    // Levels to load from monsters.dat
#define MONSTERS 12	// Monsters per level

#include <stdarg.h>
#include "player.h"
#include "list.h"
#include "config.h"
#include "options.h"

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif


E int day;
E void save_day();
E void load_day();

// The socket
E int sock;


// Random configuration stuff
E int load_config_file(char *config = "gameserv.conf");
E void unload_config_file();
E char *s_GameServ;
E char *c_Forest;
E char *c_ForestTopic;
E char *gshost;
E char *gsident;

#if defined(P10)
E char *gsnum;
#endif

E char *servername;
E char *remoteserver;
E char *remoteport;
E char *remotepass;
E char *playerdata;
E char *logfile;
E char *monsterdata;
E char *adminpass;
E char *VERSION;
E char *PACKAGE;
E char *welcomemsg;

E int welcomedelay;
E int updateperiod;
E int forestfights;

E List<aClient> clients;
E List<aClient> players;

/** List search functions **/
E aClient *find(char *nick);
E aClient *find(const char *nick);
E aClient *findbynick(char *nick);
E aClient *findbynick(const char *nick);
E aClient *findbyrealnick(char *realnick);
E aClient *findplayer(const char *name);
E aClient *findIRCplayer(const char *nick);
#ifdef P10
E aClient *findbyrealnick(char *realnick);
#endif

/** Sock writing functions **/
E void notice(const char *source, const char *dest, const char *fmt, ...);
E void raw(const char *fmt, ...);

/** gameserv.cpp **/
E void gameserv(char *source, char *buf);
E Monster *monsters[LEVELS][MONSTERS];

/** forest.cpp **/
E void forest(char *source, char *buf);

/** functions.cpp **/

E bool is_playing(char *u);
E bool is_playing(aClient *user);

E bool is_fighting(char *u);
E bool is_fighting(aClient *user);

E bool player_fight(char *u);
E bool player_fight(aClient *user);

E bool master_fight(char *u);
E bool master_fight(aClient *user);

#ifndef HAVE_STRTOK
E char *strtok(char *str, const char *delim);
#endif

E char *spaces(int len, char *seperator);
E void display_monster(char *u);
E void display_players(char *u);
E int stricmp(const char *s1, const char *s2);
E int strnicmp(const char *s1, const char *s2, size_t len);
E long int chartoint(char ch);
E int isstringnum(char *num);
E long int pow (int x, int y);
E long int stringtoint(char *number);
E void init_masters();
E void init_monsters();
E bool load_monsters();
E void delete_monsters();
E void delete_masters();
E Monster *getNewMonster(Monster *m);
E void deleteMonster(Monster *m);
E void refresh(Player *p);
E void refreshall();
E void reset(Player *p);
E void resetall();

E void do_attack(char *u);
E void do_bank(char *u);
E void do_fight(char *u);
E void do_forest(char *u);
E void do_heal(char *u);
E void do_identify(char *u);
E void do_invenory(char *u);
E void do_list(char *u);
E void do_play(char *u);
E void do_quitg(char *u);
E void do_refresh(char *u);
E void do_register(char *u);
E void do_reset(char *u);
E void do_run(char *u);
E void do_stats(char *u);
E void do_store(char *u);
E void do_tavern(char *u);
E void do_use(char *u);
E void see_mystic(char *u);

E void showstats(const char *u, const char *nick);
E void showinventory(aClient *from, aClient *to = NULL);
/* Database saving stuff */

E int save_gs_dbase();
E int load_gs_dbase();

// Log File Stuff
E void log(const char *fmt, ...);

#endif
