#ifndef FLAGS_H
#define FLAGS_H

/* This file contains all the flags used in the aClient and Player classes.
 * More flags can be added simply by going up in multiples of 2.
 * ie. 0001 0002 0004 0008 0010 0020 0040 0080 0100 0200 0400 0800 1000 2000 4000
 *     8000 10000 20000 40000 80000 100000 200000 400000 800000 1000000 2000000 4000000
 *     8000000 10000000 20000000 40000000 80000000 (32 bit)
 * This method was taken from my experience in working with various
 * IRCD packages. Most of them use this for their modes along with
 * corresponding letter representations.
 * Theoretically, each flag is 32 bit (long int), and each place in a flag
 * is one hexadecimal digit (four bits). So, technically each flag variable
 * can hold 8 spaces for flags. 8 spaces at 4 flags per space makes for
 * 32 possible flags for each long int. That means there are 32 flags available
 * for the aClient class, and 32 for the player class.
 *
 * Basically if you are having problems visualizing how flags work, think of them in
 * binary terms:
 *	Hex	Binary
 *	0x0001 	0001
 * 	0x0002 	0010
 *	0x0004 	0100
 *	0x0008 	1000
 *     Basically, each flag represents a 1. When you add the different flags, you are just
 *	adding a 1 in the given position. So 1001 would be 0x0009 or flags 0001 and 0008.
 */

// aClient FLAGS ONLY
#define FLAG_ADMIN 0x0001

// PLAYER FLAGS ONLY
#define FLAG_MASTER		0x0001
#define FLAG_ALIVE		0x0002
#define FLAG_YOURTURN		0x0004



// aClient flags
// #define ADMIN_FLAGS(FLAG_ONE | FLAG_TWO | FLAG_ETC)
#define ADMIN_FLAGS (FLAG_ADMIN)

#define setAdmin(x)	((x)->addFlag(FLAG_ADMIN))
#define clearAdmin(x)	((x)->remFlag(FLAG_ADMIN))
#define isAdmin(x)	((x)->getFlags() & FLAG_ADMIN)

#define clearAdminFlags(x)	((x)->remFlag(ADMIN_FLAGS))


// Player Flags
#define seenMaster(x)		((x)->getFlags() & FLAG_MASTER)
#define setMaster(x)		((x)->addFlag(FLAG_MASTER))
#define clearMaster(x)		((x)->remFlag(FLAG_MASTER))

#define isAlive(x)		((x)->getFlags() & FLAG_ALIVE)
#define setAlive(x)		((x)->addFlag(FLAG_ALIVE))
#define clearAlive(x)		((x)->remFlag(FLAG_ALIVE))

#define isYourTurn(x)		((x)->getFlags() & FLAG_YOURTURN)
#define setYourTurn(x)  	((x)->addFlag(FLAG_YOURTURN))
#define clearYourTurn(x)	((x)->remFlag(FLAG_YOURTURN))

#endif
