#include "aClient.h"
#include "config.h"
#include "extern.h"
#include "flags.h"
#include "list.h"
#include "sockhelp.h"

#include <cctype>
#include <fstream>

using std::ifstream;
using std::ofstream;

#if defined(HAVE_CRYPT_H)

#include <crypt.h>

#elif defined(HAVE_UNISTD_H)

#include <unistd.h> 

#endif

List<aClient> players;

Monster *monsters[LEVELS][MONSTERS];  	// Monsters per level. Total = MONSTERS * LEVELS

Monster *masters[LEVELS]; 		// A master for each level

// Database functions
int save_gs_dbase();
int load_gs_dbase();

// String functions
#ifndef HAVE_STRTOK
char *strtok(char *str, const char *delim);
#endif

int stricmp(const char *s1, const char *s2);
int strnicmp(const char *s1, const char *s2, size_t len);
// String Functions


/********** Password functions **********/

bool passcmp(char *encrypted, char *plaintext); // Compares an encrypted pass with a plain text one

bool check_password(char *name, char *plaintext); // Finds a password for the given name, and checks it with passcmp against the plaintext password given.
 
/********** Password functions **********/


/********** GameServ Booleans **********/

bool is_playing(char *u); // True if the given nickname in the clients list is playing.
bool is_playing(aClient *user);

bool is_fighting(char *u); // True if the given nick in the clients list is fighting anything.
bool is_fighting(aClient *user);

bool player_fight(char *u); // True if the player is fighting another player.
bool player_fight(aClient *user);

bool master_fight(char *u); // True if the player is fighting their master.
bool master_fight(aClient *user);

/********** GameServ Booleans **********/

void display_help(char *u, char *file = NULL);
void display_monster(char *u);
void display_players(char *u);
void display_players(aClient *user);
long int chartoint(char ch);
int isstringnum(char *num);
long int pow (int x, int y);
long int stringtoint(char *number);

char *spaces(int len, char *seperator);
void refresh(Player *p);
void refreshall();
void reset(Player *p);
void init_masters();
void init_monsters();
bool load_monsters();
void delete_monsters();
void delete_masters();

void do_admin(char *u);
void do_attack(char *u);
void do_bank(char *u);
void do_fight(char *u);
void do_heal(char *u);
void do_help(char *u);
void do_identify(char *u);
void do_inventory(char *u);
void do_refresh(char *u);
void do_register(char *u);
void do_list(char *u);
void do_master(char *u);
void do_play(char *u);
void do_quitg(char *u);
void do_reset(char *u);
void do_run(char *u);
void do_stats(char *u);
void do_store(char *u);
void do_tavern(char *u);
void do_use(char *u);
void see_master(char *u);

void showstats(const char *u, const char *nick);
void showinventory(aClient *from, aClient *to);
void showBankBalance(const char *u);
void end_turn(aClient *user);

#define WNA 16
char *weapons[WNA] = {  "Fists", "Stick", "Dagger", "Quarterstaff",  "Short Sword", 
			"Long Sword", "Silver Spear", "Battle Axe", "The Ragnarok", 
			"Chain Saw", "Poison Sword",  "Flame Sword", "Earth Hammer", 
			"Light Saber", "Masamune", "Mystical Sword"};

char *armors[WNA] = { "Nothing", "Clothes", "Leather Vest", "Chain Mail", "Plate Armor", 
		      "Full Body Armor", "Magic Mail", "Graphite Suit", "Steel Suit", 
		      "Force Field", "Armor of Light", "Mythril Vest", "DemiGod Armor", 
		      "Hades' Cloak", "Dragon Scales", "Adamantium"};

int prices[WNA - 1] = {200, 1000, 3000, 10000, 30000, 100000, 150000, 200000, 400000, 
			1000000, 4000000, 10000000, 40000000, 100000000, 400000000};
int webonus[WNA] = {0, 10, 15, 25, 35, 45, 65, 85, 125, 185, 255, 355, 505, 805, 1205, 1805};
int arbonus[WNA] = {0, 1, 3, 10, 15, 25, 35, 50, 75, 100, 150, 225, 300, 400, 600, 1000};

int hpbonus[11] = {10, 15, 20, 30, 50, 75, 125, 185, 250, 350, 550};
int strbonus[11] = {5, 7, 10, 12, 20, 35, 50, 75, 110, 150, 200};
int defbonus[11] = {2, 3, 5, 10, 15, 22, 35, 60, 80, 120, 150};

void gameserv(char *source, char *buf)
{
    char *cmd;
    cmd = strtok(buf, " ");

    #ifndef P10
        source++; // Get rid of that : at the beginning of a :Nick privmsg Gameserv :text
    #endif

    if (cmd[0] == ':')
        cmd++;    // Get rid of that : at the beginning of the :text  (command)

    #ifdef DEBUGMODE
	log("Source: %s  Command: %s", source, cmd);
    #endif

    struct tm *tm;
    time_t ti;
    time(&ti);
    tm = localtime(&ti);

    int curday = tm->tm_mday;

    if (curday != day)
    {
        refreshall();
        day = curday;
	save_day();
    }

    if (strnicmp(cmd, "\1PING", 6) == 0)
    {
	char *ts;
	ts = strtok(NULL, "\1");
        notice(s_GameServ, source, "\1PING %s\1", ts);
    } else if (stricmp(cmd, "\1VERSION\1") == 0) {
	notice(s_GameServ, source, "\1VERSION %s %s +devel\1", PACKAGE, VERSION);
    } else if (stricmp(cmd, "SEARCH") == 0) {
	cmd = strtok(NULL, " ");

	if (!cmd)
	    notice(s_GameServ, source, "SYNTAX: /msg %S SEARCH FOREST");
	else
	    do_forest(source);

    } else if (stricmp(cmd, "FIGHT") == 0) {
	do_fight(source);
    } else if (stricmp(cmd, "ATTACK") == 0) {
	do_attack(source);
    } else if (stricmp(cmd, "RUN") == 0) {
	do_run(source);
    } else if (stricmp(cmd, "USE") == 0) {
	do_use(source);
    } else if (stricmp(cmd, "HEAL") == 0) {
	do_heal(source);
    } else if (stricmp(cmd, "INVENTORY") == 0) {
	do_inventory(source);
    } else if (stricmp(cmd, "MASTER") == 0) {
	do_master(source);
    } else if (stricmp(cmd, "STORE") == 0) {
	do_store(source);
    } else if (stricmp(cmd, "BANK") == 0) {
	do_bank(source);
    } else if (stricmp(cmd, "ADMIN") == 0) {
	do_admin(source);
    } else if (stricmp(cmd, "REFRESH") == 0) {
	do_refresh(source);
    } else if (stricmp(cmd, "RESET") == 0) {
	do_reset(source);
    } else if (stricmp(cmd, "TAVERN") == 0) {
	do_tavern(source);
    } else if (stricmp(cmd, "LIST") == 0) {
	do_list(source);
    #ifdef DEBUGMODE
    } else if (stricmp(cmd, "PRINT") == 0) {
	cout << "Printing the clients list:" << endl;
	clients.print();
	cout << "\nPrinting the players list:" << endl;
	players.print();
    #endif
    } else if (stricmp(cmd, "REGISTER") == 0) {
	do_register(source);
    } else if (stricmp(cmd, "IDENTIFY") == 0) {
	do_identify(source);
    } else if (stricmp(cmd, "HELP") == 0) {
	do_help(source);
    } else if (stricmp(cmd, "STATS") == 0) {
	do_stats(source);
    } else if (stricmp(cmd, "SHUTDOWN") == 0) {
	aClient *user;

	if (!(user = find(source)))
	{
	    notice(s_GameServ, source, "Error: aClient not found. Contact a %S admin");
		log("Error: aClient not found: %s", source);
	}
	else if (!isAdmin(user))
	{
	    notice(s_GameServ, source, "You must be a %S admin to use this command!");
	}
	else
	{
	    save_gs_dbase();
	    #ifdef P10
		raw("[] SQ %s 0 :leaving: %s used the Shutdown command.", servername, user->getRealNick());
	    #else
		raw("SQUIT %s :leaving: %s used the Shutdown command.", servername, source);
	    #endif
	}
    } else if (stricmp(cmd, "SAVE") == 0) {
	aClient *user;

	if (!(user = find(source)))
	{
	    notice(s_GameServ, source, "Error: aClient not found. Contact a %S admin");
		log("Error: aClient not found: %s", source);
	}
	else if (!isAdmin(user))
	{
	    notice(s_GameServ, source, "You must be a %S admin to use this command!");
	}
	else
        {
	    save_gs_dbase();
        }
    } else if (stricmp(cmd, "LOAD") == 0) {
	aClient *user;

	if (!(user = find(source)))
	{
	    notice(s_GameServ, source, "Error: aClient not found. Contact a %S admin");
	    log("Error: aClient not found: %s", source);
	}
	else if (!isAdmin(user))
	{
	    notice(s_GameServ, source, "You must be a %S admin to use this command!");
	}
	else
        {
	    char *cmd2 = strtok(NULL, " ");
	    if (!cmd2)
	    {
		notice(s_GameServ, source, "Loading player data from %s", playerdata);
		load_gs_dbase();
	    }
	    else if (stricmp(cmd2, "MONSTERS") == 0)
	    {
		notice(s_GameServ, source, "Loading monster data from %s", monsterdata);
		load_monsters();
	    }
	    else
		display_help(source, cmd);
	}
    } else if (stricmp(cmd, "RAW") == 0) {
	aClient *user;

	if (!(user = find(source)))
	{
	    notice(s_GameServ, source, "Error: aClient not found. Contact a %S admin");
		log("Error: aClient not found: %s", source);
	}
	else if (!isAdmin(user))
	{
	    notice(s_GameServ, source, "You must be a %S admin to use this command!");
	}
	else
        {
	    char *rest = strtok(NULL, "");
	    raw("%s", rest);
	}
    } else {
	notice(s_GameServ, source, "Unknown command \002%s\002. Type /msg %S \002HELP\002 to get a list of commands.", cmd);
    } 

   source--;  // Bring the ':' back so we don't leak memory
   cmd--;     // Same thing :)
}

int stricmp(const char *s1, const char *s2)
{
    register int c;

    while ((c = tolower(*s1)) == tolower(*s2)) {
        if (c == 0)
            return 0;
        s1++;
        s2++;
    }
    if (c < tolower(*s2))
        return -1;
    return 1;
}

void showstats(const char *u, const char *nick)
{
    aClient *ni, *sender = find(u);
    char *buf;
    buf = new char[50];
    char *space;


    if (!(ni = findplayer(nick)))
    {
        notice(s_GameServ, u, "%s not found", nick);
    }
    else if (ni->stats)
    {
        notice(s_GameServ, sender->getNick(), "Stats for %s:", ni->stats->name);

        sprintf(buf, "Experience: %ld", ni->stats->exp);
        space = spaces(strlen(buf), " ");
        notice(s_GameServ, sender->getNick(), "%s%sLevel: %d",  buf, space,
                 ni->stats->level);
        delete [] space;

        sprintf(buf, "Gold: %ld", ni->stats->gold);
        space = spaces(strlen(buf), " ");
        notice(s_GameServ, sender->getNick(), "%s%sGold in Bank: %ld", buf, space, ni->stats->bank);
        delete [] space;

        notice(s_GameServ, sender->getNick(), "Hit Points: %d of %d", ni->stats->hp,
                 ni->stats->maxhp);

        sprintf(buf, "Strength: %d", ni->stats->strength + webonus[ni->stats->weapon]);
        space = spaces(strlen(buf), " ");
        notice(s_GameServ, sender->getNick(), "%s%sDefense: %d",
                 buf, space, ni->stats->defense + arbonus[ni->stats->armor]);
        delete [] space;

        sprintf(buf, "Armor: %s", armors[ni->stats->armor]);
        space = spaces(strlen(buf), " ");
        notice(s_GameServ, sender->getNick(), "%s%sWeapon: %s", buf, space,
                 weapons[ni->stats->weapon]);
        delete [] space;

        sprintf(buf, "Forest Fights: %d", ni->stats->forest_fights);
        space = spaces(strlen(buf), " ");
        notice(s_GameServ, sender->getNick(), "%s%sPlayer Fights: %d", buf, space, ni->stats->player_fights);
        delete [] space;
    }
    else
    {
	notice(s_GameServ, u, "%s is not playing!", ni->stats->name);
    }
    delete [] buf;
}

char *spaces(int len, char *seperator)
{
    char *final;
    final = new char[30];
    int y;
    strcpy(final, seperator);
    for (y = 0; y < 30 - len; y++)
        strcat(final, seperator);
    return final;
}

void raw(const char *fmt, ...)
{
    va_list args;
    char *input;
    const char *t = fmt;
    input = new char[1024];
    va_start(args, fmt);
    memset(input, 0, sizeof(input)); // Initialize to NULL
    for (; *t; t++)
    {
	if (*t == '%')
	{
	    switch(*++t) {
		case 'd': sprintf(input, "%s%d", input, va_arg(args, int)); break;
		case 's': sprintf(input, "%s%s", input, va_arg(args, char *)); break;
		case 'S': sprintf(input, "%s%s", input, s_GameServ); break;
		case 'l':
		   if (*++t == 'd')
			  sprintf(input, "%s%ld", input, va_arg(args, long int)); break;
	    }
	}
	else
	{
	    sprintf(input, "%s%c", input, *t);
	}

    }
    #ifdef DEBUGMODE
	log("Input: %s", input);
    #endif

    sprintf(input, "%s%s", input, "\r\n");
    sock_puts(sock, input);
    delete [] input;
    va_end(args);
}
/* Send a NOTICE from the given source to the given nick. */

void notice(const char *source, const char *dest, const char *fmt, ...)
{
    if (fmt[0] == '\0')
	return;

    va_list args;
    char *input;
    const char *t = fmt;
    input = new char[1024];
    va_start(args, fmt);
    if (dest[0] == ':')
    {
    	dest++;

      #if !defined(P10)
	sprintf(input, ":%s NOTICE %s :", source, dest);
      #else
	sprintf(input, "%s O %s :", gsnum, dest);
      #endif

	dest--;
    }
    else
    {
      #if !defined(P10)
	sprintf(input, ":%s NOTICE %s :", source, dest);
      #else
	sprintf(input, "%s O %s :", gsnum, dest);
      #endif
    }

    for (; *t; t++)
    {
	if (*t == '%')
	{
	    switch(*++t) {
		case 'd': sprintf(input, "%s%d", input, va_arg(args, int)); break; 
		case 's': sprintf(input, "%s%s", input, va_arg(args, char *)); break;
		case 'S': sprintf(input, "%s%s", input, s_GameServ); break;
		case 'l':
		   if (*++t == 'd')
			  sprintf(input, "%s%ld", input, va_arg(args, long int)); break;
	    }
	}
	else
	{
	    sprintf(input, "%s%c", input, *t);
	}

    }
    #ifdef DEBUGMODE
	log("Input: %s", input);
    #endif
    sprintf(input, "%s%s", input, "\r\n");
    sock_puts(sock, input);
    delete [] input;
va_end(args);
}


int strnicmp(const char *s1, const char *s2, size_t len)
{
    register int c;

    if (!len)
        return 0;
    while ((c = tolower(*s1)) == tolower(*s2) && len > 0) {
        if (c == 0 || --len == 0)
            return 0;
        s1++;
        s2++;
    }
    if (c < tolower(*s2))
        return -1;
    return 1;
}

#ifndef HAVE_STRTOK
char *strtok(char *str, const char *delim)
{
    static char *current = NULL;
    char *ret;

    if (str)
        current = str;
    if (!current)
        return NULL;
    current += strspn(current, delim);
    ret = *current ? current : NULL;
    current += strcspn(current, delim);
    if (!*current)
        current = NULL;
    else
        *current++ = 0;
    return ret;
}
#endif

void do_list(char *u)
{
    ListNode<aClient> *temp;
    temp = players.First();
    if (!players.isEmpty())
    {
	notice(s_GameServ, u, "People Playing:");
	while(temp)
	{

	    #ifdef P10
	    notice(s_GameServ, u, "IRC: %s     Game: %s", temp->getData()->getRealNick(), 
		   temp->getData()->stats->name);
	    #else
	    notice(s_GameServ, u, "IRC: %s     Game: %s", temp->getData()->getNick(), 
		   temp->getData()->stats->name);
	    #endif

	    temp = temp->Next();
	}
	notice(s_GameServ, u, "End of List");
    }
    else
	notice(s_GameServ, u, "No one is playing");
}

void do_register(char *u)
{
    char *password, *name;
    aClient *user, *p;
    name = strtok(NULL, " ");
    password = strtok(NULL, " ");

    static char saltChars[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./";
    static char salt[3];
    
    salt[0] = saltChars[rand() % strlen(saltChars)];
    salt[1] = saltChars[rand() % strlen(saltChars)];
    salt[2] = '\0';

    if (!name)
    {
	notice(s_GameServ, u, "SYNTAX: /msg %S REGISTER NAME PASSWORD");
    }
    else if (!password)
    {
	notice(s_GameServ, u, "SYNTAX: /msg %S REGISTER NAME PASSWORD");
    }
    else if ((user = find(u)))
    {
	p = findplayer(u);
        if (!user->stats && !p)
        {
	    user->stats = new Player(user);
	    user->stats->user = user; // Set the backwards pointer
	    strcpy(user->stats->password, crypt(password, salt));
	    strcpy(user->stats->name, name);
	    players.insertAtBack(user);
	    notice(s_GameServ, u, "Player %s registered with password %s.", user->stats->name, password);
	    notice(s_GameServ, u, "Write this password down. If you lose it, there is no way to retrieve it!");
	    log("Nickname %s registered player %s.", u, user->stats->name);
	}
	else
	{
	    notice(s_GameServ, u, "Already registered. Contact a %S admin for help.");
	}
    }
}

void do_identify(char *u)
{
    char *password, *name;
    aClient *user, *p;
    name = strtok(NULL, " ");
    password = strtok(NULL, " ");
    user = find(u);
    if (!password || !name)
    {
	notice(s_GameServ, u, "SYNTAX: /msg %S IDENTIFY NAME PASSWORD");
    }
    else if (!user)
    {
	notice(s_GameServ, u, "Fatal error. Cannot find aClient. Buf: %s", strtok(NULL, ""));
	log("Error: aClient not found: %s", u);
    }
    else if (!(p = findplayer(name)) || !p->stats)
	    notice(s_GameServ, u, "Player %s not found", name);
    else if (!check_password(name, password) && !isAdmin(user))
    {
	    notice(s_GameServ, u, "Password incorrect");
    }
    else
    {
	if (p->stats->user && !isAdmin(user))
	{
	    notice(s_GameServ, u, "That player has already identified.");
	    return;
	}
        if (!user->stats)
        {
	    ListNode<aClient> *temp;
	    temp = players.Find(p);
	    if (!temp)
	    {
		notice(s_GameServ, u, "Fatal error. Contact %S Admin. Buf: %s", 
			strtok(NULL, ""));
		return;
	    }
	    user->stats = new Player(p->stats->name);
	    #ifdef DEBUGMODE
		log("Setting data for identified");
	    #endif
	    user->stats->setData(p->stats);

	    #ifdef DEBUGMODE
		log("Player Identified");
	    #endif

	    temp->setPtr(user);

	    notice(s_GameServ, u, "Password Accepted. Identified.");	    

	}
	else
	{
	    notice(s_GameServ, u, "Already identified. Contact a %S admin for help.");
	}
    }
}

void do_stats(char *u)
{
    char *nick;
    aClient *user;

    nick = strtok(NULL, " ");

    if (!nick)
    {
	if (!(user = find(u)))
	{
	    notice(s_GameServ, u, "Fatal Error in do_stats(). Contact a %S admin for help!");
	    log("Error: aClient not found: %s", u);
	    return;
	}
	else if (!is_playing(user))
	{
	    notice(s_GameServ, u, "You're not playing, so you have no stats!");
	    return;
	}
	else
	    showstats(u, user->stats->name);
    }
    else
	showstats(u, nick);
}
void init_masters()
{
    #ifdef DEBUGMODE
	log("Calling delete_masters()");
    #endif

    delete_masters();

    #ifdef DEBUGMODE
	log("Initializing masters");
    #endif

    for (int x = 0; x < LEVELS; x++)
	masters[x] = new Monster;

    strcpy(masters[0]->name, "Old Bones");
    strcpy(masters[0]->weapon, "Dull Sword Cane");
    masters[0]->strength = 15;
    masters[0]->gold = 0;
    masters[0]->exp = 0;
    masters[0]->maxhp = 30;
    masters[0]->hp = 30;
    strcpy(masters[0]->death, "You have done well my student, but the road is long. Use your new strength with humility and honor as you progress in levels!");

    strcpy(masters[1]->name, "Master Chang");
    strcpy(masters[1]->weapon, "Nanchaku");
    masters[1]->strength = 30;
    masters[1]->gold = 0;
    masters[1]->exp = 0;
    masters[1]->maxhp = 40;
    masters[1]->hp = 40;
    strcpy(masters[1]->death, "You try to make out what Master Chang is saying, but the only thing you catch is something about a grasshopper.");

    strcpy(masters[2]->name, "Chuck Norris");
    strcpy(masters[2]->weapon, "Ranger Kick");
    masters[2]->strength = 85;
    masters[2]->gold = 0;
    masters[2]->exp = 0;
    masters[2]->maxhp = 70;
    masters[2]->hp = 70;
    strcpy(masters[2]->death, "Be strong, and keep your goals in site. Drink milk, and don't do drugs. One day you may be fighting next to me as a Texas Ranger YEEHAW!");


    strcpy(masters[3]->name, "Mr. Miagi");
    strcpy(masters[3]->weapon, "Petrified Bonsai");
    masters[3]->strength = 120;
    masters[3]->gold = 0;
    masters[3]->exp = 0;
    masters[3]->maxhp = 120;
    masters[3]->hp = 120;
    strcpy(masters[3]->death, "Skill comes from repeating the correct but seemingly mundane actions. Wax ON, wax OFF!");

    strcpy(masters[4]->name, "Jackie Chan");
    strcpy(masters[4]->weapon, "Kung Fu Kick");
    masters[4]->strength = 135;
    masters[4]->gold = 0;
    masters[4]->exp = 0;
    masters[4]->maxhp = 200;
    masters[4]->hp = 200;
    strcpy(masters[4]->death, "I like to let people talk who like to talk... it's easier to find out how full of it they really are!");

    strcpy(masters[5]->name, "Jet Li");
    strcpy(masters[5]->weapon, "Motorcycle");
    masters[5]->strength = 160;
    masters[5]->gold = 0;
    masters[5]->exp = 0;
    masters[5]->maxhp = 400;
    masters[5]->hp = 400;
    strcpy(masters[5]->death, "Failure is a fuel for excuses. It's the doing the do, that makes the making.");


    strcpy(masters[6]->name, "Muhammad Ali");
    strcpy(masters[6]->weapon, "Quick Jab");
    masters[6]->strength = 185;
    masters[6]->gold = 0;
    masters[6]->exp = 0;
    masters[6]->maxhp = 600;
    masters[6]->hp = 600;
    strcpy(masters[6]->death, "It's just a job. Grass grows, birds fly, waves pound the sand. I beat people up.");

    strcpy(masters[7]->name, "Li Mu Bai");
    strcpy(masters[7]->weapon, "Green Destiny");
    masters[7]->strength = 210;
    masters[7]->gold = 0;
    masters[7]->exp = 0;
    masters[7]->maxhp = 800;
    masters[7]->hp = 800;
    strcpy(masters[7]->death, "No growth without resistance.  No action without reaction.  No desire without restraint.");


    strcpy(masters[8]->name, "Jimmy Wang Yu");
    strcpy(masters[8]->weapon, "Flying Guillotine");
    masters[8]->strength = 275;
    masters[8]->gold = 0;
    masters[8]->exp = 0;
    masters[8]->maxhp = 1200;
    masters[8]->hp = 1200;
    strcpy(masters[8]->death, "You have beaten the one armed boxer. Proceed with caution!");

    strcpy(masters[9]->name, "Wong Fei Hung");
    strcpy(masters[9]->weapon, "Drunken Boxing");
    masters[9]->strength = 360;
    masters[9]->gold = 0;
    masters[9]->exp = 0;
    masters[9]->maxhp = 1800;
    masters[9]->hp = 1800;
    strcpy(masters[9]->death, "Hiccup! Monkey drinks master's wine!");

    strcpy(masters[10]->name, "Bruce Lee");
    strcpy(masters[10]->weapon, "Fists of fury");
    masters[10]->strength = 575;
    masters[10]->gold = 0;
    masters[10]->exp = 0;
    masters[10]->maxhp = 2500;
    masters[10]->hp = 2500;
    strcpy(masters[10]->death, "You must learn to concentrate. It is like a finger pointing away to the moon... DONT concentrate on the finger, or you will miss all the heavenly glory.");
}

void init_monsters()
{
    #ifdef DEBUGMODE
	log("Calling delete_monsters");
    #endif

    delete_monsters();

    for (int x = 0; x < LEVELS; x++)
	for (int y = 0; y < MONSTERS; y++)
	    monsters[x][y] = new Monster();
}

void delete_monsters()
{
    for (int x = 0; x < LEVELS; x++)
	for (int y = 0; y < MONSTERS; y++)
	    if (monsters[x][y])
		delete monsters[x][y];
}

void delete_masters()
{
    for (int x = 0; x < LEVELS; x++)
	if (masters[x])
	    delete masters[x];
}

void display_monster(char *u)
{
    if (is_playing(u))
    {
	aClient *user = find(u);
	Player *ni = user->stats;
	
	notice(s_GameServ, u, "Your Hitpoints: %d", ni->hp);
	notice(s_GameServ, u, "%s's Hitpoints: %d", ni->fight->name, ni->fight->hp);
	notice(s_GameServ, u, "Here are your commands:");
	notice(s_GameServ, u, "/msg %S attack");
	notice(s_GameServ, u, "/msg %S run");
	notice(s_GameServ, u, "What will you do?");
    }
}

void display_players(char *u)
{
    if (is_playing(u))
    {
	aClient *ni = find(u);

    	aClient *battle = ni->stats->battle;

	notice(s_GameServ, u, "Your Hitpoints: %d", ni->stats->hp);
	notice(s_GameServ, u, "%s's Hitpoints: %d", battle->stats->name, 
							battle->stats->hp);
	notice(s_GameServ, u, "Here are your commands:");
	notice(s_GameServ, u, "/msg %S attack");
	notice(s_GameServ, u, "/msg %S run");
	notice(s_GameServ, u, "What will you do?");
    }
}
void display_players(aClient *user)
{
    char *u = user->getNick();
    if (is_playing(user) && player_fight(user))
    {
	aClient *battle = user->stats->battle;
	notice(s_GameServ, u, "Your Hitpoints: %d", user->stats->hp);
	notice(s_GameServ, u, "%s's Hitpoints: %d", battle->stats->name, battle->stats->hp);
	notice(s_GameServ, u, "Here are your commands:");
	notice(s_GameServ, u, "/msg %S attack");
	notice(s_GameServ, u, "/msg %S run");
	notice(s_GameServ, u, "What will you do?");
    }
}


bool is_playing(char *u)
{
    aClient *user;
    if (!(user = find(u)))
    {
	return false;
    }
    else
    {
	return user->stats != NULL;
    }
}

bool is_playing(aClient *user)
{
    return user->stats != NULL && (stricmp(user->getNick(), "!NULL!") != 0);
}

bool is_fighting(char *u)
{
    aClient *user;

    if (!(user = find(u)))
    {
	return false;
    }
    else if (user->stats)
    {
	return user->stats->fight != NULL || user->stats->battle != NULL 
		|| user->stats->master != NULL;
    }
    else
    	return false;
}
bool is_fighting(aClient *user)
{
    if (!is_playing(user))
	return false;
    else
	return (user->stats->fight != NULL || user->stats->battle != NULL || user->stats->master != NULL);
}

bool player_fight(char *u)
{
    aClient *user;

    if (!(user = find(u)))
	return false;
    else if (user->stats)
	return user->stats->battle != NULL;
    else
	return false;
}
bool player_fight(aClient *user)
{
    if (!is_fighting(user))
	return false;
    else
	return user->stats->battle != NULL;
}

bool master_fight(char *u)
{
    aClient *user;

    if (!(user = find(u)))
	return false;
    else if (user->stats)
	return user->stats->master != NULL;
    else
	return false;
}
bool master_fight(aClient *user)
{
    if (!is_playing(user))
	return false;
    else
	return user->stats->master != NULL;
}

void do_fight(char *u)
{
    aClient *ni, *battle;

    char *nick = strtok(NULL, " ");

    if (!nick)
    {
	notice(s_GameServ, u, "SYNTAX: /msg %S FIGHT PLAYER");
    }
    else if (!(ni = find(u)))
    {
	notice(s_GameServ, u, "Fatal error. Contact a(n) %S admin. buf: %s", strtok(NULL, ""));
	return;
    }
    else if (!(battle = findbyrealnick(nick)))
    {
	notice(s_GameServ, u, "You can't attack %s while they aren't playing!", nick);
	return;
    }
    else if (!is_playing(ni))
    {
	notice(s_GameServ, u, "You are not playing!");
	return;
    }
/*
 * Offline fighting not implemented yet.
 *   else if (!(fight = finduser(nick)))
 *   {
 *       ni->stats->battle = battle;
 *       battle->battle = ni;
 *       ni->yourturn = 1;
 *       battle->yourturn = 0;
 *       notice(s_GameServ, u, "You decide to fight %s while they're not online!",
 *                battle->stats->name);
 *       display_players(u);
 *   }
 */
    else if (!isAlive(ni->stats))
    {
	notice(s_GameServ, u, "You are dead. Wait until tomorrow to fight others!");
	return;
    }
    else if (player_fight(battle))
    {
	notice(s_GameServ, u, "%s is fighting %s already!", battle->stats->name, battle->stats->battle->stats->name);
	return;
    }
    else if (is_fighting(battle))
    {
	notice(s_GameServ, u, "%s is fighting %s already!", battle->stats->name, battle->stats->fight->name);
	return;
    }
    else if (is_playing(ni) && is_playing(battle) && stricmp(ni->stats->name, battle->stats->name) != 0)
    {
	// Set your battle pointer to the other player
        ni->stats->battle = battle;

	// Set the other player's battle pointer to you
        battle->stats->battle = ni;

	// The initiator gets the first move (perhaps this should be 50/50)
	setYourTurn(ni->stats);
	clearYourTurn(battle->stats);

	// Initiate Battle sequence!
        notice(s_GameServ, u, "You challenge %s to an online duel!", battle->stats->name);
        notice(s_GameServ, battle->getNick(), "%s has challenged you to an online duel!", ni->stats->name);
        notice(s_GameServ, battle->getNick(), "%s gets to go first because he initiated!", ni->stats->name);
        notice(s_GameServ, battle->getNick(), "Please wait while %s decides what to do.", ni->stats->name);
        display_players(u);
    }
}
void do_use(char *u)
{
    aClient *user;
    Pouch *p;

    char *item = strtok(NULL, " ");

    if (!item)
    {
	notice(s_GameServ, u, "SYNTAX: USE ITEM");
	notice(s_GameServ, u, "Type /msg %S HELP USE for more information.");
	return;
    }
    else if (!(user = find(u)))
    {
	notice(s_GameServ, u, "Fatal Error in do_use. Contact a(n) %S Admin");
	return;
    }
    else if (!is_playing(user))
    {
	notice(s_GameServ, u, "You must be playing to use items!");
	return;
    }

    p = &user->stats->inventory;

    if (stricmp(item, "HEALTH") == 0)
    {
	if (p->Healing() <= 0)
	{
	    notice(s_GameServ, u, "You are out of Health Potions!");
	    return;
	}
	int oldhealth = user->stats->hp;
	notice(s_GameServ, u, "You hastiliy gulp down the flask of cool life-giving waters.");
	notice(s_GameServ, u, "Rejuvination spreads throughout your body.");
	user->stats->hp += (10 * user->stats->level) + (rand() % 10) * user->stats->level;
	notice(s_GameServ, u, "You gain %d HP!", user->stats->hp - oldhealth);
	p->decHealing();
    }
    else if (stricmp(item, "STRENGTH") == 0)
    {
	if (p->Strength() <= 0)
	{
	    notice(s_GameServ, u, "You are out of Strength Potions!");
	    return;
	}
	int oldstrength = user->stats->strength;
	notice(s_GameServ, u, "As you grip the flask containing pure power, you feel adrenaline coarse through your veins!");
	notice(s_GameServ, u, "In one swallow you drink the potion and feel your muscle fibers bulging andgrowing!");
	user->stats->strength += 1 + rand() % 2; // 1 - 2 Strength Added
	notice(s_GameServ, u, "You gain %d Strength points!", user->stats->strength - oldstrength);
	p->decStrength();
    }
    else if (stricmp(item, "DEFENSE") == 0)
    {
	if (p->Defense() <= 0)
	{
	    notice(s_GameServ, u, "You are out of Defense Potions!");
	    return;
	}
	int olddefense = user->stats->defense;
	notice(s_GameServ, u, "You drink the foul tasting viscous liquid while pinching your nose in disgust.");
	notice(s_GameServ, u, "It tasted bad, but you feel like you are unbeatable!");
	user->stats->defense += 1 + rand() % 2; // 1 - 2 Defense Added
	notice(s_GameServ, u, "You gain %d Defense points!", user->stats->defense - olddefense);
	p->decDefense();
    }
    else if (stricmp(item, "HP") == 0)
    {
	if (p->HP() <= 0)
	{
	    notice(s_GameServ, u, "You are out of HP Potions!");
	    return;
	}
	int oldHP = user->stats->maxhp;
	notice(s_GameServ, u, "You feel your life growing longer as you drink the green glowing liquid.");
	user->stats->maxhp += 1 + rand() % 5; // 1 - 5 Maxhp
	notice(s_GameServ, u, "You gain %d Maximum hit points!", user->stats->maxhp - oldHP);
	p->decHP();
    }
    else
    {
	notice(s_GameServ, u, "SYNTAX: /msg %S USE {HEALTH | STRENGTH | DEFENSE}");
	return;
    }

    end_turn(user); // If they're fighting, end their turn
}
void do_run(char *u)
{
    aClient *user;
    Player *p, *p2 = NULL;

    if (!(user = find(u)))
    {
	notice(s_GameServ, u, "Couldn't find you. Error. Contact a %S admin");
	return;
    }

    p = user->stats;

    if (p->battle)
	p2 = p->battle->stats;

    if (!is_fighting(user))
	notice(s_GameServ, u, "You run in place... try fighting next time.");
    else if (!player_fight(user) && !master_fight(user))
    {
	notice(s_GameServ, u, "You run away from %s like a little baby!", p->fight->name);
	delete p->fight;
	p->fight = NULL;
    }
    else if (player_fight(user) && isYourTurn(p))
    {
	notice(s_GameServ, u, "You run away from %s like a little baby!", p2->name);
	notice(s_GameServ, p->battle->getNick(), "%s ran away from you like a little baby!", p->name);
	p2->battle = NULL;
    }
    else if (player_fight(user) && !isYourTurn(p))
    {
	notice(s_GameServ, u, "It is not your turn. Please wait until %s decides what to do.", p2->name);
    }
    else if (master_fight(user))
    {
	notice(s_GameServ, u, "You cannot run from %s! FIGHT!", p->master->name);
    }
    p->battle = NULL;
}

void end_turn(aClient *user)
{
    char *nick, *u = user->getNick();
    Monster *fight;
    aClient *battle;
    int mhit;

    nick = new char[strlen(user->getNick()) + 1];

    if (!user || !is_playing(user) || !is_fighting(user))
	goto endturn;

    if (!player_fight(user) && !master_fight(user))
	fight = user->stats->fight;
    else
	fight = user->stats->master;
    battle = user->stats->battle;

    if (!player_fight(user))
    {
        // Opponent's Hit
        mhit = (fight->strength / 2) +
               (rand() % (fight->strength / 2) - (user->stats->defense +
                arbonus[user->stats->armor]));
    }
    else
    {
        // Opponent's Hit
        mhit = (((battle->stats->strength + webonus[battle->stats->weapon]) / 2) +
               (rand() % ((battle->stats->strength + webonus[battle->stats->weapon])) / 2) -
               (user->stats->defense + arbonus[user->stats->armor]));
    }
    if (!player_fight(user))
    {

        if (mhit > 0)
        {
            notice(s_GameServ, u, "%s attacks with their %s for %d damage!",
                     fight->name, fight->weapon, mhit);
        }
        else if (mhit <= 0)
            notice(s_GameServ, u, "%s completely misses you!", fight->name);

        if (mhit >= user->stats->hp)
        {
            if (!master_fight(user))
            {
                notice(s_GameServ, u, "You have been killed by %s!", fight->name);
                notice(s_GameServ, u, "You lose all gold on hand and lose 10 percent "\
                        "of your experience!");
                user->stats->gold = 0;
                user->stats->exp -= (long int)(user->stats->exp * .10);
                user->stats->fight = NULL;
		clearAlive(user->stats);
                goto endturn;
            }
            else
            {
                notice(s_GameServ, u, "%s has bested you! You will have to wait "\
                        "until tomorrow to try again", user->stats->master->name);
                user->stats->fight = NULL;
                user->stats->master = NULL;
		goto endturn;
            }
        }
        else
        {
            if (mhit > 0)
                user->stats->hp -= mhit;
            display_monster(u);
            goto endturn;
        }
    }
    else
    {
	clearYourTurn(user->stats);
	setYourTurn(battle->stats);
        display_players(battle);
    }
endturn:
    delete nick;
}

void do_attack(char *u)
{
    int hit, mhit;
    aClient *ni, *battle; // The player and perhaps the player they're fighting
    Monster *fight; // The monster they may be fighting

    if (!(ni = find(u)))
    {
	notice(s_GameServ, u, "Fatal error in do_attack. Contact a(n) %S admin for help.");
	return;
    }
    else if (!is_playing(ni))
    {
	notice(s_GameServ, u, "You're not playing!");
	return;
    }
    else if (!is_fighting(ni))
    {
	notice(s_GameServ, u, "You're not in battle!");
	return;
    }
    else
    {
	if (!ni->stats->master) // This is not a master fight
		fight = ni->stats->fight;	// Monster	Could be NULL
	else			// This IS a master fight
		fight = ni->stats->master;	// Master	Could be NULL

	battle = ni->stats->battle;		// Player	Could be NULL

	// One has to be !NULL based on the previous else if
	// We wouldn't be here if they were all NULL
    }

    if (!player_fight(ni))
    {
	// Player's Hit
        hit = ((ni->stats->strength + webonus[ni->stats->weapon]) / 2) +
              (rand() % ((ni->stats->strength + webonus[ni->stats->weapon]) / 2));

	// Opponent's Hit
        mhit = (fight->strength / 2) +
               (rand() % (fight->strength / 2) - (ni->stats->defense +
                arbonus[ni->stats->armor]));
    }
    else
    {
	// Opponent's Hit
        mhit = (((battle->stats->strength + webonus[battle->stats->weapon]) / 2) +
               (rand() % ((battle->stats->strength + webonus[battle->stats->weapon])) / 2) -
               (ni->stats->defense + arbonus[ni->stats->armor]));

	// Player's Hit
        hit = (((ni->stats->strength + webonus[ni->stats->weapon]) / 2) +
               (rand() % ((ni->stats->strength + webonus[ni->stats->weapon])) / 2) -
               (battle->stats->defense + arbonus[battle->stats->armor]));
    }

  if (!player_fight(ni))
  {
    if (hit > 0)
        notice(s_GameServ, u, "You attack %s for %d points!", fight->name, hit);
    else
        notice(s_GameServ, u, "You miss %s completely!", fight->name);

    if (hit >= fight->hp)
    {
        if (master_fight(ni))
            notice(s_GameServ, u, "You have bested %s!", fight->name);
        else
            notice(s_GameServ, u, "You have killed %s!", fight->name);

        notice(s_GameServ, u, "%s", fight->death);
        notice(s_GameServ, u, "You recieve %d experience and %d gold!",
                 fight->exp, fight->gold);

	// If your new experience (or gold) will be greater than 2 billion,
	// then set your exp to 2bil. (2 billion max)... otherwise add them.
	// This could be a problem with overflowing out of the sign bit.
	// Unsigned long int maybe? Leave it for now.
        ni->stats->exp = ( (ni->stats->exp + fight->exp) > 2000000000 ? 2000000000 : 
				ni->stats->exp + fight->exp);

        ni->stats->gold = (ni->stats->gold + fight->gold > 2000000000 ? 2000000000 : 
				ni->stats->gold + fight->gold);


        if (master_fight(ni))
        {
            notice(s_GameServ, u, "You are now level %d!", ni->stats->level + 1);
            notice(s_GameServ, u, "You gain %d Strength, and %d Defense points!",
                     strbonus[ni->stats->level - 1], defbonus[ni->stats->level - 1]);

	    // Increase your level
            ni->stats->level++;

	    // Increase your maximum hit points
            ni->stats->maxhp += hpbonus[ni->stats->level - 1];

	    // Heal the player by setting hp to their max
            ni->stats->hp = ni->stats->maxhp;

	    // Add to your strength
            ni->stats->strength += strbonus[ni->stats->level - 1];

	    // Add to your defensive power
            ni->stats->defense += defbonus[ni->stats->level - 1];

	    // Clear the pointer for your master
            ni->stats->master = NULL;
        }

	// They're dead so remove the pointer
	delete ni->stats->fight;
        ni->stats->fight = NULL; 
	ni->stats->master = NULL;

        return;
    }
    else
    {
        if (hit > 0)
            fight->hp -= hit;
        if (mhit > 0)
        {
            notice(s_GameServ, u, "%s attacks with their %s for %d damage!",
                     fight->name, fight->weapon, mhit);
        }
        else if (mhit <= 0)
            notice(s_GameServ, u, "%s completely misses you!", fight->name);

        if (mhit >= ni->stats->hp)
        {
            if (!master_fight(ni))
            {
                notice(s_GameServ, u, "You have been killed by %s!", fight->name);
                notice(s_GameServ, u, "You lose all gold on hand and lose 10 percent "\
                        "of your experience!");
                ni->stats->gold = 0;
                ni->stats->exp -= (long int)(ni->stats->exp * .10);
                ni->stats->fight = NULL;
		clearAlive(ni->stats);
                return;
            }
            else
            {
                notice(s_GameServ, u, "%s has bested you! You will have to wait "\
                        "until tomorrow to try again", ni->stats->master->name);
                ni->stats->fight = NULL;
                ni->stats->master = NULL;
		return;
            }
        }
        else
        {
            if (mhit > 0)
                ni->stats->hp -= mhit;
            display_monster(u);
            return;
        }
    }
  }
  else if (player_fight(ni))
  {
/* Offline fighting not available yet
   if (!(online = finduser(ni->stats->battle->nick)) || !nick_identified(online))
   {
    if (hit > 0)
        notice(s_GameServ, u, "You attack %s for %d points!", battle->nick, hit);
    else
        notice(s_GameServ, u, "You miss %s completely!", battle->nick);
    if (hit >= battle->stats->hp)
    {
        notice(s_GameServ, u, "You have killed %s!", battle->nick);
*        notice(s_GameServ, u, "You recieve %d experience and %ld gold!",
                (long int)(battle->stats->exp * .10), battle->stats->gold);
        if (2000000000 - ni->stats->exp > (long int)(battle->stats->exp * .10))
        {
            ni->stats->exp += (long int)(battle->stats->exp * .10);
            battle->stats->exp -= (long int)(battle->stats->exp * .10);
        }
*        else
        {
            battle->stats->exp -= (long int)(battle->stats->exp * .10);
            ni->stats->exp = 2000000000;
        }

        if (2000000000 - ni->stats->gold > battle->stats->gold)
        {
*            ni->stats->gold += battle->stats->gold;
            battle->stats->gold = 0;
        }
        else
        {
            battle->stats->gold = 2000000000 - ni->stats->gold;
            ni->stats->gold = 2000000000;
        }
*        ni->stats->battle->stats->alive = 0;
        ni->stats->battle->battle = NULL;
        ni->stats->battle = NULL;
        return;
    }
    else
    {
        if (hit > 0)
*            battle->stats->hp -= hit;
        if (mhit > 0)
        {
            notice(s_GameServ, u, "%s hits you with their %s for %d damage!",
                     battle->nick, weapons[battle->stats->weapon], mhit);
        }
        else if (mhit <= 0)
            notice(s_GameServ, u, "%s completely misses you!", battle->nick);
*
        if (mhit >= ni->stats->hp)
        {
            notice(s_GameServ, u, "You have been killed by %s!", battle->nick);
            if (2000000000 - battle->stats->gold > ni->stats->gold)
            {
                notice(s_GameServ, u, "%s took all your gold!", battle->nick);
                battle->stats->gold += ni->stats->gold;
*                ni->stats->gold = 0;
            }
            else
            {
                notice(s_GameServ, u, "You're lucky, %s couldn't carry all your gold.",
                        battle->nick);
                ni->stats->gold -= (2000000000 - battle->stats->gold);
                notice(s_GameServ, u, "You were left dead with %d gold.",
*                         (long int)ni->stats->gold);
                battle->stats->gold = 2000000000;
            }
            ni->stats->battle->battle = NULL;
            ni->stats->battle = NULL;
            ni->stats->alive = 0;
            return;
        }
*        else
        {
            if (mhit > 0)
                ni->stats->hp -= mhit;
            display_players(u);
            return;
        }
    }
   }
* end offline fighting */

   if (is_playing(battle))
   {
    if (!isYourTurn(ni->stats))
    {
        notice(s_GameServ, u, "Please wait until %s decides what to do!", 
		battle->stats->name);
        return;
    }
    if (hit > 0)
    {
        notice(s_GameServ, u, "You attack %s for %d points!", battle->stats->name, hit);

        notice(s_GameServ, battle->getNick(), "%s has hit you with their %s for "\
					      "%d damage!", ni->stats->name, 
					      weapons[ni->stats->weapon], hit);
	clearYourTurn(ni->stats);
	setYourTurn(battle->stats);
        display_players(battle->getNick());
    }
    else
    {
        notice(s_GameServ, u, "You miss %s completely!", battle->stats->name);
        notice(s_GameServ, battle->getNick(), "%s misses you completely!", ni->stats->name);
	clearYourTurn(ni->stats);
	setYourTurn(battle->stats);
        display_players(battle->getNick());
    }
    if (hit >= battle->stats->hp)
    {
        notice(s_GameServ, u, "You have killed %s!", battle->stats->name);
        notice(s_GameServ, u, "You recieve %d experience and %ld gold!",
                (long int)(battle->stats->exp * .10), battle->stats->gold);
        notice(s_GameServ, battle->getNick(), "You have been killed by %s!", 
		ni->stats->name);
        battle->stats->hp = 0;
        clearAlive(battle->stats);

        if (2000000000 - ni->stats->exp > (long int)(battle->stats->exp * .10))
        {
            ni->stats->exp += (long int)(battle->stats->exp * .10);
            battle->stats->exp -= (long int)(battle->stats->exp * .10);
        }
        else
        {
            battle->stats->exp -= (long int)(battle->stats->exp * .10);
            ni->stats->exp = 2000000000;
        }

        if (2000000000 - ni->stats->gold > battle->stats->gold)
        {
           notice(s_GameServ, battle->getNick(), "You lose ten percent of experience and "\
						 "all gold on hand!");
            ni->stats->gold += battle->stats->gold;
            battle->stats->gold = 0;
        }
        else
        {
            battle->stats->gold = 2000000000 - ni->stats->gold;
            notice(s_GameServ, battle->getNick(), "You lose ten percent of your experience!");

            notice(s_GameServ, battle->getNick(), "However, %s could not carry all of your "\
			"gold.", ni->stats->name);

            notice(s_GameServ, battle->getNick(), "Luckily, you still have %ld gold "\
			"left. All is not lost!", battle->stats->gold);

            ni->stats->gold = 2000000000;
        }
	battle->stats->battle = NULL;
        ni->stats->battle = NULL;
        return;
    }
    else
    {
        if (hit > 0)
            battle->stats->hp -= hit;
	clearYourTurn(ni->stats);
	setYourTurn(battle->stats);
        notice(s_GameServ, u, "Please wait while %s decides what to do!", 
		battle->stats->name);

        return;
    }
   }
  }
}

void do_heal(char *u)
{
    aClient *ni;
    char *amount = strtok(NULL, " ");
    int price, num;

    if (!amount)
    {
	notice(s_GameServ, u, "SYNTAX: /msg %S HEAL {ALL | #}");
    }
    else if (!(ni = find(u)))
    {
	notice(s_GameServ, u, "Fatal error. Contact a(n) %S admin. buf: %s", strtok(NULL, ""));
	return;
    }
    else if (!is_playing(ni))
    {
	notice(s_GameServ, u, "You aren't playing!");
	return;
    }
    else if (!isAlive(ni->stats))
    {
	notice(s_GameServ, u, "You are dead. Wait until tomorrow for healing.");
	return;
    }
    else if (is_fighting(ni))
    {
	notice(s_GameServ, u, "You can't heal in battle!");
    }
    else if (ni->stats->hp >= ni->stats->maxhp)
    {
        notice(s_GameServ, u, "You don't need healing!");
    }
    else if (stricmp(amount, "ALL") == 0)
    {
        price = ni->stats->level * 3;
        if (ni->stats->gold < (ni->stats->maxhp - ni->stats->hp) * price)
        {
            notice(s_GameServ, u, "Healing %d points for %d gold per point.",
                     (long int)ni->stats->gold/price, price);
            ni->stats->hp += ni->stats->gold / price;
            ni->stats->gold %= price;
        }
        else
        {
            notice(s_GameServ, u, "Healing all possible points at %d gold "\
			"per point.", price);
            notice(s_GameServ, u, "%d points healed for %ld gold. HP at MAX!",
                     (ni->stats->maxhp - ni->stats->hp), 
		     (price * (ni->stats->maxhp - ni->stats->hp)) );
            ni->stats->gold -= price * (ni->stats->maxhp - ni->stats->hp);
            ni->stats->hp = ni->stats->maxhp;
        }
    }
    else if (isstringnum(amount))
    {
        num = stringtoint(amount);
        price = ni->stats->level * 3;
        if (ni->stats->gold < price * num)
        {
            notice(s_GameServ, u, "You only have enough gold to heal %d points!",
                     (long int)ni->stats->gold/price);
        }
        else if (num <= ni->stats->maxhp - ni->stats->hp)
        {
            notice(s_GameServ, u, "Healing %d points at %d gold per point.",
                     num, price);
            ni->stats->hp += num;
            ni->stats->gold -= num * price;
        }
        else if (num > ni->stats->maxhp - ni->stats->hp)
        {
            notice(s_GameServ, u, "Healing all possible points at %d gold "\
			"per point.", price);
            notice(s_GameServ, u, "%d points healed. HP at MAX!",
                     (ni->stats->maxhp - ni->stats->hp));
            ni->stats->gold -= price * (ni->stats->maxhp - ni->stats->hp);
            ni->stats->hp = ni->stats->maxhp;
        }
    }
    else if (amount[0] == '-')
        notice(s_GameServ, u, "You trying to cheat?");
    else
	notice(s_GameServ, u, "SYNTAX: /msg %S HEAL {ALL | #}");
}

int isstringnum(char *num)
{
    unsigned int x;
    for (x = 0; x < strlen(num); x++)
    {
        if ((int)num[x] < 48 || (int)num[x] > 57)
            return 0;
    }
return 1;
}

long int stringtoint(char *number)
{
    long int x, len = strlen(number), sum = 0;
    if (len == 1)
        return chartoint(number[0]);
    sum += chartoint(number[len - 1]);
    for (x = len - 2; x >= 0; x--)
        sum += chartoint(number[x]) * pow(10, abs(x - len + 1));
    return sum;
}

long int pow(int x, int y)
{
    long int value = 0;
    int count = 0;
    value += x;

    if (x != 0 && y != 0)
    {
        for (count = 1; count <= y - 1; count++)
            value *= x;
    }
    else
        return 1;
return value;
}

long int chartoint(char ch)
{
	if (int(ch) >= 48 && int(ch) <= 57)
		return int(ch) - 48;
	else
		return 0;
}

int save_gs_dbase()
{
    ListNode<aClient> *ptr = players.First();
    Player *it;
    ofstream outfile;

    outfile.open(playerdata);

    if (!outfile)
    {
	log("Error opening %s", playerdata);
	return 0;
    }

    while(ptr)
    {
	it = ptr->getData()->stats;
	outfile << it->name << ' ' << it->level << ' ' << it->exp << ' ' << it->gold << ' ' << it->bank << ' '
		<< it->hp << ' ' << it->maxhp << ' ' << it->strength << ' ' << it->defense << ' '
		<< it->armor << ' ' << it->weapon << ' '
		<< it->forest_fights << ' ' << it->player_fights <<  ' ' 
		<< it->getFlags() << ' ' << it->password << ' ' << it->inventory.Healing()
		<< ' ' << it->inventory.Strength() << ' ' << it->inventory.Defense() << ' ' << it->inventory.HP() << endl;
	ptr = ptr->Next();
    }
outfile.close();
return 1;
}

int load_gs_dbase()
{
    ifstream infile;
    aClient *temp;
    Player *p;
    char *tempname, *buf, *password;
    buf = new char[1023];

    infile.open(playerdata);

    if (infile.fail())
    {
	log("Error opening %s", playerdata);
	return 0;
    }

    while (infile.getline(buf, 1024, '\n'))
    {
	temp = new aClient;
	tempname = strtok(buf, " ");
	temp->stats = new Player(tempname);
	p = temp->stats;

	p->level = stringtoint(strtok(NULL, " "));
	p->exp = stringtoint(strtok(NULL, " "));
	p->gold = stringtoint(strtok(NULL, " "));
	p->bank = stringtoint(strtok(NULL, " "));
	p->hp = stringtoint(strtok(NULL, " "));
	p->maxhp = stringtoint(strtok(NULL, " "));
	p->strength = stringtoint(strtok(NULL, " "));
	p->defense = stringtoint(strtok(NULL, " "));
	p->armor = stringtoint(strtok(NULL, " "));
	p->weapon = stringtoint(strtok(NULL, " "));
	p->forest_fights = stringtoint(strtok(NULL, " "));
	p->player_fights = stringtoint(strtok(NULL, " "));
	p->setFlags(stringtoint(strtok(NULL, " ")));

	password = strtok(NULL, " ");
	strcpy(p->password, password);
	temp->setNick("!NULL!");
	#ifdef P10
	temp->setRealNick("!NULL!");
	#endif

	p->inventory.reset(); // Set inventory to all 0s
	// Old player databases didn't have these three extra values
	// If they come up null, leave them to 0 as the default.
	// On the next gameserv database save, it will save the values.
	tempname = strtok(NULL, " ");
	if (tempname)
	    p->inventory.setHealing(stringtoint(tempname));

	tempname = strtok(NULL, " ");
	if (tempname)
	    p->inventory.setStrength(stringtoint(tempname));

	tempname = strtok(NULL, " ");
	if (tempname)
	    p->inventory.setDefense(stringtoint(tempname));

	tempname = strtok(NULL, " ");
	if (tempname)
	    p->inventory.setHP(stringtoint(tempname));

	players.insertAtBack(temp);
	delete temp;
    }
delete [] buf;
infile.close();
return 1;
}

bool passcmp(char *encrypted, char *plaintext)
{
    char salt[3];
    char *plaintext2, *plainToencrypt;
    bool same = false;

    plaintext2 = new char[strlen(encrypted) + strlen(plaintext)]; // Extra
    strcpy(plaintext2, plaintext);
   
    salt[0] = encrypted[0];
    salt[1] = encrypted[1];
    salt[3] = '\0';

    plainToencrypt = crypt(plaintext2, salt);

    same = (strcmp((const char *)encrypted, plainToencrypt) == 0 ? true : false);

    delete []plaintext2;

    return same;
}

bool check_password(char *name, char *plaintext)
{
    aClient *client;

    if (!(client = findplayer(name)))
	return false;
    else
    {
	return passcmp(client->stats->password, plaintext);
    }
}

void do_store(char *u)
{
    char *cmd = strtok(NULL, " ");
    char *item = strtok(NULL, " ");
    char *num = strtok(NULL, " ");
    char *space;
    int wep;
    aClient *user;
    Player *p;

    if (!cmd || !item)
    {
	notice(s_GameServ, u, "SYNTAX: STORE LIST {ARMOR | WEAPONS}");
	notice(s_GameServ, u, "        STORE SELL {ARMOR | WEAPON}");
	notice(s_GameServ, u, "        STORE BUY {ARMOR | WEAPON} NUMBER");
    }
    else if (!(user = find(u)) || !is_playing(user))
	notice(s_GameServ, u, "You must be playing to use the store!");
    else if (!isAlive(user->stats))
    {
	notice(s_GameServ, u, "You are dead. Wait until tomorrow to purchase weapons and armor!");
	return;
    }
    else if (stricmp(cmd, "LIST") == 0)
    {
	if (stricmp(item, "WEAPONS") == 0)
	{
            notice(s_GameServ, u, "Welcome to Kain's Armory");
            notice(s_GameServ, u, "Here are the weapons we have available for the killing, sire:");
	    for (int x = 1; x < WNA; x++)
            {
                space = spaces(strlen(weapons[x]), ".");
                notice(s_GameServ, u, "%s%d. %s%s%d",(x < 10 ? " " : ""), x, weapons[x], space, prices[x - 1]);
                free(space);
            }
	    notice(s_GameServ, u, "To purchase a weapon, type /msg %S STORE BUY NUM.");
            notice(s_GameServ, u, "Where num. is the weapon number from the menu above.");

	}
	else if (stricmp(item, "ARMOR") == 0)
	{
	    notice(s_GameServ, u, "Welcome to Kain's Armory");
	    notice(s_GameServ, u, "I hope you enjoy the fine armor we have available for your protection:");
	    for (int x = 1; x < WNA; x++)
            {
		space = spaces(strlen(armors[x]), ".");
		notice(s_GameServ, u, "%s%d. %s%s%d",(x < 10 ? " " : ""), x, armors[x], space, prices[x - 1]);
		free(space);
	    }
            notice(s_GameServ, u, "To purchase armor, type /msg %S store buy armor num.");
            notice(s_GameServ, u, "Where num. is the armor number from the menu above.");


	}
    } else if (stricmp(cmd, "BUY") == 0) {
	if (!num)
	{
	    notice(s_GameServ, u, "SYNTAX: STORE BUY {ARMOR | WEAPON} NUMBER");
	    return;
	}
	else if (!isstringnum(num))
	{
	    notice(s_GameServ, u, "You must specify a number between 1 and %d. Not %s!", WNA - 1, num);
	    return;
	}
	if (stricmp(item, "WEAPON") == 0)
        {
            wep = stringtoint(num);
            if (wep >= WNA || wep < 1)
            {
		notice(s_GameServ, u, "The number %d is out of range. The number you provide must be between 1 and %d.", wep, WNA - 1);
                return;
            }

	    p = user->stats;

            if (p->weapon != 0)
                notice(s_GameServ, u, "You have to sell your %s first!", weapons[p->weapon]);
            else if (p->gold < prices[wep - 1])
                notice(s_GameServ, u, "You don't have enough gold for %s!", weapons[wep]);
            else
            {
                notice(s_GameServ, u, "You have purchased %s! Thanks for the gold!", weapons[wep]);
                p->weapon = wep;
                p->gold -= prices[wep - 1];
            }
        }
	else if (stricmp(item, "ARMOR") == 0)
        {
            wep = stringtoint(num);
            if (wep >= WNA || wep < 1)
            {
		notice(s_GameServ, u, "The number %d is out of range. The number you provide must be between 1 and %d.", wep, WNA - 1);
                return;
            }

	    p = user->stats;

            if (p->armor != 0)
                notice(s_GameServ, u, "You have to sell your %s first!", armors[p->armor]);
            else if (p->gold < prices[wep - 1])
                notice(s_GameServ, u, "You don't have enough gold for %s!", armors[wep]);
            else
            {
                notice(s_GameServ, u, "You have purchased %s! Thanks for the gold!", armors[wep]);
                p->armor = wep;
                p->gold -= prices[wep - 1];
            }
        }
    }
    else if (stricmp(cmd, "SELL" ) == 0)
    {
	p = user->stats;

        if (stricmp(item, "WEAPON") == 0)
        {
            if (p->weapon == 0)
            {
                notice(s_GameServ, u, "You want me to chop off your hands?");
                return;
            }
            else if (p->gold == 2000000000)
            {
                notice(s_GameServ, u, "You have enough gold. I'll just take that off your hands, sire.");
                p->weapon = 0;
            }
            else if (2000000000 - p->gold < (prices[p->weapon - 1] / 2))
            {
                notice(s_GameServ, u, "Thank you for your business! You now have as much gold as you can carry.");
                notice(s_GameServ, u, "However, you have no weapon... can I interest you in the %s?", weapons[WNA - 1]);
                p->gold = 2000000000;
                p->weapon = 0;
            }
            else
	    {
                notice(s_GameServ, u, "Thank you for your business! You now have %d more gold but no weapon!", (prices[p->weapon - 1] / 2));
                p->gold += (prices[p->weapon - 1] / 2);
                p->weapon = 0;
            }
        }
        else if (stricmp(item, "ARMOR") == 0)
        {
	    p = user->stats;

            if (p->armor == 0)
            {
                notice(s_GameServ, u, "I don't think you can be any more naked...");
                return;
            }
            if (p->gold == 2000000000)
            {
                notice(s_GameServ, u, "You have enough gold. I'll just take that off your hands, sire.");
                p->armor = 0;
            }
            else if (2000000000 - p->gold < (prices[p->armor - 1] / 2))
            {
                notice(s_GameServ, u, "Thank you for your business! You now have as much gold as you can carry.");
                notice(s_GameServ, u, "However, you have no armor... can I interest you in %s?", armors[WNA - 1]);
		p->gold = 2000000000;
                p->armor = 0;
            }
            else
            {
                notice(s_GameServ, u, "Thank you for your business! You now have %d more gold but no armor!",
                         (prices[p->armor - 1] / 2));

                p->gold += (prices[p->armor - 1] / 2);
                p->armor = 0;
            }
	}
        else
	{
	    notice(s_GameServ, u, "SYNTAX: STORE LIST {ARMOR | WEAPONS}");
	    notice(s_GameServ, u, "        STORE SELL {ARMOR | WEAPON}");
	    notice(s_GameServ, u, "        STORE BUY {ARMOR | WEAPON} NUMBER");
	}
    }
}
void do_inventory(char *u)
{
    aClient *user;

    if (!(user = find(u)))
    {
	notice(s_GameServ, u, "Fatal Error. Contact a %S admin!");
	return;
    }
    else if (!is_playing(user))
    {
	notice(s_GameServ, u, "You must be playing to check your inventory!");
	return;
    }
    showinventory(user, user);
}
void showinventory(aClient *from, aClient *to)
{
    char *nick = to->getNick();

    if (!to)
	to = from;
    if (is_playing(from))
    {
	Pouch *p = &from->stats->inventory;
	notice(s_GameServ, nick, "Inventory for %s:", from->stats->name);
	notice(s_GameServ, nick, " Healing Potions: %d", p->Healing());
	notice(s_GameServ, nick, "Strength Potions: %d", p->Strength());
	notice(s_GameServ, nick, " Defense Potions: %d", p->Defense());
	notice(s_GameServ, nick, "      HP Potions: %d", p->HP());
    }
}
void do_tavern(char *u)
{
    char *cmd = strtok(NULL, " ");
    long int price;

    aClient *user;
    Player *p;
    if (!(user = find(u)))
    {
	notice(s_GameServ, u, "Fatal Error. See a %S admin for help");
	return;
    }
    else if (!is_playing(user))
    {
	notice(s_GameServ, u, "You must be playing to go to the Tavern");
	return;
    }
    else if (is_fighting(user))
    {
	notice(s_GameServ, u, "You cannot go to the Tavern during a fight!");
	return;
    }
    p = user->stats;
    if (!cmd)
    {
	notice(s_GameServ, u, "Welcome to Boot Liquors Mystic Apothecary");
	notice(s_GameServ, u, "Your commands:");
	notice(s_GameServ, u, "/msg %S TAVERN {LIST | BUY} [NUMBER]");
	notice(s_GameServ, u, "What'll it be?");
    }
    else if (stricmp(cmd, "LIST") == 0)
    {
	notice(s_GameServ, u, "Here is a list of what we have to offer:");
	notice(s_GameServ, u, "1. Healing Potions for %ld Gold", 1000 * p->level + (p->exp / 10));
	notice(s_GameServ, u, "2. Strength Potions for %ld Gold", 2050 * p->level + (p->exp / 10));
	notice(s_GameServ, u, "3. Defense Potions for %ld Gold", 2000 * p->level + (p->exp / 10));
	notice(s_GameServ, u, "4. HP Potions for %ld Gold", 2300 * p->level + (p->exp / 10));
	notice(s_GameServ, u, "To buy a potion, type /msg %S TAVERN BUY #");
	notice(s_GameServ, u, "Example: /msg %S TAVERN BUY 1 buys a healing potion!");
	notice(s_GameServ, u, "By something will ya!");
    }
    else if (stricmp(cmd, "BUY") == 0)
    {
	char *chnum = strtok(NULL, " ");
	int num = stringtoint(chnum);

	if (!chnum)
	{
	    notice(s_GameServ, u, "SYNTAX: TAVERN BUY #");
	    notice(s_GameServ, u, "Example: /msg %S TAVERN BUY 1");
	    return;
	}
	if (num < 1 || num > 4)
	{
	    notice(s_GameServ, u, "Invalid Choice!");
	    notice(s_GameServ, u, "Here is a list of what we have to offer:");
	    notice(s_GameServ, u, "1. Healing Potions for %ld Gold", 1000 * p->level + (p->exp / 10));
	    notice(s_GameServ, u, "2. Strength Potions for %ld Gold", 2050 * p->level + (p->exp / 10));
	    notice(s_GameServ, u, "3. Defense Potions for %ld Gold", 2000 * p->level + (p->exp / 10));
	    notice(s_GameServ, u, "4. HP Potions for %ld Gold", 2300 * p->level + (p->exp / 10));
	    notice(s_GameServ, u, "To buy a potion, type /msg %S TAVERN BUY #");
	    notice(s_GameServ, u, "Example: /msg %S TAVERN BUY 1 buys a healing potion!");
	    return;
	}
	switch(num)
	{
	    case 1:
		price = (1000 * p->level) + (p->exp / 10);
		if (p->gold >= price)
		{
		    notice(s_GameServ, u, "One healing potion coming right up!");
		    p->inventory.incHealing();
		    p->gold -= price;
		} 
		else
		    notice(s_GameServ, u, "You don't have enough gold!");
		break;
	    case 2:
		price = (2050 * p->level) + (p->exp / 10);
		if (p->gold >= price)
		{
		    notice(s_GameServ, u, "One strength boost coming right up!");
		    p->inventory.incStrength();
		    p->gold -= price;
		}
		else
		    notice(s_GameServ, u, "You don't have enough gold!");
		break;
	    case 3:
		price = (2000 * p->level) + (p->exp / 10);
		if (p->gold >= price)
		{
		    notice(s_GameServ, u, "One defense boost coming right up!");
		    p->inventory.incDefense();
		    p->gold -= price;
		}
		else
		    notice(s_GameServ, u, "You don't have enough gold!");
		break;
	    case 4:
		price = (2300 * p->level) + (p->exp / 10);
		if (p->gold >= price)
		{
		    notice(s_GameServ, u, "One HP Potion coming right up!");
		    p->inventory.incHP();
		    p->gold -= price;
		}
		else
		    notice(s_GameServ, u, "You don't have enough gold!");
		break;
	    default:
		notice(s_GameServ, u, "Logical Error. See a %S admin for help!");
		break;
	}
    }
    else
    {
	notice(s_GameServ, u, "Improper Syntax.");
	notice(s_GameServ, u, "Type /msg %S HELP TAVERN for help");
    }
}

void do_bank(char *u)
{
    char *cmd = strtok(NULL, " ");
    char *amount = strtok(NULL, " ");
    char *nick = strtok(NULL, " ");

    aClient *user;
    Player *p;

    if (!cmd || (!amount && stricmp(cmd, "BALANCE") != 0) || (stricmp(cmd, "TRANSFER") == 0 && !nick))
    {
	notice(s_GameServ, u, "BANK {WITHDRAW | DEPOSIT} {ALL | AMOUNT}");
	notice (s_GameServ, u, "BANK BALANCE");
	return;
    }

    user = find(u);
    if (!is_playing(user))
    {
	notice(s_GameServ, u, "You must be playing to use the bank!");
	return;
    }
    else if (stricmp(cmd, "BALANCE") == 0)
    {
        showBankBalance(u);
        return;
    }
    else if (!isAlive(user->stats))
    {
	notice(s_GameServ, u, "You are dead. We don't accept gold from dead folk! Wait 'til tomorrow!");
	return;
    }
    else if (!isstringnum(amount) && stricmp(amount, "ALL") != 0)
    {
        notice(s_GameServ, u, "I don't know how to convert alphabet letters into currency, sire!");
        return;
    }

    p = user->stats;

    if (stricmp(cmd, "DEPOSIT") == 0)
    {
        if (p->bank == 2000000000)
        {
            notice(s_GameServ, u, "Your bank account is full, sire!");
            return;
        }
        else if (stricmp(amount, "ALL") == 0)
        {
            if (2000000000 - p->bank < p->gold)
            {
                notice(s_GameServ, u, "You don't have enough room for all of your gold.");
                notice(s_GameServ, u, "Depositing %ld gold into your account", (2000000000 - p->bank));
                p->gold -= (2000000000 - p->bank);
                p->bank = 2000000000;
		showBankBalance(u);
            }
            else
            {
                notice(s_GameServ, u, "Depositing %ld gold into your account!", p->gold);
                p->bank += p->gold;
                p->gold = 0;
		showBankBalance(u);
            }
        }
        else if (stringtoint(amount) > p->gold)
        {
            notice(s_GameServ, u, "Sire, you only have %ld gold!", p->gold);
	    showBankBalance(u);
            return;
        }
        else
        {
            if (2000000000 - p->bank < stringtoint(amount))
            {
                notice(s_GameServ, u, "You don't have room in your account for that much.");
                notice(s_GameServ, u, "Capping off your account with %ld gold!", (2000000000 - p->bank));
                p->gold -= (2000000000 - p->bank);
                p->bank = 2000000000;
		showBankBalance(u);
            }
            else
            {
                notice(s_GameServ, u, "Depositing %d gold into your account!", stringtoint(amount));
                p->bank += stringtoint(amount);
                p->gold -= stringtoint(amount);
		showBankBalance(u);
            }
        }
    }
    else if (stricmp(cmd, "WITHDRAW") == 0)
    {
        if (p->gold == 2000000000)
        {
            notice(s_GameServ, u, "You cannot carry any more gold, sire!");
	    showBankBalance(u);
            return;
        }
        else if (stricmp(amount, "ALL") == 0)
        {
            if (2000000000 - p->gold < p->bank)
            {
                notice(s_GameServ, u, "You don't have enough room to carry all that gold.");
                notice(s_GameServ, u, "Withdrawing %ld gold from your account", (2000000000 - p->gold));
                p->bank -= (2000000000 - p->gold);
                p->gold = 2000000000;
		showBankBalance(u);
            }
            else
            {
                notice(s_GameServ, u, "Withdrawing %ld gold from your account!", p->bank);
                p->gold += p->bank;
                p->bank = 0;
		showBankBalance(u);
            }
        }
        else if (stringtoint(amount) > p->bank)
        {
            notice(s_GameServ, u, "Sire, you only have %ld gold in the bank!", p->bank);
	    showBankBalance(u);
            return;
        }
        else
        {
            if (2000000000 - p->gold < stringtoint(amount))
            {
                notice(s_GameServ, u, "You don't enough have room to carry that much gold!");
                notice(s_GameServ, u, "You fill your pockets with %ld gold!",
                        (2000000000 - p->gold));
                p->bank -= (2000000000 - p->gold);
                p->gold = 2000000000;
		showBankBalance(u);
            }
            else
            {
                notice(s_GameServ, u, "Withdrawing %d gold from your account!", stringtoint(amount));
                p->gold += stringtoint(amount);
                p->bank -= stringtoint(amount);
		showBankBalance(u);
            }
        }
    }

}

void do_master(char *u)
{
    aClient *user;
    user = find(u);

    if (!user)
    {
	notice(s_GameServ, u, "Fatal error. Contact a(n) %S admin. buf: %s", strtok(NULL, ""));
	return;
    }
    else if (is_fighting(user))
    {
	notice(s_GameServ, u, "You're in the middle of a fight! Pay attention!");
	return;
    }
    else if (!isAlive(user->stats))
    {
	notice(s_GameServ, u, "You're dead. Wait until tomorrow to see your master!");
	return;
    }
    else if (!is_playing(user))
    {
	notice(s_GameServ, u, "You must be playing to see your master!");
	return;
    }
    
    char *cmd = strtok(NULL, " ");
    Player *p = user->stats;
    long int need = 0;

    if (seenMaster(p))
    {
	notice(s_GameServ, u, "You have already seen your master today. Wait until tomorrow to try again");
	return;
    }

    if (cmd != NULL)
    {
	switch(p->level)
	{
	    case 1:
		need = 100;
		break;
	    case 2:
		need = 400;
		break;
	    case 3:
		need = 1000;
		break;
	    case 4:
		need = 4000;
		break;
	    case 5:
		need = 10000;
		break;
	    case 6:
		need = 40000;
		break;
	    case 7:
		need = 100000;
		break;
	    case 8:
		need = 400000;
		break;
	    case 9:
		need = 1000000;
		break;
	    case 10:
		need = 4000000;
		break;
	    case 11:
		need = 10000000;
		break;
	    case 12:
		need = p->exp + 1;
		notice(s_GameServ, u, "You are at level 12. You are the master. What's left? The DRAGON!");
		break;
	    default:
		need = p->exp + 1; // Unknown level... don't let them fight a fake master!
		break;
	}   
    }
    else
    {
	notice(s_GameServ, u, "SYNTAX: MASTER {FIGHT | QUESTION}");
	return;
    }

    if (stricmp(cmd, "FIGHT") == 0)
    {
	if (p->exp >= need)
	{
	    setMaster(p);
	    see_master(u);
	}
	else
	    notice(s_GameServ, u, "You are not worthy of fighting %s! You need %ld more experience.", masters[p->level - 1]->name, (need - p->exp));
	return;
    }
    else if (stricmp(cmd, "QUESTION") == 0)
    {
	if (p->exp >= need)
	    notice(s_GameServ, u, "%s looks you up and down and decides you are more ready than you will ever be.", masters[p->level - 1]->name);
	else
	    notice(s_GameServ, u, "You pathetic fool! You are no match for %s, %s!", masters[p->level - 1]->name, p->name);

	return;
    }
    else
    {
	notice(s_GameServ, u, "SYNTAX: MASTER {FIGHT | QUESTION}");
    }
}

void see_master(char *u)
{
    aClient *user;

    if (!(user = find(u)))
    {
	notice(s_GameServ, u, "Fatal error. Contact a(n) %S admin. buf: %s", strtok(NULL, ""));
	return;	
    }

    if (!is_fighting(user) && is_playing(user))
    {
	Player *p = user->stats;
	p->master = new Monster(masters[p->level - 1]);
	p->fight = p->master;
	display_monster(u);  // Since master is the same structure, use this function
    }
}

void showBankBalance(const char *u)
{
    aClient *user;
    Player *p;

    if (!(user = find(u)))
        return;

    p = user->stats;

    if (!p)
	return;

    notice(s_GameServ, u, "Account Balance: %ld     Gold On hand: %ld", p->bank, p->gold);

}

void refreshall()
{
    ListNode <aClient> *it;
    Player *p;

    it = players.First();

    while (it)
    {
	p = it->getData()->stats;
	refresh(p);
	it = it->Next();
    }
}

void refresh(Player *p)
{
    if (!p)
	return;

    if (p->hp < p->maxhp)
	p->hp = p->maxhp;
    p->forest_fights = forestfights;
    p->player_fights = 3;
    setAlive(p);
    clearMaster(p);
}

void do_refresh(char *u)
{
    char *nick = strtok(NULL, " ");
    aClient *user;

    if (!(user = find(u)))
    {
	notice(s_GameServ, u, "Error: aClient not found. Contact a %S admin");
	log("Error: aClient not found: %s", u);
	return;
    }
    else if (!isAdmin(user))
    {
	notice(s_GameServ, u, "You must be a %S admin to use this command!");
	return;
    }
    if (!nick)
    {
	notice(s_GameServ, u, "SYNTAX: REFRESH {ALL | NICK}");
	return;
    }
    else if (stricmp(nick, "ALL") == 0)
    {
	notice(s_GameServ, u, "Refreshing everyone's stats!");
	refreshall();
    }
    else if ((user = findbyrealnick(nick)))
    {
	if (is_playing(user))
	{
	    #ifdef P10
	    notice(s_GameServ, u, "Refreshing %s.", user->getRealNick());
	    #else
	    notice(s_GameServ, u, "Refreshing %s.", user->getNick());
	    #endif
	    refresh(user->stats);
	}
	else
	{
	    #ifdef P10
	    notice(s_GameServ, u, "%s is not playing.", user->getRealNick());
	    #else
	    notice(s_GameServ, u, "%s is not playing.", user->getNick());
	    #endif
	}
    }
    else
    {
	notice(s_GameServ, u, "Nick %s not found.", nick);
	return;
    }
}


void resetall()
{
    ListNode <aClient> *it;
    Player *p;

    it = players.First();

    while (it)
    {
	p = it->getData()->stats;
	reset(p);
	it = it->Next();
    }
}

void reset(Player *p)
{
    if (!p)
	return;

    p->reset();
}

void do_reset(char *u)
{
    char *nick = strtok(NULL, " ");
    aClient *user;

    if (!(user = find(u)))
    {
	notice(s_GameServ, u, "Error: aClient not found. Contact a %S admin");
	log("Error: aClient not found: %s", u);
	return;
    }
    else if (!isAdmin(user))
    {
	notice(s_GameServ, u, "You must be a %S admin to use this command!");
	return;
    }
    if (!nick)
    {
	notice(s_GameServ, u, "SYNTAX: RESET {ALL | NICK}");
	return;
    }
    else if (stricmp(nick, "ALL") == 0)
    {
	notice(s_GameServ, u, "Resetting everyone's stats!");
	resetall();
    }
    else if ((user = findbyrealnick(nick)))
    {
	if (is_playing(user))
	{
	    #ifdef P10
	    notice(s_GameServ, u, "Resetting %s.", user->getRealNick());
	    #else
	    notice(s_GameServ, u, "Resetting %s.", user->getNick());
	    #endif
	    reset(user->stats);
	}
	else
	{
	    #ifdef P10
	    notice(s_GameServ, u, "%s is not playing.", user->getRealNick());
	    #else
	    notice(s_GameServ, u, "%s is not playing.", user->getNick());
	    #endif
	}
    }
    else
    {
	notice(s_GameServ, u, "Nick %s not found.", nick);
	return;
    }
}

void do_help(char *u)
{
    char *cmd = strtok(NULL, " ");

    display_help(u, cmd);
}

void display_help(char *u, char *file)
{
    ifstream infile;
    char *buf;

    if (!file)
    {
	infile.open("helpfiles/help");
	if (infile.fail())
	{
	    log("Error opening helpfiles/help");
	    notice(s_GameServ, u, "Error opening helpfiles/help");
	    return;
	}
	buf = new char[1024];
	while(infile.getline(buf, 1024))
	{
	    // Written this way, it will process %S in the helpfiles
	    // Instead of notice(s_GameServ, u, "%s", buf);
	    	notice(s_GameServ, u, buf);
	}

	// Minor recursion
	aClient *user = find(u);
	if (user && isAdmin(user))
	    display_help(u, "admin_commands");
    }
    else
    {
	char *filename;
	filename = new char[strlen(file) + 11];
	strcpy(filename, "helpfiles/");
	strcat(filename, file);

	for (unsigned int x = 10; x < strlen(filename); x++)
	    filename[x] = tolower(filename[x]);

	infile.open(filename);
	delete [] filename;
	if (infile.fail())
	{
	    notice(s_GameServ, u, "No help for %s", file);
	    return;
	}
	buf = new char[1024];
	while(infile.getline(buf, 1024))
	{
	    // Written this way, it will process %S in the helpfiles
	    // Instead of notice(s_GameServ, u, "%s", buf);
	    notice(s_GameServ, u, buf);
	}
    }
    infile.close();
    delete [] buf;
}

void do_admin(char *u)
{
    aClient *user;
    char *pass = strtok(NULL, " ");

    if (!(user = find(u)))
    {
	log("Error: aClient not found: %s", u);
	notice(s_GameServ, u, "Error: aClient not found. Contact %S admin.");
	return;
    }
    if (!pass)
    {
	notice(s_GameServ, u, "SYNTAX: ADMIN password");
	return;
    }

    if (isAdmin(user))
    {
	notice(s_GameServ, u, "You already have administrator privledges.");
	return;
    }
    else if (strcmp(pass, adminpass) == 0)
    {
	notice(s_GameServ, u, "Password accepted. You now have administrator privledges.");
	setAdmin(user);
	#ifdef P10
	log("%s became an administrator.", user->getRealNick());
	#else
	log("%s became an administrator.", user->getNick());
	#endif
    }
    else
    {
	notice(s_GameServ, u, "Invalid password. Remember: case sensitive");
	return;
    }
}

bool load_monsters()
{
    ifstream infile;
    infile.open("monsters.dat");

    char *buf;

    if (infile.fail())
    {
	log("Error opening monsters.dat");
	return false;
    }
    init_monsters();
    buf = new char[2048];

    #ifdef DEBUGMODE
	log("Loading monsters from monsters.dat");
    #endif

  for (int l = 0; l < REALLEVELS; l++)
  {
    for (int m = 0; m < MONSTERS;)
    {
	infile.getline(buf, 2048);
	if (buf[0] == '\n' || buf[0] == '\0' || buf[0] == '#')
	    continue;
	else
	{
	    strcpy(monsters[l][m]->name, strtok(buf, "~"));
	    strcpy(monsters[l][m]->weapon, strtok(NULL, "~"));
	    monsters[l][m]->strength = stringtoint(strtok(NULL, "~"));
	    monsters[l][m]->gold = stringtoint(strtok(NULL, "~"));
	    monsters[l][m]->exp = stringtoint(strtok(NULL, "~"));
	    monsters[l][m]->maxhp = stringtoint(strtok(NULL, "~"));
	    monsters[l][m]->hp = monsters[l][m]->maxhp;
	    strcpy(monsters[l][m]->death, strtok(NULL, ""));
	    m++;
	}
    }
  }
    delete [] buf;
return true;
}
