#ifndef LIST_H
#define LIST_H

#include <iostream>
#include <cassert>
#include "listnode.h"
#include "aClient.h"
#include "extern.h"
#include "options.h"

using std::cout;
using std::endl;
using std::flush;

template <class T>
class List {
    public:
	List();		//constructor
	~List();	//deconstructor
	void insertAtFront( const T & );
	void insertAtBack( T *&);
	bool removeFromFront( T & );
	bool removeFromBack( T & );
	bool remove( T * );
	bool isEmpty() const;
	void print() const;
	ListNode < T > *Find( T * );
        ListNode < T > *First() { return firstPtr; };
	ListNode < T > *Last() { return lastPtr; };
    private:
	ListNode < T > *firstPtr;
	ListNode < T > *lastPtr;

	ListNode < T > *getNewNode ( const T &  );
};

template <class T>
List<T>::List() : firstPtr (0), lastPtr (0) {}

template <class T>
List<T>::~List()
{
    if (!isEmpty())
    {
	#ifdef DEBUGMODE
	    log("Destroying Nodes");
	#endif

	ListNode<T> *currentPtr = firstPtr, *tempPtr;

	while (currentPtr) 
	{
	    tempPtr = currentPtr;
	    currentPtr = currentPtr->Next();

	    #ifdef DEBUGMODE
		log("Deleting Memory address: %s", tempPtr->getData());
	    #endif
	    
		delete tempPtr;
	}
	#ifdef DEBUGMODE
	    log("All Nodes destroyed");
	#endif
    }
}

template<class T>
void List<T>::insertAtFront( const T &value )
{
    ListNode<T> *newPtr = getNewNode ( value );


    if (isEmpty())
	firstPtr = lastPtr = newPtr;
    else
    {
	newPtr->Next = firstPtr;
	firstPtr->prev = newPtr;
	firstPtr = newPtr;
    }
}

template<class T>
void List<T>::insertAtBack(T *&value )
{
    ListNode<T> *newPtr = getNewNode(*value);

    if (isEmpty())
    {
	firstPtr = lastPtr = newPtr;
    }
    else
    {
	newPtr->prev = lastPtr;
	lastPtr->next = newPtr;
	lastPtr = newPtr;
    }
}


template <class T>
bool List<T>::removeFromFront( T &value )
{
    if ( isEmpty())
	return false;
    else
    {
	ListNode<T> *tempPtr = firstPtr;

	if ( firstPtr == lastPtr )
	    firstPtr = lastPtr = 0;
	else
	    firstPtr = firstPtr->next;

	value = tempPtr->getData();
	delete tempPtr;
	return true;
    }
}

template <class T>
bool List<T>::removeFromBack( T &value )
{
    if ( isEmpty() )
	return false;
    else
    {
	ListNode<T> *tempPtr = lastPtr;

	if ( firstPtr == lastPtr )
	    lastPtr = firstPtr = 0;
	else
	    lastPtr = lastPtr->prev;

	value = tempPtr->getData();
	delete tempPtr;
	return true;

    }
}

template <class T>
bool List<T>::isEmpty() const
   { return firstPtr == 0 && lastPtr == 0; }

template <class T>
ListNode<T> *List<T>::getNewNode( const T &value)
{
    ListNode<T> *ptr = new ListNode<T>(value);

    assert( ptr != 0);

    return ptr;
}
template<class T>
ListNode<T> *List<T>::Find( T *value )
{
    if (isEmpty()) {return NULL;}

    ListNode<T> *currentPtr;
    currentPtr = firstPtr;
    while (currentPtr)
    {
	if (currentPtr->getData() == value)
	    return currentPtr;
	currentPtr = currentPtr->Next();
    }
    return NULL;
}

#ifdef DEBUGMODE
template <class T>
void List<T>::print() const
{
    if (isEmpty())
    {
	cout << "Empty list" << endl;
	return;
    }

    ListNode<T> *currentPtr;
    currentPtr = firstPtr;
    while (currentPtr)
    {
	cout << "aClient: " << *currentPtr->getData() << flush;

        if (currentPtr->getData()->stats)
	    cout << "  Player Name: " << currentPtr->getData()->stats->name 
		 << "   Password: " << currentPtr->getData()->stats->password << flush;
	cout << endl;
	currentPtr = currentPtr->next;
    }
}
#endif

template <class T>
bool List<T>::remove(T *remPtr)
{
    ListNode<T> *newPtr = firstPtr;
    T *testPtr;

    if (isEmpty())
	return false;

    while (newPtr)
    {
	testPtr = newPtr->getData();
	if (testPtr == remPtr)
	{
	    if (firstPtr == lastPtr)
	    {
		#ifdef DEBUGMODE
		    log("One Element. Deleting it");
		#endif
		firstPtr = lastPtr = NULL;
		delete newPtr;
		return true;
	    }
	    else if (newPtr != lastPtr && newPtr != firstPtr)
	    {
		#ifdef DEBUGMODE
		    log("Many elements, this one is in the middle. Deleting it, linking front to back, and back to front.");
		#endif
		newPtr->prev->next = newPtr->next;
		newPtr->next->prev = newPtr->prev;
		delete newPtr;
		return true;
	    }
	    else if (newPtr == lastPtr)
	    {
		#ifdef DEBUGMODE
		    log("This was the last element. Deleting it, and pointing the tail to its previous element.");
		#endif
		lastPtr = newPtr->prev;
		lastPtr->next = 0;
		delete newPtr;
		return true;
	    }
	    else if (newPtr == firstPtr)
	    {
		#ifdef DEBUGMODE
		    log("This was the first element. Deleting it, and pointing the head to its next element.");
		#endif
		firstPtr = newPtr->next;
		firstPtr->prev = 0;
		delete newPtr;
		return true;
	    }
	}
	newPtr = newPtr->next;
    }
    return false;
}
#endif
