#ifndef LISTNODE_H
#define LISTNODE_H

#include "aClient.h"

template<class T> class List;


template <class T>
class ListNode {
	friend class List<T>;
    public:
	ListNode(const T &);
	T *getData();
	void setData(const T &);
	void setPtr( T * );
	ListNode<T> *Next() { return next; };
	ListNode<T> *Prev() { return prev; };
    private:
	T *data;
	ListNode<T> *next;
	ListNode<T> *prev;
};

template <class T>
ListNode<T>::ListNode(const T &info) 
{
  next = NULL;
  prev = NULL;
  data = new T(info); 
}

template <class T>
T *ListNode<T>::getData() { return data; }

template <class T>
void ListNode<T>::setData( const T &info )
	{ data ( info ); }

template <class T>
void ListNode<T>::setPtr( T *newPtr )
{
    T *temp;
    temp = data;
    data = newPtr;
    delete temp;
}
#endif
