#include "extern.h"
#include <cctype>
#include <stdio.h>
#include <fstream>

using std::endl;
using std::cerr;
using std::ofstream;
using std::ios;

void log(const char *fmt, ...)
{
    if (fmt[0] == '\0')
        return;

    ofstream outfile;
    char *ts, *output;
    const char *t = fmt;

    ts = new char[32];
    output = new char[4096];

    outfile.open("gameserv.log", ios::out | ios::app);

    if (outfile.fail())
    {
	cerr << "Error opening gameserv.log" << endl;
	return;
    }

    struct tm *tm;
    time_t ti;
    time(&ti);
    tm = localtime(&ti);
    strftime(ts, 32, "%Y%m%d", tm);

    sprintf(output, "[%s]: ", ts);

    va_list args;
    va_start(args, fmt);

    for (; *t; t++)
    {
        if (*t == '%')
        {
            switch(*++t) {
                case 'd': sprintf(output, "%s%d", output, va_arg(args, int)); break;
                case 's': sprintf(output, "%s%s", output, va_arg(args, char *)); break;
                case 'S': sprintf(output, "%s%s", output, s_GameServ); break;
                case 'l':
                   if (*++t == 'd')
                          sprintf(output, "%s%ld", output, va_arg(args, long int)); break;
            }
        }
        else
        {
            sprintf(output, "%s%c", output, *t);
        }

    }

    outfile << output << endl;

    outfile.close();
    va_end(args);

    delete [] ts;
    delete [] output;
}
