#include "player.h"
#include "pouch.h"
#include "extern.h"
#include "flags.h"
#include <stdlib.h>
#include <stdio.h>

void Player::reset()
{
    memset(name, 0, 256);
    memset(password, 0, 256);

    exp = 1;
    gold = 0;
    bank = 500;
    hp = 10;
    maxhp = 10;
    strength = 0;
    defense = 0;
    armor = 1;
    weapon = 1;
    level = 1;
    forest_fights = forestfights;
    player_fights = 3;
    fight = NULL;
    master = NULL;
    battle = NULL;
    flags = 0;
    setAlive(this);
    inventory.reset();
}

Player::Player(aClient *user)
{

    name = new char[256];
    password = new char[256];

    if (user)
    {
	setData(user->stats);
	strcpy(name, user->getNick());
    }
    else
	setData(NULL);

    #ifdef DEBUGMODE
	log("New Player: %s", name);
    #endif
}

Player::Player(char *n)
{
    name = new char[256];
    password = new char[256];

    reset(); // Set defaults

    strcpy(name, n);

    log("New Player: %s", name);
}

Player::~Player()
{   
    #ifdef DEBUGMODE
	char *output;
	output = new char[strlen(name) + strlen(password) + 48];
	strcpy(output, "Deleting Player");
    #endif
 
    if (name != NULL)
    {
	#ifdef DEBUGMODE
	    sprintf(output, "%s: %s", output, name);
	#endif

	delete [] name;
    }

    if (password != NULL)
    {
	#ifdef DEBUGMODE
	    sprintf(output, "%s    Password: %s", output, password);
	#endif

	delete [] password;
    }

    #ifdef DEBUGMODE
	log ("%s", output);
	delete [] output;
    #endif
}

void Player::setData(Player *right)
{
    if (right)
    {
        strcpy(name, right->name);
        strcpy(password, right->password);
        exp = right->exp;
        gold = right->gold;
        bank = right->bank;
        hp = right->hp;
        maxhp = right->maxhp;
        strength = right->strength;
        defense = right->defense;
        armor = right->armor;
        weapon = right->weapon;
        level = right->level;
        forest_fights = right->forest_fights;
        player_fights = right->player_fights;
	flags = right->flags;
	inventory.setInventory(&right->inventory);
    }
    else
    {
        reset();

	int num = rand() % 32767;
	sprintf(name, "Player%d", num);
    }

    log("Setting Player data for %s", name);
}

monster_::~monster_()
{
    delete name;
    delete weapon;
    delete death;
}

monster_::monster_()
{
    name = new char[64];
    weapon = new char[64];
    death = new char[512];

    memset(name, 0, 64);
    memset(weapon, 0, 64);
    memset(death, 0, 512);
}

monster_::monster_(monster_ *m)
{
    name = new char[strlen(m->name) + 1];
    weapon = new char[strlen(m->weapon) + 1];
    death = new char[strlen(m->death) + 1];

    strcpy(name, m->name);
    strcpy(weapon, m->weapon);
    strcpy(death, m->death);

    strength = m->strength;
    maxhp = m->maxhp;
    hp = m->hp;
    gold = m->gold;
    exp = m->exp;
}

long int Player::setFlags(long int newflags)
{
    flags = newflags;
    return getFlags();
}

long int Player::addFlag(long int flag)
{
    flags |= flag;
    return getFlags();
}

long int Player::remFlag(long int flag)
{
    flags &= ~flag;
    return getFlags();
}

Pouch::Pouch(int h, int s, int d)
{
    setHealing(h);
    setStrength(s);
    setDefense(d);
}
