#ifndef PLAYER_H
#define PLAYER_H

#include <string.h>
#include "aClient.h"
#include "pouch.h"

typedef struct monster_ Monster;

class aClient; // forward declaration

class Player {
public:
    Player(aClient *user = NULL);
    Player(char *);
    ~Player();
    void setData(Player *);
    void reset();

    long int getFlags() { return flags; };          // Returns the Client's current flags
        // Functions also return the flags after modifying them
    long int setFlags(long int);    // Sets the clients flags to a new value
    long int addFlag(long int);     // Adds a flag to the client's flags
    long int remFlag(long int);     // Removes a flag from the client's current flags


    char *name;			// Player's Name
    int level;			// Player's level (1-12)
    long int exp;               // Player's experience
    long int gold;              // Gold on hand
    long int bank;              // Gold in the bank
    int hp;                     // Current Hit Points (health)
    int maxhp;                  // Maximum Hit Points
    int strength;               // Player's Strength
    int defense;                // Player's defensive strength
    int armor;                  // Number for the player's armor
    int weapon;                 // Number for the player's weapon
    int forest_fights;          // Amount of forest fights left today
    int player_fights;          // Amount of player<->player fights for today
    char *password;		// Player's encrypted password
    Pouch inventory;		// This contains their potions, etc.

    aClient *user;		// Pointer to the aClient this player is from
    Monster *fight;		// Pointer to the monster the player is currently fighting
    Monster *master;		// Pointer to the master the player is currently fighting
    aClient *battle;		// Pointer to the player this player is currently fighting

private:
    long int flags;		// Player's current flags
};

struct monster_ {
    monster_();
    monster_(monster_ *);
    ~monster_();
    char *name;    // The monster's name
    char *weapon;  // A name for their weapon. Doesn't have to be in weapons[]
    int strength;  // Their strength
    int gold;      // The gold you get when you kill them
    int exp;       // The experience you get when you kill them
    int hp;        // Their remaining hitpoints
    int maxhp;     // Their max hitpoints
    char *death;   // What is said when they die
};

#endif
