#ifndef POUCH_H
#define POUCH_H

class Pouch {
  public:

    Pouch(int h = 0, int s = 0, int d = 0);	// Default constructor

    // Access functions to get the number of each potion in inventory
    int Healing() { return healing; };
    int Strength() { return strength; };
    int Defense() { return defense; };
    int HP() { return hp; };

    // Modifiers to set the number of potions
    int setHealing (int h = 0) { healing = h; return Healing();};
    int setStrength (int s = 0) { strength = s; return Strength(); };
    int setDefense (int d = 0) { defense = d; return Defense();};
    int setHP (int h = 0) { hp = h; return HP(); };

    // Add one healing potion
    int incHealing() { return setHealing(Healing() + 1); };

    // Add one Strength potion
    int incStrength() { return setStrength(Strength() + 1); };

    // Add one Defense potion
    int incDefense() { return setDefense(Defense() + 1); };

    // Add one Max HP Potion
    int incHP() { return setHP(HP() + 1); };

    int decHealing() { return setHealing(Healing() - 1); };
    int decStrength() { return setStrength(Strength() - 1); };
    int decDefense() { return setDefense(Defense() - 1); };
    int decHP() { return setHP(HP() - 1); };

    void setInventory(Pouch *right) {	setHealing(right->Healing());
					setStrength(right->Strength());
					setDefense(right->Defense());
					setHP(right->HP());
				    };
    // Reset all potions to 0
    void reset() { 	setHealing(0); 	setStrength(0); 	setDefense(0);
			setHP(0);};

  private:
    // Potions
    int healing;
    int strength;
    int defense;
    int hp;
};

#endif
