# Emacs mode: -*- text -*-

# Spanish language file.
#
# IRC Services is copyright (c) 1996-2001 Andrew Church.
#     E-mail: <achurch@achurch.org>
# Parts copyright (c) 1999-2000 Andrew Kempe and others.
# This program is free but copyrighted software; see the file COPYING for
# details.

# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, please inform
# the Services developers.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Espaol (Spanish)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Dom
	Lun
	Mar
	Mie
	Jue
	Vie
	Sab
# %A
STRFTIME_DAYS_LONG
	Domingo
	Lunes
	Martes
	Miercoles
	Jueves
	Viernes
	Sabado
# %b
STRFTIME_MONTHS_SHORT
	Ene
	Feb
	Mar
	Abr
	May
	Jun
	Jul
	Ago
	Sep
	Oct
	Nov
	Dic
# %B
STRFTIME_MONTHS_LONG
	Enero
	Febrero
	Marzo
	Abril
	Mayo
	Junio
	Julio
	Agosto
	Septiembre
	Octubre
	Noviembre
	Diciembre


# "day", "hour", "minute", and "second" in singular and plural.
STR_DAY
	da
STR_DAYS
	das
STR_HOUR
	hora
STR_HOURS
	horas
STR_MINUTE
	minuto
STR_MINUTES
	minutos
STR_SECOND
	segundo
STR_SECONDS
	segundos


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	, 


# Various error messages.
USER_RECORD_NOT_FOUND
	Error Interno - imposible procesar comando.
UNKNOWN_COMMAND
	Comando desconocido %s.
UNKNOWN_COMMAND_HELP
	Comando desconocido %s.  Escriba /msg %s HELP para ayuda.
SYNTAX_ERROR
	Sintaxis: %s
MORE_INFO
	Escriba /msg %s HELP %s para mas informacin.
NO_HELP_AVAILABLE
	No existe ayuda disponible para %s.

BAD_EMAIL
	Direccin e-mail debe ser en el formato Usuario@ProveedorWeb.  No debes usar colores, negritas, subrayado, ni reverso, o alguno de estos caracteres: , : ; | \ " ( ) < >
BAD_URL
	URLs deben ser en el formato http://ProveedorWeb[:puerto]/... (o ftp://, etc.).
BAD_USERHOST_MASK
	Mscara debe ser en el formato Usuario@ProveedorWeb.
BAD_EXPIRY_TIME
	Fecha de expiracin invlida.

SERVICE_OFFLINE
	%s est actualmente fuera de servicio.
READ_ONLY_MODE
	Noticia: Los Servicios estn en modo de leer solamente ; cambios no seran grabados!
PASSWORD_INCORRECT
	Contrasea incorrecta.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Acceso negado.
PERMISSION_DENIED
	Permiso negado.

MORE_OBSCURE_PASSWORD
	Favor trate de nuevo con una contrasea mas difcil. Contraseas deben ser de 5 caracteres mnimo,no debe ser algo fcil de descifrar (ejemplo. su verdadero nombre o su apodo), tampoco debe contener espacios.
PASSWORD_TRUNCATED
	Noticia:  Su contrasea a sido limitada a %d caracteres.

NICK_NOT_REGISTERED
	Su apodo no est registrado.
NICK_NOT_REGISTERED_HELP
	Su apodo no est registrado.  Escriba /msg %s HELP para mas informacin de como registrar su apodo.
NICK_X_NOT_REGISTERED
	Apodo %s no est registrado.
NICK_X_NOT_IN_USE
	Apodo %s no est en uso en este momento.
NICK_X_FORBIDDEN
	Apodo %s no puede ser registrado o utilizado.
NICK_X_SUSPENDED
	Apodo %s est suspendido y no se puede utilizar o identificarse por l.
NICK_X_SUSPENDED_MEMOS
	Apodo %s est suspendido y no puede recibir mensajes.
NICK_IDENTIFY_REQUIRED
	Identificacin con su contrasea se requiere para usar ese comando.
	Vuelva a intentar despus de escribir /msg %s IDENTIFY Contrasea.
NICK_X_NOT_ON_CHAN_X
	Apodo %s no est actualmente en el canal %s.

CHAN_X_NOT_REGISTERED
	Canal %s no est registrado.
CHAN_X_NOT_IN_USE
	Canal %s no est en uso actualmente.
CHAN_X_FORBIDDEN
	Canal %s no puede ser registrado o utilizado.
CHAN_X_SUSPENDED
	Canal %s est suspendido y no se puede utilizar o identificarse por l.
CHAN_X_SUSPENDED_MEMOS
	Canal %s est suspendido y no puede recibir mensajes.
CHAN_IDENTIFY_REQUIRED
	Identificacin con su contrasea se requiere para usar ese comando.
	Vuelva a intentar despus de escribir /msg %s IDENTIFY Contrasea.

SERV_X_NOT_FOUND
	Servidor %s no encontrado.

EXPIRES_NONE
	no expira
EXPIRES_SOON
	expira en la siguiente actualizacin de la base de datos
EXPIRES_M
	expira en %d minutos
EXPIRES_1M
	expira en %d minuto
EXPIRES_HM
	expira en %d horas, %d minutos
EXPIRES_H1M
	expira en %d horas, %d minutos
EXPIRES_1HM
	expira en %d hora, %d minutos
EXPIRES_1H1M
	expira en %d hora, %d minuto
EXPIRES_D
	expira en %d das
EXPIRES_1D
	expira en %d da

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Este apodo pertence a otra persona.  Favor de escoger otro.
	(Si este es su apodo, escriba /msg %s IDENTIFY Contrasea.)
NICK_IS_SECURE
	Este apodo est registrado y protegido.  Si es su apodo
	Escriba /msg %s IDENTIFY Contrasea.  De lo contrario,
	favor de escoger un apodo diferente.
NICK_MAY_NOT_BE_USED
	Este apodo no puede utilizarse. Favor de escoger otro.
DISCONNECT_IN_1_MINUTE
	Si no cambia dentro de un minuto, ser desconectado.
DISCONNECT_IN_20_SECONDS
	Si no cambia dentro de 20 segundos, ser desconectado.
DISCONNECT_NOW
	Este apodo ha sido registrado; no lo puedes utilizar. Favor
	de escoger otro apodo antes de reconectar.
FORCENICKCHANGE_IN_1_MINUTE
	Si no cambias dentro de un minuto, cambiar tu apodo.
FORCENICKCHANGE_IN_20_SECONDS
	Si no cambias dentro de 20 segundos, cambiar tu apodo.
FORCENICKCHANGE_NOW
	Este apodo ha sido registrado; no lo puedes utilizar.
	Su apodo est ahra siendo cambiado a %s.
NICK_EXPIRES_SOON
	Nota: La registracin de su apodo expirar en %d %s.  Si usted desea continuar utilizando su apodo, favor de identificarse a %s Escribiendo: /msg %s IDENTIFY Contrasea
NICK_EXPIRED
	Nota: La registracin de su apodo ha expirado.  Favor de re-registrar su apodo si usted quiere continuar utilizandolo.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER Contrasea [Correo-Electrnico]
NICK_REGISTER_REQ_EMAIL_SYNTAX
	REGISTER Contrasea Correo-Electrnico
NICK_REGISTRATION_DISABLED
	Lo sentimos, el registro de apodos est temporaralmente deshabilitado.
NICK_REGISTRATION_FAILED
	Lo sentimos, la registracin fall.
NICK_REG_PLEASE_WAIT
	Favor de esperar %d segundos antes de utilizar nuevamente el comando REGISTER.
NICK_CANNOT_BE_REGISTERED
	Apodo %s no puede ser registrado.
NICK_ALREADY_REGISTERED
	Apodo %s ya est registrado!
NICK_REGISTERED
	Apodo %s registrado bajo tu cuenta: %s
NICK_PASSWORD_IS
	Tu contrasea es %s - recuerda esto para uso posterior.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY Contrasea
NICK_IDENTIFY_FAILED
	Lo sentimos, la identificacin fall.
NICK_IDENTIFY_SUCCEEDED
	Contrasea aceptada - ahra se le ha reconocido.

# DROP responses
NICK_DROP_SYNTAX
	DROP
NICK_DROP_DISABLED
	Lo sentimos, la cancelacin de apodos est temporalmente deshabilitada.
NICK_DROPPED
	Su apodo ha sido cancelado.
NICK_X_DROPPED
	Apodo %s ha sido cancelado.

# SET responses
NICK_SET_SYNTAX
	SET Opcin Parmetros
NICK_SET_SERVADMIN_SYNTAX
	SET [Apodo] Opcin Parmetros
NICK_SET_DISABLED
	Lo sentimos, la configuracin de opciones del apodo est temporalmente deshabilitada.
NICK_SET_UNKNOWN_OPTION
	Opcin SET desconocida %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Opcin SET %s desconocida, o su apodo no est registrado.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Lo sentimos, la contrasea no se pudo cambiar.
NICK_SET_PASSWORD_CHANGED
	Contrasea cambiada.
NICK_SET_PASSWORD_CHANGED_TO
	Contrasea cambiada a %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE Nmero
NICK_SET_LANGUAGE_UNKNOWN
	Nmero %d de lenguaje desconocido.  Escriba /msg %s HELP SET LANGUAGE para una lista de lenguajes disponibles.
NICK_SET_LANGUAGE_CHANGED
	Lenguaje cambiado a Espaol.

# SET URL responses
NICK_SET_URL_CHANGED
	URL para %s cambiado a %s.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	Correo electrnico (EMAIL) para %s cambiada a %s.

# SET KILL responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Proteccin de KILL ahra Activada (ON).
NICK_SET_KILL_QUICK
	Proteccin de KILL ahra Activada (ON), con una espera reducida.
NICK_SET_KILL_IMMED
	Proteccin de KILL Activada (ON), sin espera reducida.
NICK_SET_KILL_IMMED_DISABLED
	La opcin IMMED no est disponible en esta red.
NICK_SET_KILL_OFF
	Proteccin de KILL ahra Desactivada (OFF).

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Opcin SECURE ahra Activada (ON).
NICK_SET_SECURE_OFF
	Opcin SECURE ahra Desactivada (OFF).

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Opcin PRIVATE ahra Activada (ON).
NICK_SET_PRIVATE_OFF
	Opcin PRIVATE ahra Desactivada (OFF).

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Su correo electrnico ser ahra ocultada en la opcin de %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	Su correo electrnico ser ahra visible en la opcin de %s INFO.
NICK_SET_HIDE_MASK_ON
	Su ltima mscara de Usuario@ProveedorWeb ser ahra ocultada en la opcin de %s INFO.
NICK_SET_HIDE_MASK_OFF
	Su ltima mscara de Usuario@ProveedorWeb ser ahra visible en la opcin de %s INFO.
NICK_SET_HIDE_QUIT_ON
	Su ltimo mensaje de salida ser ahra ocultado en la opcin de %s INFO.
NICK_SET_HIDE_QUIT_OFF
	Su ltimo mensaje de salida ser ahra visible en la opcin de %s INFO.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [Apodo] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	Apodo %s No expirar.
NICK_SET_NOEXPIRE_OFF
	Apodo %s Si expirar.

# UNSET responses
NICK_UNSET_SYNTAX
	UNSET {URL | EMAIL}
NICK_UNSET_SYNTAX_REQ_EMAIL
	UNSET URL
NICK_UNSET_URL
	URL para %s est ahra Indefinido (Unset).
NICK_UNSET_EMAIL
	Correo electrnico (EMAIL) para %s est ahra Indefinido (Unset).
NICK_UNSET_EMAIL_BAD
	Imposible remover su correo electrnico (EMAIL).
NICK_UNSET_EMAIL_OTHER_BAD
	Imposible remover la direccion electrnica (e-mail) relacionada a su apodo.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [Mscara]
NICK_ACCESS_ALREADY_PRESENT
	Mscara %s ya existe en su lista de acceso.
NICK_ACCESS_REACHED_LIMIT
	Lo sentimos, solamente puede tener %d entradas de acceso para su apodo.
NICK_ACCESS_ADDED
	%s aadido a su lista de acceso.
NICK_ACCESS_NOT_FOUND
	%s no fue encontrado en su lista de acceso.
NICK_ACCESS_DELETED
	%s removido de su lista de acceso.
NICK_ACCESS_LIST
	Lista de acceso:
NICK_ACCESS_LIST_X
	Lista de acceso para %s:

# LINK responses
NICK_LINK_SYNTAX
	LINK Apodo Contrasea
NICK_LINK_DISABLED
	El comando LINK no est disponible.
NICK_LINK_FAILED
	Lo sentimos, liga de apodo fall.
NICK_NO_LINK_SAME
	No puede ligar su apodo actual!
NICK_LINK_CIRCULAR
	Imposible ligar a apodo %s: liga circular detectada.
NICK_LINK_TOO_DEEP
	No puede crear una liga mayor de %d niveles de profundidad.
NICK_LINK_TOO_MANY_CHANNELS
	Imposible ligar el apodo %s: demasiados canales registrados (combinacin mxima %d).
NICK_LINKED
	Su apodo ha sido ligado a %s.

# UNLINK responses
NICK_UNLINK_SYNTAX
	UNLINK [Apodo Contrasea]
NICK_UNLINK_FAILED
	Lo sentimos, la liga no pudo ser removida.
NICK_NOT_LINKED
	Su apodo no est ligado.
NICK_UNLINKED
	Su apodo ha sido desligado de %s.
NICK_X_NOT_LINKED
	Apodo %s no est ligado.
NICK_X_UNLINKED
	Apodo %s ha sido desligado de %s.

# LISTLINKS responses
NICK_LISTLINKS_SYNTAX
	LISTLINKS Apodo [ALL]
NICK_LISTLINKS_HEADER
	Lista de apodos ligados a %s:
NICK_LISTLINKS_FOOTER
	%d apodos ligados.
NICK_X_IS_LINKED
	    %s
NICK_X_IS_LINKED_VIA_X
	    %-20s (via %s)

# INFO responses
NICK_INFO_SYNTAX
	INFO Apodos [ALL]
NICK_INFO_REALNAME
	%s es %s
NICK_INFO_ADDRESS
	ltima direccin vista: %s
NICK_INFO_ADDRESS_ONLINE
	   Est en lnea usando: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s est actualmente en lnea.
NICK_INFO_TIME_REGGED
	  Fecha de registro: %s
NICK_INFO_LAST_SEEN
	   Se le vio por ltima vez en: %s
NICK_INFO_LAST_QUIT
	ltimo mensaje de salida: %s
NICK_INFO_URL
	              URL: %s
NICK_INFO_EMAIL
	   Correo electrnico: %s
NICK_INFO_OPTIONS
	          Opciones: %s
NICK_INFO_LINKED_TO
	        Ligado a: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Proteccin de KILL
NICK_INFO_OPT_SECURE
	Seguro
NICK_INFO_OPT_PRIVATE
	Privado
NICK_INFO_OPT_NONE
	Ninguna
NICK_INFO_NO_EXPIRE
	Este apodo no expirar.
NICK_INFO_SUSPEND_DETAILS
	Suspendido por %s en %s (%s).
NICK_INFO_SUSPEND_REASON
	Razn: %s
NICK_INFO_SHOW_ALL
	Para mas informacin, escriba: /msg %s INFO %s ALL

# LISTCHANS responses
NICK_LISTCHANS_SYNTAX
	LISTCHANS
NICK_LISTCHANS_SERVADMIN_SYNTAX
	LISTCHANS [Apodo]
NICK_LISTCHANS_NONE
	%s no ha registrado canal alguno.
NICK_LISTCHANS_HEADER
	Canales registrados por %s:
NICK_LISTCHANS_ENTRY
	    %s
NICK_LISTCHANS_END
	Fin del listado (%d canales registrados).

# LIST responses
NICK_LIST_SYNTAX
	LIST Patrn
NICK_LIST_SERVADMIN_SYNTAX
	LIST Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
NICK_LIST_HEADER
	Lista de entradas asociadas a %s:
NICK_LIST_RESULTS
	Fin del listado - %d/%d asociaciones visibles.

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER Apodo [Contrasea]
NICK_NO_RECOVER_SELF
	No puedes recobrarte a ti mismo!
NICK_RECOVERED
	El usuario que reclamaba su apodo ha sido desconectado.
	Escriba /msg %s RELEASE %s para recuperarlo ahra y no esperar a un minuto.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE Apodo [Contrasea]
NICK_RELEASE_NOT_HELD
	Apodo %s no est siendo retenido.
NICK_RELEASED
	Servicios' Espere su apodo ha sido liberado.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST Apodo [Contrasea]
NICK_NO_GHOST_SELF
	No puedes usar el comando GHOST en ti mismo!
NICK_GHOST_KILLED
	El fantasma con su apodo ha sido desconectado.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS Apodo
NICK_GETPASS_UNAVAILABLE
	Comando GETPASS no est disponible porque esta red est usando encripcin.
NICK_GETPASS_PASSWORD_IS
	Contrasea para %s es %s.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID Apodo
NICK_FORBID_SUCCEEDED
	Apodo %s est ahra prohibido.
NICK_FORBID_FAILED
	No se pudo prohibir el apodo %s!

# SUSPEND responses
NICK_SUSPEND_SYNTAX
	SUSPEND [+Expiracin] Apodo Razn
NICK_SUSPEND_SUCCEEDED
	Apodo %s, y todos los apodos con la misma raiz, han sido suspendidos.
NICK_SUSPEND_ALREADY_SUSPENDED
	Apodo %s ya est suspendido.

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND Apodo
NICK_UNSUSPEND_SUCCEEDED
	Apodo %s ya no est suspendido.
NICK_SUSPEND_NOT_SUSPENDED
	Apodo %s no est suspendido.

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Estatus de operador de canal automtico
CHAN_LEVEL_AUTOVOICE
	Modo +v automtico
CHAN_LEVEL_AUTODEOP
	No es permitido obtener estatus de operador de canal
CHAN_LEVEL_AUTODEOP_HALFOP
	No es permitido obtener estatus de Operador/MedioOP de canal
CHAN_LEVEL_NOJOIN
	No puede entrar al canal si est en modo RESTRICTED (RESTRINGIDO)
CHAN_LEVEL_INVITE
	Permitido usar el comando INVITE
CHAN_LEVEL_AKICK
	Permitido usar el comando AKICK
CHAN_LEVEL_SET
	Permitido usar el comando SET (excluidos FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Permitido usar el comando CLEAR
CHAN_LEVEL_UNBAN
	Permitido usar el comando UNBAN
CHAN_LEVEL_OPDEOP
	Permitido usar los comandos OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Permitido ver la lista de acceso
CHAN_LEVEL_ACCESS_CHANGE
	Permitido modificar la lista de acceso
CHAN_LEVEL_MEMO
	Permitido alistar/leer los mensajes del canal (list/read)
CHAN_LEVEL_VOICE
	Permitido usar los comandos VOICE/DEVOICE
CHAN_LEVEL_AUTOHALFOP
	Estatus MedioOP (+h) automtico
CHAN_LEVEL_HALFOP
	Permitido usar los comandos HALFOP/DEHALFOP (MitadOP/No-MitadOP)
CHAN_LEVEL_AUTOPROTECT
	Estatus de Proteccin de canal (+a) automtico
CHAN_LEVEL_PROTECT
	Permitido usar los comandos PROTECT/DEPROTECT (Proteger/desproteger)

# Automatic responses
CHAN_IS_REGISTERED
	Este canal ha sido registrado con %s.
CHAN_NOT_ALLOWED_OP
	Usted no puede obtener estatus de operador en el canal %s.
CHAN_MAY_NOT_BE_USED
	Este canal no puede ser utilizado.
CHAN_NOT_ALLOWED_TO_JOIN
	No le es permitido ingresar a este canal.

# Multi-purpose responses
CHAN_BOUNCY_MODES
	Lo sentimos, el comando %s est temporaralmente deshabilitado.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER Canal Contrasea Descripccin
CHAN_REGISTER_DISABLED
	Lo sentimos, la registracin de canales est temporalmente deshabilitada.
CHAN_REGISTER_NOT_LOCAL
	Canales locales no pueden ser registrados.
CHAN_MUST_REGISTER_NICK
	Usted debe registrar su apodo primeramente.  Escriba /msg %s HELP para informacin sobre como registrar apodos.
CHAN_MUST_IDENTIFY_NICK
	Favor de identificarse con %s primeramente, usando el comando:
	/msg %s IDENTIFY Contrasea
CHAN_MAY_NOT_BE_REGISTERED
	Canal %s no puede ser registrado.
CHAN_ALREADY_REGISTERED
	Canal %s ya est registrado!
CHAN_MUST_BE_CHANOP
	Usted debe ser operador del canal para poder registrarlo.
CHAN_REACHED_CHANNEL_LIMIT
	Lo sentimos, usted ya ha alcazado su lmite de %d canales.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Lo sentimos, usted ya ha excedido su lmite de %d canales.
CHAN_REGISTRATION_FAILED
	Lo sentimos, la registracin fall.
CHAN_REGISTERED
	Canal %s registrado bajo su apodo: %s
CHAN_PASSWORD_IS
	La contrasea de su canal es %s - recuerdela para uso posterior.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY Canal Contrasea
CHAN_IDENTIFY_FAILED
	Lo sentimos, la identificacin fall.
CHAN_IDENTIFY_SUCCEEDED
	Contrasea acceptada - usted ahra tiene acceso a nivel de fundador con %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP Canal
CHAN_DROP_DISABLED
	Lo sentimos, la cancelacin de registro de canal est temporalmente deshabilitada.
CHAN_DROPPED
	Canal %s ha sido cancelado.

# SET responses
CHAN_SET_SYNTAX
	SET Canal Opcin Parmetros
CHAN_SET_DISABLED
	Lo sentimos, el ajuste de opciones de canal est temporalmente deshabilitada.
CHAN_SET_UNKNOWN_OPTION
	Opcin SET %s desconocida.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s tiene demasiados canales registrados.
CHAN_FOUNDER_CHANGED
	Fundador de %s cambiado a %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Sucesor para %s cambiado a %s.
CHAN_SUCCESSOR_IS_FOUNDER
	Usted no puede convertir al fundador de un canal tambin en sucesor.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Lo sentimos, fue imposible establecer la contrasea.
CHAN_PASSWORD_CHANGED
	Contrasea para %s cambiada.
CHAN_PASSWORD_CHANGED_TO
	Contrasea para %s cambiada a %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Descripcin de %s cambiada a %s.

# SET URL responses
CHAN_URL_CHANGED
	URL para %s cambiado a %s.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	Correo electrnico para %s cambiado a %s.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Mensaje de entrada para %s cambi.

# SET TOPIC responses
CHAN_SET_TOPIC_FAILED
	Lo sentimos, fue imposible establecer el tpico.

# SET MLOCK responses
CHAN_SET_MLOCK_KEY_REQUIRED
	Parmetro requerido para MLOCK +k.
CHAN_SET_MLOCK_LIMIT_REQUIRED
	Parmetro requerido para MLOCK +l.
CHAN_SET_MLOCK_LIMIT_POSITIVE
	Parmetro para MLOCK +l debe ser un nmero positivo.
CHAN_SET_MLOCK_MODE_REG_BAD
	Modo +%c es siempre establecido en canales registrados, y no puede ser usado con MLOCK (Opcin Candado).
CHAN_SET_MLOCK_MODE_F_BAD
	Modo +f no puede ser fijado con la opcin candado.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Modo con caractr %c es desconocido e ignorado.
CHAN_MLOCK_CHANGED
	Modo de candado en canal %s cambiado a %s.
CHAN_MLOCK_REMOVED
	Modo de candado en canal %s removido.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET Canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Opcin de retencin de tpico ahra ACTIVADA (ON).
CHAN_SET_KEEPTOPIC_OFF
	Opcin de retencin de tpico ahra DESACTIVADA (OFF).

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET Canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Opcin de candado en tpico ACTIVADA (ON).
CHAN_SET_TOPICLOCK_OFF
	Opcin de candado en tpico DESACTIVADA (OFF).

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET Canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Opcin de privacidad ACTIVADA (ON).
CHAN_SET_PRIVATE_OFF
	Opcin de privacidad DESACTIVADA (OFF).

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET Canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Opcin de SecureOPs (OPs Seguros) ACTIVADA (ON).
CHAN_SET_SECUREOPS_OFF
	Opcin de SecureOPs (OPs Seguros) DESACTIVADA (OFF).

# SET LEAVEOPS responses
CHAN_SET_LEAVEOPS_SYNTAX
	SET Canal LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	Opcin de LeaveOPs (OPs Dejados) ACTIVADA (ON).
CHAN_SET_LEAVEOPS_OFF
	Opcin de LeaveOPs (OPs Dejados) DESACTIVADA (OFF).

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET Canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Opcin de acceso restringido ACTIVADA (ON).
CHAN_SET_RESTRICTED_OFF
	Opcin de acceso restringido DESACTIVADA (OFF).

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET Canal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Opcin Secure (Seguro) ahra ACTIVADA (ON).
CHAN_SET_SECURE_OFF
	Opcin Secure (Seguro) ahra DESACTIVADA (OFF).

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET Canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Opcin de Op-notice (Nota a OPs) ahra ACTIVADA (ON).
CHAN_SET_OPNOTICE_OFF
	Opcin de Op-notice (Nota a OPs) ahra DESACTIVADA (OFF).

# SET ENFORCE responses
CHAN_SET_ENFORCE_SYNTAX
	SET Canal ENFORCE {ON | OFF}
CHAN_SET_ENFORCE_ON
	Opcin de Enforce (Implementar) est ahra ACTIVADA (ON).
CHAN_SET_ENFORCE_OFF
	Opcin de Enforce (Implementar) est ahra DESACTIVADA (OFF).

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET Canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	Canal %s NO expirar.
CHAN_SET_NOEXPIRE_OFF
	Canal %s SI expirar.

# UNSET responses
CHAN_UNSET_SYNTAX
	UNSET Canal {SUCCESSOR | URL | EMAIL | ENTRYMSG}
CHAN_SUCCESSOR_UNSET
	Sucesor para %s ahra indefinido.
CHAN_URL_UNSET
	URL para %s ahra indefinido.
CHAN_EMAIL_UNSET
	Correo electrnico (EMAIL) para %s ahra indefinida.
CHAN_ENTRY_MSG_UNSET
	Mensaje de entrada para %s ahra indefinido.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS Canal {ADD | DEL | LIST | COUNT} [Apodo [Nivel] | Lista-De-Entrada]
CHAN_ACCESS_DISABLED
	Lo sentimos, modificacin a la lista de acceso de canal est temporalmente deshabilitada.
CHAN_ACCESS_LEVEL_NONZERO
	Nivel de acceso debe ser diferente a cero.
CHAN_ACCESS_LEVEL_RANGE
	Nivel de acceso debe estar entre %d y %d.
CHAN_ACCESS_NICKS_ONLY
	Lista de acceso de canal debera contener solamente apodos registrados.
CHAN_ACCESS_REACHED_LIMIT
	Lo sentimos, usted solamente puede tener %d entradas de acceso en un canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Nivel de acceso para %s en %s no cambio de %d.
CHAN_ACCESS_LEVEL_CHANGED
	Nivel de acceso para %s en %s fue cambiado a %d.
CHAN_ACCESS_ADDED
	%s agregado a la lista de acceso de %s con nivel %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Entrada desconocida (#%d) en la lista de acceso de %s.
CHAN_ACCESS_NOT_FOUND
	%s no fue encontrado en la lista de acceso de %s.
CHAN_ACCESS_NO_MATCH
	No entrada alguna en la lista de acceso de %s.
CHAN_ACCESS_DELETED
	%s borrado de la lista de acceso de %s.
CHAN_ACCESS_DELETED_ONE
	Borrada 1 entrada de la lista de acceso de %s.
CHAN_ACCESS_DELETED_SEVERAL
	Borradas %d entradas de la lista de acceso de %s.
CHAN_ACCESS_LIST_EMPTY
	La lista de acceso de %s est vaca.
CHAN_ACCESS_LIST_HEADER
	Lista de acceso para %s:
	  Nm   Niv  Apodo
CHAN_ACCESS_LIST_FORMAT
	  %3d  %4d  %s%s%s%s
CHAN_ACCESS_COUNT
	La lista de acceso de %s tiene %d entradas.

# XOP (AOP/SOP/VOP) responses
CHAN_SOP_SYNTAX
	SOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_AOP_SYNTAX
	AOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_HOP_SYNTAX
	HOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_VOP_SYNTAX
	VOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_XOP_ADDED
	%s agregado a la lista de %s %s.
CHAN_XOP_LEVEL_CHANGED
	%s movido a la lista de %s %s.
CHAN_XOP_LEVEL_UNCHANGED
	%s ya est en la lista de %s %s.
CHAN_XOP_NICKS_ONLY
	Las listas de SOP, AOP, y VOP solo pueden contener apodos registrados.
CHAN_XOP_NICKS_ONLY_HOP
	Las listas de SOP, AOP, HOP, y VOP solo pueden contener apodos registrados.
CHAN_XOP_REACHED_LIMIT
	Lo sentimos, el nmero de entradas en sus listas de SOP, AOP y VOP
	no puede sobrepasar mas de %d entradas.  Lmite excedido.
CHAN_XOP_REACHED_LIMIT_HOP
	Lo sentimos, el nmero de entradas en sus listas de SOP, AOP, HOP y VOP
	no puede sobrepasar mas de %d entradas.  Lmite excedido.
CHAN_XOP_NOT_FOUND
	%s no fue encontrado en la lista de %s %s.
CHAN_XOP_NO_SUCH_ENTRY
	Entrada desconocida (#%d) en la lista de %s %s.
CHAN_XOP_NO_MATCH
	No entrada alguna en la lista de %s %s.
CHAN_XOP_DELETED
	%s borrado de la lista de %s %s.
CHAN_XOP_DELETED_ONE
	Borrada 1 entrada de la lista de %s %s.
CHAN_XOP_DELETED_SEVERAL
	Borrada %d entradas de la lista de %s %s.
CHAN_XOP_LIST_EMPTY
	La lista de %s %s est vaca.
CHAN_XOP_LIST_HEADER
	Lista de %s para %s:
	  Nm   Apodo
CHAN_XOP_LIST_FORMAT
	  %3d   %s%s%s%s
CHAN_XOP_COUNT
	La lista de %s %s tiene %d entradas.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK Canal {ADD | DEL | LIST | VIEW | ENFORCE | COUNT} [Mscara | Lista]
CHAN_AKICK_DISABLED
	Lo sentimos, modificacin a la lista de pateo automtico de canal est temporalmente deshabilitada.
CHAN_AKICK_ALREADY_EXISTS
	%s ya existe en la lista de pateo automtico de %s.
CHAN_AKICK_REACHED_LIMIT
	Lo sentimos, usted solo puede tener %d mscaras de pateo automtico en un canal.
CHAN_AKICK_ADDED
	%s agregado a la lista de pateo automtico de %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Entrada desconocida (#%d) en la lista de pateo automtico de %s.
CHAN_AKICK_NOT_FOUND
	%s no se encuentra en la lista de pateo automtico de %s.
CHAN_AKICK_NO_MATCH
	No entrada alguna en la lista de pateo automtico de %s.
CHAN_AKICK_DELETED
	%s borrado de la lista de pateo automtico de %s.
CHAN_AKICK_DELETED_ONE
	Borrada 1 entrada de la lista de pateo automtico de %s.
CHAN_AKICK_DELETED_SEVERAL
	Borradas %d entradas de la lista de pateo automtico de %s.
CHAN_AKICK_LIST_EMPTY
	Lista de pateo automtico de %s est vaca.
CHAN_AKICK_LIST_HEADER
	Lista de pateo automtico para %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s%s
CHAN_AKICK_VIEW_FORMAT
	  %3d %s (por %s)
	    %s
CHAN_AKICK_ENFORCE_DONE
	Implementacin de auto pateo para %s completado; %d usuarios fueron afectados.
CHAN_AKICK_COUNT
	%s tiene %d entradas en su lista de Auto Pateo.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS Canal {SET | DIS[ABLE] | LIST | RESET} [Articulo [Nivel]]
CHAN_LEVELS_RANGE
	Nivel debe de estar entre %d y %d.
CHAN_LEVELS_CHANGED
	Nivel para %s en canal %s cambiado a %d.
CHAN_LEVELS_UNKNOWN
	Opcin %s desconocida.  Escriba /msg %s HELP LEVELS DESC para una lista de opciones vlidas.
CHAN_LEVELS_DISABLED
	%s deshabilitado en canal %s.
CHAN_LEVELS_LIST_HEADER
	Configuracin de nivel de acceso para canal %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (deshabilitado)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (fundador solamente)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Niveles de acceso para %s reconfigurados a los niveles originales.

# INFO responses
CHAN_INFO_SYNTAX
	INFO Canal [ALL]
CHAN_INFO_HEADER
	Informacin del canal %s:
CHAN_INFO_FOUNDER
	        Fundador: %s (%s)
CHAN_INFO_NO_FOUNDER
	        Fundador: %s
CHAN_INFO_SUCCESSOR
	      Sucesor: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	      Sucesor: %s
CHAN_INFO_DESCRIPTION
	    Descripcin: %s
CHAN_INFO_ENTRYMSG
	  Mensaje de Entrada: %s
CHAN_INFO_TIME_REGGED
	     Registrado: %s
CHAN_INFO_LAST_USED
	      ltimo uso: %s
CHAN_INFO_LAST_TOPIC
	     ltimo tpico: %s
CHAN_INFO_TOPIC_SET_BY
	   Tpico ajustado por: %s
CHAN_INFO_URL
	            URL: %s
CHAN_INFO_EMAIL
	 Correo electrnico: %s
CHAN_INFO_OPTIONS
	        Opciones: %s
CHAN_INFO_OPT_PRIVATE
	Privado
CHAN_INFO_OPT_KEEPTOPIC
	Retencin de tpico
CHAN_INFO_OPT_TOPICLOCK
	Candado en tpico
CHAN_INFO_OPT_SECUREOPS
	OPs Seguros
CHAN_INFO_OPT_LEAVEOPS
	OPs Dejados
CHAN_INFO_OPT_RESTRICTED
	Acceso restringido
CHAN_INFO_OPT_SECURE
	Seguro
CHAN_INFO_OPT_OPNOTICE
	Nota a OPs
CHAN_INFO_OPT_ENFORCE
	Implementar
CHAN_INFO_OPT_NONE
	Ninguna
CHAN_INFO_MODE_LOCK
	      Modo de candado: %s
CHAN_INFO_NO_EXPIRE
	Este canal no expirar.
CHAN_INFO_SUSPEND_DETAILS
	Suspendido por %s en %s (%s).
CHAN_INFO_SUSPEND_REASON
	Razn: %s
CHAN_INFO_SHOW_ALL
	Para mas informacin, Escriba: /msg %s INFO %s ALL

# LIST responses
CHAN_LIST_SYNTAX
	LIST Patrn
CHAN_LIST_SERVADMIN_SYNTAX
	LIST Patrn [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	Lista de entradas relacionadas con %s:
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Fin de la lista - %d/%d entradas mostradas.

# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE Canal
CHAN_INVITE_OK
	Invitando %s al canal %s.

# OP/DEOP/VOICE/DEVOICE responses
CHAN_OPVOICE_SYNTAX
	%s Canal Apodo
CHAN_OP_SUCCEEDED
	OPs dadas a %s en el canal %s.
CHAN_OP_FAILED
	Imposible dar OPs a %s en el canal %s.
CHAN_DEOP_SUCCEEDED
	OPs removidas de %s en el canal %s.
CHAN_DEOP_FAILED
	Imposible remover OPs de %s en el canal %s.
CHAN_VOICE_SUCCEEDED
	Voz dada a %s en el canal %s.
CHAN_VOICE_FAILED
	Imposible dar voz a %s en el canal %s.
CHAN_DEVOICE_SUCCEEDED
	Voz removida de %s en el canal %s.
CHAN_DEVOICE_FAILED
	Imposible remover voz de %s en el canal %s.
CHAN_HALFOP_SUCCEEDED
	Mitad-OPs dadas a %s en el canal %s.
CHAN_HALFOP_FAILED
	Imposible dar mitad-OPs a %s en el canal %s.
CHAN_DEHALFOP_SUCCEEDED
	Mitad-OPs removidas de %s en el canal %s.
CHAN_DEHALFOP_FAILED
	Imposible remover mitad-OPs de %s en el canal %s.
CHAN_PROTECT_SUCCEEDED
	Protegido %s en el canal %s.
CHAN_PROTECT_FAILED
	Imposible proteger a %s en el canal %s.
CHAN_DEPROTECT_SUCCEEDED
	Desprotegido %s en el canal %s.
CHAN_DEPROTECT_FAILED
	Imposible desproteger a %s en el canal %s.

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN Canal
CHAN_UNBANNED
	Usted ya no est bloqueado en %s.

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR Canal Opcin
CHAN_CLEARED_BANS
	Todos los bloqueos en el canal %s han sido removidos.
CHAN_CLEARED_EXCEPTIONS
	Todas las excepciones en el canal %s han sido removidas.
CHAN_CLEARED_MODES
	Todos los modos en el canal %s han sido borrados.
CHAN_CLEARED_OPS
	Modo +o ha sido desactivado en el canal %s.
CHAN_CLEARED_HALFOPS
	Modo +h ha sido desactivado en el canal %s.
CHAN_CLEARED_VOICES
	Modo +v ha sido desactivado en el canal %s.
CHAN_CLEARED_USERS
	Todos los usuarios han sido pateados del canal %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS Canal
CHAN_GETPASS_UNAVAILABLE
	Comando GETPASS no est disponible porque la red esta usando encripcin.
CHAN_GETPASS_PASSWORD_IS
	Contrasea para el canal %s es %s.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID Canal
CHAN_FORBID_SUCCEEDED
	Canal %s est ahra prohibido.
CHAN_FORBID_FAILED
	No fue posible prohibir el canal %s!

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND [+Expiracin] Canal Razn
CHAN_SUSPEND_SUCCEEDED
	Canal %s ha sido suspendido.
CHAN_SUSPEND_ALREADY_SUSPENDED
	Canal %s ya est suspendido.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND Canal
CHAN_UNSUSPEND_SUCCEEDED
	Suspensin del canal %s ha sido desactivada.
CHAN_SUSPEND_NOT_SUSPENDED
	Canal %s no est suspendido.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Usted tiene 1 nuevo mensaje.
MEMO_HAVE_NEW_MEMOS
	Usted tiene %d nuevos mensajes.
MEMO_TYPE_READ_LAST
	Escriba /msg %s READ LAST para leerlo.
MEMO_TYPE_READ_NUM
	Escriba /msg %s READ %d para leerlo.
MEMO_TYPE_LIST_NEW
	Escriba /msg %s LIST NEW para alistarlos.
MEMO_AT_LIMIT
	AVISO!: Usted ha alcanzado su nmero mximo de mensajes (%d).  No podr recibir mensajes nuevos hasta que borre algunos de los que ahra tiene.
MEMO_OVER_LIMIT
	AVISO!: Usted ha pasado su nmero mximo de mensajes (%d).  No podr recibir mensajes nuevos hasta que borre algunos de los que ahra tiene.
MEMO_NEW_MEMO_ARRIVED
	Usted tiene un nuevo mensaje de %s.
	Escriba /msg %s READ %d para leerlo.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Usted no tiene mensajes.
MEMO_X_HAS_NO_MEMOS
	%s no tine mensajes.
MEMO_DOES_NOT_EXIST
	Mensaje %d no existe!
MEMO_LIST_NOT_FOUND
	Ningn mensaje fue encontrado.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {Apodo | Canal} Texto
MEMO_SEND_DISABLED
	Lo sentimos, el envo de mensajes est temporalmente deshabilitado.
MEMO_SEND_PLEASE_WAIT
	Favor de esperar %d segundos antes de utilizar el comando SEND nuevamente.
MEMO_X_GETS_NO_MEMOS
	%s no puede recibir mensajes.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s tiene demasiados mensajes actualmente y no puede recibir mas.
MEMO_SENT
	Mensaje enviado a %s.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [Canal] [Lista | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Usted no tiene nuevos mensajes.
MEMO_X_HAS_NO_NEW_MEMOS
	%s no tiene nuevos mensajes.
MEMO_LIST_MEMOS
	Mensajes para %s.  Para leer, escriba: /msg %s READ Nmero
MEMO_LIST_NEW_MEMOS
	Nuevos mensajes para %s.  Para leer, escriba: /msg %s READ Nmero
MEMO_LIST_CHAN_MEMOS
	Mensajes para %s.  Para leer, escriba: /msg %s READ %s Nmero
MEMO_LIST_CHAN_NEW_MEMOS
	Nuevos mensajes para %s.  Para leer, escriba: /msg %s READ %s Nmero
MEMO_LIST_HEADER
	 Nm  Envia            Fecha/Hora
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [Canal] {list | LAST | NEW}
MEMO_HEADER
	Mensaje %d de %s (%s).  Para borrar, escriba: /msg %s DEL %d
MEMO_CHAN_HEADER
	Mensaje %d de %s (%s).  Para borrar, escriba: /msg %s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [Canal] {Nmero | Lista | ALL}
MEMO_DELETED_NONE
	Ningn mensaje fue borrado.
MEMO_DELETED_ONE
	Mensaje %d ha sido borrado.
MEMO_DELETED_SEVERAL
	%d mensajes han sido borrados.
MEMO_DELETED_ALL
	Todos sus mensajes han sido borrados.

# SET responses
MEMO_SET_SYNTAX
	SET Opcin Parmetros
MEMO_SET_DISABLED
	Lo sentimos, la opcin de ajuste de mensajes est temporalmente deshabilitada.
MEMO_SET_UNKNOWN_OPTION
	Opcin SET %s desconocida.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s le notificar ahra de sus mensajes cuando se conecte o cuando le sean enviados.
MEMO_SET_NOTIFY_LOGON
	%s le notificar ahra de sus mensajes cuando se conecte o cancele su modo /AWAY.
MEMO_SET_NOTIFY_NEW
	%s le notificar ahra de sus mensajes cuando le sean enviados.
MEMO_SET_NOTIFY_OFF
	%s no le eviar notificacin alguna de mensajes.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [Canal] Lmite
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [Apodo | Canal] {Lmite | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	No le es permitido cambiar su lmite de mensajes.
MEMO_SET_LIMIT_FORBIDDEN
	El lmite de mensajes para %s no puede ser cambiado.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Usted no puede ajustar su lmite de mensajes a mas de %d.
MEMO_SET_LIMIT_TOO_HIGH
	Usted no puede ajustar el lmite de mensajes para %s a mas de %d.
MEMO_SET_LIMIT_OVERFLOW
	Lmite de mensajes muy alto; lo hemos limitado a %d.
MEMO_SET_YOUR_LIMIT
	Su lmite de mensajes ha sido ajustado a %d.
MEMO_SET_YOUR_LIMIT_ZERO
	No le sera posible recibir mas mensajes.
MEMO_UNSET_YOUR_LIMIT
	Su lmite de mensajes ha sido dishabilitado.
MEMO_SET_LIMIT
	Lmite de mensajes para %s ajustado a %d.
MEMO_SET_LIMIT_ZERO
	Lmite de mensajes para %s ajustado a 0.
MEMO_UNSET_LIMIT
	Lmite de mensajes Dishabilitado para %s.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [Canal]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [Apodo | Canal]
MEMO_INFO_NO_MEMOS
	Actualmente usted no tiene mensajes.
MEMO_INFO_MEMO
	Actualmente usted tiene 1 mensaje.
MEMO_INFO_MEMO_UNREAD
	Actualmente usted tiene 1 mensaje, y no ha sido an ledo.
MEMO_INFO_MEMOS
	Actualmente usted tiene %d mensajes.
MEMO_INFO_MEMOS_ONE_UNREAD
	Actualmente usted tiene %d mensajes, de los cuales 1 no ha sido ledo.
MEMO_INFO_MEMOS_SOME_UNREAD
	Actualmente usted tiene %d mensajes, de los cuales %d no han sido ledos.
MEMO_INFO_MEMOS_ALL_UNREAD
	Actualmente usted tiene %d mensajes; ninguno ha sido ledo.
MEMO_INFO_LIMIT
	Su lmite de mensajes es %d.
MEMO_INFO_HARD_LIMIT
	Su lmite de mensajes es %d, y no puede ser cambiado.
MEMO_INFO_LIMIT_ZERO
	Su lmite de mensajes es 0; usted no recibir ningn nuevo mensaje.
MEMO_INFO_HARD_LIMIT_ZERO
	Su lmite de mensajes es 0; usted no recibir ningn nuevo mensaje.  Usted no puede cambiar este lmite.
MEMO_INFO_NO_LIMIT
	Usted no tiene lmite en la cantidad de mensajes que puede guardar.
MEMO_INFO_NOTIFY_OFF
	Usted no ser notificado de nuevos mensajes.
MEMO_INFO_NOTIFY_ON
	Usted ser notificado de nuevos mensajes al conectarse y cuandos estos lleguen.
MEMO_INFO_NOTIFY_RECEIVE
	Usted ser notificado cuando nuevos mensajes lleguen.
MEMO_INFO_NOTIFY_SIGNON
	%s es notificado de nuevos mensajes al conectarse.
MEMO_INFO_X_NO_MEMOS
	%s no tiene mensajes actualmente.
MEMO_INFO_X_MEMO
	%s actualmente tiene 1 mensaje.
MEMO_INFO_X_MEMO_UNREAD
	%s actualmente tiene 1 mensaje, y an est por ser ledo.
MEMO_INFO_X_MEMOS
	%s actualmente tiene %d mensajes.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s actualmente tiene %d mensajes, de los cuales 1 est an sin leer.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s actualmente tiene %d mensajes, de los cuales %d estn an sin leer.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s actualmente tiene %d mensajes; todos los cuales estn sin leer.
MEMO_INFO_X_LIMIT
	El lmite de mensages para %s es %d.
MEMO_INFO_X_HARD_LIMIT
	El lmite de mensajes para %s es %d, y no puede ser cambiado.
MEMO_INFO_X_NO_LIMIT
	%s no tiene lmite de mensajes.
MEMO_INFO_X_NOTIFY_OFF
	%s no es notificado de nuevos mensajes.
MEMO_INFO_X_NOTIFY_ON
	%s es notificado de nuevos mensajes al conectarse y cuando estos llegan.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s es notificado cuando llegan nuevos mensajes.
MEMO_INFO_X_NOTIFY_SIGNON
	%s es notificado de nuevos mensajes al conectarse.

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Los servicios no pueden cambiar modos.  Estn sus servidores configurados correctamente?
OPER_BOUNCY_MODES_U_LINE
	Los servicios no pueden cambiar modos.  Estn las U:lines de sus servidores configurados correctamente?
OPER_SKELETON_MODE
	Esta funcin no est disponible en modo de esqueleto (skeleton).

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL Notcia

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Opcin STATS %s desconocida.
OPER_STATS_RESET_USER_COUNT
	La cantidad mxima de usuarios ha sido re-ajustada.
OPER_STATS_CURRENT_USERS
	Usuarios actuales: %d (%d ops)
OPER_STATS_MAX_USERS
	Mximo de usuarios: %d (%s)
OPER_STATS_UPTIME_DHMS
	Servicios activos %d %s, %02d:%02d
# If >= 1 hour, hours and minutes; if < 1 hour, minutes and seconds
OPER_STATS_UPTIME_HM_MS
	Servicios activos %d %s, %d %s
OPER_STATS_BYTES_READ
	Octetos leidos: %5d kB
OPER_STATS_BYTES_WRITTEN
	Octetos enviados: %5d kB
OPER_STATS_USER_MEM
	Usuarios    : %6d registros, %5d kB
OPER_STATS_SERVER_MEM
	Servidor  : %6d registros, %5d kB
OPER_STATS_CHANNEL_MEM
	Canales : %6d registros, %5d kB
OPER_STATS_NICKSERV_MEM
	NickServ: %6d registros, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ: %6d registros, %5d kB
OPER_STATS_MEMOSERV_MEM
	MemoServ: %6d registros, %5d kB
OPER_STATS_STATSERV_MEM
	StatServ: %6d registros, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ: %6d registros, %5d kB
OPER_STATS_AKILL_COUNT
	Cantidad actual de AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Tiempo de expiracin de AKILL original: %d das
OPER_STATS_AKILL_EXPIRE_DAY
	Tiempo de expiracin de AKILL original: 1 da
OPER_STATS_AKILL_EXPIRE_HOURS
	Tiempo de expiracin de AKILL original: %d horas
OPER_STATS_AKILL_EXPIRE_HOUR
	Tiempo de expiracin de AKILL original: 1 hora
OPER_STATS_AKILL_EXPIRE_MINS
	Tiempo de expiracin de AKILL original: %d minutos
OPER_STATS_AKILL_EXPIRE_MIN
	Tiempo de expiracin de AKILL original: 1 minuto
OPER_STATS_AKILL_EXPIRE_NONE
	Tiempo de expiracin de AKILL original: No expira
OPER_STATS_SESSIONS_MEM
	Sesiones: %6d registros, %5d kB

# MODE responses
OPER_MODE_SYNTAX
	MODE Canal Modos

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES Canal [ALL]
OPER_CLEARMODES_DONE
	Modos binarios y bloqueos borrados del canal %s.
OPER_CLEARMODES_ALL_DONE
	Todos los modos borrados del canal %s.

# CLEARCHAN responses
OPER_CLEARCHAN_SYNTAX
	CLEARCHAN Canal
OPER_CLEARCHAN_DONE
	Todos los usuarios removidos del canal %s.

# KICK responses
OPER_KICK_SYNTAX
	KICK Canal Usuario Razn

# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [Apodos]
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD Apodo
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL Apodo
OPER_ADMIN_SKELETON
	Los servicios estn en modo de esqueleto; el comando ADMIN no est disponible.
OPER_ADMIN_EXISTS
	%s ya existe en la lista de Administradores de Servicios.
OPER_ADMIN_ADDED
	%s agregado a la lista de Administradores de Servicios.
OPER_ADMIN_TOO_MANY
	Demasiadas entradas (%d) en la lista de Administradores de Servicios; imposible agregar mas.
OPER_ADMIN_REMOVED
	%s removido de la lista de Administradores de Servicios.
OPER_ADMIN_NOT_FOUND
	%s no encontrado en la lista de administradores de Servicios.
OPER_ADMIN_LIST_HEADER
	Lista de Adminisradores de Servicios:

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [Apodo]
OPER_OPER_ADD_SYNTAX
	OPER ADD Apodo
OPER_OPER_DEL_SYNTAX
	OPER DEL Apodo
OPER_OPER_SKELETON
	Los servicios estn en modo de esqueleto; el comando OPER no est disponible.
OPER_OPER_EXISTS
	%s ya existe en la lista de Operadores de Servicios.
OPER_OPER_ADDED
	%s agregado a la lista de Operadores de Servicios.
OPER_OPER_TOO_MANY
	Demasiadas entradas (%d) en la lista de Operadores de Servicios; imposible agregar mas.
OPER_OPER_REMOVED
	%s removido de la lista de Operadores de Servicios.
OPER_OPER_NOT_FOUND
	%s no encontrado en la lista de Operadores de Servicios.
OPER_OPER_LIST_HEADER
	Lista de Operadores de Servicios:

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | COUNT} [[+Expiracin] Mscara [Razn]]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+Expiracin] Mscara Razn
OPER_AKILL_DEL_SYNTAX
	AKILL DEL Mscara
OPER_TOO_MANY_AKILLS
	La lista AKILL est llena!
OPER_AKILL_EXISTS
	%s ya existe en la lista AKILL.
OPER_AKILL_NO_NICK
	Nota: Las mscaras de AKILL no pueden contener apodos; asegurese que usted no ha incluido una porcin con apodo en su mscara.
OPER_AKILL_MASK_TOO_GENERAL
	La mscara de AKILL es demasiado general.
OPER_AKILL_ADDED
	%s agregado a lista AKILL.
OPER_AKILL_REMOVED
	%s removido de la lista AKILL.
OPER_AKILL_NOT_FOUND
	%s no encontrado en la lista AKILL.
OPER_AKILL_LIST_HEADER
	Lista AKILL actual:
# mscara, razn
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mscara, puesto-por, tiempo-fijado, expira, razn
OPER_AKILL_VIEW_FORMAT
	%s (por %s en %s; %s)
	    %s
OPER_AKILL_COUNT
	Existen %d mscaras de proveedor web en la lista AKILL.

# SU responses
OPER_SU_SYNTAX
	SU Contrasea
OPER_SU_NO_PASSWORD
	El comando SU no est disponible porque ninguna contrasea de super-usuario ha sido fijada.
OPER_SU_SUCCEEDED
	Usted ahra tiene privilegios de super-usuario con los servicios.
OPER_SU_FAILED
	Imposible verificar la contrasea.

# SET responses
OPER_SET_SYNTAX
	SET Opcin Ajuste
OPER_SET_IGNORE_ON
	Cdigo Ignore ser usado.
OPER_SET_IGNORE_OFF
	Cdigo Ignore no ser usado.
OPER_SET_IGNORE_ERROR
	Parmetro para IGNORE debe ser ON o OFF.
OPER_SET_READONLY_ON
	Los Servicios estn ahra en modo de Leer-solamente (Read-Only).
OPER_SET_READONLY_OFF
	Los Servicios estn ahra en modo de Leer-Escribir (Read-Write).
OPER_SET_READONLY_ERROR
	Parmetro para READONLY debe ser ON u OFF.
OPER_SET_DEBUG_ON
	Los Servicios estn ahra en modo debug (Deteccin De Errores).
OPER_SET_DEBUG_OFF
	Los Servicios estn ahra en modo de non-debug. 
OPER_SET_DEBUG_LEVEL
	Los Servicios estn ahra en modo de debug (nivel %d).
OPER_SET_DEBUG_ERROR
	Parmetro para DEBUG debe ser ON, OFF, o un nmero positivo.
OPER_SET_SUPASS_FAILED
	Imposible fijar la contrasea para el Super-Usuario de los servicios.
OPER_SET_SUPASS_OK
	Contrasea para el Super-Usuario de los servicios ha sido cambiada.
OPER_SET_SUPASS_NONE
	Contrasea para el Super-Usuario de los servicios ha sido dishabilitada.
OPER_SET_UNKNOWN_OPTION
	Opcin %s desconocida.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE Nombre-Del-Servidor [Razn]

# RAW responses
OPER_RAW_SYNTAX
	RAW Texto

# UPDATE responses
OPER_UPDATING
	Actualizando las bases de datos.

# LISTIGNORE responses
OPER_IGNORE_LIST
	Lista de Ignore de los servicios:
OPER_IGNORE_LIST_EMPTY
	La lista de Ignore est vaca.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES Apodo
OPER_KILLCLONES_UNKNOWN_NICK
	Imposible encontrar el usuario %s.

###########################################################################
#
# Session Limiting and Exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [Parmetros]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+Expiracin] Mscara Lmite Razn
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {Mscara | Lista}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE Nm Nuevo-Nm
OPER_EXCEPTION_DISABLED
	Limitado de sesiones est dishabilitado.
OPER_EXCEPTION_ALREADY_PRESENT
	Mscara %s ya est presente en la lista de excepcin.
OPER_EXCEPTION_TOO_MANY
	Lista de excepcin para lmite de sesiones est llena!
OPER_EXCEPTION_ADDED
	Lmite de sesiones para %s fijado a %d.
OPER_EXCEPTION_MOVED
	Excepcin para %s (#%d) movido al nmero %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Ninguna entrada (#%d) en la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_NOT_FOUND
	%s no encontrado en la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_NO_MATCH
	Ninguna entrada que concuerde en la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_DELETED
	%s borrado de la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_DELETED_ONE
	Borrada 1 entrada de la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_DELETED_SEVERAL
	Borradas %d entradas de la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_LIST_HEADER
	Lista de excepcin para lmite de sesiones actual:
# mscara, lmite
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Nm  Lmite  De
# mscara, fijado-por, fijado-a, expira, lmite, razn
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (por %s on %s; %s)
	    Lmite: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Lmite de sesin invlido; lmite debe ser al menos cero y no mayor que %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Mscara proveedor-web invlida. Solo mscaras de proveedor-web reales son vlidas ya que excepciones no son relacionadas a apodos o nombres de usuario.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST Lmite | VIEW Mscara-web}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST Lmite
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW Mscara-Web
OPER_SESSION_DISABLED
	Limitado de sesiones est dishabilitado.
OPER_SESSION_INVALID_THRESHOLD
	Valor lmite invlido; lmite debe ser un entero mayor que 1.
OPER_SESSION_NOT_FOUND
	%s no encontrado en la lista de sesin.
OPER_SESSION_LIST_HEADER
	Proveedores con al menos %d sesiones:
OPER_SESSION_LIST_COLHEAD
	Sesiones  Proveedor
# Lmite, Proveedor
OPER_SESSION_LIST_FORMAT
	%6d    %s
# provee, sesiones, lmite
OPER_SESSION_VIEW_FORMAT
	El proveedor %s actualmente tiene %d sesiones con un lmite de %d.

###########################################################################
#
# StatServ messages
#
############################################################################

# General SERVERS responses
STAT_SERVERS_REMOVE_SERV_FIRST
	Servidor %s est en lnea. Remuevalo de la red y trate nuevamente.
STAT_SERVERS_SERVER_EXISTS
	Servidor %s ya existe.

# SERVERS command syntax
STAT_SERVERS_SYNTAX
	SERVERS Opcin Parmetros

# STATS responses
STAT_SERVERS_STATS_TOTAL
	Total de Servidores: %2d
STAT_SERVERS_STATS_ON_OFFLINE
	       En lnea: %2d (%d%%)  No en lnea: %2d (%d%%)
STAT_SERVERS_LASTQUIT_WAS
	    ltima Desconexin: %-30s  %s

# LIST responses
STAT_SERVERS_LIST_HEADER
	Servidor                    Usuarios      Operadores
STAT_SERVERS_LIST_RESULTS
	Fn del listado -- %d/%d servidores en lnea mostrados.

# VIEW responses
STAT_SERVERS_VIEW_HEADER_ONLINE
	%-30s  (En lnea)
STAT_SERVERS_VIEW_HEADER_OFFLINE
	%-30s  (Fuera de lnea)
STAT_SERVERS_VIEW_LASTJOIN
	    ltima conexin: %s
STAT_SERVERS_VIEW_LASTQUIT
	    ltima desconexin: %s
STAT_SERVERS_VIEW_QUITMSG
	 Mensaje de salida: %s
STAT_SERVERS_VIEW_USERS_OPERS
	        Usuarios: %3d (%2d%%)  Operadores: %3d (%2d%%)
STAT_SERVERS_VIEW_RESULTS
	Fn del listado -- %d/%d servidores mostrados.

# DELETE responses
STAT_SERVERS_DELETE_SYNTAX
	SERVERS DELETE Servidor
STAT_SERVERS_DELETE_DONE
	Estadsticas para el servidor %s han sido borradas.

# COPY responses
STAT_SERVERS_COPY_SYNTAX
	SERVERS COPY Servidor Nuevo-Nombre
STAT_SERVERS_COPY_DONE
	Estadsticas para el servidor %s copiadas a %s

# RENAME responses
STAT_SERVERS_RENAME_SYNTAX
	SERVERS RENAME Servidor Nuevo-Nombre
STAT_SERVERS_RENAME_DONE
	Estadsticas para el servidor %s renombradas a %s

# USERS command syntax
STAT_USERS_SYNTAX
	USERS Opcin Parmetros

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Notcias - %s] %s
NEWS_OPER_TEXT
	[Notcias De Operador - %s] %s

NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD|DEL|LIST} [Texto|Nm]
NEWS_LOGON_LIST_HEADER
	Listado De Notcias:
NEWS_LOGON_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_LOGON_LIST_NONE
	No existen artculos noticiosos.
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD Texto
NEWS_LOGON_ADD_FULL
	La lista de notcias est llena!
NEWS_LOGON_ADDED
	Nuevo artculo notcioso agregado (#%d).
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL {Nm | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Artculo notcioso #%d no encontrado!
NEWS_LOGON_DELETED
	Artculo notcioso  #%d borrado.
NEWS_LOGON_DEL_NONE
	Ningn artculo notcioso para borrar!
NEWS_LOGON_DELETED_ALL
	Todos los artculo notcioso borrados.

NEWS_OPER_SYNTAX
	OPERNEWS {ADD|DEL|LIST} [Texto|Nm]
NEWS_OPER_LIST_HEADER
	Artculos notciosos para operadores:
NEWS_OPER_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_OPER_LIST_NONE
	No existen artculos noticiosos para los Operadores.
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD Texto
NEWS_OPER_ADD_FULL
	La lista de notcias est llena!
NEWS_OPER_ADDED
	Nuevo artculo notcioso de Operadores agregado (#%d).
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Artculo notcioso de Operadores #%d no encontrado!
NEWS_OPER_DELETED
	Artculo notcioso de Operadores #%d borrado.
NEWS_OPER_DEL_NONE
	Ningn artculo notcioso de Operadores para borrar!
NEWS_OPER_DELETED_ALL
	Todos los artculos notciosos de Operadores borrados.

NEWS_HELP_LOGON
	Sintaxis: LOGONNEWS ADD Texto
	        LOGONNEWS DEL {Nm | ALL}
	        LOGONNEWS LIST
	
	Edita o muestra la lista de artculos notciosos.  Cuando los
	usuarios se conectan a la red, estos mensajes sern enviados
	a ellos.  (Sin embargo, no mas de tres mensajes les sern
	enviados para asi evitar un ahgo (flood) del usuario.  Si hay
	mas de tres mensajes notciosos, solo los tres mas recientes
	sern enviados.)
	
	LOGONNEWS LIST puede ser usado por cualquier operador de IRC para
	listar los mensajes notciosos actuales.  ADD y DEL solo pueden ser
	usados por los Administradores de los Servicios.

NEWS_HELP_OPER
	Sintaxis: OPERNEWS ADD Texto
	        OPERNEWS DEL {Nm | ALL}
	        OPERNEWS LIST
	
	Edita o muestra la lista de mensajes notciosos de operadores.
	Cuando un usuario se hace Operador (con el comando /OPER), estos
	mensajes le sern enviados.  (Sin embargo, no mas de tres mensajes
	sern enviados asi evitando un ahgo (flood) del usuario.  Si hay
	mas de tres mensajes notciosos, solo los tres mas recientes
	sern enviados.)
	
	OPERNEWS LIST puede ser usado por cualquier operador de IRC para
	listar los mensajes notciosos al Operador actuales.  ADD y DEL solo
	pueden ser usandos por los Administradores de los Servicios.

###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S le permite "registrar" un apodo y previene que
	otros hagan uso de l.  Si el apodo no es utilizado por
	%d das, el registro expirar.  Los siguientes comandos
	permiten la registracin y tambin el mantenimiento de
	apodos; para utilizarlos, escriba /msg %S Comando.
	Para mas informacin en un comando especfico, escriba:
	/msg %S HELP Comando.
	
	    REGISTER   Registre un apodo
	    IDENTIFY   Identifiquese con su contrasea
	    ACCESS     Modifique la lista de direcciones autorizadas
	    LINK       Haga su apodo un alias de otro
	    SET        Ajuste opciones, incluyendo proteccin de kill
	    DROP       Cancele el registro de un apodo
	    RECOVER    Desconecte otro usuario que este usando su apodo
	    RELEASE    Tome custodia de su apodo despus de utilizar el
	                   comando RECOVER
	
	Otros comandos: UNLINK, UNSET, GHOST, INFO, LIST, STATUS
	
	NOTA: Este servicio est diseado para proveer una forma en la
	que los usuarios de IRC se aseguran de que su identidad no sea
	comprometida.  Su intencin NO es para facilitar el "robo"
	de apodos u otras acciones mal intencionadas.  Abuso de
	%S resultar, por lo menos, en la prdida de el/los
	apodo(s) abusado(s).

NICK_HELP_EXPIRE_ZERO
	%S le permite "registrar" un apodo y previene que
	otros hagan uso de l.  Si el apodo no es utilizado por
	%d das, el registro expirar.  Los siguientes comandos
	permiten la registracin y tambin el mantenimiento de
	apodos; para utilizarlos, escriba /msg %S Comando.
	Para mas informacin en un comando especfico, escriba:
	/msg %S HELP Comando.
	
	    REGISTER   Registre un apodo
	    IDENTIFY   Identifiquese con su contrasea
	    ACCESS     Modifique la lista de direcciones autorizadas
	    LINK       Haga su apodo un alias de otro
	    SET        Ajuste opciones, incluyendo proteccin de kill
	    DROP       Cancele el registro de un apodo
	    RECOVER    Desconecte otro usuario que este usando su apodo
	    RELEASE    Tome custodia de su apodo despus de utilizar el
	                   comando RECOVER
	
	Otros comandos: UNLINK, UNSET, GHOST, INFO, LIST, STATUS
	
	NOTA: Este servicio est diseado para proveer una forma en la
	que los usuarios de IRC se aseguran de que su identidad no sea
	comprometida.  Su intencin NO es para facilitar el "robo"
	de apodos u otras acciones mal intencionadas.  Abuso de
	%S resultar, por lo menos, en la prdida de el/los
	apodo(s) abusado(s).

NICK_HELP_REGISTER
	Sintaxis: REGISTER Contrasea [Correo-Electrnico ]
	
	Registra su apodo en la base de datos de %S.  Una vez registrado
	su apodo, usted puede utilizar los comandos SET y ACCESS
	para configurar los parmetros de su apodo como usted los desee.
	Asegrese de recordar la contrasea que utiliz para
	registrarse--la necesitar para hacer cambios a su apodo
	posteriormente.  (Ntese que las maysculas importan
	FIDO, Fido, y fido son todas diferentes contraseas!)
	
	Usted puede incluir una direccin de correo electrnico (e-mail)
	cuando registre su apodo; tambin puede fijar una mas tarde usando
	el comando SET EMAIL.
	
	Sugerencias para escoger contraseas:
	
	Contraseas no deben ser fcil de adivinar.  Por ejemplo,
	usar su verdadero nombre como contrasea es una mala idea.
	Usar su apodo como contrasea es una idea peor ;) y, por
	supuesto que, %S no lo permitir.  Tambin, contraseas
	cortas son vulnerables a bsquedas de prueba y error, por lo
	que usted debe escoger una contrasea de por lo menos 5
	caracteres.  Finalmente, el caracter de "espacio" no se
	puede utilizar en contraseas.

NICK_HELP_REGISTER_REQ_EMAIL
	Sintaxis: REGISTER Contrasea Correo-Electrnico
	
	Registra su apodo en la base de datos de %S.  Una vez registrado
	su apodo, usted puede utilizar los comandos SET y ACCESS
	para configurar los parmetros de su apodo como usted los desee.
	Asegrese de recordar la contrasea que utiliz para
	registrarse--la necesitar para hacer cambios a su apodo
	posteriormente.  (Ntese que las maysculas importan
	FIDO, Fido, y fido son todas diferentes contraseas!)
	
	Usted debe incluir una direccin de correo Electrnico (e-mail)
	cuando registre su apodo.  Usted puede prevenir que su correo
	electrnico sea mostrado a otros usuarios con el comando SET HIDE
	(Escriba /msg %S HELP SET HIDE para mas informacin).
	
	Sugerencias para escoger contraseas:
	
	Contraseas no deben ser fcil de adivinar.  Por ejemplo,
	usar su verdadero nombre como contrasea es una mala idea.
	Usar su apodo como contrasea es una idea peor ;) y, por
	supuesto que, %S no lo permitir.  Tambin, contraseas
	cortas son vulnerables a bsquedas de prueba y error, por lo
	que usted debe escoger una contrasea de por lo menos 5
	caracteres.  Finalmente, el caracter de "espacio" no se
	puede utilizar en contraseas.

NICK_HELP_IDENTIFY
	Sintaxis: IDENTIFY Contrasea
	
	Notifica a %S que usted es el verdadero dueo de este
	apodo.  Muchos de los comandos requieren que usted se
	identifique con este comando antes de poder utilizarlos.  La
	contrasea debe ser la misma que utiliz con el comando
	REGISTER.

NICK_HELP_DROP
	Sintaxis: DROP
	
	Elimina su apodo de la base de datos de %S.  Un apodo
	que ha sido eliminado est disponible para que cualquier
	persona lo vuelva a registrar.
	
	Para utilizar este comando , usted tiene que identificarse
	con su  contrasea Escriba (/msg %S HELP IDENTIFY para
	mayor informacin).

NICK_HELP_ACCESS
	Sintaxis: ACCESS ADD Mscara
	          ACCESS DEL Mscara
	          ACCESS LIST
	
	Modifica o muestra la lista de acceso para su apodo. Esta
	es la lista de direcciones que %S reconocer automticamente
	como vlidas para utilizar este apodo. Si desea utilizar este
	apodo desde otra direccin, necesita enviar el comando
	IDENTIFY para que %S lo reconozca a usted.
	
	Ejemplos:
	
	    ACCESS ADD achurch@*.dragonfire.net
	        Permite acceso al usuario achurch desde cualquier
		  computadora en el dominio dragonfire.net.
	
	    ACCESS DEL achurch@*.dragonfire.net
	        Hace lo contrario al comando anterior.
	
	    ACCESS LIST
	        Muestra la lista de acceso actual.

NICK_HELP_LINK
	Sintaxis: LINK Apodo Contrasea
	
	Liga su apodo a otro, efectivamente haciendo del apodo que
	usted utiliza actualmente un alias del otro especificado.
	Cuando usted utiliza este comando, la lista de acceso de
	el apodo que est usando es eliminada y reemplazada por la 
	del apodo con la que usted hace la liga; todos los mensajes
	para el apodo actual son agregados a la lista de mensajes de
	el apodo a ligar (esto puede causar que el apodo se exceda
	en su lmite de mensajes, en este caso necesitar borrar
	algunos de los mensajes antes de poder recibir nuevos
	mensajes para cualquiera de ambos apodos).
	
	Una vez establecida la liga, su apodo ser convertido
	transparentemente a el apodo nuevo en todas las bases de
	datos de los Servicios, excepto para los comandos %S UNLINK
	y DROP.  Por ejemplo, puede utilizar cualquiera de los
	apodos para leer los mismos mensajes (y los mensajes que se
	envan a cualquiera de los apodos irn a la misma lista).  Si
	se identifica para un apodo, automticamente se identificar
	para el otro. Si cualquiera de ambos apodos est en la lista
	de acceso de un canal, ambos apodos tendrn los mismos
	privilegios y accesos.
	
	Para utilizar este comando, usted debe de identificarse para
	su apodo actual (usando el comando IDENTIFY), y debe
	proporcionar la contrasea para el apodo al que desea ligarse.

NICK_HELP_UNLINK
	Sintaxis: UNLINK [Apodo Contrasea]
	
	Elimina la liga de su apodo hacia otro. Cuando la liga se
	elimina, los modos de un apodo y la lista de acceso de el
	apodo previamente ligado son copiados a su apodo actual y
	pueden ser modificados independientemente.  Mensajes no son
	copiados; todos los mensajes permanecen con el apodo
	previamente ligado.
	
	Cuando d un apodo y contrasea como parmetros, usted podr
	desligar otro apodo aparte del que est usando actualmente.

NICK_HELP_SET
	Sintaxis: SET Opcin Parmetros
	
	Ajusta varias opciones del apodo. Donde Opcin puede ser:
	
	    PASSWORD   Ajusta la contrasea de su apodo
	    LANGUAGE   Ajusta el lenguaje que Servicios utilizar cuando
	                   envi mensajes a usted
	    URL        Asocia un URL con su apodo
	    EMAIL      Asocia una direccin de E-mail con su apodo
	    KILL       Activa/desactiva la proteccin de kill
	    SECURE     Activa/desactiva el modo SECURE para su apodo
	    PRIVATE    Evita que su apodo aparezca en
	                   /msg %S LIST
	    HIDE       Esconde ciertas informaciones sobre su apodo
	
	Para utilizar este comando es necesario identificarse antes
	con su contrasea. Escriba (/msg %S HELP IDENTIFY para
	mayor informacin).
	
	Escriba /msg %S HELP SET Opcin para mayor informacin
	sobre una opcin especfica.

NICK_HELP_SET_PASSWORD
	Sintaxis: SET PASSWORD Nueva-Contrasea
	
	Cambia la contrasea que utiliza para identificarse como el
	dueo de el apodo.

NICK_HELP_SET_LANGUAGE
	Sintaxis: SET LANGUAGE Nmero
	
	Cambia el lenguaje que los Servicios utilizan cuando envan
	mensajes a usted (por ejemplo cuando responden a un comando
	que usted envi).  Nmero debe ser escogido de la siguiente
	lista de lenguajes disponibles:
	

NICK_HELP_SET_URL
	Sintaxis: SET URL url
	
	Asocia el URL dado con su apodo.  Este URL ser  mostrado
	cuando alguien solicite informacin sobre su apodo con el
	comando INFO.

NICK_HELP_SET_EMAIL
	Sintaxis: SET EMAIL Direccin
	
	Asocia la direccin de E-mail dada con su apodo.  Esta
	direccin ser mostrada cuando alguien solicite informacin
	sobre su apodo con el comando INFO.

NICK_HELP_SET_KILL
	Sintaxis: SET KILL {ON | QUICK | IMMED | OFF}
	
	Activa/desactiva la proteccin de kill para su apodo.  Con
	proteccin de kill activada, si algn otro usuario intenta
	utilizar tu apodo, se le dar un minuto para que cambie a
	otro, si no ser removido forzosamente de IRC por %S.
	
	Si selecciona QUICK, el usuario solo tendr 20 segundos para
	cambiar de apodo en lugar de lo usual (60 segundos).  Si
	seleccionas IMMED, el usuario ser desconectado (killed)
	inmediatamente sin ser avisado primero o darle una
	oportunidad de cambiar de apodo, favor de no utilizar esta
	opcin a menos que sea verdaderamente necesario.  Los
	Administradores de la red pueden haber deshabilitado esta opcin.

NICK_HELP_SET_SECURE
	Sintaxis: SET SECURE {ON | OFF}
	
	Activa/desactiva las funciones de seguridad de %S para
	su apodo.  Con SECURE activado, usted deber enviar su
	contrasea antes de que se le reconozca como el dueo de
	el apodo, sin importar si su direccin este o no en la lista
	de acceso.  Sin embargo, si aparece en la lista de acceso,
	%S no lo desconectar automticamente, independientemente 
	de como este la opcin de KILL.

NICK_HELP_SET_PRIVATE
	Sintaxis: SET PRIVATE {ON | OFF}
	
	Activa/desactiva la opcin privacidad de %S sobre su
	apodo.  Con PRIVATE activado, su apodo no aparecer en las
	listas de apodos generadas con el comando %S LIST.
	(Sin embargo, cualquiera que conozca su apodo puede obtener
	informacin usando el comando INFO.)

NICK_HELP_SET_HIDE
	Sintaxis: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Permite que usted evite que ciertos pedazos de informacin
	sean mostradas cuando alguien usa el comando %S INFO en su
	apodo.  Usted puede esconder su correo electrnico (EMAIL),
	ltima mscara usuario@host (USERMASK), o su ltimo mensaje
	de salida (QUIT).  El segundo parmetro especifica cual 
	informacin debe ser mostrada (OFF) o escondida (ON).

NICK_HELP_UNSET
	Sintaxis: UNSET {URL | EMAIL}
	
	Le permite borrar el URL o la direccin de E-mail asociada
	con su apodo.  Use el parmetro URL para borrar el
	URL, o el parmetro EMAIL para borrar la direccin E-mail.
	Usted no puede borrarlos ambos al mismo tiempo.

NICK_HELP_UNSET_REQ_EMAIL
	Sintaxis: UNSET URL
	
	Le permite borrar el URL asociado con su
	apodo.  El parmetro URL debe ser dado.

NICK_HELP_RECOVER
	Sintaxis: RECOVER Apodo [Contrasea]
	
	Permite que usted recupere su apodo si alguien mas lo ha
	tomado; esto es lo mismo que %S hace automticamente si
	alguien intenta utilizar un apodo protegido con kill.
	
	Cuando usted enva este comando, %S conectar  en lnea a un
	usuario falso con el mismo apodo del usuario del cual usted
	desea recuperar su apodo.  Esto causar  que los servidores 
	de IRC desconecten al otro usuario.  Este usuario falso 
	permanecer en lnea por un minuto para asegurar que el otro 
	usuario no se reconecte inmediatamente; despus de ese minuto,
	usted puede tomar su apodo.  Alternativamente, use el comando
	RELEASE (/msg %S HELP RELEASE) para obtener su apodo
	mas rpidamente.
	
	Para usar el comando RECOVER para un apodo, su direccin
	actual como se muestra en un /WHOIS debe de estar en la
	lista de acceso de el apodo, o usted debe de proporcionar la
	contrasea correcta para el apodo.

NICK_HELP_RELEASE
	Sintaxis: RELEASE Apodo [Contrasea]
	
	Instruye a %S que elimine cualquier retencin en su apodo
	causada por un kill automtico de proteccin o por el uso de
	el comando RECOVER.  Normalmente, la espera dura un minuto;
	este comando lo libera mas rpidamente.
	
	Para usar el comando RELEASE para un apodo, su direccin
	actual como se muestra en un /WHOIS debe de estar en la
	lista de acceso de el apodo, o usted deber proporcionar la
	contrasea correcta para el apodo.

NICK_HELP_GHOST
	Sintaxis: GHOST Apodo [Contrasea]
	
	Termina una sesin "fantasma" de IRC que este utilizando su
	apodo.  Una sesin "fantasma" es aquella que no est
	realmente conectada, pero que el servidor de IRC acredita
	como activa por una razn u otra.  Tpicamente esto sucede
	si su computadora se atora o su conexin a Internet se
	desconecta muy brevemente mientras est en IRC.
	
	Para usar el comando GHOST para un apodo, su direccin
	actual como se muestra en un /WHOIS debe de estar en la
	lista de acceso de el apodo, o usted debe de proporcionar
	la contrasea correcta para el apodo.

NICK_HELP_INFO
	Sintaxis: INFO Apodo [ALL]
	
	Muestra informacin sobre el apodo dado, como quien es
	el dueo, ltima direccin utilizada y hora, y las
	diferentes opciones del apodo. Si se identific por el apodo
	del cual est reclamando informacin y ALL es especificado,
	se le mostrar toda la informacin; independientemente de si
	esta est escondida o no.

NICK_HELP_LISTCHANS
	Sintaxis: LISTCHANS
	
	Lista los nombres y el nmero total de canales que usted
	ha registrado bajo su apodo.

NICK_HELP_LIST
	Sintaxis: LIST Patrn
	
	Lista todos los apodos registrados que concuerdan con un
	patrn dado en formato Apodo!usuario@host.  Apodos con 
	la opcin de PRIVATE activada no sern mostrados.
	
	Ejemplos:
	
	    LIST *!joeuser@foo.com
	        Lista los apodos registrados por joeuser@foo.com.
	
	    LIST *Bot*!*@*
	        Lista todos los apodos registrados que contengan Bot
		  en su nombre (no importa maysculas).
	
	    LIST *!*@*.bar.org
	        Lista cada apodo registrado por usuarios del dominio bar.org.

NICK_HELP_STATUS
	Sintaxis: STATUS Apodo...
	
	Informa si el usuario de un apodo es reconocido como el dueo
	de el mismo.  La respuesta tiene el siguiente formato:
	
	    Apodo cdigo-De-Estatus
	
	donde Apodo es el apodo enviado con el comando,
	Cdigo-De-Estatus es uno de los siguientes:
	
	    0 - usuario no est conectado o apodo no est registrado
	    1 - usuario no reconocido como dueo del apodo
	    2 - usuario reconocido por la lista de acceso solamente
	    3 - usuario reconocido por identificacin con contrasea
	
	Hasta 16 apodos pueden ser enviados con cada comando; el
	resto sern ignorados. No se genera mensaje de error alguno si
	no se enva un apodo.

NICK_SERVADMIN_HELP
	
	Los siguientes comandos estn disponibles para los
	Administradores de Servicios:
	
	    GETPASS    Muestra la contrasea para un apodo
	                   (solo si encripcin est desactivada)
	    SUSPEND     Previene que alguien se identifique por un apodo dado
	    FORBID      Previene que un apodo sea utilizado/registrado
	    LISTLINKS   Lista los apodos ligados a un apodo (ligas)
	
	Administradores de Servicios tambin pueden usar los siguientes
	comandos en cualquier apodo sin necesidad de identificarse:
	
	    DROP, SET, ACCESS LIST, INFO ALL

	Vea la ayuda para cada comando para detalles especficos.

NICK_SERVADMIN_HELP_DROP
	Sintaxis: DROP [Apodo]
	
	Sin parmetros, cancela el registro de su apodo en la base de
	datos de %S.
	
	Con un parmetro, cancela el registro de ese apodo en la base
	de datos.  Este comando est restringido a Administradores
	de Servicios.

NICK_SERVADMIN_HELP_SET
	
	Administradores de Servicios pueden seleccionar la opcin
	NOEXPIRE, con la cual se puede prevenir que algunos apodos 
	no expiren.  Adicionalmente, los Administradores de Servicios
	pueden establecer opciones para cualquier apodo sin necesidad
	de proveer una contrasea, utilizando el formato
	SET Apodo Opcin Parmetros.

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxis: SET [Apodo] NOEXPIRE {ON | OFF}
	
	Define si el apodo dado expirar.  Si se define ON previene
	que el apodo expire.  Si no se incluye un apodo, entonces se
	aplica a tu propio apodo.
	
	Limitado a Administradores de Servicios.

NICK_SERVADMIN_HELP_UNSET
	
	Administradores de Servicios pueden usar el comando UNSET en
	cualquier apodo por medio de inclur el apodo antes del nombre
	de la opcin, como en el comando SET.

NICK_SERVADMIN_HELP_UNLINK
	
	Administradores de Servicios pueden desligar cualquier apodo sin
	necesidad de enviar una contrasea.

NICK_SERVADMIN_HELP_LISTLINKS
	Sintaxis: LISTLINKS Apodo [ALL]
	
	Alista los apodos que estn ligados al apodo dado.  Si ALL es
	especificado, alista cada apodo con los mismos privilegios del
	apodo dado; de otra manera, alista solamente aquellos apodos 
	directamente ligados al apodo dado.
	
	Limitado a Administradores de Servicios.

NICK_SERVADMIN_HELP_ACCESS
	
	Administradores de Servicios pueden dar un apodo como parmetro
	al comando LIST para mostrar la lista de acceso para cualquier apodo.

NICK_SERVADMIN_HELP_INFO
	
	Administradores de Servicios pueden usar parmetro ALL en cualquier apodo.

NICK_SERVADMIN_HELP_LISTCHANS
	
	Administradores de Servicios pueden alistar canales para cualquier apodo
	usando el apodo con el comando (por ejemplo,
	/msg NickServ LISTCHANS Cualquier-Apodo).

NICK_SERVADMIN_HELP_LIST
	Sintaxis: LIST Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Lista todos los apodos registrados que concuerden con el
	patrn definido, con el formato Apodo!usuario@host. 
	Apodos con la opcin PRIVATE activada solo sern mostrados
	a Administradores de Servicios. Para los Administradores de
	Servicios, los apodos con la opcin NOEXPIRE establecida
	tendrn el signo ! precedido al apodo y aquellos que son
	SUSPENDidos sern precedidos del signo *.
	
	Si las opciones FORBIDDEN, SUSPENDED o NOEXPIRE son dadas,
	solo apodos que, respectivamente, estn bajo FORBID, SUSPEND o
	que tengan el modo NOEXPIRE fijado sern mostrados. Las opciones
	pueden ser usadas en cualquier orden o combinacin. Estas opciones
	estn limitadas a los Administradores de Servicios.
	
	Ejemplos:
	
	    LIST *!joeuser@foo.com
	        Lista todos los apodos registrados por joeuser@foo.com.
	
	    LIST *Bot*!*@*
	        Lista todos los apodos registrados que contenga Bot
		  en su nombre (no importa maysculas).
	
	    LIST * NOEXPIRE
	        Lista todos los apodos registrados que han sido ajustados
	        para que no expiren.

NICK_SERVADMIN_HELP_GETPASS
	Sintaxis: GETPASS Apodo
	
	Muestra la contrasea para el apodo dado.  Note que cuando
	este comando es utilizado, un mensaje incluyendo el apodo de
	la persona que lo utiliza, y el apodo sobre el cual se interroga
	es grabado en el archivo y enviado como un mensaje global
	(WALLOPS/GLOBOPS).
	
	Limitado a Administradores de Servicios.
	
	Este comando no est disponible cuando encripcin est en
	uso.

NICK_SERVADMIN_HELP_FORBID
	Sintaxis: FORBID Apodo
	
	Prohibe a todos el registro y el uso de un apodo. Se puede
	revertir utilizando el comando DROP.
	
	Limitado a Administradores de Servicios.

NICK_SERVADMIN_HELP_SUSPEND
	Sintaxis: SUSPEND [+Expiracin] Apodo Razn
	
	Previene que un apodo, y todos aquellos apodos con el
	mismo apodo raz, sean utilizados o que alguien se identifique
	por ellos. Puede lograrse que un apodo deje de estar suspendido
	por medio del comando UNSUSPEND.
	
	A diferencia de un apodo prohibido (FORBIDDEN), uno suspendido
	no pierde su informacin pero si expirar!
	
	Limitado a Administradores de Servicios.

NICK_SERVADMIN_HELP_UNSUSPEND
	Sintaxis: UNSUSPEND Apodo
	
	Permite a los usuarios el uso y habilidad de identificarse por
	un apodo previamente SUSPENDido.
	
	Limitado a Administradores de Servicios.


###########################################################################
#
# ChanServ help messages
#
###########################################################################

CHAN_HELP
	%S le permite a usted registrar y controlar varios aspectos
	de los canales.  %S frecuentemente previene el que
	usuarios mal intecionados puedan "tomar" el control limitando
	a quin se permite obtener privilegios de operador del canal. los
	comandos disponibles estn listados abajo;  para usarlos, escriba
	/msg %S Comando.  Para mas informacin sobre un
	comando especfico, escriba /msg %S HELP Comando.
	
	    REGISTER   Registre un canal
	    IDENTIFY   Identifiquese con su contrasea
	    DROP       Cancele la registracin de un canal
	    INFO       Muestra opciones e informacin del canal
	    SET        Fija opciones e informacin del canal
	    ACCESS     Mantiene la lista general de acceso al canal
	    SOP        Mantiene la lista de SuperOp
	    AOP        Mantiene la lista de AutoOp
	    VOP        Mantiene la lista de AutoVoice
	    AKICK      Mantiene la lista de AutoKick

CHAN_HELP_OTHERS
	
	Otros comandos: UNSET, LIST, INVITE, UNBAN, CLEAR,
	                LEVELS, OP, DEOP, VOICE, DEVOICE

CHAN_HELP_OTHERS_HALFOP_CHANPROT
	
	Otros comandos: UNSET, LIST, INVITE, UNBAN, CLEAR,
	                LEVELS, OP, DEOP, VOICE, DEVOICE,
	                HALFOP, DEHALFOP, PROTECT, DEPROTECT,
	                HOP

CHAN_HELP_EXPIRES
	
	Note que si un canal no es utilizado por %d das (es decir
	qu ningn usuario en la lista de acceso del canal entra en
	ese periodo de tiempo) ser automticamente cancelado.

CHAN_HELP_REGISTER
	Sintaxis: REGISTER Canal Contrasea Descripcin
	
	Registra un nuevo canal en la base de datos de %S.
	Para poder utilizar este comando, usted primero debe ser
	operador del canal que est tratando de registrar.  La
	contrasea deber ser utilizada con el comando IDENTIFY
	cuando necesite hacer modificaciones posteriores a las
	opciones del canal.  El ltimo parmetro, que debe ser
	incluido, es una descripcin de los propsitos del canal.
	
	Cuando usted registra un canal, usted queda grabado como
	el "fundador" del canal. El fundador de un canal puede
	modificar cualquiera de las opciones para un canal;
	%S le dar automticamente privilegios de operador 
	al fundador del canal cuando l/ella ingresen al canal
	Vea el comando ACCESS; (/msg %S HELP ACCESS) para 
	obtener informacin de como dar privilegios de operador 
	a otros usuarios del canal.
	
	AVISO: para poder registrar un canal, su apodo debe estar
	registrado.  Si an no lo registr, escriba
	/msg %s HELP para obtener informacin de cmo hacerlo.

CHAN_HELP_IDENTIFY
	Sintaxis: IDENTIFY Canal Contrasea
	
	Lo identifica a usted ante %S como el fundador
	del canal.  Muchos comandos requieren que usted
	ejecute este comando antes de poder utilizarlos.  La
	contrasea debe ser la misma que se ingres al momento
	de registrar el canal (comando REGISTER).

CHAN_HELP_DROP
	Sintaxis: DROP Canal
	
	Borra el canal nombrado.  Esto Puede ser utilizado
	nicamente por el fundador del canal, quien deber
	primeramente identificarse con el comando IDENTIFY.

CHAN_HELP_SET
	Sintaxis: SET Canal Opcin Parmetros
	
	Habilita al fundador del canal a definir varias opciones 
	e informacin del canal.  El fundador, debe hacer uso del
	comando IDENTIFY antes de utilizar SET.
	
	Opciones disponibles:
	
	    FOUNDER     Cambia el fundador de un canal
	    SUCCESSOR   Establece el sucesor para un canal
	    PASSWORD    Cambia la contrasea del fundador
	    DESC        Cambia la descripcin del canal
	    URL         Asocia un URL con el canal
	    EMAIL       Asocia una direccion E-mail con el canal
	    ENTRYMSG    Fija un mensaje que ser enviado a los usuarios
	                   cuando ellos entran al canal
	    TOPIC       Cambia el tpico en el canal
	    KEEPTOPIC   Retenga el tpico cuando el canal no es usado
	    TOPICLOCK   Tpico solo podr ser cambiado via SET TOPIC
	    MLOCK       Fija los modos del canal en 'ON' u 'OFF'
	    PRIVATE     Oculta al canal del comando LIST
	    RESTRICTED  Restringe el acceso al canal
	    SECURE      Activa las opciones de seguridad de %S
	    SECUREOPS   Control mas estricto del estatus de operador
	    LEAVEOPS    No remover OPs a los usuarios al entrar al canal
	    OPNOTICE    Notifca cuando los comandos OP/DEOP son usados
	    ENFORCE     Impone estatus auto-op y auto-voice de immediato
	
	Escriba /msg %S HELP Opcin para mas informacin sobre una
	opcin en particular.

CHAN_HELP_SET_FOUNDER
	Sintaxis: SET Canal FOUNDER Apodo
	
	Cambia el fundador de un canal.  El nuevo apodo debe
	ser uno registrado.

CHAN_HELP_SET_SUCCESSOR
	Sintaxis: SET Canal SUCCESSOR Apodo
	
	Cambia el sucesor de un canal.  Si el apodo del fundador
	expira o si es cancelado mientras el canal est todavia
	registrado, el sucesor se convertir en el nuevo fundador
	del canal.  Sin embargo, si el sucesor ya tiene demaciados
	canales registrados (%d), el canal ser cancelado como
	resultado, justo como si ningun sucesor hubiese sido fijado.
	El nuevo apodo debe ser uno registrado.

CHAN_HELP_SET_PASSWORD
	Sintaxis: SET Canal PASSWORD Contrasea
	
	Cambia la contrasea usada para identificarse como el fundador
	de el canal.

CHAN_HELP_SET_DESC
	Sintaxis: SET Canal DESC Descripcin
	
	Cambia la descripcin para el canal, que se muestra con
	los comandos LIST e INFO.

CHAN_HELP_SET_URL
	Sintaxis: SET Canal URL url
	
	Asocia con el canal el URL dado.  Este URL ser
	mostrado siempre que alguien pida informacin sobre
	el canal con el comando INFO.

CHAN_HELP_SET_EMAIL
	Sintaxis: SET Canal EMAIL Direccin
	
	Asocia con el canal la direccin E-mail (correo electrnico) dada.
	Esta direccin ser mostrada siempre que alguien pida
	informacin sobre el canal con el comando INFO.

CHAN_HELP_SET_ENTRYMSG
	Sintaxis: SET Canal ENTRYMSG Mensaje
	
	Fija el mensaje que ser enviado via /notice a los 
	usuarios cuando estos entren al canal.

CHAN_HELP_SET_TOPIC
	Sintaxis: SET Canal TOPIC Tpico
	
	Causa que %S fije el tpico del canal a aquel que se
	le especifica.  Este comando es muy til en conjuncin 
	con el comando SET TOPICLOCK.

CHAN_HELP_SET_KEEPTOPIC
	Sintaxis: SET Canal KEEPTOPIC {ON | OFF}
	
	Habilita o deshabilita la opcin de retencin del tpico
	para el canal.  Cuando retencin del tpico est en ON
	(activada), el tpico del canal ser recordado por %S
	an despus que el ltimo usuario se haya retirado, y se
	restaurar la prxima vez que alguien ingrese al canal.

CHAN_HELP_SET_TOPICLOCK
	Sintaxis: SET Canal TOPICLOCK {ON | OFF}
	
	Habilita o deshabilita la opcin para candado en tpico del
	canal.  Cuando TOPICLOCK (candado en tpico) est en ON, %S 
	no habilitar el cambio del tpico excepto va el comando
	SET TOPIC.

CHAN_HELP_SET_MLOCK
	Sintaxis: SET Canal MLOCK Modos
	
	Fija los distintos modos para el canal.  %S lo habilita a
	usted para definir determinados modos del canal y que queden
	siempre habilitados (o no).  Los modos que pueden ser
	fijados son: i, k, l, m, n, p, s, y t; cada
	uno de estos modos puede estar activado (ON), desactivado
	(OFF) o no fijado.  Distintos modos se indican justo como si
	se utilizase el comando /MODE; esto es, modo seguido de + 
	indica activado (ON), modo seguido de - indica desactivado (OFF).
	
	Cuidado!:  Si usted fija un modo protegido por contrasea,
	como en el segundo ejemplo, tambin deber fijar la opcin
	RESTRICTED para el canal (vea HELP SET RESTRICTED), o alguien
	que entre al canal cuando est vaco, ver la contrasea!!
	
	Ejemplos:
	
	    SET #canal MLOCK +nt-iklps
	       Activa los modos n y t, y desactiva los modos i, k,
	       l, p, y s.  El modo m puede ser activado o desactivado.
	
	    SET #canal MLOCK +knst-ilmp mi-clave
	       Activa los modos k, n, s, y t.
	       Desactiva los modos i, l, m, y p.
	       Tambin establece "mi-clave" como la contrasea del canal.
	
	    SET #canal MLOCK +
	       Elimina los modos activos; todos los modos del canal
	       pueden ser libremente activados o desactivados.

CHAN_HELP_SET_PRIVATE
	Sintaxis: SET Canal PRIVATE {ON | OFF}
	
	Habilita o deshabilita la opcin de Privado para el canal.
	Cuando esta opcin est activada, el comando /msg %S LIST no
	incluir el canal en ninguna lista.

CHAN_HELP_SET_RESTRICTED
	Sintaxis: SET Canal RESTRICTED {ON | OFF}
	
	Habilita o deshabilita la opcin de Acceso Restringido para
	el canal.  Cuando el acceso restringido est activo (ON),
	usuarios que normalmente no tienen privilegio de operadores
	cuando entran al canal (usuarios con nivel de acceso
	negativo y, si secure ops est activada, usuarios que NO
	estn en la lista de acceso) sern expulsados (y se les
	prohibir el acceso) al canal.

CHAN_HELP_SET_SECURE
	Sintaxis: SET Canal SECURE {ON | OFF}
	
	Habilita o deshabilita la seguridad de %S para el
	canal.  Cuando SECURE est ACTIVO, SOLO los usuarios que
	tienen registrados sus apodos con %s y que se han
	IDENTIFICADO con sus contraseas tendrn privilegios en
	el canal si es que figuran en la lista de ACCESS (acceso).

CHAN_HELP_SET_SECUREOPS
	Sintaxis: SET Canal SECUREOPS {ON | OFF}
	
	Habilita o deshabilita la opcin de OPs Seguros para
	un canal.  Cuando SECUREOPS est activada (ON),
	usuarios que NO estn en la lista de usuarios del canal NO
	podrn obtener estatus de operadores.

CHAN_HELP_SET_LEAVEOPS
	Sintaxis: SET Canal LEAVEOPS {ON | OFF}
	
	Habilita o deshabilita la opcin Dejar OPs para un canal.
	Cuando LEAVEOPS es activada (ON), %S permite al servidor
	dar OPs (+o a la primera persona que entre al canal) inclusve
	cuando la persona normalmente no obtiene Auto-OPs.  Opciones
	SECUREOPS y de nivel de acceso de AUTODEOP sern an impuestas.
	Cuidado!:  Esto puede permitir que personas no autorizadas
	"roben" el estatus de Operador durante una ruptura de la red.

CHAN_HELP_SET_OPNOTICE
	Sintaxis: SET Canal OPNOTICE {ON | OFF}
	
	Habilita o deshabilita la opcin Nota de OPs para un canal.
	Cuando OPNOTICE es activada (ON), %S enviar una nota al 
	canal siempre que los comandos OP o DEOP sean usados por 
	un usuario en el canal.

CHAN_HELP_SET_ENFORCE
	Sintaxis: SET Canal ENFORCE {ON | OFF}
	
	Habilita o deshabilita la opcin de IMPONER a un canal. Cuando
	ENFORCE es activado (ON), %S impondr los niveles de
	auto-op y auto-voice para todos los usuarios.  Por ejemplo, si a
	un usuario con privilegios de auto-op se le remueven los OPs, %S
	automticamente le dar OPs al usuario de nuevo, y %S tampoco
	permitir que el comando DEOP sea usado en aquel usuario.

CHAN_HELP_UNSET
	Sintaxis: UNSET Canal {SUCCESSOR | URL | EMAIL | ENTRYMSG}
	
	Borra los ajustes especificados de un canal.

CHAN_HELP_SOP
	Sintaxis: SOP Canal ADD Apodo
	          SOP Canal DEL Apodo
	          SOP Canal LIST [Mscara | Lista]
	          SOP Canal COUNT
	
CHAN_HELP_SOP_NOPROT
	Mantiene la lista de SuperOp (SOP) para un canal.
	Usuarios con el estatus SOP reciben OPs automaticamente
	(reciben modo +o) cuando estos ingresan al canal.
CHAN_HELP_SOP_PROT
	Mantiene la lista de SuperOp (SOP) para un canal.
	Usuarios con el estatus SOP reciben OPs automaticamente
	(reciben modo +o) y son protegidos (modo +a) cuando estos
	ingresan al canal.
CHAN_HELP_SOP_END
	
	Un SOP puede modificar las listas de AOP y VOP. Solo
	el fundador del canal puede modificar la lista de SOP.
	
	El comando SOP LIST muestra la lista SOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que 
	concuerden con esa mscara son mostradas.  Si se da una lista de 
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   SOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas SOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando SOP COUNT retorna el nmbero de entradas que
	existen en la lista SOP.

CHAN_HELP_AOP
	Sintaxis: AOP Canal ADD Apodo
	          AOP Canal DEL Apodo
	          AOP Canal LIST [Mscara | Lista]
	          AOP Canal COUNT
	
	Mantiene la lista AutoOp (AOP) para un canal.
	Usuarios con estatus AOP reciben OPs automaticamente
	(reciben modo +o) cuando ingresan al canal.
	
	Un AOP puede modificar la lista VOP.
	
	El comando AOP LIST muestra la lista AOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que 
	concuerden con esa mscara son mostradas.  Si se da una lista de 
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   AOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas SOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando AOP COUNT retorna el nmero de entradas que
	existen en la lista AOP.

CHAN_HELP_HOP
	Sintaxis: HOP Canal ADD Apodo
	          HOP Canal DEL Apodo
	          HOP Canal LIST [Mscara | Lista]
	          HOP Canal COUNT
	
	Mantiene la lista HalfOp (HOP) para un canal.  Usuarios
	con estatus HOP reciben privilegios de Mitad-OP (reciben
	modo +h) automaticamente cuando estos ingresan al canal.
	
	Un HOP puede modificar la lista VOP; SOPs y AOPs pueden
	modificar la lista HOP.
	
	El comando HOP LIST muestra la lista HOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que 
	concuerden con esa mscara son mostradas.  Si se da una lista de 
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   HOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas HOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando HOP COUNT retorna el nmero de entradas que
	existen en la lista HOP.

CHAN_HELP_VOP
	Sintaxis: VOP Canal ADD Apodo
	          VOP Canal DEL Apodo
	          VOP Canal LIST [Mscara | Lista]
	          VOP Canal COUNT
	
	Mantiene la lista VoiceOp (VOP) para un canal.
	Usuarios con estatus VOP reciben vz automaticamente 
	(reciben modo +v) cuando estos ingresan al canal.
	
	El comando VOP LIST muestra la lista VOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que 
	concuerden con esa mscara son mostradas.  Si se da una lista de 
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   VOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas VOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando VOP COUNT retorna el nmero de entradas que
	existen en la lista VOP.

CHAN_HELP_ACCESS
	Sintaxis: ACCESS Canal ADD Apodo Nivel
	          ACCESS Canal DEL {Apodo | Nm-de-Entrada | Lista}
	          ACCESS Canal LIST [Mscara | Lista]
	          ACCESS Canal COUNT
	
	Mantiene la Lista De Accesos del canal.  La lista de acceso
	establece qu usuarios estn habilitados a ser operadores
	del canal o acceder a comandos de %S en el canal.  Se pueden
	establecer diferentes niveles de usuarios para acceder a
	diferentes privilegios; utilice /msg %S HELP ACCESS LEVELS
	para obtener informacin mas especfica.  Cualquier apodo que
	no est en la lista de acceso tiene nivel de usuario 0
	(cero).
	
	Note que la lista de acceso puede tambin ser manipulada con los
	comandos SOP, AOP, y VOP, los cuales corresponden a los
	niveles de %d, %d, y %d respectivamente.
	
	El comando ACCESS ADD agrega el apodo con el nivel dado a
	la lista de acceso; si el usuario ya existe en la lista, se
	reemplazar su nivel con el dado.  El nivel especificado debe
	ser menor que el que tiene el usuario que est ingresando el
	comando, y si el apodo est actualmente en la lista, el nivel 
	actual de dicho apodo debe ser menor que el nivel del usuario que
	est ingresando el comando.
	
	El comando ACCESS DEL remueve el apodo dado de la 
	lista de acceso.  Si una lista de nmeros de entrada es dada,
	aquellas entradas son borradas.  (Vea el ejemplo para LIST abajo.)
	
	El comando ACCESS LIST muestra la lista de acceso.  Si una mscara
	de comodn (signo *) es insertada, solamente aquellas entradas que 
	concuerden con esa mscara son mostradas.  Si se da una lista de 
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   ACCESS #canal LIST 2-5,7-9
	      Muestra la lista de entradas del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando ACCESS COUNT retorna el nmero de entradas que
	existen en la lista de acceso.

CHAN_HELP_ACCESS_LEVELS
	Niveles De Acceso Del Usuario
	
	Originalmente, los siguientes niveles son definidos:
	
	   Founder   Acceso completo a las funciones de %S; obtencin
	                     automtica de OPs al entrar al canal.  Note
	                     que solo UNA persona puede tener estatus de
	                     fundador (el cual no puede ser dado usando el
	                     comando ACCESS).
	      %4d   Acceso al comando AKICK; obtencin automtica de OPs.
	      %4d   Obtencin automtica de OPs.
	      %4d   Obtencin automtica de vz (voice +v).
	         0   Ningn privilegio especial; otros operadores pueden
	                     darle OPs (a menos que SECUREOPS este fijado).
	        <0   No puede obtener OPs.
	
	Estos niveles no pueden ser cambiados, ni nuevos agregados, usando el
	comando LEVELS; escriba /msg %S HELP LEVELS para mas
	informacin.

CHAN_HELP_AKICK
	Sintaxis: AKICK Canal ADD Mscara [Razn]
	          AKICK Canal DEL Mscara
	          AKICK Canal LIST [Mscara | Lista]
	          AKICK Canal VIEW [Mscara | Lista]
	          AKICK Canal ENFORCE
	          AKICK Canal COUNT
	
	Mantiene la lista de Auto-Patear (AKICK) para un canal.  Si un
	usuario en la lista de Auto-Patear intenta ingresar al canal,
	%S lo bloquear (ban) del canal, despues lo patear (kick).
	
	El comando AKICK ADD agrega un usuario a la lista de AKICK.
	Si una razn es dada con el comando, entonces la razn ser
	utilizada por %S cuando expulse a dicho usuario; si
	no, el mensaje que se utilizar por defecto, es "You have
	been banned from the channel" (Estas bloqueado del canal).
	
	El comando AKICK DEL elimina el usuario o mscara dada de la
	lista AKICK.  Este comando no remueve sin embargo bloqueos (bans)
	existentes en el canal, los que debern ser removidos manualmente.
	
	El comando AKICK LIST muestra la lista de usuarios en la
	lista de AKICK.  AKICK VIEW simplemente muestra mas detalles.
	
	El comando AKICK ENFORCE causa que %S imponga la lista AKICK
	actual por medio de remover aquellos usuarios que concuerdan con
	una mscara AKICK .
	
	El comando AKICK COUNT retorna cuantas entradas existen
	en la lista de Auto-Pateo (AKICK).

CHAN_HELP_LEVELS
	Sintaxis: LEVELS Canal SET Tipo Nivel
	          LEVELS Canal {DIS | DISABLE} Tipo
	          LEVELS Canal LIST
	          LEVELS Canal RESET
	
	El comando LEVELS permite un control fino sobre los accesos
	numricos utilizados por los canales.  Con este comando,
	usted puede definir los niveles requeridos para muchas de
	las funciones de %S.  Los comandos SET FOUNDER,
	SET PASSWORD, as como ste comando estn siempre
	restringidos al fundador.
	
	Cuidado!:  Este comando es solo para usuarios avanzados!  Cambiar
	las opciones de nivel con este comando puede causar que los comandos
	SOP, AOP, y VOP dejen de funcionar correctamente.
	
	LEVELS SET permite el nivel de acceso para una funcin o grupo
	de funciones a ser cambiadas.  LEVELS DISABLE (o DIS abreviado)
	deshabilita una opcin automtica o prohibe el acceso a una
	funcin por cualquiera que no sea el fundador del canal.
	LEVELS LIST muestra el nivel actual para cada funcin o
	grupo de funciones.  LEVELS RESET reajusta los niveles a los
	niveles originales de un canal recien creado (vea
	HELP ACCESS LEVELS para mas informacin).
	
	Para una lista de las opciones y funciones a los que se le puede 
	ajustar los niveles, vea HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	La siguiente lista muestra los valores/funciones originalemente
	establecidos.  Note que los niveles para AUTODEOP y NOJOIN son
	los mximos niveles, mientras que todos los dems, son los
	mnimos.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Sintaxis: INFO Canal [ALL]
	
	Lista informacin sobre el canal registrado especificado,
	incluyendo su fundador, fecha de registro, ltima vez usado,
	descripcin, y modo lock (candado), si existe.  Si usted se
	ha identificado como el fundador del canal del cual pide
	informacin y ALL es especificado, el mensaje de entrada
	y el sucesor tambin sern mostrado.

CHAN_HELP_LIST
	Sintaxis: LIST Patrn
	
	Lista todos los canales registrados que coincidan con el patrn dado.
	(Canales con la opcin PRIVATE fijada no son alistados.)

CHAN_HELP_OP
	Sintaxis: OP #canal Apodo
	
	Convierte en Operador al usuario dado en el canal indicado.  Originalmente,
	esto est limitado a aquellos con nivel 5 de acceso o superior en el canal.

CHAN_HELP_DEOP
	Sintaxis: DEOP #Canal Apodo
	
	Retira estatus "operador" (+o) del usuario dado en el canal indicado. Originalmente
	esto est limitado a aquellos con nivel 5 de acceso o mayor en el canal.
	
CHAN_HELP_VOICE
	Sintaxis: VOICE #Canal Apodo
	
	Da voz (+v) al apodo seleccionado en un canal.  Originalmente, limitado 
	a aquellos con nivel 3 de acceso o superior en el canal.

CHAN_HELP_DEVOICE
	Sintaxis: DEVOICE #Canal Apodo
	
	Retira la voz (-v) del apodo seleccionado en el canal.  Originalmente,
	limitado a aquellos con nivel 3 de acceso o superior en el canal.

CHAN_HELP_HALFOP
	Sintaxis: HALFOP #Canal Apodo
	
	Da acceso midad-OP (+h) al apodo seleccionado en un canal.  Originalmente,
	limitado a aquellos con nivel 4 de acceso o superior en el canal.

CHAN_HELP_DEHALFOP
	Sintaxis: DEHALFOP #Canal Apodo
	
	Remueve el acceso mitad-OP (halfop +h) del apodo seleccionado en un canal.
	Originalmente, limitado a aquellos con nivel 4 de acceso o mayor en el canal.

CHAN_HELP_PROTECT
	Sintaxis: PROTECT #Canal Apodo
	
	Da proteccin de canal (modo +a) a un apodo seleccionado en un
	canal.  Originalmente, limitado a aquellos con nivel 10 de acceso
	o superior en el canal.

CHAN_HELP_DEPROTECT
	Sintaxis: DEPROTECT #Canal Apodo
	
	Remueve la proteccin de canal (modo +a) del apodo seleccionado
	en un canal.  Originalmente, limitado a aquellos con nivel 10
	de acceso o superior en el canal.

CHAN_HELP_INVITE
	Sintaxis: INVITE Canal
	
	Le dice a %S que lo invite a usted a ingresar al canal dado. 
	Originalmente, solamente funciona si su nivel de acceso en aquel
	canal es de por lo menos 5.

CHAN_HELP_UNBAN
	Sintaxis: UNBAN Canal
	
	Le dice a %S que remueva todos los bans (bloqueos) que lo retienen
	a usted de ingresar al canal especificado.  Originalmente, solo
	funciona si su nivel de acceso en aquel canal es por lo menos 5.

CHAN_HELP_CLEAR
	Sintaxis: CLEAR Canal Algo
	
	Le dice a %S que borre ciertos ajustes en un canal.  Algo
	puede ser cualquiera de las siguientes opciones:
	
	     MODES       Borra todos los modos en el canal excepto aquellos
	                     modos fijados con la opcin MLOCK.
	     BANS        Borra todos los bans (bloqueos) en el canal.
CHAN_HELP_CLEAR_EXCEPTIONS
	     EXCEPTIONS  Borra todas las excepciones en el canal.
CHAN_HELP_CLEAR_MID
	     OPS         Remueve el estatus de operador de canal (modo +o)
	                     de todos los usuarios.
CHAN_HELP_CLEAR_HALFOPS
	     HALFOPS     Remueve el estatus de medio operador o halfop
	                     (modo +h) de todos los usuarios.
CHAN_HELP_CLEAR_END
	     VOICES      Remueve el estatus "voice" (modo +v) de todo usuario.
	     USERS       Remueve o Patea (kicks) todos los usuarios del canal.
	
	Originalmente, su nivel de acceso en el canal debe ser por
	lo menos 10 para poder utilizar este comando.

CHAN_SERVADMIN_HELP
	
	Comandos para los administradores de Servicios:
	
	    GETPASS   Recobre la contrasea de fundador para un canal
	                  (solo si encripcin est deshabilitada)
	    FORBID    Prevenga el que un canal sea registrado/usado
	    SUSPEND   Prevenga el que un canal registrado sea usado
	    STATUS    Retorna el nivel de acceso actual para un usuario
	                  en un canal
	
	Administradores de Servicios tambin pueden cancelar cualquier 
	canal sin identificarse via contrasea, y pueden ver las listas
	de acceso, AKICK, y de ajuste de niveles para cualquier canal.

CHAN_SERVADMIN_HELP_DROP
	Sintaxis: DROP Canal
	
	Elimina el canal seleccionado.  Solamente los 
	Administradores de Servicios pueden eliminar un canal
	por el cual no se han identificado.

CHAN_SERVADMIN_HELP_SET
	
	Administradores de Servicios tambin pueden fijar la opcin NOEXPIRE,
	con la cual se puede prevenir el que los canales expiren. Adicionalmente,
	los Administradores de Servicios pueden fijar opciones para cualquier 
	canal sin identificarse via contrasea por el canal.

CHAN_SERVADMIN_HELP_UNSET
	
	Igual que con el comando SET, los Administradores de Servicios pueden
	borrar ajustes para cualquier canal sin identificarse por el canal.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxis: SET Canal NOEXPIRE {ON | OFF}
	
	Ajusta si el canal especificado expirar o no.  Ajustar esta opcin
	a ON previene que el canal expire.
	
	Limitado a los Administradores de Servicios.

CHAN_SERVADMIN_HELP_INFO
	
	Administradores de Servicios pueden usar el parmetro ALL con cualquier canal.

CHAN_SERVADMIN_HELP_LIST
	Sintaxis: LIST Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Lista todos los canales registrados que concuerden con el patrn dado.
	Canales con la opcin PRIVATE activada solamente sern mostrados a 
	los administradores de Servicios. Canales con la opcin NOEXPIRE activada
	tendrn un signo ! antecediendo al nombre del canal, Esto en el caso de
	los administradores de servicios.
	
	Si las opciones FORBIDDEN, SUSPENDED o NOEXPIRE son dadas, solo
	aquellos canales que, respectivamente, tienen las opciones FORBID, SUSPEND
	o que tienen el modo NOEXPIRE activado sern mostrados. Las opciones pueden
	ser utilizadas en cualquier orden y en cualquier combinacin. Estas opciones
	estn limitadas a los Administradores de Servicios.

CHAN_SERVADMIN_HELP_GETPASS
	Sintaxis: GETPASS Canal
	
	Retorna la contrasea para el canal indicado.  Note que
	siempre que este comando es usado, un mensaje incluyendo la
	persona que ejuct el comando y el canal para el cual fue
	usado ser archivado y enviado en forma de WALLOPS/GLOBOPS.
	
	Limitado a Administradores de Servicios.

CHAN_SERVADMIN_HELP_FORBID
	Sintaxis: FORBID Canal
	
	Deshabilita el que alguien registre o utilice el canal indicado.
	Esto puede ser revertido por medio de eliminar el canal (drop).
	
	Limitado a Administradores de Servicios.

CHAN_SERVADMIN_HELP_SUSPEND
	Sintaxis: SUSPEND [+Expiracin] Canal Razn
	
	Previene el que un canal sea utilizado o el que alguien se 
	identifique por l. Esta accin puede ser revertida por medio
	de usar el comando UNSUSPEND.
	
	A diferencia de un canal prohibido (forbidden), uno suspendido no
	pierde su informacin y SI expirar!
	
	Limitado a Administradores de Servicios.

CHAN_SERVADMIN_HELP_UNSUSPEND
	Sintaxis: UNSUSPEND Canal
	
	Permite a los usuarios el uso y el que se identifiquen por un
	canal que habia sido previamente suspendido (suspend).
	
	Limitado a Administradores de Servicios.

CHAN_SERVADMIN_HELP_STATUS
	Sintaxis: STATUS Canal Apodo
	
	Retorna el nivel de acceso actual para el apodo indicado en el
	canal indicado.  La respuesta es de la forma:
	
	    STATUS Canal Apodo Nivel-De-Acceso
	
	Si ocurre un error, la respuesta ser en la forma:
	
	    STATUS ERROR Mensaje-Del-Error
	
	Limitado a Administradores de Servicios.


###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S es una utilera que le permite a los usuarios de IRC
	el envio de mensajes cortos a otros usuarios de la misma red,
	independientemente de si estos estn en lnea o no, igualmente
	se puede enviar mensajes a canales(*).  Ambos apodos remitente
	y destinatario, asi como el canal al que se envia deben estar
	registrados para poder enviar mensajes.
	
	Comandos de %S incluyen:
	
	    SEND   Envie un mensaje a un apodo o canal
	    LIST   Liste sus mensajes
	    READ   Lea un mensaje o mensajes
	    DEL    Borre un mensaje o mensajes
	    SET    Ajuste opciones relacionadas a los mensajes
	
	Escriba /msg %S HELP Comando para ayuda con cualquiera de
	los comandos descritos arriba.
	
	(*) Originalmente, cualquier usuario con al menos nivel 10 de 
	    acceso en un canal puede leer los mensajes de aquel canal.
	    Esto puede cambiarse con el comando %s LEVELS.

MEMO_HELP_SEND
	Sintaxis: SEND {Apodo | Canal} Texto-Del-Mensaje
	
	Le envia al apodo o canal indicado un mensaje conteniendo
	el texto-del-mensaje.  Cuando se envie a un apodo, el recipiente
	recibir una nota informandole que l/ella tiene un nuevo mensaje.
	El apodo/canal al que se envie debe estar registrado.

MEMO_HELP_LIST
	Sintaxis: LIST [Canal] [Lista | NEW]
	
	Lista cualquier mensaje que usted pueda tener actualmente.  Con NEW,
	lista solamente nuevos mensajes (sin leer).  Mensajes no leidos se marcan
	con el signo * a la izquierda del nmero del mensaje.  Usted tambin puede
	especificar una lista de nmeros, como en el ejemplo abajo:

	   LIST 2-5,7-9
	      Lista mensajes numerados 2 through 5 and 7 through 9.

MEMO_HELP_READ
	Sintaxis: READ [Canal] {Nm | Lista | LAST | NEW}
	
	Le envia el texto de los mensajes especificados.  Si se especifica
	LAST, Le envia el mensaje mas reciente rebido por usted.  Si se
	especifica NEW, le envia todos sus nuevos mensajes.  De lo contrario,
	le envia el nmero Nm del mensaje.  Usted tambin puede especificar
	una lista de nmeros, como en este ejemplo:
	
	   READ 2-5,7-9
	      Muestra mensajes del numero 2 hasta el 5 y 7 hasta el 9.

MEMO_HELP_DEL
	Sintaxis: DEL [Canal] {Nm | Lista | ALL}
	
	Borra los mensajes o mensaje especificados.  Usted puede suplir
	multiples nmeros o una amalgama de nmeros en lugar de un
	simple nmero, como en el segundo ejemplo abajo.
	
	Si ALL se especifica, borra todos tus mensajes.
	
	Ejemplos:
	
	   DEL 1
	      Borra tu primer mensaje.
	
	   DEL 2-5,7-9
	      Borra los mensajes numberados del 2 al 5 y del 7 al 9.

MEMO_HELP_SET
	Sintaxis: SET Opcin Parmetros
	
	Ajusta varias opciones del mensaje.  opcin puede ser:
	
	    NOTIFY      Cambia cuando ser usted notificado de
	                    nuevos mensajes (Solamente apodos)
	    LIMIT       Fija el nmero mximo de mensajes que
	                    usted puede recibir
	
	Escriba /msg %S HELP SET opcin para mas informacin
	sobre una opcin especfica.

MEMO_HELP_SET_NOTIFY
	Sintaxis: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Cambia cuando ser notificado usted de nuevos mensajes:
	
	    ON      Usted ser notificado de mensajes cuando se
	               conecte, cuando desactive /AWAY, y cuando
	               estos le sean enviados a usted.
	    LOGON   Usted ser notificado de mensajes solamente al
	               conectarse o cuando desactive /AWAY.
	    NEW     Usted ser notificado de mensajes solamente
	               cuando estos le sean enviados.
	    OFF     No recibirs notificacin alguna de mensajes.
	
	ON es equivalente a LOGON y a NEW combinados.
	
	Note que si su apodo tiene la opcin "secure" activada, 
	usted ser solamente notificado de mensajes nuevos (para 
	LOGON u ON) despues de indentificarse a %S.

MEMO_HELP_SET_LIMIT
	Sintaxis: SET LIMIT [Canal] Lmite
	
	Fija el nmero mximo permitido de mensajes que usted (o el
	canal dado) pueden tener. Si se fija esto a 0, nadie podr
	enviar mensaje alguno a usted.  Sin embargo, usted no puede
	fijar esto a un nmero mayor que %d.

MEMO_HELP_INFO
	Sintaxis: INFO [Canal]
	
	Muestra informacin sobre el nmero de mensajes que usted
	tiene, cuantos de estos estn sin leer, cuantos mensajes
	en total usted puede recibir y cuando ser usted notificado
	de los nuevos mensajes. con el parmetro, muestra la misma  
	informacin para el canal indicado.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Sintaxis: SET LIMIT [Usuario | Canal] {Lmite | NONE} [HARD]
	
	Fija el nmero mximo permitido de mensajes que un usuario
	o canal pueden tener.  Si se fija el lmite a 0 previene 
	que el usuario reciba mensaje alguno; fijandolo a NONE le
	permitir al usuario recibir y mantener cuantos mensajes desee.
	Si usted no indica un apodo o canal, su propio lmite es
	ajustado.
	
	Agregar HARD previene que el usuario cambie el lmite.  No
	agregar HARD tiene el efecto opuesto, permitiendo entonces
	que el usuario cambie el lmite (inclusive si un lmite previo
	fue fijado con HARD).
	
	Este uso del comando SET LIMIT es limitado a Administradores
	de Servicios.  Otros usuarios solo pueden establecer su propio
	lmite o el de un canal sobre el cual tienen tales privilegios, no
	pueden remover su lmite, no pueden fijar un lmite superior a %d, 
	y no pueden fijar un lmite HARD.

MEMO_SERVADMIN_HELP_INFO
	Sintaxis: INFO [Apodo | Canal]
	
	Sin un parmetro, muestra informacin sobre el nmero de
	mensajes que usted tiene, cuantos estn sin leer, cuantos
	mensajes en total usted puede recibir y cuando es que se 
	le notifica a usted de nuevos mensajes.
	
	Con un parmetro de canal, muestra la misma informacin para
	el canal indicado.
	
	Con un parmetro de apodo, muestra la misma informacin para
	el apodo indicado.  Este comando est limitado a  los
	Administradores de Servicios.

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	Comandos de %S:
	    GLOBAL      Envie un mensaje a todos los usuarios
	    STATS       Muestra el estatus de los Servicios y red
	    OPER LIST   Lista todos los Operadores de Servicios
	    ADMIN LIST  Lista todos los Administradores de Servicios
	
	Comandos solo para Administradores y Operadores de Servicios:
	    MODE        Cambia los modos de un canal
	    KICK        Patea (kicks) a un usuario de un canal
	    CLEARMODES  Remueve ciertos modos de un canal
	    CLEARCHAN   Remueve todos los usuarios de un canal (pateo masivo)
	    KILLCLONES  Desconecta (kills) todos los usuarios con cierta mscara
	    AKILL       Manipula la lista AKILL
	    SESSION     Vea la lista de sesiones para una mscara
	    EXCEPTION   Modifica la lista de excepcin de lmite de sesiones
	    LOGONNEWS   Define mensajes que ven los usuarios al conectarse
	    OPERNEWS    Define mensajes que ven los usuarios que usan /OPER
	
	Comandos disponibles solo a los Administradores de  Servicios:
	    OPER        Modifica la lista de Operadores de Servicios
	    JUPE        Impone el comando "Jupiter" para un servidor
	    RAW         Envia un comando "raw" al servidor de IRC
	    SET         Ajusta varias opciones globales de los Servicios
	    UPDATE      Fuerza una actualizacin immediata en el disco de las
	                    bases de datos de los servicios
	    SHUTDOWN    Graba la base de datos al disco y detiene los servicios
	    QUIT        Detiene los Servicios sin grabar la base de datos al disco
	    RESTART     Graba la base de datos al disco y recomienza los servicios
	    SU          Obtenga privilegios de Super-Usuario de los Servicios
	
	Comandos disponibles solo al Super-Usuario de los Servicios:
	    ADMIN       Modifica la lista de Administradores De Los Servicios
	
	Nota: Todos los comandos enviados a %S son archivados!

OPER_HELP_GLOBAL
	Sintaxis: GLOBAL Mensaje
	
	Permite a los IRCops enviar mensajes a todos los usuarios en la red.
	El mensaje ser enviado desde el apodo %s.

OPER_HELP_STATS
	Sintaxis: STATS [RESET | AKILL | ALL]
	
	Sin opciones, muestra la cantidad de usuarios y IRCops en
	lnea (excluyendo Servicios), el mas alto nmero de usuarios 
	en lnea desde que los servicios se pusieron en funcionamiento,
	y desde cuando estn funcionando los servicios.
	
	Con la opcin RESET, reajusta la cuenta cuenta mxima de
	usuarios a la del nmero de usuarios en lnea actualmente.
	
	Con el parmetro AKILL muestra la longitud de la lista de
	AKILL y la fecha actual de expiracin.
	
	El parmetro ALL solo est disponible para los
	Administradores de Servicios y muestra el uso de memoria de
	los Servicios.  Utilizar esta opcin puede congelar los
	Servicios por un breve perodo de tiempo en grandes redes,
	por lo tanto no abuse de ella!
	
	UPTIME puede ser usado como un sinnimo de STATS.

OPER_HELP_OPER
	Sintaxis: OPER ADD Apodo
	          OPER DEL Apodo
	          OPER LIST
	
	Habilita a los Administradores de Servicios para agregar
	(ADD), borrar (DEL) o listar (LIST) usuarios de la lista de
	operadores.  Un usuario que se encuentre en la lista de
	operadores y que se identifique ante %s podr acceder
	a los comandos de Operador de Servicios.
	
	Cualquiera de los operadores de IRC (IRCops) puede utilizar
	el comando OPER LIST. Todos los otros comandos solo pueden
	ser utilizados por los Administradores de Servicios.

OPER_HELP_ADMIN
	Sintaxis: ADMIN ADD Apodo
	          ADMIN DEL Apodo
	          ADMIN LIST
	
	Habilita a los sper-usuarios de los Servicios a agregar
	(ADD), eliminar (DEL) o listar (LIST) usuarios de la lista
	de administradores.  Un usuario que se encuentre en la lista
	de operadores y que se identifique ante %s podr
	acceder a los comandos de Administrador de Servicios.
	
	Cualquiera de los operadores de IRC (IRCops) puede utilizar
	el comando ADMIN LIST.  Todos los otros comandos solo pueden
	ser utilizados por el sper-usuarios de los Servicios.

OPER_HELP_MODE
	Sintaxis: MODE Canal Modos
	
	Habilita a los operadores de Servicios a establecer los
	modos para cualquier canal.  Los parmetros son los mismos
	que se utilizan en la forma estndar de /MODE.
	
	Solo disponible para los Operadores de Servicios.

OPER_HELP_CLEARMODES
	Sintaxis: CLEARMODES Canal [ALL]
	
	Elimina los modos binarios (i,k,l,m,n,p,s,t) y los bloqueos (bans)
	de un canal. Si el parmetro ALL es dado, tambin quita los 
	modos Operador y voz que haya en el canal (modos +o y +v).
	
	Solo disponible para los Operadores de Servicios.

OPER_HELP_CLEARCHAN
	Sintaxis: CLEARCHAN Canal
	
	Remueve todos los usuarios de un canal (pateo masivo).
	
	Limitado a los Operadores de Servicios.

OPER_HELP_KICK
	Sintaxis: KICK Canal Usuario Razn
	
	Habilita a un IRCop a sacar a un usuario de cualquier canal.
	Los parmetros son los mismos que para un /KICK comn.  El
	mensaje de kick mostrar al usuario el nombre del IRCop que
	est enviando el comando. Por ejemplo:	
	
	*** SpamMan has been kicked off channel #my_channel by %S (Alcan (Flood))
	
	Solo disponible para los Operadores de Servicios.

OPER_HELP_AKILL
	Sintaxis: AKILL ADD [+Expiracin] Mscara Razn
	        AKILL DEL Mscara
	        AKILL LIST [Mscara] [NOEXPIRE]
	        AKILL VIEW [Mscara] [NOEXPIRE]
	        AKILL COUNT
	
	Permite a los Operadores de servicios manipular la lista AKILL.
	Si un usuario que figura en dicha lista, intenta conectarse, los
	Servicios impondrn un KILL para el usuario y darn instrucciones 
	a todos los servidores donde esta opcin es disponible, que agreguen
	un ban (k-line) para la mscara que coincida con la del usuario.
	
	AKILL ADD agrega el usuario dado (con la mscara usuario@host)
	a la lista de akill por la razn dada (que debe ser dada).
	AKILL DEL quita el usuario dado de la lista de AKILL si el
	mismo est presente.
	AKILL LIST muestra todos los usuarios que estn actualmente
	en la lista. Si una mscara es dada, el listado estar
	limitado a las ocurrencias.
	AKILL VIEW es mas explcito que AKILL LIST, dado que muestra
	quien agreg el AKILL, la fecha en que fue hecho, cuando
	expira, la mscara usuario@host utilizada y la razn.
	AKILL COUNT simplemente retorna el nmero de AKILLs en la lista AKILL.

	Opcionalmente, un tiempo de expiracin puede ser
	suministrado con el comando AKILL ADD.  El tiempo de
	expiracin PRECEDE a la mscara usuario@host y es
	especificado como un entero (esto es, sin decimales) seguido
	de: d para especificar das, h (horas), o m (minutos).
	Combinaciones (como 1h30m) no estn permitidas.  Si un
	especificador de unidades no es incluido, originalmente se
	asumen DIAS (entonces, poner +30 sin nada, significa 30
	das).  Para agregar un AKILL que NO expira, utilice +0.  Si
	la mscara de usuario comienza con +, un perodo de
	expiracin deber ser indicado, an si es el mismo perodo
	que el asignado originalmente.  El tiempo de expiracin por
	defecto, se puede ver utilizando el comando STATS AKILL.
	
	La razn est indicada para uso de los IRCops, y NO ser
	mostrada al usuario cuando se efecte el KILL.
	
	Solo disponible para los Operadores de Servicios.

OPER_HELP_EXCEPTION
	Sintaxis: EXCEPTION ADD [+Expiracin] Mscara Lmite Razn
	          EXCEPTION DEL {Mscara | Lista}
	          EXCEPTION MOVE Nmero NuevoNmero
	          EXCEPTION LIST [Mscara | Lista]
	          EXCEPTION VIEW [Mscara | Lista]
	
	Permite a los administradores de Servicios manipular la lista de las
	mquinas (hosts) que tienen lmite de sesiones especficas - permitiendo
	a ciertas mquinas, como los servidores de shell, a que carguen mas
	del nmero permitido de clientes al mismo tiempo. Cuando una mquina
	alcanza su lmite de sesiones, culquier cliente que trate de conectarse
	desde aquella mquina ser desconectado (killed). Antes de esto, ellos
	sern, notificados via /NOTICE por %S, sobre dnde buscar ayuda acerca 
	de lmite de sesiones. El contenido de esta nota es una opcin en config.
	
	EXCEPTION ADD agrega la mscara de una mquina a la lista de excepcin.
	Note: Mscaras como apodo!usuario@host y usuario@host son invlidas!
	Solamente mscaras reales, tales como mquina.host.dom y *.host.dom,
	son permitidas porque el limitado de sesiones no toma en cuenta apodos o
	nombres de usuario. lmite debe ser un nmero mayor o igual que cero.
	Esto determina cuantas sesiones es permitido cargar a esta mquina (host)
	simultaneamente. Un valor de cero significa que dicha mquina disfruta 
	de sesines ilimitadas. Vea ayuda de AKILL para detalles sobre formato
	del parmetro opcional Expiracin.
	EXCEPTION DEL remueve la mscara dada de la lista de excepcin.
	EXCEPTION MOVE mueve el Nmero de excepcin al NuevoNmero. Si 
	NuevoNmero est ya siendo usado por otra excepcin, su nmero ser
	cambiado un un nmero mayor para hacer espacio.
	EXCEPTION LIST y EXCEPTION VIEW muestran cada excepcin actual;
	si la mscara opcional es dada, la lista est limitada a aquellas
	excepciones que concuerdan con la mscara . La diferencia es que
	EXCEPTION VIEW es mas explcito, mostrando el nombre de la persona 
	que agreg la excepcin, su lmite de sesin, razn, mscara de la 
	mquina, yla fecha de expiracin con la hora.
	
	Note que un cliente al conectarse "usar" la primera excepcin que 
	concuerde con la mquina de donde se conecta. Listas de excepcin   
	grandes junto a mscaras de excepcin que concuerden apliamente 
	afectarn negativamente en la eficiencia de los servicios.
	
	Limitado a Administradores de Servicios.

OPER_HELP_SESSION
	Sintaxis: SESSION LIST Nm-Lmite
	          SESSION VIEW Mscara
	
	Permite a Administradores de Servicios ver lista de sesin.
	
	SESSION LIST lista  mscaras con al menos sesiones lmites.
	El lmite debe ser un nmero mayor que 1. Esto es para
	prevenir el listado accidental de el gran nmero de mquinas o
	mscaras con una sola sesin.
	SESSION VIEW muestra informacin detallada sobre una mscara o
	mquina especifica - incluyendo la cuenta de sesin curriente y 
	lmite de sesin. El valor mscara no puede inclur comodnes.
	
	Vea la ayuda de EXCEPTION para mas informacin sobre limitado
	de sesiones y sobre como fijar lmites de sesiones especificos a
	ciertas mquinas y grupos de esas mquinas.
	
	Limitado a Administradores de Servicios.

OPER_HELP_SU
	Sintaxis: SU Contrasea
	
	Permite acceso a funciones que requieren privilegios de
	super-usuario de los servicios.  La contrasea es la misma
	fijada con el comando SET SUPASS; note que la contrasea
	debe ser fijada antes de usar este comando.  Privilegios de
	Super-usuario solamente duran hasta que usted cambie su apodo
	o se desconecte de IRC.
	
	AVISO!: Si usted ingresa una contrasea incorrecta, Entonces
	los servicios enviarn un mensaje de aviso a todos los IRCops.
	
	Limitado a Administradores de Servicios.

OPER_HELP_SET
	Sintaxis: SET opcin Ajuste
	
	Ajusta varias opciones globales de los Servicios.  Algunas
	de las opciones actualmente definidas son:
	    READONLY   Fija servicios en modo de leer-solamente
	    DEBUG      Activa/desactiva el modo de deteccin de errores
	    SUPASS     Fija contrasea para el comando SU (super-usuario)
	
	Limitado a Administradores de Servicios.

OPER_HELP_SET_READONLY
	Sintaxis: SET READONLY {ON | OFF}
	
	Activa o desactiva el modo de leer-solamente.  En modo de 
	leer-solamente, los usuarios regulares no podrn modificar
	las bases de datos de los servicios, incluyendo las listas
	de acceso de canales y apodos, ect. IRCops con suficientes
	privilegios si podrn modificar la lista AKILL asi como 
	cancelar o prohibir apodos o canales, pero ninguno de estos
	cambios ser grabado al disco a menos que se desactive el modo 
	de leer-solamente antes que los servicios sean desactivados o
	re-activados.
	
	Esta opcin es equivalente a la opcin -readonly en la lnea
	de comandos.

OPER_HELP_SET_DEBUG
	Sintaxis: SET DEBUG {ON | OFF | Nm}
	
	Activa/Desactiva el modo de deteccin de errores.  En modo de
	deteccin de errores, toda la informacion enviada a o desde los
	servicios asi como un nmero considerable de mensajes de chequeo
	son escritos en un archivo en el disco, Si se especifica Nm,
	el modo de deteccin de errores es activado con el nivel de
	deteccin fijado a Nm.
	
	Esta opcin es equivalente a la opcin -debug en la lnea
	de comandos.

OPER_HELP_SET_SUPASS
	Sintaxis: SET SUPASS [Contrasea]
	
	Fija la contrasea que se usar para el comando SU.  La
	contrasea debe ser fijada una vez antes de usar el comando SU
	por primera vez.  Si no se establece una contrasea, el comando
	SU no estar disponible.
	
	Esta opcin solo puede ser fijada por el Super-usuario de servicios.

OPER_HELP_JUPE
	Sintaxis: JUPE Servidor [Razn]
	
	Ordena a Servicios que ejecuten el comando jupiter en un servidor
	-- eso es, crear un "servidor" falso conectado a los servicios
	que evita que el servidor real con ese nombre se conecte.  Esta
	opcin puede ser removida usando un SQUIT estandar.  Si se da
	una razn, esta es colocada en el area de informacin del servidor;
	de otra manera, el area de informacin sobre el servidor contendr
	el texto "Jupitered by <apodo>", mostrando el apodo de la persona
	que desenganch (jupitered) al servidor.
	
	Limitado a Administradores de Servicios.

OPER_HELP_RAW
	Sintaxis: RAW Texto
	
	Enva una cadena de caracteres directamente al servidor al
	cual los Servicios estn conectados.  Esta orden tiene un 
	muy limitado rango de usos, y puede causar estragos en una
	red o causar que los servicios caigan de no ser utilizado
	apropiadamente. NO USE ESTE COMANDO a menos que usted
	est completamente seguro de lo que est haciendo!
	
	Limitado a Administradores de Servicios.

OPER_HELP_UPDATE
	Sintaxis: UPDATE
	
	Causa que los Servicios actualicen las bases de datos tan
	pronto como usted enva el comando.
	
	Limitado a Administradores de Servicios.

OPER_HELP_QUIT
	Sintaxis: QUIT
	
	Causa la desactivacin de los Servicios; las bases de datos
	no se graban.  Este comando no debe utilizarse a menos que
	se sospeche de un dao en las bases de datos en-memoria y no
	deseen grabarse.  Para desactivacin normal de los
	Servicios, utilice el comando SHUTDOWN.
	
	Limitado a Administradores de Servicios.

OPER_HELP_SHUTDOWN
	Sintaxis: SHUTDOWN
	
	Causa que los Servicios graben todas las bases de datos y despues se desactiven.
	
	Limitado a Administradores de Servicios.

OPER_HELP_RESTART
	Sintaxis: RESTART
	
	Causa que los servicios graben todas las bases de datos y
	luego se desactiven. (ejemplo: salir e immediatamente
	re-hacer el ejecutable).
	
	Limitado a Administradores de Servicios.	

OPER_HELP_KILLCLONES
	Sintaxis: KILLCLONES Apodo
	
	Desconecta (Kills) todos los usuarios que tengan la misma
	mscara que Apodo. un KILL temporario, en la forma *@mscara,
	es agregado para prevenir que los clientes ofensivos se reconecten
	immediatamente. un wallops es tambin enviado indicando quien us
	el comando, que mscara fue afectada y cuantos usuarios fueron 
	desconectados. Esto es muy til cuando es necesario remover
	numerosos clones de la red.
	
	Limitado a Administradores de Servicios.


###########################################################################
#
# StatServ help messages
#
############################################################################

STAT_HELP
	%S provee informacin estadstica sobre la red de IRC,
	sus servidores y sus usuarios. Para informacin sobre un
	comando especfico, Escriba /msg %S HELP Comando.
	
	    SERVERS     Estadsticas del servidor
	    USERS       Estadsticas de los usuarios

STAT_HELP_SERVERS
	Sintaxis: SERVERS STATS
	          SERVERS LIST [Mscara]
	          SERVERS VIEW [Mscara] [ONLINE | OFFLINE]
	
	Muestra estadsticas relacionadas a los servidores de la red.
	
	SERVERS STATS muestra un sumrio breve de los servidores
	actualmente visibles (en lnea) e invisibles (no en lnea) a
	los Servicios.
	SERVERS LIST muestra una lista de servidores en lnea y
	estadsticas corrientes sobre cada uno de ellos.
	SERVERS VIEW muestra una lista de servidores en o fuera de
	lnea con estadsticas detalladas sobre cada uno de ellos. las
	opciones ONLINE y OFFLINE causan, respectivamente, que 
	solo los servidores en lnea o fuera de lnea sean mostrados.
	
	Utilice la opcin Mscara para limitar el tipo de estadsticas
	que sern mostradas sobre el servidor.

STAT_HELP_USERS
	Sintaxis: USERS STATS
	
	Muestra estadsticas relacionadas a los usuarios de la red.

STAT_SERVROOT_HELP_SERVERS
	Sintaxis: SERVERS STATS
	          SERVERS LIST [Mscara]
	          SERVERS VIEW [Mscara] [ONLINE | OFFLINE]
	          SERVERS DELETE Servidor
	          SERVERS COPY Servidor NuevoNombre
	          SERVERS RENAME Servidor NuevoNombre
	
	Muestra estadsticas relacionadas a los servidores de la red.
	
	SERVERS STATS muestra un sumrio breve de los servidores
	actualmente visibles (en lnea) e invisibles (no en lnea) a
	los Servicios.
	SERVERS LIST muestra una lista de servidores en lnea y
	estadsticas corrientes sobre cada uno de ellos.
	SERVERS VIEW muestra una lista de servidores en o fuera de
	lnea con estadsticas detalladas sobre cada uno de ellos. las
	opciones ONLINE y OFFLINE causan, respectivamente, que 
	solo los servidores en lnea o fuera de lnea sean mostrados.
	
	Utilice la opcin Mscara para limitar el tipo de estadsticas
	que sern mostradas sobre el servidor.
	
	DELETE borra las estadsticas del servidor especificado.
	COPY duplica un grupo de estadsticas del servidor.
	RENAME renombra un grupo de estadsticas del servidor.
	Estos tres comandos estn limitados al Super-Usuario 
	de los Servicios.
