# Emacs: -*- mode: fundamental; coding: binary -*-

# Spanish language file.
#
# IRC Services is copyright (c) 1996-2004 Andrew Church.
#     E-mail: <achurch@achurch.org>
# Parts written by Andrew Kempe and others.
# This program is free but copyrighted software; see the file COPYING for
# details.

# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, please inform
# the Services developers.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Espaol (Spanish)

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Dom
	Lun
	Mar
	Mie
	Jue
	Vie
	Sab
# %A
STRFTIME_DAYS_LONG
	Domingo
	Lunes
	Martes
	Miercoles
	Jueves
	Viernes
	Sabado
# %b
STRFTIME_MONTHS_SHORT
	Ene
	Feb
	Mar
	Abr
	May
	Jun
	Jul
	Ago
	Sep
	Oct
	Nov
	Dic
# %B
STRFTIME_MONTHS_LONG
	Enero
	Febrero
	Marzo
	Abril
	Mayo
	Junio
	Julio
	Agosto
	Septiembre
	Octubre
	Noviembre
	Diciembre


# "day", "hour", "minute", and "second" in singular and plural.
# These must be preceded by spaces if the language requires them
# (e.g. in English: "10 hours", not "10hours").
STR_DAY
	 da
STR_DAYS
	 das
STR_HOUR
	 hora
STR_HOURS
	 horas
STR_MINUTE
	 minuto
STR_MINUTES
	 minutos
STR_SECOND
	 segundo
STR_SECONDS
	 segundos
# Separator used between units of time; in English, a comma followed by a
# space (the ", " in "3 hours, 10 minutes").
STR_TIMESEP
	, 

# This is used in ChanServ/NickServ INFO displays, and is a comma followed
# by a space (", " -- trailing space is significant), or the equivalent in
# the language's character set.
COMMA_SPACE
	, 


# Various error messages.
INTERNAL_ERROR
	Error Interno - imposible procesar comando.
SERVICES_IS_BUSY
	Los servicios estn muy ocupados en este momento; favor de intentar mas tarde nuevamente.

UNKNOWN_COMMAND
	Comando desconocido %s.
UNKNOWN_COMMAND_HELP
	Comando desconocido %s.  Escriba /msg %s HELP para ayuda.
SYNTAX_ERROR
	Sintaxis: %s
MORE_INFO
	Escriba /msg %s HELP %s para ms informacin.
NO_HELP_AVAILABLE
	No existe ayuda disponible para %s.
MISSING_QUOTE
	Faltan las doble comillas (").

BAD_EMAIL
	Direccin e-mail debe ser en el formato Usuario@ProveedorWeb.  No debes usar colores, negritas, subrayado, ni reverso, o alguno de estos caracteres: , : ; | \ " ( ) < > [ ]
BAD_URL
	URLs deben ser en el formato http://ProveedorWeb[:puerto]/... (o ftp://, etc.).
BAD_USERHOST_MASK
	Mscara debe ser en el formato Usuario@ProveedorWeb.
BAD_NICKUSERHOST_MASK
	Mscara debe ser en el formato Apodo!Usuario@ProveedorWeb.
BAD_EXPIRY_TIME
	Fecha de expiracin invlida.

SENDMAIL_NO_RESOURCES
	El sistema est actualmente demasiado ocupado para enviar correo; Favor trate ms tarde nuevamente.
READ_ONLY_MODE
	Notcia: Los Servicios estn en modo de leer solamente; cambios no sern grabados!
PASSWORD_INCORRECT
	Contrasea incorrecta.

PASSWORD_WARNING
	Advertensia: Despues de una contrasea incorrecta ms usted ser desconectado.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Acceso negado.
PERMISSION_DENIED
	Permiso negado.

MORE_OBSCURE_PASSWORD
	Favor trate de nuevo con una contrasea ms difcil. Contraseas deben ser de 5 caracteres mnimo,no debe ser algo fcil de descifrar (ejemplo. su verdadero nombre o su apodo).
PASSWORD_TRUNCATED
	Notcia:  Su contrasea a sido limitada a %d caracteres.

NICK_NOT_REGISTERED
	Su apodo no est registrado.
NICK_NOT_REGISTERED_HELP
	Su apodo no est registrado.  Escriba /msg %s HELP para ms informacin de como registrar su apodo.
NICK_TOO_LONG
	Apodos no deben tener ms de %d caracteres de largo.
NICK_INVALID
	%s no es un apodo vlido.
NICK_X_NOT_REGISTERED
	El apodo %s no est registrado.
NICK_X_ALREADY_REGISTERED
	El apodo %s ya est registrado!
NICK_X_NOT_IN_USE
	El apodo %s no est en uso en este momento.
NICK_X_FORBIDDEN
	El apodo %s no puede ser registrado o utilizado.
NICK_X_SUSPENDED
	El apodo %s est suspendido y no se puede utilizar o identificarse por l.
NICK_X_SUSPENDED_MEMOS
	El apodo %s est suspendido y no puede recibir mensajes.
NICK_IDENTIFY_REQUIRED
	Identificacin con su contrasea se requiere para usar ese comando.
	Vuelva a intentar despus de escribir /msg %s IDENTIFY Contrasea.
NICK_PLEASE_AUTH
	Su apodo no est an autenticado.  Favor de autenticar su apodo usando el cdigo de autenticacin incluido en el correo electrnico enviado a: %s
NICK_X_NOT_ON_CHAN_X
	El apodo %s no est actualmente en el canal %s.

CHAN_INVALID
	%s no es un nombre vlido de canal.
CHAN_X_NOT_REGISTERED
	El canal %s no est registrado.
CHAN_X_NOT_IN_USE
	El canal %s no est en uso actualmente.
CHAN_X_FORBIDDEN
	El canal %s no puede ser registrado o utilizado.
CHAN_X_SUSPENDED
	El canal %s est suspendido y no se puede utilizar o identificarse por l.
CHAN_X_SUSPENDED_MEMOS
	El canal %s est suspendido y no puede recibir mensajes.
CHAN_IDENTIFY_REQUIRED
	Identificacin con su contrasea se requiere para usar ese comando.
	Vuelva a intentar despus de escribir /msg %s IDENTIFY %s Contrasea.

SERV_X_NOT_FOUND
	El servidor %s no fue encontrado.

EXPIRES_NONE
	no expira
EXPIRES_SOON
	expira en la siguiente actualizacin de la base de datos
EXPIRES_IN
	expira en %s

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Este apodo pertence a otra persona.  Favor de escoger otro.  (Si este es su apodo, escriba /msg %s IDENTIFY Contrasea.)
NICK_IS_SECURE
	Este apodo est registrado y protegido.  Si es su apodo, escriba /msg %s IDENTIFY Contrasea.  De lo contrario, favor de escoger un apodo diferente.
NICK_MAY_NOT_BE_USED
	Este apodo no puede utilizarse. Favor de escoger otro.
DISCONNECT_IN_1_MINUTE
	Si no cambia dentro de un minuto, ser desconectado.
DISCONNECT_IN_20_SECONDS
	Si no cambia dentro de 20 segundos, ser desconectado.
DISCONNECT_NOW
	Este apodo ha sido registrado; no lo puedes utilizar.  Favor de escoger otro apodo antes de reconectar.
FORCENICKCHANGE_IN_1_MINUTE
	Si no cambias dentro de un minuto, cambiar tu apodo.
FORCENICKCHANGE_IN_20_SECONDS
	Si no cambias dentro de 20 segundos, cambiar tu apodo.
FORCENICKCHANGE_NOW
	Este apodo ha sido registrado; no lo puedes utilizar.  Su apodo est ahra siendo cambiado a %s.
NICK_EXPIRES_SOON
	Nota: La registracin de su apodo expirar en %s.  Si usted desea continuar utilizando su apodo, favor de identificarse a %s Escribiendo: /msg %s IDENTIFY Contrasea
NICK_EXPIRED
	Nota: La registracin de su apodo ha expirado.  Favor de re-registrar su apodo si usted desea continuar utilizandolo.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER Contrasea [Correo-Electrnico]
NICK_REGISTER_REQ_EMAIL_SYNTAX
	REGISTER Contrasea Correo-Electrnico
NICK_REGISTRATION_DISABLED
	Lo sentimos, el regstro de apodos est temporaralmente deshabilitado.
NICK_REGISTRATION_FAILED
	Lo sentimos, la registracin fall.
NICK_REG_PLEASE_WAIT
	Favor de esperar %s antes de utilizar nuevamente el comando REGISTER.
NICK_REG_PLEASE_WAIT_FIRST
	Favor de esperar %s antes de utilizar el comando REGISTER.
NICK_CANNOT_BE_REGISTERED
	El apodo %s no puede ser registrado.
NICK_REGISTER_EMAIL_UNAUTHED
	La direccin de correo electrnico (E-mail) que usted proevi no ha sido an autenticada. Por favor use el comando AUTH para autenticar la direccin antes de registrar un nuevo apodo con ella.
NICK_REGISTER_TOO_MANY_NICKS
	Usted tiene demasiados apodos registrados (%d, mximo de %d).  No puede registrarse ms a menos que cancele algunos de sus apodos actuales.
NICK_REGISTERED
	El apodo %s ha sido registrado a usted.
NICK_PASSWORD_IS
	Su contrasea es %s -- recuerde esto para uso posterior.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY Contrasea
NICK_IDENTIFY_FAILED
	Lo sentimos, la identificacin fall.
NICK_IDENTIFY_EMAIL_MISSING
	Usted debe fijar una direccin de correo electrnico para su apodo antes de continuar usandolo.  Favor de fijar una ahra con el comando: /msg %s SET EMAIL Direccin
NICK_IDENTIFY_SUCCEEDED
	Contrasea aceptada - ahra se le ha reconocido.

# DROP responses
NICK_DROP_SYNTAX
	DROP Contrasea
NICK_DROP_WARNING
	Nota: El comando DROP cancelar todos sus apodos ligados!
NICK_DROP_DISABLED
	Lo sentimos, la cancelacin de apodos ha sido temporaralmente dishabilatada.
NICK_DROP_FAILED
	Lo sentimos, la cancelacin del apodo fall.
NICK_DROPPED
	Su apodo ha sido cancelado.
NICK_DROPPED_LINKS
	Su apodo y todos los apodos ligados han sido cancelados.

# DROPNICK responses
NICK_DROPNICK_SYNTAX
	DROPNICK Apodo
NICK_X_DROPPED
	El apodo %s ha sido cancelado.
NICK_X_DROPPED_LINKS
	El apodo %s y todos los apodos ligados han sido cancelados.

# DROPEMAIL and DROPEMAIL-CONFIRM responses
NICK_DROPEMAIL_SYNTAX
	DROPEMAIL Patrn
NICK_DROPEMAIL_PATTERN_TOO_LONG
	El patrn dado es demaciado largo (%d caractres mximo).
NICK_DROPEMAIL_NONE
	Ningn apodo tiene una direccin de correo electrnico que concuerde con el patrn especificado.
NICK_DROPEMAIL_COUNT
	%d apodos tienen direccines de correo electrnico que concuerdan con el patrn especificado.
	Para cancelar estos apodos, escriba: /msg %s DROPEMAIL-CONFIRM %s
NICK_DROPEMAIL_CONFIRM_SYNTAX
	DROPEMAIL-CONFIRM Patrn
NICK_DROPEMAIL_CONFIRM_UNKNOWN
	El patrn especificado no es reconocido.  Por favor utilice el comando DROPEMAIL nuevamente con este patrn antes de usar el comando DROPEMAIL-CONFIRM.
NICK_DROPEMAIL_CONFIRM_DROPPING
	Cancelando %d apodos...
NICK_DROPEMAIL_CONFIRM_DROPPED
	Cancelacin de apodos completado.

# SET responses
NICK_SET_SYNTAX
	SET Opcin Parmetros
NICK_SET_OPER_SYNTAX
	SET [Apodo] Opcin Parmetros
NICK_SET_DISABLED
	Lo sentimos, la configuracin de opciones del apodo est temporalmente deshabilitada.
NICK_SET_UNKNOWN_OPTION
	Opcin SET desconocida %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Opcin SET %s desconocida, o su apodo no est registrado.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Lo sentimos, la contrasea no se pudo cambiar.
NICK_SET_PASSWORD_CHANGED
	Contrasea cambiada.
NICK_SET_PASSWORD_CHANGED_TO
	Contrasea cambiada a %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE Nmero
NICK_SET_LANGUAGE_UNKNOWN
	Nmero %d de lenguaje desconocido.  Escriba /msg %s HELP SET LANGUAGE para ver la lista de lenguajes disponibles.
NICK_SET_LANGUAGE_CHANGED
	Lenguaje cambiado a %s.

# SET URL responses
NICK_SET_URL_CHANGED
	URL para %s cambiado a %s.

# SET EMAIL responses
NICK_SET_EMAIL_UNAUTHED
	La direccin de correo electrnico (E-mail) que usted proevi no ha sido an autenticada. Por favor use el comando AUTH para autenticar la direccin primeramente.
NICK_SET_EMAIL_TOO_MANY_NICKS
	%s ya tiene %d apodos registrados (mximo de %d).  El cambio de correo-electrnico fall
NICK_SET_EMAIL_CHANGED
	Correo electrnico (EMAIL) para %s cambiada a %s.

# SET INFO responses
NICK_SET_INFO_CHANGED
	Informacin para %s cambiada.

# SET KILL responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Proteccin de KILL ahra Activada (ON).
NICK_SET_KILL_QUICK
	Proteccin de KILL ahra Activada (ON), con una espera reducida.
NICK_SET_KILL_IMMED
	Proteccin de KILL Activada (ON), sin espera reducida.
NICK_SET_KILL_IMMED_DISABLED
	La opcin IMMED no est disponible en esta red.
NICK_SET_KILL_OFF
	Proteccin de KILL ahra Desactivada (OFF).

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Opcin SECURE ahra Activada (ON).
NICK_SET_SECURE_OFF
	Opcin SECURE ahra Desactivada (OFF).

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Opcin PRIVATE ahra Activada (ON).
NICK_SET_PRIVATE_OFF
	Opcin PRIVATE ahra Desactivada (OFF).

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Su correo electrnico ser ahra ocultada en la opcin de %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	Su correo electrnico ser ahra visible en la opcin de %s INFO.
NICK_SET_HIDE_MASK_ON
	Su ltima mscara de Usuario@ProveedorWeb ser ahra ocultada en la opcin de %s INFO.
NICK_SET_HIDE_MASK_OFF
	Su ltima mscara de Usuario@ProveedorWeb ser ahra visible en la opcin de %s INFO.
NICK_SET_HIDE_QUIT_ON
	Su ltimo mensaje de salida ser ahra ocultado en la opcin de %s INFO.
NICK_SET_HIDE_QUIT_OFF
	Su ltimo mensaje de salida ser ahra visible en la opcin de %s INFO.

# SET TIMEZONE responses
NICK_SET_TIMEZONE_SYNTAX
	SET TIMEZONE {UTC-Ms/Menos | Uso-Horario | DEFAULT}
NICK_SET_TIMEZONE_TO
	Su uso horario ha sido ajustado a UTC%c%d:%02d.
	La hora actual en este uso horario es %s.
NICK_SET_TIMEZONE_DEFAULT
	Su uso horario ha sido re-ajustado al uso horario de los Servicios.

# SET MAINNICK responses
NICK_SET_MAINNICK_NOT_FOUND
	El apodo %s no est ligado al apodo de usted.
NICK_SET_MAINNICK_CHANGED
	Su apodo principal ha sido cambiado a %s.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [Apodo] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	El apodo %s no expirar.
NICK_SET_NOEXPIRE_OFF
	El apodo %s si expirar.

# UNSET responses
NICK_UNSET_SYNTAX
	UNSET {URL | EMAIL | INFO}
NICK_UNSET_SYNTAX_REQ_EMAIL
	UNSET {URL | INFO}
NICK_UNSET_URL
	URL para %s est ahra Indefinido (Unset).
NICK_UNSET_EMAIL
	Correo electrnico (EMAIL) para %s est ahra Indefinido (Unset).
NICK_UNSET_INFO
	Informacin para %s est ahra Indefinida (Unset).
NICK_UNSET_EMAIL_BAD
	Usted no puede remover su correo electrnico (EMAIL).
NICK_UNSET_EMAIL_OTHER_BAD
	El correo electrnico (e-mail) de los apodos no puede ser removida.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [Mscara]
NICK_ACCESS_ALREADY_PRESENT
	Mscara %s ya existe en su lista de acceso.
NICK_ACCESS_REACHED_LIMIT
	Lo sentimos, solamente puede tener %d entradas de acceso para su apodo.
NICK_ACCESS_NO_NICKS
	Advertencia: Las mscaras de acceso de apodos no deben inclur apodos.  Por favor verifique y asegurarse de que ha ingresado la mscara Usuario@Proveedor correctamente.
NICK_ACCESS_ADDED
	%s aadido a su lista de acceso.
NICK_ACCESS_NOT_FOUND
	%s no fue encontrado en su lista de acceso.
NICK_ACCESS_DELETED
	%s removido de su lista de acceso.
NICK_ACCESS_LIST_EMPTY
	Su lista de acceso est vaca.
NICK_ACCESS_LIST
	Lista de acceso:
NICK_ACCESS_LIST_X_EMPTY
	Lista de acceso para %s est vaca.
NICK_ACCESS_LIST_X
	Lista de acceso para %s:

# LINK responses
NICK_OLD_LINK_SYNTAX
	LINK Apodo Contrasea
NICK_LINK_SYNTAX
	LINK Apodo
NICK_LINK_DISABLED
	Lo sentimos, el ligado de apodos esta temporalmente deshabilitado.
NICK_LINK_FAILED
	Lo sentimos, liga de apodo fall.
NICK_CANNOT_BE_LINKED
	El apodo %s no puede ser ligado.
NICK_OLD_LINK_SAME
	No puede ligar su apodo actual!
NICK_LINK_SAME
	No puede ligar su apodo actual!
NICK_LINK_ALREADY_LINKED
	El apodo %s ya est ligado al apodo de usted.
NICK_LINK_IN_USE
	El apodo %s est siendo usado en este momento.
NICK_LINK_TOO_MANY
	Usted no puede tener ms de %d apodos ligados a una misma liga.
NICK_LINK_TOO_MANY_NICKS
	Usted ya tiene %d apodos registrados (el mximo es %d).  la liga fall.
NICK_OLD_LINK_TOO_MANY_CHANNELS
	No fue posible ligar el apodo %s: demasiados canales registrados (combinacin mxima %d).
NICK_OLD_LINKED
	Su apodo ha sido ligado a %s.
NICK_LINKED
	El apodo %s ha sido ligado a su apodo actual.

# UNLINK responses
NICK_OLD_UNLINK_SYNTAX
	UNLINK [Apodo Contrasea]
NICK_UNLINK_SYNTAX
	UNLINK Apodo
NICK_UNLINK_OPER_SYNTAX
	UNLINK Apodo [FORCE]
NICK_UNLINK_DISABLED
	Lo sentimos, el desligado de apodos esta temporalmente deshabilitado.
NICK_UNLINK_FAILED
	Lo sentimos, la liga no pudo ser removida.
NICK_UNLINK_SAME
	Usted no puede remover una liga de un apodo mientras lo est usando!
NICK_OLD_UNLINK_NOT_LINKED
	Su apodo no est ligado.
NICK_UNLINK_NOT_LINKED_YOURS
	El apodo %s no est ligado a su apodo.
NICK_UNLINK_NOT_LINKED
	El apodo %s no est ligado.
NICK_OLD_UNLINKED
	Su apodo ha sido desligado de %s.
NICK_UNLINKED
	El apodo %s ha sido desligado del apodo de usted.
NICK_X_UNLINKED
	El apodo %s ha sido desligado de %s.

# LISTLINKS responses
NICK_OLD_LISTLINKS_SYNTAX
	LISTLINKS Apodo
NICK_LISTLINKS_SYNTAX
	LISTLINKS
NICK_LISTLINKS_HEADER
	Lista de apodos ligados a %s:
NICK_LISTLINKS_FOOTER
	%d apodos ligados.

# INFO responses
NICK_INFO_SYNTAX
	INFO Apodos [ALL]
NICK_INFO_REALNAME
	%s es %s
NICK_INFO_ADDRESS
	  ltima direccin vista: %s
NICK_INFO_ADDRESS_ONLINE
	    Est en lnea usando: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s est actualmente en lnea.
NICK_INFO_TIME_REGGED
	       Fecha de regstro: %s
NICK_INFO_LAST_SEEN
	Se le vio por ltima vez en: %s
NICK_INFO_LAST_QUIT
	ltimo mensaje de salida: %s
NICK_INFO_URL
	                     URL: %s
NICK_INFO_EMAIL
	      Correo electrnico: %s
NICK_INFO_EMAIL_UNAUTHED
	   Correo electrnico: %s (No-Verificado)
NICK_INFO_INFO
	      Informacin: %s
NICK_INFO_OPTIONS
	                Opciones: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Proteccin de KILL
NICK_INFO_OPT_SECURE
	Seguro
NICK_INFO_OPT_PRIVATE
	Privado
NICK_INFO_OPT_NONE
	Ninguna
NICK_INFO_NO_EXPIRE
	Este apodo no expirar.
NICK_INFO_SUSPEND_DETAILS
	Suspendido por %s en %s (%s).
NICK_INFO_SUSPEND_REASON
	Razn: %s
NICK_INFO_SHOW_ALL
	Para ms informacin, escriba: /msg %s INFO %s ALL

# LISTCHANS responses
NICK_LISTCHANS_SYNTAX
	LISTCHANS
NICK_LISTCHANS_NONE
	%s no ha registrado canal alguno.
NICK_LISTCHANS_HEADER
	Canales registrados por %s:
NICK_LISTCHANS_END
	Fin del listado (%d canales registrados).

# LIST responses
NICK_LIST_SYNTAX
	%s Patrn
NICK_LIST_OPER_SYNTAX
	%s Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
NICK_LIST_OPER_SYNTAX_AUTH
	%s Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
NICK_LIST_HEADER
	Lista de entradas asociadas a %s:
NICK_LIST_RESULTS
	Fin del listado - %d/%d asociaciones visibles.
NICK_LISTEMAIL_NONE
	(Ninguno fijado)

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER nickname [password]
NICK_NO_RECOVER_SELF
	Usted no puede utilizar el comando RECOVER en usted mismo!
NICK_RECOVERED
	El usuario que reclamaba su apodo ha sido desconectado.
	Escriba /msg %s RELEASE %s para recuperarlo ahra y no esperar a un minuto.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE Apodo [Contrasea]
NICK_RELEASE_NOT_HELD
	El apodo %s no est siendo retenido.
NICK_RELEASED
	La retencin de su apodo por los Servicios has sido liberada.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST Apodo [Contrasea]
NICK_NO_GHOST_SELF
	No puedes usar el comando GHOST en ti mismo!
NICK_GHOST_KILLED
	El fantasma con su apodo ha sido desconectado.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS Apodo
NICK_GETPASS_UNAVAILABLE
	El comando GETPASS no est disponible porque esta red est usando encripcin.
NICK_GETPASS_PASSWORD_IS
	Contrasea para %s es %s.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID Apodo
NICK_FORBID_SUCCEEDED
	El apodo %s est ahra prohibido.
NICK_FORBID_FAILED
	No se pudo prohibir el apodo %s!

# SUSPEND responses
NICK_SUSPEND_SYNTAX
	SUSPEND [+Expiracin] Apodo Razn
NICK_SUSPEND_SUCCEEDED
	El apodo %s, y todos los apodos ligados a este, han sido suspendidos.
NICK_SUSPEND_ALREADY_SUSPENDED
	El apodo %s ya est suspendido.

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND Apodo
NICK_UNSUSPEND_SUCCEEDED
	El apodo %s ya no est suspendido.
NICK_UNSUSPEND_NOT_SUSPENDED
	El apodo %s no est suspendido.

################ autojoin module messages/responses

# AJOIN responses
NICK_AJOIN_SYNTAX
	AJOIN {ADD | DEL | LIST} [canal]
NICK_AJOIN_ADD_SYNTAX
	AJOIN ADD canal
NICK_AJOIN_DEL_SYNTAX
	AJOIN DEL canal
NICK_AJOIN_ALREADY_PRESENT
	El canal %s ya est presente en su lista autojoin (Auto-Ingreso).
NICK_AJOIN_LIST_FULL
	Lo sentimos, solo puedes tener %d entradas de autojoin (Auto-Ingreso) por cada apodo.
NICK_AJOIN_ADDED
	%s agregado a su lista autojoin (Auto-Ingreso).
NICK_AJOIN_NOT_FOUND
	%s no fue encontrado en su lista autojoin (Auto-Ingreso).
NICK_AJOIN_DELETED
	%s removido de su lista autojoin (Auto-Ingreso).
NICK_AJOIN_LIST_EMPTY
	Su lista autojoin (Auto-Ingreso) est vaca.
NICK_AJOIN_LIST
	Lista Autojoin (Auto-Ingreso):
NICK_AJOIN_LIST_X_EMPTY
	Lista Autojoin (Auto-Ingreso) para %s est vaca.
NICK_AJOIN_LIST_X
	Lista Autojoin (Auto-Ingreso) para %s:

################ mail-auth module messages/responses

# General-purpose messages
NICK_AUTH_SENT
	Un cdigo de autenticacin para su apodo ha sido enviado a %s.
NICK_AUTH_FOR_REGISTER
	Cuando reciba este mensaje, escriba /msg %s AUTH Cdigo (reemplace Cdigo por el cdigo de autenticacin incluido en el mensaje) para completar la registracin de su apodo.
NICK_AUTH_FOR_SET_EMAIL
	Cuando reciba este mensaje, escriba /msg %s AUTH Cdigo (reemplace Cdigo por el cdigo de autenticacin incluido en el mensaje) para completar el cambio a su direccin E-mail (Correo-electrnico)
	Favor note que usted no podr continuar usando su apodo a menos que complete el cambio.
NICK_AUTH_NOT_NEEDED
	No existe nada que necesite autenticacin en este momento.
NICK_AUTH_NO_AUTHCODE
	El apodo %s no tiene cdigo de autenticacin.
NICK_AUTH_HAS_AUTHCODE
	El apodo %s ya tiene un cdigo de autenticacin.
PASSWORD_WARNING_FOR_AUTH
	Advertensia: Despues de otro cdigo de autenticacin incorrecto usted ser desconectado.

# Mail text.  The last "%s" (before the user@host) in the body text is
# replaced by one of the NICK_AUTH_MAIL_TEXT_* messages.
NICK_AUTH_MAIL_SUBJECT
	Cdigo de autenticacin para %s
NICK_AUTH_MAIL_BODY
	El cdigo de autenticacin para su apodo (%s) es: %09d
	Favor de ingresar este cdigo a %s con el comando:
	    /msg %s AUTH %09d
	
	Este mensaje fue enviado por %s en respuesta a %s
	%s@%s.
NICK_AUTH_MAIL_TEXT_REG
	registracin por
NICK_AUTH_MAIL_TEXT_EMAIL
	un cambio de E-mail (Correo-Electrnico) por
NICK_AUTH_MAIL_TEXT_SENDAUTH
	un comando SENDAUTH de
NICK_AUTH_MAIL_BODY_SETAUTH
	El cdigo de autenticacin para su apodo (%s) es: %09d
	Favor de ingresar este cdigo a %s con el comando:
	    /msg %s AUTH %09d

# AUTH responses
NICK_AUTH_SYNTAX
	AUTH Cdigo
NICK_AUTH_DISABLED
	Lo sentimos, La autenticacin de apodos est temporaralmente deshabilatada.
NICK_AUTH_FAILED
	Ese cdigo de autenticacin es incorrecto.
NICK_AUTH_SUCCEEDED_REGISTER
	Autenticacin exitosa; la registracin de su apodo ha sido completada.
NICK_AUTH_SUCCEEDED_SET_EMAIL
	Autenticacin exitosa; su cambio de E-mail (Correo-Electrnico) ha sido completado.
NICK_AUTH_SUCCEEDED_SETAUTH
	Autenticacin exitosa; puedes continuar usando tu apodo ahra.

# SENDAUTH responses
NICK_SENDAUTH_SYNTAX
	SENDAUTH
NICK_SENDAUTH_TOO_SOON
	Favor de esperar %s antes de usar el comando SENDAUTH nuevamente.
NICK_SENDAUTH_FAILED
	Lo sentimos, no fue posible enviar el cdigo de autenticacin.

# SETAUTH responses
NICK_SETAUTH_SYNTAX
	SETAUTH Apodo
NICK_SETAUTH_NO_EMAIL
	El apodo %s no tiene un E-mail (Correo-Electrnico) establecido.
NICK_SETAUTH_AUTHCODE_SET
	Un nuevo cdigo de autenticacin (%09d) ha sido fijado para el apodo %s.
NICK_SETAUTH_SEND_FAILED
	Advertencia: no fue posible enviar correo a %s.
NICK_SETAUTH_SEND_TEMPFAIL
	Advertencia: no fue posible enviar correo a %s (insuficientes recursos).
NICK_SETAUTH_USER_NOTICE
	Usted debe autorizar su apodo antes de continuar usandolo.  Un cdigo de autenticacin ha sido enviado a su E-mail (Correo-Electrnico): %s
	Escriba: /msg %s HELP AUTH para ms informacin.

# GETAUTH responses
NICK_GETAUTH_SYNTAX
	GETAUTH Apodo
NICK_GETAUTH_AUTHCODE_IS
	El cdigo de autenticacin para el apodo %s es: %09d

# CLEARAUTH responses
NICK_CLEARAUTH_SYNTAX
	CLEARAUTH Apodo
NICK_CLEARAUTH_CLEARED
	El cdigo de autenticacin para el apodo %s ha sido removido.

################ sendpass module messages/responses

# Mail text
NICK_SENDPASS_MAIL_SUBJECT
	Contrasea para %s
NICK_SENDPASS_MAIL_BODY
	La Contrasea para su apodo es: %s
	
	Este mensaje fue enviado por %s en respuesta a un pedido SENDPASS de
	%s@%s.

# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS Apodo
NICK_SENDPASS_FAILED
	Lo sentimos, el envio de contrasea fall.
NICK_SENDPASS_NO_EMAIL
	El apodo %s no tiene una direccin de correo electrnico (E-mail) establecida.
NICK_SENDPASS_NOT_AUTHED
	La direccin de correo electrnico (E-mail) para el apodo %s no ha sido an autenticada.
# parameter is "NNN days/hours/minutes"
NICK_SENDPASS_TOO_SOON
	Favor de esperar %s antes de usar el comando SENDPASS nuevamente.
NICK_SENDPASS_SENT
	La contrasea para el apodo %s ha sido enviada a su correo electrnico (E-mail) registrado.

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Estatus de operador de canal automtico
CHAN_LEVEL_AUTOVOICE
	Modo +v automtico
CHAN_LEVEL_INVITE
	Permitido usar el comando INVITE
CHAN_LEVEL_AKICK
	Permitido usar el comando AKICK
CHAN_LEVEL_SET
	Permitido usar el comando SET (excluidos FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Permitido usar el comando CLEAR
CHAN_LEVEL_UNBAN
	Permitido usar el comando UNBAN
CHAN_LEVEL_OPDEOP
	Permitido usar los comandos OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Permitido ver la lista de acceso
CHAN_LEVEL_ACCESS_CHANGE
	Permitido modificar la lista de acceso
CHAN_LEVEL_MEMO
	Permitido alistar/leer los mensajes del canal (list/read)
CHAN_LEVEL_VOICE
	Permitido usar los comandos VOICE/DEVOICE
CHAN_LEVEL_AUTOHALFOP
	Estatus MedioOP (+h) automtico
CHAN_LEVEL_HALFOP
	Permitido usar los comandos HALFOP/DEHALFOP (MitadOP/No-MitadOP)
CHAN_LEVEL_AUTOPROTECT
	Estatus de Proteccin de canal (+a) automtico
CHAN_LEVEL_PROTECT
	Permitido usar los comandos PROTECT/DEPROTECT (Proteger/Desproteger)
CHAN_LEVEL_KICK
	Permitido usar el comando KICK
CHAN_LEVEL_STATUS
	Permitido usar el comando STATUS
CHAN_LEVEL_TOPIC
	Permitido usar el comando TOPIC

# Automatic responses
CHAN_IS_REGISTERED
	Este canal ha sido registrado con %s.
CHAN_MAY_NOT_BE_USED
	Este canal no puede ser utilizado.
CHAN_NOT_ALLOWED_TO_JOIN
	No le es permitido ingresar a este canal.

# Multi-purpose responses
CHAN_MUST_IDENTIFY_NICK
	Favor de identificarse con %s primero, usando el comando:
	/msg %s IDENTIFY Contrasea
CHAN_BOUNCY_MODES
	Lo sentimos, el comando %s est temporaralmente deshabilitado.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER Canal Contrasea Descripccin
CHAN_REGISTER_DISABLED
	Lo sentimos, la registracin de canales est temporalmente deshabilitada.
CHAN_REGISTER_SHORT_CHANNEL
	El canal # no puede ser registrado.
CHAN_REGISTER_NOT_LOCAL
	Canales locales no pueden ser registrados.
CHAN_REGISTER_INVALID_NAME
	Solo puedes registrar nombres de canales que comiencen con el signo #.
CHAN_MUST_REGISTER_NICK
	Usted debe registrar su apodo primeramente.  Escriba /msg %s HELP para informacin sobre como registrar apodos.
CHAN_MAY_NOT_BE_REGISTERED
	El canal %s no puede ser registrado.
CHAN_ALREADY_REGISTERED
	El canal %s ya est registrado!
CHAN_MUST_BE_CHANOP
	Usted debe ser operador del canal para poder registrarlo.
CHAN_REACHED_CHANNEL_LIMIT
	Lo sentimos, usted ya ha alcazado su lmite de %d canales.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Lo sentimos, usted ya ha excedido su lmite de %d canales.
CHAN_REGISTRATION_FAILED
	Lo sentimos, la registracin fall.
CHAN_REGISTERED
	Canal %s registrado bajo su apodo: %s
CHAN_PASSWORD_IS
	La contrasea de su canal es %s - recuerdela para uso posterior.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY Canal Contrasea
CHAN_IDENTIFY_FAILED
	Lo sentimos, la identificacin fall.
CHAN_IDENTIFY_SUCCEEDED
	Contrasea aceptada - usted ahra tiene acceso a nivel de fundador con %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP Canal
CHAN_DROP_DISABLED
	Lo sentimos, la cancelacin de regstro de canal est temporalmente deshabilitada.
CHAN_DROPPED
	El canal %s ha sido cancelado.

# SET responses
CHAN_SET_SYNTAX
	SET Canal Opcin Parmetros
CHAN_SET_DISABLED
	Lo sentimos, el ajuste de opciones de canal est temporalmente deshabilitada.
CHAN_SET_UNKNOWN_OPTION
	Opcin SET %s desconocida.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s tiene demasiados canales registrados.
CHAN_FOUNDER_CHANGED
	Fundador de %s cambiado a %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Sucesor para %s cambiado a %s.
CHAN_SUCCESSOR_IS_FOUNDER
	Usted no puede convertir al fundador de un canal tambin en sucesor.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Lo sentimos, fue imposible establecer la contrasea.
CHAN_PASSWORD_CHANGED
	Contrasea para %s cambiada.
CHAN_PASSWORD_CHANGED_TO
	Contrasea para %s cambiada a %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Descripcin de %s cambiada a %s.

# SET URL responses
CHAN_URL_CHANGED
	URL para %s cambiado a %s.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	Correo electrnico para %s cambiado a %s.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Mensaje de entrada para %s cambi.

# SET MLOCK responses
CHAN_SET_MLOCK_NEED_PLUS_MINUS
	Lista de Modos debe comenzar con un + (ms) o - (menos).
CHAN_SET_MLOCK_NEED_PARAM
	Parmetro requerido para MLOCK +%c.
CHAN_SET_MLOCK_NEED_POSITIVE
	Parmetro para MLOCK +%c debe ser un nmero positivo.
CHAN_SET_MLOCK_MODE_REG_BAD
	Modo +%c es siempre establecido en canales registrados, y no puede ser usado con MLOCK (Opcin Candado).
CHAN_SET_MLOCK_LINK_BAD
	Parmetro para MLOCK +%c no es un nombre vlido de canal.
CHAN_SET_MLOCK_LINK_SAME
	Parmetro para MLOCK +%c debe ser canal diferente.
CHAN_SET_MLOCK_LINK_NO_LIMIT
	MLOCK +%c requiere que se fije MLOCK +l tambien.
CHAN_SET_MLOCK_BAD_PARAM
	Parmetro invlido para MLOCK +%c.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Modo con caractr %c es desconocido e ignorado.
CHAN_SET_MLOCK_CANNOT_LOCK
	Modo %c no puede ser fijado con la opcin candado (MLOCK).
CHAN_MLOCK_CHANGED
	Modo de candado en canal %s cambiado a %s.
CHAN_MLOCK_REMOVED
	Modo de candado en canal %s removido.

# SET HIDE responses
CHAN_SET_HIDE_SYNTAX
	SET Canal HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
CHAN_SET_HIDE_EMAIL_ON
	La direccin electrnica (E-mail) del canal %s ser ahra ocultada de el comando %s INFO.
CHAN_SET_HIDE_EMAIL_OFF
	La direccin electrnica (E-mail) del canal %s ser ahra mostrada en el comando %s INFO.
CHAN_SET_HIDE_TOPIC_ON
	El tpico del canal %s ser ahra ocultado de el comando %s INFO.
CHAN_SET_HIDE_TOPIC_OFF
	El tpico del canal %s ser ahra mostrado en el comando %s INFO.
CHAN_SET_HIDE_MLOCK_ON
	El modo de candado del canal %s ser ahra ocultado de el comando %s INFO.
CHAN_SET_HIDE_MLOCK_OFF
	El modo de candado del canal %s ser ahra mostrado en el comando %s INFO.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET Canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Opcin de retencin de tpico ahra ACTIVADA (ON).
CHAN_SET_KEEPTOPIC_OFF
	Opcin de retencin de tpico ahra DESACTIVADA (OFF).

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET Canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Opcin de candado en tpico ACTIVADA (ON).
CHAN_SET_TOPICLOCK_OFF
	Opcin de candado en tpico DESACTIVADA (OFF).

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET Canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Opcin de privacidad ACTIVADA (ON).
CHAN_SET_PRIVATE_OFF
	Opcin de privacidad DESACTIVADA (OFF).

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET Canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Opcin de SecureOPs (OPs Seguros) ACTIVADA (ON).
CHAN_SET_SECUREOPS_OFF
	Opcin de SecureOPs (OPs Seguros) DESACTIVADA (OFF).

# SET LEAVEOPS responses
CHAN_SET_LEAVEOPS_SYNTAX
	SET Canal LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	Opcin de LeaveOPs (OPs Dejados) ACTIVADA (ON).
CHAN_SET_LEAVEOPS_OFF
	Opcin de LeaveOPs (OPs Dejados) DESACTIVADA (OFF).

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET Canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Opcin de acceso restringido ACTIVADA (ON).
CHAN_SET_RESTRICTED_OFF
	Opcin de acceso restringido DESACTIVADA (OFF).

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET Canal SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Opcin Secure (Seguro) ahra ACTIVADA (ON).
CHAN_SET_SECURE_OFF
	Opcin Secure (Seguro) ahra DESACTIVADA (OFF).

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET Canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Opcin de Op-notice (Nota a OPs) ahra ACTIVADA (ON).
CHAN_SET_OPNOTICE_OFF
	Opcin de Op-notice (Nota a OPs) ahra DESACTIVADA (OFF).

# SET ENFORCE responses
CHAN_SET_ENFORCE_SYNTAX
	SET Canal ENFORCE {ON | OFF}
CHAN_SET_ENFORCE_ON
	Opcin de Enforce (Implementar) est ahra ACTIVADA (ON).
CHAN_SET_ENFORCE_OFF
	Opcin de Enforce (Implementar) est ahra DESACTIVADA (OFF).

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET Canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	El canal %s NO expirar.
CHAN_SET_NOEXPIRE_OFF
	El canal %s SI expirar.

# UNSET responses
CHAN_UNSET_SYNTAX
	UNSET Canal {SUCCESSOR | URL | EMAIL | ENTRYMSG}
CHAN_SUCCESSOR_UNSET
	Sucesor para %s ahra indefinido.
CHAN_URL_UNSET
	URL para %s ahra indefinido.
CHAN_EMAIL_UNSET
	Correo electrnico (EMAIL) para %s ahra indefinida.
CHAN_ENTRY_MSG_UNSET
	Mensaje de entrada para %s ahra indefinido.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS Canal {ADD | DEL | LIST | COUNT} [Apodo [Nivel] | Lista-De-Entrada]
CHAN_ACCESS_DISABLED
	Lo sentimos, modificacin a la lista de acceso de canal est temporalmente deshabilitada.
CHAN_ACCESS_LEVEL_NONZERO
	Nivel de acceso debe ser diferente a cero.
CHAN_ACCESS_LEVEL_RANGE
	Nivel de acceso debe estar entre %d y %d.
CHAN_ACCESS_NICKS_ONLY
	La lista de acceso del canal deber contener solamente apodos registrados.
CHAN_ACCESS_REACHED_LIMIT
	Lo sentimos, usted solamente puede tener %d entradas de acceso en un canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Nivel de acceso para %s en %s no cambio de %d.
CHAN_ACCESS_LEVEL_CHANGED
	Nivel de acceso para %s en %s fue cambiado a %d.
CHAN_ACCESS_ADDED
	%s agregado a la lista de acceso de %s con nivel %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Entrada desconocida (#%d) en la lista de acceso de %s.
CHAN_ACCESS_NOT_FOUND
	%s no fue encontrado en la lista de acceso de %s.
CHAN_ACCESS_NO_MATCH
	No existe entrada alguna en la lista de acceso de %s.
CHAN_ACCESS_DELETED
	%s borrado de la lista de acceso de %s.
CHAN_ACCESS_DELETED_ONE
	Borrada 1 entrada de la lista de acceso de %s.
CHAN_ACCESS_DELETED_SEVERAL
	Borradas %d entradas de la lista de acceso de %s.
CHAN_ACCESS_LIST_EMPTY
	La lista de acceso de %s est vaca.
CHAN_ACCESS_LIST_HEADER
	Lista de acceso para %s:
	  Nm   Niv  Apodo
CHAN_ACCESS_LIST_FORMAT
	 %4d  %4d  %s
CHAN_ACCESS_COUNT
	La lista de acceso de %s tiene %d entradas.

# XOP (AOP/SOP/VOP) responses
CHAN_SOP_SYNTAX
	SOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_AOP_SYNTAX
	AOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_HOP_SYNTAX
	HOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_VOP_SYNTAX
	VOP Canal {ADD | DEL | LIST | COUNT} [Apodo | Lista-De-Acceso]
CHAN_XOP_ADDED
	%s agregado a la lista de %s %s.
CHAN_XOP_LEVEL_CHANGED
	%s movido a la lista de %s %s.
CHAN_XOP_LEVEL_UNCHANGED
	%s ya est en la lista de %s %s.
CHAN_XOP_NICKS_ONLY
	Las listas de SOP, AOP, y VOP solo pueden contener apodos registrados.
CHAN_XOP_NICKS_ONLY_HOP
	Las listas de SOP, AOP, HOP, y VOP solo pueden contener apodos registrados.
CHAN_XOP_REACHED_LIMIT
	Lo sentimos, el nmero de entradas en sus listas de SOP, AOP y VOP
	no puede sobrepasar ms de %d entradas.  Lmite excedido.
CHAN_XOP_REACHED_LIMIT_HOP
	Lo sentimos, el nmero de entradas en sus listas de SOP, AOP, HOP y VOP
	no puede sobrepasar ms de %d entradas.  Lmite excedido.
CHAN_XOP_NOT_FOUND
	%s no fue encontrado en la lista de %s %s.
CHAN_XOP_NO_SUCH_ENTRY
	Entrada desconocida (#%d) en la lista de %s %s.
CHAN_XOP_NO_MATCH
	No existe entrada alguna en la lista de %s %s.
CHAN_XOP_DELETED
	%s borrado de la lista de %s %s.
CHAN_XOP_DELETED_ONE
	Borrada 1 entrada de la lista de %s %s.
CHAN_XOP_DELETED_SEVERAL
	Borrada %d entradas de la lista de %s %s.
CHAN_XOP_LIST_EMPTY
	La lista de %s %s est vaca.
CHAN_XOP_LIST_HEADER
	Lista de %s para %s:
	  Nm   Apodo
CHAN_XOP_LIST_FORMAT
	 %4d   %s
CHAN_XOP_COUNT
	La lista de %s %s tiene %d entradas.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK Canal {ADD | DEL | LIST | VIEW | ENFORCE | COUNT} [Mscara | List]
CHAN_AKICK_DISABLED
	Lo sentimos, modificacin a la lista de pateo automtico de canal est temporalmente deshabilitada.
CHAN_AKICK_ALREADY_EXISTS
	%s ya existe en la lista de pateo automtico de %s.
CHAN_AKICK_REACHED_LIMIT
	Lo sentimos, usted solo puede tener %d mscaras de pateo automtico en un canal.
CHAN_AKICK_ADDED
	%s agregado a la lista de pateo automtico de %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Entrada desconocida (#%d) en la lista de pateo automtico de %s.
CHAN_AKICK_NOT_FOUND
	%s no se encuentra en la lista de pateo automtico de %s.
CHAN_AKICK_NO_MATCH
	No existe entrada alguna en la lista de pateo automtico de %s.
CHAN_AKICK_DELETED
	%s borrado de la lista de pateo automtico de %s.
CHAN_AKICK_DELETED_ONE
	Borrada 1 entrada de la lista de pateo automtico de %s.
CHAN_AKICK_DELETED_SEVERAL
	Borradas %d entradas de la lista de pateo automtico de %s.
CHAN_AKICK_LIST_EMPTY
	Lista de pateo automtico de %s est vaca.
CHAN_AKICK_LIST_HEADER
	Lista de pateo automtico para %s:
# index, mask, set-by, set-time, last-used, reason
CHAN_AKICK_VIEW_FORMAT
	  %3d %s (por %s en %s; ltima vez usado %s)
	    %s
# index, mask, set-by, set-time, reason
CHAN_AKICK_VIEW_UNUSED_FORMAT
	  %3d %s (por %s en %s; nunca usado)
	    %s
CHAN_AKICK_ENFORCE_DONE
	Implementacin de auto pateo para %s completado; %d usuarios fueron afectados.
CHAN_AKICK_COUNT
	%s tiene %d entradas en su lista de Auto Pateo.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS Canal {SET | DIS[ABLE] | LIST | RESET} [Articulo [Nivel]]
CHAN_LEVELS_RANGE
	Nivel debe de estar entre %d y %d.
CHAN_LEVELS_CHANGED
	Nivel para %s en canal %s cambiado a %d.
CHAN_LEVELS_UNKNOWN
	Opcin %s desconocida.  Escriba /msg %s HELP LEVELS DESC para ver la lista de opciones vlidas.
CHAN_LEVELS_DISABLED
	%s deshabilitado en canal %s.
CHAN_LEVELS_LIST_HEADER
	Configuracin de nivel de acceso para canal %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (deshabilitado)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (fundador solamente)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %4d
CHAN_LEVELS_RESET
	Niveles de acceso para %s reconfigurados a los niveles originales.

# INFO responses
CHAN_INFO_SYNTAX
	INFO Canal [ALL]
CHAN_INFO_HEADER
	Informacin del canal %s:
CHAN_INFO_FOUNDER
	           Fundador: %s
CHAN_INFO_SUCCESSOR
	            Sucesor: %s
CHAN_INFO_DESCRIPTION
	        Descripcin: %s
CHAN_INFO_ENTRYMSG
	 Mensaje de Entrada: %s
CHAN_INFO_TIME_REGGED
	         Registrado: %s
CHAN_INFO_LAST_USED
	         ltimo uso: %s
CHAN_INFO_LAST_TOPIC
	      ltimo tpico: %s
CHAN_INFO_TOPIC_SET_BY
	Tpico ajustado por: %s
CHAN_INFO_URL
	                URL: %s
CHAN_INFO_EMAIL
	 Correo electrnico: %s
CHAN_INFO_OPTIONS
	           Opciones: %s
CHAN_INFO_OPT_PRIVATE
	Privado
CHAN_INFO_OPT_KEEPTOPIC
	Retencin de tpico
CHAN_INFO_OPT_TOPICLOCK
	Candado en tpico
CHAN_INFO_OPT_SECUREOPS
	OPs Seguros
CHAN_INFO_OPT_LEAVEOPS
	OPs Dejados
CHAN_INFO_OPT_RESTRICTED
	Acceso restringido
CHAN_INFO_OPT_SECURE
	Seguro
CHAN_INFO_OPT_OPNOTICE
	Nota a OPs
CHAN_INFO_OPT_ENFORCE
	Implementar
CHAN_INFO_OPT_NONE
	Ninguna
CHAN_INFO_MODE_LOCK
	    Modo de candado: %s
CHAN_INFO_NO_EXPIRE
	Este canal no expirar.
CHAN_INFO_SUSPEND_DETAILS
	Suspendido por %s en %s (%s).
CHAN_INFO_SUSPEND_REASON
	Razn: %s
CHAN_INFO_SHOW_ALL
	Para ms informacin, Escriba: /msg %s INFO %s ALL

# LIST responses
CHAN_LIST_SYNTAX
	LIST Patrn
CHAN_LIST_OPER_SYNTAX
	LIST Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
CHAN_LIST_HEADER
	Lista de entradas relacionadas con %s:
CHAN_LIST_END
	Fin de la lista - %d/%d entradas mostradas.

# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE Canal
CHAN_INVITE_OK
	Invitando %s al canal %s.

# OP/DEOP/VOICE/DEVOICE responses
CHAN_OPVOICE_SYNTAX
	%s Canal [Apodo]
CHAN_OP_SUCCEEDED
	OPs dadas a %s en el canal %s.
CHAN_OP_ALREADY
	%s ya tiene OPs en el canal %s.
CHAN_OP_FAILED
	Imposible dar OPs a %s en el canal %s.
CHAN_DEOP_SUCCEEDED
	OPs removidas de %s en el canal %s.
CHAN_DEOP_ALREADY
	Ya le fueron removidas los OPs a %s en el canal %s.
CHAN_DEOP_FAILED
	Imposible remover OPs de %s en el canal %s.
CHAN_VOICE_SUCCEEDED
	Voz dada a %s en el canal %s.
CHAN_VOICE_ALREADY
	%s ya tiene voz en el canal %s.
CHAN_VOICE_FAILED
	Imposible dar voz a %s en el canal %s.
CHAN_DEVOICE_SUCCEEDED
	Voz removida de %s en el canal %s.
CHAN_DEVOICE_ALREADY
	Ya se le ha removido la voz a %s en el canal %s.
CHAN_DEVOICE_FAILED
	Imposible remover voz de %s en el canal %s.
CHAN_HALFOP_SUCCEEDED
	Mitad-OPs dadas a %s en el canal %s.
CHAN_HALFOP_ALREADY
	%s ya tiene estatus de Mitad-OPs en el canal %s.
CHAN_HALFOP_FAILED
	Imposible dar mitad-OPs a %s en el canal %s.
CHAN_DEHALFOP_SUCCEEDED
	Mitad-OPs removidas de %s en el canal %s.
CHAN_DEHALFOP_ALREADY
	Ya le fue removido el estatus de Mitdad-OPs a %s en el canal %s.
CHAN_DEHALFOP_FAILED
	Imposible remover mitad-OPs de %s en el canal %s.
CHAN_PROTECT_SUCCEEDED
	Protegido %s en el canal %s.
CHAN_PROTECT_ALREADY
	%s ya ha sido protegido en el canal %s.
CHAN_PROTECT_FAILED
	Imposible proteger a %s en el canal %s.
CHAN_DEPROTECT_SUCCEEDED
	Desprovisto de proteccin %s en el canal %s.
CHAN_DEPROTECT_ALREADY
	%s ya est desprovisto de proteccin en el canal %s.
CHAN_DEPROTECT_FAILED
	Imposible desproteger a %s en el canal %s.

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN Canal
CHAN_UNBANNED
	Usted ya no est bloqueado en %s.

# KICK responses
CHAN_KICK_SYNTAX
	KICK Canal Apodo [Razn]
CHAN_KICK_PROTECTED
	%s no puede ser pateado en el canal %s.
CHAN_KICKED
	%s pateado de el canal %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC Canal Tpico

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR Canal Opcin
CHAN_CLEARED_BANS
	Todos los bloqueos en el canal %s han sido removidos.
CHAN_CLEARED_EXCEPTIONS
	Todas las excepciones en el canal %s han sido removidas.
CHAN_CLEARED_MODES
	Todos los modos en el canal %s han sido borrados.
CHAN_CLEARED_OPS
	Modo +o ha sido desactivado en el canal %s.
CHAN_CLEARED_HALFOPS
	Modo +h ha sido desactivado en el canal %s.
CHAN_CLEARED_VOICES
	Modo +v ha sido desactivado en el canal %s.
CHAN_CLEARED_USERS
	Todos los usuarios han sido pateados del canal %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS Canal
CHAN_GETPASS_UNAVAILABLE
	El comando GETPASS no est disponible porque la red est usando encripcin.
CHAN_GETPASS_PASSWORD_IS
	Contrasea para el canal %s es %s.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID Channel
CHAN_FORBID_SHORT_CHANNEL
	El canal # no puede ser prohibido.
CHAN_FORBID_SUCCEEDED
	El canal %s est ahra prohibido.
CHAN_FORBID_FAILED
	No fue posible prohibir el canal %s!

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND [+Expiracin] Canal Razn
CHAN_SUSPEND_SUCCEEDED
	El canal %s ha sido suspendido.
CHAN_SUSPEND_ALREADY_SUSPENDED
	El canal %s ya est suspendido.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND Canal
CHAN_UNSUSPEND_SUCCEEDED
	Suspensin del canal %s ha sido desactivada.
CHAN_UNSUSPEND_NOT_SUSPENDED
	El canal %s no est suspendido.

################ sendpass module messages/responses

# Mail text
CHAN_SENDPASS_MAIL_SUBJECT
	Contrasea para %s
CHAN_SENDPASS_MAIL_BODY
	La Contrasea para el canal %s es: %s
	
	Este mensaje fue enviado por %s en respuesta a un pedido SENDPASS de
	%s@%s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS Canal
CHAN_SENDPASS_FAILED
	Lo sentimos, el envio de la contrasea fall.
CHAN_SENDPASS_FOUNDER_ONLY
	Solamente el fundador de un canal puede utilizar el comando SENDPASS.
CHAN_SENDPASS_NO_EMAIL
	Usted no ha establecido una direccin de correo-electrnico (E-mail) para su apodo.
# parameter is "NNN days/hours/minutes"
CHAN_SENDPASS_TOO_SOON
	Favor de esperar %s antes de usar el comando SENDPASS nuevamente.
CHAN_SENDPASS_SENT
	La contrasea para el canal %s ha sido enviada a %s.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Usted tiene 1 nuevo mensaje.
MEMO_HAVE_NEW_MEMOS
	Usted tiene %d nuevos mensajes.
MEMO_TYPE_READ_LAST
	Escriba /msg %s READ LAST para leerlo.
MEMO_TYPE_READ_NUM
	Escriba /msg %s READ %d para leerlo.
MEMO_TYPE_LIST_NEW
	Escriba /msg %s LIST NEW para alistarlos.
MEMO_AT_LIMIT
	AVISO!: Usted ha alcanzado su nmero mximo de mensajes (%d).  No podr recibir mensajes nuevos hasta que borre algunos de los que ahra tiene.
MEMO_OVER_LIMIT
	AVISO!: Usted ha pasado su nmero mximo de mensajes (%d).  No podr recibir mensajes nuevos hasta que borre algunos de los que ahra tiene.
MEMO_NEW_MEMO_ARRIVED
	Usted tiene un nuevo mensaje de %s.
	Escriba /msg %s READ %d para leerlo.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	Usted no tiene mensajes.
MEMO_X_HAS_NO_MEMOS
	%s no tine mensajes.
MEMO_DOES_NOT_EXIST
	Mensaje %d no existe!
MEMO_LIST_NOT_FOUND
	Ningn mensaje fue encontrado.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {Apodo | Canal} Texto
MEMO_SEND_DISABLED
	Lo sentimos, el envo de mensajes est temporalmente deshabilitado.
MEMO_SEND_PLEASE_WAIT
	Favor de esperar %s antes de utilizar el comando SEND nuevamente.
MEMO_X_GETS_NO_MEMOS
	%s no puede recibir mensajes.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s tiene demasiados mensajes actualmente y no puede recibir ms.
MEMO_SENT
	Mensaje enviado a %s.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [Canal] [Nmero | List | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Usted no tiene nuevos mensajes.
MEMO_X_HAS_NO_NEW_MEMOS
	%s no tiene nuevos mensajes.
MEMO_LIST_MEMOS
	Mensajes para %s.  Para leer, escriba: /msg %s READ Nmero
MEMO_LIST_NEW_MEMOS
	Nuevos mensajes para %s.  Para leer, escriba: /msg %s READ Nmero
MEMO_LIST_CHAN_MEMOS
	Mensajes para %s.  Para leer, escriba: /msg %s READ %s Nmero
MEMO_LIST_CHAN_NEW_MEMOS
	Nuevos mensajes para %s.  Para leer, escriba: /msg %s READ %s Nmero
MEMO_LIST_HEADER
	  Nm  Envia             Fecha/Hora
MEMO_LIST_FORMAT
	%c%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [Canal] {Nmero | List | LAST | NEW}
MEMO_HEADER
	Mensaje %d de %s (%s).  Para borrar, escriba: /msg %s DEL %d
MEMO_CHAN_HEADER
	Mensaje %d de %s (%s).  Para borrar, escriba: /msg %s DEL %s %d

# SAVE responses
MEMO_SAVE_SYNTAX
	SAVE [Canal] {Nmero | List}
MEMO_SAVED_ONE
	Mensaje %d marcado para que no expire.
MEMO_SAVED_SEVERAL
	%d mensajes marcados para que no expiren.

# DEL responses
MEMO_DEL_SYNTAX
	DEL [Canal] {Nmero | List | ALL}
MEMO_DELETED_NONE
	Ningn mensaje fue borrado.
MEMO_DELETED_ONE
	Mensaje %d ha sido borrado.
MEMO_DELETED_SEVERAL
	%d mensajes han sido borrados.
MEMO_DELETED_ALL
	Todos sus mensajes han sido borrados.

# SET responses
MEMO_SET_SYNTAX
	SET Opcin Parmetros
MEMO_SET_DISABLED
	Lo sentimos, la opcin de ajuste de mensajes est temporalmente deshabilitada.
MEMO_SET_UNKNOWN_OPTION
	Opcin SET %s desconocida.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s le notificar ahra de sus mensajes cuando se conecte o cuando le sean enviados.
MEMO_SET_NOTIFY_LOGON
	%s le notificar ahra de sus mensajes cuando se conecte o cancele su modo /AWAY.
MEMO_SET_NOTIFY_NEW
	%s le notificar ahra de sus mensajes cuando le sean enviados.
MEMO_SET_NOTIFY_OFF
	%s no le eviar notificacin alguna de mensajes.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [Canal] Lmite
MEMO_SET_LIMIT_OPER_SYNTAX
	SET LIMIT [Apodo | Canal] {Lmite | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	No le es permitido cambiar su lmite de mensajes.
MEMO_SET_LIMIT_FORBIDDEN
	El lmite de mensajes para %s no puede ser cambiado.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	Usted no puede ajustar su lmite de mensajes a ms de %d.
MEMO_SET_LIMIT_TOO_HIGH
	Usted no puede ajustar el lmite de mensajes para %s a ms de %d.
MEMO_SET_LIMIT_OVERFLOW
	Lmite de mensajes muy alto; lo hemos limitado a %d.
MEMO_SET_YOUR_LIMIT
	Su lmite de mensajes ha sido ajustado a %d.
MEMO_SET_YOUR_LIMIT_ZERO
	No le ser posible recibir ms mensajes.
MEMO_SET_YOUR_LIMIT_DEFAULT
	Su limite de mensajes ha sido fijado a la Configuracin Original (%d).
MEMO_UNSET_YOUR_LIMIT
	Su lmite de mensajes ha sido dishabilitado.
MEMO_SET_LIMIT
	Lmite de mensajes para %s ajustado a %d.
MEMO_SET_LIMIT_ZERO
	Lmite de mensajes para %s ajustado a 0.
MEMO_SET_LIMIT_DEFAULT
	Limite de mensajes para %s fijado a la Configuracin Original (%d).
MEMO_UNSET_LIMIT
	Lmite de mensajes Dishabilitado para %s.

# INFO responses
MEMO_INFO_NO_MEMOS
	Actualmente usted no tiene mensajes.
MEMO_INFO_MEMO
	Actualmente usted tiene 1 mensaje.
MEMO_INFO_MEMO_UNREAD
	Actualmente usted tiene 1 mensaje, y no ha sido an ledo.
MEMO_INFO_MEMOS
	Actualmente usted tiene %d mensajes.
MEMO_INFO_MEMOS_ONE_UNREAD
	Actualmente usted tiene %d mensajes, de los cuales 1 no ha sido ledo.
MEMO_INFO_MEMOS_SOME_UNREAD
	Actualmente usted tiene %d mensajes, de los cuales %d no han sido ledos.
MEMO_INFO_MEMOS_ALL_UNREAD
	Actualmente usted tiene %d mensajes; ninguno ha sido ledo.
MEMO_INFO_LIMIT
	Su lmite de mensajes es %d.
MEMO_INFO_HARD_LIMIT
	Su lmite de mensajes es %d, y no puede ser cambiado.
MEMO_INFO_LIMIT_ZERO
	Su lmite de mensajes es 0; usted no recibir ningn nuevo mensaje.
MEMO_INFO_HARD_LIMIT_ZERO
	Su lmite de mensajes es 0; usted no recibir ningn nuevo mensaje.  Usted no puede cambiar este lmite.
MEMO_INFO_NO_LIMIT
	Usted no tiene lmite en la cantidad de mensajes que puede guardar.
MEMO_INFO_NOTIFY_OFF
	Usted no ser notificado de nuevos mensajes.
MEMO_INFO_NOTIFY_ON
	Usted ser notificado de nuevos mensajes al conectarse y cuandos estos lleguen.
MEMO_INFO_NOTIFY_RECEIVE
	Usted ser notificado cuando nuevos mensajes lleguen.
MEMO_INFO_NOTIFY_SIGNON
	Usted ser notificado de nuevos mensajes al conectarse a la red de IRC.
MEMO_INFO_X_NO_MEMOS
	%s no tiene mensajes actualmente.
MEMO_INFO_X_MEMO
	%s actualmente tiene 1 mensaje.
MEMO_INFO_X_MEMO_UNREAD
	%s actualmente tiene 1 mensaje, y an est por ser ledo.
MEMO_INFO_X_MEMOS
	%s actualmente tiene %d mensajes.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s actualmente tiene %d mensajes, de los cuales 1 est an sin leer.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s actualmente tiene %d mensajes, de los cuales %d estn an sin leer.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s actualmente tiene %d mensajes; todos los cuales estn sin leer.
MEMO_INFO_X_LIMIT
	El lmite de mensages para %s es %d.
MEMO_INFO_X_HARD_LIMIT
	El lmite de mensajes para %s es %d, y no puede ser cambiado.
MEMO_INFO_X_NO_LIMIT
	%s no tiene lmite de mensajes.
MEMO_INFO_X_NOTIFY_OFF
	%s no es notificado de nuevos mensajes.
MEMO_INFO_X_NOTIFY_ON
	%s es notificado de nuevos mensajes al conectarse y cuando estos llegan.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s es notificado cuando llegan nuevos mensajes.
MEMO_INFO_X_NOTIFY_SIGNON
	%s es notificado de nuevos mensajes al conectarse.

################ forward module messages/responses

# Mail format
MEMO_FORWARD_MAIL_SUBJECT
	Mensaje para %s
MEMO_FORWARD_MAIL_BODY
	Mensaje para %s (%s)
	%s

# FORWARD responses
MEMO_FORWARD_SYNTAX
	FORWARD {Nmero | List | ALL}
MEMO_FORWARD_NEED_EMAIL
	Usted debe fijar una direccin de correo electrnico (E-mail) antes de que los mensajes puedan ser reexpedidos a usted.
MEMO_FORWARD_PLEASE_WAIT
	Favor de esperar %s antes de usar el comando FORWARD nuevamente.
MEMO_FORWARD_FAILED
	Lo sentimos, el reexpedido de mensaje fall.
MEMO_FORWARDED_NONE
	Ningn mensaje fue reexpedido.
MEMO_FORWARDED_ONE
	Mensaje %d ha sido reexpedido.
MEMO_FORWARDED_SEVERAL
	%d mensajes han sido reexpedidos.
MEMO_FORWARDED_ALL
	Todos sus mensajes han sido reexpedidos.
MEMO_FORWARDED_ALSO_TEMPFAIL
	Nota: Algunos mensajes no fueron reexpedidos porque el sistema estaba muy ocupado.
MEMO_FORWARDED_ALSO_PERMFAIL
	Nota: Algunos mensajes no fueron reexpedidos debido a un error en el sistema.

# SET FORWARD responses
MEMO_SET_FORWARD_SYNTAX
	SET FORWARD {ON | COPY | OFF}
MEMO_SET_FORWARD_ON
	Sus mensajes sern ahra reexpedidos a su direccin de correo electrnico: %s
MEMO_SET_FORWARD_COPY
	Sus mensajes sern ahra reexpedidos a su direccin de correo electrnico: %s
	Sus mensajes ahra tambien sern grabados por el sistema (Services).
MEMO_SET_FORWARD_OFF
	Sus mensajes no sern reexpedidos a su direccin de correo electrnico (E-mail).

################ ignore module messages/responses

# IGNORE responses
MEMO_IGNORE_SYNTAX
	IGNORE {ADD | DEL | LIST} [Apodo | Mscara]
MEMO_IGNORE_ADD_SYNTAX
	IGNORE ADD Apodo | Mscara
MEMO_IGNORE_DEL_SYNTAX
	IGNORE DEL Apodo | Mscara
MEMO_IGNORE_LIST_FULL
	Su lista de ignorar est llena.
MEMO_IGNORE_ALREADY_PRESENT
	%s ya est presente en su lista de ignorar.
MEMO_IGNORE_ADDED
	%s agregado a su lista de ignorar.
MEMO_IGNORE_NOT_FOUND
	%s no fue encontrado en su lista de ignorar.
MEMO_IGNORE_DELETED
	%s borrado de su lista de ignorar.
MEMO_IGNORE_LIST_EMPTY
	Su lista de ignorar est vaca.
MEMO_IGNORE_LIST
	Lista De Ignorar:
MEMO_IGNORE_LIST_X_EMPTY
	Lista de ignorar para %s est vaca.
MEMO_IGNORE_LIST_X
	Lista de ignorar para %s:

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Los servicios no pueden cambiar modos.  Estn sus servidores configurados correctamente?
OPER_BOUNCY_MODES_U_LINE
	Los servicios no pueden cambiar modos.  Estn las U:lines de sus servidores configurados correctamente?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL Notcia

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Opcin STATS %s desconocida.
OPER_STATS_RESET_USER_COUNT
	La cantidad mxima de usuarios ha sido re-ajustada.

OPER_STATS_CURRENT_USERS
	Usuarios actuales: %d (%d ops)
OPER_STATS_MAX_USERS
	Mximo de usuarios: %d (%s)
# Parameters: days, STR_DAYS or STR_DAY, hours, minutes, seconds
OPER_STATS_UPTIME_DHMS
	Servicios activos %d%s, %02d:%02d
# If >= 1 hour, hours and minutes; if < 1 hour, minutes and seconds
OPER_STATS_UPTIME_HM_MS
	Servicios activos %s

OPER_STATS_KBYTES_READ
	Data recibida: %10u kB
OPER_STATS_KBYTES_WRITTEN
	Data enviada:  %10u kB
OPER_STATS_NETBUF_SOCK
	Prelecturas de enchufe de servidor: %5u kB
OPER_STATS_NETBUF_SOCK_PERCENT
	Prelecturas de Enchufe de servidor: %5u kB (%d%%)
OPER_STATS_NETBUF_TOTAL
	Total de prelecturas de enchufe:    %5u kB
OPER_STATS_NETBUF_TOTAL_PERCENT
	Total de prelecturas de enchufe:    %5u kB (%d%%)

OPER_STATS_ALL_USER_MEM
	Usuarios           : %6d regstros, %5d kB
OPER_STATS_ALL_CHANNEL_MEM
	Canales            : %6d regstros, %5d kB
OPER_STATS_ALL_SERVER_MEM
	Servidores         : %6d regstros, %5d kB
OPER_STATS_ALL_NICKGROUPINFO_MEM
	Grupos De Apodos   : %6d regstros, %5d kB
OPER_STATS_ALL_NICKINFO_MEM
	Apodos             : %6d regstros, %5d kB
OPER_STATS_ALL_CHANSERV_MEM
	ChanServ           : %6d regstros, %5d kB
OPER_STATS_ALL_STATSERV_MEM
	StatServ           : %6d regstros, %5d kB
OPER_STATS_ALL_NEWS_MEM
	Notcias        : %6d regstros, %5d kB
OPER_STATS_ALL_AKILL_MEM
	Auto-desconecciones: %6d regstros, %5d kB
OPER_STATS_ALL_EXCEPTION_MEM
	Exceptions         : %6d regstros, %5d kB
OPER_STATS_ALL_SGLINE_MEM
	SGlines            : %6d regstros, %5d kB
OPER_STATS_ALL_SQLINE_MEM
	SQlines            : %6d regstros, %5d kB
OPER_STATS_ALL_SZLINE_MEM
	SZlines            : %6d regstros, %5d kB
OPER_STATS_ALL_SESSION_MEM
	Sesiones           : %6d regstros, %5d kB

# MODE responses
OPER_MODE_SYNTAX
	MODE Canal Modos

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES Canal [ALL]
OPER_CLEARMODES_DONE
	Modos binarios y bloqueos borrados del canal %s.
OPER_CLEARMODES_EXCEPT_DONE
	Modos binarios, bloqueos (bans), y excepciones fueron removidos en el canal %s.
OPER_CLEARMODES_ALL_DONE
	Todos los modos borrados del canal %s.

# CLEARCHAN responses
OPER_CLEARCHAN_SYNTAX
	CLEARCHAN Canal
OPER_CLEARCHAN_DONE
	Todos los usuarios removidos del canal %s.

# KICK responses
OPER_KICK_SYNTAX
	KICK Canal Usuario Razn

# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [Apodos]
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD Apodo
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL Apodo
OPER_ADMIN_NO_NICKSERV
	NickServ est deshabilitado en este momento; el comando ADMIN no est disponible.
OPER_ADMIN_EXISTS
	%s ya existe en la lista de Administradores de Servicios.
OPER_ADMIN_ADDED
	%s agregado a la lista de Administradores de Servicios.
OPER_ADMIN_TOO_MANY
	Demasiadas entradas (%d) en la lista de Administradores de Servicios; imposible agregar ms.
OPER_ADMIN_REMOVED
	%s removido de la lista de Administradores de Servicios.
OPER_ADMIN_NOT_FOUND
	%s no encontrado en la lista de administradores de Servicios.
OPER_ADMIN_LIST_HEADER
	Lista de Adminisradores de Servicios:

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [Apodo]
OPER_OPER_ADD_SYNTAX
	OPER ADD Apodo
OPER_OPER_DEL_SYNTAX
	OPER DEL Apodo
OPER_OPER_NO_NICKSERV
	NickServ est deshabilitado en este momento; el comando OPER no est disponible.
OPER_OPER_EXISTS
	%s ya existe en la lista de Operadores de Servicios.
OPER_OPER_ADDED
	%s agregado a la lista de Operadores de Servicios.
OPER_OPER_TOO_MANY
	Demasiadas entradas (%d) en la lista de Operadores de Servicios; imposible agregar ms.
OPER_OPER_REMOVED
	%s removido de la lista de Operadores de Servicios.
OPER_OPER_NOT_FOUND
	%s no encontrado en la lista de Operadores de Servicios.
OPER_OPER_LIST_HEADER
	Lista de Operadores de Servicios:

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | COUNT} [[+Expiracin] Mscara [Razn]]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+Expiracin] Mscara Razn
OPER_AKILL_DEL_SYNTAX
	AKILL DEL Mscara
OPER_TOO_MANY_AKILLS
	La lista AKILL est llena!
OPER_AKILL_EXISTS
	%s ya existe en la lista de auto-desconeccin (AKILL).
OPER_AKILL_NO_NICK
	Nota: Las mscaras de auto-desconeccin (AKILL) no pueden contener apodos; asegurese que usted no ha incluido una porcin con apodo en su mscara.
OPER_AKILL_MASK_TOO_GENERAL
	La mscara de auto-desconeccin (AKILL) es demasiado general.
OPER_AKILL_EXPIRY_LIMITED
	Solamente es posible fijar un tiempo de expiracin de %s.
OPER_AKILL_ADDED
	%s agregado a la lista de auto-desconeccin (AKILL).
OPER_AKILL_REMOVED
	%s removido de la lista de auto-desconeccin (AKILL).
OPER_AKILL_NOT_FOUND
	%s no encontrado en la lista de auto-desconeccin (AKILL).
OPER_AKILL_LIST_HEADER
	Lista actual de auto-desconeccin (AKILL):
# mask, reason
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_AKILL_VIEW_FORMAT
	%s (por %s en %s, ltima vez usada %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_UNUSED_FORMAT
	%s (por %s en %s, nunca usada; %s)
	    %s
OPER_AKILL_COUNT
	Existen %d mscaras de proveedor web en la lista de auto-desconeccin (AKILL).

# AKILLCHAN responses
OPER_AKILLCHAN_SYNTAX
	AKILLCHAN [KILL] [+Expiracin] Canal Razn
OPER_AKILLCHAN_AKILLED
	%d usuarios fueron agregados a la lista de auto-desconeccin (AKILL).
OPER_AKILLCHAN_KILLED
	%d usuarios fueron desconectados.
OPER_AKILLCHAN_AKILLED_ONE
	1 usuario fue agregado a la lista de auto-desconeccin (AKILL).
OPER_AKILLCHAN_KILLED_ONE
	1 usuario fue auto-desconectado.

# EXCLUDE responses
OPER_EXCLUDE_SYNTAX
	EXCLUDE {ADD | DEL | LIST | VIEW | COUNT} [[+Expiracin] Mscara [Razn]]
OPER_EXCLUDE_ADD_SYNTAX
	EXCLUDE ADD [+Expiracin] Mscara Razn
OPER_EXCLUDE_DEL_SYNTAX
	EXCLUDE DEL Mscara
OPER_TOO_MANY_EXCLUDES
	La lista EXCLUDE est llena!
OPER_EXCLUDE_EXISTS
	%s ya existe en la lista de exclusin de auto-desconeccin (AKILL).
OPER_EXCLUDE_ADDED
	%s agregado a la lista de exclusin de auto-desconeccin (AKILL).
OPER_EXCLUDE_REMOVED
	%s removido de la lista de exclusin de auto-desconeccin (AKILL).
OPER_EXCLUDE_NOT_FOUND
	%s no fue encontrado en la lista de exclusin de auto-desconeccin (AKILL).
OPER_EXCLUDE_LIST_HEADER
	Lista actual de exclusin de auto-desconeccin (AKILL):
# mask, reason
OPER_EXCLUDE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_EXCLUDE_VIEW_FORMAT
	%s (por %s en %s, ltima vez usada %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_EXCLUDE_VIEW_UNUSED_FORMAT
	%s (por %s en %s, nunca usado; %s)
	    %s
OPER_EXCLUDE_COUNT
	Existen %d mscaras de proveedor web en la lista de exclusin de auto-desconeccin (AKILL).

# SxLINE responses
OPER_SLINE_SYNTAX
	%s {ADD | DEL | LIST | VIEW | COUNT} [[+Expiracin] Mscara [Razn]]
OPER_SLINE_ADD_SYNTAX
	%s ADD [+Expiracin] Mscara Razn
OPER_SLINE_DEL_SYNTAX
	%s DEL Mscara
OPER_TOO_MANY_SLINES
	La lista %s est llena!
OPER_SLINE_EXISTS
	%s ya exixte en la lista %s.
OPER_SLINE_ADDED
	%s agregado a la lista %s.
OPER_SLINE_REMOVED
	%s removido de la lista %s.
OPER_SLINE_NOT_FOUND
	%s no fue encontrado en la lista %s.
OPER_SLINE_LIST_HEADER
	Lista %s actual:
# mask, reason
OPER_SLINE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_SLINE_VIEW_FORMAT
	%s (por %s en %s, ltima vez usada %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_SLINE_VIEW_UNUSED_FORMAT
	%s (por %s en %s, nunca usada; %s)
	    %s
OPER_SLINE_COUNT
	Existen %d entradas en la lista %s.
OPER_SZLINE_NOT_AVAIL
	SZLINE no est disponible con este servidor de IRC.

# SU responses
OPER_SU_SYNTAX
	SU Contrasea
OPER_SU_NO_PASSWORD
	El comando SU no est disponible porque ninguna contrasea de super-usuario ha sido fijada.
OPER_SU_SUCCEEDED
	Usted ahra tiene privilegios de super-usuario con los servicios.
OPER_SU_FAILED
	Imposible verificar la contrasea.

# SET responses
OPER_SET_SYNTAX
	SET Opcin Ajuste
OPER_SET_IGNORE_ON
	Cdigo Ignore ser usado.
OPER_SET_IGNORE_OFF
	Cdigo Ignore no ser usado.
OPER_SET_IGNORE_ERROR
	Parmetro para IGNORE debe ser ON o OFF.
OPER_SET_READONLY_ON
	Los Servicios estn ahra en modo de Leer-solamente (Read-Only).
OPER_SET_READONLY_OFF
	Los Servicios estn ahra en modo de Leer-Escribir (Read-Write).
OPER_SET_READONLY_ERROR
	Parmetro para READONLY debe ser ON u OFF.
OPER_SET_DEBUG_ON
	Los Servicios estn ahra en modo debug (Deteccin De Errores).
OPER_SET_DEBUG_OFF
	Los Servicios estn ahra en modo de non-debug (No Detectando Errores).
OPER_SET_DEBUG_LEVEL
	Los Servicios estn ahra en modo de debug (nivel %d).
OPER_SET_DEBUG_ERROR
	Parmetro para DEBUG debe ser ON, OFF, o un nmero positivo.
OPER_SET_SUPASS_FAILED
	Imposible fijar la contrasea para el Super-Usuario de los servicios.
OPER_SET_SUPASS_OK
	Contrasea para el Super-Usuario de los servicios ha sido cambiada.
OPER_SET_SUPASS_NONE
	Contrasea para el Super-Usuario de los servicios ha sido dishabilitada.
OPER_SET_UNKNOWN_OPTION
	Opcin %s desconocida.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE Nombre-Del-Servidor [Razn]
OPER_JUPE_INVALID_NAME
	El nombre de servidor es invlido (los nombres de servidores deben contener un punto).
OPER_JUPE_ALREADY_JUPED
	Ya se ha ejecutado el comando JUPE en el servidor %s.

# RAW responses
OPER_RAW_SYNTAX
	RAW Texto

# UPDATE responses
OPER_UPDATE_SYNTAX
	UPDATE [FORCE]
OPER_UPDATE_FORCE_FAILED
	Fue imposible abrir las bases de datos.
OPER_UPDATING
	Actualizando las bases de datos...
OPER_UPDATE_COMPLETE
	La actualizacin de la base de datos ha completado.
OPER_UPDATE_FAILED
	La actualizacin de la base de datos fall.

# REHASH responses
OPER_REHASHING
	Re-leyendo los ajustes a la configuracin.
OPER_REHASHED
	Todos los ajustes a la configuracin fueron exitosamente actualizados.
OPER_REHASH_ERROR
	Un error occurrio mientras se re-leian los ajustes a la configuracin.  Favor examine el fichero de archivo de los Servicios (log) para ms detalles.

# LISTIGNORE responses
OPER_IGNORE_LIST
	Lista de Ignorar de los servicios:
OPER_IGNORE_LIST_EMPTY
	La lista de Ignorar est vaca.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES Apodo
OPER_KILLCLONES_UNKNOWN_NICK
	Imposible encontrar el usuario %s.
OPER_KILLCLONES_KILLED
	%s utilizo KILLCLONES para %s desconectando %d clones.
OPER_KILLCLONES_KILLED_AKILL
	%s utilizo KILLCLONES para %s desconectando %d clones.  Un AKILL temporario ha sido agregado para %s.


###########################################################################
#
# Session limiting and exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [Parmetros]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+Expiracin] Mscara Lmite Razn
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {Mscara | List}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE Nm Nuevo-Nm
OPER_EXCEPTION_ALREADY_PRESENT
	Mscara %s ya est presente en la lista de excepcin.
OPER_EXCEPTION_TOO_MANY
	Lista de excepcin para lmite de sesiones est llena!
OPER_EXCEPTION_ADDED
	Lmite de sesiones para %s fijado a %d.
OPER_EXCEPTION_MOVED
	Excepcin para %s (#%d) movido al nmero %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Ninguna entrada (#%d) existe en la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_NOT_FOUND
	%s no encontrado en la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_NO_MATCH
	Ninguna entrada existe que concuerde en la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_EMPTY
	La lista de excepcin para lmite de sesiones est vaca.
OPER_EXCEPTION_DELETED
	%s borrado de la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_DELETED_ONE
	Borrada 1 entrada de la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_DELETED_SEVERAL
	Borradas %d entradas de la lista de excepcin para lmite de sesiones.
OPER_EXCEPTION_LIST_HEADER
	Lista de excepcin para lmite de sesiones actual:
# number, limit, host
OPER_EXCEPTION_LIST_COLHEAD
	Nm  Lmite  De
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
# number, mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (por %s on %s; %s)
	    Lmite: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Lmite de sesin invlido; lmite debe ser al menos cero y no mayor que %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Mscara proveedor-web invlida. Solo mscaras de proveedor-web reales son vlidas ya que excepciones no son relacionadas a apodos o nombres de usuario.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST Lmite | VIEW Mscara-web}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST Lmite
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW Mscara-Web
OPER_SESSION_INVALID_THRESHOLD
	Valor lmite invlido; lmite debe ser un entero mayor que 1.
OPER_SESSION_NOT_FOUND
	%s no encontrado en la lista de sesin.
OPER_SESSION_LIST_HEADER
	Proveedores con al menos %d sesiones:
OPER_SESSION_LIST_COLHEAD
	Sesiones  Proveedor
# Lmite, Proveedor
OPER_SESSION_LIST_FORMAT
	%6d    %s
# provee, sesiones, lmite
OPER_SESSION_VIEW_FORMAT
	El proveedor %s actualmente tiene %d sesiones con un lmite de %d.


###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Notcias - %s] %s
NEWS_OPER_TEXT
	[Notcias De Operador - %s] %s

NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD | DEL | LIST} [Texto | Nm]
NEWS_LOGON_LIST_HEADER
	Listado De Notcias:
NEWS_LOGON_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_LOGON_LIST_NONE
	No existen artculos noticiosos.
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD Texto
NEWS_LOGON_ADD_FULL
	La lista de notcias est llena!
NEWS_LOGON_ADDED
	Nuevo artculo notcioso agregado (#%d).
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL {Nm | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Artculo notcioso #%d no encontrado!
NEWS_LOGON_DELETED
	Artculo notcioso  #%d borrado.
NEWS_LOGON_DEL_NONE
	Ningn artculo notcioso para borrar!
NEWS_LOGON_DELETED_ALL
	Todos los artculo notcioso borrados.

NEWS_OPER_SYNTAX
	OPERNEWS {ADD | DEL | LIST} [Texto | Nm]
NEWS_OPER_LIST_HEADER
	Artculos notciosos para operadores:
NEWS_OPER_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_OPER_LIST_NONE
	No existen artculos noticiosos para los Operadores.
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD Texto
NEWS_OPER_ADD_FULL
	La lista de notcias est llena!
NEWS_OPER_ADDED
	Nuevo artculo notcioso de Operadores agregado (#%d).
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL {Num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Artculo notcioso de Operadores #%d no encontrado!
NEWS_OPER_DELETED
	Artculo notcioso de Operadores #%d borrado.
NEWS_OPER_DEL_NONE
	Ningn artculo notcioso de Operadores para borrar!
NEWS_OPER_DELETED_ALL
	Todos los artculos notciosos de Operadores borrados.

NEWS_HELP_LOGON
	Sintaxis: LOGONNEWS ADD Texto
	        LOGONNEWS DEL {Nm | ALL}
	        LOGONNEWS LIST
	
	Edita o muestra la lista de artculos notciosos.  Cuando los
	usuarios se conectan a la red, estos mensajes sern enviados
	a ellos.  (Sin embargo, no ms de tres mensajes les sern
	enviados para asi evitar un ahgo (flood) del usuario.  Si hay
	ms de tres mensajes notciosos, solo los tres ms recientes
	sern enviados.)
	
	LOGONNEWS LIST puede ser usado por cualquier operador de IRC para
	listar los mensajes notciosos actuales.  ADD y DEL solo pueden ser
	usados por los Administradores de los Servicios.

NEWS_HELP_OPER
	Sintaxis: OPERNEWS ADD Texto
	        OPERNEWS DEL {Nm | ALL}
	        OPERNEWS LIST
	
	Edita o muestra la lista de mensajes notciosos de operadores.
	Cuando un usuario se hace Operador (con el comando /OPER), estos
	mensajes le sern enviados.  (Sin embargo, no ms de tres mensajes
	sern enviados asi evitando un ahgo (flood) del usuario.  Si hay
	ms de tres mensajes notciosos, solo los tres ms recientes
	sern enviados.)
	
	OPERNEWS LIST puede ser usado por cualquier operador de IRC para
	listar los mensajes notciosos al Operador actuales.  ADD y DEL solo
	pueden ser usandos por los Administradores de los Servicios.


###########################################################################
#
# StatServ messages
#
############################################################################

# General SERVERS responses
STAT_SERVERS_REMOVE_SERV_FIRST
	Servidor %s est en lnea. Remuevalo de la red y trate nuevamente.
STAT_SERVERS_SERVER_EXISTS
	Servidor %s ya existe.

# SERVERS command syntax
STAT_SERVERS_SYNTAX
	SERVERS Opcin Parmetros

# STATS responses
STAT_SERVERS_STATS_TOTAL
	Total de Servidores: %2d
STAT_SERVERS_STATS_ON_OFFLINE
	       En lnea: %2d (%d%%)  No en lnea: %2d (%d%%)
STAT_SERVERS_LASTQUIT_WAS
	    ltima Desconexin: %-30s  %s

# LIST responses
STAT_SERVERS_LIST_HEADER
	Servidor                       Usuarios   Operadores
STAT_SERVERS_LIST_FORMAT
	%-30s %3d (%2d%%)  %3d (%2d%%)
STAT_SERVERS_LIST_RESULTS
	Fn del listado -- %d/%d servidores en lnea mostrados.

# VIEW responses
STAT_SERVERS_VIEW_HEADER_ONLINE
	%-30s  (En lnea)
STAT_SERVERS_VIEW_HEADER_OFFLINE
	%-30s  (Fuera de lnea)
STAT_SERVERS_VIEW_LASTJOIN
	    ltima conexin: %s
STAT_SERVERS_VIEW_LASTQUIT
	    ltima desconexin: %s
STAT_SERVERS_VIEW_QUITMSG
	 Mensaje de salida: %s
STAT_SERVERS_VIEW_USERS_OPERS
	        Usuarios: %3d (%2d%%)  Operadores: %3d (%2d%%)
STAT_SERVERS_VIEW_RESULTS
	Fn del listado -- %d/%d servidores mostrados.

# DELETE responses
STAT_SERVERS_DELETE_SYNTAX
	SERVERS DELETE Servidor
STAT_SERVERS_DELETE_DONE
	Estadsticas para el servidor %s han sido borradas.

# COPY responses
STAT_SERVERS_COPY_SYNTAX
	SERVERS COPY Servidor Nuevo-Nombre
STAT_SERVERS_COPY_DONE
	Estadsticas para el servidor %s copiadas a %s.

# RENAME responses
STAT_SERVERS_RENAME_SYNTAX
	SERVERS RENAME Servidor Nuevo-Nombre
STAT_SERVERS_RENAME_DONE
	Estadsticas para el servidor %s renombradas a %s.

# USERS responses
STAT_USERS_SYNTAX
	USERS STATS
STAT_USERS_TOTUSERS
	             Total de usuarios: %d
STAT_USERS_TOTOPERS
	             Total de operadores: %d
STAT_USERS_SERVUSERS
	Average de usuarios por servidor: %d
STAT_USERS_SERVOPERS
	Average de operadores por servidor: %d.%d


###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S le permite "registrar" un apodo y previene el que
	otros hagan uso de l.  %S es controlado por medio de
	varios comandos que hacen posible la registracin y tambin el
	mantenimiento de apodos.  Para ver la lista de comandos, escriba
	/msg %S HELP COMMANDS; para utilizar un comando, escriba
	/msg %S Comando, y para ms informacin sobre un comando
	especfico, escriba /msg %S HELP Comando.
NICK_HELP_EXPIRES
	
	Si un apodo registrado no es utilizado por %s, el
	regstro expirar y el apodo estar  disponible
	para que cualquier persona lo vuelva a utilizar.
NICK_HELP_WARNING
	
	NOTA: Este servicio est diseado para proveer una forma en la
	que los usuarios de IRC se aseguran de que su identidad no sea
	comprometida.  Su intencin NO es para facilitar el "robo"
	de apodos u otras acciones mal intencionadas.  Abuso de
	%S resultar, por lo menos, en la prdida de el/los
	apodo(s) abusado(s).

NICK_HELP_COMMANDS
	Los siguientes comandos pueden ser utilizados con %S:
	
	    REGISTER   Registre un apodo
NICK_HELP_COMMANDS_AUTH
	    AUTH       Autentica el regstro de un apodo
	    SENDAUTH   Envie a s mismo el cdigo de autenticacin de un apodo
NICK_HELP_COMMANDS_IDENTIFY
	    IDENTIFY   Identifiquese con su contrasea
NICK_HELP_COMMANDS_SENDPASS
	    SENDPASS   Envie su contrasea a su direccin de correo electrnico
NICK_HELP_COMMANDS_DROP
	    DROP       Cancele el regstro de un apodo
NICK_HELP_COMMANDS_LINK
	    LINK       Ligue otro apodo al suyo
	    UNLINK     Cancele un apodo ligado previamente
	    LISTLINKS  Aliste todos los apodos que usted ha ligado
NICK_HELP_COMMANDS_OLDLINK
	    LINK       Haga su apodo un alias de otro
	    UNLINK     Remueva una liga de su apodo
NICK_HELP_COMMANDS_ACCESS
	    ACCESS     Modifique la lista de direcciones autorizadas
NICK_HELP_COMMANDS_AJOIN
	    AJOIN      Modifique su lista de auto-ingreso (autojoin)
NICK_HELP_COMMANDS_SET
	    SET        Ajuste opciones, incluyendo proteccin de kill
	    UNSET      Re-configure la informacin del apodo
	    RECOVER    Desconecte otro usuario que este usando su apodo
	    RELEASE    Tome custodia de su apodo despus de utilizar RECOVER
	    GHOST      Desconecte una sesin "fantasma"
	    INFO       Muestra informacin sobre un apodo
NICK_HELP_COMMANDS_LIST
	    LIST       Alista todos los apodos que concuerden con una mscara dada
	    LISTEMAIL  Alista apodos segun su direccin electrnica (E-Mail)
NICK_HELP_COMMANDS_LISTCHANS
	    LISTCHANS  Alista todos los canales que usted posee
	    STATUS     Asegurese si se han identificado correctamente por un apodo dado

NICK_HELP_REGISTER
	Sintaxis: %s
	
	Registra su apodo en la base de datos de %S.  Una vez registrado
	su apodo, usted puede utilizar los comandos SET y ACCESS
	para configurar los parmetros de su apodo como usted los desee.
	Asegrese de recordar la contrasea que utiliz para
	registrarse--la necesitar para hacer cambios a su apodo
	posteriormente.  (Ntese que las maysculas importan
	FIDO, Fido, y fido son todas diferentes contraseas!)
NICK_HELP_REGISTER_EMAIL
	
	Usted puede inclur una direccin de correo electrnico (e-mail)
	cuando registre su apodo; tambin puede fijar una ms tarde usando
	el comando SET EMAIL.
NICK_HELP_REGISTER_EMAIL_REQ
	
	Usted debe inclur una direccin de correo Electrnico (e-mail)
	cuando registre su apodo.  Usted puede prevenir que su correo
	electrnico sea mostrado a otros usuarios con el comando SET HIDE
	(Escriba /msg %S HELP SET HIDE para ms informacin).
NICK_HELP_REGISTER_EMAIL_AUTH
	
	Usted debe inclur una direccin vlida de correo electrnico
	cuando registre su apodo; %S enviar un mensaje con un cdigo
	de autenticacin a esta direccin, el cual usted deber usar con
	el comando AUTH para completar su registracin.  Usted puede
	prevenir que su correo electrnico (E-mail) sea mostrado a otros
	usuarios con el comando SET HIDE (Escriba /msg %S HELP SET HIDE
	para ms informacin).
NICK_HELP_REGISTER_END
	
	Sugerencias para escoger contraseas:
	
	Contraseas no deben ser fcil de adivinar.  Por ejemplo,
	usar su verdadero nombre como contrasea es una mala idea.
	Usar su apodo como contrasea es una idea peor ;) y, por
	supuesto que, %S no lo permitir.  Tambin, contraseas
	cortas son vulnerables a bsquedas de prueba y error, por lo
	que usted debe escoger una contrasea de por lo menos 5
	caracteres.

NICK_HELP_AUTH
	Sintaxis: AUTH Cdigo
	
	Autentica la registracin o cambio de correo para un apodo.
	Para asegurarse que su correo electrnico es correcto, %S
	enviar un mensaje que contendr un cdigo de autenticacin
	a la direccin electrnica dada cuando registre su apodo o
	cambie su direccin electrnica con el comando SET EMAIL.
	Este comando le permite a usted confirmar que ha recibido el
	mensaje y continuar usando su apodo normalmente.  Reemplace
	Cdigo en el comando con el cdigo de autenticacin de nueve
	dgitos especificado en el mensaje electrnico (E-mail).
	
NICK_HELP_SENDAUTH
	Sintaxis: SENDAUTH
	
	Le envia a usted una copia del cdigo de autenticacin para
	su apodo despues de un REGISTER o SET EMAIL.  Si por accidente
	usted borra o pierde el mensaje con el cdigo de autenticacin,
	usted puede utilizar este comando para recibir una copia extra.
	
	Para prevenir abuso, este comando solo puede ser usado una vez
	cada 24 horas.

NICK_HELP_SENDPASS
	Sintaxis: SENDPASS Apodo
	
	Envia un mensaje conteniendo la contrasea de un apodo
	dado a la direccin electrnica registrada para el apodo.
	La direccin debe haber sido primero confirmada usando el
	comando AUTH.

NICK_HELP_IDENTIFY
	Sintaxis: IDENTIFY Contrasea
	
	Notifica a %S que usted es el verdadero dueo de este
	apodo.  Muchos de los comandos requieren que usted se
	identifique con este comando antes de poder utilizarlos.  La
	contrasea debe ser la misma que utiliz con el comando
	REGISTER.

NICK_HELP_DROP
	Sintaxis: DROP Contrasea
	
	Cancela (borra) su apodo de la base de datos de %S.
	Un apodo que ha sido borrado est disponible para que
	cualquier persona lo vuelva a registrar.
NICK_HELP_DROP_LINK
	
	Note que cuando usted cancele un apodo, todos los apodos ligados a este
	sern borrados tambin.  Para cancelar la liga de solamente un apodo,
	utilice el comando UNLINK.
NICK_HELP_DROP_END
	
	Para prevenir el uso accidental de este comando, usted debe entrar
	su contrasea para poder cancelar (borrar) su apodo.

NICK_HELP_OLD_LINK
	Sintaxis: LINK Apodo Contrasea
	
	Liga su apodo a otro, efectivamente haciendo del apodo que
	usted utiliza actualmente un alias del otro especificado.
	Cuando usted utiliza este comando, la lista de acceso de
	el apodo que est usando es eliminada y reemplazada por la
	del apodo con la que usted hace la liga; todos los mensajes
	para el apodo actual son agregados a la lista de mensajes de
	el apodo a ligar (esto puede causar que el apodo se exceda
	en su lmite de mensajes, en este caso necesitar borrar
	algunos de los mensajes antes de poder recibir nuevos
	mensajes para cualquiera de ambos apodos).
	
	Una vez establecida la liga, su apodo ser convertido
	transparentemente a el apodo nuevo en todas las bases de
	datos de los Servicios, excepto para el comando %S UNLINK.
	Por ejemplo, puede utilizar cualquiera de los apodos para
	leer los mismos mensajes (y los mensajes que se envan a
	cualquiera de los apodos irn a la misma lista). Si alguno
	de los apodos est en la lista de acceso de un canal, entonces
	cada apodo tendr los mismos privilegios de acceso.
	Sin embargo, los apodos expirarn independientemente; si solo
	utilizas uno de los apodos en una liga, todo los otros expirarn.
	
	Para poder utilizar este comando, usted debe identificarse por su
	apodo actual (usando el comando IDENTIFY), y usted debe
	suplir la contrasea para el apodo al que se desea ligar.

NICK_HELP_LINK
	Sintaxis: LINK Apodo
	
	Liga un nuevo apodo al apodo que usted est usando ahra,
	creando un nuevo "alias" para su apodo.  El nuevo apodo ser
	equivalente a su apodo actual en terminos de privilegios de
	acceso y mensajes; por ejemplo, usted puede leer mensajes
	enviados a uno de sus apodos ligados mientras usa cualquiera
	de sus otros apodos, y si uno de sus apodos tiene privilegios
	de auto-op en un canal, usted obtendr estatus de operador sin
	importar cual de sus apodos ligados est utilizando.
	
	Para cancelar una liga, use el comando UNLINK.
	
	Para poder utilizar este comando, usted debe identificarse por
	su apodo actual (usando el comando IDENTIFY), y el apodo
	que ser ligado no debe estar en uso en este momento.

NICK_HELP_OLD_UNLINK
	Sintaxis: UNLINK [Apodo Contrasea]
	
	Elimina la liga de su apodo hacia otro. Cuando la liga se
	elimina, los modos de un apodo y la lista de acceso de el
	apodo previamente ligado son copiados a su apodo actual y
	pueden ser modificados independientemente.  Mensajes no son
	copiados; todos los mensajes permanecen con el apodo
	previamente ligado.
	
	Cuando d un apodo y contrasea como parmetros, usted podr
	desligar otro apodo aparte del que est usando actualmente.

NICK_HELP_UNLINK
	Sintaxis: UNLINK Apodo
	
	Remueve una liga (alias) de su apodo creada con el comando
	LINK.  Usted no puede desligar el apodo que est utilizando
	actualmente; cambiese a otro de sus apodos ligados primeramente
	antes de usar este comando.
	
	Si usted desliga el "main nick" (Apodo Principal) que seleccion
	usando el comando SET MAINNICK, su apodo actual ser automticamente
	seleccionado como el apodo principal (main nick).

NICK_HELP_LISTLINKS
	Sintaxis: LISTLINKS
	
	Alista todos los apodos que esten ligados a su apodo.  El apodo
	principal para el grupo de apodos ligados ser indicado por un
	signo "*" a la izquierda del apodo.

NICK_HELP_ACCESS
	Sintaxis: ACCESS ADD Mscara
	          ACCESS DEL Mscara
	          ACCESS LIST
	
	Modifica o muestra la lista de acceso para su apodo.  Esta es la
	lista de direcciones usuario@proveedor que sern automticamente
	reconocidas por %S como autorizadas para usar el apodo.  Si usted
	se conecta a IRC con una direccin includa en dicha lista, usted no
	ser afectado por la configuracin SET KILL fijada en su apodo, y si
	la opcin SECURE est disahabilitada, le ser posible recibir los
	privilegios de auto-op y otros privilegios en los canales sin utilizar
	el comando IDENTIFY.
	
	La Mscara dada con los comandos ADD y DEL pueden contener
	comodnes (* o el signo ?).
	
	Ejemplos:
	
	    ACCESS ADD achurch@*.dragonfire.net
	        Permite acceso al usuario achurch desde cualquier
	        computadora en el dominio dragonfire.net.
	
	    ACCESS DEL achurch@*.dragonfire.net
	        Hace lo contrario al comando anterior.
	
	    ACCESS LIST
	        Muestra la lista de acceso actual.

NICK_HELP_SET
	Sintaxis: SET Opcin Parmetros
	
	Ajusta varias opciones del apodo. Donde Opcin puede ser:
	
	    PASSWORD   Ajusta la contrasea de su apodo
	    LANGUAGE   Ajusta el lenguaje que Servicios utilizar cuando
	                   envi mensajes a usted
	    URL        Asocia un URL con su apodo
	    EMAIL      Asocia una direccin de E-mail con su apodo
	    INFO       Ajuste el texto que se mostrar con el comando INFO
	    KILL       Activa/desactiva la proteccin de kill
	    SECURE     Activa/desactiva el modo SECURE para su apodo
	    PRIVATE    Evita que su apodo aparezca en
	                   /msg %S LIST
	    HIDE       Esconde ciertos datos e informacin sobre su apodo
	    TIMEZONE   Ajusta el uso horario a utilizarse para mostrar la hora
NICK_HELP_SET_OPTION_MAINNICK
	    MAINNICK   Fija el apodo mostrado en las listas de acceso de canales
NICK_HELP_SET_END
	
	Para utilizar este comando es necesario identificarse antes
	con su contrasea. Escriba (/msg %S HELP IDENTIFY para
	mayor informacin).
	
	Escriba /msg %S HELP SET Opcin para mayor informacin
	sobre una opcin especfica.

NICK_HELP_SET_PASSWORD
	Sintaxis: SET PASSWORD Nueva-Contrasea
	
	Cambia la contrasea que utiliza para identificarse como el
	dueo del apodo.

NICK_HELP_SET_LANGUAGE
	Sintaxis: SET LANGUAGE Nmero
	
	Cambia el lenguaje que los Servicios utilizan cuando envan
	mensajes a usted (por ejemplo cuando responden a un comando
	que usted envi).  Nmero debe ser escogido de la siguiente
	lista de lenguajes disponibles:
	

NICK_HELP_SET_URL
	Sintaxis: SET URL url
	
	Asocia el URL dado con su apodo.  Este URL ser  mostrado
	cuando alguien solicite informacin sobre su apodo con el
	comando INFO.

NICK_HELP_SET_EMAIL
	Sintaxis: SET EMAIL Direccin
	
	Asocia la direccin de E-mail (Correo-Electrnico) dada con su apodo.
	Esta direccin ser mostrada cuando alguien solicite informacin
	sobre su apodo con el comando INFO.

NICK_HELP_SET_INFO
	Sintaxis: SET INFO Texto
	
	Asocia el texto dado con su apodo; el cual ser mostrado
	cuando un usuario pida informacin sobre su apodo con el
	comando INFO.

NICK_HELP_SET_KILL
	Sintaxis: SET KILL {ON | QUICK | IMMED | OFF}
	
	Activa/desactiva la proteccin de kill para su apodo.  Con
	proteccin de kill activada, si algn otro usuario intenta
	utilizar su apodo, se le dar un minuto para que cambie a
	otro, si no ser removido forzosamente de IRC por %S.
	
	Si selecciona QUICK, el usuario solo tendr 20 segundos para
	cambiar de apodo en lugar de lo usual (60 segundos).  Si
	seleccionas IMMED, el usuario ser desconectado (killed)
	inmediatamente sin ser avisado primero o darle una
	oportunidad de cambiar de apodo, favor de no utilizar esta
	opcin a menos que sea verdaderamente necesario.  Los
	Administradores de la red pueden haber deshabilitado esta opcin.

NICK_HELP_SET_SECURE
	Sintaxis: SET SECURE {ON | OFF}
	
	Activa/desactiva las funciones de seguridad de %S para
	su apodo.  Con SECURE activado, usted deber enviar su
	contrasea antes de que se le reconozca como el dueo de
	el apodo, sin importar si su direccin este o no en la lista
	de acceso.  Sin embargo, si aparece en la lista de acceso,
	%S no lo desconectar automticamente, independientemente
	de como este la opcin de KILL.

NICK_HELP_SET_PRIVATE
	Sintaxis: SET PRIVATE {ON | OFF}
	
	Activa/desactiva la opcin privacidad de %S sobre su
	apodo.  Con PRIVATE activado, su apodo no aparecer en las
	listas de apodos generadas con el comando %S LIST.
	(Sin embargo, cualquiera que conozca su apodo puede obtener
	informacin usando el comando INFO.)

NICK_HELP_SET_HIDE
	Sintaxis: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Permite que usted evite que ciertos datos e informacin
	sean mostradas cuando alguien usa el comando %S INFO en su
	apodo.  Usted puede esconder su correo electrnico (EMAIL),
	ltima mscara usuario@host (USERMASK), o su ltimo mensaje
	de salida (QUIT).  El segundo parmetro especifica cual
	informacin debe ser mostrada (OFF) o escondida (ON).

NICK_HELP_SET_TIMEZONE
	Sintaxis: SET TIMEZONE {UTC-Ms/Menos | Uso-Horario | DEFAULT}
	
	Ajusta el uso horario a utilizarse para mostrar la hora (Como por
	ejemplo la ltima vez que un canal fue usado), en lugar de utilizar
	el uso horario en el cual los servicios operan; la opccin DEFAULT
	puede usarse para retornar al uso horario original de los Servicios.
	El uso horario puede ser especificado en una de estas dos formas:
	
	   - Como en UTC Ms/Menos, la diferencia de hora entre su hora
	     local y la UTC (Tiempo Universal Coordinado, tambien conocido
	     como GMT, Greenwich Mean Time).  La diferencia "ms" o "menos"
	     es dada con los signos "+" o "-" indicando antes (este) o detras
	     (oeste) de UTC, seguido por o bien un nmero completo de horas o
	     por una linea en el formato "hh:mm".
	
	   - Como en Nombre de uso horario, tal como "GMT" o "EDT".  No todos
	     los nombres de usos horarios estn disponibles en los Servicios, y
	     los usos horarios de algunos paises tienen el mismo nombre, asi es
	     que si usted recibe un error o si el uso horario mostrado por los
	     servicios es incorrecto, use un UTC ms/menos en lugar de un nombre.
	
	Note que los Servicios no se ajustarn a si mismos automticamente para
	el horario de verano; usted necesitar ajustar el uso horario de su
	preferencia manualmente.
	
	Ejemplos:
	
	    SET TIMEZONE -5
	        Ajuste el uso horario a 5 horas detras de UTC.
	
	    SET TIMEZONE +3:30
	        Ajuste el uso horario a 3 horas, 30 minutos antes de UTC.
	
	    SET TIMEZONE JST
	        Ajuste el uso horario al Horario Estandar Japones (UTC+9:00).

NICK_HELP_SET_MAINNICK
	Sintaxis: SET MAINNICK Apodo
	
	Cuando usted tiene multiples apodos ligados, este comando le permite
	seleccionar cual se muestra en las listas de acceso de canales.  Si
	usted desliga este apodo posteriormente, entonces uno diferente
	ser seleccionado automticamente.

NICK_HELP_UNSET
	Sintaxis: UNSET {URL | EMAIL | INFO}
	
	Le permite borrar el URL (URL), correo electrnico (EMAIL),
	o el texto de la informacin (INFO) asociada a su apodo.

NICK_HELP_UNSET_REQ_EMAIL
	Sintaxis: UNSET {URL | INFO}
	
	Le permite borrar el URL (URL) o texto de la informacin (INFO)
	asociada a su apodo.

NICK_HELP_RECOVER
	Sintaxis: RECOVER Apodo [Contrasea]
	
	Permite que usted recupere su apodo si alguien ms lo ha
	tomado; esto es lo mismo que %S hace automticamente si
	alguien intenta utilizar un apodo protegido con kill.
	
	Cuando usted enva este comando, %S conectar en lnea
	a un usuario falso con el mismo apodo del usuario del cual
	usted desea recuperar su apodo.  Esto causar que los
	servidores de IRC desconecten al otro usuario.  Este usuario
	falso permanecer en lnea por %s para asegurar que
	el otro usuario no se reconecte inmediatamente; despus de
	ese tiempo, usted puede reclamar su apodo.  Alternativamente,
	use el comando RELEASE (/msg %S HELP RELEASE) para obtener
	su apodo ms rpidamente.
	
	Para poder usar el comando RECOVER para un apodo, usted debe
	suplir la contrasea correcta para ese apodo, o usted debe haberse
	ya identificado por un apodo ligado a el apodo dado.

NICK_HELP_RELEASE
	Sintaxis: RELEASE Apodo [Contrasea]
	
	Instruye a %S que elimine cualquier retencin en su
	apodo causada por un kill automtico de proteccin o por el
	uso de el comando RECOVER Normalmente, la espera dura
	%s; este comando lo libera ms rpidamente.
	
	Para poder usar el comando RELEASE para un apodo, usted debe
	suplir la contrasea correcta para ese apodo, o usted debe haberse
	ya identificado por un apodo ligado a el apodo dado.

NICK_HELP_GHOST
	Sintaxis: GHOST Apodo [Contrasea]
	
	Termina una sesin "fantasma" de IRC que este utilizando su
	apodo.  Una sesin "fantasma" es aquella que no est
	realmente conectada, pero que el servidor de IRC acredita
	como activa por una razn u otra.  Tpicamente esto sucede
	si su computadora se atora o su conexin a Internet se
	desconecta muy brevemente mientras usted est en IRC.
	
	Para poder usar el comando GHOST para un apodo, usted debe
	suplir la contrasea correcta para ese apodo, o usted debe haberse
	ya identificado por un apodo ligado a el apodo dado.

NICK_HELP_INFO
	Sintaxis: INFO Apodo [ALL]
	
	Muestra informacin sobre el apodo dado, como quien es
	el dueo, ltima direccin utilizada y hora, y las
	diferentes opciones del apodo. Si se identific por el apodo
	del cual est reclamando informacin y ALL es especificado,
	se le mostrar toda la informacin; independientemente de si
	esta est escondida o no.
NICK_HELP_INFO_AUTH
	
	Si el correo electrnico del apodo no ha sido an confirmado con
	el comando AUTH, no ser mostrado a nadie excepto a el dueo de el
	apodo y a los Administradores de los Servicios, independientemente
	de la configuracin SET HIDE EMAIL estableciada para el apodo.

NICK_HELP_LISTCHANS
	Sintaxis: LISTCHANS
	
	Lista los nombres y el nmero total de canales que usted
	ha registrado bajo su apodo.

NICK_HELP_LIST
	Sintaxis: LIST Patrn
	
	Alista todos los apodos registrados para los cuales o bien el apodo
	mismo o la  ltima direccin vista (en el formato Usuario@Proveedor-web)
	concuerdan con el patrn dado.  Apodos con la opcin PRIVATE activada no
	no sern mostrados.
	
	Examples:
	
	    LIST joeuser@foo.com
	        Lista todos los apodos registrados que fueron usados ltimamente
	        por joeuser@foo.com.
	
	    LIST *Bot*!*@*
	        Lista todos los apodos registrados que contengan Bot
	        en su nombre (no importa maysculas).
	
	    LIST *@*.bar.org
	        Lista todos los apodos registrados que fueron  usados ltimamente por
	        usuarios del dominio bar.org.
NICK_HELP_LIST_OPERSONLY
	
	Solamente los operadores de IRC pueden utilizar este comando.

NICK_HELP_LISTEMAIL
	Sintaxis: LISTEMAIL Patrn
	
	Alista apodos registrados al igual que el comando LIST, pero lo hace
	basado en la direccin de correo electrnico en lugar de Usuario@proveedor-web.
	Vea el comando de ayuda para LIST (/msg %S HELP LIST) para obtener
	ms informacin.

NICK_HELP_STATUS
	Sintaxis: STATUS Apodo...
	
	Informa si el usuario de un apodo es reconocido como el dueo
	del mismo.  La respuesta tiene el siguiente formato:
	
	    Apodo cdigo-De-Estatus
	
	donde Apodo es el apodo enviado con el comando,
	Cdigo-De-Estatus es uno de los siguientes:
	
	    0 - usuario no est conectado o apodo no est registrado
	    1 - usuario no reconocido como dueo del apodo
	    2 - usuario reconocido por la lista de acceso solamente
	    3 - usuario reconocido por identificacin con contrasea
	
	Hasta 16 apodos pueden ser enviados con cada comando; el
	resto sern ignorados. No se genera mensaje de error alguno si
	no se enva un apodo.

NICK_HELP_AJOIN
	Sintaxis: AJOIN ADD Canal
	          AJOIN DEL Canal
	          AJOIN LIST
	
	Modifica o muestra la lista de auto ingreso (autojoin) para
	su apodo.  Esta es la lista de canales a los cuales le
	gustaria ser llevado automticamente, y va a surtir efecto
	cuando usted se identifica a %S.  Note que usted
	solamente puede inclur nombres de canales que comiencen con
	"#" en la lista de auto ingreso (canales locales no pueden
	ser incluidos).
	
NICK_HELP_AJOIN_END
	Note que el servidor de IRC pudiera prohibirle el ingreso a
	algunos de los canales en la lista de auto ingreso, tales
	canales incluyen aquellos a los cuales le ha sido fijado una
	llave (modo +k) o que se han fijado como invitacin-solamente
	(modo +i).
NICK_HELP_AJOIN_END_CHANSERV
	Note que el servidor de IRC pudiera prohibirle el ingreso a
	algunos de los canales en la lista de auto ingreso, tales
	canales incluyen aquellos a los cuales le ha sido fijado una
	llave (modo +k) o que se han fijado como invitacin-solamente
	(modo +i).  Sin embargo, si usted tiene acceso al comando
	INVITE de %s en un canal registrado, %S le
	invitar automticamente a usted para que pueda ingresar al
	canal.

NICK_OPER_HELP_COMMANDS
	
	Los siguientes comandos estn disponibles a los Administradores de Servicios:
	
	    DROPNICK   Cancela cualquier apodo
NICK_OPER_HELP_COMMANDS_DROPEMAIL
	    DROPEMAIL  Cancela todos los apodos que concuerden con una
	                  direccin de correo electrnico especificada
NICK_OPER_HELP_COMMANDS_GETPASS
	    GETPASS    Muestra la contrasea para un apodo
	                  (solo si encripcin est desactivada)
NICK_OPER_HELP_COMMANDS_FORBID
	    FORBID     Previene que un apodo sea utilizado/registrado
	    SUSPEND    Previene que alguien se identifique por un apodo dado
	    UNSUSPEND  Cancela la suspensin de un apodo
NICK_OPER_HELP_COMMANDS_LISTLINKS
	    LISTLINKS  Lista los apodos ligados a un apodo (ligas)
NICK_OPER_HELP_COMMANDS_SETAUTH
	    SETAUTH    Fija un nuevo cdigo de autenticacin para un apodo
	    GETAUTH    Muestra el cdigo de autenticacin para un apodo
	    CLEARAUTH  Cancela el cdigo de autenticacin para un apodo
NICK_OPER_HELP_COMMANDS_END
	
	Administradores de Servicios tambin pueden usar los siguientes
	comandos en cualquier apodo sin necesidad de identificarse:
	
	    SET, ACCESS LIST, INFO ALL
	
	Vea la ayuda para cada comando para detalles especficos.

NICK_OPER_HELP_DROPNICK
	Sintaxis: DROPNICK Apodo
	
	Remueve el apodo dado de la base de datos de %S, asi como
	cualquier apodo ligado a este.
	
	Limitedo a los Administradores de servicios.

NICK_OPER_HELP_DROPEMAIL
	Syntax: DROPEMAIL Patrn
	        DROPEMAIL-CONFIRM Patrn
	
	Cancela todos los apodos con una direccin de correo
	electrnico que concuerde con el Patrn dado.  Si Patrn es el
	simple caractr "-", entonces cancelar todos los apodos sin
	una direccin de correo electrnico.
	
	Para prevenir el que accidentalmente se cancelen apodos via
	este comando, se deber entrar dos veces: primero usando el
	comando llamado DROPEMAIL, y despues usando DROPEMAIL-CONFIRM
	con el mismo patrn.  El comando DROPEMAIL-CONFIRM debe ser
	ejecutado dentro de %s de y por la misma persona que
	ejecut el comando DROPEMAIL.  Si se dan mas de 4 ejecuciones
	del comando DROPEMAIL continuamente, la mas antigua ser
	ignorada y no se le reconoser mas para una ejecucin del
	comando DROPEMAIL-CONFIRM.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_SET
	
	Administradores de Servicios pueden seleccionar la opcin
	NOEXPIRE, con la cual se puede prevenir que algunos apodos
	expiren.  Adicionalmente, los Administradores de Servicios
	pueden establecer opciones para cualquier apodo sin necesidad
	de proveer una contrasea, utilizando el formato
	SET Apodo Opcin Parmetros.

NICK_OPER_HELP_SET_NOEXPIRE
	Sintaxis: SET [Apodo] NOEXPIRE {ON | OFF}
	
	Define si el apodo dado expirar.  Si se define ON previene
	que el apodo expire.  Si no se incluye un apodo, entonces se
	aplica a tu propio apodo.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_UNSET
	
	Administradores de Servicios pueden usar el comando UNSET en
	cualquier apodo por medio de inclur el apodo antes del nombre
	de la opcin, como en el comando SET.

NICK_OPER_HELP_OLD_UNLINK
	
	Administradores de Servicios pueden desligar cualquier apodo sin
	necesidad de enviar una contrasea.

NICK_OPER_HELP_UNLINK
	Sintaxis: UNLINK Apodo [FORCE]
	
	Remueve una liga (alias) de su apodo creada con el
	comando LINK.  Usted no puede desligar el apodo que est
	usando actualmente; cambie a otro apodo ligado primeramente
	antes de utilizar este comando.
	
	Si usted desliga el "main nick" (Apodo Principal) que seleccion
	usando el comando SET MAINNICK, su apodo actual ser automticamente
	seleccionado como el apodo principal (main nick).
	
	Los Administradores de servicios pueden agregar la opccin FORCE,
	la cual permite remover una liga de un apodo que no les pertenese.

NICK_OPER_HELP_OLD_LISTLINKS
	Sintaxis: LISTLINKS Apodo
	
	Alista los apodos que estn ligados al apodo dado.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_LISTLINKS
	Sintaxis: LISTLINKS [Apodo]
	
	Alista todos los apodos que esten ligados a su apodo.  El apodo
	principal para el grupo de apodos ligados ser indicado por un
	signo "*" a la izquierda del apodo.  Administradores de servicios
	pueden alistar ligas para cualquier apodo cuando especifican el
	apodo en el comando.

NICK_OPER_HELP_ACCESS
	
	Los Administradores de Servicios pueden dar un apodo como parmetro en
	el comando LIST para mostrar la lista de acceso de cualquier apodo.

NICK_OPER_HELP_INFO
	
	Administradores de Servicios pueden usar parmetro ALL en cualquier apodo.

NICK_OPER_HELP_LISTCHANS
	
	Administradores de Servicios pueden alistar canales para cualquier apodo
	usando el apodo con el comando (por ejemplo,
	/msg %S LISTCHANS Cualquier-Apodo).

NICK_OPER_HELP_LIST
	Sintaxis: LIST Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Alista todos los apodos registrados para los cuales o bien el apodo
	mismo o la  ltima direccin vista (en el formato Usuario@Proveedor-web)
	concuerdan con el patrn dado.  Apodos con la opcin PRIVATE activada
	sern solamente mostrados a los Administradores de los servicios.  Ellos,
	vern que los apodos con la opcin NOEXPIRE activada tendrn un signo !
	antes del apodo y aquellos que estn suspendidos estarn prefijados con el
	signo * antes del apodo.
	
	Si las opciones FORBIDDEN, SUSPENDED o NOEXPIRE estn activadas, entonces
	solamente los apodos que, respectivamente, estn prohibidos, suspendidos, o que
	tienen la opcin NOEXPIRE activada ser mostrados.  Las opciones pueden
	ser utilizadas en cualquier orden y en cualquier combinacin.  Estas
	opciones estn limitadas a los Administradores de Servicios.
	
	Examples:
	
	    LIST joeuser@foo.com
	        Lista todos los apodos registrados que fueron usados ltimamente
	        por joeuser@foo.com.
	
	    LIST *Bot*!*@*
	        Lista todos los apodos registrados que contengan Bot
	        en su nombre (no importa maysculas).
	
	    LIST * NOEXPIRE
	        Lista todos los apodos registrados que han sido fijados
	        como apodos que no expirarn.

NICK_OPER_HELP_LIST_AUTH
	Sintaxis: LIST Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Alista todos los apodos registrados para los cuales o bien el apodo
	mismo o la  ltima direccin vista (en el formato Usuario@Proveedor-web)
	concuerdan con el patrn dado.  Apodos con la opcin PRIVATE activada
	sern solamente mostrados a los Administradores de los servicios.  Ellos,
	vern que los apodos con la opcin NOEXPIRE activada tendrn un signo !
	antes del apodo, los que estn suspendidos estarn prefijados con el signo *
	antes del apodo, y aquellos que an no han sido autenticados (con el comando
	AUTH) tendrn un signo ? antes del apodo.
	
	Si las opciones FORBIDDEN, SUSPENDED o NOEXPIRE estn activadas, entonces
	solamente los apodos que, respectivamente, estn prohibidos, suspendidos, o que
	tienen la opcin NOEXPIRE activada ser mostrados.  Las opciones pueden
	ser utilizadas en cualquier orden y en cualquier combinacin.  Estas
	opciones estn limitadas a los Administradores De Servicios.
	
	Ejemplos:
	
	    LIST joeuser@foo.com
	        Alista todos los apodos registrados que fueron usados ltimamente
	        por joeuser@foo.com.
	
	    LIST *Bot*!*@*
	        Alista todos los apodos registrados que contengan Bot
	        en su nombre (no importa maysculas).
	
	    LIST * NOEXPIRE
	        Alista todos los apodos registrados que han sido fijados
	        como apodos que no expirarn.

NICK_OPER_HELP_LISTEMAIL
	Sintaxis: LISTEMAIL Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Alista apodos registrados al igual que el comando LIST, pero basado en la
	direccin de correo electrnico en lugar de la direccin usuario@proveedor-web.
	Vea el comando de ayuda para LIST (/msg %S HELP LIST) para obtener
	ms informacin.

NICK_OPER_HELP_LISTEMAIL_AUTH
	Sintaxis: LISTEMAIL Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Alista apodos registrados al igual que el comando LIST, pero basado en la
	direccin de correo electrnico en lugar de la direccin usuario@proveedor-web.
	Vea el comando de ayuda para LIST (/msg %S HELP LIST) para obtener
	ms informacin.

NICK_OPER_HELP_GETPASS
	Sintaxis: GETPASS Apodo
	
	Muestra la contrasea para el apodo dado.  Note que cuando
	este comando es utilizado, un mensaje incluyendo el apodo de
	la persona que lo utiliza, y el apodo sobre el cual se interroga
	es grabado en el archivo de services y enviado como un mensaje global
	(WALLOPS/GLOBOPS).
	
	Este comando pudiera no estar disponible cuando la red est usando encripcin,
	dependiendo de el tipo de encripcin utilizada.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_FORBID
	Sintaxis: FORBID Apodo
	
	Prohibe a todos el regstro y el uso de un apodo. Se puede
	revertir utilizando el comando DROP.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_SUSPEND
	Sintaxis: SUSPEND [+Expiracin] Apodo Razn
	
	Previene que un apodo, y todos aquellos apodos con el mismo
	apodo raz, sean utilizados o que alguien se identifique por
	ellos.  Puede lograrse que un apodo deje de estar suspendido
	por medio del comando UNSUSPEND, lo cual permitir que sea
	usado como antes.  El parmetro Expiracin es interpretado
	en la misma manera que para el comando %s AKILL.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_UNSUSPEND
	Sintaxis: UNSUSPEND Apodo
	
	Permite a los usuarios el uso y habilidad de identificarse por
	un apodo previamente SUSPENDido.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_AJOIN
	
	Administradores de servicios pueden ver la lista de auto ingreso (autojoin)
	para cualquier apodo con el formato LIST Apodo.

NICK_OPER_HELP_SETAUTH
	Sintaxis: SETAUTH Apodo
	
	Establece un nuevo cdigo de autenticacin para el apodo dado. El dueo
	del apodo tendr que utilizar el comando AUTH para el apodo antes de
	que le sea permitido identificarse nuevamente.   Si el apodo est en uso
	actualmente, una notificacin (notice) le ser enviada al usuario del
	apodo y esta persona no ser ya ms tratada como si se hubiese
	identificado previamente por el apodo.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_GETAUTH
	Sintaxis: GETAUTH Apodo
	
	Recobra el cdigo de autenticacin asociado con el  nickname,
	si es que realmente existe un cdigo para dicho apodo.
	
	Limitado a los Administradores De Servicios.

NICK_OPER_HELP_CLEARAUTH
	Sintaxis: CLEARAUTH Apodo
	
	Remueve cualquier cdigo de autenticacin asociado con el  Apodo,
	permitiendo que el apodo pueda ser usado normalmente.
	
	Limitado a los Administradores De Servicios.


###########################################################################
#
# ChanServ help messages
#
###########################################################################

# Used in OP/VOICE/etc for required access levels for commands
CHAN_HELP_REQSOP_LEVXOP
	nivel 100 (SOP)
CHAN_HELP_REQSOP_LEV
	level 100
CHAN_HELP_REQSOP_XOP
	SOP
CHAN_HELP_REQAOP_LEVXOP
	nivel 50 (AOP)
CHAN_HELP_REQAOP_LEV
	nivel 50
CHAN_HELP_REQAOP_XOP
	AOP
CHAN_HELP_REQHOP_LEVXOP
	nivel 40 (HOP)
CHAN_HELP_REQHOP_LEV
	nivel 40
CHAN_HELP_REQHOP_XOP
	HOP
CHAN_HELP_REQVOP_LEVXOP
	nivel 30 (VOP)
CHAN_HELP_REQVOP_LEV
	nivel 30
CHAN_HELP_REQVOP_XOP
	VOP

# Real help messages start here
CHAN_HELP
	%S le permite a usted registrar y controlar varios aspectos
	de los canales.  %S frecuentemente previene el que usuarios
	mal intecionados puedan "tomar" el control limitando a quin
	se permite obtener privilegios de operador del canal. Escriba
	/msg %S HELP COMMANDS para ver la lista de comandos de %S;
	para usar un comando, escriba /msg %S Comando, o para ms
	informacin sobre un comando, escriba /msg %S HELP Comando.
CHAN_HELP_EXPIRES
	
	Note que si un canal no es utilizado por %s (es decir
	qu ningn usuario en la lista de acceso del canal entra en
	ese periodo de tiempo) ser automticamente cancelado.

CHAN_HELP_COMMANDS
	Los siguientes comandos pueden ser utilizados con %S:
	
	    REGISTER   Registre un canal
	    IDENTIFY   Identifiquese con su contrasea
CHAN_HELP_COMMANDS_SENDPASS
	    SENDPASS   Envie la contrasea de un canal a usted mismo
CHAN_HELP_COMMANDS_DROP
	    DROP       Cancele la registracin de un canal
	    SET        Fija opciones e informacin del canal
	    UNSET      Remueve informacin del canal
	    INFO       Muestra opciones e informacin del canal
CHAN_HELP_COMMANDS_LIST
	    LIST       Alista canales registrados
CHAN_HELP_COMMANDS_AKICK
	    AKICK      Mantiene la lista de AutoKick (AutoPateo)
CHAN_HELP_COMMANDS_LEVELS
	    ACCESS     Mantiene la lista general de acceso al canal
	    LEVELS     Fije los niveles de acceso a canales ms detalladamente
CHAN_HELP_COMMANDS_XOP
	    SOP        Mantiene la lista de SuperOp
	    AOP        Mantiene la lista de AutoOp
	    VOP        Mantiene la lista de AutoVoice (Auto Voz)
CHAN_HELP_COMMANDS_HOP
	    HOP        Mantiene la lista AutoHalfop (Auto Mitad OP)
CHAN_HELP_COMMANDS_OPVOICE
	    OP         Le da a un usuario estatus de operador de canal (+o)
	    DEOP       Remueve el estatus de operador de canal (+o)
	    VOICE      Le da a un usuario el estatus de voz (voice) (+v)
	    DEVOICE    Remueve el estatus de voz (voice) (+v)
CHAN_HELP_COMMANDS_HALFOP
	    HALFOP     Le da a un usuario estatus de MitadOP(halfop) (+h)
	    DEHALFOP   Remueve el estatus de MitadOP (halfop) (+h)
CHAN_HELP_COMMANDS_PROTECT
	    PROTECT    Le da a un usuario estatus de protegido (+a)
	    DEPROTECT  Remueve el estatus de protegido (+a)
CHAN_HELP_COMMANDS_INVITE
	    INVITE     Invitese usted mismo a un canal
	    UNBAN      Remueva un bloqueo a usted mismo de un canal
	    KICK       Patee (kick) a un usuario de un canal
	    TOPIC      Cambie el tpico de un canal
	    CLEAR      Remueva los modos de un canal o haga un pateo masivo de sus usuarios
	    STATUS     Muestre el nivel de acceso de un usuario en un canal

CHAN_HELP_REGISTER
	Sintaxis: REGISTER Canal Contrasea Descripcin
	
	Registra un nuevo canal en la base de datos de %S.
	Para poder utilizar este comando, usted primero debe ser
	operador del canal que est tratando de registrar.  La
	contrasea deber ser utilizada con el comando IDENTIFY
	cuando necesite hacer modificaciones posteriores a las
	opciones del canal.  El ltimo parmetro, que debe ser
	incluido, es una descripcin de los propsitos del canal.
	
	Cuando usted registra un canal, usted queda grabado como
	el "fundador" del canal. El fundador de un canal puede
	modificar cualquiera de las opciones para dicho canal;
	%S le dar automticamente privilegios de operador
	al fundador del canal cuando l/ella ingresen al canal
	Vea el comando ACCESS; (/msg %S HELP ACCESS) para
	obtener informacin de como dar privilegios de operador
	a otros usuarios del canal.
	
	AVISO: para poder registrar un canal, usted deber haber registrado
	su apodo e identificado por l.  Si an no lo registr, escriba
	/msg %s HELP para obtener informacin de cmo hacerlo.
CHAN_HELP_REGISTER_ADMINONLY
	
	Limitado a los Administradores De Servicios.

CHAN_HELP_SENDPASS
	Sintaxis: SENDPASS Canal
	
	Le envia a usted un mensaje (E-mail) conteniendo la contrasea para
	el canal dado.  Usted debe ser el fundador del canal para poder
	usar este comando, y usted debe primeramente identificarse por su
	apodo con el comando IDENTIFY de %s.

CHAN_HELP_IDENTIFY
	Sintaxis: IDENTIFY Canal Contrasea
	
	Lo identifica a usted ante %S como el fundador
	del canal.  Muchos comandos requieren que usted
	ejecute este comando antes de poder utilizarlos.  La
	contrasea debe ser la misma que se ingres al momento
	de registrar el canal (comando REGISTER).

CHAN_HELP_DROP
	Sintaxis: DROP Canal
	
	Borra el canal nombrado.  Esto Puede ser utilizado
	nicamente por el fundador del canal, quien deber
	primeramente identificarse con el comando IDENTIFY.

CHAN_HELP_SET
	Sintaxis: SET Canal Opcin Parmetros
	
	Habilita al fundador del canal a definir varias opciones
	e informacin del canal.  El fundador, debe hacer uso del
	comando IDENTIFY antes de utilizar SET.
	
	Opciones disponibles:
	
	    FOUNDER     Cambia el fundador de un canal
	    SUCCESSOR   Establece el sucesor para un canal
	    PASSWORD    Cambia la contrasea del fundador
	    DESC        Cambia la descripcin del canal
	    URL         Asocia un URL con el canal
	    EMAIL       Asocia una direccin E-mail con el canal
	    ENTRYMSG    Fija un mensaje que ser enviado a los usuarios
	                   cuando ellos entran al canal
	    KEEPTOPIC   Retenga el tpico cuando el canal no es usado
	    TOPICLOCK   Tpico solo podr ser cambiado via TOPIC
	    MLOCK       Fija los modos del canal en 'ON' u 'OFF'
	    PRIVATE     Oculta al canal del comando LIST
	    RESTRICTED  Restringe el acceso al canal
	    SECURE      Activa las opciones de seguridad de %S
	    SECUREOPS   Control ms estricto del estatus de operador
	    LEAVEOPS    No remover OPs a los usuarios al entrar al canal
	    OPNOTICE    Notifca cuando los comandos OP/VOICE son usados
	    ENFORCE     Impone estatus auto-op y auto-voice de immediato
	
	Escriba /msg %S HELP SET Opcin para ms informacin
	sobre una opcin en particular.

CHAN_HELP_SET_FOUNDER
	Sintaxis: SET Canal FOUNDER Apodo
	
	Cambia el fundador de un canal.  El nuevo apodo debe
	ser uno registrado.

CHAN_HELP_SET_SUCCESSOR
	Sintaxis: SET Canal SUCCESSOR Apodo
	
	Cambia el sucesor de un canal.  Si el apodo del fundador
	expira o si es cancelado mientras el canal est todavia
	registrado, el sucesor se convertir en el nuevo fundador
	del canal.  Sin embargo, si el sucesor ya tiene demaciados
	canales registrados (%d), el canal ser cancelado como
	resultado, justo como si ningun sucesor hubiese sido fijado.
	El nuevo apodo debe ser uno registrado.

CHAN_HELP_SET_PASSWORD
	Sintaxis: SET Canal PASSWORD Contrasea
	
	Cambia la contrasea usada para identificarse como el fundador
	del canal.

CHAN_HELP_SET_DESC
	Sintaxis: SET Canal DESC Descripcin
	
	Cambia la descripcin para el canal, que se muestra con
	los comandos LIST e INFO.

CHAN_HELP_SET_URL
	Sintaxis: SET Canal URL url
	
	Asocia con el canal el URL dado.  Este URL ser
	mostrado siempre que alguien pida informacin sobre
	el canal con el comando INFO.

CHAN_HELP_SET_EMAIL
	Sintaxis: SET Canal EMAIL Direccin
	
	Asocia con el canal la direccin E-mail (correo electrnico) dada.
	Esta direccin ser mostrada siempre que alguien pida
	informacin sobre el canal con el comando INFO.

CHAN_HELP_SET_ENTRYMSG
	Sintaxis: SET Canal ENTRYMSG Mensaje
	
	Fija el mensaje que ser enviado via /NOTICE a los
	usuarios cuando estos entren al canal.

CHAN_HELP_SET_KEEPTOPIC
	Sintaxis: SET Canal KEEPTOPIC {ON | OFF}
	
	Habilita o deshabilita la opcin de retencin del tpico
	para el canal.  Cuando retencin del tpico est en ON
	(activada), el tpico del canal ser recordado por %S
	an despus que el ltimo usuario se haya retirado, y se
	restaurar la prxima vez que alguien ingrese al canal.

CHAN_HELP_SET_TOPICLOCK
	Sintaxis: SET Canal TOPICLOCK {ON | OFF}
	
	Habilita o deshabilita la opcin para candado en tpico del
	canal.  Cuando TOPICLOCK (candado en tpico) est en ON, %S
	no habilitar el cambio de tpico excepto va el comando TOPIC.

CHAN_HELP_SET_MLOCK
	Sintaxis: SET Canal MLOCK Modos
	
	Fija el parmetro modo-candado para el canal.  %S le permite a
	usted definir ciertos modos en el canal para que esten siempre
	activados (o desactivados).  Todos los modos binarios (n, s, t,
	k, l, ect) pueden ser fijados permanentemente; cada modo puede
	ser activado, desactivado, o no fijado.  El parmetro Modos es
	construido exactamente en la misma forma que se ejecuta un
	comando /MODE; lo cual significa que, los modos seguidos por
	un signo + son activados, y los modos seguidos por - son
	desactivados.
	
	Advertencia:  Si usted fija una llave con el modo-candado, como
	en el segundo ejemplo abajo, entonces deber tambin fijar la
	opcin RESTRICTED para el canal (vea HELP SET RESTRICTED), de
	lo contrario a cualquier usuario que ingrese al canal cuando
	este est vaco le sera posible ver la llave del canal!
	Igualmente MLOCK +i no preveer el que los usuarios ingresen
	al canal cuando est vaco sin haber sido invitados.
	
	Ejemplos:
	
	    SET #Canal MLOCK +nt-ikl
	        Impone los modos n y t como activos, y los modos i, k,
	        y l como innactivos.  Todos los otros modos son
	        liberados para estr bien activos o innactivos.
	
	    SET #Canal MLOCK +knst-ilmp My-Contrasea
	        Impone los modos k, n, s, y t como activos, y los modos
	        i, l, m, y p como innactivos.  Tambien establece la
	        contrasea del canal como "My-Contrasea".
	
	    SET #Canal MLOCK +
	        Remueve el modo-candado; todos los modos en el canal
	        son liberados para estr o bien activados o
	        desactivados (innactivos).

CHAN_HELP_SET_HIDE
	Sintaxis: SET Canal HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
	
	Le permite a usted prevenir que ciertos datos e informacin
	sean mostrados cuando alguien ejecuta un %S INFO en el
	canal especificado.  Usted puede esconder el correo electrnico
	(EMAIL) para un canal, el ltimo tpico (TOPIC), y el modo-candado
	(MLOCK).  El segundo parmetro especifica si la informacin deberia
	ser mostrada (OFF) o escondida (ON).
	
	Note que el tpico ser siempre ocultada si el canal tiene activados
	los modos-candado +p o +s.

CHAN_HELP_SET_PRIVATE
	Sintaxis: SET Canal PRIVATE {ON | OFF}
	
	Habilita o deshabilita la opcin de Privado para el canal.
	Cuando esta opcin est activada, el comando /msg %S LIST no
	incluir el canal en ninguna lista.

CHAN_HELP_SET_RESTRICTED
	Sintaxis: SET Canal RESTRICTED {ON | OFF}
	
	Habilita o deshabilita la opcin de Acceso Restringido para
	el canal.  Cuando el acceso restringido est activo (ON),
	usuarios que NO estn en la lista de acceso o usuarios que
	normalmente no tienen privilegio de operadores cuando entran
	al canal sern expulsados y se les prohibir el acceso  al
	canal.

CHAN_HELP_SET_SECURE
	Sintaxis: SET Canal SECURE {ON | OFF}
	
	Habilita o deshabilita la las opciones de seguridad de
	%S en un canal.  Cuando SECURE est activo (SET ON),
	SOLO los usuarios que tienen registrados sus apodos con
	%s y que se han IDENTIFICADO con sus contraseas
	tendrn privilegios en el canal segun lo establecido por la
	lita de acceso.  Si la opcin RESTRICTED est tambin fijada
	(SET ON), ser negado a los usuarios el ingreso al canal
	hasta que se hayan IDENTIFICADO a %s.

CHAN_HELP_SET_SECUREOPS
	Sintaxis: SET Canal SECUREOPS {ON | OFF}
	
	Habilita o deshabilita la opcin de OPs Seguros para un
	canal.  Cuando OPs Seguros est activada (ON), usuarios que
	NO estn en la lista de acceso del canal NO podrn obtener
	estatus de operadores.

CHAN_HELP_SET_LEAVEOPS
	Sintaxis: SET Canal LEAVEOPS {ON | OFF}
	
	Habilita o deshabilita la opcin leave ops para un canal.
	Cuando leave ops est fijado, %S dejar OPs del
	servidor (+o para la primera persona en el canal) en efecto
	incluso si el usuario normalmente no optendria OPs
	automticamente.  La opcin SECUREOPS ser an enforzada.
	Cuidado!:  Esto puede permitir que personas no autorizadas
	"roben" el estatus de Operador durante una ruptura de la red.

CHAN_HELP_SET_OPNOTICE
	Sintaxis: SET Canal OPNOTICE {ON | OFF}
	
	Habilita o deshabilita la opcin Nota de OPs para un canal.
	Cuando OPNOTICE es activada (ON), %S enviar una nota
	al canal siempre que los comandos OP, VOICE, o cualquier
	otro comando relacionado a estos sea utilizado para un usuario
	en el canal.

CHAN_HELP_SET_ENFORCE
	Sintaxis: SET Canal ENFORCE {ON | OFF}
	
	Habilita o deshabilita la opcin de IMPONER a un canal. Cuando
	ENFORCE es activado (ON), %S impondr los niveles de
	auto-op y auto-voice para todos los usuarios.  Por ejemplo, si a
	un usuario con privilegios de auto-op se le remueven los OPs, %S
	automticamente le dar OPs al usuario de nuevo, y %S tampoco
	permitir que el comando DEOP sea usado en aquel usuario.

CHAN_HELP_UNSET
	Sintaxis: UNSET Canal {SUCCESSOR | URL | EMAIL | ENTRYMSG}
	
	Borra los ajustes especificados de un canal.

CHAN_HELP_SOP
	Sintaxis: SOP Canal ADD Apodo
	          SOP Canal DEL Apodo
	          SOP Canal LIST [Mscara | List]
	          SOP Canal COUNT
	
CHAN_HELP_SOP_MID1
	Mantiene la lista de SuperOp (SOP) para un canal.
	Usuarios con el estatus SOP reciben OPs automticamente
	(reciben modo +o) cuando estos ingresan al canal.
CHAN_HELP_SOP_MID1_CHANPROT
	Mantiene la lista de SuperOp (SOP) para un canal.
	Usuarios con el estatus SOP reciben OPs automticamente
	(reciben modo +o) y son protegidos (modo +a) cuando estos
	ingresan al canal.
CHAN_HELP_SOP_MID2
	
	Un SOP puede modificar las listas de AOP y VOP. Solo
	el fundador del canal puede modificar la lista de SOP.
CHAN_HELP_SOP_MID2_HALFOP
	
	Un SOP puede modificar las listas AOP, HOP, y VOP.  Solamente el
	fundador del canal puede modificar la lista SOP.
CHAN_HELP_SOP_END
	
	El comando SOP LIST muestra la lista SOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que
	concuerden con esa mscara son mostradas.  Si se da una lista de
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   SOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas SOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando SOP COUNT retorna el nmbero de entradas que
	existen en la lista SOP.

CHAN_HELP_AOP
	Sintaxis: AOP Canal ADD Apodo
	          AOP Canal DEL Apodo
	          AOP Canal LIST [Mscara | List]
	          AOP Canal COUNT
	
	Mantiene la lista AutoOp (AOP) para un canal.
	Usuarios con estatus AOP reciben OPs automticamente
	(reciben modo +o) cuando ingresan al canal.
CHAN_HELP_AOP_MID
	
	Un AOP puede modificar la lista VOP; Los SOPs pueden modificar la
	lista AOP.
CHAN_HELP_AOP_MID_HALFOP
	
	Un AOP puede modificar las listas HOP y VOP; Los SOPs pueden modificar
	la lista AOP.
CHAN_HELP_AOP_END
	
	El comando AOP LIST muestra la lista AOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que
	concuerden con esa mscara son mostradas.  Si se da una lista de
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   AOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas SOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando AOP COUNT retorna el nmero de entradas que
	existen en la lista AOP.

CHAN_HELP_HOP
	Sintaxis: HOP Canal ADD Apodo
	          HOP Canal DEL Apodo
	          HOP Canal LIST [Mscara | List]
	          HOP Canal COUNT
	
	Mantiene la lista HalfOp (HOP) para un canal.  Usuarios
	con estatus HOP reciben privilegios de Mitad-OP (reciben
	modo +h) automticamente cuando estos ingresan al canal.
	
	Un HOP puede modificar la lista VOP; SOPs y AOPs pueden
	modificar la lista HOP.
	
	El comando HOP LIST muestra la lista HOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que
	concuerden con esa mscara son mostradas.  Si se da una lista de
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   HOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas HOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando HOP COUNT retorna el nmero de entradas que
	existen en la lista HOP.

CHAN_HELP_VOP
	Sintaxis: VOP Canal ADD Apodo
	          VOP Canal DEL Apodo
	          VOP Canal LIST [Mscara | List]
	          VOP Canal COUNT
	
	Mantiene la lista VoiceOp (VOP) para un canal.
	Usuarios con estatus VOP reciben vz automticamente
	(reciben modo +v) cuando estos ingresan al canal.
	
	El comando VOP LIST muestra la lista VOP.  Si una mscara de
	comodn (signo *) es insertada, solamente aquellas entradas que
	concuerden con esa mscara son mostradas.  Si se da una lista de
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   VOP #canal LIST 2-5,7-9
	      Muestra la lista de entradas VOP del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando VOP COUNT retorna el nmero de entradas que
	existen en la lista VOP.

CHAN_HELP_ACCESS
	Sintaxis: ACCESS Canal ADD Apodo Nivel
	          ACCESS Canal DEL {Apodo | Nm-de-Entrada | List}
	          ACCESS Canal LIST [Mscara | List]
	          ACCESS Canal COUNT
	
	Mantiene la Lista De Acceso del canal.  La lista de acceso
	establece qu usuarios estn habilitados a ser operadores en
	el canal o acceder a comandos de %S en el canal.  Se pueden
	establecer diferentes niveles de usuarios para acceder a
	diferentes privilegios; utilice /msg %S HELP ACCESS LEVELS
	para obtener informacin ms especfica.  Cualquier apodo que
	no est en la lista de acceso tiene nivel de usuario 0
	(cero).
	
	El comando ACCESS ADD agrega el apodo con el nivel dado a
	la lista de acceso; si el usuario ya existe en la lista, se
	reemplazar su nivel con el dado.  El nivel especificado debe
	ser menor que el que tiene el usuario que est ingresando el
	comando, y si el apodo est actualmente en la lista, el nivel
	actual de dicho apodo debe ser menor que el nivel del usuario que
	est ingresando el comando.
	
	El comando ACCESS DEL remueve el apodo dado de la
	lista de acceso.  Si una lista de nmeros de entrada es dada,
	aquellas entradas son borradas.  (Vea el ejemplo para LIST abajo.)
	
	El comando ACCESS LIST muestra la lista de acceso.  Si una mscara
	de comodn (signo *) es insertada, solamente aquellas entradas que
	concuerden con esa mscara son mostradas.  Si se da una lista de
	nmeros de entrada, solo esas entradas se muestran; por ejemplo:
	
	   ACCESS #canal LIST 2-5,7-9
	      Muestra la lista de entradas del nmero 2 hasta el 5 y
	      del 7 hasta 9.
	
	El comando ACCESS COUNT retorna el nmero de entradas que
	existen en la lista de acceso.
CHAN_HELP_ACCESS_XOP
	
	Note que la lista de acceso puede tambin ser manipulada con los
	comandos SOP, AOP, y VOP, los cuales corresponden a los
	niveles de %d, %d, y %d respectivamente.
CHAN_HELP_ACCESS_XOP_HALFOP
	
	Note que la lista de acceso puede ser tambin manipulada con los
	comandos SOP, AOP, HOP, y VOP, los cuales corresponden
	a los niveles de %d, %d, %d, y %d respectivamente.

CHAN_HELP_ACCESS_LEVELS
	Niveles De Acceso Del Usuario
	
	Originalmente, los siguientes niveles son definidos:
	
	   Founder   Acceso completo a las funciones de %S; obtencin
	                 automtica de OPs al entrar al canal.  Note
	                 que solo UNA persona puede tener estatus de
	                 fundador (el cual no puede ser dado usando el
	                 comando ACCESS).
	      %4d   Acceso al comando AKICK; obtencin automtica de OPs.
	      %4d   Obtencin automtica de OPs.
CHAN_HELP_ACCESS_LEVELS_HALFOP
	      %4d   Obtencin automtica de MitadOP.
CHAN_HELP_ACCESS_LEVELS_END
	      %4d   Obtencin automtica de vz (voice +v).
	         0   Ningn privilegio especial; otros operadores pueden
	                 darle OPs (a menos que SECUREOPS este fijado).
	        -1   No puede obtener status de Operador del canal (OPs).
	      -100   No puede ingresar al canal.
	
	Estos niveles (Excepto los dos ltimos) pueden ser cambiados, o nuevos agregados,
	usando el comando LEVELS; escriba /msg %S HELP LEVELS para ms
	informacin.

CHAN_HELP_LEVELS
	Sintaxis: LEVELS Canal SET Tipo Nivel
	          LEVELS Canal {DIS | DISABLE} Tipo
	          LEVELS Canal LIST
	          LEVELS Canal RESET
	
	El comando LEVELS permite un control fino sobre los accesos
	numricos utilizados por los canales.  Con este comando,
	usted puede definir los niveles requeridos para muchas de
	las funciones de %S.  Los comandos SET FOUNDER,
	SET PASSWORD, as como ste comando estn siempre
	restringidos al fundador.
CHAN_HELP_LEVELS_XOP
	
	Cuidado!:  Este comando es solo para usuarios avanzados!  Cambiar
	las opciones de nivel con este comando puede causar que los comandos
	SOP, AOP, y VOP dejen de funcionar correctamente.
CHAN_HELP_LEVELS_XOP_HOP
	
	Cuidado!:  Este comando es solo para usuarios avanzados!  Cambiar
	las opciones de nivel con este comando puede causar que los comandos
	SOP, AOP, HOP, y VOP dejen de funcionar correctamente.
CHAN_HELP_LEVELS_END
	
	LEVELS SET permite el nivel de acceso para una funcin o grupo
	de funciones a ser cambiadas.  LEVELS DISABLE (o DIS abreviado)
	deshabilita una opcin automtica o prohibe el acceso a una
	funcin por cualquiera que no sea el fundador del canal.
	LEVELS LIST muestra el nivel actual para cada funcin o
	grupo de funciones.  LEVELS RESET reajusta los niveles a los
	niveles originales de un canal recien creado (vea
	HELP ACCESS LEVELS para ms informacin).
	
	Para una lista de las opciones y funciones a los que se le puede
	ajustar los niveles, vea HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	Los siguientes nombres de valores/funciones son entendidos:

CHAN_HELP_AKICK
	Sintaxis: AKICK Canal ADD Mscara [Razn]
	          AKICK Canal DEL Mscara
	          AKICK Canal LIST [Mscara | List]
	          AKICK Canal VIEW [Mscara | List]
	          AKICK Canal ENFORCE
	          AKICK Canal COUNT
	
	Mantiene la lista de Auto-Pateo (AKICK) para un canal.  Si un
	usuario en la lista de Auto-Pateo intenta ingresar al canal,
	%S lo bloquear (ban) del canal, despues lo patear (kick).
	
	El comando AKICK ADD agrega la mscara user@host dada o
	Apodo!Usuario@dominio a la lista de auto-pateo.  Si una
	razn es dada con el comando, esa razn ser usada cuando el
	usuario sea pateado; de lo contrario, la razn por naturaleza
	ser "You have been banned from the channel".
	
	El comando AKICK DEL elimina la mscara dada de la lista AKICK.
	Este comando no remueve sin embargo bloqueos (bans) existentes
	en el canal, los que debern ser removidos manualmente.
	
	El comando AKICK LIST muestra la lista de auto-pateo (AKICK), o
	optionalmente solo aquellas entradas de auto-pateo que concuerden con
	la mscara dada.  AKICK VIEW es similar, pero muestra ms detalles.
	
	El comando AKICK ENFORCE causa que %S imponga la lista AKICK
	actual por medio de remover aquellos usuarios que concuerdan con
	una mscara AKICK .
	
	El comando AKICK COUNT retorna cuantas entradas existen
	en la lista de Auto-Pateo (AKICK).
	
	Originalmente, esto est limitado a usuarios con acceso %s y superior
	en el canal.

CHAN_HELP_INFO
	Sintaxis: INFO Canal [ALL]
	
	Lista informacin sobre el canal registrado especificado,
	incluyendo su fundador, fecha de regstro, ltima vez usado,
	descripcin, y modo lock (candado), si existe.  Si usted se
	ha identificado como el fundador del canal del cual pide
	informacin y ALL es especificado, el mensaje de entrada
	y el sucesor tambin sern mostrado.

CHAN_HELP_LIST
	Sintaxis: LIST Patrn
	
	Lista todos los canales registrados que coincidan con el patrn dado.
	(Canales con la opcin PRIVATE fijada no son alistados.)
CHAN_HELP_LIST_OPERSONLY
	
	Solamente los operadores de IRC pueden utilizar este comando.

CHAN_HELP_OP
	Sintaxis: OP Canal [Apodo]
	
	Da estatus de OP (modo +o) al apodo seleccionado en un canal.  Si Apodo no es especificado
	entonces le da a usted los OPs.  Originalmente, limitado a usuarios con acceso %s
	o superior en un canal.

CHAN_HELP_DEOP
	Sintaxis: DEOP Canal Apodo
	
	Remueve el estatus de OP (modo +o) de un apodo seleccionado en un canal.  Si Apodo
	no es especificado, Remueve los OPs de usted.  Originalmente, limitado a usuarios
	con acceso %s o superior en el canal.

CHAN_HELP_VOICE
	Sintaxis: VOICE Canal [Apodo]
	
	Da voz (modo +v) a un apodo seleccionado nick en un canal.  Si Apodo
	no es especificado, Le da voz a usted.  Originalmente, limitado
	a usuarios con acceso %s o superior en el canal.

CHAN_HELP_DEVOICE
	Sintaxis: DEVOICE Canal [Apodo]
	
	Remueve la voz (modo +v) de el apodo seleccionado en un canal.  Si Apodo
	no es especificado, remueve la voz de usted.  Originalmente, limitado
	a usuarios con acceso %s o superior en el canal.

CHAN_HELP_HALFOP
	Sintaxis: HALFOP Canal [Apodo]
	
	Da acceso MitadOP (modo +h) a un apodo seleccionado en un canal.  Si Apodo
	no es especificado, le da acceso de MitadOP a usted.  Originalmente,
	limitado a usuarios con acceso %s o superior en el canal.

CHAN_HELP_DEHALFOP
	Sintaxis: DEHALFOP Canal [Apodo]
	
	Remueve el acceso de MitadOP (modo +h) de un apodo seleccionado en un canal.  Si
	Apodo no es especificado, entonces le remueve el acceso MitadOP a usted mismo.
	Originalmente, limitado a usuarios con acceso %s o superior en el canal.

CHAN_HELP_PROTECT
	Sintaxis: PROTECT Canal [Apodo]
	
	Da estatus de protegido en el canal (modo +a) a un apodo seleccionado en un
	canal.  Si Apodo no es especificado, le da estatus de protegido en el canal
	a usted mismo.  Originalmente, limitado a usuarios con acceso %s o superior
	en el canal.

CHAN_HELP_DEPROTECT
	Sintaxis: DEPROTECT Canal [Apodo]
	
	Remueve el estatus de protegido en el canal (modo +a) de un apodo seleccionado
	en un canal.  Si Apodo no es especificado, entonces le remueve el estatus de
	protegido en el canal a usted mismo.  Originalmente, limitado a usuarios con
	acceso %s o superior en el canal.

CHAN_HELP_INVITE
	Sintaxis: INVITE Canal
	
	Instruye a %S que lo invite a usted a el canal dado.  Originalmente,
	limitado a usuarios con acceso %s o superior en
	el canal.
	
	Note: Si usted recibe un mensaje diciendo que el canal no est en uso,
	eso significa que el canal est vaco, y usted puede ingresar a este
	libremente sin necesidad de utilizar este comando.

CHAN_HELP_UNBAN
	Sintaxis: UNBAN Canal
	
	Instruye a  %S que remueva todos los bloqueos (bans) que le impiden a
	usted el ingreso al canal dado.  Originalmente, limitado a usuarios
	con acceso %s o superior en el canal.

CHAN_HELP_KICK
	Sintaxis: KICK Canal Apodo [Razn]
	
	Instruye a %S que patee (kick) al apodo dado de el canal
	dado.  El mensaje incluido en el pateo mostrar tanto quien
	utiliz el comando KICK, como tambin la razn dada con el
	comando, si una es especificada.  Originalmente, limitado a
	usuarios con acceso %s o superior en el canal.

CHAN_HELP_KICK_PROTECTED
	
	Note que los usuarios protegidos (+a) no pueden ser pateados
	con este comando, ni siquiera por el fundador del canal.

CHAN_HELP_TOPIC
	Sintaxis: TOPIC Canal Tpico
	
	Causa que %S cambie el tpico del canal a aquel que se
	ha especificado.  Este comando es ms til en conjuncin
	con SET TOPICLOCK.  Originalmente, limitado a usuarios
	con acceso %s o superior en el canal.

CHAN_HELP_CLEAR
	Sintaxis: CLEAR Canal Algo
	
	Le dice a %S que borre ciertos ajustes en un canal.  Algo
	puede ser cualquiera de las siguientes opciones:
	
	    MODES       Borra todos los modos en el canal excepto aquellos
	                    modos fijados con la opcin MLOCK (candado).
	    BANS        Borra todos los bans (bloqueos) en el canal.
CHAN_HELP_CLEAR_EXCEPTIONS
	    EXCEPTIONS  Borra todas las excepciones en el canal.
CHAN_HELP_CLEAR_MID
	    OPS         Remueve el estatus de operador de canal (modo +o)
	                    de todos los usuarios.
CHAN_HELP_CLEAR_HALFOPS
	    HALFOPS     Remueve estatus MitadOP (modo +h) de todos los usuarios.
CHAN_HELP_CLEAR_END
	    VOICES      Remueve el estatus "voice" (modo +v) de todo usuario.
	    USERS       Remueve o Patea (kicks) todos los usuarios del canal.
	
	Originalmente, limitado a usuarios con acceso %s o superior
	en el canal.

CHAN_HELP_STATUS
	Sintaxis: STATUS Canal Apodo
	
	Muestra el nivel de acceso curriente del apodo dado en el
	canal dado.  La repuesta es en el formato:
	
	    STATUS Canal Apodo Nivel-De-Acceso
	
	Si ocurre un error, la respuesta ser en el formato:
	
	    STATUS Canal Apodo ERROR Mensaje-De-Error
	
	Originalmente, limitado a usuarios con acceso %s o superior
	en el canal.

CHAN_OPER_HELP_COMMANDS
	
	Comandos disponibles para los administradores de Servicios:
	
CHAN_OPER_HELP_COMMANDS_GETPASS
	    GETPASS   Recobre la contrasea de fundador para un canal
	                  (solo si encripcin est deshabilitada)
CHAN_OPER_HELP_COMMANDS_FORBID
	    FORBID    Prevenga el que un canal sea registrado/usado
	    SUSPEND   Prevenga el que un canal registrado sea usado
	    UNSUSPEND  Cancele la suspensin de un canal
CHAN_OPER_HELP_COMMANDS_END
	
	Administradores de Servicios tambin pueden cancelar cualquier
	canal sin identificarse via contrasea, y pueden ver las listas
	de acceso, AKICK, y de ajuste de niveles o utilizar el comando
	STATUS para cualquier canal.

CHAN_OPER_HELP_DROP
	Sintaxis: DROP Canal
	
	Elimina el canal seleccionado.  Solamente los Administradores de Servicios
	pueden eliminar un canal por el cual no se han identificado.

CHAN_OPER_HELP_SET
	
	Administradores de Servicios tambin pueden fijar la opcin NOEXPIRE,
	con la cual se puede prevenir el que los canales expiren. Adicionalmente,
	los Administradores de Servicios pueden fijar opciones para cualquier
	canal sin identificarse via contrasea por el canal.

CHAN_OPER_HELP_SET_NOEXPIRE
	Sintaxis: SET Canal NOEXPIRE {ON | OFF}
	
	Ajusta si el canal especificado expirar o no.  Ajustar esta opcin
	a ON previene que el canal expire.
	
	Limitado a los Administradores De Servicios.

CHAN_OPER_HELP_UNSET
	
	Igual que con el comando SET, los Administradores de Servicios pueden
	borrar ajustes para cualquier canal sin identificarse por el canal.

CHAN_OPER_HELP_INFO
	
	Administradores de Servicios pueden usar el parmetro ALL con cualquier canal.

CHAN_OPER_HELP_LIST
	Sintaxis: LIST Patrn [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Lista todos los canales registrados que concuerden con el patrn dado.
	Canales con la opcin PRIVATE activada solamente sern mostrados a
	los administradores de Servicios. Canales con la opcin NOEXPIRE activada
	tendrn un signo ! antecediendo al nombre del canal, Esto en el caso de
	los administradores de servicios.
	
	Si las opciones FORBIDDEN, SUSPENDED o NOEXPIRE son dadas, solo
	aquellos canales que, respectivamente, tienen las opciones FORBID, SUSPEND
	o que tienen el modo NOEXPIRE activado sern mostrados. Las opciones pueden
	ser utilizadas en cualquier orden y en cualquier combinacin. Estas opciones
	estn limitadas a los Administradores de Servicios.

CHAN_OPER_HELP_GETPASS
	Sintaxis: GETPASS Canal
	
	Retorna la contrasea para el canal indicado.  Note que
	siempre que este comando es usado, un mensaje incluyendo la
	persona que ejuct el comando y el canal para el cual fue
	usado ser archivado y enviado en forma de WALLOPS/GLOBOPS.
	
	Si encripcin est en uso, este comando puediera no estar disponible
	dependiendo del tipo de encripcin que se este usando en la red.
	
	Limitado a los Administradores De Servicios.

CHAN_OPER_HELP_FORBID
	Sintaxis: FORBID Canal
	
	Deshabilita el que alguien registre o utilice el canal indicado.
	Esto puede ser revertido por medio de eliminar el canal (drop).
	
	Limitado a los Administradores De Servicios.

CHAN_OPER_HELP_SUSPEND
	Sintaxis: SUSPEND [+Expiracin] Canal Razn
	
	Previene el que un canal sea utilizado o que alguien se
	identifique por l.  Se puede lograr que el canal se utilice
	nuevamente por medio del comando UNSUSPEND, lo cual
	permitir su uso como antes.  El parmetro Expiracin es
	interpretado en la misma manera que el comando %s AKILL.
	
	Limitado a los Administradores De Servicios.

CHAN_OPER_HELP_UNSUSPEND
	Sintaxis: UNSUSPEND Canal
	
	Permite a los usuarios el uso y el que se identifiquen por un
	canal que habia sido previamente suspendido (suspend).
	
	Limitado a los Administradores De Servicios.


###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S es una utilera que le permite a los usuarios de IRC
	el envio de mensajes cortos a otros usuarios de la misma red,
	independientemente de si estos estn en lnea o no, igualmente
	se puede enviar mensajes a canales(*).  Ambos apodos remitente
	y destinatario, asi como el canal al que se envia deben estar
	registrados para poder enviar un mensaje. Escriba
	/msg %S HELP COMMANDS para ver la lista de comandos de %S;
	para usar un comando, escriba /msg %S Comando, o para ms
	informacin sobre un comando, escriba /msg %S HELP Comando.
MEMO_HELP_EXPIRES
	
	Nota:  Los mensajes expirarn ( automticamente borrados)
	%s despues de haber sido enviados, a menos que se hayan marcado
	como para no expirar con el comando SAVE.
MEMO_HELP_END_LEVELS
	
	(*) Originalmente, cualquier usuario con al menos nivel %s de
	    acceso en un canal puede leer los mensajes del canal.
	    Esto puede ser cambiado con el comando %s LEVELS.
MEMO_HELP_END_XOP
	
	(*) Cualquier usuario en la lista de SOPs de un canal puede
	    leer los mensajes para dicho canal.

MEMO_HELP_COMMANDS
	Los siguientes comandos pueden ser utilizados con %S:
	
	    SEND   Envie un mensaje a un apodo o canal
	    LIST   Liste sus mensajes
	    READ   Lea un mensaje o mensajes
MEMO_HELP_COMMANDS_FORWARD
	    FORWARD   Reexpida mensajes a su direccin e-mail
MEMO_HELP_COMMANDS_SAVE
	    SAVE      Define el que ciertos mensajes no expiren
MEMO_HELP_COMMANDS_DEL
	    DEL    Borre un mensaje o mensajes
	    SET    Ajuste opciones relacionadas a los mensajes
	    INFO   Muestra informacin relacionada a los mensajes
MEMO_HELP_COMMANDS_IGNORE
	    IGNORE    Ignore los mensajes de ciertos usuarios

MEMO_HELP_SEND
	Sintaxis: SEND {Apodo | Canal} Texto-Del-Mensaje
	
	Le envia al apodo o canal indicado un mensaje conteniendo
	el texto-del-mensaje.  Cuando se envie a un apodo, el recipiente
	recibir una nota informandole que l/ella tiene un nuevo mensaje.
	El apodo/canal al que se envie debe estar registrado.

MEMO_HELP_LIST
	Sintaxis: LIST [Canal] [List | NEW]
	
	Lista cualquier mensaje que usted pueda tener actualmente.  Con NEW,
	lista solamente nuevos mensajes (sin leer).  Mensajes no leidos se marcan
	con el signo * a la izquierda del nmero del mensaje.  Usted tambin puede
	especificar una lista de nmeros, como en el ejemplo abajo:
	
	   LIST 2-5,7-9
	      Lista mensajes enumerados de 2 hasta el 5 y 7 hasta el 9.

MEMO_HELP_LIST_EXPIRE
	Sintaxis: LIST [Canal] [Nm | List | NEW]
	
	Alista todos sus mensajes actuales.  Con NEW, alista solo los mensajes
	nuevos (sin leer).  Mensajes an sin leer son marcados con un signo "*"
	a la inzquierda de el nmero del mensaje; mensajes que no expirarn son
	marcados con un signo "+".  Usted tambin puede especificar una lista de
	nmmeros, como en el siguiente ejemplo:
	
	   LIST 2-5,7-9
	      Alista mensajes enumberados de 2 hasta el 5 y 7 hasta el 9.

MEMO_HELP_READ
	Sintaxis: READ [Canal] {Nm | List | LAST | NEW}
	
	Le envia el texto de los mensajes especificados.  Si se especifica
	LAST, Le envia el mensaje ms reciente recibido por usted.  Si se
	especifica NEW, le envia todos sus nuevos mensajes.  De lo contrario,
	le envia el nmero Nm del mensaje.  Usted tambin puede especificar
	una lista de nmeros, como con el comando LIST.

MEMO_HELP_SAVE
	Sintaxis: SAVE [Canal] {Nm | List}
	
	Marca el mensaje o mensajes dados como unos que no expirarn.  Usted puede
	simplemente dar o bien el nmero de un mensaje o, como con el comando LIST,
	una lista de mensajes.

MEMO_HELP_DEL
	Sintaxis: DEL [Canal] {Nm | List | ALL}
	
	Borra los mensajes o mensaje especificados.  Usted puede
	suplir multiples nmeros o un rango de nmeros en lugar de
	un simple nmero, tal como con el comando LIST; tambin se
	pude especificar el parmetro ALL, lo cual causar que
	todos sus mensajes sean borrados.
	
	Advertensia: Una vez que un mensaje ha sido borrado, no se
	puede recuperar!

MEMO_HELP_SET
	Sintaxis: SET Opcin Parmetros
	
	Ajusta varias opciones del mensaje.  opcin puede ser:
	
	    NOTIFY      Cambia cuando ser usted notificado de
	                    nuevos mensajes (Solamente apodos)
	   LIMIT       Fija el nmero mximo de mensajes que
	                    usted puede recibir
MEMO_HELP_SET_OPTION_FORWARD
	    FORWARD     Establece el que si los mensajes sern
	                automticamente reexpedidos a usted
MEMO_HELP_SET_END
	
	Escriba /msg %S HELP SET opcin para ms informacin
	sobre una opcin especfica.

MEMO_HELP_SET_NOTIFY
	Sintaxis: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Cambia cuando ser notificado usted de nuevos mensajes:
	
	    ON      Usted ser notificado de mensajes cuando se
	               conecte, cuando desactive /AWAY, y cuando
	               estos le sean enviados a usted.
	    LOGON   Usted ser notificado de mensajes solamente al
	               conectarse o cuando desactive /AWAY.
	    NEW     Usted ser notificado de mensajes solamente
	               cuando estos le sean enviados.
	    OFF     No recibirs notificacin alguna de mensajes.
	
	ON es equivalente a LOGON y a NEW combinados.
	
	Note que si su apodo tiene la opcin "secure" activada,
	usted ser solamente notificado de mensajes nuevos (para
	LOGON u ON) despues de indentificarse a %s.

MEMO_HELP_SET_LIMIT
	Sintaxis: SET LIMIT [Canal] Lmite
	
	Fija el nmero mximo permitido de mensajes que usted (o el
	canal dado) pueden tener. Si se fija esto a 0, nadie podr
	enviar mensaje alguno a usted.  Sin embargo, usted no puede
	fijar esto a un nmero mayor que %d.

MEMO_HELP_INFO
	Sintaxis: INFO [Canal]
	
	Muestra informacin sobre el nmero de mensajes que usted
	tiene, cuantos de estos estn sin leer, cuantos mensajes
	en total usted puede recibir y cuando ser usted notificado
	de los nuevos mensajes. con el parmetro, muestra la misma
	informacin para el canal indicado.

MEMO_OPER_HELP_COMMANDS
	
	Administradores de servicios pueden usar los comandos SET y INFO con
	apodos que no sean los suyos propios.

MEMO_OPER_HELP_SET_LIMIT
	Sintaxis: SET LIMIT [Usuario | Canal] {Lmite | NONE} [HARD]
	
	Fija el nmero mximo permitido de mensajes que un usuario (o canal)
	pueden tener.  Si se fija el lmite a 0 previene que el usuario
	reciba mensaje alguno; fijandolo a NONE le permitir al usuario
	recibir y mantener cuantos mensajes desee; y fijandolo a DEFAULT
	restaur el limite a el valor original (%d).  Si usted no indica
	un apodo o canal, su propio lmite es ajustado
	
	Agregar HARD previene que el usuario cambie el lmite.  No
	agregar HARD tiene el efecto opuesto, permitiendo entonces
	que el usuario cambie el lmite (inclusive si un lmite previo
	fue fijado con HARD).
	
	Este uso del comando SET LIMIT es limitado a Administradores
	De Servicios.  Otros usuarios solo pueden establecer su propio
	lmite o el de un canal sobre el cual tienen tales privilegios, no
	pueden remover su lmite, no pueden fijar un lmite superior a %d,
	y no pueden fijar un lmite HARD.

MEMO_OPER_HELP_INFO
	Sintaxis: INFO [Apodo | Canal]
	
	Sin un parmetro, muestra informacin sobre el nmero de
	mensajes que usted tiene, cuantos estn sin leer, cuantos
	mensajes en total usted puede recibir y cuando es que se
	le notifica a usted de nuevos mensajes.
	
	Con un parmetro de canal, muestra la misma informacin para
	el canal indicado.
	
	Con un parmetro de apodo, muestra la misma informacin para
	el apodo indicado.  Este comando est limitado a los
	Administradores De Servicios.

MEMO_HELP_FORWARD
	Sintaxis: FORWARD {Nm | List | ALL}
	
	Reexpide uno o ms de sus mensajes a su correo electrnico.  Usted debe
	haber fijado una direccin de correo electrnico vlida para su apodo
	para que le sea posible utilizar este comando.  Mensajes a canales no
	pueden ser reexpedidos.

MEMO_HELP_SET_FORWARD
	Sintaxis: SET FORWARD {ON | COPY | OFF}
	
	Fija si %S automticamente reexpide los mensajes enviados a usted
	a su direccin de correo electrnico.  Fijado a ON,  reexpide los
	mensajes enviados a usted a el correo electrnico acreditado a su
	apodo en lugar de enviarlos a usted en IRC.  COPY es similar, pero
	tambin instruye a %S que mantenga una copia del mensaje para
	leerlo en linea.  Fijado a OFF, sus mensajes sern almancenados en
	linea como es usual.  Incluso si usted fija esta opcin a ON, usted
	an podr recibir mensajes en linea si los servicios son incapaces de
	reexpedirlos a usted.
	
	Note que cuando esta opcin es fijada a COPY y usted ha recibido
	el nmero  mximo de mensajes que le son permitidos, no le ser
	posible a usted recibir mensaje nuevo alguno (incluyendo por correo
	electrnico) hasta que haya borrado algunos mensajes viejos usando
	el comando DEL.

MEMO_HELP_IGNORE
	Sintaxis: IGNORE {ADD | DEL | LIST} [Apodo | Mscara]
	
	Controla la lista de usuarios "ignorados"; los usuarios de los cuales el apodo
	o su mscara usuario@proveedor-web  concuerden con una entrada en esta lista
	no les ser permitido enviarle mensajes a usted.  ADD agrega el apodo dado o
	la mscara usuario@proveedor-web a su lita de ignorar, y DEL remueve el apodo
	dado o la mscara de dicha lista; LIST muestra su lista actual de ignorar.
	
	Note que el apodo o mscara dada en el comando ADD puede contener los
	signos "*" o "?", y esto no es sensitivo a maysculas or minsculas; por
	ejemplo, "*Evil*" concuerda con "EvilNick", "AN_EVIL_USER" y tambin con
	"devil".


###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	%S permite a los operadores de IRC controlar varios aspectos
	de la red de IRC.  Escriba /msg %S HELP COMMANDS para ver la
	lista de comandos.
	
	Nota: Todos los comandos enviados a %S son archivados!

OPER_HELP_COMMANDS
	Comandos de %S:
	    GLOBAL      Envie un mensaje a todos los usuarios
	    STATS       Muestra el estatus de los Servicios y red
	    SERVERMAP   Muestra un mapa de los servidores en la red
	    OPER LIST   Lista todos los Operadores de Servicios
	    ADMIN LIST  Lista todos los Administradores de Servicios
OPER_HELP_COMMANDS_SERVOPER
	
	Comandos solo para Administradores y Operadores de Servicios:
	    MODE        Cambia los modos de un canal
	    KICK        Patea (kicks) a un usuario de un canal
	    CLEARMODES  Remueve ciertos modos de un canal
	    CLEARCHAN   Remueve todos los usuarios de un canal (pateo masivo)
	    KILLCLONES  Desconecta (kills) todos los usuarios con cierta mscara
OPER_HELP_COMMANDS_AKILL
	    AKILL       Manipula la lista de auto-desconeccon (AKILL)
	    AKILLCHAN   Auto-desconecta todos los usuarios en un canal
OPER_HELP_COMMANDS_EXCLUDE
	    EXCLUDE     Manipula la lista de exclusin de auto-desconeccin (AKILL)
OPER_HELP_COMMANDS_SLINE
	    SGLINE      Manipula la lista SGLINE
	    SQLINE      Manipula la lista SQLINE
	    SZLINE      Manipula la lista SZLINE
OPER_HELP_COMMANDS_SESSION
	    SESSION     Vea la lista de sesiones para una mscara
	    EXCEPTION   Modifica la lista de excepcin de lmite de sesiones
OPER_HELP_COMMANDS_NEWS
	    LOGONNEWS   Define mensajes que ven los usuarios al conectarse
	    OPERNEWS    Define mensajes que ven los usuarios que usan /OPER
OPER_HELP_COMMANDS_SERVADMIN
	
	Comandos disponibles solo a los Administradores de Servicios:
	    OPER        Modifica la lista de Operadores de Servicios
	    JUPE        Impone el comando "Jupiter" para un servidor
	    SET         Ajusta varias opciones globales de los Servicios
	    UPDATE      Fuerza una actualizacin immediata en el disco de las
	                    bases de datos de los servicios
	    SHUTDOWN    Graba la base de datos al disco y detiene los servicios
	    QUIT        Detiene los Servicios sin grabar la base de datos al disco
	    RESTART     Graba la base de datos al disco y recomienza los servicios
	    REHASH      Re-lee los ficheros de configuracin
	    SU          Obtenga privilegios de Super-Usuario de los Servicios
OPER_HELP_COMMANDS_SERVROOT
	
	Comandos disponibles solo al Super-Usuario de los Servicios:
	    ADMIN       Modifica la lista de Administradores De Los Servicios
OPER_HELP_COMMANDS_RAW
	    RAW         Envia un comando "raw" al servidor de IRC

OPER_HELP_GLOBAL
	Sintaxis: GLOBAL Mensaje
	
	Permite a los IRCops enviar mensajes a todos los usuarios en la red.
	El mensaje ser enviado desde el apodo %s.

OPER_HELP_STATS
	Sintaxis: STATS [RESET | NETWORK | ALL]
	
	Sin ninguna opcin, muestra el nmero corriente de usuarios y IRCops
	en lnea (excluyendo los Servicios), el nmero mas alto de usuarios en
	lnea desde que los Servicios comenzaron, asi como la cantidad de
	tiempo que ha pasado desde que los Servicios han estado corriendo.
	
	Con la opcin RESET, reajusta la cuenta mxima de usuarios a la
	del nmero de usuarios corrientes en lnea.
	
	Con la opcin NETWORK, muestra la cantidad de data enviada a
	y recibida desde el servidor remoto, asi como la cantidad de memoria
	usada por las prelecturas de enchufe de la red. El rtio de uso de la
	memoria de prelectura corriente contra la dimensin del lmite de la
	prelectura es tambin mostrado en porcentage si se configur un lmite.
	
	La opcin ALL est disponible solamente a los administradores de Servicios,
	y muestra informacin sobre la cantidad de memoria usada por los Servicios.
	utilizar esta opcin puede conjelar los Servicios por un corto periodo de tiempo
	en redes muy grandes, por lo tanto no la sobreuse!
	
	UPTIME puede ser utilizado como un sinnimo de STATS.

OPER_HELP_SERVERMAP
	Sintaxis: SERVERMAP
	
	Muestra un mapa de los servidores conectados a la red, desde el punto
	de vista de los servicios.  Servidores "Falsos" los servicios mismos o
	cualquier otro  servidor que ha sido sacado de la red con el comando JUPE
	tienen un signo "(*)" que se muestra detras del nombre de el servidor.

OPER_HELP_OPER
	Sintaxis: OPER ADD Apodo
	          OPER DEL Apodo
	          OPER LIST
	
	Habilita a los Administradores de los Servicios para agregar
	(ADD) o a borrar (DEL) usuarios de la lista de operadores.
	Un usuario que se encuentre en la lista de operadores y
	que se identifique ante %s podr acceder a los comandos
	de Operador de Servicios.
	
	Cualquiera de los operadores de IRC (IRCops) puede utilizar
	el comando OPER LIST. Todos los otros comandos solo pueden
	ser utilizados por los Administradores de Servicios.

OPER_HELP_ADMIN
	Sintaxis: ADMIN ADD Apodo
	          ADMIN DEL Apodo
	          ADMIN LIST
	
	Habilita a los sper-usuarios de los Servicios a agregar (ADD)
	o a eliminar (DEL) usuarios de la lista de los administradores.
	Un usuario que se encuentre en la lista de operadores y que se
	identifique ante %s podr acceder a los comandos de los
	Administrador de Servicios.
	
	Cualquiera de los operadores de IRC (IRCops) puede utilizar
	el comando ADMIN LIST.  Todos los otros comandos solo pueden
	ser utilizados por el sper-usuarios de los Servicios.

OPER_HELP_MODE
	Sintaxis: MODE Canal Modos
	
	Habilita a los operadores de Servicios a establecer los
	modos para cualquier canal.  Los parmetros son los mismos
	que se utilizan en la forma estndar de /MODE.
	
	Solo disponible para los Operadores de Servicios.

OPER_HELP_CLEARMODES
	Sintaxis: CLEARMODES Canal [ALL]
	
	Elimina los modos binarios (n,s,t,k,l ect) y los bloqueos (bans)
	de un canal. Si el parmetro ALL es dado, tambin quita los
	modos Operador y voz que haya en el canal (modos +o y +v).
	
	Solo disponible para los Operadores de Servicios.

OPER_HELP_CLEARCHAN
	Sintaxis: CLEARCHAN Canal
	
	Remueve todos los usuarios de un canal (pateo masivo).
	
	Limitado a los Operadores De Servicios.

OPER_HELP_KICK
	Sintaxis: KICK Canal Usuario Razn
	
	Habilita a un IRCop a sacar a un usuario de cualquier canal.
	Los parmetros son los mismos que para un /KICK comn.  El
	mensaje de kick mostrar al usuario el nombre del IRCop que
	est enviando el comando. Por ejemplo:
	
	*** SpamMan has been kicked off channel #my_channel by %S (Alcan (Flood))
	
	Solo disponible para los Operadores de Servicios.

OPER_HELP_AKILL
	Sintaxis: AKILL ADD [+Expiracin] Mscara Razn
	          AKILL DEL Mscara
	          AKILL LIST [Mscara] [NOEXPIRE]
	          AKILL VIEW [Mscara] [NOEXPIRE]
	          AKILL COUNT
	
	Permite a los Operadores de servicios manipular la lista AKILL.
	Si un usuario que figura en dicha lista, intenta conectarse, los
	Servicios impondrn un KILL para el usuario y darn instrucciones
	a todos los servidores donde esta opcin es disponible, que agreguen
	un ban (k-line) para la mscara que coincida con la del usuario.
	
	AKILL ADD agrega el usuario dado (con la mscara usuario@host)
	a la lista de akill por la razn dada (que debe ser dada).
	AKILL DEL quita el usuario dado de la lista de AKILL si el
	mismo est presente.  AKILL LIST muestra todos los usuarios
	que estn actualmente en la lista. Si una mscara es dada, el
	listado estar limitado a las ocurrencias. AKILL VIEW es
	ms explcito que AKILL LIST, dado que muestra quien agreg el
	AKILL, la fecha en que fue hecho, cuando expira, la mscara
	usuario@host utilizada y la razn.  AKILL COUNT simplemente
	retorna el nmero de AKILLs en la lista AKILL.
	
	Opcionalmente, un tiempo de expiracin tambin puede ser
	suministrado con el comando AKILL ADD.  El tiempo de
	expiracin PRECEDE a la mscara usuario@Proveedor y deber
	ser especificado como un entero seguido o bien por d (das),
	h (horas), o por m (minutos). Combinaciones (como 1h30m) son
	tambin permitidas.  Si un especificador de unidades no es
	incluido, originalmente se asumen DIAS (entonces, poner +30
	sin nada, significa 30 das).  Para agregar un AKILL que NO
	expira, utilice +0.  Si la mscara de usuario comienza con
	+, un perodo de expiracin deber ser indicado, an si es
	el mismo perodo que el asignado originalmente.
	
	La Razn debe describir el porqu se agreg la entrada;
	dependiendo de como han sido configurados los servicios, la
	razn podiera ser mostrada a los usuarios en los mensajes KILL.
OPER_HELP_AKILL_OPERMAXEXPIRY
	
	Los Operadores De Servicios pueden fijar un tiempo de expiracin de solamente
	%s; Mientras que los Administradores De Servicios pueden fijar cualquier
	tiempo de expiracin.
OPER_HELP_AKILL_END
	
	Limitado a los Operadores De Servicios.

OPER_HELP_AKILLCHAN
	Syntax: AKILLCHAN [KILL] [+Expiracin] Canal Razn
	
	Aade auto-desconecciones para todos los usuarios excepto para los operadores de
	IRC en el canal especificado, y opcionalmente (si KILL es especificado)
	los remueve de la red.  La Razn ser recordada en cada auto-desconeccin,
	y puede ser mostrada en los mensajes de desconeccin dependiendo de como esten
	configurados los Servicios.  Expiracin toma el mismo formato como en el
	comando AKILL ADD; Si no es especificado, lo fija por %s.
	
	Auto-desconecciones aadidas con este comando tendrn el formato
	*@Mscara, para cada mscara usada por un cliente en el
	canal.  Si dicha auto-desconeccin ya existe para una mscara,
	esta no ser modificada; esto puede causar que el nmero de
	auto-desconecciones aadidas sea menor que el nmero de usuarios
	afectados.
	
	Limitado a los Operadores De Servicios.

OPER_HELP_EXCLUDE
	Sintaxis: EXCLUDE ADD [+Expiracin] Mscara Razn
	          EXCLUDE DEL Mscara
	          EXCLUDE LIST [Mscara] [NOEXPIRE]
	          EXCLUDE VIEW [Mscara] [NOEXPIRE]
	          EXCLUDE COUNT
	
	Permite a los Operadores de servicios manipular la lista de exclusin de
	auto-desconeccin (AKILL).  Cuando un usuario que concuerda con una mscara
	de exclusin de auto-desconeccin se connecta a la red, Los servicios no
	impondrn un KILL para dicho usuario inclusive si el usuario de otra forma
	concordara con una mscara de auto-desconeccin (AKILL) .  Esto es til si
	usted tiene mscaras de auto-desconeccin muy generales, y an desea que
	ciertos dominios especificos o usuarios que conduerdan con esas mscaras
	le sea posible conectarse a la red.
	
	Los subcomandos ADD, DEL, LIST, VIEW, y COUNT funcionan en la misma manera
	en que lo hacen los subcomandos con respecto al comando AKILL; vea la
	ayuda para AKILL para obtener ms informacin.
	
	Limitado a los Operadores De Servicios.

OPER_HELP_SGLINE
	Sintaxis: SGLINE ADD [+Expiracin] Mscara Razn
	        SGLINE DEL Mscara
	        SGLINE LIST [Mscara] [NOEXPIRE]
	        SGLINE VIEW [Mscara] [NOEXPIRE]
	        SGLINE COUNT
	
	Permite a los Operadores de servicios manipular la lista SGLINE.  Si un usuario
	de quien el "real name" concuerda con una mscara SGLINE trata de conectarse,
	Los servicios impondrn un KILL para dicho usuario y, en servidores en los que
	esto este disponible, instruirn a todos los servidores que agregen un bloqueo
	(G-line en el servidor) para la mscara con la que el usuario concuerda.
	
	SGLINE ADD agrega la mscara para el real name dada a la lista SGLINE con
	la razn especificada (la cual debe ser especificada).
	SGLINE DEL remueve la mscara especificada de la lista SGLINE si esta
	est presente.
	SGLINE LIST muestra todas las entradas SGLINE; si la mscara opcional es
	especificada, el listado se limitar a aquellas entradas que concuerden con
	dicha mscara.
	SGLINE VIEW es una versin ms detallada de el comando SGLINE LIST, y
	mostrar quien aadi cada entrada SGLINE, la fecha en que fue aadida,
	cuando fue usada por ltima vez, cuando expira, como tambin la mscara
	y la razn.  Si la opccin NOEXPIRE es dada, entonces solamente entradas
	que no expiran y que concuerdan con la mscara especificada
	sern mostradas.
	SGLINE COUNT simplemente retorna el nmero de entradas en la
	lista SGLINE.
	
	El parmetro Mscara puede ser encerrado en comodnes dobles, y
	debe estar cuando la mscara contiene espacios; por ejemplo:
	    /msg %S SGLINE ADD +0 "nombre malo" Este es un nombre prohibido.
	
	Opcionalmente, un tiempo de expiracin puede ser dado con el comando
	SGLINE ADD.  El tiempo de expiracin precede a la mscara usuario@host,
	y es especificada con un entero seguido por o bien d (das),
	h (horas), o m (minutos).  Combinaciones (tales como 1h30m)
	son tambin permitidas.  Si un especificador de unidad no es incluido,
	lo fijado sern das (por lo tanto +30 por si mismo significa 30 das).
	Para agregar una entrada que no expire, utilice +0.  Si la mscara que
	se aadir comienza con un + y no se especifica un tiempo de expiracin,
	la mscara debe ser encerrada entre comodnes dobles, justo como lo hemos
	descrito arriba.
	
	La Razn deberia describir el porqu se agrego la entrada; dependiendo
	de cmo los servicios han sido configurados, esta pudiera tambien ser
	mostrada a los usuarios en los mensajes de KILL.
	
	Limitado a los Operadores De Servicios.

OPER_HELP_SQLINE
	Sintaxis: SQLINE ADD [+Expiracin] Mscara Razn
	        SQLINE DEL Mscara
	        SQLINE LIST [Mscara] [NOEXPIRE]
	        SQLINE VIEW [Mscara] [NOEXPIRE]
	        SQLINE COUNT
	
OPER_HELP_SQLINE_KILL
	Permite a los Operadores de Servicios manipular la lista
	SQLINE.  Si un usuario cuyo apodo concuerda con una mscara
	SQLINE trata de conectarse, o si un usuario trata de cambiar
	su apodo a uno que concuerda con una mscara SQLINE, Los
	Servicios impondrn un KILL para dicho usuario y, en los
	tipos de servidores donde esto este disponible, instruirn a
	todos los servidores que agregen un bloqueo (G-line en el
	servidor) para la mscara con la que el usuario concuerda.
OPER_HELP_SQLINE_NOKILL
	Permite a los Operadores de Servicios manipular la lista
	SQLINE.  Si un usuario cuyo apodo concuerda con una mscara
	SQLINE trata de conectarse, o si un usuario trata de cambiar
	su apodo a uno que concuerda con una mscara SQLINE, Los
	Servicios cambiarn el apodo de dicho usuario a un apodo
	"guest" (Husped), y enviar un mensaje al usuario que
	normalmente causar que el programa cliente de IRC del
	usuario pida un nuevo apodo.  En tipos de servidores donde
	est disponible, Los Servicios tambin instruirn a todos
	los servidores que agregen un bloqueo (Q-line en el
	servidor) para la mscara con la que el usuario concuerda.
OPER_HELP_SQLINE_IGNOREOPERS
	
	Note que los Operadores de IRC no sern afectados por
	mscaras SQLINE.
OPER_HELP_SQLINE_END
	
	Los subcomandos ADD, DEL, LIST, y VIEW, asi como COUNT pueden ser utilizados
	para agregar, borrar, ver (versin corta o larga), o cuenta el nmero
	de entradas en la lista SQLINE.  Vea la ayuda para
	SGLINE (/msg %S HELP SGLINE) para ms detalles.
	
	Limitado a los Operadores De Servicios.

OPER_HELP_SZLINE
	Sintaxis: SZLINE ADD [+Expiracin] Mscara Razn
	        SZLINE DEL Mscara
	        SZLINE LIST [Mscara] [NOEXPIRE]
	        SZLINE VIEW [Mscara] [NOEXPIRE]
	        SZLINE COUNT
	
	Permite a los Operadores de Servicios el manipular la lista SZLINE.  Si un usuario
	cuya direccin IP concuerda con una mscara SZLINE trata de conectarse, Los servicios
	impondrn un KILL para dicho usuario y,en servidores en los que esto este disponible,
	instruirn a todos los servidores que agregen un bloqueo (Z-line en el servidor) para
	la mscara con la que el usuario concuerda.
	
	Los subcomandos ADD, DEL, LIST, y VIEW, asi como COUNT pueden ser utilizados
	para agregar, borrar, ver (versin corta o larga), o cuenta el nmero
	de entradas en la lista SZLINE.  Vea la ayuda para
	SGLINE (/msg %S HELP SGLINE) para ms detalles.
	
	Limitado a los Operadores De Servicios.

OPER_HELP_EXCEPTION
	Sintaxis: EXCEPTION ADD [+Expiracin] Mscara Lmite Razn
	          EXCEPTION DEL {Mscara | List}
	          EXCEPTION MOVE Nmero NuevoNmero
	          EXCEPTION LIST [Mscara | List]
	          EXCEPTION VIEW [Mscara | List]
	
	Permite a los Operadores de Servicios manipular la lista de las
	mquinas (hosts) que tienen lmite de sesiones especficas - permitiendo
	a ciertas mquinas, como los servidores de shell, a que carguen ms
	del nmero permitido de clientes al mismo tiempo. Cuando una mquina
	alcanza su lmite de sesiones, culquier cliente que trate de conectarse
	desde aquella mquina ser desconectado (killed). Antes de esto, ellos
	sern, notificados via /NOTICE por %S, sobre dnde buscar ayuda acerca de
	lmite de sesiones. El contenido de la nota es una opcin de configuracin.
	
	EXCEPTION ADD agrega la mscara de una mquina a la lista de excepcin.
	Note: Mscaras como apodo!usuario@host y usuario@host son invlidas!
	Solamente mscaras reales, tales como mquina.host.dom y *.host.dom,
	son permitidas porque el limitado de sesiones no toma en cuenta apodos o
	nombres de usuario. lmite debe ser un nmero mayor o igual que cero.
	Esto determina cuantas sesiones es permitido cargar a esta mquina (host)
	simultaneamente. (Un valor de cero significa que dicha mquina disfruta
	de sesines ilimitadas).
	
	Opcionalmente, un tiempo de expiracin tambin puede ser dado con el comando
	EXCEPTION ADD.  El tiempo de expiracin preceder la mscara de la mquina,
	y es especficada con un entero seguido por o bien d (das), h (horas),
	o m (minutos).  Combinaciones (tales como 1h30m) son tambin permitidas.
	Si un especficador de unidad no es incluido, entonces lo normal es das (por
	lo tanto +30 por si mismo significa 30 das).  Para agregar una entrada que
	expire, utilice +0.  Si la mscara que se agregar comienza con un +,
	entonces un tiempo de expiracin debe ser especficado, incluso si es el mismo
	que lo fijado como lo normal en la configuracin.
	
	EXCEPTION DEL remueve la mscara dada o entrada enumerada o entradas
	del la lista de excepcin (nmeros de entrada pueden ser localizados con
	los parmetros VIEW o LIST).
	
	EXCEPTION MOVE mueve el Nmero de excepcin al NuevoNmero. Si
	NuevoNmero est ya siendo usado por otra excepcin, entonces su
	nmero ser aumentado para hacer espacio.
	
	EXCEPTION LIST y EXCEPTION VIEW muestran cada excepcin actual;
	si la mscara opcional es dada, la lista est limitada a aquellas
	excepciones que concuerdan con la mscara . La diferencia es que
	EXCEPTION VIEW es ms explcito, mostrando el nombre de la persona
	que agreg la excepcin, su lmite de sesin, razn, mscara de la
	mquina, y la fecha de expiracin con la hora.
	
	Note que un cliente al conectarse "usar" la primera excepcin que
	concuerde con la mquina de donde se conecta. Listas de excepcin
	grandes junto a mscaras de excepcin que concuerden apliamente
	afectarn negativamente en la eficiencia de los servicios.
	
	Limitado a los Operadores De Servicios.

OPER_HELP_SESSION
	Sintaxis: SESSION LIST Nm-Lmite
	          SESSION VIEW Mscara
	
	Permite a Operadores de Servicios ver lista de sesin.
	
	SESSION LIST lista  mscaras con al menos sesiones lmites.
	El lmite debe ser un nmero mayor que 1. Esto es para
	prevenir el listado accidental de el gran nmero de mquinas o
	mscaras con una sola sesin.
	
	SESSION VIEW muestra informacin detallada sobre una mscara o
	mquina especfica - incluyendo la cuenta de sesin curriente y
	lmite de sesin. El valor mscara no puede inclur comodnes.
	
	Vea la ayuda de EXCEPTION para ms informacin sobre limitado
	de sesiones y sobre como fijar lmites de sesiones especficos a
	ciertas mquinas y grupos de esas mquinas.
	
	Limitado a los Operadores De Servicios.

OPER_HELP_SU
	Sintaxis: SU Contrasea
	
	Permite acceso a funciones que requieren privilegios de
	super-usuario de los servicios.  La contrasea es la misma
	fijada con el comando SET SUPASS; note que la contrasea
	debe ser fijada antes de usar este comando.  Privilegios de
	Super-usuario solamente duran hasta que usted se desconecte
	de IRC.
	
	AVISO!: Si usted ingresa una contrasea incorrecta, Entonces
	los servicios enviarn un mensaje de aviso a todos los IRCops.
	
	Limitado a los Administradores De Servicios.

OPER_HELP_SET
	Sintaxis: SET Opcin Ajuste
	
	Ajusta varias opciones globales de los Servicios.  Algunas
	de las opciones actualmente definidas son:
	    READONLY   Fija servicios en modo de leer-solamente
	    DEBUG      Activa/desactiva el modo de deteccin de errores
	    SUPASS     Fija contrasea para el comando SU (super-usuario)
	
	Limitado a los Administradores De Servicios; la opcin SUPASS
	solo puede ser fijada por el Super-Usuario De Servicios.

OPER_HELP_SET_READONLY
	Sintaxis: SET READONLY {ON | OFF}
	
	Activa o desactiva el modo de leer-solamente.  En modo de
	leer-solamente, los usuarios regulares no podrn modificar
	las bases de datos de los servicios, incluyendo las listas
	de acceso de canales y apodos, ect. IRCops con suficientes
	privilegios si podrn modificar la lista AKILL asi como
	cancelar o prohibir apodos o canales, pero ninguno de estos
	cambios ser grabado al disco a menos que se desactive el modo
	de leer-solamente antes que los servicios sean desactivados o
	re-activados.
	
	Esta opcin es equivalente a la opcin -readonly en la lnea
	de comandos.

OPER_HELP_SET_DEBUG
	Sintaxis: SET DEBUG {ON | OFF | Nm}
	
	Activa/Desactiva el modo de deteccin de errores.  En modo de
	deteccin de errores, toda la informacion enviada a o desde los
	servicios asi como un nmero considerable de mensajes de chequeo
	son escritos en un archivo en el disco, Si se especifica Nm,
	el modo de deteccin de errores es activado con el nivel de
	deteccin fijado a Nm.
	
	Esta opcin es equivalente a la opcin -debug en la lnea
	de comandos.

OPER_HELP_SET_SUPASS
	Sintaxis: SET SUPASS [Contrasea]
	
	Fija la contrasea que se usar para el comando SU.  La
	contrasea debe ser fijada una vez antes de usar el comando SU
	por primera vez.  Si no se establece una contrasea, el comando
	SU no estar disponible.
	
	Esta opcin solo puede ser fijada por el Super-Usuario de Servicios.

OPER_HELP_JUPE
	Sintaxis: JUPE Servidor [Razn]
	
	Ordena a Servicios que ejecuten el comando jupiter en un servidor
	--eso es, crear un "servidor" falso conectado a los servicios
	que evita que el servidor real con ese nombre se conecte.  Esta
	opcin puede ser removida usando un /SQUIT estandar.  Si se da
	una razn, esta es colocada en el area de informacin del servidor;
	de otra manera, el area de informacin sobre el servidor contendr
	el texto "Jupitered by <apodo>", mostrando el apodo de la persona
	que desenganch (jupitered) al servidor.
	
	Limitado a los Administradores De Servicios.

OPER_HELP_RAW
	Sintaxis: RAW Texto
	
	Enva una cadena de caracteres directamente al servidor al
	cual los Servicios estn conectados.  Este comando tiene un
	muy limitado rango de usos, y puede causar estragos en una
	red o causar que los servicios caigan de no ser utilizado
	apropiadamente. NO USE ESTE COMANDO a menos que usted
	est completamente seguro de lo que est haciendo!
	
	Limitado al Super-Usuario De Servicios.

OPER_HELP_UPDATE
	Sintaxis: UPDATE [FORCE]
	
	Causa que los Servicios actualicen las bases de datos tan
	pronto como usted enva el comando.  Si la opcin FORCE es
	dada, los servicios procurarn abrir (liberar) las bases de
	datos antes de realizar la actualizacin; esto puede usarse
	para corregir los errores "databases are locked" cuando se
	actualizan las bases de datos.
	
	Limitado a los Administradores De Servicios.

OPER_HELP_QUIT
	Sintaxis: QUIT
	
	Causa la desactivacin de los Servicios; las bases de datos
	no se graban.  Este comando no debe utilizarse a menos que
	se sospeche de un dao en las bases de datos en-memoria y no
	deseen grabarse.  Para desactivacin normal de los
	Servicios, utilice el comando SHUTDOWN.
	
	Limitado a los Administradores De Servicios.

OPER_HELP_SHUTDOWN
	Sintaxis: SHUTDOWN
	
	Causa que los Servicios graben todas las bases de datos y despues se desactiven.
	
	Limitado a los Administradores De Servicios.

OPER_HELP_RESTART
	Sintaxis: RESTART
	
	Causa que los servicios graben todas las bases de datos y
	luego se desactiven. (ejemplo: salir e immediatamente
	re-hacer el ejecutable).
	
	Limitado a los Administradores De Servicios.

OPER_HELP_REHASH
	Sintaxis: REHASH
	
	Causa que los Servicios re-lean sus ficheros de configuracin y que actualicen
	la configuracin activa corriente.  Algunos ajustes, tales como RemoteServer
	(la cual establece la direccin de el servidor de IRC al que servicios se
	conectar), no puede ser cambiado con REHASH, y solo entrar en efecto cuando
	los Servicios sean re-empezados; en estos casos, un mensaje ser escrito en
	en el fichero de archivo de los Servicios , y una notificacin ser enviada
	poniendolo a usted al corriente de esto.
	
	Si lineas de LoadModule han sido agregadas o removidas de el fichero principal
	de configuracin de los servicios (%s), los modulos sern bien cargados o
	descargados segn sea necesario.  Los modulos que ya no tengan una linea de
	LoadModule sern descargados (desmontados) en orden reversa a aquellos que se
	cargarn; entonces, despues que los modulos que faltan hayan sido actualizados,
	los modulos nuevos sern cargados (montados) en el orden alistado en el fichero
	configuracin.  Si ocurriera un error en cualquiera de los pasos, entonces el
	proceso de actualizacin ser abortado (cancelado).
	
	Note que debido a dependencias de los modules, algunos modulos no pueden ser
	removidos o cambiandos via REHASH; en estos cases, usted deber re-empenzar
	los servicios para que los cambios entren en efecto.
	
	Limitado a los Administradores De Servicios.

OPER_HELP_KILLCLONES
	Sintaxis: KILLCLONES Apodo
	
	Desconecta (Kills) todos los usuarios que tengan la misma
	mscara que Apodo. un KILL temporario, en la forma *@mscara,
	es agregado para prevenir que los clientes ofensivos se reconecten
	immediatamente. un wallops es tambin enviado indicando quien us
	el comando, que mscara fue afectada y cuantos usuarios fueron
	desconectados. Esto es muy til cuando es necesario remover
	numerosos clones de la red.
	
	Limitado a los Operadores De Servicios.


###########################################################################
#
# StatServ help messages
#
###########################################################################

STAT_HELP
	%S provee informacin estadstica sobre la red de IRC,
	sobre sus servidores y tambin sus usuarios.  Escriba
	/msg %S HELP COMMANDS para ver la lista de comandos de %S;  Para
	informacin sobre un comando, escriba /msg %S HELP comando.

STAT_HELP_COMMANDS
	Los siguientes comandoss pueden ser utilizados con %S:
	
	    SERVERS     Estadsticas del servidor
	    USERS       Estadsticas de los usuarios

STAT_HELP_SERVERS
	Sintaxis: SERVERS STATS
	          SERVERS LIST [Mscara]
	          SERVERS VIEW [Mscara] [ONLINE | OFFLINE]
	
	Muestra estadsticas relacionadas a los servidores de la red.
	
	SERVERS STATS muestra un sumrio breve de los servidores
	actualmente visibles (en lnea) e invisibles (no en lnea) a
	los Servicios.
	SERVERS LIST muestra una lista de servidores en lnea y
	estadsticas corrientes sobre cada uno de ellos.
	SERVERS VIEW muestra una lista de servidores en o fuera de
	lnea con estadsticas detalladas sobre cada uno de ellos. las
	opciones ONLINE y OFFLINE causan, respectivamente, que
	solo los servidores en lnea o fuera de lnea sean mostrados.
	
	Utilice la opcin Mscara para limitar el tipo de estadsticas
	que sern mostradas sobre el servidor.

STAT_HELP_USERS
	Sintaxis: USERS STATS
	
	Muestra estadsticas relacionadas a los usuarios de la red.

STAT_OPER_HELP_SERVERS
	Sintaxis: SERVERS STATS
	          SERVERS LIST [Mscara]
	          SERVERS VIEW [Mscara] [ONLINE | OFFLINE]
	          SERVERS DELETE Servidor
	          SERVERS COPY Servidor NuevoNombre
	          SERVERS RENAME Servidor NuevoNombre
	
	Muestra estadsticas relacionadas a los servidores de la red.
	
	SERVERS STATS muestra un sumrio breve de los servidores
	actualmente visibles (en lnea) e invisibles (no en lnea) a
	los Servicios.
	SERVERS LIST muestra una lista de servidores en lnea y
	estadsticas corrientes sobre cada uno de ellos.
	SERVERS VIEW muestra una lista de servidores en o fuera de
	lnea con estadsticas detalladas sobre cada uno de ellos. las
	opciones ONLINE y OFFLINE causan, respectivamente, que
	solo los servidores en lnea o fuera de lnea sean mostrados.
	
	Utilice la opcin Mscara para limitar las estadsticas de
	qu servidor sern mostradas.
	
	DELETE borra las estadsticas del servidor especificado.
	COPY duplica un grupo de estadsticas del servidor.
	RENAME renombra un grupo de estadsticas del servidor.
	Estos tres comandos estn limitados al Super-Usuario De
	Servicios.
