# Emacs: -*- mode: fundamental; coding: binary; -*-

# IRC Services is copyright (c) 1996-2004 Andrew Church.
#     E-mail: <achurch@achurch.org>
# Parts written by Andrew Kempe and others.
# This program is free but copyrighted software; see the file COPYING for
# details.

# Hungarian language file (Magyar nyelvi fjl)

# =======================================================
# Translated by:
# =======================================================
#     Kapitny Jnos 'cyberboj' (chates@freemail.hu)
#     Romek Krisztin 'AngryWolf' (angrywolf@datachat.hu)
# =======================================================
#     DataChat.hu Admins (http://datachat.hu)
# =======================================================

# Amikor lefordtod ezt a fjlt ms nyelvre, tartsd szben, hogy a sprintf()
# paramtereinek sorrendje rgzitett a forrskdban, teht a te zeneteidnek
# ugyanazokat a paramtereket ugyanabban a sorrendben kell tvennie, mint
# ahogy az angol zenetekben vannak. (Nyilvnvalan, ez nem fogja megtartani az
# strftime() formtum sorokat azonnal alatta.) Ha nem tudod egyszeren lefordtani
# az zenetet anlkl, hogy megvltoztatnd a paramterek sorredjt, krlek,
# tjkoztasd a Service fejlesztit.
#
# A help zentekben, "%S" (Nagy S, nem kisbet) az zenetet kld service nevre
# vonatkozik; pldul a NickServ help zenetekben az "%S" a "NickServ"
# helyettestje (vagy lehet brmi ms, amire tnevezted a config.h fjlban).
# Az %S's nem szmit sprintf() paramternek, teht ez
# trendezhet, elmozdithat vagy hozzadhat, ha szksges.
#
# Emellett a help zenetekben, krlek, prbld meg korltozni a sorok hosszt
# 60 karakteres szvegre (nem belertve a sorkezd tabultort).  Azrt ezt a
# hosszsgot vlasztottuk, mert nem bontja szt a sorokat a legtbb jelenlegi
# IRC kliens alapbelltsaival. Ne felejtsd el, hogy a formz karaktereket
# (control-B, control-_) nem tartalmazza a 60 karakteres korltozs (mivel nem
# jelennek meg a felhasznl kpernyjn).  Arra is emlkezz, hogy a formtum-
# specifikusok (%S, stb.) kiterjednek, amikor megjelennek, teht ne hagyd
# figyelmen kivl; szben kell tartanod, hogy az lkliens neve (%S helyettesitje)
# 8 karakteres lesz, vagyis minden egyes %S karakter 6-tal cskkenti a maximlis
# sorhosszsgot.
#
# Vgl, ne felejts el tabultort rakni minden sor elejre a szvegben
# (mg az res soroknl is)!  Ezeknek tabultoroknak kell lennik,
# nem szkzknek.

###########################################################################
#
# A nyelv neve
#
###########################################################################

# Az angoltl klnbz nyelvek esetn ennek a sornak a kvetkez formban
# kell kinznie:
#     nyelv-neve-a-nyelvben (nyelv-neve-angolul)
# Pldul, "Espaol (Spanish)" vagy "Franais (French)".

LANG_NAME
	Magyar (Hungarian)

###########################################################################
#
# ltalnos zenetek
#
###########################################################################

# Ez forma sor a strftime()  man 3 strftime  informaci a formtum specifikusok
# jelentsrl.  Rvid verzi:
#	%a = ht napjnak neve (rvid)	%H = ra
#	%b = hnap neve (rvid)		%M = perc
#	%d = hnap napja 		%S = msodperc
#	%Y = v			%Z = id zona

# Ezt hasznljuk formtumsztringknt az strftime()-ban dtumhoz s idhz
# egytt.
STRFTIME_DATE_TIME_FORMAT
	%Y %b %d %H:%M:%S %Z
# Ezt hasznljuk formtumsztringknt az strftime()-ban egyedl a dtumhoz,
# hossz alakban (angolban: a ht napjnak nevvel egytt).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# Ezt hasznljuk formtumsztringknt az strftime()-ban egyedl a dtumhoz,
# rvid alakban (angolban: a ht napjnak neve nlkl).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# Ezek mondjk el a strftime()-nak, hogy mi a neve a hnapoknak s napoknak.
# Ha Te nem hasznlsz %a, %A, %b vagy %B karaktereket a fenti strftime()
# sztringjeidben, akkor resen hagyhatod.  De ha bersz neveket,
# KTELEZ sorrendben szerepelnik, soronknt egy lljon, s legyen TELJES
# a lista!

# %a
STRFTIME_DAYS_SHORT
	Vasrnap
	Htf
	Kedd
	Szerda
	Cstrtk
	Pntek
	Szombat
# %A
STRFTIME_DAYS_LONG
	Vasrnap
	Htf
	Kedd
	Szerda
	Cstrtk
	Pntek
	Szombat
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Feb
	Mrc
	pr
	Mj
	Jn
	Jl
	Aug
	Szept
	Oct
	Nov
	Dec
# %B
STRFTIME_MONTHS_LONG
	Janur
	Februr
	Mrcius
	prilis
	Mjus
	Jnius
	Jlius
	Augusztus
	Szeptember
	Oktber
	November
	December


# "nap", "ra", "perc", s "msodperc" egyes- s tbbes szmban.
# Ezeket meg kell elzni egy szkzzel, ha a nyelv ignyli
# (pl. angolban: "10 hours", nem "10hours").
STR_DAY
	 nap
STR_DAYS
	 nap
STR_HOUR
	 ra
STR_HOURS
	 ra
STR_MINUTE
	 perc
STR_MINUTES
	 perc
STR_SECOND
	 msodperc
STR_SECONDS
	 msodperc
# Elvlasztst hasznlunk az idegysgek kztt; az angol forma szerint
# a vesszt szkz kveti (a ", " a "3 ra, 10 perc" kifejezs kztt van).
STR_TIMESEP
	, 

# Ez a ChanServ/NickServ INFO kijelzsekben szerepel, s van egy vessz, amit
# egy szkz kvet (", " -- lnyeges az utna lv szkz), vagy egyenrtk
# a nyelv karakterkszletvel.
COMMA_SPACE
	, 


# Klnbz hibazenetek.
INTERNAL_ERROR
	Bels hiba--nem teljesthet a krs.
SERVICES_IS_BUSY
	Services jelenleg foglalt; krlek prbld ksbb.

UNKNOWN_COMMAND
	Ismeretlen parancs: %s.
UNKNOWN_COMMAND_HELP
	Ismeretlen parancs: %s. Tovbbi segtsgrt rd be: /msg %s HELP.
SYNTAX_ERROR
	Szintaxis: %s
MORE_INFO
	Tovbbi informcirt rd be: /msg %s HELP %s.
NO_HELP_AVAILABLE
	Nem ll rendelkezsre segtsg: %s.
MISSING_QUOTE
	Idzjel (") hinyzik.
BAD_EMAIL
	Az E-mail cmnek usernv@hostnv alakban kell lennie.  Nem hasznlhatsz a szneket, flkvr, alhzott vagy forditott karaktereket, illetve a kvetkez karakterek brmelyikt: , : ; | \ " ( ) < > [ ]
BAD_URL
	Az URL-nek http://gazdanv[:port]/... alakban kell lennie (vagy ftp://, stb.).
BAD_USERHOST_MASK
	A maszknak user@host alakban kell lennie.
BAD_NICKUSERHOST_MASK
	A maszknak nick!user@host alakban kell lennie.
BAD_EXPIRY_TIME
	rvnytelen lejrati id.
SENDMAIL_NO_RESOURCES
	A rendszer jelenleg tl forgalmas, hogy levelet kldjn; krlek prbld jra ksbb.
READ_ONLY_MODE
	Megjegyzs: A Services jelenleg csak olvashat mdban fut; a vltoztatsok nem kerlnek mentse!
PASSWORD_INCORRECT
	Hibs jelszt adtl meg.
PASSWORD_WARNING
	Figyelmeztets: Mg egy rossz jelsz megadsa utn a kapcsolatod meg fog szakadni.

# Hogy mi a klnbsg az "Hozzfrs megtagadva" s az "Engedly letiltva" kztt?
# Nagyon kicsi; biztonsggal nevezhet azonos zenetnek, valdi vesztesg nlkl.
# Ha meg akarod klnbztetni ket, az "Hozzfrs letiltva" ltalban gyakrabban
# hasznlt; pldul, a non-oper prblkozs az OperServ-hez val hozzfrsnl
# "Hozzfrs megtagadva", amg a non-Services admin hozzfrsi prblkozs
# a NickServ SET NOEXPIRE parancshoz "Engedly letiltva".
ACCESS_DENIED
	Hozzfrs megtagadva.
PERMISSION_DENIED
	Engedly megtagadva.

MORE_OBSCURE_PASSWORD
	Krlek prblkozz jra egy biztonsgosabb jelszval. A jelsznak legalbb 5 karakter hossznak kell lennie, s nem lehet valami knnyen kitallhat. (Pl: A Te valdi neved vagy a nicked.), s nem tartalmazhatja a szkz s tabultor karaktereket.
PASSWORD_TRUNCATED
	Megjegyzs:  A jelszd meg lett csonktva  %d karakterre.

NICK_NOT_REGISTERED
	A nicked nem regisztrlt.
NICK_NOT_REGISTERED_HELP
	A nicked nem regisztrlt.  rd be: /msg %s HELP, hogy informcit kapj a neved regisztrlsnak mdjrl.
NICK_TOO_LONG
	A nickneved nem lehet hosszabb %d karakternl.
NICK_INVALID
	%s egy nem rvnyes nicknv.
NICK_X_NOT_REGISTERED
	A megadott nick (%s) nem regisztrlt.
NICK_X_ALREADY_REGISTERED
	A megadott nick (%s) nick mr regisztrlt!
NICK_X_NOT_IN_USE
	A megadott nick (%s) nick jelenleg nincs hasznlatban.
NICK_X_FORBIDDEN
	A megadott nick (%s) nick nem hasznlhat.
NICK_X_SUSPENDED
	A megadott nick (%s) hasznlata fel van fggesztve, ezrt nem hasznlhat.
NICK_X_SUSPENDED_MEMOS
	A megadott nick (%s) hasznlata fel van fggesztve, ezrt nem fogadhat memokat..
NICK_IDENTIFY_REQUIRED
	Jelszavas hitelests szksges ehhez a parancshoz.
	Prbld jra, miutn bertad: /msg %s IDENTIFY jelsz.
NICK_PLEASE_AUTH
	A nickneved nincs hitelestve. Krlek hitelestsd a nickneved a hitelest kddal, amit a levlben kaptl: %s
NICK_X_NOT_ON_CHAN_X
	A megadott nick (%s) nincs hasznlatban ezen a csatornn: %s.

CHAN_INVALID
	%s nem rvnyes csatornanv.
CHAN_X_NOT_REGISTERED
	A megadott csatorna (%s) nem regisztrlt.
CHAN_X_NOT_IN_USE
	A megdott csatorna: (%s) jelenleg nincs hasznlatban.
CHAN_X_FORBIDDEN
	A megadott csatorna: (%s) nem hasznlhat, regisztrlhat.
CHAN_X_SUSPENDED
	A megadott csatorna (%s) hasznlata fel van fggesztve, nem hasznlhat.
CHAN_X_SUSPENDED_MEMOS
	A megadott csatornak (%s) hasznlata fel van fggesztve, nem fogadhat zeneteket.
CHAN_IDENTIFY_REQUIRED
	Jelszavas azonosts szksges ehhez a parancshoz.
	Prbld jra miutn beirtad: /msg %s IDENTIFY %s jelsz.

SERV_X_NOT_FOUND
	A megadott szerver (%s) nem tallhat.

EXPIRES_NONE
	Nem elvl
EXPIRES_SOON
	Elvl a legkzelebbi adatbzis frisstsnl
EXPIRES_IN
	Elvlsi id: %s

###########################################################################
#
# NickServ zenetek
#
###########################################################################

# Automatikus zenetek
NICK_IS_REGISTERED
	Ez a nick mr foglalt.  Krlek vlassz msikat.  (Ha ez a Te neved, rd be: /msg %s IDENTIFY jelsz.)
NICK_IS_SECURE
	Ez a nick regisztrlt s vdett.  Ha ez a te neved, rd be: /msg %s IDENTIFY jelsz.  Msklnben krlek, vlassz egy msik nicknevet!
NICK_MAY_NOT_BE_USED
	Ez a nicknv nem hasznlhat. Krlek vlassz msikat!
DISCONNECT_IN_1_MINUTE
	Ha nem vltoztatsz egy percen bell nevet, megszakad a kapcsolatod.
DISCONNECT_IN_20_SECONDS
	Ha nem vltoztatsz 20 msodpercen bell nevet, megszakad a kapcsolatod.
DISCONNECT_NOW
	Ez a nicknv regisztrlt; nem hasznlhatod. Krlek vlassz msik nicknevet, mieltt jracsatlakozol.
FORCENICKCHANGE_IN_1_MINUTE
	Ha nem vltoztatsz nevet egy percen bell, n fogom megvltoztatni.
FORCENICKCHANGE_IN_20_SECONDS
	Ha nem vltoztatsz nevet 20 msodpercen bell, n fogom megvltoztatni.
FORCENICKCHANGE_NOW
	Ez a nicknv regisztrlt; te nem hasznlhatod.  A te nickneved most meg lesz vltoztatva: %s.
NICK_EXPIRES_SOON
	Megjegyzs: A nickneved regisztrcija el fog vlni: %s.  Ha tovbbra is hasznlni szeretnd a nevedet, krlek azonositsd %s nicked a kvetkez parancs bersval: /msg %s IDENTIFY jelsz
NICK_EXPIRED
	Megjegyzs: A  nickneved regisztrcija elvlt. Krlek regisztrld jra, ha folytatni szeretnd a hasznlatt.

# REGISTER vlasz
NICK_REGISTER_SYNTAX
	REGISTER jelsz [E-mail]
NICK_REGISTER_REQ_EMAIL_SYNTAX
	REGISTER jelsz E-mail
NICK_REGISTRATION_DISABLED
	Sajnlom, a nicknv-regisztrci jelenleg nem mkdik.
NICK_REGISTRATION_FAILED
	Sajnlom, a regisztrci sikertelen.
NICK_REG_PLEASE_WAIT
	Krlek vrj %s mieltt jra hasznlnd a REGISTER parancsot.
NICK_REG_PLEASE_WAIT_FIRST
	Krlek vrj %s mieltt jra hasznlod a REGISTER parancsot.
NICK_CANNOT_BE_REGISTERED
	Ez a nicknv: %s nem regisztrlhat.
NICK_REGISTER_EMAIL_UNAUTHED
	Az E-mail cm amit megadtl mg nincs hitelestve.  Klek hasznld az AUTH parancsot, hogy hitelestsd a cmet mieltt j nickneveket regisztrlsz vele.
NICK_REGISTER_TOO_MANY_NICKS
	Neked mr tl sok neved van regisztrlva. (sszesen %d, a maximum %d). Nem regisztrlhatsz jat, amg nem dropolsz nhnyat a jelenlegi nickneveid kzl.
NICK_REGISTERED
	Ez a nicknv: %s szmodra lett regisztrlva.
NICK_PASSWORD_IS
	A jelszavad: %s -- emlkezz erre a nicked ksbbi hasznlatra!

# IDENTIFY vlasz
NICK_IDENTIFY_SYNTAX
	IDENTIFY jelsz
NICK_IDENTIFY_FAILED
	Sajnlom, az azonosts sikertelen.
NICK_IDENTIFY_EMAIL_MISSING
	Be kell lltanod egy E-mail cmet a nicknevedhez mieltt folytatnd a hasznlatt.  Krlek, llts be egyet most a kvetkez paranccsal: /msg %s SET EMAIL E-mail cmed
NICK_IDENTIFY_SUCCEEDED
	Jelszavad elfogadva. -- Azonosts sikeres.

# DROP vlasz
NICK_DROP_SYNTAX
	DROP jelsz
NICK_DROP_WARNING
	Megjegyzs: a DROP parancs trli a regisztrcijt minden nicknek ami linkelt!
NICK_DROP_DISABLED
	Sajnlom, a nicknevek regisztrcijnak trlse jelenleg sznetel.
NICK_DROP_FAILED
	Sajnlom, a nicknv regisztrcijnak trlse sikertelen.
NICK_DROPPED
	A nickneved mr nem regisztrlt.
NICK_DROPPED_LINKS
	A nickneved s minden hozz linkelt nicknv mr nem regisztrlt.

# DROPNICK vlasz
NICK_DROPNICK_SYNTAX
	DROPNICK nick
NICK_X_DROPPED
	Ez a nicknv: %s mr nem regisztrlt.
NICK_X_DROPPED_LINKS
	Ez a nicknv %s s az sszes hozz linkelt nicknv mr nem regisztrlt.

# DROPEMAIL vlasz
NICK_DROPEMAIL_SYNTAX
	DROPEMAIL plda
NICK_DROPEMAIL_PATTERN_TOO_LONG
	A megadott plda tl hossz (maximum %d karakter).
NICK_DROPEMAIL_NONE
	Egy nicknvnek E-mail cme a megadott pldban.
NICK_DROPEMAIL_COUNT
	%d nicknvnek van E-mail cme a megadott pldbl.
	Hogy dropold ezeket a nickneveket, rd be: /msg %s DROPEMAIL-CONFIRM %s
NICK_DROPEMAIL_CONFIRM_SYNTAX
	DROPEMAIL-CONFIRM cm
NICK_DROPEMAIL_CONFIRM_UNKNOWN
	A megadott plda nem felismerhet.  Krlek hasznld a DROPEMAIL parancsot jra ezzel a pldval mieltt hasznlod a DROPEMAIL-CONFIRM parancsot.
NICK_DROPEMAIL_CONFIRM_DROPPING
	%d nicknv trlse...
NICK_DROPEMAIL_CONFIRM_DROPPED
	Nicknevek dropolsa ksz.

# SET vlasz
NICK_SET_SYNTAX
	SET opci paramterek
NICK_SET_OPER_SYNTAX
	SET [nick] opci paramterek
NICK_SET_DISABLED
	Sajnlom, a nicknevek opciinak belltsa jelenleg sznetel.
NICK_SET_UNKNOWN_OPTION
	Ismeretlen SET opci: %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Ismeretlen SET opci %s, vagy a nicknv nem regisztrlt.

# SET PASSWORD vlasz
NICK_SET_PASSWORD_FAILED
	Sajnlom, nem vltoztathatod meg a jelszavad.
NICK_SET_PASSWORD_CHANGED
	Jelsz megvltoztatva.
NICK_SET_PASSWORD_CHANGED_TO
	Jelszavad megvltoztattam (%s).

# SET LANGUAGE vlasz
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE szm
NICK_SET_LANGUAGE_UNKNOWN
	Ismeretlen nyelvi azonost: %d.  rd be: /msg %s HELP SET LANGUAGE a nyelvek listjhoz.
NICK_SET_LANGUAGE_CHANGED
	A nyelv %s vltozott.

# SET URL vlasz
NICK_SET_URL_CHANGED
	Az URL, amely a megadott nickhez (%s) tartozik, megvltozott:  %s.

# SET EMAIL vlasz
NICK_SET_EMAIL_TOO_MANY_NICKS
	%s mr regisztrlt  %d nicknevet (a maximum %d).  Az E-mail cm megvltoztatsa sikertelen.
NICK_SET_EMAIL_CHANGED
	%s E-mail cme megvltozott a kvetkezre: %s.

# SET INFO vlasz
NICK_SET_INFO_CHANGED
	%s informcija megvltozott.

# SET KILL vlasz
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	A Kill protection opci most mr ON.
NICK_SET_KILL_QUICK
	A Kill protection opci most mr ON, egy kis idcsszssal killel.
NICK_SET_KILL_IMMED
	A Kill protection opci most mr ON, azonnal killel.
NICK_SET_KILL_IMMED_DISABLED
	Az IMMED opci nem elrhet ebben a hlozatban.
NICK_SET_KILL_OFF
	A Kill protection opci most mr OFF.

# SET SECURE vlasz
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	A Secure opci most mr ON.
NICK_SET_SECURE_OFF
	A Secure opci most mr OFF.

# SET PRIVATE vlasz
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	A Private opci most mr ON.
NICK_SET_PRIVATE_OFF
	A Private opci most mr OFF.

# SET HIDE krelem
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Az E-mail cmed most mr el lesz rejtve az %s INFO-i kztt.
NICK_SET_HIDE_EMAIL_OFF
	Az E-mail cmed most mr szerepelni fog az %s INFO-i  kztt.
NICK_SET_HIDE_MASK_ON
	Az utoljra  user@host maszkod nem fog szerepelni %s INFO-i kztt.
NICK_SET_HIDE_MASK_OFF
	Az utoljra  hasznlt user@host maszkod szerepelni fog %s INFO-i kztt.
NICK_SET_HIDE_QUIT_ON
	Az utoljra hasznlt kilp zeneted nem fog szerepelni %s INFO-i kztt.
NICK_SET_HIDE_QUIT_OFF
	Az utoljra hasznlt kilp zeneted szerepelni fog %s INFO-i kztt .

# SET TIMEZONE vlasz
NICK_SET_TIMEZONE_SYNTAX
	SET TIMEZONE {UTC-offset | time-zone | DEFAULT}
NICK_SET_TIMEZONE_TO
	Az idznd a kvetkezre lett belltva: UTC%c%d:%02d.
	A jelenlegi id ebben az idznban: %s.
NICK_SET_TIMEZONE_DEFAULT
	Az idznd vissza lett lltva a service idznjhoz.

# SET MAINNICK vlasz
NICK_SET_MAINNICK_NOT_FOUND
	A megadott nick (%s) nem linkelt a tieddel.
NICK_SET_MAINNICK_CHANGED
	A f nicked a kvetkezre vltozott %s.

# SET NOEXPIRE vlasz
NICK_SET_NOEXPIRE_SYNTAX
	SET [nicknv] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	A megadott nick (%s) nem fog elvlni.
NICK_SET_NOEXPIRE_OFF
	A megadott nick (%s) el fog elvlni.

# UNSET vlasz
NICK_UNSET_SYNTAX
	UNSET {URL | EMAIL | INFO}
NICK_UNSET_SYNTAX_REQ_EMAIL
	UNSET {URL | INFO}
NICK_UNSET_URL
	%s URL cme vissza lett lltva.
NICK_UNSET_EMAIL
	%s E-mail cme vissza lett lltva.
NICK_UNSET_INFO
	%s informcija vissza lett lltva..
NICK_UNSET_EMAIL_BAD
	Te nem trlheted az E-mail cmed.
NICK_UNSET_EMAIL_OTHER_BAD
	Ennek a nicknvnek az E-mail cmeit nem lehet trlni.

# ACCESS vlasz
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [mask]
NICK_ACCESS_ALREADY_PRESENT
	A megadott maszk (%s) mr szerepel a hozzfrsi listdon.
NICK_ACCESS_REACHED_LIMIT
	Sajnlom, sajnlom neked csak %d hozzfrsi helyed van ehhez a nickhez.
NICK_ACCESS_NO_NICKS
	Figyelmeztets: A nicknv hozzfrsi maszk nem tartalmazhat nickneveket. Krlek ellenrizd, s bizonyosodj meg rla, hogy a user@host maszkot helyesen adtad-e meg.
NICK_ACCESS_ADDED
	A megadott nick (%s) neve hozzadva a hozzfrsi listdhoz.
NICK_ACCESS_NOT_FOUND
	A megadott nick (%s) neve nem szerepel a hozzfrsi listdon.
NICK_ACCESS_DELETED
	A megadott nick (%s) neve trlve a hozzfrsi listdrl.
NICK_ACCESS_LIST_EMPTY
	A te hozzfrsi listd res.
NICK_ACCESS_LIST
	Hozzfrsi lista:
NICK_ACCESS_LIST_X_EMPTY
	%s hozzfrsi listja res.
NICK_ACCESS_LIST_X
	%s hozzfrsi listja:

# LINK vlasz
NICK_OLD_LINK_SYNTAX
	LINK nick jelsz
NICK_LINK_SYNTAX
	LINK nick
NICK_LINK_DISABLED
	Sajnlom, a nicknv linkels jelenleg sznetel.
NICK_LINK_FAILED
	Sajnlom, a neved linkelse sikertelen.
NICK_CANNOT_BE_LINKED
	A %s nicknv nem linkelhet.
NICK_OLD_LINK_SAME
	Nem tudsz linkeldni a sajt nickedhez!
NICK_LINK_SAME
	Nem tudsz linkeldni a jelenlegi nickedhez!
NICK_LINK_ALREADY_LINKED
	A kvetkez nick: %s mr linkelve van a nevedhez.
NICK_LINK_IN_USE
	Ez a nick: %s jelenleg is hasznlatban van.
NICK_LINK_TOO_MANY
	Neked nem lehet tbb, mint %d neved ssze linkelve.
NICK_SET_EMAIL_UNAUTHED
	Az E-mail cm amit megadtl mg nincs hitelestve.  Krlek hasznld az AUTH parancsot, hogy hitelestsd a cmet elszr.
NICK_LINK_TOO_MANY_NICKS
	Neked mr tl sok  %d nickneved van regisztrlva (maximum %d).  Linkels sikertelen.
NICK_OLD_LINK_TOO_MANY_CHANNELS
	A megadott nickhez (%s) nem linkelhetsz: tl sok csatorna van regisztrlva (kombinlt maximum %d).
NICK_OLD_LINKED
	A nicked linkeldtt ehhez a nickhez: %s.
NICK_LINKED
	A megadott nick: (%s) linkeldtt a Te nickedhez.

# UNLINK vlasz
NICK_OLD_UNLINK_SYNTAX
	UNLINK [nick jelsz]
NICK_UNLINK_SYNTAX
	UNLINK nick
NICK_UNLINK_OPER_SYNTAX
	UNLINK nick [FORCE]
NICK_UNLINK_DISABLED
	Sajnlom, az nicknv unlinkels opci jelenleg sznetel.
NICK_UNLINK_FAILED
	Sajnlom, a linkels trlse sikertelen.
NICK_UNLINK_SAME
	Nem tudod a jelenlegi nicked linkelst trlni!
NICK_OLD_UNLINK_NOT_LINKED
	A te nicked nincs linkelve msikhoz.
NICK_UNLINK_NOT_LINKED_YOURS
	A megadott nick (%s) nem linkeldtt a tiedhez.
NICK_UNLINK_NOT_LINKED
	A megadott nick (%s) nem linkelt.
NICK_OLD_UNLINKED
	A nicked linkeldse trldtt a kvetkez nicktl: %s.
NICK_UNLINKED
	%s tbb nincs linkvelve a Tieddel.
NICK_X_UNLINKED
	%s tbb nincs linkelve a megadott nickkel (%s).

# LISTLINKS vlasz
NICK_OLD_LISTLINKS_SYNTAX
	LISTLINKS nick
NICK_LISTLINKS_SYNTAX
	LISTLINKS
NICK_LISTLINKS_HEADER
	%s linkelt nickjeinek listja:
NICK_LISTLINKS_FOOTER
	%d linkelt nicknv.

# INFO vlasz
NICK_INFO_SYNTAX
	INFO nick [ALL]
NICK_INFO_REALNAME
	%s is %s
NICK_INFO_ADDRESS
	              Utoljra ltott cm: %s
NICK_INFO_ADDRESS_ONLINE
	   Jelenleg online errl a cmrl: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s jelenleg online.
NICK_INFO_TIME_REGGED
	               Regisztrls ideje: %s
NICK_INFO_LAST_SEEN
	              Utoljra ekkor volt: %s
NICK_INFO_LAST_QUIT
	             Utols kilp zenet: %s
NICK_INFO_URL
	              URL: %s
NICK_INFO_EMAIL
	                     E-mail cmek: %s
NICK_INFO_EMAIL_UNAUTHED
	                     E-mail cmek: %s (igazolatlan)
NICK_INFO_INFO
	                       Informaci: %s
NICK_INFO_OPTIONS
	                           Opcik: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Kill protection
NICK_INFO_OPT_SECURE
	Security
NICK_INFO_OPT_PRIVATE
	Private
NICK_INFO_OPT_NONE
	Nincs
NICK_INFO_NO_EXPIRE
	Ez a nicknv nem fog elvlni.
NICK_INFO_SUSPEND_DETAILS
	Felfggesztva %s ltal  %s (%s).
NICK_INFO_SUSPEND_REASON
	Indok: %s
NICK_INFO_SHOW_ALL
	Tovbbi informcirt, rd be: /msg %s INFO %s ALL

# LISTCHANS vlasz
NICK_LISTCHANS_SYNTAX
	LISTCHANS
NICK_LISTCHANS_NONE
	%s nem regisztrlt egy szobt se.
NICK_LISTCHANS_HEADER
	%s regisztrlt szobinak listja:
NICK_LISTCHANS_END
	A lista vge (%d csatorna regisztrlt).

# LIST/LISTEMAIL vlasz
NICK_LIST_SYNTAX
	%s sablon
NICK_LIST_OPER_SYNTAX
	%s sablon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
NICK_LIST_OPER_SYNTAX_AUTH
	%s sablon [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
NICK_LIST_HEADER
	A listn szereplk szma: %s:
NICK_LIST_RESULTS
	A lista vge; %d/%d eredmnyt tallt.
NICK_LISTEMAIL_NONE
	(nincs belltva)

# RECOVER vlasz
NICK_RECOVER_SYNTAX
	RECOVER nicknv [jelsz]
NICK_NO_RECOVER_SELF
	Nem tudod visszafoglalni a nicked!
NICK_RECOVERED
	A felhasznl kvetelsre a nicknv linkelse megsznt.  rd be: /msg %s RELEASE %s hogy visszakapd, mieltt az egy perc letelik.

# RELEASE vlasz
NICK_RELEASE_SYNTAX
	RELEASE nicknv [jelsz]
NICK_RELEASE_NOT_HELD
	Ez a nick: %s nem lett held-elve.
NICK_RELEASED
	Service tartja a te nicked felszabaditst.

# GHOST vlasz
NICK_GHOST_SYNTAX
	GHOST nicknv [jelsz]
NICK_NO_GHOST_SELF
	Nem ghost-olhatod ki sajt magad!
NICK_GHOST_KILLED
	Ghost, a nicked ki lett kill-elve.

# GETPASS vlasz
NICK_GETPASS_SYNTAX
	GETPASS nicknv
NICK_GETPASS_UNAVAILABLE
	GETPASS parancs hasznlhatatlan, mert az  encryption hasznlatban van.
NICK_GETPASS_PASSWORD_IS
	%s jelszava: %s.

# FORBID vlasz
NICK_FORBID_SYNTAX
	FORBID nicknv
NICK_FORBID_SUCCEEDED
	A megadott nick (%s) ezentl nem hasznlhat.
NICK_FORBID_FAILED
	A megadott nick (%s) hasznlatt nem tilthatod le!

# SUSPEND vlasz
NICK_SUSPEND_SYNTAX
	SUSPEND [+elvls] nicknv indok
NICK_SUSPEND_SUCCEEDED
	%s s az sszes hozz linkelt nick hasznlata fel lett fggesztve.
NICK_SUSPEND_ALREADY_SUSPENDED
	A megadott nick (%s) hasznlata fel lett fggesztve.

# UNSUSPEND vlasz
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND nicknv
NICK_UNSUSPEND_SUCCEEDED
	A megadott nick (%s) felfggesztse meg lett szntetve.
NICK_UNSUSPEND_NOT_SUSPENDED
	A megadott nick (%s) nincs felfggesztve.

################ autojoin module zenetek/vlaszok

# AJOIN vlasz
NICK_AJOIN_SYNTAX
	AJOIN {ADD | DEL | LIST} [channel]
NICK_AJOIN_ADD_SYNTAX
	AJOIN ADD channel
NICK_AJOIN_DEL_SYNTAX
	AJOIN DEL channel
NICK_AJOIN_ALREADY_PRESENT
	A megadott csatorna (%s) mostmr szerepel a te autojoin listdban.
NICK_AJOIN_LIST_FULL
	Sajnos, neked csak %d autojoin helyed van a nicknevedhez.
NICK_AJOIN_ADDED
	%s hozzadva az autojoin listdhoz.
NICK_AJOIN_NOT_FOUND
	%s nem szerepel az autojoin listdon.
NICK_AJOIN_DELETED
	%s trlve az autojoin listdrl.
NICK_AJOIN_LIST_EMPTY
	Az autojoin listd res.
NICK_AJOIN_LIST
	Autojoin lista:
NICK_AJOIN_LIST_X_EMPTY
	%s autojoin listja res.
NICK_AJOIN_LIST_X
	%s autojoin listja:

################ mail-auth module zenetek/vlaszok

# ltalnos cl zenetek
NICK_AUTH_SENT
	A nicked rvnyestsi kdjt elkldtem az E-mail cmedre (%s).
NICK_AUTH_FOR_REGISTER
	Amikor megkapod ezt az zentet, rd be: /msg %s AUTH kd (helyettestsd a kdot az rvnyesit kdoddal) hogy befejezd a nickneved regisztraciojt.
NICK_AUTH_FOR_SET_EMAIL
	Amikor megkapod ezt az zenetet, rd be: /msg %s AUTH kd (helyettestsd a kdot az rvnyest kdoddal) hogy befejezd az E-mail cmed megvltoztatst.
	krlek jegyezd meg ,hogy nem fogod tudni folytatni a nickneved hasznlatt amg nem teljested a vltoztatst.
NICK_AUTH_NOT_NEEDED
	Jelenleg nincs szksg lestsre.
NICK_AUTH_NO_AUTHCODE
	A megadott nickhez (%s) nincs lestsi kd.
NICK_AUTH_HAS_AUTHCODE
	A megadott nickhez (%s) mr tartozik egy rvnyest kd.
PASSWORD_WARNING_FOR_AUTH
	Figyelmeztets: Egy vagy tbb helytelen rvnyest kd bersa utn a megszakad a kapcsolatod.

# Levl szvege.  Az zenettrzsben az utols "%s" (user@host eltt)
# ki lesz cserlve a  NICK_AUTH_MAIL_TEXT_* zenetek egyikvel.
NICK_AUTH_MAIL_SUBJECT
	Az rvnyest kd ehhez a nickhez: %s
NICK_AUTH_MAIL_BODY
	Az rvnyest kd a te nickedhez: (%s) a kvetkez %09d
	Krlek hitelestsd a nicked %s a kvetkez paranccsal:
	    /msg %s AUTH %09d
	
	Ezt az zenetet a kvetkez kldte: %s a kvetkez okbl: %s
	%s@%s.
NICK_AUTH_MAIL_TEXT_REG
	Regisztrlva a kvetkez ltal:
NICK_AUTH_MAIL_TEXT_EMAIL
	Az E-mail cm meg vltoztatva a kvetkez ltal:
NICK_AUTH_MAIL_TEXT_SENDAUTH
	A SENDAUTH parancs kiadva a kvetkez ltal:
NICK_AUTH_MAIL_BODY_SETAUTH
	A hitelest kd nicknevedhez: (%s) a kvetkez: %09d
	Krlek hasznld a kvetkez kdot %s ezzel a paranccsal:
	    /msg %s AUTH %09d

# AUTH vlasz
NICK_AUTH_SYNTAX
	AUTH kd
NICK_AUTH_DISABLED
	Sajnlom, a nicknv lests jelenleg sznetel.
NICK_AUTH_FAILED
	Az megadott lest kd helytelen.
NICK_AUTH_SUCCEEDED_REGISTER
	lests sikeresen megtrtnt; a nickneved regisztrcija most mr ksz.
NICK_AUTH_SUCCEEDED_SET_EMAIL
	lests sikeresen megtrtnt; az E-mail cmvltoztats most mr ksz.
NICK_AUTH_SUCCEEDED_SETAUTH
	lests sikeresen megtrtnt; te most mr folytathatod a nickneved hasznlatt.

# SENDAUTH vlasz
NICK_SENDAUTH_SYNTAX
	SENDAUTH
NICK_SENDAUTH_TOO_SOON
	Krlek vrj %s leteltig, mieltt jra hasznlod a SENDAUTH parancsot.
NICK_SENDAUTH_FAILED
	Sajnlom, nem tudom elkldeni a hitelest kdot.

# SETAUTH vlasz
NICK_SETAUTH_SYNTAX
	SETAUTH nick
NICK_SETAUTH_NO_EMAIL
	A megadott nickhez (%s) nincs E-mail cm belltva.
NICK_SETAUTH_AUTHCODE_SET
	Az j rvnyestsi kd (%09d) elkldtem a kvetkez nicknek: %s.
NICK_SETAUTH_SEND_FAILED
	Figyelmeztets: sikertelen zenetklds a kvetkez nickhez: %s.
NICK_SETAUTH_SEND_TEMPFAIL
	Figyelmeztets: sikertelen zenetklds a kvetkez nickhez: %s (hibs forrs).
NICK_SETAUTH_USER_NOTICE
	A nickneved regisztrcijt lestened kell,ha tovbbra is hasznlni szeretnd. A hitelestsi kd el lett kldve a kvetkez E-mail cmre: %s
	rd be: /msg %s HELP AUTH tovbbi informacikrt.

# GETAUTH vlasz
NICK_GETAUTH_SYNTAX
	GETAUTH nicknv
NICK_GETAUTH_AUTHCODE_IS
	%s hitelestsi kdja: %09d

# CLEARAUTH vlasz
NICK_CLEARAUTH_SYNTAX
	CLEARAUTH nicknv
NICK_CLEARAUTH_CLEARED
	%s hitelestsi kdjt trltem.

################ sendpass modul zenetei/vlaszai

# Levl szvege
NICK_SENDPASS_MAIL_SUBJECT
	Jelsz a kvetkez nickhez: %s
NICK_SENDPASS_MAIL_BODY
	A nevedhez tartoz jelsz a kvetkez: %s
	
	Ezt a E-mailt a %s (%s@%s) kldte a SENDPASS parancs
	krsnek eredmnyekppen.

# SENDPASS vlasz
NICK_SENDPASS_SYNTAX
	SENDPASS nicknv
NICK_SENDPASS_FAILED
	Sajnlom, a jelsz klds sikertelen.
NICK_SENDPASS_NO_EMAIL
	%s nem lltott be E-mail cmet.
NICK_SENDPASS_NOT_AUTHED
	%s E-mail cme mg nem lett lestve.
# parameter is "NNN days/hours/minutes"
NICK_SENDPASS_TOO_SOON
	Krlek vrj %s mieltt jra hasznlod a SENDPASS parancsot.
NICK_SENDPASS_SENT
	%s jelszavt elkldtem a nickhez regisztrlt E-mail cmre.

###########################################################################
#
# ChanServ zenetek
#
###########################################################################

# Access level meghatrozsok

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Automatikus opertor (+o) sttusz
CHAN_LEVEL_AUTOVOICE
	Automatikus voice (+v) sttusz (hangads)
CHAN_LEVEL_INVITE
	Engedlyezi az INVITE parancsok hasznlatt
CHAN_LEVEL_AKICK
	Engedlyezi az AKICK parancsok hasznlatt
CHAN_LEVEL_SET
	Engedlyezi a SET parancsok hasznlatt (kivve a FOUNDER/PASSWORD parancsokat)
CHAN_LEVEL_CLEAR
	Engedlyezi a CLEAR parancsok hasznlatt
CHAN_LEVEL_UNBAN
	Engedlyezi az UNBAN parancs hasznlatt
CHAN_LEVEL_OPDEOP
	Engedlyezi az OP/DEOP parancs hasznlatt
CHAN_LEVEL_ACCESS_LIST
	Engedlyezi az access lista megtekintst
CHAN_LEVEL_ACCESS_CHANGE
	Engedlyezi az access lista mdostst
CHAN_LEVEL_MEMO
	Engedlyezi a list/read memo parancsokat szobban
CHAN_LEVEL_VOICE
	Engedlyezi a VOICE/DEVOICE parancsok hasznlatt
CHAN_LEVEL_AUTOHALFOP
	Automatikus halfop (+h) sttus (flop)
CHAN_LEVEL_HALFOP
	Engedlyezi a HALFOP/DEHALFOP parancsok hasznlatt
CHAN_LEVEL_AUTOPROTECT
	Automatikus  protect (+a) sttus (vdett felhasznl [sop])
CHAN_LEVEL_PROTECT
	Engedlyezi a PROTECT/DEPROTECT parancsok hasznlatt
CHAN_LEVEL_KICK
	Engedlyezi a KICK parancs hasznlatt
CHAN_LEVEL_STATUS
	Engedlyezi a STATUS parancs hasznlatt
CHAN_LEVEL_TOPIC
	Engedlyezi a TOPIC parancs hasznlatt

# Automatikus vlaszok
CHAN_IS_REGISTERED
	Ez a csatorna regisztrlva van %s-vel.
CHAN_MAY_NOT_BE_USED
	Ez a csatorna nem hasznlhat.
CHAN_NOT_ALLOWED_TO_JOIN
	Nem tartzkodhatsz a csatornn.

# Multi-szndkos zenetek/vlaszok
CHAN_MUST_IDENTIFY_NICK
	Krlek azonosts %s elszr, hasznld a kvetkez parancsot:
	/msg %s IDENTIFY jelsz
CHAN_BOUNCY_MODES
	Sajnlom, a %s parancs jelenleg elrhetetlen.

# REGISTER vlaszok
CHAN_REGISTER_SYNTAX
	REGISTER csatorna jelsz meghatrozs
CHAN_REGISTER_DISABLED
	Sajnlom, a csatonra regisztraci jelenleg sznetel.
CHAN_REGISTER_SHORT_CHANNEL
	A # csatorna nem regisztrlhat.
CHAN_REGISTER_NOT_LOCAL
	Local csatornk nem regisztrlhatak.
CHAN_REGISTER_INVALID_NAME
	Csak olyan szobkat regisztrlhatsz amelyek neve a kvetkezkppen kezddik: #.
CHAN_MUST_REGISTER_NICK
	Elszr regisztrlnod kell a neved.  rd be: /msg %s HELP a nvregisztrcival kapcsolatos informcikrt.
CHAN_MAY_NOT_BE_REGISTERED
	A megadott csatorna (%s) nem regisztrlhat.
CHAN_ALREADY_REGISTERED
	A megadott csatorna (%s) mr regisztrlt!
CHAN_MUST_BE_CHANOP
	A csatornn opertornak kell lenned, hogy regisztrlhasd azt.
CHAN_REACHED_CHANNEL_LIMIT
	Sajnlom, mr elrted a fels korltot (%d) csatornk szmt tekintve.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Sajnlom, mr tllpted a fels korltot (%d) a csatornn.
CHAN_REGISTRATION_FAILED
	Sajnlom, regisztrci sikertelen.
CHAN_REGISTERED
	Sikeresen regisztrltam a megadott csatornt (%s) a Te nickedre (%s).
CHAN_PASSWORD_IS
	A csatorna jelszava: %s -- Emlkezz erre a ksbbi hasznlathoz.

# IDENTIFY vlaszok
CHAN_IDENTIFY_SYNTAX
	IDENTIFY csatorna jelsz
CHAN_IDENTIFY_FAILED
	Sajnlom, azonosts sikertelen.
CHAN_IDENTIFY_SUCCEEDED
	Jelszavad elfogadva -- founder-szint a hozzfrsed van a megadott csatornhoz (%s).

# DROP vlaszok
CHAN_DROP_SYNTAX
	DROP csatorna
CHAN_DROP_DISABLED
	Sajnlom, a csatornk regisztrcijnak trlse jelenleg sznetel.
CHAN_DROPPED
	A megadott csatorna (%s) regisztrcija trlse sikerlt.

# SET vlaszok
CHAN_SET_SYNTAX
	SET csatorna opci paramterek
CHAN_SET_DISABLED
	Sajnlom, a csatornk opciinak bellitsa jelenleg sznetel.
CHAN_SET_UNKNOWN_OPTION
	Ismeretlen SET opci %s.

# SET FOUNDER vlaszok
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s rszre tl sok csatorna van regisztrlva.
CHAN_FOUNDER_CHANGED
	A megadott csatorna (%s) j foundere: %s.

# SET SUCCESSOR vlaszok
CHAN_SUCCESSOR_CHANGED
	A megadott csatorna (%s) j successora: %s.
CHAN_SUCCESSOR_IS_FOUNDER
	A csatorna foundere s successora nem lehet azonos szemly.

# SET PASSWORD vlaszok
CHAN_SET_PASSWORD_FAILED
	Sajnlom, a jelsz belltsa sikertelen.
CHAN_PASSWORD_CHANGED
	Az j jelsz: %s.
CHAN_PASSWORD_CHANGED_TO
	%s j jelszava: %s.

# SET DESC vlasz
CHAN_DESC_CHANGED
	A megadott csatorna (%s) j lersa: %s.

# SET URL vlasz
CHAN_URL_CHANGED
	A megadott csatorna (%s) j URL cme: %s.

# SET EMAIL vlasz
CHAN_EMAIL_CHANGED
	A megadott csatorna (%s) j E-mail cme: %s.

# SET ENTRYMSG vlasz
CHAN_ENTRY_MSG_CHANGED
	%s csatorna belp zenete megvltozott.

# SET MLOCK vlaszok
CHAN_SET_MLOCK_NEED_PLUS_MINUS
	A lockolni kvnt mdokat tartalmaz lista  + (plus) vagy - (minus) jelekkel kell, hogy kezddjn.
CHAN_SET_MLOCK_NEED_PARAM
	A megadott flaghez (+%c) paramter szksges.
CHAN_SET_MLOCK_NEED_POSITIVE
	A paramter az MLOCK +%c esetben pozitv szm kell, hogy legyen.
CHAN_SET_MLOCK_MODE_REG_BAD
	A megadott flag (+%c) mindig be lesz lltva a regisztrlt csatornn, s nem hasznlhat az MLOCK paranccsal.
CHAN_SET_MLOCK_LINK_BAD
	A megadott flaghez (+%c) csatornanv szksges.
CHAN_SET_MLOCK_LINK_SAME
	Az MLOCK +%c paramternl egy msik szobt kell megadni.
CHAN_SET_MLOCK_LINK_NO_LIMIT
	A megadott flag (+%c) j belltshoz +l flag is szksges.
CHAN_SET_MLOCK_BAD_PARAM
	A megdott flag (+%c) rvnytelen.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	%c: ismeretlen karakter, elutasitva.
CHAN_SET_MLOCK_CANNOT_LOCK
	%c md nem lockolhat.
CHAN_MLOCK_CHANGED
	A megadott csatornn (%s) az j Mode lock: %s.
CHAN_MLOCK_REMOVED
	A megadott csatornn (%s) mr nincs Mode lock.

# SET HIDE vlaszok
CHAN_SET_HIDE_SYNTAX
	SET csatorna HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
CHAN_SET_HIDE_EMAIL_ON
	A megadott csatorna (%s) E-mail cme nem fog szerepelni a %s INFO-i kzt .
CHAN_SET_HIDE_EMAIL_OFF
	A megadott csatorna (%s) E-mail cme szerepelni fog a %s INFO-i kzt.
CHAN_SET_HIDE_TOPIC_ON
	A megadott csatorna (%s) tmja nem fog szerepelni a %s INFO-i kzt.
CHAN_SET_HIDE_TOPIC_OFF
	A megadott csatorna (%s) tmja szerepelni fog a %s INFO-i kzt.
CHAN_SET_HIDE_MLOCK_ON
	A megadott csatorna (%s) mode lockja nem fog szerepelni a %s INFO-i kzt.
CHAN_SET_HIDE_MLOCK_OFF
	A megadott csatorna (%s) mode lockja szerepelni fog a %s INFO-i kzt.

# SET KEEPTOPIC vlaszok
CHAN_SET_KEEPTOPIC_SYNTAX
	SET csatorna KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Tmamegrzs BEKAPCSOLVA.
CHAN_SET_KEEPTOPIC_OFF
	Tmamegrzs KIKAPCSOLVA.

# SET TOPICLOCK vlaszok
CHAN_SET_TOPICLOCK_SYNTAX
	SET csatorna TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Tmalezrs BEKAPCSOLVA.
CHAN_SET_TOPICLOCK_OFF
	Tmalezrs KIKAPCSOLVA.

# SET PRIVATE vlaszok
CHAN_SET_PRIVATE_SYNTAX
	SET csatorna PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Private opci BEKAPCSOLVA.
CHAN_SET_PRIVATE_OFF
	Private opci BEKAPCSOLVA.

# SET SECUREOPS vlaszok
CHAN_SET_SECUREOPS_SYNTAX
	SET csatorna SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Secure ops opci BEKAPCSOLVA.
CHAN_SET_SECUREOPS_OFF
	Secure ops opci KIKAPCSOLVA.

# SET LEAVEOPS vlaszok
CHAN_SET_LEAVEOPS_SYNTAX
	SET csatorna LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	Leave ops opci BEKAPCSOLVA.
CHAN_SET_LEAVEOPS_OFF
	Leave ops opci KIKAPCSOLVA.

# SET RESTRICTED vlaszok
CHAN_SET_RESTRICTED_SYNTAX
	SET csatorna RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Restricted access opci BEKAPCSOLVA.
CHAN_SET_RESTRICTED_OFF
	Restricted access opci KIKAPCSOLVA.

# SET SECURE vlaszok
CHAN_SET_SECURE_SYNTAX
	SET csatorna SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Secure opci BEKAPCSOLVA.
CHAN_SET_SECURE_OFF
	Secure opci KIKAPCSOLVA.

# SET OPNOTICE vlaszok
CHAN_SET_OPNOTICE_SYNTAX
	SET csatorna OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Op-notice opci BEKAPCSOLVA.
CHAN_SET_OPNOTICE_OFF
	Op-notice opci KIKAPCSOLVA.

# SET ENFORCE vlaszok
CHAN_SET_ENFORCE_SYNTAX
	SET csatornal ENFORCE {ON | OFF}
CHAN_SET_ENFORCE_ON
	Enforce opci BEKAPCSOLVA.
CHAN_SET_ENFORCE_OFF
	Enforce opci KIKAPCSOLVA.

# SET NOEXPIRE vlaszok
CHAN_SET_NOEXPIRE_SYNTAX
	SET csatorna NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	A megadott csatorna (%s) nem fog elvlni.
CHAN_SET_NOEXPIRE_OFF
	A megadott csatorna (%s) el fog vlni.

# UNSET vlaszok
CHAN_UNSET_SYNTAX
	UNSET csatorna {SUCCESSOR | URL | EMAIL | ENTRYMSG}
CHAN_SUCCESSOR_UNSET
	A megadott csatorna (%s) successora trlve.
CHAN_URL_UNSET
	A megadott csatorna (%s) URL cme trlve.
CHAN_EMAIL_UNSET
	A megadott csatorna (%s) E-mail cme trlve.
CHAN_ENTRY_MSG_UNSET
	A megadott csatorna (%s) belp zenete trlve.

# ACCESS zenetek
CHAN_ACCESS_SYNTAX
	ACCESS csatorna {ADD | DEL | LIST | COUNT} [nick [level] | entry-list]
CHAN_ACCESS_DISABLED
	Sajnlom, a csatorna hozzfrsi listjnak mdostsa tmenetileg sznetel.
CHAN_ACCESS_LEVEL_NONZERO
	A hozzfrsi szint nem lehet nulla.
CHAN_ACCESS_LEVEL_RANGE
	A hozzfrsi szintnek %d s %d kztt kell lennie.
CHAN_ACCESS_NICKS_ONLY
	A hozzfrsi szintjeinek listja csak regisztrlt nickneveket tartalmazhat.
CHAN_ACCESS_REACHED_LIMIT
	Sajnlom, neked csak %d szm helyed van a csatorna hozzfrsi listjn.
CHAN_ACCESS_LEVEL_UNCHANGED
	%s hozzfrsi szintje a megadott szobn (%s) visszallt errl a szintrl: %d.
CHAN_ACCESS_LEVEL_CHANGED
	%s hozzfrsi szintje  a kvetkez szobhoz: %s megvltozott: %d.
CHAN_ACCESS_ADDED
	%s hozzadva a %s csatorna hozzfrsi listjhoz a kvetkez szinttel: %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	A megadott bejegyzs (#%d) nem tallhat %s hozzfrsi listjn.
CHAN_ACCESS_NOT_FOUND
	%s nem szerepel a megadott csatorna (%s) hozzfrsi listjn.
CHAN_ACCESS_NO_MATCH
	Nincs tallat a megadott csatorna (%s) hozzfrsi listjn.
CHAN_ACCESS_DELETED
	%s trlve a megadott csatorna (%s) hozzfrsi listjrl.
CHAN_ACCESS_DELETED_ONE
	1 bejegyzs trlve a megadott csatorna (%s) hozzfrsi listjrl.
CHAN_ACCESS_DELETED_SEVERAL
	%d bejegyzs trlve a megadott csatorna (%s) hozzfrsi listjrl.
CHAN_ACCESS_LIST_EMPTY
	%s hozzfrsi listja res.
CHAN_ACCESS_LIST_HEADER
	%s hozzfrsi listja:
	  Sorszm   Szint  Nick
CHAN_ACCESS_LIST_FORMAT
	 %4d  %4d  %s
CHAN_ACCESS_COUNT
	%s hozzfrsi listjn %d bejegyzs van.

# XOP (AOP/SOP/VOP) vlaszok
CHAN_SOP_SYNTAX
	SOP csatorna {ADD | DEL | LIST | COUNT} [nick | entry-list]
CHAN_AOP_SYNTAX
	AOP csatorna {ADD | DEL | LIST | COUNT} [nick | entry-list]
CHAN_HOP_SYNTAX
	HOP csatorna {ADD | DEL | LIST | COUNT} [nick | entry-list]
CHAN_VOP_SYNTAX
	VOP csatorna {ADD | DEL | LIST | COUNT} [nick | entry-list]
CHAN_XOP_ADDED
	%s hozzadva %s %s listhoz.
CHAN_XOP_LEVEL_CHANGED
	%s thelyezve a %s %s listhoz.
CHAN_XOP_LEVEL_UNCHANGED
	%s mr szerepel a %s %s listn.
CHAN_XOP_NICKS_ONLY
	SOP, AOP, s VOP listk csak regisztrlt  nickneveket tartalmazhatnak.
CHAN_XOP_NICKS_ONLY_HOP
	SOP, AOP, HOP, s VOP listk csak regisztrlt nicknevelet tartalmazhatnak.
CHAN_XOP_REACHED_LIMIT
	Sajnlom, az SOP, AOP s VOP listn lv bejegyzsek szma nem lehet tbb, mint %d. Hatrrtk elrve.
CHAN_XOP_REACHED_LIMIT_HOP
	Sajnlom, az SOP, AOP, HOP s VOP listn lv bejegyzsek szma nem lehet tbb, mint %d. Hatrrtk elrve.
CHAN_XOP_NOT_FOUND
	%s nem tallhat a %s %s listn.
CHAN_XOP_NO_SUCH_ENTRY
	Nincs tallat (#%d) a %s %s listn.
CHAN_XOP_NO_MATCH
	Nincs tallat a %s %s listn.
CHAN_XOP_DELETED
	%s trlve %s %s listrl.
CHAN_XOP_DELETED_ONE
	Trlve: 1 hely a %s %s listrl.
CHAN_XOP_DELETED_SEVERAL
	Trlve %d helyek a %s %s listrl.
CHAN_XOP_LIST_EMPTY
	%s %s lista res.
CHAN_XOP_LIST_HEADER
	%s lista a csatornhoz: %s:
	  Sorszm   Nick
CHAN_XOP_LIST_FORMAT
	 %4d   %s
CHAN_XOP_COUNT
	A %s %s listn %d nv tallhat.

# AKICK vlaszok
CHAN_AKICK_SYNTAX
	AKICK csatorna {ADD | DEL | LIST | VIEW | ENFORCE | COUNT} [maszk | lista]
CHAN_AKICK_DISABLED
	Sajnlom, a csatorna autokick listjnak mdostsa tmenetileg sznetel.
CHAN_AKICK_ALREADY_EXISTS
	%s mr szerepel a megadott csatorna (%s) autokick listjn.
CHAN_AKICK_REACHED_LIMIT
	Sajnlom, %d autokick maszknl nem lehet tbb a listn. Elrted a fels korltot.
CHAN_AKICK_ADDED
	%s hozzadva a megadott csatorna (%s) autokick listjhoz.
CHAN_AKICK_NO_SUCH_ENTRY
	A megadott bejegyzs (#%d) nem szerepel a csatorna (%s) autokick listjn.
CHAN_AKICK_NOT_FOUND
	%s nem szerepel a megadott csatorna (%s) autokick listjn.
CHAN_AKICK_NO_MATCH
	Nincs tallat a megadott csatorna (%s) autokick listjn.
CHAN_AKICK_DELETED
	%s trlve a megadott csatorna (%s) autokick listjrl.
CHAN_AKICK_DELETED_ONE
	1 bejegyzs trlve a megadott csatorna (%s) autokick listjrl.
CHAN_AKICK_DELETED_SEVERAL
	%d bejegyzs trlve a megadott csatorna (%s) autokick listjrl.
CHAN_AKICK_LIST_EMPTY
	%s autokick listja res.
CHAN_AKICK_LIST_HEADER
	%s autokick listja:
# index, mask, feltev szemly , felraks ideje, utoljra-hasznlva, indok
CHAN_AKICK_VIEW_FORMAT
	  %3d %s (%s ltal, ekkor: %s; utoljra hasznlva %s)
	         %s
# index, mask, feltev szemly, felraks ideje, indok
CHAN_AKICK_VIEW_UNUSED_FORMAT
	  %3d %s (%s ltal, ekkor: %s; sose hasznlt)
	         %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE a(z) %s csatornn teljestve; %d user eltvoltva.
CHAN_AKICK_COUNT
	%s AKIK listjn sszesen %d szemly szerepel.

# LEVELS vlaszok
CHAN_LEVELS_SYNTAX
	LEVELS csatorna {SET | DIS[ABLE] | LIST | RESET} [opci [szint]]
CHAN_LEVELS_RANGE
	A szintnek kizrlag %d s %d kztt kell lennie.
CHAN_LEVELS_CHANGED
	%s szintjnek j rtke a megadott csatornn (%s): %d.
CHAN_LEVELS_UNKNOWN
	A megadott bellts (%s) ismeretlen.  Az rvnyes belltsok listjt a /msg %s HELP LEVELS DESC parancs bersval tallod meg.
CHAN_LEVELS_DISABLED
	%s letiltva a megadott csatornn (%s).
CHAN_LEVELS_LIST_HEADER
	%s hozzfrsi szintjeinek belltsai:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (letiltva)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (csak foundernek)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %4d
CHAN_LEVELS_RESET
	%s hozzfrsi szintjeit visszalltottam az alapbelltsokra.

# INFO vlaszok
CHAN_INFO_SYNTAX
	INFO csatorna [ALL]
CHAN_INFO_HEADER
	%s informcii:
CHAN_INFO_FOUNDER
	         Tulajdonos: %s
CHAN_INFO_SUCCESSOR
	            Jogutd: %s
CHAN_INFO_DESCRIPTION
	             Lers: %s
CHAN_INFO_ENTRYMSG
	    Belpsi zenet: %s
CHAN_INFO_TIME_REGGED
	 Regisztrls ideje: %s
CHAN_INFO_LAST_USED
	 Utoljra hasznlva: %s
CHAN_INFO_LAST_TOPIC
	       Utols topic: %s
CHAN_INFO_TOPIC_SET_BY
	A tmt belltotta: %s
CHAN_INFO_URL
	                URL: %s
CHAN_INFO_EMAIL
	         E-mail cm: %s
CHAN_INFO_OPTIONS
	             Opcik: %s
CHAN_INFO_OPT_PRIVATE
	Privt
CHAN_INFO_OPT_KEEPTOPIC
	Tmamegrzs
CHAN_INFO_OPT_TOPICLOCK
	Tmalezrs
CHAN_INFO_OPT_SECUREOPS
	Opok vdelme
CHAN_INFO_OPT_LEAVEOPS
	Opok meghagysa
CHAN_INFO_OPT_RESTRICTED
	Korltozott hozzfrs
CHAN_INFO_OPT_SECURE
	Secure
CHAN_INFO_OPT_OPNOTICE
	Opok rtestse
CHAN_INFO_OPT_ENFORCE
	Op jog erltetse
CHAN_INFO_OPT_NONE
	Nincs
CHAN_INFO_MODE_LOCK
	      Md lock: %s
CHAN_INFO_NO_EXPIRE
	Ez a csatorna nem fog lejrni.
CHAN_INFO_SUSPEND_DETAILS
	felfggesztette: %s; dtum: %s (%s).
CHAN_INFO_SUSPEND_REASON
	Indok: %s
CHAN_INFO_SHOW_ALL
	Tovbbi informcirt rd be: /msg %s INFO %s ALL

# LIST vlaszok
CHAN_LIST_SYNTAX
	LIST minta
CHAN_LIST_OPER_SYNTAX
	LIST minta [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
CHAN_LIST_HEADER
	%s listjnak bejegyzsei:
CHAN_LIST_END
	A lista vge; %d/%d tallat.

# INVITE vlaszok
CHAN_INVITE_SYNTAX
	INVITE csatora
CHAN_INVITE_OK
	%s meghvva a megadott a csatornra (%s).

# OP/DEOP/VOICE/DEVOICE vlaszok
CHAN_OPVOICE_SYNTAX
	%s csatorna [nick]
CHAN_OP_SUCCEEDED
	%s opertor lett a megadott csatornn (%s).
CHAN_OP_ALREADY
	%s mr rendelkezik opertor joggal a megadott csatornn (%s).
CHAN_OP_FAILED
	%s nem kaphat opertor jogot a megadott csatornn (%s).
CHAN_DEOP_SUCCEEDED
	%s tbb nem opertor a megadott csatornn (%s).
CHAN_DEOP_ALREADY
	%s mg nem rendelkezik opertor joggal a megadott csatornn (%s).
CHAN_DEOP_FAILED
	%s opertor joga nem vehet el a megadott csatornn (%s).
CHAN_VOICE_SUCCEEDED
	%s beszdjogot kapott a megadott csatornn (%s).
CHAN_VOICE_ALREADY
	%s mr rendelkezik beszdjoggal a megadott csatornn (%s).
CHAN_VOICE_FAILED
	%s kaphat beszdjogot a megadott csatornn (%s).
CHAN_DEVOICE_SUCCEEDED
	%s tbb nem rendelkezik beszdjoggal a megadott csatornn (%s).
CHAN_DEVOICE_ALREADY
	%s mg nem rendelkezik beszdjoggal a megadott csatornn (%s).
CHAN_DEVOICE_FAILED
	%s beszdjogt nem veheted el a megadott csatornn (%s).
CHAN_HALFOP_SUCCEEDED
	%s flopertor lett a megadott csatornn (%s).
CHAN_HALFOP_ALREADY
	%s mr rendelkezik flopertor joggal a megadott csatornn (%s).
CHAN_HALFOP_FAILED
	%s nem lehet flopertor a megadott csatornn (%s).
CHAN_DEHALFOP_SUCCEEDED
	%s tbb nem flopertor a megadott csatornn (%s).
CHAN_DEHALFOP_ALREADY
	%s mg nem flopertor a megadott csatornn (%s).
CHAN_DEHALFOP_FAILED
	%s flopertori jogt nem veheted el a megadott csatornn (%s).
CHAN_PROTECT_SUCCEEDED
	%s vdelmi jogot kapott a megadott csatornn (%s).
CHAN_PROTECT_ALREADY
	%s mr rendelkezik vdelmi joggal a megadott csatornn (%s).
CHAN_PROTECT_FAILED
	%s nem kaphat vdelmi jogot a megadott csatornn (%s).
CHAN_DEPROTECT_SUCCEEDED
	%s tbb nem rendelkezik vdelmi joggal a megadott csatornn (%s).
CHAN_DEPROTECT_ALREADY
	%s mg nem rendelkezik vdelmi joggal a megadott csatornn (%s).
CHAN_DEPROTECT_FAILED
	%s vdelmi jogt nem veheted el a megadott csatornn (%s).

# UNBAN vlaszok
CHAN_UNBAN_SYNTAX
	UNBAN csatorna
CHAN_UNBANNED
	Mr nem vagy kitiltva a megadott csatornn (%s).

# KICK vlaszok
CHAN_KICK_SYNTAX
	KICK csatorna nick [indok]
CHAN_KICK_PROTECTED
	%s nem rghat ki a megadott csatornrl (%s).
CHAN_KICKED
	%s ki lett rgva a megadott csatornrl (%s).

# TOPIC vlaszok
CHAN_TOPIC_SYNTAX
	TOPIC csatorna topic

# CLEAR vlaszok
CHAN_CLEAR_SYNTAX
	CLEAR csatorna mit
CHAN_CLEARED_BANS
	A megadott csatornn (%s) minden kitilts fel lett oldva.
CHAN_CLEARED_EXCEPTIONS
	A megadott csatornn (%s) minden kivtel el lett tvoltva.
CHAN_CLEARED_INVITES
	A megadott csatornn (%s) minden invite maszk el lett tvoltva.
CHAN_CLEARED_MODES
	A megadott csatornn (%s) minden md el lett tvoltva.
CHAN_CLEARED_OPS
	A megadott csatornn (%s) minden opertori jog el lett vve.
CHAN_CLEARED_HALFOPS
	A megadott csatornn (%s) minden flopertori jog el lett vve.
CHAN_CLEARED_VOICES
	A megadott csatornn (%s) minden hangads el lett vve.
CHAN_CLEARED_USERS
	A megadott csatornn (%s) minden felhasznl el lett tvoltva.

# GETPASS vlaszok
CHAN_GETPASS_SYNTAX
	GETPASS csatorna
CHAN_GETPASS_UNAVAILABLE
	Nem hasznlhatod a GETPASS parancsot, mert a titkosts be van kapcsolva.
CHAN_GETPASS_PASSWORD_IS
	A megadott csatorna (%s) jelszava: %s.

# FORBID vlaszok
CHAN_FORBID_SYNTAX
	FORBID csatorna
CHAN_FORBID_SHORT_CHANNEL
	A # csatornanv nem tilthat.
CHAN_FORBID_SUCCEEDED
	A megadott csatorna (%s) mostantl nem hasznlhat.
CHAN_FORBID_FAILED
	A megadott csatorna (%s) nem tilthat le!

# SUSPEND vlaszok
CHAN_SUSPEND_SYNTAX
	SUSPEND [+elvls] csatorna indok
CHAN_SUSPEND_SUCCEEDED
	A megadott csatorna (%s) hasznlata fel lett fggesztve.
CHAN_SUSPEND_ALREADY_SUSPENDED
	A megadott csatorna (%s) hasznlata mr fel van fggesztve.

# UNSUSPEND vlaszok
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND csatorna
CHAN_UNSUSPEND_SUCCEEDED
	A megadott csatorna (%s) jra hasznlhat.
CHAN_UNSUSPEND_NOT_SUSPENDED
	A megadott csatorna (%s) hasznlata nincs felfggesztve.

################ sendpass module zenetek/vlaszok

# Levl szveg
CHAN_SENDPASS_MAIL_SUBJECT
	Jelsz a szobhoz: %s
CHAN_SENDPASS_MAIL_BODY
	A megadott csatorna (%s) jelszava: %s
	
	Ezt a levelet %s kldte vlaszknt
	%s@%s SENDPASS krelmre.

# SENDPASS vlaszok
CHAN_SENDPASS_SYNTAX
	SENDPASS csatorna
CHAN_SENDPASS_FAILED
	Sajnlom, a jelszklds sikertelen.
CHAN_SENDPASS_FOUNDER_ONLY
	Csak a csatorna tulajdonosa hasznlhatja a SENDPASS parancsot.
CHAN_SENDPASS_NO_EMAIL
	Nem lltottl be E-mail cmet a nicknevedhez.
# parameter  "NNN napok/rk/percek"
CHAN_SENDPASS_TOO_SOON
	A SENDPASS parancsot legkzelebb %s nap utn hasznlhatod; addig krlek, vrj.
CHAN_SENDPASS_SENT
	A megadott csatorna (%s) jelszavt elkldtem a kvetkez E-mail cmre: %s.

###########################################################################
#
# MemoServ zenetek
#
###########################################################################

# Automatikus zenetek
MEMO_HAVE_NEW_MEMO
	Van egy j zeneted.
MEMO_HAVE_NEW_MEMOS
	%d j zeneted van.
MEMO_TYPE_READ_LAST
	Az utols zenet elolvasshoz hasznld a /msg %s READ LAST parancsot.
MEMO_TYPE_READ_NUM
	Az zenet elolvasshoz rd be: /msg %s READ %d.
MEMO_TYPE_LIST_NEW
	Az zenetek listjhoz rd be: /msg %s LIST NEW
MEMO_AT_LIMIT
	Figyelem: Elrted a fogadhat zenetek maximlis szmt (%d). Nem fogadhatsz tbb j zenetet, amg a jelenlegiekbl nem trlsz nhnyat.
MEMO_OVER_LIMIT
	Figyelem: Tllpted a fogadhat zenetek maximlis szmt (%d). Nem fogadhatsz tbb j zenetet, amg a jelenlegiekbl nem trlsz nhnyat.
MEMO_NEW_MEMO_ARRIVED
	%s kldtt egy j zenetet.
	Ha szeretnd elolvasni, rd be: /msg %s READ %d.

# Multi-felhasznlsi vlaszok
MEMO_HAVE_NO_MEMOS
	Nincs zeneted.
MEMO_X_HAS_NO_MEMOS
	%s zenetlistja res.
MEMO_DOES_NOT_EXIST
	A megadott szm zenet (%d.) nem szerepel az zenetlistn!
MEMO_LIST_NOT_FOUND
	A megadott szm zenetek nem szerepelnek az zenetlistn.

# SEND vlaszok
MEMO_SEND_SYNTAX
	SEND {nick | csatorna} zenet
MEMO_SEND_DISABLED
	Sajnlom, az zenetklds jelenleg sznetel.
MEMO_SEND_PLEASE_WAIT
	Krlek, vrj %s mieltt SEND parancsot jra hasznlod!
MEMO_X_GETS_NO_MEMOS
	%s nem fogadhat zeneteket.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s tl sok zenettel rendelkezik, s nem fogadhat tbbet.
MEMO_SENT
	zenet elkldve %s rszre.

# LIST vlaszok
MEMO_LIST_SYNTAX
	LIST [csatorna] [szm | list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	Nem kaptl j zenetet.
MEMO_X_HAS_NO_NEW_MEMOS
	%s nem kapott j zenetet.
MEMO_LIST_MEMOS
	%s zenetei. Olvasshoz rd be: /msg %s READ szm
MEMO_LIST_NEW_MEMOS
	%s j zenetei.  Olvasshoz rd be: /msg %s READ szm
MEMO_LIST_CHAN_MEMOS
	%s zenetei.  Olvasshoz rd be: /msg %s READ %s szm
MEMO_LIST_CHAN_NEW_MEMOS
	%s j zenetei.  Olvasshoz, rd be: /msg %s READ %s szm
MEMO_LIST_HEADER
	  Szm  Kld            Dtum/Id
MEMO_LIST_FORMAT
	%c%c%3d  %-16s  %s

# READ vlaszok
MEMO_READ_SYNTAX
	READ [csatorna] {szm | list | LAST | NEW}
MEMO_HEADER
	zenetszm: %d; felad: %s (%s).  Trlshez rd be: /msg %s DEL %d
MEMO_CHAN_HEADER
	zenetszm: %d; felad: %s (%s).  Trlshez rd be: /msg %s DEL %s %d

# SAVE vlaszok
MEMO_SAVE_SYNTAX
	SAVE [csatorna] {szm | list}
MEMO_SAVED_ONE
	A megadott zenet (%d) nem fog lejrni.
MEMO_SAVED_SEVERAL
	A megadott zenetek (%d) nem fognak lejrni.

# DEL vlaszok
MEMO_DEL_SYNTAX
	DEL [csatorna] {szm | list | ALL}
MEMO_DELETED_NONE
	Nem trltem egy zenetet sem.
MEMO_DELETED_ONE
	A megadott zenetet (%d) trltem.
MEMO_DELETED_SEVERAL
	A megadott zeneteket (%d) trltem.
MEMO_DELETED_ALL
	Minden zenetet trltem.

# SET vlaszok
MEMO_SET_SYNTAX
	SET opci paramterek
MEMO_SET_DISABLED
	Sajnlom, az zenet opciinak belltsa tmenetileg sznetel.
MEMO_SET_UNKNOWN_OPTION
	Ismeretlen SET opci: %s.

# SET NOTIFY vlaszok
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s mostmr rtesteni fog az j zenetekrl minden csatlakozskor.
MEMO_SET_NOTIFY_LOGON
	%s mostmr rtesteni fog az j zenetekrl minden csatlakozskor illetve az /AWAY kikapcsolsakor.
MEMO_SET_NOTIFY_NEW
	%s mostmr rtesteni fog, ha j zeneted rkezik.
MEMO_SET_NOTIFY_OFF
	%s mostmr nem fog rtestteni, ha j zeneted rkezik.

# SET LIMIT vlaszok
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [csatorna] limit
MEMO_SET_LIMIT_OPER_SYNTAX
	SET LIMIT [nick | csatorna] {limit | NONE | DEFAULT} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	Nem vltoztathatod meg a maximlisan fogadhat zenetek szmt.
MEMO_SET_LIMIT_FORBIDDEN
	Nem vltoztathatod meg %s zeneteinek szmt.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	A maximlisan fogadhat zenetek szma nem lehet nagyobb, mint %d.
MEMO_SET_LIMIT_TOO_HIGH
	%s maximlisan fogadhat zeneteinek szma nem lehet nagyobb, mint %d.
MEMO_SET_LIMIT_OVERFLOW
	Tl nagy rtket adtl meg a maximlisan fogadhat zenetek szmnak, %d lesz helyette.
MEMO_SET_YOUR_LIMIT
	A maximlisan fogadhat zenetek szmanak j rtke: %d.
MEMO_SET_YOUR_LIMIT_ZERO
	Ezentl nem tudsz zeneteket fogadni.
MEMO_SET_YOUR_LIMIT_DEFAULT
	A maximlisan fogadhat zenetek szmt belltottam alaprtelmezsre (%d).
MEMO_UNSET_YOUR_LIMIT
	Ezentl korltlan szm zenetet fogadhatsz.
MEMO_SET_LIMIT
	%s maximlisan fogadhat zeneteinek szma: %d.
MEMO_SET_LIMIT_ZERO
	%s ezentl nem fogadhat zeneteket.
MEMO_SET_LIMIT_DEFAULT
	%s maximlisan fogadhat zeneteinek szmt belltottam alaprtelmezsre (%d).
MEMO_UNSET_LIMIT
	%s ezentl .korltlan. szm zenetet fogadhat.

# INFO vlaszok
MEMO_INFO_NO_MEMOS
	Jelenleg nincs zeneted.
MEMO_INFO_MEMO
	Van 1 zeneted.
MEMO_INFO_MEMO_UNREAD
	Van 1 olvasatlan zeneted.
MEMO_INFO_MEMOS
	Van %d zeneted.
MEMO_INFO_MEMOS_ONE_UNREAD
	Van %d zeneted, ebbl 1 olvasatlan.
MEMO_INFO_MEMOS_SOME_UNREAD
	Van %d zeneted, ebbl %d olvasatlan.
MEMO_INFO_MEMOS_ALL_UNREAD
	Van %d zeneted; s mind olvasatlan.
MEMO_INFO_LIMIT
	A maximlisan fogadhat zentek szma:  %d.
MEMO_INFO_HARD_LIMIT
	A maximlisan fogadhat zentek szma: %d, s ez a bellts nem vltoztathat meg.
MEMO_INFO_LIMIT_ZERO
	A maximlisan fogadhat zentek szma: 0; s nem fogadhatsz zenteket.
MEMO_INFO_HARD_LIMIT_ZERO
	A maximlisan fogadhat zentek szma: 0; s nem fogadhatsz zenteket. Ez a bellts nem vltoztathat meg.
MEMO_INFO_NO_LIMIT
	Korltlan szm zenetet fogadhatsz.
MEMO_INFO_NOTIFY_OFF
	Nem kapsz rtestst az j zeneteidrl.
MEMO_INFO_NOTIFY_ON
	rtestst kapsz j zenetek rkezsrl minden csatlakozskor.
MEMO_INFO_NOTIFY_RECEIVE
	rtestst kapsz j zenetek rkezsekor.
MEMO_INFO_NOTIFY_SIGNON
	rtestst kapsz az j zeneteidrl, amikor fellpsz az IRC-re.
MEMO_INFO_X_NO_MEMOS
	%s zenetlistja res.
MEMO_INFO_X_MEMO
	%s listjn van 1 zenet.
MEMO_INFO_X_MEMO_UNREAD
	%s listjn van 1 olvasatlan zenet.
MEMO_INFO_X_MEMOS
	%s szmra %d zenet rkezett.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s szmra %d zenet rkezett, ebbl 1 olvasatlan.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s szmra %d zenet rkezett, ebbl %d olvasatlan.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s szmra %d zenet rkezett, s mind olvasatlan.
MEMO_INFO_X_LIMIT
	%s maximlisan fogadhat zeneteinek szma: %d.
MEMO_INFO_X_HARD_LIMIT
	%s maximlisan fogadhat zenteinek szma: %d, s ez nem vltoztathat meg.
MEMO_INFO_X_NO_LIMIT
	%s korltlan szm zenetet fogadhat.
MEMO_INFO_X_NOTIFY_OFF
	%s nem krt rtestst az zeneteirl.
MEMO_INFO_X_NOTIFY_ON
	%s kte, hogy rtestst kapjon minden csatlakozskor, ha j zenete van, illetve ha j zente rkezik.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s krte, hogy rtestst kapjon, ha j zenete rkezik.
MEMO_INFO_X_NOTIFY_SIGNON
	%s krte, hogy minden csatlakozskor rtestst kapjon, ha j zenete van.

################ tovbbtsi module zenetek/vlaszok

# Levl Formtum
MEMO_FORWARD_MAIL_SUBJECT
	zenet %s szmra
MEMO_FORWARD_MAIL_BODY
	zenet kldje: %s (%s)
	%s

# FORWARD vlaszok
MEMO_FORWARD_SYNTAX
	FORWARD {szm | list | ALL}
MEMO_FORWARD_NEED_EMAIL
	A FORWARD parancs hasznlathoz be kell lltanod egy E-mail cmet.
MEMO_FORWARD_PLEASE_WAIT
	Krlek, vrj %s mieltt jra hasznlod a FORWARD parancsot.
MEMO_FORWARD_FAILED
	Sajlom, a klds sikertelen.
MEMO_FORWARDED_NONE
	Nem lehet elkldve egy zenet sem.
MEMO_FORWARDED_ONE
	A megadott szm zenet (%d) elkldve.
MEMO_FORWARDED_SEVERAL
	A megadott szm zenetek (%d) elkldve.
MEMO_FORWARDED_ALL
	Minden zenet elkldve.
MEMO_FORWARDED_ALSO_TEMPFAIL
	Figyelem: Nhny zenetet nem sikerlt elkldeni, mert a rendszer tl forgalmas volt.
MEMO_FORWARDED_ALSO_PERMFAIL
	Figyelem: Nhny zenetet nem sikerlt elkldeni valamilyen rendszerhiba miatt.

# SET FORWARD vlaszok
MEMO_SET_FORWARD_SYNTAX
	SET FORWARD {ON | COPY | OFF}
MEMO_SET_FORWARD_ON
	Az zenetek tovbbtva lesznek a kvetkez E-mail cmre: %s
MEMO_SET_FORWARD_COPY
	Az zenetek tovbbtva lesznek a kvetkez E-mail cmre: %s
	Az zeneteid a Services elmentette.
MEMO_SET_FORWARD_OFF
	A nevedre rkez memokat nem fogja az E-mail cmedre tovbbtani.


################ mellzs module zenetek/vlaszok

# IGNORE vlaszok
MEMO_IGNORE_SYNTAX
	IGNORE {ADD | DEL | LIST} [nick | mask]
MEMO_IGNORE_ADD_SYNTAX
	IGNORE ADD nick | mask
MEMO_IGNORE_DEL_SYNTAX
	IGNORE DEL nick | mask
MEMO_IGNORE_LIST_FULL
	Tele van az ignore listd!
MEMO_IGNORE_ALREADY_PRESENT
	%s mr szerepel az ignore listn.
MEMO_IGNORE_ADDED
	%s hozzadva az ignore listhoz.
MEMO_IGNORE_NOT_FOUND
	%s nem szerepel az ignore listn.
MEMO_IGNORE_DELETED
	%s trlve az ignore listrl.
MEMO_IGNORE_LIST_EMPTY
	Az ignore listd res.
MEMO_IGNORE_LIST
	Ignore lista:
MEMO_IGNORE_LIST_X_EMPTY
	Ignore lista %s res.
MEMO_IGNORE_LIST_X
	Ignore lista %s:

###########################################################################
#
# OperServ zenetek
#
###########################################################################

# ltalnos zenetek
OPER_BOUNCY_MODES
	A Services nem tud mdokat lltani. A szervered megfelelen konfigurltad?
OPER_BOUNCY_MODES_U_LINE
	A Services nem tud mdokat lltani. A szervered U:lines rszt megfelelen konfigurltad?

# GLOBAL vlaszok
OPER_GLOBAL_SYNTAX
	GLOBLIS zenet

# STATS vlaszok
OPER_STATS_UNKNOWN_OPTION
	Ismeretlen STATS opci: %s.
OPER_STATS_RESET_USER_COUNT
	A maximum felhasznlk szma alaprtkre llt.

OPER_STATS_CURRENT_USERS
	Jelenlegi felhasznlk szma: %d (%d op)
OPER_STATS_MAX_USERS
	Maximum felhasznlk szma: %d (%s)
# Paramterek: napok, STR_DAYS vagy STR_DAY, rk, percek, msodpercek
OPER_STATS_UPTIME_DHMS
	A Services online %d%s, %02d:%02d ta
# Ha >= 1 ra, rk s percek; ha < 1 ra, percek s msodpercek
OPER_STATS_UPTIME_HM_MS
	A Services online %s ta.

OPER_STATS_KBYTES_READ
	Fogadott Adat:     %10u kB
OPER_STATS_KBYTES_WRITTEN
	Elkldtt Adat:    %10u kB
OPER_STATS_NETBUF_SOCK
	Server socket bufferek: %5u kB
OPER_STATS_NETBUF_SOCK_PERCENT
	Server socket bufferek: %5u kB (%d%%)
OPER_STATS_NETBUF_TOTAL
	Total socket bufferek:  %5u kB
OPER_STATS_NETBUF_TOTAL_PERCENT
	Total socket bufferek:  %5u kB (%d%%)

OPER_STATS_ALL_USER_MEM
	Felhasznlk  : %6d rekord, %5d kB
OPER_STATS_ALL_CHANNEL_MEM
	Csatornk     : %6d rekord, %5d kB
OPER_STATS_ALL_SERVER_MEM
	Szerverek     : %6d rekord, %5d kB
OPER_STATS_ALL_NICKGROUPINFO_MEM
	Nickcsoportok : %6d rekord, %5d kB
OPER_STATS_ALL_NICKINFO_MEM
	Nickek        : %6d rekord, %5d kB
OPER_STATS_ALL_CHANSERV_MEM
	ChanServ      : %6d rekord, %5d kB
OPER_STATS_ALL_STATSERV_MEM
	StatServ      : %6d rekord, %5d kB
OPER_STATS_ALL_NEWS_MEM
	Hrzenetek   : %6d rekord, %5d kB
OPER_STATS_ALL_AKILL_MEM
	Autokillek    : %6d rekord, %5d kB
OPER_STATS_ALL_EXCEPTION_MEM
	Kivtelek     : %6d rekord, %5d kB
OPER_STATS_ALL_SGLINE_MEM
	SGline-ok     : %6d rekord, %5d kB
OPER_STATS_ALL_SQLINE_MEM
	SQline-ok     : %6d rekord, %5d kB
OPER_STATS_ALL_SZLINE_MEM
	SZline-ok     : %6d rekord, %5d kB
OPER_STATS_ALL_SESSION_MEM
	Sessions      : %6d rekord, %5d kB

# MODE vlaszok
OPER_MODE_SYNTAX
	MODE csatorna mdok

# CLEARMODES vlaszok
OPER_CLEARMODES_SYNTAX
	CLEARMODES csatorna [ALL]
OPER_CLEARMODES_DONE
	Logikai mdok s kitiltsok trlve a megadott csatornrl (%s).
OPER_CLEARMODES_EXCEPT_DONE
	Logikai mdok, kitiltsok, s kivtelek trlve a megadott csatornrl (%s).
OPER_CLEARMODES_ALL_DONE
	Minden md trlve a megadott csatornrl (%s).

# CLEARCHAN vlaszok
OPER_CLEARCHAN_SYNTAX
	CLEARCHAN csatorna
OPER_CLEARCHAN_DONE
	Minden felhasznlt eltvoltottam a megadott (%s) csatornrl.

# KICK vlaszok
OPER_KICK_SYNTAX
	KICK csatorna felhasznl indok

# ADMIN vlaszok
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [nick]
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD nick
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL nick
OPER_ADMIN_NO_NICKSERV
	NickServ jelenleg nem mkdik; az ADMIN parancs nem hasznlhat.
OPER_ADMIN_EXISTS
	%s mr szerepel a Services adminok listjn.
OPER_ADMIN_ADDED
	%s felvve a Services adminok listjra.
OPER_ADMIN_TOO_MANY
	Tl sok bejegyzs szerepel a Services adminok listjn (%d); tbb nem vehet fel.
OPER_ADMIN_REMOVED
	%s eltvoltva a Services adminok listjrl.
OPER_ADMIN_NOT_FOUND
	%s nem tallhat a Services adminok listjn.
OPER_ADMIN_LIST_HEADER
	Services adminok listja:

# OPER vlaszok
OPER_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [nick]
OPER_OPER_ADD_SYNTAX
	OPER ADD nick
OPER_OPER_DEL_SYNTAX
	OPER DEL nick
OPER_OPER_NO_NICKSERV
	NickServ jelenleg nem mkdik; az OPER parancs nem hasznlhat.
OPER_OPER_EXISTS
	%s mr szerepel a Services opertorok listjn.
OPER_OPER_ADDED
	%s felvve a Services opertorok listjra.
OPER_OPER_TOO_MANY
	Tl sok bejegyzs szerepel a Services opertorok listjn (%d); tbb nem vehet fel.
OPER_OPER_REMOVED
	%s eltvoltva a Services opertorok listjrl.
OPER_OPER_NOT_FOUND
	%s nem tallhat a Services opertorok listjn.
OPER_OPER_LIST_HEADER
	Services opertorok listja:

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | COUNT} [[+expiry] mask [reason]]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+elvls] mask indok
OPER_AKILL_DEL_SYNTAX
	AKILL DEL mask
OPER_TOO_MANY_AKILLS
	Tele van az AKILL lista!
OPER_AKILL_EXISTS
	%s mr szerepel az autokill listn.
OPER_AKILL_NO_NICK
	Megjegyzs: az autokill maszk nem tartalmazhat nicknevet; gyzdj meg rla, hogy nem tartalmaz nick rszt a te maszkolsod.
OPER_AKILL_MASK_TOO_GENERAL
	Az autokill maszk tl ltalnos.
OPER_AKILL_EXPIRY_LIMITED
	A lejrati id maximumlisan %s lehet.
OPER_AKILL_ADDED
	%s hozzadva az autokill listhoz.
OPER_AKILL_REMOVED
	%s eltvoltva az autokill listrl.
OPER_AKILL_NOT_FOUND
	%s nem tallhat az autokill listn.
OPER_AKILL_LIST_HEADER
	Jelenlegi autokill lista:
# mask, indok
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mask, felrak szemly, felraks ideje, utoljra hasznlva, elvls, indok
OPER_AKILL_VIEW_FORMAT
	%s (felvette: %s; dtum: %s; utoljra hasznlva: %s; %s)
	    %s
# mask, felrak szemly, felraks ideje, elvls, indok
OPER_AKILL_VIEW_UNUSED_FORMAT
	%s (felvette: %s, dtum: %s; mg nem volt hasznlva; %s)
	    %s
OPER_AKILL_COUNT
	%d darab hostmaszk szerepel az autokill listn.

# AKILLCHAN vlaszok
OPER_AKILLCHAN_SYNTAX
	AKILLCHAN [KILL] [+elvls] csatorna indok
OPER_AKILLCHAN_AKILLED
	%d felhasznl autokillelve.
OPER_AKILLCHAN_KILLED
	%d felhasznl killelve.
OPER_AKILLCHAN_AKILLED_ONE
	1 felhasznl autokillelve.
OPER_AKILLCHAN_KILLED_ONE
	1 felhasznl killelve.

# EXCLUDE vlaszok
OPER_EXCLUDE_SYNTAX
	EXCLUDE {ADD | DEL | LIST | VIEW | COUNT} [[+elvls] mask [indok]]
OPER_EXCLUDE_ADD_SYNTAX
	EXCLUDE ADD [+elvls] mask indok
OPER_EXCLUDE_DEL_SYNTAX
	EXCLUDE DEL mask
OPER_TOO_MANY_EXCLUDES
	Tele van az EXCLUDE lista!
OPER_EXCLUDE_EXISTS
	%s mr szerepel az autokill kizrsi listn.
OPER_EXCLUDE_ADDED
	%s hozzadva az autokill kizrsi listhoz.
OPER_EXCLUDE_REMOVED
	%s eltvoltva az autokill kizrsi listrl.
OPER_EXCLUDE_NOT_FOUND
	%s nem tallhat az autokill kizrsi listn.
OPER_EXCLUDE_LIST_HEADER
	Jelenlegi autokill kizrsi lista:
# mask, indok
OPER_EXCLUDE_LIST_FORMAT
	%-32s  %s
# mask, felrak szemly, felraks ideje, utoljra hasznlva, elvls, indok
OPER_EXCLUDE_VIEW_FORMAT
	%s (felvette: %s; dtum: %s; utoljra hasznlva %s; %s)
	    %s
# mask, felrak szemly, felraks ideje, elvls, indok
OPER_EXCLUDE_VIEW_UNUSED_FORMAT
	%s (felvette: %s; dtum: %s, mg nem volt hasznlva; %s)
	    %s
OPER_EXCLUDE_COUNT
	%d darab hostmaszk szerepel az autokill kizrsi listn.

# SxLINE vlaszok
OPER_SLINE_SYNTAX
	%s {ADD | DEL | LIST | VIEW | COUNT} [[+elvls] mask [indok]]
OPER_SLINE_ADD_SYNTAX
	%s ADD [+elvls] mask indok
OPER_SLINE_DEL_SYNTAX
	%s DEL mask
OPER_TOO_MANY_SLINES
	%s lista tele van!
OPER_SLINE_EXISTS
	%s mr szerepel a %s listn.
OPER_SLINE_ADDED
	%s hozzadva a %s listhoz.
OPER_SLINE_REMOVED
	%s eltvoltva a %s listrl.
OPER_SLINE_NOT_FOUND
	%s nem tallhat a %s listn.
OPER_SLINE_LIST_HEADER
	Jelenlegi %s lista:
# mask, indok
OPER_SLINE_LIST_FORMAT
	%-32s  %s
# mask, felrak szemly, felraks ideje, utoljra hasznlva, elvls, indok
OPER_SLINE_VIEW_FORMAT
	%s (felvette: %s; dtum: %s, utoljra hasznlva %s; %s)
	    %s
# mask, felrak szemly, felraks ideje, elvls, indok
OPER_SLINE_VIEW_UNUSED_FORMAT
	%s (felvette: %s; dtum:  %s, mg nem volt hasznlva; %s)
	    %s
OPER_SLINE_COUNT
	%d bejegyzs szerepel a %s listn.
OPER_SZLINE_NOT_AVAIL
	SZLINE nem elrhet ezzel az IRC szerverrel.

# SU vlaszok
OPER_SU_SYNTAX
	SU jelsz
OPER_SU_NO_PASSWORD
	Nem hasznlhatod a SU parancsot, mert nincs belltva super-user jelsz.
OPER_SU_SUCCEEDED
	Most mr Services super-user jogaid vannak.
OPER_SU_FAILED
	A jelsz nem ellenrizhet.

# SET vlaszok
OPER_SET_SYNTAX
	SET opci bellts
OPER_SET_IGNORE_ON
	Ignore kd hasznlva lesz.
OPER_SET_IGNORE_OFF
	Ignore kd nem lesz hasznlva.
OPER_SET_IGNORE_ERROR
	Az IGNORE bellts lehet ON vagy OFF.
OPER_SET_READONLY_ON
	A Services most mr csak olvashat mdban dolgozik.
OPER_SET_READONLY_OFF
	A Services most mr rhat, olvashat mdban dolgozik.
OPER_SET_READONLY_ERROR
	A READONLY bellts lehet ON vagy OFF.
OPER_SET_DEBUG_ON
	A Services most mr debug mdban dolgozik.
OPER_SET_DEBUG_OFF
	A Services most mr non-debug mdban dolgozik.
OPER_SET_DEBUG_LEVEL
	A Services most mr debug mdban dolgozik (szint %d).
OPER_SET_DEBUG_ERROR
	A DEBUG bellts lehet ON, OFF, vagy egy pozitiv szm.
OPER_SET_SUPASS_FAILED
	Nem sikerlt lltani a Services super-user jelszt.
OPER_SET_SUPASS_OK
	A Services super-user jelsz megvltozott.
OPER_SET_SUPASS_NONE
	A Services super-user jelsz hasznlta letiltva.
OPER_SET_UNKNOWN_OPTION
	Ismeretlen opci: %s.

# JUPE vlaszok
OPER_JUPE_SYNTAX
	JUPE szervernv [indok]
OPER_JUPE_INVALID_NAME
	rvnytelen szervernv (a szervernvnek tartalmaznia kell egy pontot).
OPER_JUPE_ALREADY_JUPED
	A megadott szerver (%s) mr jupe-olva van.

# RAW vlaszok
OPER_RAW_SYNTAX
	RAW szveg

# UPDATE vlaszok
OPER_UPDATE_SYNTAX
	UPDATE [FORCE]
OPER_UPDATE_FORCE_FAILED
	Nem sikerlt az adatbzist jranyitni.
OPER_UPDATING
	Menti az adatbzisokat...
OPER_UPDATE_COMPLETE
	Adatbzis mentse ksz.
OPER_UPDATE_FAILED
	Adatbzis mentse sikertelen.

# REHASH vlaszok
OPER_REHASHING
	A konfigurcis belltsok jraolvassa...
OPER_REHASHED
	Minden konfigurcis bellts sikeresen frisstve.
OPER_REHASH_ERROR
	Hiba lpett fel a konfigurcis belltsok jraolvassa kzben.  Krlek ellenrizd a Services naplfjlt a rszletekrt.

# LISTIGNORE vlaszok
OPER_IGNORE_LIST
	Services ignore lista:
OPER_IGNORE_LIST_EMPTY
	res az ignore lista.

# KILLCLONES vlaszok
OPER_KILLCLONES_SYNTAX
	KILLCLONES nick
OPER_KILLCLONES_UNKNOWN_NICK
	Ismeretlen felhasznl: %s.
OPER_KILLCLONES_KILLED
	%s KILLCLONES-t hasznlt %s felhasznlra, kilve %d kln.
OPER_KILLCLONES_KILLED_AKILL
	%s KILLCLONES-t hasznlt %s felhasznlra, kilve %d kln.  Egy tmeneti AKILL hozzadva %s maszkkal.


###########################################################################
#
# Session Limit s Exception zenetek (exception=kivtel)
#
###########################################################################

# EXCEPTION vlasz
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [paramterek]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+lejrat] maszk korlt indok
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {maszk | lista}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE szm jszm
OPER_EXCEPTION_ALREADY_PRESENT
	A megadott maszk (%s) mr szerepel az exception listn.
OPER_EXCEPTION_TOO_MANY
	A session-korltozsi kivtellista tele van!
OPER_EXCEPTION_ADDED
	%s session-korltozsa belltva a kvetkezre: %d.
OPER_EXCEPTION_MOVED
	%s kivtel bejegyzsnek szma (#%d) tlltva a kvetkezre: %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	A megadott bejegyzs (#%d) nem tallhat a session-korltozsi kivtellistn.
OPER_EXCEPTION_NOT_FOUND
	%s nem tallhat a session-korltozsi kivtellistn.
OPER_EXCEPTION_NO_MATCH
	Nincs egyez bejegyzs a session-korltozsi kivtellistn.
OPER_EXCEPTION_EMPTY
	res a session-korltozsi kivtellista.
OPER_EXCEPTION_DELETED
	%s trlve a session-korltozsi kivtellistrl.
OPER_EXCEPTION_DELETED_ONE
	Trlve 1 bejegyzs a session-korltozsi kivtellistrl.
OPER_EXCEPTION_DELETED_SEVERAL
	Trlve %d bejegyzs a session-korltozsi kivtellistrl.
OPER_EXCEPTION_LIST_HEADER
	Jelenlegi session-korltozsi kivtellista:
# mask, limit
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
OPER_EXCEPTION_LIST_COLHEAD
	Sorszm  Limit  Host
# mask, felrak szemly, felraks ideje, elvls, limit, indok
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (felvette: %s; dtum:  %s; %s)
	    Limit: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	rvnytelen session-korltozsi szm; ez a szm nem lehet nullnl kisebb, s nagyobb, mint %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	rvnytelen hostmaszk. Csak vals hostmaszkok rvnyesek, vagyis nem szerepelhet bennk nick vagy felhasznlnv.

# SESSION vlaszok
OPER_SESSION_SYNTAX
	SESSION {LIST limit | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limit
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_INVALID_THRESHOLD
	rvnytelen hatrrtk; a hatrrtk legyen nagyobb, mint 1.
OPER_SESSION_NOT_FOUND
	%s nem tallhat a session listn.
OPER_SESSION_LIST_HEADER
	Hostok legalbb %d sessionnal:
OPER_SESSION_LIST_COLHEAD
	Session  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	A megadott hostnak (%s) jelenleg %d sessionja van, sessin korltja: %d.


###########################################################################
#
# Hirek rendszer zenetek
#
###########################################################################

NEWS_LOGON_TEXT
	[Fellpsi zenet - %s] %s
NEWS_OPER_TEXT
	[Oper zenet - %s] %s

NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD|DEL|LIST} [szveg|szm]
NEWS_LOGON_LIST_HEADER
	Fellpsi zeneti egysgek:
NEWS_LOGON_LIST_ENTRY
	%5d (%s %s ltal)
	    %s
NEWS_LOGON_LIST_NONE
	Nincs egyetlen fellpsi zenet sem.
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD szveg
NEWS_LOGON_ADD_FULL
	Tele van a hrzenetek listja!
NEWS_LOGON_ADDED
	Hozzadva a fellpsi zenetekhez (#%d).
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL {szm | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	A megadott szm (#%d) fellpsi zenet nem tallhat!
NEWS_LOGON_DELETED
	A megadott szm #%d fellpsi zenet trlve.
NEWS_LOGON_DEL_NONE
	Nincs trlhet fellpsi zenet!
NEWS_LOGON_DELETED_ALL
	Minden fellpsi zenet trlve.

NEWS_OPER_SYNTAX
	OPERNEWS {ADD|DEL|LIST} [szveg|szm]
NEWS_OPER_LIST_HEADER
	Oper zenetek:
NEWS_OPER_LIST_ENTRY
	%5d (%s %s ltal)
	    %s
NEWS_OPER_LIST_NONE
	Nincs oper hrzenet.
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD szveg
NEWS_OPER_ADD_FULL
	Tele van a hrzenetek listja!
NEWS_OPER_ADDED
	Hozzadva az oper hrzenetekhez (#%d).
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL {szm | ALL}
NEWS_OPER_DEL_NOT_FOUND
	A megadott szm (#%d) oper zenet nem tallhat!
NEWS_OPER_DELETED
	A megadott szm (#%d) oper zenet trlve.
NEWS_OPER_DEL_NONE
	Nincs trlhet oper zenet!
NEWS_OPER_DELETED_ALL
	Minden oper zenet trlve.

NEWS_HELP_LOGON
	Syntax: LOGONNEWS ADD szveg
	        LOGONNEWS DEL {szm | ALL}
	        LOGONNEWS LIST
	
	Szerkeszti vagy megjeleniti a fellp zenetek listjt.  Amikor egy
	felhasznl csatlakozik a hlzathoz, meg fogja kapni ezek az zeneteket
	. (Habr, nem tbb mint hrom lesz csak elkldve a
	usernek, hogy elkerljk a user kifloodolst.  Ha tbb, mint
	hrom hr zenet is van, akkor csak a hrom legujabb lesz
	elkldve.)
	
	LOGONNEWS LIST arra hasznlhat , hogy brmelyik IRC operator listzhassa
	a jelenlegi hr zeneteket. Az ADD s DEL parancsok csak Services administratorok
	ltal hasznlhatak.

NEWS_HELP_OPER
	Syntax: OPERNEWS ADD szveg
	        OPERNEWS DEL {szm | ALL}
	        OPERNEWS LIST
	
	Szerkeszti vagy megjeleniti az oper hrek listjt.  Amikor egy
	user felopereli magt ( a /oper paranccsal) , meg fogja kapni
	ezek az zeneteket. (Habr, nem tbb mint hrom lesz csak elkldve a
	usernek, hogy elkerljk a user kifloodolst.  Ha tbb, mint
	hrom hr zenet is van, akkor csak a hrom legujabb lesz
	elkldve.)
	
	OPERNEWS LIST arra hasznlhat , hogy brmelyik IRC operator listzhassa
	a jelenlegi oper hreket. Az ADD s DEL parancsok csak Services administratorok
	ltal hasznlhatak.


###########################################################################
#
# StatServ zenetek
#
############################################################################

# ltalnos SERVERS vlaszok
STAT_SERVERS_REMOVE_SERV_FIRST
	A megadott szerver (%s) jelenleg online. Elszr tvolitsd el a hlozatrl, majd prbld jra.
STAT_SERVERS_SERVER_EXISTS
	A megadott szerver (%s) mr ltezik.

# SERVERS parancs szintaktika
STAT_SERVERS_SYNTAX
	SERVERS opci paramterek

# STATS vlaszok
STAT_SERVERS_STATS_TOTAL
	sszes Szerver: %2d
STAT_SERVERS_STATS_ON_OFFLINE
	       Online: %2d (%d%%)  Offline: %2d (%d%%)
STAT_SERVERS_LASTQUIT_WAS
	    Utols kilps: %-30s  %s

# LIST vlaszok
STAT_SERVERS_LIST_HEADER
	Szerver Nv                    Userek     Operek
STAT_SERVERS_LIST_FORMAT
	%-30s %3d (%2d%%)  %3d (%2d%%)
STAT_SERVERS_LIST_RESULTS
	Lista vge -- %d/%d online szerver listzva.

# VIEW vlaszok
STAT_SERVERS_VIEW_HEADER_ONLINE
	%-30s  (online)
STAT_SERVERS_VIEW_HEADER_OFFLINE
	%-30s  (offline)
STAT_SERVERS_VIEW_LASTJOIN
	    Utols belps: %s
STAT_SERVERS_VIEW_LASTQUIT
	    Utols kilps: %s
STAT_SERVERS_VIEW_QUITMSG
	     Kilp zenet: %s
STAT_SERVERS_VIEW_USERS_OPERS
	            Userek: %3d (%2d%%)  Operek: %3d (%2d%%)
STAT_SERVERS_VIEW_RESULTS
	Lista vge -- %d/%d szerver listzva.

# DELETE vlaszok
STAT_SERVERS_DELETE_SYNTAX
	SERVERS DELETE szerver
STAT_SERVERS_DELETE_DONE
	A megadott szerver (%s) statisztikjt trltem.

# COPY vlaszok
STAT_SERVERS_COPY_SYNTAX
	SERVERS COPY szerver jnv
STAT_SERVERS_COPY_DONE
	A megadott szerver (%s) statisztikjt tmsoltam %s nvre.

# RENAME vlaszok
STAT_SERVERS_RENAME_SYNTAX
	SERVERS RENAME szerver jnv
STAT_SERVERS_RENAME_DONE
	A megadott szerver (%s) statisztikjt tneveztem %s nvre.

# USERS vlaszok
STAT_USERS_SYNTAX
	USERS opci paramterek
STAT_USERS_TOTUSERS
	               sszes felhasznl: %d
STAT_USERS_TOTOPERS
	                  sszes opertor: %d
STAT_USERS_SERVUSERS
	Felhasznlk tlaga szerverenknt: %d
STAT_USERS_SERVOPERS
	  Opertorok tlaga szerverenknt: %d.%d


###########################################################################
#
# NickServ help zenetek
#
###########################################################################

NICK_HELP
	A %S lehetsget nyjt a "register" parancs hasznlatval
	a nickneved regisztrlsra s ezzel megelzi azt, hogy
	ms is hasznlhassa a nicked. A %S klnbz parancsokkal
	rnythat, amelyek a nicknevek regisztrcijt s fenntartst
	segtik el. A parancsok pontos listjrt rd be brmelyik
	ablakba: /msg %S HELP COMMANDS; hogy a parancsok szintaktikjt
	is megkapd, rd be: /msg %S parancs, s ha tovbbi
	informcira van szksged, akkor rd be: /msg %S HELP parancs.

NICK_HELP_EXPIRES
	
	Ha egy regisztrlt nicknevet %s idejig nem hasznlnak, a
	regisztrci elvl s a nicknv elrhet lesz msok szmra is,
	hogy hasznlhassk.

NICK_HELP_WARNING
	
	Megjegyzs: Ez a service arrl akar gondoskodni, hogy az
	IRC felhasznlk szmra biztostsa az azonostst is.
	s NEM azrt van, ohgy megknnytse a nicknevek "lopst"
	vagy ms alattomos akcit.  A %S visszals
	azt is eredmnyezhati, hogy esetleg elveszik az a
	nicknv, amivel visszaltek.

NICK_HELP_COMMANDS
	A kvetkez parancsok hasznlhatak a  %S: ltal
	
	    REGISTER   Regisztrlhatod a nicknevet
NICK_HELP_COMMANDS_AUTH
	    AUTH       A nickneved regisztrcijnak lestse
	    SENDAUTH   Elkldi neked a nicked lestsi kdjt
NICK_HELP_COMMANDS_IDENTIFY
	    IDENTIFY   Azonosthatod magad a jelszavaddal
NICK_HELP_COMMANDS_SENDPASS
	    SENDPASS   Elkldi a jelszavad az E-mail cmedre
NICK_HELP_COMMANDS_DROP
	    DROP       Trli a nickneved regisztrcijt
NICK_HELP_COMMANDS_LINK
	    LINK       Ms nicket linkelhetsz a tiedhez
	    UNLINK     Trlheted a linkelt nickneveket
NICK_HELP_COMMANDS_OLDLINK
	    LINK       Linkelheted sajt neveid
	    UNLINK     Eltvolthatod a linket
NICK_HELP_COMMANDS_ACCESS
	    ACCESS     Mdosithatod a listt az lestet hozzfrsi cmekrl
NICK_HELP_COMMANDS_AJOIN
	    AJOIN      Mdostja az autojoin listd
NICK_HELP_COMMANDS_SET
	    SET        Set opcik, tartalmazza pl: a kill protection-t
	    UNSET      Trli a nickneved informciit
	    RECOVER    Killelhetsz ms usert, aki megszerezte a neved
	    RELEASE    Visszaszerezhated a nickedet RECOVER parancs hasznlata utn
	    GHOST      Bentragadt nicked killelshez segtsg
	    INFO       Lekrheted az informcikat egy nicknvrl
NICK_HELP_COMMANDS_LIST
	    LIST       Listzhatod az sszes nicknevet, amelyek kaptak mask-ot
	    LISTEMAIL  Listzhatod a nickneveket az E-mail cm alapjn
NICK_HELP_COMMANDS_LISTCHANS
	    LISTCHANS  Listzhatod azokat a csatornkatt, amelyek a nicknvre lettek regisztrlva
	    STATUS     Egy nicknv sttusznak lekrse

NICK_HELP_REGISTER
	Syntax: %s
	
	Regisztrld a nickneved a %S adatbzisba.  Amint a
	nicked regisztrlt, hasznlhatod a SET s az ACCESS
	parancsokat s konfigurlhatod a nicked belltsait
	Lgy biztos abban, hogy a jelszavadra emlkezni fogsz, hogy
	hasznlni tud a belltsokat.Ksbb szksged lehet a
	nickeddel kapcsolatos belltsok vgrehajtsra.
	(Jegyezd meg ezt: PROBLMT OKOZHAT  FIDO, Fido, s fido
	mind klnbz jelszavak!)

NICK_HELP_REGISTER_EMAIL
	
	A nickneved regisztrcijnak tartalmaznia kell egy E-mail cmet;
	vagy bellthasz egyet ksbb a SET EMAIL paraccsal.

NICK_HELP_REGISTER_EMAIL_REQ
	
	Tartalmaznia kell egy E-mail cmet amikor regisztrlod a
	nicknevet.  Megelzheted az E-mail cmed az Info lekrsekor
	trtn kirst a SET HIDE paranccsal (Tovbbi informcirt
	rd be: /msg %S HELP SET HIDE).

NICK_HELP_REGISTER_EMAIL_AUTH
	
	Egy vals E-mail cmet kell megadnod amikor regisztrlod a
	nicknevedet; %S kldeni fog egy zenetet az lestsi kdoddal
	erre a cmre, amit hasznlhatsz az AUTH paraccsal, hogy
	befejezd a nickneved regisztrcijt.Megelzheted az E-mail
	cmed az Info lekrsekor trtn kirst a SET HIDE
	paranccsal (Tovbbi informcirt,rd be:/msg %S HELP SET HIDE).

NICK_HELP_REGISTER_END
	
	Tancsok a jelsz megvltasztshoz:
	
	A jelszavad nem lehet knnyen kitallhat. Pldul,
	a real name-ed jelsznak hasznlni rossz tlet. A
	nicknevedet hasznlni jelsznakmg rosszabb tlet s,
	ezt a %S nem is engedlyezi.  Ezenkvl, a rvid
	jelszavak knnyen kitallhatak, ha valaki keresi, ezrt
	olyan jelszt kell vlasztanod ami legalbb 5 karakter hossz.

NICK_HELP_AUTH
	Syntax: AUTH code
	
	lesteni egy nicknv regisztrcijt vagy E-mail cmet
	vltoztatni.Hogy megbizonyosodj arrl, hogy az E-mail cmed
	helyes, %S kldeni fog neked egy zentet, ami tartalmazza
	az lestsi kdodat arra az E-mail cmre amit a regisztrcinl
	megadtl az E-mail cm cserhez a SET EMAIL parancsot hasznld.
	Ez a parancs lehetsget nyjt, arra hogy megersitsd azt, hogy
	kaptl zenetet s folytasd a a nickneved normlis hasznlatt.
	Helyettests a kdot a parancsba a kilenc karakteres lestsi
	kdot amit az E-mail zenetben kaptl.

NICK_HELP_SENDAUTH
	Syntax: SENDAUTH
	
	Kld szmodra egy msolatot az lestsi kdodrl a REGISZTRCI
	vagy SET EMAIL parancs hasznlata utn.Ha te vletlenl trlted
	vagy ms okbl elvesztetted az lestsi kdodat tartalmaz zeneted,
	akkor hasznlhatod a parancsot,hogy szerezz egy msolatot arrl az
	lestsi kdot tartalmaz zenterl, amit kaptl.
	
	Hogy a visszalst megelzzk, ez a parancs naponta csak
	egyszer hasznlhat.


NICK_HELP_SENDPASS
	Syntax: SENDPASS nicknv
	
	Kld szmodra egy E-mail zentet ami tartalmazza a megadott nicknvhez
	tartoz jelszt arra az E-mail cmre, amit a regisztrcinl megadtl.
	A cmet elszr rvnyesteni kell az AUTH parancs hasznlatval.
	

NICK_HELP_IDENTIFY
	Syntax: IDENTIFY jelsz
	
	Megmutatja %S ,hogy te vagy az igazi tulajdonosa ennek a
	nicknek.  Sok parancs szksges hogy rvnyestsd a nickneved
	mieltt hasznlnd ezt a parancsot. A jelsznak ugyanannak kell
	lennie amit a regisztrcinl megadtl.
	

NICK_HELP_DROP
	Syntax: DROP jelsz
	
	REgisztrci trlse (dropolja) a nickneved a %S
	adatbzisbl. Az a nick ami dropolva van mr
	szabadon hsznlhat brki ltal, hogy jra-regisztrlhassa.
	
NICK_HELP_DROP_LINK
	
	Vigyzz mert amikor droppolod a nicked, az sszes hozzlinkelt nv
	is droppolodik.  Hogy eltvolitsd az hozzlinkelt nevet, hasznld az
	UNLINK parancsot.
NICK_HELP_DROP_END
	
	Hogy meglzzk a vletlen hasznlatt ennek a parancsnak,
	neked be kell rnod a jelszavadat a parancsban amivel droppolod a
	nickneved,azaz trld a regisztrcijt.

NICK_HELP_OLD_LINK
	Syntax: LINK nick jelsz
	
	A nicked msikhoz linkelni , hatsosan ltrehozza a kapcsolatot
	a jelenlegi nicked kztt s a megadott nv kztt. Amikor
	kiadod ezt a parancsot, a hozzfrsi lista a nicknevedhez
	hasznlhat trlssel s helyettestssel msik nicknv adhat hozz
	; minden memo zenet ami a jelenlegi nickedre rkezik hozzaddik a
	linkelt (cl)nv listjhoz.
	
	Minden nicked access jogt megkapja a fnicked.A linkels az unlink
	paranccsal szntetheted meg.Ha droppolod a neved akkor az sszes
	hozzlinkelt nv droppolodik.
	
	Ezen parancs kiadsakor, azonositanod kell magad mint a nick tulajdonosa
	(hasznlva az IDENTIFY parancsot), s tudnod kell annak a nicket is a
	jelszavt, amelyhez linkeldni akarsz.

NICK_HELP_LINK
	Syntax: LINK nick
	
	j nicknv linkelse a nickedhez amit jelenleg hasznlsz,
	ltrehoz egy j "alias"-t a nickedhez. Az j nick is meg fogja
	kapni a jelenlegi nicked access hozzfrseit s opertori
	kivltsgait s memoit; pldul, olvashatsz zeneteket,
	amiket a linkelt nevedre kldtek,
	A linkels megszntetshez az UNLINK parancsot hasznlhatod.
	
	Ezen parancs kiadsakor, azonositanod kell magad mint a nick tulajdonosa
	(hasznlva az IDENTIFY parancsot), s tudnod kell annak a nicket is a
	jelszavt, amelyhez linkeldni/unlinkeldni akarsz.

NICK_HELP_OLD_UNLINK
	Syntax: UNLINK [nick jelsz]
	
	Eltvoltja a linkelst. Amikor a linkels megsznik,
	a nicknv flagjei s access hozzfrsei a korbban linkelt
	nicktl t lesznek msolva a jelenlegi nickedhez s
	s fggetlenl vltoztathat lesz. Az zenetek nem lesznek msolva;
	s minden korbbi zenet trolva marad amit a korbban linkelt nvnek kldtek.
	
NICK_HELP_UNLINK
	Syntax: UNLINK nick
	
	Eltvoltja a linkelst (aliast) amit a nicnevedhez ltrehoztl a
	LINK paranccsal. Nem tudod unlinkelni a jelenlegi nicked, amit jelenleg
	hasznlsz; vltoztass egy msik linkelt nickre elszr mieltt hasznlod
	ezt a parancsot.
	
	Ha a "f nicked" unlinkeled, akkor a SET MAINNICK paranccsal,
	a jelenlegi nicked lesz automatikusan a f nick.

NICK_HELP_LISTLINKS
	Syntax: LISTLINKS
	
	Listzza az sszes nicket amit a nickedhez linkeltl. A f neved
	a linkelt nickek csoportjban jelezve lesz a "*" jellel a baloldaln
	a nicknvnek.

NICK_HELP_ACCESS
	Syntax: ACCESS ADD mask
	        ACCESS DEL mask
	        ACCESS LIST
	
	Mdostja vagy megmutatja a hozzfrsi listt a nickedhez.
	Ez a listja azon cmeknek amelyek automatikusan ugy tekintdnek
	mint a %S engedlyezett nicke.  Ha hasznlni akarod a nicked klnbz
	cmekrl, kldened kell egy IDENTIFY parancsot, hogy gy legyl
	tekintve, mint  %S a nick tulajdonosa.
	
	Examples:
	
	    ACCESS ADD achurch@*.dragonfire.net
	        Engedlyezi a hozzfrst az achurch nicknek brmilyen gprl.
	        aminek a dragonfire.net a domainje.
	
	    ACCESS DEL achurch@*.dragonfire.net
	        Trli az elz parancsot.
	
	    ACCESS LIST
	        Megmutatja a hozzfrsi listt.

NICK_HELP_SET
	Syntax: SET opci paramterek
	
	Bellthat klnbz nicknv opcik.  opci ezek egyike lehet:
	
	    PASSWORD   A nickneved jelszavnak lltsa
	    LANGUAGE   A Services nyelvezetnek megvlasztsa
	    URL        Egy URL trstsa a nicknevedhez
	    EMAIL      Egy E-mail cm trstsa a nicknevedhez
	    INFO       A szveg belltsa, ami az INFO parancs hasznlatakor lszik
	    KILL       A kill protection be/ki kapcsolsa
	    SECURE     A nickneved vdelmnek be/ki kapcsolsa
	    PRIVATE    A nickneved /msg %S LIST parancs listjbl val elrejts
	    HIDE       A nicknvhez tartoz informcik elrejtse
	    TIMEZONE   Az idzna belltsa
NICK_HELP_SET_OPTION_MAINNICK
	    MAINNICK   A f nickneved ami a csatornk access listjn szerepelni fog.
NICK_HELP_SET_END
	
	Ahhoz, hogy hasznld ezt a parancsot, elszr hasznlnod kell az identify
	parancsot.  (Tovbbi informcirt, rd be: /msg %S HELP IDENTIFY).
	
	Tovbbi informcirt, rd be: /msg %S HELP SET opci
	
NICK_HELP_SET_PASSWORD
	Syntax: SET PASSWORD j-jelsz
	
	Megvltoztatja a nicknv tulajdonosnak jelszavt.

NICK_HELP_SET_LANGUAGE
	Syntax: SET LANGUAGE szm
	
	Megvltoztatja a SERVICES nyelvezett, amin az zenteket rja.
	(Pldul: amikor vlaszol egy parancsra, amit te adtl ki).
	szm ki kell vlasztanod a neked megfelelt nyelveket tartalmaz
	listbl:
	

NICK_HELP_SET_URL
	Syntax: SET URL url
	
	Egy URL trsts a nicknevedhez .Ez az URL szerepelni fog
	az INFO-id kztt, amit brki lekrhet az INFO paranccsal.

NICK_HELP_SET_EMAIL
	Syntax: SET EMAIL cm
	
	Egy E-mail cm trstsa a nicknevedhez.
	Ez az E-mail cm szerepelni fog az INFO-id kztt,
	amit brki lekrhet az INFO paranccsal.
	
NICK_HELP_SET_INFO
	Syntax: SET INFO szveg
	
	Egy szveg trstsa a nicknevedhez; Ez az szveg szerepelni
	fog az INFO-id kztt, amit brki lekrhet az INFO paranccsal.



NICK_HELP_SET_KILL
	Syntax: SET KILL {ON | QUICK | IMMED | OFF}
	
	Be/kikapcsolja az automatikus kill protection opcit a
	nickedhez.  A kill protection bekapcsolsakor, ha ms user
	megprblja hasznlni a nicked, kap egy percet mieltt
	meg kell vltoztatnia a nickjt egy msikra, ha letelt az id
	akkor ki lesz killelve az IRC-rl a %S ltal.
	
	Ha a QUICK -et vlasztod, a user csak 20 msodpercet kap
	a nickvltsra eltren az ltalnos 60 msodperctl.
	Ha az IMMED -et vlasztod a user azonnal ki lesz killelve
	Figyelmeztets nlkl vagy kap egy eslyt a nickvltsra;
	krlek ne hasznld ezt az opcit csak ha nagyon indokolt.
	Viszont, a network adminisztrtorok letilthatjk ezt az opcit.

NICK_HELP_SET_SECURE
	Syntax: SET SECURE {ON | OFF}
	
	Be/kikapcsolja a %S biztonsgi opciit a nicknevedhez.
	A SECURE belltssal, be kell rnod a jelszavadat
	mieltt a nicknv tulajdonsaknt leszel tekintve,
	
NICK_HELP_SET_PRIVATE
	Syntax: SET PRIVATE {ON | OFF}
	
	Be/kikapcsolja a %S privt opcit a nicknevedhez.
	A PRIVATE belltssal, bellthatod azt hogy
	a nickneved ne szerepeljen a nicknv listban ami lekrhet a
	%S LIST paranccsal.
	(Msklnben, brki kaphat informcit a nicknevedrl hasznlva az
	INFO parancsot.)

NICK_HELP_SET_HIDE
	Syntax: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Lehetsget nyjt arra hogy megelzd nhny informcinak a
	szerepelst az INFO parancs hasznlatakor lekrt informcik kzl.
	Elrejtheted az E-mail cmed (EMAIL), az utoljra hasznlt
	user@host maszkod (USERMASK), s az utols kilp zeneted(QUIT).
	A msodik paramter meghatrozza, hogy az opci ki legyen kapcsolva(OFF)
	vagy el legyen rejtve az informci(ON).

NICK_HELP_SET_TIMEZONE
	Syntax: SET TIMEZONE {UTC-offset | time-zone | DEFAULT}
	
	Bellthatod az idznt ami szerint az idt ltni szeretnd
	(mondjuk egy nicknv vagy csatorna utols hasznlatnak idejrl
	kapott infban), ha a Services ltal hasznlt idznt szeretnd;
	a DEFAULT bellts hasznlhat,hogy belltsd a Services' idznjt.
	
	MEgjegyzs a Services nem fog automatikus tllni az ideltolodskor
	(nyri idszmts); nekem kell belltanod.
	
	Examples:
	
	    SET TIMEZONE -5
	        Belltja az idznt 5 rval az UTC utnra.
	
	    SET TIMEZONE +3:30
	        Belltja az idznt 3 ra, 30 percre az UTCtl elrbb .
	
	    SET TIMEZONE JST
	        Belltja a Japan Standard Time szerinti idznt (UTC+9:00).

NICK_HELP_SET_MAINNICK
	Syntax: SET MAINNICK nick
	
	Ha tbb nicket linkelsz ssze meg kell
	vlasztanod a f nicked (main nick).
	Ez a nick lesz az ssze linkelt neveid
	kzl amelyik minden hozzfrsi jogot
	megkap.

NICK_HELP_UNSET
	Syntax: UNSET {URL | EMAIL | INFO}
	
	Engedlyezi, hogy trld az URL-t (URL), E-mail cmet (EMAIL),
	vagy az informcis szveget (INFO) amit a nickedhez trstottl.

NICK_HELP_UNSET_REQ_EMAIL
	Syntax: UNSET {URL | INFO}
	
	Engedlyezi, hogy trld az URL-t (URL), E-mail cmet (EMAIL),
	vagy az informcis szveget (INFO) amit a nickedhez trstottl.

NICK_HELP_RECOVER
	Syntax: RECOVER nicknv [jelsz]
	
	Amikor engedlyezed ezt az opcit, a %S fel fog hozni egy
	l felhasznlt ugyanazzal a nvvel, amit vissza
	akarsz venni a msik nvtol. Ennek kvetkeztben
	az IRC szerver megbontja a msik felhasznl kapcsolatt.
	A %S l felhasznlja online marad %s hogy
	a msik felhasznl ne tudjon automatikusa jracsatlakozni;
	ezutn az id letelte utn, te felveheted
	a nevedet.Alternatv megolds,
	a RELEASE parancs hasznlata (/msg %S HELP RELEASE)
	ezzel hamarabb is visszakaphatod a neved.
	
	Abban az esetben ha hasznlod a RECOVER parancsot, akkor
	tudnod kell a pontos jelszt a nickhez vagy be kell azonostanod
	"identify"-zned egy olyan nickre, amely linkelve van a megadott
	nickhez.

NICK_HELP_RELEASE
	Syntax: RELEASE nicknv [jelsz]
	
	Utastja a %S -et, hogy ne tartsa tovbb az
	automatikus kill vdelem vagy a RECOVER
	parancs hasznlatbl kifolylag felvett neved.
	Alapbellts szerint csak %s; tartja, de
	ezzel a paranccsal hamarabb tveheto jra a neved.
	
	Ha a RELEASE parancsot akarod hasznlni, tudnod kell a
	pontos jelszt a nickhez vagy be kell azonostanod "identify"-zned
	egy olyan nickre, amely linkelve van a megadott nickhez.

NICK_HELP_GHOST
	Syntax: GHOST nicknv [jelsz]
	
	Ezt a parancsot akkor hasznlhatod ha a nicked beragad, befagy
	pldul lefagy a gped vagy a kapcsolatod.A bent ragadt nicked
	killelheted, ha ismered a jelszt a nickhez vagy be kell azonostanod
	egy olyan nickre, amely linkelve van a befagyott nickedhez.
	
NICK_HELP_INFO
	Syntax: INFO nicknv [ALL]
	
	Megmutatja a megadott nicknvvel kapcsolatos informcikat, mint pl:
	a nick tulajdonosa, utoljra ltott cme s ideje, s a nick
	opcikat. Ha beazonostasz egy nickre akkor teljes informacikat
	kaphatsz az ALL parancs hasznlatval s ltni fogod a rejtett
	informcikat is.

NICK_HELP_INFO_AUTH
	
	Ha a nickneved E-mail cmed mg nincs biztostva az
	AUTH parancs hasznlatval nem fog megjelenni a
	regisztrlt nicknevek listjn.
	
NICK_HELP_LISTCHANS
	Syntax: LISTCHANS
	
	Listzza az sszes nicknevet, csatornt ami a te nicked
	alatt lett regisztrlva.

NICK_HELP_LIST
	Syntax: LIST pattern
	
	Listzza az sszes regisztrlt nicknevet kivve azokat,
	amelyeken fent van PRIVATE opci bellts.
	
	Examples:
	
	    LIST joeuser@foo.com
	        Listzz minden regisztrlt nicknevet, amelyet utoljra:
	        joeuser@foo.com cmrl hasznltak.
	
	    LIST *Bot*
	        Listzz minden nicket amelyben szerepelt a Bot
	
	    LIST *@*.bar.org
	        Listzz minden nicket amit utoljra olyan user hasznlt akinek
	        a bar.org volt a domain-je.

NICK_HELP_LIST_OPERSONLY
	
	Csak IRC opertorok hasznlhatjk ezt a parancsot.

NICK_HELP_LISTEMAIL
	Syntax: LISTEMAIL pattern
	
	Listzza a regisztrlt nicknevek mint a LIST parancs, de
	kirja az E-mail cmeket is s a user@host cmeket.
	Tekintsd meg a LIST parancs helpjt (/msg %S HELP LIST).

NICK_HELP_STATUS
	Syntax: STATUS nicknv...
	
	A kvetkezket kapod, ha a nicknvre, amit a felhasznl hasznl
	azonostotta magt mint tulajdonos. Az eredmny formja a kvetkez:
	
	    nicknv sttusz-kd
	
	ahol a nicknv az a nicknv amit kldtl a parancsban, s
	a sttusz-kd a kvetkez lehet:
	
	    0 - nincs ilyen user online vagy a nick nem regisztrlt
	    1 - a felhasznl nem azonostott, mint a nick tulajdonosa
	    2 - A felhasznl azonostott, mint tulajdonos csak a hozzfrsi lista alapjn
	    3 - A felhasznl azonostott, mint tulajdonos a jelszava alapjn
	
	
NICK_HELP_AJOIN
	Syntax: AJOIN ADD csatorna
	        AJOIN DEL csatorna
	        AJOIN LIST
	
	Mdostja vagy megjelenti az nicknevedhez tartoz autojoin listt.
	Ez a lista azon csatornkat tartalmazza, melyekbe automatikusan
	be akarsz lpni, ennek akkor van hatsa, ha mr beazonostottl a %S fel.
	Csak olyan csatornkat helyezhetsz el az autojoin listn, melyek
	"#" jellel kezddnek (helyi csatornk nem adhatak hozz).
	
NICK_HELP_AJOIN_END
	Megjegyzs: az IRC server megtilthatja, hogy belpj nhny csatornra
	az autojoin listdrl, mint pldul melyek csatornajelszval vdettek,
	(mode +k) vagy csak meghvsra lehet belpni (mode +i).
NICK_HELP_AJOIN_END_CHANSERV
	Megjegyzs: az IRC server megtilthatja, hogy belpj nhny csatornra
	az autojoin listdrl, mint pldul melyek csatornajelszval vdettek,
	(mode +k) vagy csak meghvsra lehet belpni (mode +i).
	Habr, ha van hozzfrsed a %s INVITE parancshoz
	egy regisztrlt csatornn, akkor a %S automatikus meg fog hvni a
	csatornra tged.

NICK_OPER_HELP_COMMANDS
	
	A kvetkez parancsok llnak a Services adminok rendelkezsre:
	
	    DROPNICK   Nicknv droppolsa
NICK_OPER_HELP_COMMANDS_DROPEMAIL
	    DROPEMAIL  Dropol minden nicknevet, aminl szerepel a
	                   megadott E-mail cm
NICK_OPER_HELP_COMMANDS_GETPASS
	    GETPASS    Nicknv jelszavnak megtekintse
	                   (csak, ha az encryption nem aktv)
NICK_OPER_HELP_COMMANDS_FORBID
	    FORBID     Egy nick hasznlatnak/regisztrlsnak letiltsa
	    SUSPEND    Egy nick hasznlatnak felfggesztse
	    UNSUSPEND  Felfggeszts eltvoltsa egy nickrl
NICK_OPER_HELP_COMMANDS_LISTLINKS
	    LISTLINKS  Listzza egy adott nickhez linkelt nickeket
NICK_OPER_HELP_COMMANDS_SETAUTH
	    SETAUTH    j lestsi kd megadsa
	    GETAUTH    lestsi kd megtekintse
	    CLEARAUTH  lestsi kd trlse
NICK_OPER_HELP_COMMANDS_END
	
	Services adminok hasznlhatjk a kvetkez parancsokat is brmelyik nicknven
	anlkl, hogy be kellenne azonostaniuk magukat jelszval:
	
	    SET, ACCESS LIST, INFO ALL
	
	Nzd meg a parancsokhoz tartoz helpet a klnleges rszletekrt.

NICK_OPER_HELP_DROPNICK
	Syntax: DROPNICK nicknv
	
	Trli az nicknv regisztrcijt a %S adatbazisbl, s termszetesen
	minden hozzlinkelt nevet
	
	Limitlva Services adminoknak.

NICK_OPER_HELP_DROPEMAIL
	Syntax: DROPEMAIL plda
	        DROPEMAIL-CONFIRM plda
	
	Dropol minden nicknevet, aminl szerepel az E-mail cm,
	melyet megadtl a pldban.  Ha a plda egy egyszer
	karakter: "-", dropol minden nicknevet, melynl nincs E-mail
	cm trstva.
	
	Hogy megelzzk a balesetszer nicknv dropolsokat ezen a
	parancson keresztl, ktszer kell megadni: elszr hasznlva
	a DROPEMAIL parancsot majd hasznlva a DROPEMAIL-CONFIRM
	ugyanazzal a pldval.  A DROPEMAIL-CONFIRM parancs meg kell
	adni %s s ugyannak a szemlynek, aki kiadta a
	DROPEMAIL parancsot.  Ha tbb mint 4 DROPEMAIL parancs van
	megadva egy sorban a legrgebbi elfelejtdik s tovbbiakban
	nem fog reaglni a DROPEMAIL-CONFIRM parancsra.
	
	Limitlva Services adminoknak.

NICK_OPER_HELP_SET
	
	Services adminok hasznlhatjk a NOEXPIRE (nem elvl) opcit is,
	azokon a nickeken, amelyeket meg akarnak elzni az elvlstl.
	Mellesleg, Services admins minden set opcit hasznlhatnak
	brmelyik nicknven jelsz bersa nlkl, a kvetkez forma hasznlatval:0
	SET nicknv opci paramterek.

NICK_OPER_HELP_SET_NOEXPIRE
	Syntax: SET [nickname] NOEXPIRE {ON | OFF}
	
	Bellthat, ha a megadott nick elvl.  Az ON opcival
	megelzheted, hogy a nicknv elvljn.  Ha nincs megadott
	nicknv, akkor a nem-elvl bellts a sajt nickeden hajtja vgre.
	
	Limitlva Services adminoknak.

NICK_OPER_HELP_UNSET
	
	Services adminok hasznlhatjk az UNSET parancsot brmelyik nicknven
	tartalmazva a nicknevet a opcinv  eltt, mint a
	SET parancsnl.

NICK_OPER_HELP_OLD_UNLINK
	
	Services adminok unlinkelhetik brmelyik nicket anlkl, hogy bernk a
	jelszavt.

NICK_OPER_HELP_UNLINK
	Syntax: UNLINK nick [FORCE]
	
	Eltvoltja a linket (aliast) amit a nicknevedhez a LINK paranccsal
	hoztl ltre.Nem unlinkelheted azt a nicket, amit ppen hasznlsz
	;elszr  vltoztas egy msik linkelt nickre mieltt
	hasznlod ezt a parancsot.
	
	Ha a "f nicked" unlinkeled, akkor a SET MAINNICK paranccsal,
	a jelenlegi nicked lesz automatikusan a f nick.
	
	Services adminok hozzadhatjk a FORCE opcit, amely lehetv teszi
	ms nick linkelsnek eltvoltst, mint ami a sajtjuk.

NICK_OPER_HELP_OLD_LISTLINKS
	Syntax: LISTLINKS nick
	
	Listzza a megadott nickhez linkelt nickeket.
	
	Limitlva Services adminoknak.

NICK_OPER_HELP_LISTLINKS
	Syntax: LISTLINKS [nick]
	
	Listzza az sszes nicket amit a nickedhez linkeltl. A f neved
	a linkelt nickek csoportjban jelezve lesz a "*" jellel a baloldaln
	a nicknvnek.  Services adminok listzhatjk ms nickekhez tartoz
	linkeket meghatrozva a parancsban az adott nicket.

NICK_OPER_HELP_ACCESS
	
	Services adminok megadhatnak nicknvhez paramtert a LIST
	paranccsal megjelenithet az access lista brmelyik nicknvhez.

NICK_OPER_HELP_INFO
	
	Services adminok hasznlhatjk az ALL paramtert brmelyik nickhez.

NICK_OPER_HELP_LISTCHANS
	
	Services adminok listzhatjk a csatornkat brmelyik nicknvhez
	megadva a nicknevet a parancsban (pldul,
	/msg %S LISTCHANS MsikNick).

NICK_OPER_HELP_LIST
	Syntax: LIST sablon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Listz minden registrlt nicknevet, amely vagy nicknv
	vagy az utoljra ltott address (user@host formatumban), amely
	egyezik a megadott sablonnal.  Nickek PRIVATE opcival belltva
	csak Services adminoknak jelennek meg.  Services adminoknak,
	a nickek NOEXPIRE opcival belltva ! megelzve (prefix)
	jelennek meg azok pedig, amelyek hasznlata fel lett fggesztve
	* megelzve (prefix) fognak megjelenni. Pl: !nick *nick
	
	Ha FORBIDDEN, SUSPENDED vagy NOEXPIRE opci meg van adva,
	csak azok a nickek amelyek, klcsnsen forbidoltak s suspendeltek, vagy
	a NOEXPIRE opci bellts megjelenik.  Ezek az opcik
	hasznlhatak brmilyen sorrendben vagy kombinciban.  Ezek
	az opcik limitltak Services adminoknak.
	
	Pldk:
	
	    LIST joeuser@foo.com
	        Listzz minden regisztrlt nicknevet amit utoljra errl a hostrl hasznltak:
	        joeuser@foo.com.
	
	    LIST *Bot*
	        Listz minden registerlt nicknevet amiben szerepel a Bot
	         (lehet hatstalan).
	
	    LIST * NOEXPIRE
	        Listzz minden registrlt nicknevet ameylre be van lltva a nem
	        elvl opci.
	

NICK_OPER_HELP_LIST_AUTH
	Syntax: LIST sablon [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Listz minden regisztrlt nicknevet, amely vagy egy nicknv
	vagy az utoljra hasznlt address (user@host formtumban), ami megegyezik
	a megadott sablonnal.  Nickek PRIVATE opci belltssal csak
	Services adminoknak fognak megjelenni.  Services adminoknak,
	nickek NOEXPIRE opci belltssal ! megelzve (prefix)
	jelennek meg azok pedig, amelyek hasznlata fel lett fggesztve
	* megelzve (prefix) fognak megjelenni. Pl: !nick *nick
	s azok, amelyek mg nem lettek lestve (az
	AUTH parancs hasznlatval) ? fogja megelzni (prefix).Pl: ?nick
	
	Ha a FORBIDDEN, SUSPENDED, NOEXPIRE, vagy NOAUTH opcik megvannak
	adva, csak azok a nickek amelyek klcsnsen forbidoltak,
	suspendeeltek, NOEXPIRE opci be van lltva rjuk, vagy mg nem lestettek
	meg fognak jellenni. Az opcik hasznlhatak brmilyen
	sorrendben vagy kombinciban.  Ezek az opcik
	limitlva Services adminoknak.
	
	Pldk:
	
	    LIST joeuser@foo.com
	        Listz minden regisztrlt nicknevet amit utoljra errl a hostrl hasznltak:
	        joeuser@foo.com.
	
	    LIST *Bot*
	        Listz minden registerlt nicknevet amiben szerepel a Bot
	         (lehet hatstalan).
	
	    LIST * NOEXPIRE
	        Listz minden regisztrlt nicknevet amelyben be van lltva a nem elvl
	        opci.

NICK_OPER_HELP_LISTEMAIL
	Syntax: LISTEMAIL sablon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Listzza a regisztrlt nickneveket mint a LIST parancsnl, de
	szerepelni fog az email cm tartalmazva a user@host addresst.
	Nzd meg a LIST parancs helpjt (/msg %S HELP LIST) bvebb
	informcikrt..

NICK_OPER_HELP_LISTEMAIL_AUTH
	Syntax: LISTEMAIL sablon [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Listzza a regisztrlt nickneveket mint a LIST parancsnl, de
	szerepelni fog az email cm tartalmazva a user@host addresst.
	Nzd meg a LIST parancs helpjt (/msg %S HELP LIST) bvebb
	informcikrt..

NICK_OPER_HELP_GETPASS
	Syntax: GETPASS nicknv
	
	Returns the password for the given nickname.  Note that
	whenever this command is used, a message including the
	person who issued the command and the nickname it was used
	on will be logged and sent out as a WALLOPS/GLOBOPS.
	
	If encryption is in use, this command may not be available
	depending on the type of encryption used.
	
	Limited to Services admins.

NICK_OPER_HELP_FORBID
	Syntax: FORBID nickname
	
	Megtiltja egy nicknv regisztrlst s hasznlatt.
	Eltnik, olyan mintha droppoljk a nicket.
	
	Limitlva Services adminoknak.

NICK_OPER_HELP_SUSPEND
	Syntax: SUSPEND [+elvls] nicknv indok
	
	Megelzi, hogy egy nicknevet, s minden hozz linkelt nicknevet
	hasznljanak, beazonostsanak r. A nicknv unsuspendelhet
	az UNSUSPEND paranccsal, ami lehetv teszi, hogy
	tovbbra is hasznljk, mint korbban.
	Az elvls paramter ugyanolyan, mint az
	%s AKILL parancs esetben.
	
	Limitlva: Services adminoknak.

NICK_OPER_HELP_UNSUSPEND
	Syntax: UNSUSPEND nicknv
	
	Trli egy adott nicknv korbbi suspendjt s lehetv teszi
	az jbli hasznlatt.
	
	Limitlva Services adminoknak.

NICK_OPER_HELP_AJOIN
	
	Services adminok listzhatjk az brmelyik nickhez tartoz autojoin listt
	ezzel a formtummal LIST nicknv.

NICK_OPER_HELP_SETAUTH
	Syntax: SETAUTH nicknv
	
	Bellt egy j lestsi kdot a megadott nicknvhez. A
	nicknv tulajdonosnak hasznlni kell az AUTH parancsot a
	nicknv hasznlathoz mieltt jra beazonosthatna.  Ha a
	nicknv jelenleg is hasznlatban van, egy megjegyzs lesz kldve
	a nicknv hasznljnak s  nem hasznlhatja tbbet a nicknevet
	beazonosts nlkl
	
	Limitlva Services adminoknak.
	
NICK_OPER_HELP_GETAUTH
	Syntax: GETAUTH nicknv
	
	Visszaszerzi a nicknvhez tartoz lestsi kdot,
	ha mr van megadva.
	
	Limitlva Services adminoknak.

NICK_OPER_HELP_CLEARAUTH
	Syntax: CLEARAUTH nicknv
	
	Trl minden a nicknvhez tartoz lestsi kdot,
	lehetv tve a nick normlis hasznlatt.
	
	Limitlva Services adminoknak.


###########################################################################
#
# ChanServ help messages
#
###########################################################################

# Used in OP/VOICE/etc for required access levels for commands
CHAN_HELP_REQSOP_LEVXOP
	level 100 (SOP)
CHAN_HELP_REQSOP_LEV
	level 100
CHAN_HELP_REQSOP_XOP
	SOP
CHAN_HELP_REQAOP_LEVXOP
	level 50 (AOP)
CHAN_HELP_REQAOP_LEV
	level 50
CHAN_HELP_REQAOP_XOP
	AOP
CHAN_HELP_REQHOP_LEVXOP
	level 40 (HOP)
CHAN_HELP_REQHOP_LEV
	level 40
CHAN_HELP_REQHOP_XOP
	HOP
CHAN_HELP_REQVOP_LEVXOP
	level 30 (VOP)
CHAN_HELP_REQVOP_LEV
	level 30
CHAN_HELP_REQVOP_XOP
	VOP

# A Valdi help zenetek itt kezddnek
CHAN_HELP
	A %S lehetsget ad szmodra, hogy csatornt regisztrlhass.
	A %S hasznlatval elkerlhet a szobdban a "taking over"
	jelensg, amit az opjoggal visszal userek okozhatnak, mg pedig
	olyan mdon, hogy meghatrozhat az, hogy ki kaphasson a csatornn
	opertori kivltsgokat. rd be: /msg %S HELP COMMANDS, hogy
	megkapd a rendelkezsedre ll parancsok s lehetsgek listjt,
	ha a %S -et hasznlod; a parancsok hasznlathoz rd be:
	/msg %S parancs, vagy ha tbb informcira van szksged a paranccsal
	kapcsolatban, akkor rd be: /msg %S HELP parancs.
CHAN_HELP_EXPIRES
	
	Megjegyzs: azok a csatornk, amelyeket nem hasznlnak %s
	lefogsa utn, automatikusan elvesztik regisztrcijukat.

CHAN_HELP_COMMANDS
	A kvetkez parancsok hasznlhatk a %S en:
	
	    REGISTER   Csatorna regisztrlsa
	    IDENTIFY   Azonosthatod magad a jelszavaddal
CHAN_HELP_COMMANDS_SENDPASS
	    SENDPASS   Elkldetheted magadnak a csatornd jelszavt
CHAN_HELP_COMMANDS_DROP
	    DROP       Trlheted a csatornd regisztrcijt
	    SET        Bellthatod a csatornd opciit
	    UNSET      Trlheted a csatorna belltskat
	    INFO       Megtekintheted a csatorna informciit s belltsait
CHAN_HELP_COMMANDS_LIST
	    LIST       Listzhatad a regisztrlt csatornkat
CHAN_HELP_COMMANDS_AKICK
	    AKICK      AutoKirugs listra teheted a "rossz" usereket
CHAN_HELP_COMMANDS_LEVELS
	    ACCESS     A szoba hozzfrsi listjnak belltsa
	    LEVELS     tllthatod a csatorna hozzfrsi szintjeit
CHAN_HELP_COMMANDS_XOP
	    SOP        SuperOpertor lista belltsa
	    AOP        AutoOpertor lista belltsa
	    VOP        AutoHangadk listjnak belltsa
CHAN_HELP_COMMANDS_HOP
	    HOP        Autoflopertorok listjnak belltsa
CHAN_HELP_COMMANDS_OPVOICE
	    OP         Ideiglenes opertor sttusz adsa (+o)
	    DEOP       Ideiglenes opertor sttusz elvtele (-o)
	    VOICE      Ideiglenes hangads sttusz adsa(+v)
	    DEVOICE    Ideiglenes hangads sttusz elvtele(-v)
CHAN_HELP_COMMANDS_HALFOP
	    HALFOP     Ideiglenes flopertor sttusz ads (+h)
	    DEHALFOP   Ideiglenes flopertor sttusz elvtele (-h)
CHAN_HELP_COMMANDS_PROTECT
	    PROTECT    Vdettsg adsa(+a)
	    DEPROTECT  Vdettsg elvtele (-a)
CHAN_HELP_COMMANDS_INVITE
	    INVITE     Meghvhatod magad a csatornra (pl: +i chmode estre hasznos)
	    UNBAN      Leveheted a tiltst magadrl a csatornn
	    KICK       Kirghatsz egy usert a csatornrl
	    TOPIC      Megvltoztathatod a topic-ot
	    CLEAR      Leveszi a szobamdokat vagy eltvolt minden usert
	    STATUS     Megkaphatod egy user hozzfrsi szintjt a csatornn

CHAN_HELP_REGISTER
	Syntax: REGISTER szobanv jelsz lers
	
	A csatorndat regisztrlja a %S adatbzisba.
	Hogy kiadhasd ezt a paracsot opertornak kell lenned
	az adott csatornn.
	A jelszt hasznlhatod az IDENTIFY parancs segitsgvel
	azonostsra, mieltt belltsokat eszkzlsz a ksbbiekben
	az adott csatonn.
	
	Az utols paramternek,tartalmaznia kell
	a csatorna ltalnos meghatrozst.
	
	Amikor regisztrlsz egy csatornt, te leszel a "founder".
	A csatorna founderjnek van lehetsge a szoba belltsokat
	az hozzfrsi listt, az autkirgs listt, az infkat
	megvltoztatni; a %S automatikusan megadja belpskor a
	founder hozzfrsi jogot s csatorna opertori jogokat.
	Nzd meg az ACCESS parancsot (/msg %S HELP ACCESS)
	,hogy infomldj a klnbz szint kivltsgok adsrl
	(a csatorna tbbi felhasznlja rszre).
	
	Megjegyzs: Ha regisztrlsz egy csatornt, elszr regisztrlnod kell
	a nickneved s azonostanod kell magad(/ns identify jelsz)Ha mg nem
	nzted meg, /msg %s HELP pp itt az id,hogy informldj mit hogyan csinlj.
CHAN_HELP_REGISTER_ADMINONLY
	
	Csak Services adminok regisztrlhatnak szobt.

CHAN_HELP_SENDPASS
	Syntax: SENDPASS csatorna
	
	Elkldi E-mailben a csatorndra belltott jelszt.
	Neked a csatorna founderjnek kell lenned,
	hogy hasznlhasd ezt a parancsot s elszr
	azonostanod kell magadat a %s IDENTIFY paranccsal.

CHAN_HELP_IDENTIFY
	Syntax: IDENTIFY csatorna jelsz
	
	A %S a parancs bersa utna founder szintet ad a csatornn.
	Tbb parancs szksges, hogy hasznlhasd ezt a parancsot.
	A jelsznak egyeznie kell a regisztrcikor megadott jelszval.

CHAN_HELP_DROP
	Syntax: DROP csatorna
	
	Trli a megnevezett csatorna regisztrcijt.Csak a
	csatorna founder hasznlhatja,akinek elszr
	hasznlnia kell az IDENTIFY parancsot.

CHAN_HELP_SET
	Syntax: SET csatorna opci paramterek
	
	Lehetsget ad a foundernek, hogy a belltsokat
	s informcikat megvltotassa.A foundernek az IDENTIFY
	parancsot kell hasznlnia mieltt a SET paracsokat hasznln.
	
	Elrhet opcik:
	
	    FOUNDER     A founder megvltoztatsa
	    SUCCESSOR   A successor megadsa
	    PASSWORD    A founder jelsz vltoztatsa
	    DESC        A szobameghatrozs llts
	    URL         Egy URL trstsa a szobhoz
	    EMAIL       Egy E-mail cm trstsa a szobhoz
	    ENTRYMSG    A belpzenet lltsa
	    KEEPTOPIC   A topic megtartsa, ha a szoba nincs hasznlatban
	    TOPICLOCK   Topic lezrsa (topicvlts: /cs set #szoba topic szveg)
	    MLOCK       Szoba mdok lezrsa (+flag -flag)
	    PRIVATE     A szoba elrejtse a listbl
	    RESTRICTED  Korltozott hozzfrs
	    SECURE      Aktivlja a %S biztonsgi lehetsgeit
	    SECUREOPS   A csatornn opads szigoru kezelse(csak accesses user kaphat)
	    LEAVEOPS    Nem veszi el az op-ot a szobanyittl
	    OPNOTICE    zenetet kld az OP/VOICE parancsok hasznltrl
	    ENFORCE     Megvdi az auto-op, auto-voice sttuszt (nincs deop,devoice)
	
	Tovbbi informcirt egy adott opcirl rd be:
	/msg %S HELP SET opci.

CHAN_HELP_SET_FOUNDER
	Syntax: SET csatorna FOUNDER nick
	
	Megvltoztatja a csatorna founderjt.
	Az j nv regisztrlt kell, hogy legyen

CHAN_HELP_SET_SUCCESSOR
	Syntax: SET csatorna SUCCESSOR nick
	
	MEgvltoztatja a successort a csatornn.Ha a founder neve
	elvl vagy drop-olodik, de a csatornamg regisztrlt,
	a successor lesz a csatorna j founderje.
	Ha, a successornak mr tl sok regisztrlt
	csatornja van (%d), a csatorna drop-olodik, azaz
	megsznik a regisztrcija, akkor is ez trtnik,
	ha nem volt megadott successor. A nicknek regisztrlnak
	kell lennie.

CHAN_HELP_SET_PASSWORD
	Syntax: SET csatorna PASSWORD jelsz
	
	Belltja a founder jelszt a csatornra, amivel
	a founder azonosthatja magt.

CHAN_HELP_SET_DESC
	Syntax: SET csatorna DESC meghatrozs
	
	Bellthat a szoba ltalnos meghatrozsa
	ami ltszdni fog a  LIST s INFO parancs hasznlata esetn.

CHAN_HELP_SET_URL
	Syntax: SET csatorna URL url
	
	Egy URL trstsa a szobhoz.Ha van honlapja a szobnak,
	akkor azt brki megtudhatja, ha lekrte a szobrl az INFO-t.

CHAN_HELP_SET_EMAIL
	Syntax: SET csatorna EMAIL E-mail cm
	
	Egy E-mail cm trstsa a szobhoz.Ha van E-mail cme
	a szobnak, a foundernek; akkor azt brki
	megtudhatja, ha lekrte a szobrl az INFO-t.

CHAN_HELP_SET_ENTRYMSG
	Syntax: SET csatorna ENTRYMSG belp zenet
	
	Ez egy zenet, amit minden belp user megkap /NOTICE
	formjban, aki belp belp a szobba.

CHAN_HELP_SET_KEEPTOPIC
	Syntax: SET csatorna KEEPTOPIC {ON | OFF}
	
	Engedlyezi vagy letiltja a topic megtartsa opcit a
	csatorna rszre.  Ha a topic megtartsa be van lltva,
	a topicot a %S megjegyzi miutn az utols user elhagyja a szobt
	, s visszalltja a kvetkez megnyitskor.

CHAN_HELP_SET_TOPICLOCK
	Syntax: SET channel TOPICLOCK {ON | OFF}
	
	Engedlyezi vagy letiltja a topic lezrsa opcit a csatornn.
	Ha a topic lezrsa be van kapcsolva,a %S nem engedlyezi a
	csatornn a topic vltoztatst a TOPIC paranccsal.Csak a
	/cs set #szobanv topic szveg paranccsal llthat a topic.

CHAN_HELP_SET_MLOCK
	Syntax: SET csatorna MLOCK mdok
	
	Bellthatod a mode-lock paramtert a csatornn.A  %S
	lehetsget nyjt arra, hogy meghatrozz csatorna mdokat amik mindig
	be (vagy ki)lesznek kapcsolva.  Minden binris md
	(n, s, t, k, l, s gy tovbb)
	lockolhat; nhny md lockolhat, a lockols levehet, vagy nem
	lockolhat. A mdok paramter felrakhatak a kvetkez mdon is
	/MODE parancs; azok a mdok amelyek a + jel utn vannak lockoldnak,
	s azok a mdok amelyek a - jel utn vannak nem rakhatak fel a szobra.
	
	Figyelmeztets:  Ha belltasz egy mode-lock alatti kulcsot,
	mint azt a msodik pldban ltod, akkor be kell lltanod a
	RESTRICTED opcit a csatornn (lsd HELP SET RESTRICTED)
	vagy brki belphet a szobba amikor res s lehetsge lesz
	megltni a kulcsot!  MLOCK +i nem elzi meg, hogy belpjenek
	a szobdba amikor res, meghvs nlkl.
	
	Pldk:
	
	    SET #csatorna MLOCK +nt-ikl
	        Az  "n" s a "t" llandan fent van, s az "i", "k", s "l" llandan.
	        ki lesz kapcsolva.Minden ms md felraksa-levtele szabad.
	
	    SET #csatorna MLOCK +knst-ilmp my-key
	        A "k", "n", "s", s "t" llandan fent van, s az "i", "l", "m",
	        s a "p" ki lesz kapcsolva.  A szobba val belpshez szksges jelsz:
	        "my-key".
	
	    SET #channel MLOCK +
	        Eltvoltja az sszes lockolt mdot.
	        Minden md szabadon ki/bekapcsolhat.

CHAN_HELP_SET_HIDE
	Syntax: SET csatorna HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
	
	Lehetsget nyjt a szoba informcinak lekrsekor kirsra
	kerl adatok kzl az email, a topic, az mlock elrejtsre.
	A topic, akkor sem ltszik ha a szoba rejtett (+s).

CHAN_HELP_SET_PRIVATE
	Syntax: SET csatorna PRIVATE {ON | OFF}
	
	Engedlyezi vagy letiltja a private opcit a csatornn.
	Amikor a private be van kapcsolva, a /msg %S LIST parancs
	ltal kilistzott csatornk kztt nem szerepel a csatorna.

CHAN_HELP_SET_RESTRICTED
	Syntax: SET csatorna RESTRICTED {ON | OFF}
	
	Engedlyezi vagy letiltja a restricted access opcit a
	csatornn. Amikor a restricted access be van kapcsolva,
	a userek nem kaphatnak csatorna opertori jogokat
	(userek negativ access szinttel s, ha
	a secure ops opci be van kapcsolva, a userek,
	akik nem szerepelnek az access listn) azonnal
	ki lesznek rgva s tiltva.

CHAN_HELP_SET_SECURE
	Syntax: SET csatorna SECURE {ON | OFF}
	
	Engedlyezi vagy letitlja a %S biztonsgi lehetsgeit
	a szobban. Ha a SECURE be van kapcsolva, csak azok a felhasznlk
	akik regisztrlt nvvel rendelkeznek s beazonostottak a
	%s jelszavukkal hasznltk a IDENTIFY'd parancsot csak azok
	kaphatnak a szobban privilgiumokat, a hozzfrsi listn.
	Ha a RESTRICTED opci be van lltva akkor a felhasznlk,
	akik szerepelnek a hozzfrsi listn azok sem tudnak belpni,
	amg nem azonostottak be a %s -be.

CHAN_HELP_SET_SECUREOPS
	Syntax: SET szoba SECUREOPS {ON | OFF}
	
	Bekapcsolja vagy letiltja a secure ops opcit a szobban.
	Amikor a secure ops be van kapcsolva, akkor azok akik nem
	szerepelnek a hozzfrsi listn nem kaphatnak szoba
	opertori sttust.

CHAN_HELP_SET_LEAVEOPS
	Syntax: SET csatorna LEAVEOPS {ON | OFF}
	
	Engedlyezi vagy letiltje a leave ops opcit a szobban.
	Ha a leave ops be van lltva, %S meghagyja a szerver opot
	(+o az els belpnek a szobba) azokon a helyeken, ahol a felhasznl
	nem lenne normlisan auto-opolva. A SECUREOPS opci
	tovbbra is vgre lesz hajtva.
	Megjegyzs:  gy lehetsget adsz az op "lopsra" egy netsplit esetn.

CHAN_HELP_SET_OPNOTICE
	Syntax: SET csatorna OPNOTICE {ON | OFF}
	
	Be/kikapcsolja az op-notice opcit a csatornn.
	Amikor az op-notice be van kapcsolva, a %S megjegyzest
	fog kuldeni a csatornara, amikor a felhasznalok hasznaljak
	az OP, VOICE, vagy a hozzajuk kapcsolodo parancsokat a
	csatornan.

CHAN_HELP_SET_ENFORCE
	Syntax: SET csatorna ENFORCE {ON | OFF}
	
	Be/kikapcsolja az enforce opcit a csatornn.
	Amikor az enforce be van kapcsolva, a %S nem engedlyezi az auto-opok
	s auto-voice-osok  jogfosztst.  Pldul, ha egy usert
	aki auto-op deoppolnak, %S automatikusan oppolja a usert, s a %S nem
	engedlyezi a ChanServ hasznlatval trtn deoppolst a usernek.

CHAN_HELP_UNSET
	Syntax: UNSET csatorna {SUCCESSOR | URL | EMAIL | ENTRYMSG}
	
	Trli a megadott belltst (Successor, URL, E-mail, Belp zenet) a csatornn.

CHAN_HELP_SOP
	Syntax: SOP csatorna ADD nick
	        SOP csatorna DEL nick
	        SOP csatorna LIST [mask | list]
	        SOP csatorna COUNT
	
CHAN_HELP_SOP_MID1
	SuperOp (SOP) lista a csatornn. Az SOP sttusz
	a szobba val belpskor automatikus oppolssal (set mode +o)
	s automatikus vdelemmel jr (set mode +a)

CHAN_HELP_SOP_MID1_CHANPROT
	SuperOp (SOP) lista a csatornn. Az SOP sttusz
	a szobba val belpskor automatikus oppolssal (set mode +o)
	s automatikus vdelemmel jr (set mode +a).

CHAN_HELP_SOP_MID2
	
	Az SOP mdosthatja az AOP s VOP listt.  Csak a
	csatorna founderje mdosthatja az SOP listt.

CHAN_HELP_SOP_MID2_HALFOP
	
	Az SOP  mdosthatja az AOP, HOP, s VOP listt.  Csak a
	csatorna founderje mdosthatja az SOP listt.
CHAN_HELP_SOP_END
	
	Az SOP LIST parancs megadja az SOP listt.
	Ha nem vagyunk kivncsiak a teljes listra akkor a listban szerepl
	Sop sorszmt megadva is megtudhatjuk a nevt, megadhatunk intervallumot is.
	
	Pldk:
	
	   SOP #csatorna LIST 2-5,7-9
	      Listzza az SOP-okat 2 s 5 kztt s
	      7-tl  9-ig.
	
	Az SOP COUNT parancs megadja, hogy hny darab Sop szerepel a listn

CHAN_HELP_AOP
	Syntax: AOP  ADD nick
	        AOP csatorna DEL nick
	        AOP csatorna LIST [mask | list]
	        AOP csatorna COUNT
	
	AOP lista a csatornn. Az AOP sttusz
	a szobba val belpskor automatikus oppolssal (set mode +o)  jr.

CHAN_HELP_AOP_MID
	
	Az AOP mdosthatja a VOP listt; SOP-ok mdosthatjk az AOP
	listt.
CHAN_HELP_AOP_MID_HALFOP
	
	Az AOP mdosthatja a HOP s VOP listt; SOP-ok mdosthatjk az
	AOP listt.
CHAN_HELP_AOP_END
	
	Az AOP LIST parancs megadja az AOP listt.
	Ha nem vagyunk kivncsiak a teljes listra akkor a listban szerepl
	Aop sorszmt megadva is megtudhatjuk a nevt, megadhatunk intervallumot is.
	
	Pldk:
	
	   AOP #csatorna LIST 2-5,7-9
	      Listzza az AOP-okat 2 s 5 kztt s
	      7-tl  9-ig.
	
	Az AOP COUNT parancs megadja, hogy hny darab Aop szerepel a listn


CHAN_HELP_HOP
	Syntax: HOP csatorna ADD nick
	        HOP csatorna DEL nick
	        HOP csatorna LIST [mask | list]
	        HOP csatornal COUNT
	
	HOP lista a csatornn. A HOP sttusz
	a szobba val belpskor automatikus flop joggal  (set mode +h)  jr.
	
	A HOP mdosthatja a VOP listt; SOP-ok s AOP-ok mdosthatjk a
	HOP listt.
	
	A HOP LIST parancs megadja az HOP listt.
	Ha nem vagyunk kivncsiak a teljes listra akkor a listban szerepl
	hop sorszmt megadva is megtudhatjuk a nevt, megadhatunk intervallumot is.
	
	Pldk:
	
	   HOP #csatorna LIST 2-5,7-9
	      Listzza az HOP-okat 2 s 5 kztt s
	      7-tl  9-ig.
	
	A HOP COUNT parancs megadja, hogy hny darab Hop szerepel a listn


CHAN_HELP_VOP
	Syntax: VOP csatorna ADD nick
	        VOP csatorna DEL nick
	        VOP csatorna LIST [mask | list]
	        VOP csatorna COUNT
	
	VOP lista a csatornn. A VOP sttusz
	a szobba val belpskor automatikus hangadsi joggal  (set mode +v)  jr.
	
	A VOP nem mdosthat listt; SOP-ok, AOP-ok s HOP-ok mdosthatjk a
	VOP listt.
	
	A VOP LIST parancs megadja az VOP listt.
	Ha nem vagyunk kivncsiak a teljes listra akkor a listban szerepl
	Vop sorszmt megadva is megtudhatjuk a nevt, megadhatunk intervallumot is.
	
	Pldk:
	
	   VOP #csatorna LIST 2-5,7-9
	      Listzza az VOP-okat 2 s 5 kztt s
	      7-tl  9-ig.
	
	A VOP COUNT parancs megadja, hogy hny darab Vop szerepel a listn


CHAN_HELP_ACCESS
	Syntax: ACCESS csatorna ADD nick szint
	        ACCESS csatorna DEL {nick | entry-num | list}
	        ACCESS csatorna LIST [mask | list]
	        ACCESS csatorna COUNT
	
	Access lista  a csatornn.  A hozzfrsi lista (access list)
	meghatrozza, hogy mely userek kaphatnak op sttuszt vagy
	hozzfrst a %S parancsokhoz a csatornn. Klnbz
	user szintek lehetsget nyjtanak arra, hogy eltr jogokat kaphassanak;
	bvebb informcirt, rd be: /msg %S HELP ACCESS LEVELS.
	Minden nick amely nem szerepel az access listn  0-s szint.
	
	Az ACCESS ADD paranccsal hozzadhat a megadott nicknv az
	access listhoz a megadott user szinttel; ha a nick mr szerepel a listn,
	akkor a hozzfrsi szintje vltozik csak meg. A szint amit meghatrozol,
	kisebb kell, hogy legyen mint a te szinted s ha a nick mr szerepel a listn,
	akkor a jelenlegi szintjnek a tidnl alacsonyabbnak kell lennie.
	
	Az ACCESS DEL parancs trli a megadott nicknevet az
	access listrl.  Ha intervallumot adsz meg,akkor minden azon intervallumban szerel
	nicknevet trlsz.
	
	Az ACCESS LIST paranccsal megtekinthet az access lista.
	Ha intervallumot is megadsz, akkor csak abban az intervallumban szerepl nicknevek
	listzsa fog megtrtnni
	
	   ACCESS #csatorna LIST 2-5,7-9
	      Listzza azokat a usereket, akik 2 s 5 kztt illetve
	      7-tl 9-ig szerepelnek a listn.
	
	Az ACCESS COUNT parancs megadja, hny user szerepel az access listn

CHAN_HELP_ACCESS_XOP
	
	Az access list knnyebben llthat az SOP, AOP, s  VOP parancsokkal.
	
CHAN_HELP_ACCESS_XOP_HALFOP
	
	Az access lista knnyebben llthat az SOP, AOP, HOP, s VOP
	parancsokkal.

CHAN_HELP_ACCESS_LEVELS
	Felhasznli hozzfrsi szintek
	
	Alapbl, a kvetkez hozzfrsi szintek vannak definilva:
	   Founder   Teljes hozzfrs a %S funkcikhoz; automatikus
	                 opjog a csatornra val belpskor.  Megjegyzem,
	                 csak egy embernek lehet founder sttusa (ez sttus
	                 (nem adhat az ACCESS paranccsal.
	      %4d   Hozzfrs az AKICK listhoz; automatikus opertori jog.
	      %4d   Automatikus opertori jog.
CHAN_HELP_ACCESS_LEVELS_HALFOP
	      %4d   Automatikus flopertori jog.
CHAN_HELP_ACCESS_LEVELS_END
	      %4d   Automatikus hangadi jog.
	         0   Semmi klnleges jog; opolhat a tbbi
	                 op ltal (kivve, ha a SECUREOPS be van kapcsolva).
	        -1   Nem opolhat.
	      -100   Nemlphet be a csatornra.
	
	Ezek a szintek (kivve az utols kettt) vltoztathatak, vagy jak
	adhatak meg a LEVELS parancs hasznlatval; a rszletekrt rd be
	/msg %S HELP LEVELS.

CHAN_HELP_LEVELS
	Syntax: LEVELS csatorna SET tipus szintl
	        LEVELS csatorna {DIS | DISABLE} tipus
	        LEVELS csatorna LIST
	        LEVELS csatorna RESET
	
	A LEVELS lehetsget nyjt a szmokkal definilt hozzfrsi szintek
	mdostshoz.Ezzel a paranccsal,  definilhatsz hozzfrsi szinteket a  %S funkciihoz.
	Ezt a parancsot csak a founder hasznlhatja.

CHAN_HELP_LEVELS_XOP
	
	Figyelmeztets: Ez a parancs megvltoztatja a usereket szintjt!
	Ennek a levelnek az lltsa elidzheti azt, hogy az SOP, AOP, s
	VOP parancsok nem fognak rendesen mkdni.

CHAN_HELP_LEVELS_XOP_HOP
	
	Figyelmeztets: Ez a parancs megvltoztatja a usereket szintjt!
	Ennek a levelnek az lltsa elidzheti azt, hogy az SOP, AOP, HOPs
	VOP parancsok nem fognak rendesen mkdni.
	
CHAN_HELP_LEVELS_END
	
	A LEVELS SET Engedlyezi a hozzfrsi szintek lltst.
	A LEVELS DISABLE (vagy rviden a DIS) megsznteti egy automatikus
	lehetsg mkdst vagy megakadlyozza a hozzfrst (a founderen kivl)
	minden usernek.
	A LEVELS LIST megmutatja a szintek jelenlegi belltst.
	LEVELS RESET visszlltja a szinteket az eredetire.
	(Tekintsd meg a HELP ACCESS LEVELS -t).
	
	A lehetsgek s funkcik listjrt , tekintsd meg a HELP LEVELS DESC-et.

CHAN_HELP_LEVELS_DESC
	A kvetkez lehetsgek/funkcik llnak rendelkezsre:

CHAN_HELP_AKICK
	Syntax: AKICK csatorna ADD maszk [indok]
	        AKICK csatorna DEL maszk
	        AKICK csatorna LIST [maszk | list]
	        AKICK csatorna VIEW [maszk | list]
	        AKICK csatorna ENFORCE
	        AKICK csatorna COUNT
	
	Manipulhat az autokirgs lista ami a csatornhoz tartozik.  Ha egy felhasznl
	aki szerepel az autokick listn megprobl belpni a csatornra, a %S kitiltja
	ezt a felhasznlt s aztn kirgja.
	
	Az AKICK ADD parancs hozzadja a user@host vagy a
	nick!user@host maszkot az autokick listhoz.  Ha az indok meg
	van adva a parancsban, akkor ez lesz az indok ami a kirugskor meg lesz adva, ha
	nincs megadva akkor az alapbellts szerinti indok "You have been
	banned from the channel" fog megjelenni.
	
	Az AKICK DEL parancs eltvoltja a megadott maszkot az
	autokirgs listrl.  Ez nem mkdik, hacsak nem tvoltunk el minden az
	adott nickre, identre, hostra szol tiltst, ami az autkirugs listn
	szerepel; mindegyiket egyenknt kell trlni.
	
	Az AKICK LIST parancs megjelenti az autkirgs listt, vagy
	optionlis esetben csak azokat jeleniti meg amelyek egyeznek a megadott maszkkal.
	Az AKICK VIEW ugyanaz, de tbb rszletet jelent meg.
	
	Az AKICK ENFORCE parancs hatsra a %S ellenrzi az akick listt s
	eltvolt minden olyan usert akinek a maszkja szerepel a listn.
	
	Az AKICK COUNT parancs megmutatja, hogy hny hely foglalt az akick listn.
	
	Alapbellts alapjn, limitlva a %s access szinttel vagy magasabb szinttel
	rendelkez felhasznlk szmra a szobban.

CHAN_HELP_INFO
	Syntax: INFO csatorna [ALL]
	
	Listzza az sszes informcit a megnevezett regisztrlt csatornrl,
	mint a foundert, a regisztrls idpontjt, az utols hasznlat idejt
	a meghatrozst, a mode lockot, stb.  Ha beazonstottad magad a csatorna founderjnek
	akkor teljes informacit  ALL kaphatsz, az entry message
	a successor s az elrejtett informcik is ltszdni fognak.

CHAN_HELP_LIST
	Syntax: LIST pattern
	
	Listzza a regisztrlt csatornkat.
	(Ahol a PRIVATE opci be van kapcsolva nem fog megjelenni a listban.)
CHAN_HELP_LIST_OPERSONLY
	
	Csak IRC opertorok hasznlhatjk.

CHAN_HELP_OP
	Syntax: OP csatorna [nick]
	
	Opolja a megadott nicket a csatornn. Ha nem adsz meg  nicket, magadat Oppolod.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk.

CHAN_HELP_DEOP
	Syntax: DEOP csatorna [nick]
	
	DeOpolja a megadott nicket a csatornn. Ha nem adsz meg  nicket, magadat DeOppolod.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_VOICE
	Syntax: VOICE csatorna [nick]
	
	Hangadv teszi a megadott nicket a csatornn. Ha nem adsz meg  nicket,
	magadat teszed hangadv.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_DEVOICE
	Syntax: DEVOICE csatorna [nick]
	
	Elveszi a hangadsi jogot a megadott nicktl a csatornn. Ha nem adsz meg  nicket,
	magadtl vonod meg a hangadsi jogot.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_HALFOP
	Syntax: HALFOP csatorna [nick]
	
	FlOpertori jogot kap a megadott nick a csatornn. Ha nem adsz meg  nicket,
	magadnak adsz FlOpertori jogot .
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_DEHALFOP
	Syntax: DEHALFOP csatorna [nick]
	
	Elveszi a FlOpertori jogot a megadott nicktl a csatornn. Ha nem adsz meg  nicket,
	magadtl vonod meg a FlOpertori jogot.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_PROTECT
	Syntax: PROTECT csatorna [nick]
	
	Vdelmet ad a megadott nicknek a csatornn. Ha nem adsz meg  nicket,
	 magadnak adsz vdettsget.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_DEPROTECT
	Syntax: DEPROTECT csatorna [nick]
	
	Elveszi a vdelmet a megadott nicktl a csatornn. Ha nem adsz meg  nicket,
	magadtl vonod meg a vdelmet.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_INVITE
	Syntax: INVITE csatorna
	
	A %S meghv a csatonra.Ha meghvsosra (+i) van lltva a szoba, akkor nagyon hasznos parancs.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk
	
	Megjegyzs: Ha olyan zenetet kapsz, hogy  "channel is not in
	use", hogy a csatorna res, s szabadon belphetsz ezen parancs hasznlata nlkl.

CHAN_HELP_UNBAN
	Syntax: UNBAN csatorna
	
	A %S leveszi rlad a kitiltst s szabadon belphetsz a csatonra.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_KICK
	Syntax: KICK csatorna nick [indok]
	
	A %S kirgja a megadott nicknevet a csatornrl.
	A kickmsg-ben szerepel a kirg szemlye s termsztesen a kirgs indoka.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_KICK_PROTECTED
	
	Megjegyzs:a protected (+a) userek (vdett felhasznlk) nem rghatak ki ezzel a paranccsal.
	Kivve, ha a founder adja ki a parancsot.

CHAN_HELP_TOPIC
	Syntax: TOPIC csatorna topic
	
	A %S tlltja a csatonra topic-jt.Ez a parancs akkor hasznos,
	amikor a TOPICLOCK be van kapcsolva.
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_CLEAR
	Syntax: CLEAR csatorna opci
	
	A %S eltvoltja a belitsokat a csatornn.  opci
	lehet a kvetkez:
	
	    MODES       Trli az sszes mdot ami nem szerepel a csatorna
	                    mode lockjban.
	    BANS        Trli az sszes tiltst a csatornn.
CHAN_HELP_CLEAR_EXCEPTIONS
	    EXCEPTIONS  Trli az sszes kivtelt a csatornn.
CHAN_HELP_CLEAR_INVITES
	    INVITES     Trli az sszes invite maszkot a csatornn.
CHAN_HELP_CLEAR_MID
	    OPS         Elvesz minden op-ot a csatornn
CHAN_HELP_CLEAR_HALFOPS
	    HALFOPS     Elvesz minden halfop-ot (mode +h) a csatornn.
CHAN_HELP_CLEAR_END
	    VOICES      Elvesz minden "voice"-t (mode +v) a csatornn.
	    USERS       Eltvolt minden usert a csatornrl (kirgs).
	
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_HELP_STATUS
	Syntax: STATUS csatorna nicknv
	
	Megmutatja a megadott nicknv jelenlegi access szintjt a megadott csatornn.
	A vlasz formja:
	
	    STATUS csatorna nicknv access-level
	
	Ha hiba lpne fel a vlas a kvetkez:
	
	    STATUS csatorna nicknv ERROR hiba-zenet
	
	Alap bellts szerint csak a %s accessn szerepl userek hasznlhatjk

CHAN_OPER_HELP_COMMANDS
	
	A kvetkez parancsok csak Services adminoknak elrhetek:
	
CHAN_OPER_HELP_COMMANDS_GETPASS
	    GETPASS    Megnzni egy csatorna founder jelszavt
	                   (csak, ha az encryption nincs hasznlatban)
CHAN_OPER_HELP_COMMANDS_FORBID
	    FORBID     Letiltja egy csatorna regisztrlst/hasznlatt
	    SUSPEND    Felfggeszti egy regisztrlt csatorna hasznlatt
	    UNSUSPEND  Trli egy csatorna hasznlatnak felfggesztst
CHAN_OPER_HELP_COMMANDS_END
	
	Services adminok trlhetik brmelyik csatorna regisztrcijt
	anlkl, hogy jelszval beazonostank magukat, vagy accessk lenne,
	AKICK, s level belltsok, listzsok, a STATUS parancs hasznlata
	engedlyezett szmukra brmelyik csatornn.

CHAN_OPER_HELP_DROP
	Syntax: DROP csatorna
	
	Trli a megnevezett csatorna regisztrlst. Csak Services adminok
	droppolhatnak csatornt anlkl, hogy jelszval azonostank magukat.

CHAN_OPER_HELP_SET
	
	Services adminok llthatjk a NOEXPIRE opcit is, ami
	az adott csatornt megvja az elvlstl.
	Mellegleg, Services adminok llthatjk a set opcikat brmelyik
	csatornn anlkl, hogy jelszval azonostank magukat.

CHAN_OPER_HELP_SET_NOEXPIRE
	Syntax: SET csatorna NOEXPIRE {ON | OFF}
	
	Ha nincs belltva, akkor az adott csatorna el fog vlni.
	Ha az ON opci be van kapcsolva akkor a csatorna nem fog elvlni.
	
	Limitlva Services adminoknak.

CHAN_OPER_HELP_UNSET
	
	Ugyanaz, mint a SET parancsnl, Services adminok trlhetik
	brmelyik csatorna belltsait, jelszavas azonosts nlkl.

CHAN_OPER_HELP_INFO
	
	Services adminok hasznlhatjk az ALL paramtert brmelyik csatornnl.

CHAN_OPER_HELP_LIST
	Syntax: LIST sablon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Listz minden regisztrlt csatornt a sablonnak megfelelen.
	Csatornk a PRIVATE opci belltssal csak a Services adminoknak
	fognak megjelenni. Csatornk a NOEXPIRE opci belltssal
	! eltaggal (prefix) a csatorna neve eltt fognak megjelenni
	a Services adminoknak.
	
	Ha a FORBIDDEN, SUSPENDED vagy NOEXPIRE opci be van lltva,
	csak azok amelyek, klcsnsen FORBIDoltak, SUSPENDeeltek vagy
	NOEXPIRE opcival rendelkeznek fognak ltszani. Az opcik hasznlhatak
	brmilyen sorrendben s kombinciban. Ezek az opcik
	limitltak Services adminoknak.

CHAN_OPER_HELP_GETPASS
	Syntax: GETPASS csatorna
	
	Megadja a megnevezett csatorna jelszavt.Figyelem ha
	ha ezt a parancsot hasznljk, egy zenet tartalmazni fogja
	annak a nevt aki kiadta a parancsot s a csatornt amin hasznlta
	s loggolva leszs el lesz kldve WALLOPS/GLOBOPS.
	
	Ha az encryption hasznlatban van, ez a parancs nem elrhet
	attl fggen, hogy az encryption melyik tipusa van hasznlatban.
	
	Limitlva Services adminoknak.

CHAN_OPER_HELP_FORBID
	Syntax: FORBID csatorna
	
	Megtiltja egy csatorna registrlst s hasznlatt
	Trlni lehet a csatorna droppolsval.
	
	Limitlva Services adminoknak.

CHAN_OPER_HELP_SUSPEND
	Syntax: SUSPEND [+elvls] szoba indok
	
	Megelzi, hogy egy szobt hasznljanak vagy beazonostsanak r.
	A szoba unsuspendelhet az UNSUSPEND paranccsal, amely utn
	minden marad a rgiek szerint.
	Az elvls paramter ugyanazt jelenti, mint az %s AKILL parancs esetben.
	
	Limitlva: Services adminoknak.

CHAN_OPER_HELP_UNSUSPEND
	Syntax: UNSUSPEND csatorna
	
	Trli egy csatorna hasznlatnak felfggesztst s
	lehetv teszi a hasznlatt.
	
	Limitlva Services adminoknak.


###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S lehetsget nyjt az IRC felhasznlkank, hogy rvid
	szveges zeneteket kldjenek ms IRC felhasznlk rszre,
	akkor is, ha a fogad fl nem online, s csatornkra (*).
	Ahhoz, hogy zenetet lehessen kldeni, mind a kld s a
	fogad fl nicknevnek regisztrltnak kell lennie.
	/msg %S HELP COMMANDS megjelenti a(z) %S parancsok
	listjt; ha hasznlni akarsz egy parancsot, rd be:
	/msg %S parancs, vagy a paranccsal kapcsolatos tovbbi
	informcirt rd be: /msg %S HELP parancs.
MEMO_HELP_EXPIRES
	
	Megjegyzs: Az zenetek lejrnak (automatikusan trldnek)
	%s utn, kivve, ha a SAVE paranccsal megjelld, hogy
	soha ne jrjon le.
MEMO_HELP_END_LEVELS
	
	(*) Alaprtelmezs szerint brmilyen felhasznl, akinek
	    a szintje legalbb %s, olvashatjk a csatornra
	    rkez zeneteket. Ez a bellts megvltoztathat
	    a %s LEVELS parancsval.
MEMO_HELP_END_XOP
	
	(*) Minden felhasznl, aki szerepel a szoba sop listjn
	    elolvashatja a szoba memoit.
	
MEMO_HELP_COMMANDS
	%S az albbi parancsokat nyjtja neked:
	
	    SEND      zenetet kld egy nicknek vagy csatornra
	    LIST      Megjelenti az zenetek listjt
	    READ      Elolvassa a megadott zenete(ke)t
MEMO_HELP_COMMANDS_FORWARD
	    FORWARD   Tovbbtja az zeneteket az E-mail cmedre
MEMO_HELP_COMMANDS_SAVE
	    SAVE      Belltja az zenetet, hogy soha ne jrjon le
MEMO_HELP_COMMANDS_DEL
	    DEL       Trli a megadott zenete(ke)t
	    SET       zenetekkel kapcsolatos belltsokat hajt vgre
	    INFO      Megjelenti az zenetekkel kapcsolatos informcikat
MEMO_HELP_COMMANDS_IGNORE
	    IGNORE    A megadott felhasznltl nem fogad zeneteket

MEMO_HELP_SEND
	Syntax: SEND {nick | csatorna} zenet-szvege
	
	zenetet kld a megnevezett nicknek vagy csatornra
	a zenet-szvegt tartalmazva. Amikor nicknvnek kldesz
	a cmzett kap egy figyelmeztetst az j zenet rkezsrl.
	A cmzett csatornnak vagy nicknvnek regisztrltnak kell
	lennie.
	

MEMO_HELP_LIST
	Syntax: LIST [csatornal] [szm | lista | NEW]
	
	Megjelent egy listt a jelenlegi zenteteidrl.  A NEW
	opcival csak az j (olvasatlan) zenteket listzza.
	listzza. Az olvasatlan zeneteket megjelli egy "*" jellel
	az zenetszmtl balra.  Megadhatsz szmlistt is, mint
	ahogy az albbi plda mutatja:
	
	   LIST 2-5,7-9
	      Listzza az zeneteket 2 s 5, illetve 7 s 9 kztt.

MEMO_HELP_LIST_EXPIRE
	Syntax: LIST [csatorna] [szm | lista | NEW]
	
	Megjelent egy listt a jelenlegi zenteteidrl.  A NEW
	opcival csak az j (olvasatlan) zenteket listzza.
	listzza. Az olvasatlan zeneteket megjelli egy "*" jellel
	az zenetszmtl balra; s egy "+" jellel azokat az
	zeneteket, amelyek nem jrnak le. Megadhatsz
	szmlistt is, mint ahogy az albbi plda mutatja:
	
	   LIST 2-5,7-9
	      Listzza az zeneteket 2 s 5, illetve 7 s 9 kztt.

MEMO_HELP_READ
	Syntax: READ [csatorna] {szm | lista | LAST | NEW}
	
	Elkldi a megadott zenetek tartalmt. A LAST opcival
	megjelenti a legutols zenetet. A NEW opcival
	minden j zenetet. Egybknt a megadott szm zenetet.
	Megadhatsz szmlistt is, mint a LIST parancsnl.

MEMO_HELP_SAVE
	Syntax: SAVE [csatorna] {szm | lista}
	
	Megjelli az megadott szm zenetet hogy ne jrjon le.
	Megadhatsz egyedl egy szmot, vagy ahogyan a LIST
	parancsnl, szmok listjt is.

MEMO_HELP_DEL
	Syntax: DEL [szoba] {szm | list | ALL}
	
	Trli a megjellt memot vagy memokat.
	Deletes the specified memo or memos.  Megadhatsz
	sok memo szmot vagy intervallumot ami tartalmaz egy
	egyszer szmot, mint a LIST parancsnl; megadhatod az
	ALL szavacskt is, aminek kvetkeztben az sszes memod trldni fog.
	
	Figyelem: Ha egy memot mr trltl, az nem llthat vissza!

MEMO_HELP_SET
	Syntax: SET opci paramterek
	
	Bellt klnbz memo opcikat. opci lehet az albbiak egyike:
	
	    NOTIFY      Itt llthatod be, ha figyelmeztetst szeretnl kapni
	                    az j zenetekrl (csak nicknevehez)
	    LIMIT       Belltja a maximlis zenetek szmt
MEMO_HELP_SET_OPTION_FORWARD
	    FORWARD     Lehetsget, hogy az zeneteidet az Email
	                    cmedre tovbbtsd
MEMO_HELP_SET_END
	
	Tovbbi informcirt rd be: /msg %S HELP SET opci

MEMO_HELP_SET_NOTIFY
	Syntax: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Itt lehetsged van belltani, ha rtestst szeretnl kapni
	az j zenetekr:
	
	    ON      rtestst kapsz az j zenetrl csatlakozskor,
	               amikor visszajssz /AWAY-bl, vagy ha kldenek
	               neked.
	    LOGON   rtestst kapsz az j zenetekrl csatlakozskor
	               vagy ha visszajssz /AWAY-bl.
	    NEW     Csak akkor kapsz rtestst, ha j zenet rkezett.
	    OFF     Nem kapsz rtestst az zeneteidrl.
	
	Az ON ekvivalens a LOGON s a NEW kombinlsval.
	
	Vedd figyelembe, hogy ha a nicknevedre be van lltva
	a "secure" opci, akkor csak j zenetek rkezsekor kapsz
	rtestst (LOGON vagy ON) %s azonosts utn.

MEMO_HELP_SET_LIMIT
	Syntax: SET LIMIT [csatorna] korlt
	
	Belltja, hogy maximlisan hny zenetet fogadhatsz
	a nickedre (vagy a csatornra). Ha 0-ra lltod, senki nem
	kldhet zenetet a nickedre vagy a csatornra. Mindamellett,
	nem llthatod ezt a szmot tbbre, mint %d.

MEMO_HELP_INFO
	Syntax: INFO [csatorna]
	
	Informcit jelent meg arrl, hogy mennyi zeneted van, mennyi
	ebbl mennyi olvasatlan, sszesen mennyi zenetet fogadhatsz,
	s azt is megmondja, hogy kapsz-e figyelmeztetst az j zenetek
	rkezsekor. Paramter megadsa esetn ugyanezt az informcit
	csatornra vonatkozan jelenti meg.

MEMO_OPER_HELP_COMMANDS
	
	Services adminisztrtorok a SET s INFO parancsokat
	a sajtjuknl klnbz nickekre is hasznlhatjk.

MEMO_OPER_HELP_SET_LIMIT
	Syntax: SET LIMIT [nick | csatorna] {korlt | NONE | DEFAULT} [HARD]
	
	Belltja, hogy egy nicknek vagy szobnak maximlisan mennyi
	zenete lehet. Ha a korlt 0, a nick nem kaphat zeneteket;
	NONE-ra lltva a nick kaphat s megtarthat annyi zenetet,
	amennyit akar; DEFAULT-ra lltva a korltot alaprtelmezett
	rtkre lltja (%d). Ha nem adsz meg nicknevet vagy csatornt,
	a sajt korltodat lltja be.
	
	A HARD opci hozzadsval megakadlyozza a felhasznlt,
	hogy megvltoztassa a korltot. A kihagysval a HARD
	opci ellenttesen hat, engedlyezi a felhasznlt a korlt
	megvltoztatsra (mg akkor is, ha az elz korlt
	HARD-ra lett belltva).
	
	A SET LIMIT parancs ezen hasznlata Services
	adminisztrtorokra van korltozva. Ms felhasznlk
	csak sajt magukra vagy olyan szobra llthatnak be
	korltot, amelyen megvannak ezek a jogai, s nem trlhetik
	a asjt korltjaikat, illetve nem llthatjk t
	alaprtelmezsre, nem llthatnak be nagyobb rtket,
	mint %d, s nem hasznlhatnak HARD korltozst.

MEMO_OPER_HELP_INFO
	Syntax: INFO [nick | csatorna]
	
	Paramterek nlkl informcit jelent meg arrl, hogy
	mennyi zeneted van, mennyi ebbl az olvasatlan, sszesen
	mennyi zenetet fogadhatsz, s kapsz-e rtestst,
	ha j zeneted rkezik.
	
	Csatorna paramterrel ezeket az informcikat a megadott
	csatornval kapcsolatosan jelenti meg.
	
	Nicknv paramterrel ugyanezeket az informcikat
	megjelenti a megadott nicknvre. Ez a lehetsg
	korltozva van Services adminisztrtorokra.


MEMO_HELP_FORWARD
	Syntax: FORWARD {szm | lista | ALL}
	
	Tovbbtja egy vagy tbb zenetedet az E-mail cmedre.
	A nicknevedhez belltott E-mail cmnek valsnak kell
	lennie, ha szeretnd hasznlni ezt a parancsot.
	A csatornk zenetei nem tovbbthatak.

MEMO_HELP_SET_FORWARD
	Syntax: SET FORWARD {ON | COPY | OFF}
	
	Itt van lehetsged belltani, ha szeretnd, hogy %S
	automatikusan tovbbtsa az zeneteidet az E-mail cmedre.
	Ha ON-ra van lltva, az zeneteket nem a nicknevedre,
	hanem arra az E-mail cmedre kldi, amelyre a nickneved
	regisztrlva van. A COPY ehhez hasonl, de ilyenkor
	%S elkld egy msolatot is, hogy online olvassra.
	Ha OFF-ra van lltva, az zeneteket online trolja,
	mint ltalban. Emellett ha belltod az opcit ON-ra,
	mg akkor is megkapod az zeneteket online, ha a Services
	kptelen tovbbtani ket az E-mail cmedre.
	
	Vedd figyelembe, hogy ha ez az opci COPY-ra van lltva,
	s annyi zenetet kaptl, mint amennyi zenetet fogadhatsz
	maximlisan, addig nem kaphatsz j zenetet (belertve
	az E-mailt is), amg le nem trlsz nhny rgit a DEL
	paranccsal.

MEMO_HELP_IGNORE
	Syntax: IGNORE {ADD | DEL | LIST} [nicknv | maszk]
	
	Irnytja azoknak a felhasznlknak a listjt, amelyek
	ltal kldtt zeneteket nem veszel tudomsul; azon
	felhasznlk, amelyeknek a nickneve vagy felhasznl@gazdanv
	maszkja rillik ennek a listnak az egyik bejegyzsre,
	nem kldhet zenetet neked. ADD hozzadja a megadott nicket
	vagy felhasznl@gazdanv maszkot az ignore listra, s
	a DEL parancs eltvoltja; LIST megjelenti a jelenlegi
	ignore listt.
	
	Vedd figyelembe, hogty ha a nicknv vagy a maszk, amely az ADD
	parancshoz lett megadva, tartalmazhat "*" vagy "?" joker-
	karaktereket, s nem rzkeny a kis- s nagybetkre; pldul
	"*Evil*" rillik az "EvilNick"-re, "AN_EVIL_USER"-er s
	a "devil"-re is.


###########################################################################
#
# OperServ help zenetek
#
###########################################################################

OPER_HELP
	%S lehetsget nyjt az IRC opertoroknak, hogy klnbz
	szempontok szerint irnythassk az IRC hlzatot. A parancsok
	listjrt rd be: /msg %S HELP COMMANDS
	
	Megjegyzs: Minden parancs, amit az %S-nek kldesz, naplzva lesz!

OPER_HELP_COMMANDS
	%S parancsok:
	    GLOBAL      zenet kld minden felhasznlnak
	    STATS       Megmutatja a Services s a hlozat llapott
	    SERVERMAP   Megmutatja a hlzatban lv szervereket
	    OPER LIST   Megjelenti a Services opertorok listjt
	    ADMIN LIST  Megjelenti a Services adminok listjt
OPER_HELP_COMMANDS_SERVOPER
	
	Ezeket a parancsokat csak Services opertorok s adminok hasznlhatjk:
	    MODE        Megvltoztatja a megadott csatorna belltsait
	    KICK        Kirgja a felhasznlt a megadott szobbl
	    CLEARMODES  Trl egyes mdokat a csatornrl
	    CLEARCHAN   Minden felhasznlt kirg a csatornrl (masskick)
	    KILLCLONES  Killel minden felhasznlt a megadott hostrl
OPER_HELP_COMMANDS_AKILL
	    AKILL       Mdostja az autokill listt
	    AKILLCHAN   Autokillel minden felhasznlt a szobbl
OPER_HELP_COMMANDS_EXCLUDE
	    EXCLUDE     Karbantartja az autokill kizrlistt
OPER_HELP_COMMANDS_SLINE
	    SGLINE      Karbantartja az SGLINE listt
	    SQLINE      Karbantartja az SQLINE listt
	    SZLINE      Karbantartja az SZLINE listt
OPER_HELP_COMMANDS_SESSION
	    SESSION     Megjelenti a megadott host sessionok listjt
	    EXCEPTION   Mdostja a session-korltozs kivtellistjt
OPER_HELP_COMMANDS_NEWS
	    LOGONNEWS   Mdostja a fellpskor megjelen zeneteket
	    OPERNEWS    Mdostja az opertoroknak szl zeneteket
OPER_HELP_COMMANDS_SERVADMIN
	
	Ezeket a parancsokat csak Services adminok hasznlhatjk:
	    OPER        Mdostja a Services opertorok listjt
	    JUPE        Ltrehoz egy lszervert (jupiter)
	    SET         Bellt klnbz globlis Services opcikat
	    UPDATE      Arra kszteti a Servicest, hogy az adatbzis-
	                    fjlokat azonnal frisstse
	    SHUTDOWN    Elmenti az adatbzist s lelltja a Servicest
	    QUIT        Lelltja a Servicest az adatbzis mentse nlkl
	    RESTART     Elmenti az adatbzist s jraindtja a Servicest
	    REHASH      jratlti a konfigurcis fjlokat
	    SU          Services super-user jogokat biztost
OPER_HELP_COMMANDS_SERVROOT
	
	Ezeket a parancsokat csak Services super-user hasznlhatja:
	    ADMIN       Mdostja a Services adminok listjt
OPER_HELP_COMMANDS_RAW
	    RAW         Raw parancsot kld az IRC szervernek

OPER_HELP_GLOBAL
	Syntax: GLOBAL zenet
	
	Lehetsget nyjt az IRC opertoroknak a hlzaton lv sszes
	felhasznlnak szl zenet kldsre.
	Ezt az zenetet errl a nickrl fogja kldeni: %s.

OPER_HELP_STATS
	Syntax: STATS [RESET | NETWORK | ALL]
	
	Minden ms opci nlkl, megmutatja a jelenlegi felhasznlk s
	online IRCopok szmt (kivve a Servicest), a legmagasabb
	felhasznl szmot amita a Services elindult, s a leghosszabb
	idt amita a Services fut.
	
	A RESET opci, lenullzza a maximlis userszmot s az aktulis
	user szmra vltoztatja.
	
	A NETWORK opci, megjelenti azt adatmennyisget amit a remote szervernek
	kldtt s azt az adatmennyisget amit a remoteszervertl fogadott s azt a
	memoria mennyisgt, amit a hlozat kld/fogad buffer hasznlt.  Az
	jelenlegi buffer memoria kihasznltsgnak a buffer mret limitjnek
	arnyt, ami szerepelni fog, mint egy szzalk, ha a limit be van lltva.
	
	Az ALL opci csak Services adminok szmra rhet el, s megjelenti
	az Services memoria felhasznlsra vonatkoz informcijt.  Ezen opci
	hasznlatval lefagyhat a Services egy rvid idre a nagyobb rendszereken,
	teht ne hasznld tl sokszor!
	
	UPTIME a STATS szinonimjaknt hasznlhat.

OPER_HELP_SERVERMAP
	Syntax: SERVERMAP
	
	Kirajzol egy trkpet a hlzatra kapcsoldott szerverekrl
	a Services nzpontjbl. Az lszervereknek -- magnak a
	Servicesnek s a JUPE parancs ltal ltrehozott (jupiterelt)
	szervereknek -- a neve utn egy "(*") fog megjelenni.

OPER_HELP_OPER
	Syntax: OPER ADD nick
	        OPER DEL nick
	        OPER LIST
	
	Lehetsget nyjt a Services adminoknak, hogy hozzadjanak,
	trljenek nickneveket a Services opertorok listjn.
	Az a felhasznl, akinek a nickneve szerepel a Services
	opertorok listjn, s azonostotta a nicknevt
	%s-nl, hozzfrhet a Services opertorok
	parancsaihoz.
	
	Minden IRC opertor hasznlhatja az OPER LIST parancsot.
	Minden ms korltozva a Services adminoknak.

OPER_HELP_ADMIN
	Syntax: ADMIN ADD nick
	        ADMIN DEL nick
	        ADMIN LIST
	
	Lehetsget nyjt a Services super-usereknek, hogy
	hozzadjanak, trljenek nickneveket a Services adminok
	listjn. Az a felhasznl, akinek a nickneve szerepel
	a Services adminisztrtorok listjn, s azonostotta
	a nicknevt %s-nl, hozzfrhet a Services
	admin parancsokhoz.
	
	Minden IRC opertor hasznlhatja az ADMIN LIST parancsot.
	Minden ms parancs korltozva a Services super-usereknek.

OPER_HELP_MODE
	Syntax: MODE csatorna mdok
	
	Lehetsget nyjt a Services opertoroknak, hogy brmelyik
	csatornn bellthassanak csatornamdokat. A paramterek
	megegyeznek a szabvnyos /MODE parancsval.
	
	Korltozva Services opertoroknak.

OPER_HELP_CLEARMODES
	Syntax: CLEARMODES csatorna [ALL]
	
	Trl minden logikai mdot (n,s,t,k,l, stb.) s bant
	a csatornrl.  Ha az ALL meg van adva, trli az sszes
	felhasznli mdot is (mint pl. +o vagy +v) a csatornrl.
	
	Korltozva Services opertoroknak.

OPER_HELP_CLEARCHAN
	Syntax: CLEARCHAN csatorna
	
	Elvtvolt minden felhasznlt a csatornrl (masskick).
	
	Korltozva Services opertoroknak.

OPER_HELP_KICK
	Syntax: KICK csatorna felhasznl indok
	
	Lehetsget nyjt az IRCopoknak, hogy brmilyen szobbl
	kirgjanak egy felhasznlt.
	A paramterek ugyanazok, mint a szabvnyos /KICK parancsnl.
	A kirgsi zenetben benne lesz a KIK parancsot kld
	IRCop nickneve;  pldul:
	
	*** SpamMan has been kicked off channel #my_channel by %S (Alcan (Flood))
	
	Korltozva Services opertoroknak.

OPER_HELP_AKILL
	Syntax: AKILL ADD [+lejrat] maszk indok
	        AKILL DEL maszk
	        AKILL LIST [maszk] [NOEXPIRE]
	        AKILL VIEW [maszk] [NOEXPIRE]
	        AKILL COUNT
	
	Lehetsget nyjt a Services opertoroknak, hogy karbantartsk az
	autokill (AKILL) listt.  Ha egy felhasznl hozzillik egy
	AKILL maszkhoz, s csatlakozni prbl, a Services kiad egy
	KILL parancsot erre a felhasznlra, s a tmogatott
	szervertpusokon arra utast minden szervereket, hogy adjon
	egy bant (K-line) a felhasznlra ill maszkra.
	
	AKILL ADD hozzadja a megadott felhasznl@gazdanv maszkot
	az AKILL listra a megadott indokkal (amit meg is kell adnod).
	AKILL DEL elvtoltja a megadott maszkot az AKILL listrl,
	ha jelen van.  AKILL LIST kijelzi a jelenlegi sszes AKILL-t;
	s ha egy tetszleges masz is meg van adva, a lista korltozva lesz
	azokra az AKILL-ekre, amelyeknek rillenek a megadott maszkra.
	AKILL VIEW egy sokkal rszletesebb verzija az AKILL LIST-nek,
	amely megmutatja, hogy ki vette fel az AKILL-t,
	mikor volt felvve s mikor jr le, ppgy, mint
	a felhasznl@gazdanv maszkot s indokot. Ha megadod
	a NOEXPIRE opcit, akkor csak azokat az AKILL-eket mutatja,
	amelyek nem jrnak le, s rillenek a felhasznl@gazdanv maszkra.
	AKILL COUNT csak visszakldi az AKILL-ek szmt az AKILL listn.
	
	Opcionlis, egy elvlsi id megadhat az AKILL ADD
	paranccsal. Az elvlsi id megelzi a user@host maszkot, s
	meghatrozhat mint egy egsz szm amit egy kvet ezek kzl d (nap),
	h (ra), vagy m (perc).  Kombincik (mint az 1h30m)
	most mr megengedettek. Ha nincs idegysg, az alaprtelmezs
	a nap (vagyis +30 nmagban azt jelenti, 30 nap).
	Soha le nem jr AKILL hozzadshoz hasznlj +0-t. Ha
	a hozzadand usermaszk + jellel kezddik, a lejrati idt meg
	kell adni, akkor is, ha ugyanaz, mint az alaprtelmezs.
	
	Az indoknak meg kell mondania, hogy a bejegyzs mirt lett felvve;
	attl fggen, hogy a Services hogyan konfigurlt, a felhasznlk
	is lthatjk a KILL zenetekben.
OPER_HELP_AKILL_OPERMAXEXPIRY
	
	Services adminisztrtorok korltozs nlkl hatrozhatnak meg
	lejrati idt, Services opertorok esetben a maximum %s.
OPER_HELP_AKILL_END
	
	Korlzotva Services opertoroknak.

OPER_HELP_AKILLCHAN
	Syntax: AKILLCHAN [KILL] [+elvls] csatorna indok
	
	Hozzad egy autokillt, mely minden felhasznlra vonatkozik,
	kivve az IRC opertorokra a megadott csatornn,
	opcionlisan (ha a KILL meg van adva) eltvoltja oket a
	hlzatbl.  Az indok trolva lesz minden autokill mellett,
	s meg fog jelenni a killelsi zenetben a Services
	konfigurcijtl fggen.  elvlst ugyanabban a
	formtumban kell megadni, mint az AKILL ADD parancsnl; ha
	nincs megadva, akkor az alaprtke: %s.
	
	Az Autokilleknl, melyeket ezzel a paranccsal adsz hozz,
	*@hostname formban lesz minden hosztnv, melyet hasznl
	valaki a csatornn.  Ha mr egy autokill szerepel az adott
	hosztnvre akkor az nem lesz mdostva; ennek okn lehet,
	hogy kevesebb autokill kerl hozzadsra, mint ahny user a
	szobban rintett.
	
	Limitlva Services opertoroknak.

OPER_HELP_EXCLUDE
	Syntax: EXCLUDE ADD [+lejrat] maszk indok
	        EXCLUDE DEL maszk
	        EXCLUDE LIST [maszk] [NOEXPIRE]
	        EXCLUDE VIEW [maszk] [NOEXPIRE]
	        EXCLUDE COUNT
	
	Lehetsget nyjt a Services opertoroknak, hogy karbantartsk
	az autokill kizr listt. Ha egy felhasznl rillik
	egy autokill kizr maszkra, s csatlakozik a hlzatra,
	a Services nem fog kiadni KILL parancsot arra a felhasznlra,
	mg akkor is, ha a felhasznl msklnben rillene az
	autokill maszkra. Ez hasznos lehet, ha szleskr autokill
	maszkjaid vannak, s mg mindig akarsz gazdaneveket vagy
	felhasznlkat, hogy egy ilyen maszkkal tudjanak csatlakozni.
	
	Az ADD, DEL, LIST, VIEW s COUNT alparancsok ugyangy mkdnek,
	mint az AKILL parancs alparancsai; nzd meg az AKILL helpjt
	tovbbi informcirt.
	
	Korltozva Services opertoroknak.

OPER_HELP_SGLINE
	Syntax: SGLINE ADD [+expiry] mask reason
	        SGLINE DEL mask
	        SGLINE LIST [mask] [NOEXPIRE]
	        SGLINE VIEW [mask] [NOEXPIRE]
	        SGLINE COUNT
	
	Engedlyezi a Services opertoroknak, hogy karbantartsk
	az SGLINE listt. Ha egy felhasznl "vals neve" rillik
	egy SGLINe maszkra, s megprbl csatlakozni, a Services
	kiad egy KILL parancsot arra a felhasznlra, s a tmogatott
	szervertpusokon arra utast minden szervert, hogy adjon
	egy ban-t (G-line) a felhasznlra ill maszkra.
	
	SGLINE ADD hozzadja a valsnvmaszkot az SGLINE listra
	a megadott indokkal (amit meg is kell adni).
	SGLINE DEL eltvoltja a megadott maszkot az SGLINE listrl,
	ha jelen van.
	SGLINE LIST kijelzi az sszes SGLINE bejegyzst; ha
	egy tetszleges maszk meg van adva, a lista korltozva lesz
	azokra a bejegyzsekre, amelyekre rillik a maszk.
	SGLINE VIEW sokkal rszletesebb verzija az SGLINE LIST-nek,
	s megmutatja, ki vette fel az SGLINE bejegyzseket, a dtumot,
	amikor felvettk, mikor hasznltk utoljra, s mikor jr le,
	ppgy, mint a maszkot s az indokot. Ha megadod a
	NOEXPIRE opcit, akkor csak azokat a bejegyzseket mutatja,
	amelyek soha nem jrnak le, s illenek a megadott maszkra.
	SGLINE COUNT csak visszakldi a bejegyzsek szmt
	az SGLINE listn.
	
	A maszk paramlter idzjelek kz tehet, s ktelez,
	ha a maszk szkzket tartalmaz; pldul:
	    /msg %S SGLINE ADD +0 "rossz nv" Ez egy rossz nv.
	
	Nem ktelez, de megadhat egy lejrati id is az SGLINE ADD
	parancshoz.  A lejrati id megelzi a flehasznl@gazdanv maszkot,
	egsz szmknt hatrozzuk meg, s kveti egy d (nap),
	h (ra) vagy m (perc) bet. Kombincik (mint pl. 1h30m)
	most mr megengedettek.  Ha nincs idegysg, az alaprtelmezs
	a nap (vagyis +30 nmagban azt jelenti, 30 nap). Ha szeretnl
	egy olyan bejegyzst, ami soha nem jr le, hasznlj +0-t.
	Ha a maszk + jellel kezddik, s nincs megadva lejrati id,
	a maszkot idzjelek kz kell tenni, ahogy fent le van rva.
	
	Az indok-nak meg kell mondania, hogy a bejegyzs mirt van felvve;
	attl fggen, hogy a Services hogyan konfigurlt, a felhasznlk
	is lthatjk a KILL zenetekben.
	
	Korltozva Services opertoroknak.

OPER_HELP_SQLINE
	Syntax: SQLINE ADD [+lejrat] maszk indok
	        SQLINE DEL maszk
	        SQLINE LIST [maszk] [NOEXPIRE]
	        SQLINE VIEW [maszk] [NOEXPIRE]
	        SQLINE COUNT
	
OPER_HELP_SQLINE_KILL
	Megengedi a Services opertoroknak, hogy mdostsk az SQLINE listt.
	Ha egy felhasznl, akinek a neve szerepel egy SQLINE maszkban megprbl
	csatlakozni, vagy a felhasznl megprblja tvltoztatni a
	nevt egy olyanra amely szerepel egy SQLINE maszkban, a Services ki fog osztani
	egy KILL-t ennek a felhasznlnak,a tmogatott szerver tpusok utastjk
	az sszes szervert, hogy adjanak egy tiltst (szerver Q-line) a maszknak
	amivel a felhasznl megegyezett.
OPER_HELP_SQLINE_NOKILL
	Megengedi a Services opertoroknak, hogy mdostsk az SQLINE listt.
	Ha egy felhasznl, akinek a neve szerepel egy SQLINE maszkban megprbl
	csatlakozni, vagy a felhasznl megprblja tvltoztatni a
	nevt egy olyanra amely szerepel egy SQLINE maszkban, a Services megvltoztatja a
	nicknevt "guest" nicknvre s kld egy zenetet a felhasznl
	IRC kliensnek, hogy vlasszon egy msik nicknevet.
	A tmogatott szerver tpusok utastjk az sszes szervert,
	hogy adjanak egy tiltst (szerver Q-line) a maszknak amivel a
	felhasznl megegyezett.
OPER_HELP_SQLINE_IGNOREOPERS
	
	Megjegyzs az IRC opertorokra nem hatnak az SQLINE maszkok.
OPER_HELP_SQLINE_END
	
	Az ADD, DEL, LIST s VIEW s COUNT alparancsok
	hozzadsra, trlse, megtekintsre (rvid vagy hossz verzi),
	vagy az SQLINE lista bejegyzseinek megszmolsra hasznlhatak.
	Lsd az SGLINE helpjt (/msg %S HELP SGLINE) a rszletekrt.
	
	Korltozva Services opertoroknak.

OPER_HELP_SZLINE
	Syntax: SZLINE ADD [+lejrat] maszk indok
	        SZLINE DEL maszk
	        SZLINE LIST [maszk] [NOEXPIRE]
	        SZLINE VIEW [maszk] [NOEXPIRE]
	        SZLINE COUNT
	
	Lehetsget nyjt a Services opertoroknak, hogy karbantartsk
	az SZLINE listt. Ha egy felhasznl, akinek az IP cme rillik
	egy SZLINE maszkra, s megprbl csatlakozni, a Services kiad
	egy KILL parancsot arra a felhasznlra, s a tmogatott
	szervertpusokon arra utast minden szervert, hogy adjon
	egy bant (server Z-line) a felhasznlra ill maszkra.
	
	Az ADD, DEL, LIST s VIEW s COUNT alparancsok
	hozzadsra, trlse, megtekintsre (rvid vagy hossz verzi),
	vagy az SZLINE lista bejegyzseinek megszmolsra hasznlhatak.
	Lsd az SGLINE helpjt (/msg %S HELP SGLINE) a rszletekrt.
	
	Korltozva Services opertoroknak.

OPER_HELP_EXCEPTION
	Syntax: EXCEPTION ADD [+lejrat] maszk korlt indok
	        EXCEPTION DEL {maszk | lista}
	        EXCEPTION MOVE szm jszm
	        EXCEPTION LIST [mask | lista]
	        EXCEPTION VIEW [mask | lista]
	
	Lehetsget nyjt a Services opertoroknak, hogy
	karbantartsk azon hostok listjt, amelyeknek meghatrozott
	session korltozsuk van, engedlyezve bizonyos gpeket,
	gymint a shell szervereket, hogy egyidben felvigyenek
	klienseket az alaprtelmezettnl nagyobb szmban. Amennyiben
	a gp elri a session korltot, minden csatlakozssal
	prblkoz kliens killelve lesz. Mieltt a kill megtrtnne,
	figyelmeztetst kapnak egy %S /NOTICE zeneten keresztl,
	ami, termszetesen, egy segtsgforrs a session korltozsrl.
	Az zenet tartalma egy konfigurcis bellts.
	
	EXCEPTION ADD hozzadja a megadott hostmaszkot a kivtellistba.
	Vedd figyelembe, hogy a nick!user@host s user@host maszkok
	rvnytelenek! Csak vals hostmaszkok, mint pl. box.host.dom
	s *.host.dom, megengedettek, mert a session korltozs
	maszkja nem vesz fel nicknevet vagy felhasznlnevet.
	A korlt legyen egy nullnl egyenl vagy nagyobb szm;
	ez hatrozza meg, hogy hny sessiont vihet magval a host
	egyidben (a nulla azt jelenti, hogy a hostnak korltlan
	szm sessionja lehet).
	
	Nem ktelez, de megadhat egy lejrati id az EXCEPTION ADD
	parancshoz. A lejrati id megelzi a hostmaszkot, egy
	szmknt hatrozzuk meg, s kveti egy d (nap),
	h (ra) vagy m (perc) bet.  Kombincik (mint pl. 1h30m)
	is megengedettek. Ha nincs megadva idegysg, az alaprtelmezs
	a nap (vagyis +30 nmagban azt jelenti, 30 nap). Ha szeretnl
	olyan bejegyzst, ami soha nem jr le, hasznlj +0-t. Ha
	a hozzadand maszk + jellel kezddik, egy lejrati idt is meg
	kell adni, mg akkor is, ha ugyanaz, mint ami az alaprtelmezs.
	
	EXCEPTION DEL eltvoltja a megadott maszkot vagy a megjellt sorszm
	szereplt a kivtel listrl (sorszm megtallhat: VIEW vagy LIST).
	
	EXCEPTION MOVE megvltoztatja a kivtelt szm rl j szm ra.
	Ha az jszm mr hasznlva van egy msik kivtelnl, akkor a
	szm meg lesz nvelve, hogy legyen helye.
	
	EXCEPTION LIST s EXCEPTION VIEW kijelez minden kivtelt;
	ha megadsz egy tetszleges maszkot, a listt korltozza
	azokra a kivtelekre, amelyekre rillik a maszk. A klnbsg
	a kt parancs kztt az, hogy az EXCEPTION VIEW sokkal
	rszletesebb, megjelenti a kivtelt felvev szemly nevt
	a session korltot, indokot, hostmaszkot s a lejrati dtumot
	s idt, gymint a kivtel legutols "hasznlati" idejt,
	pl. azon felhasznl legutols csatlakozsi idejt, amelyre
	rillik a maszk.
	
	Vedd figyelembe, hogy a csatlakoz kliens a rill kivtelek kzl
	mindig az elst hasznlja. Hatalmas kivtellistk s szleskr
	kivtelmaszkok lefokozhatjk a Services teljestmnyt.
	
	Korltozva Services opertoroknak.

OPER_HELP_SESSION
	Syntax: SESSION LIST hatrrtk
	        SESSION VIEW host
	
	Lehetsget nyjt a Services opertoroknak, hogy megtekintsk
	a session listt.
	
	SESSION LIST kilistzza azokat a hostokat, amelyeknek legalbb
	hatrrtk sessionjuk van. A hatrrtk legyen 1-nl nagyobb szm,
	hogy megelzze a nagy szm, egy session hostok kilistzst.
	
	SESSION VIEW megjelenti a meghatrozott host rszletes informciit,
	tartalmazva a jelenlegi session szmot s session korltot.
	A host rtke nem tartalmazhat maszkkaraktereket.
	
	Lsd az EXCEPTION helpjt tovbbi informcirt a session-
	korltozssal s azzal kapcsolatban, hogy hogyan llts be
	klnleges session korltokat bizonyos hostokra s csoportokra.
	
	Korltozva Services opertoroknak.

OPER_HELP_SU
	Syntax: SU jelsz
	
	Elrsi lehetsget nyjt olyan funkcikhoz, amelyek Services
	super-user jogokat ignyelnek. A jelsz ugyanaz, mint ami
	a SET SUPASS paranccsal lett belltva; vedd figyelembe, hogy
	ez a jelsz legyen belltva, mieltt hasznlod ezt a parancsot.
	A super-user jogok addig tartanak, amg ki nem lpsz
	az IRC-bl.
	
	FIGYELEM: Ha helytelen jelszt rsz be, a Services figyelmeztet
	krzenetet kld minden IRC opertornak.
	
	Korltozva Services adminisztrtoroknak.

OPER_HELP_SET
	Syntax: SET opci bellts
	
	Bellt klnbz Services opcikat. A jelenleg definilt
	opcinevek:
	    READONLY   Csak olvashat vagy rhat-olvashat mdba vlt
	    DEBUG      Bekapcsolja vagy kikapcsolja a hibakeres mdot
	    SUPASS     Belltja a jelszt a SU parancshoz (super-user)
	
	Korltozva Services adminisztrtoroknak; a SUPASS opcit csak
	a Services super-user llthatja be.

OPER_HELP_SET_READONLY
	Syntax: SET READONLY {ON | OFF}
	
	Bekapcsolja vagy kikapcsolja a csak olvashat mdot. Ha
	csak olvashat mdban van, a felhasznlk nem mdosthatjk
	a Services adatait, kivve a szobk s nicknevek hozzfrsi
	listjt, stb. IRC opertorok a megfelel Services jogokkal
	megvltoztathatjk a Services AKILL listjt s droppolhatnak
	vagy letilthatnak szobkat, de a vltozsok nem kerlnek mentsre,
	hacsak a csak olvashat mdot kikapcsoljk, mieltt a Services
	lell vagy jraindul.
	
	Ez az opci egyenrtk a -readonly parancssori opcival.

OPER_HELP_SET_DEBUG
	Syntax: SET DEBUG {ON | OFF | szm}
	
	Bekapcsolja vagy kikapcsolja a hibakeres mdot. Hibakeres
	mdban minden adatot, ami a Servicest rinti, ppgy, mint
	a tbbi hibakeres zenet szmt, belerja a naplfjlba. Ha
	a szm meg van adva, a hibakeres md akkor lesz kikapcsolva,
	ha a hibakeres szint szma a megadott szm-ra van belltva.
	
	Ez az opci egyenrtk a -debug parancssori opcival.

OPER_HELP_SET_SUPASS
	Syntax: SET SUPASS [jelsz]
	
	Belltja a SU parancshoz hasznlhat jelszt. A jelsznak
	belltva kell lennie, mieltt a SU parancsot els alkalommal
	hasznlod.  Ha nincs jelsz megadva, a SU parancs nem lesz
	hasznlhat.
	
	Ezt az opcit csak a Services super-user llthatja be.

OPER_HELP_JUPE
	Syntax: JUPE szerver [indok]
	
	Elmondja a Servicesnek, hogy jupitereljen egy szervert--vagyis,
	hogy ksztsen egy "lszervert", ami a Serviceshez csatlakozik,
	s megvdi annak a nvnek a vals szervert a csatlakozstl.
	A jupe etvolthat egy szabvnyos /SQUIT paranccsal. Ha megadsz
	indokot, bekerl a szerver informcis mezjbe; egybknt
	a szerver informcis mezje a "Jupitered by <nick>" szveget fogja
	tartalmazni, mutatva a szervert jupiterel felhasznl nicknevt.
	
	Korltozva Services adminisztrtoroknak.

OPER_HELP_RAW
	Syntax: RAW szveg
	
	Kld egy szvegsztringet kzvetlenl annak a szervernek,
	ahov a Services kapcsoldott. Ennek a parancsnak ersen
	korlzotott szm felhasznli vannak, mert tnkreteheti
	hlzatot, vagy kiakaszthatja a Servicest, ha helytelenl
	hasznljk. NE HASZNLD EZT A PARANCSOT, amg nem vagy
	abszolt biztos abban, hogy tutod, hogy mit csinlsz!
	
	Korltozva Services super-usereknek.

OPER_HELP_UPDATE
	Syntax: UPDATE [FORCE]
	
	Utastja a Services, hogy mentsen el minden adatbzis fjlt
	olyan, hamar, ahogy lehet a parancs kiadstl szmtva. Ha a
	FORCE opci is meg van adva a Services megprblja kinyitni
	az adatbzisokat mieltt vgrehajtan a mentst; ezzel
	kikszblhet a "databases are locked" hibazenet, az
	adatbzis mentsekor.
	
	Limitlva Services adminoknak.

OPER_HELP_QUIT
	Syntax: QUIT
	
	Arra kszteti a Servicest, hogy hajtsok vgre egy azonnali
	lelltst; az adatbzist nem menti el. Ezt a parancsot
	nem rdemes hasznlni, kivve, ha attl tartasz, hogy
	az adatbzisok memriabeli msolata megsrlt, s nem akarod
	elmenteni. Normlis lelltshoz hasznld a SHUTDOWN
	parancsot.
	
	Korltozva Services adminisztrtoroknak.

OPER_HELP_SHUTDOWN
	Syntax: SHUTDOWN
	
	Arra kszteti a Servicest, hogy mentsen el minden adatbzist,
	s lljon le.
	
	Korltozva Services adminisztrtoroknak.

OPER_HELP_RESTART
	Syntax: RESTART
	
	Arra kszteti a Servicest, hogy mentsen el minden adatbzist,
	s induljon jra (pl. kilpjen s azonnal jrafuttasa
	a futtathat fjlt).
	
	Korltozva Services adminisztrtoroknak.

OPER_HELP_REHASH
	Syntax: REHASH
	
	Arra kszteti a Servicest, hogy jraolvassa a konfigurcis
	s jrafrisstse az aktv belltsokat. Nhny bellts,
	mint pl. a RemoteServer (ami belltja az IRC szerver
	gazdanevt, ahov csatlakozik), nem vltoztathat meg
	REHASH-sal, s csak akkor lp letbe, ha a Services jraindul;
	ezekben az esetekben egy zenetet r a naplfjlba, s errl
	kld egy figyelmeztetst is.
	
	Ha LoadModule sorok lettek hozzadva vagy eltvoltva
	a f Services konfigurcis fjlbl (%s),
	a modulokat betlti vagy kiiktatja, ha szksges. Azokat
	a modulokat, amelyeknek mr nincsenek LoadModule soraik,
	sorrendben visszafel iktatja ki; aztn a maradk modul
	jratltse utn az j modulokat betlti abban a sorrendben,
	ahogy a konfigurcis fjlban szerepel. Ha hiba trtnik
	brmelyik lpsben, az jratlts megszakad.
	
	Vedd figyelembe, hogy a modulfggsgek kvetkeztpben nhny
	modul nem tvolthat el vagy vltozhat meg REHASH-on keresztl;
	ilyen esetben jra kell indtani a Servicest, hogy a vltozsok
	rvnybe lpjenek.
	
	Korltozva Services adminisztrtoroknak.

OPER_HELP_KILLCLONES
	Syntax: KILLCLONES nick
	
	Killel minden olyan felhasznlt, akinek ugyanaz a gazdaneve, mint
	ami a megadott nick-. Felvesz egy ideiglenes AKILL-t, *@host
	formban, hogy megelzze a tmad kliensek azonnali
	jracsatlakozst. Egy WALLOPS zenetet is kldd, amelyben jelzi,
	ki hasznlta a parancsot, milyen felhasznlra hatott, s hny
	felhasznlt killelt. Ez a parancs hasznos lehet szmos klnok
	hlzatrl val eltvoltsra.
	
	Korltozva Services opertoroknak.


###########################################################################
#
# StatServ help zenetek
#
###########################################################################

STAT_HELP
	%S statisztikai informcikat nyjt az IRC hlzatrl,
	a szervereirl s felhasznlirl.
	/msg %S HELP COMMANDS megmutatja %S
	parancsainak listjt; a parancsokrl tovbbi
	informcirt rd be: /msg %S HELP command.

STAT_HELP_COMMANDS
	%S az albbi parancsokat nyjtja neked:
	
	    SERVERS     Statisztikk a szerverekrl
	    USERS       Statisztikk a felhasznlkrl

STAT_HELP_SERVERS
	Syntax: SERVERS STATS
	        SERVERS LIST [maszk]
	        SERVERS VIEW [maszk] [ONLINE | OFFLINE]
	
	Statisztikt jelent meg a hlzat szervereivel kapcsolatban.
	
	SERVERS STATS megjelent egy rvid sszegzst a Services
	ltal jelenleg lthat (online) s nem lthat (offline)
	szerverekrl.
	SERVERS LIST megjelent egy listt az online szerverekrl,
	s a jelenlegi statisztikjukrl.
	SERVERS VIEW megjelent egy listt az online s offline
	szerverekrl rszletesebb statisztikval. Az ONLINE s
	OFFLINE opcik egyenknt annyit tesznek, hogy csak az
	online vagy offline szervereket jelenti meg.
	
	Hasznld a maszk opcit, hogy korltozd, mely szerverek
	statisztikjt szeretnd ltni.

STAT_HELP_USERS
	Syntax: USERS STATS
	
	Rszletes statisztikt nyjt a hlzat felhasznlival
	kapcsolatban.

STAT_OPER_HELP_SERVERS
	Syntax: SERVERS STATS
	        SERVERS LIST [maszk]
	        SERVERS VIEW [maszk] [ONLINE | OFFLINE]
	        SERVERS DELETE szerver
	        SERVERS COPY szerver jnv
	        SERVERS RENAME szerver jnv
	
	Rszletes statisztikt nyjt a hlzat szervereivel
	kapcsolatban.
	
	SERVERS STATS megjelent egy rvid sszegzst a Services
	ltal jelenleg lthat (online) s nem lthat (offline)
	szerverekrl.
	SERVERS LIST megjelent egy listt az online szerverekrl
	s a jelenlegi statisztikjukrl.
	SERVERS VIEW megjelent egy listt az online s offline
	szerverekrl rszletes statisztikval. Az ONLINE s OFFLINE
	opcik egyenknt annyit tesznek, hogy csak az online vagy
	offline szervereket jelenti meg.
	
	Hasznld a maszk opcit, hogy korltozd, mely szerverek
	statisztikjt szeretnd ltni.
	
	DELETE trli a megadott szerver statisztikjt.
	COPY duplzza a megadott szerver statisztikjt.
	RENAME tnevezi a megadott szerver statisztikjt.
	Ez a hrom parancs korltozva Services adminisztrtoroknak.
