/* News data structures and constants.
 *
 * IRC Services is copyright (c) 1996-2004 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef NEWS_H
#define NEWS_H

/*************************************************************************/

typedef struct newsitem_ NewsItem;
struct newsitem_ {
    NewsItem *next, *prev;
    int modified;
    int locked;

    int16 type;
    int32 num;		/* Numbering is separate for login and oper news */
    char *text;
    char who[NICKMAX];
    time_t time;
};

#define MAX_NEWS	32767

/* Maximum number of news items to display */
#define NEWS_DISPCOUNT	3

/*************************************************************************/

/* Constants for news types. */

#define NEWS_INVALID	-1	/* Used as placeholder */
#define NEWS_LOGON	0
#define NEWS_OPER	1

/*************************************************************************/

E NewsItem *add_news(NewsItem *news);
E void del_news(NewsItem *news);
E NewsItem *get_news(int16 type, int32 num);
E void put_news(NewsItem *news);
E NewsItem *first_news(void);
E NewsItem *next_news(void);
E int news_count(void);
E int open_news_db(const char *dbname);
E int sync_news_db(const char *dbname);
E int close_news_db(const char *dbname);

/*************************************************************************/

#endif  /* NEWS_H */
