/* Channel protect/founder (+a/+q) related functions.
 *
 * IRC Services is copyright (c) 1996-2004 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "services.h"
#include "modules.h"
#include "language.h"
#include "modules/chanserv/chanserv.h"

#include "chanprot.h"

/*************************************************************************/

static Module *module;

static int old_HELP_SOP_MID1 = -1;

/*************************************************************************/

int init_chanprot(Module *module_)
{
    module = module_;
    protocol_features |= PF_CHANPROT;
    old_HELP_SOP_MID1 =
	setstring(CHAN_HELP_SOP_MID1, CHAN_HELP_SOP_MID1_CHANPROT);
    return 1;
}

/*************************************************************************/

void exit_chanprot(void)
{
    if (old_HELP_SOP_MID1 >= 0)
	setstring(CHAN_HELP_SOP_MID1, old_HELP_SOP_MID1);
    old_HELP_SOP_MID1 = -1;
}

/*************************************************************************/
