/* Code for servers supporting the ircd.dal SVSNICK command.
 *
 * IRC Services is copyright (c) 1996-2004 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "services.h"
#include "language.h"
#include "modules.h"
#include "modules/nickserv/nickserv.h"

#include "svsnick.h"

/*************************************************************************/

static Module *module;

/*************************************************************************/
/*************************************************************************/

/* Send a SVSNICK to change a client's nickname. */

static void do_send_nickchange_remote(const char *nick, const char *newnick)
{
    send_cmd(ServerName, "SVSNICK %s %s :%ld", nick, newnick,
	     (long)time(NULL));
}

/*************************************************************************/
/*************************************************************************/

int init_svsnick(Module *module_)
{
    module = module_;

    send_nickchange_remote = do_send_nickchange_remote;
    protocol_features |= PF_CHANGENICK;

    return 1;
}

/*************************************************************************/

void exit_svsnick(void)
{
    protocol_features &= ~PF_CHANGENICK;
    send_nickchange_remote = NULL;
}

/*************************************************************************/
