/* Routines to allocate and free SuspendInfo structures.
 *
 * IRC Services is copyright (c) 1996-2004 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "services.h"

/*************************************************************************/

/* Allocate a SuspendInfo structure, and fill it in with the data provided.
 * The structure will be allocated with smalloc(); the `suspended' field is
 * set to the current time.  Always succeeds.
 */

SuspendInfo *new_suspendinfo(const char *who, char *reason, time_t expires)
{
    SuspendInfo *si = smalloc(sizeof(*si));
    strscpy(si->who, who, sizeof(si->who));
    si->reason = reason;
    si->suspended = time(NULL);
    si->expires = expires;
    return si;
}

/*************************************************************************/

/* Free a SuspendInfo structure, including the reason string. */

void free_suspendinfo(SuspendInfo *si)
{
    if (si) {
	free(si->reason);
	free(si);
    }
}

/*************************************************************************/
